/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.repository;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.RepositoryUtil;
import kd.hrmp.hrpi.business.helper.HRPIBusinessDataServiceHelper;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.HRPIPageConstants;
import kd.hrmp.hrpi.common.HRPIValueConstants;

public class HRPIEmployeeRepository {
    private static final Log LOGGER = LogFactory.getLog(HRPIEmployeeRepository.class);
    public static final HRBaseServiceHelper employeeServiceHelper = new HRBaseServiceHelper("hrpi_employee");
    public static final HRBaseServiceHelper empentrelServiceHelper = new HRBaseServiceHelper("hrpi_empentrel");
    protected static final HRBaseServiceHelper empposorgrellServiceHelper = new HRBaseServiceHelper("hrpi_empposorgrel");
    protected static final HRBaseServiceHelper laborRecordServiceHelper = new HRBaseServiceHelper("hrpi_laborrelrecord");
    protected static final HRBaseServiceHelper appointRemoveRelServiceHelper = new HRBaseServiceHelper("hrpi_appointremoverel");

    public static DynamicObject[] getLaborRecordByEmpId(List<Long> empIds) {
        String laborProp = DynamicTransformUtil.getDynamicPropString(laborRecordServiceHelper.getEntityName());
        return laborRecordServiceHelper.query(laborProp, new QFilter[]{new QFilter("employee", "in", empIds)});
    }

    public static DynamicObject[] getLabRecordLawByEmpId(List<Long> empIds) {
        QFilter empIdFilter = new QFilter("employee", "in", empIds);
        QFilter zeroFilter = new QFilter("lawentity.id", "=", (Object)0);
        return laborRecordServiceHelper.query("person,org,startdate,lawentity,employee.laborrelstatus", new QFilter[]{empIdFilter, zeroFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObjectCollection isExistEmployee(List<Object> checkList, String checkProp) {
        QFilter custFilter = new QFilter(checkProp, "in", checkList);
        return employeeServiceHelper.queryOriginalCollection(checkProp, new QFilter[]{custFilter, QFilterUtil.getStatusFilters(), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish(), new QFilter("laborrelstatus.labrelstatusprd.id", "=", (Object)1010L)});
    }

    public static DynamicObject[] getOnBoardEmployee(Set<Long> personIds) {
        QFilter qFilter = new QFilter("laborrelstatus.labrelstatusprd", "=", (Object)1010L);
        QFilter personFilter = new QFilter("person.id", "in", personIds);
        return employeeServiceHelper.query("person.id", new QFilter[]{personFilter, qFilter, QFilterUtil.getStatusFilters(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObjectCollection getPidByEmployeeIds(List<Long> employeeIds) {
        QFilter custFilter = new QFilter("id", "in", employeeIds);
        return employeeServiceHelper.queryOriginalCollection("person.personindexid,person.id,id", new QFilter[]{custFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObjectCollection getOnBoardEmployeeByPid(List<Long> pidList) {
        QFilter qFilter = new QFilter("laborrelstatus.labrelstatusprd", "=", (Object)HRPIValueConstants.LABRELSTATUSPRD_ING);
        QFilter custFilter = new QFilter("person.personindexid", "in", pidList);
        return employeeServiceHelper.queryOriginalCollection("id,person.personindexid", new QFilter[]{qFilter, custFilter, QFilterUtil.getStatusFilters(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listEmployeesByNombers(List<String> numbers) {
        QFilter personFilter = new QFilter("empnumber", "in", numbers);
        return employeeServiceHelper.queryOriginalArray(DynamicTransformUtil.getDynamicPropString(employeeServiceHelper.getEntityName()), new QFilter[]{personFilter, QFilterUtil.getStatusFilters(), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish(), QFilterUtil.isLatestRecord()});
    }

    public static DynamicObject[] listEmployeesByLikeNumbers(String selectProperties, Collection<String> numbers) {
        QFilter numberFilter = new QFilter("empnumber", "in", numbers);
        for (String number : numbers) {
            if (Objects.isNull(numberFilter)) {
                numberFilter = new QFilter("empnumber", "like", (Object)(number + "-R%"));
                continue;
            }
            numberFilter.or(new QFilter("empnumber", "like", (Object)(number + "-R%")));
        }
        return employeeServiceHelper.query(selectProperties, new QFilter[]{numberFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getDataStatusFilter()});
    }

    public static DynamicObject[] listAllCurEmployees() {
        return employeeServiceHelper.query("id", new QFilter[]{QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listInProgressEmployeesByLikeNum(String number) {
        QFilter statusFilter = new QFilter("laborrelstatus.labrelstatusprd.id", "=", (Object)1010L);
        String likeStr = "%" + number + "%";
        QFilter numberFilter = new QFilter("empnumber", "like", (Object)likeStr);
        return employeeServiceHelper.queryOriginalArray("id", new QFilter[]{statusFilter, numberFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter()});
    }

    public static DynamicObjectCollection listEmployeesByNumbers(String selectProperties, Collection<String> numbers) {
        QFilter numberFilter = new QFilter("empnumber", "in", numbers);
        return employeeServiceHelper.queryOriginalCollection(selectProperties, new QFilter[]{numberFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter()});
    }

    public static DynamicObject[] listEmpEntByNumbers(String selectProperties, Collection<String> numbers) {
        QFilter numberFilter = new QFilter("empnumber", "in", numbers);
        return empentrelServiceHelper.query(selectProperties, new QFilter[]{numberFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish(), QFilterUtil.getStatusFilters(), QFilterUtil.isLatestRecord()});
    }

    public static DynamicObject[] listEmployeeByNumbers(String selectProperties, Collection<String> numbers) {
        QFilter numberFilter = new QFilter("empnumber", "in", numbers);
        return employeeServiceHelper.query(selectProperties, new QFilter[]{numberFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish(), QFilterUtil.getStatusFilters(), QFilterUtil.isLatestRecord()});
    }

    public static DynamicObject getEmployee(Long employeeId) {
        QFilter qf = new QFilter("id", "=", (Object)employeeId);
        String dynamicPropString = DynamicTransformUtil.getDynamicPropString(employeeServiceHelper.getEntityName());
        return employeeServiceHelper.queryOne(dynamicPropString, new QFilter[]{qf, QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listEmployeeIds(List<Long> employeeIds) {
        return HRPIEmployeeRepository.listEmployeeIds(employeeIds, DynamicTransformUtil.getDynamicPropString(employeeServiceHelper.getEntityName()));
    }

    public static DynamicObject[] listEmployeeByPersonIds(String selectProps, List<Long> personIds) {
        QFilter qFilter = new QFilter("person", "in", personIds);
        if (StringUtils.isEmpty((Object)selectProps)) {
            return employeeServiceHelper.queryOriginalArray(selectProps, new QFilter[]{qFilter, QFilterUtil.getCurrentAndHisEffectFilter()});
        }
        return employeeServiceHelper.queryOriginalArray(DynamicTransformUtil.getDynamicPropString(employeeServiceHelper.getEntityName()), new QFilter[]{qFilter, QFilterUtil.getCurrentAndHisEffectFilter()});
    }

    public static DynamicObject[] listEmpByPersonIds(String selectProps, List<Long> personIds) {
        QFilter qFilter = new QFilter("person", "in", personIds);
        return HRStringUtils.isEmpty((String)selectProps) ? employeeServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter}) : employeeServiceHelper.query(selectProps, new QFilter[]{qFilter, QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf()});
    }

    public static DynamicObject[] listEmpEntByPersonIds(String selectProps, List<Long> personIds) {
        QFilter qFilter = new QFilter("person", "in", personIds);
        if (StringUtils.isEmpty((Object)selectProps)) {
            return empentrelServiceHelper.queryOriginalArray(selectProps, new QFilter[]{qFilter, QFilterUtil.getCurrentAndHisEffectFilter()});
        }
        return empentrelServiceHelper.queryOriginalArray(DynamicTransformUtil.getDynamicPropString(empentrelServiceHelper.getEntityName()), new QFilter[]{qFilter, QFilterUtil.getCurrentAndHisEffectFilter()});
    }

    public static DynamicObject[] listEmployeeByNumber(String selectProps, List<String> empNumbers) {
        QFilter qFilter = new QFilter("empnumber", "in", empNumbers);
        if (StringUtils.isEmpty((Object)selectProps)) {
            return employeeServiceHelper.queryOriginalArray(selectProps, new QFilter[]{qFilter, QFilterUtil.getCurrentAndHisEffectFilter()});
        }
        return employeeServiceHelper.queryOriginalArray(DynamicTransformUtil.getDynamicPropString(employeeServiceHelper.getEntityName()), new QFilter[]{qFilter, QFilterUtil.getCurrentAndHisEffectFilter()});
    }

    public static DynamicObject[] listEmployeeIds(List<Long> employeeIds, String selectProperties) {
        QFilter qFilter = new QFilter("id", "in", employeeIds);
        return employeeServiceHelper.queryOriginalArray(selectProperties, new QFilter[]{qFilter, QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] queryEmployeeByIds(List<Long> employeeIds, String selectProperties) {
        QFilter qFilter = new QFilter("boid", "in", employeeIds);
        return employeeServiceHelper.query(selectProperties, new QFilter[]{qFilter, QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] queryListEmployeeIds(List<Long> employeeIds, String selectProperties) {
        QFilter qFilter = new QFilter("id", "in", employeeIds);
        return employeeServiceHelper.query(selectProperties, new QFilter[]{qFilter});
    }

    public static DynamicObject getEmpentrel(Long employeeId) {
        String dynamicPropString = DynamicTransformUtil.getDynamicPropString(empentrelServiceHelper.getEntityName());
        return empentrelServiceHelper.queryOne(dynamicPropString, new QFilter[]{HRPIEmployeeRepository.getFilter(employeeId), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static int countEmpentrelByByTypeclsAndStatusCls(List<Long> labreltypeclsList, List<Long> labrelstatusclsList) {
        QFilter labreltypeclsFilter = QFilterUtil.getLaborreltypeByClsList("laborreltype", labreltypeclsList);
        QFilter labrelstatusclsFilter = QFilterUtil.getLaborrelstatusByClsList("laborrelstatus", labrelstatusclsList);
        return empentrelServiceHelper.count("hrpi_empentrel", new QFilter[]{labreltypeclsFilter, labrelstatusclsFilter, QFilterUtil.getStatusFilters(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listEmpentrelByByTypeclsAndStatusCls(List<Long> labreltypeclsList, List<Long> labrelstatusclsList, String selectProperties, int start, int limit) {
        QFilter labreltypeclsFilter = QFilterUtil.getLaborreltypeByClsList("laborreltype", labreltypeclsList);
        QFilter labrelstatusclsFilter = QFilterUtil.getLaborrelstatusByClsList("laborrelstatus", labrelstatusclsList);
        return HRPIBusinessDataServiceHelper.load("hrpi_empentrel", selectProperties, new QFilter[]{labreltypeclsFilter, labrelstatusclsFilter, QFilterUtil.getStatusFilters(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()}, "id", start, limit, Boolean.TRUE);
    }

    public static DynamicObject[] listEmpentrelByByTypeclsAndStatusCls(List<Long> labreltypeclsList, List<Long> labrelstatusclsList, String selectProperties, long id, int top) {
        QFilter labreltypeclsFilter = QFilterUtil.getLaborreltypeByClsList("laborreltype", labreltypeclsList);
        QFilter labrelstatusclsFilter = QFilterUtil.getLaborrelstatusByClsList("laborrelstatus", labrelstatusclsList);
        QFilter idFilter = new QFilter("id", ">", (Object)id);
        QFilter[] qFilters = new QFilter[]{idFilter, labreltypeclsFilter, labrelstatusclsFilter, QFilterUtil.getStatusFilters(), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()};
        return HRPIBusinessDataServiceHelper.queryOriginal("hrpi_empentrel", selectProperties, qFilters, "id", top);
    }

    public static DynamicObject[] listFieldsEmployeeAttachs(List<Long> employeeIds, String selectFields, String attachEntityName) {
        HRPIEmployeeRepository.checkEmployee(attachEntityName);
        QFilter qFilter = new QFilter("employee.id", "in", employeeIds);
        return RepositoryUtil.getOrigDynamicObjectCollection(selectFields, null, attachEntityName, HRPIEmployeeRepository.getFilters(attachEntityName, qFilter, null), null);
    }

    public static DynamicObject[] listEmployeeAttachs(Long employeeId, String attachEntityName) {
        return HRPIEmployeeRepository.listBatchEmployeeAttachs(Collections.singletonList(employeeId), null, attachEntityName);
    }

    public static DynamicObject[] listBatchEmployeeAttachs(List<Long> employeeIds, QFilter custQf, String attachEntityName) {
        HashSet<String> ignore = new HashSet<String>();
        ignore.add("issingle");
        ignore.add("businessstatus");
        QFilter qFilter = new QFilter("employee.id", "in", employeeIds);
        HRPIEmployeeRepository.checkEmployee(attachEntityName);
        return RepositoryUtil.getDynamicObjectCollection(ignore, attachEntityName, HRPIEmployeeRepository.getFilters(attachEntityName, qFilter, custQf));
    }

    private static void checkEmployee(String attachEntityName) {
        QFilter entityFilter = new QFilter("entity", "=", (Object)attachEntityName);
        Map entityCfMap = BusinessDataServiceHelper.loadFromCache((String)"hrpi_personentityconf", (String)"classify", (QFilter[])new QFilter[]{entityFilter});
        if (CollectionUtils.isEmpty((Map)entityCfMap) || !"empattached".equals(((DynamicObject)entityCfMap.values().stream().findFirst().get()).get("classify"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u4f01\u4e1a\u4eba\u9644\u8868\u7f16\u7801\u3002", (String)"HRPIEmployeeRepository_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    private static QFilter[] getFilters(String attachEntityName, QFilter qFilter, QFilter custQf) {
        MainEntityType dataEntityType;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(qFilter);
        filterList.add(QFilterUtil.getCurrentQf());
        filterList.add(QFilterUtil.getDataStatusFilter());
        filterList.add(QFilterUtil.getInitStatusFinish());
        if (null != custQf) {
            filterList.add(custQf);
        }
        if ((dataEntityType = MetadataServiceHelper.getDataEntityType((String)attachEntityName)).findProperty("bred") != null && dataEntityType.findProperty("bsed") != null) {
            filterList.add(QFilterUtil.getStatusFilters());
        }
        return filterList.toArray(new QFilter[0]);
    }

    public static DynamicObject[] listBatchEmployeeAttachsByPerson(List<Long> personIds, QFilter custQf, String attachEntityName) {
        HashSet<String> ignore = new HashSet<String>();
        ignore.add("issingle");
        ignore.add("businessstatus");
        QFilter qFilter = new QFilter("person.id", "in", personIds).and(QFilterUtil.empLatestRecord());
        HRPIEmployeeRepository.checkEmployee(attachEntityName);
        return RepositoryUtil.getDynamicObjectCollection(ignore, attachEntityName, HRPIEmployeeRepository.getFilters(attachEntityName, qFilter, custQf));
    }

    public static DynamicObject[] listEmpJobRels(Collection<Long> employeeIds) {
        HRBaseServiceHelper jobServiceHelper = new HRBaseServiceHelper("hrpi_empjobrel");
        QFilter qFilter = new QFilter("employee.id", "in", employeeIds);
        return jobServiceHelper.queryOriginalArray("job.id,person.id,employee.id,position.id,joblevel.name,jobgrade.name,issingle", new QFilter[]{qFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getStatusFilters(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listEmployeeIds(Set<Long> employeeIds) {
        QFilter qFilter = new QFilter("id", "in", employeeIds);
        return employeeServiceHelper.queryOriginalArray("id,mid,laborrelstatus.id", new QFilter[]{qFilter, QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listEmployeeById(Set<Long> employeeIds) {
        QFilter qFilter = new QFilter("id", "in", employeeIds);
        return employeeServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter, QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listEmployeeIds(Collection<Long> employeeIds, String selectProps) {
        QFilter boIdFilter = new QFilter("boid", "in", employeeIds);
        return employeeServiceHelper.query(selectProps, new QFilter[]{boIdFilter, QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listEmployeeIdsCurVersion(Collection<Long> employeeIds, String selectProps) {
        QFilter qFilter = new QFilter("id", "in", employeeIds);
        return employeeServiceHelper.query(selectProps, new QFilter[]{qFilter, QFilterUtil.getInitStatusFinish(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf()});
    }

    public static DynamicObject[] getLabRelRecordByEmployeeIds(List<Long> employeeIds, List<Long> orgIds, Boolean isNeedStatusFilter) {
        QFilter qf = new QFilter("employee", "in", employeeIds);
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        HRBaseServiceHelper laborServiceHelper = new HRBaseServiceHelper("hrpi_laborrelrecord");
        if (isNeedStatusFilter.booleanValue()) {
            return laborServiceHelper.queryOriginalArray("id,employee.id,org.id,boid,bsed,bsled,startdate,enddate", new QFilter[]{qf, orgFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), qf, QFilterUtil.getStatusFilters(), QFilterUtil.getInitStatusFinish()});
        }
        return laborServiceHelper.queryOriginalArray("id,employee.id,org.id,boid,bsed,bsled,startdate,enddate", new QFilter[]{qf, orgFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), qf, QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] getLabRelRecordByPersonIds(Set<Long> personIds, Set<Long> orgIds) {
        QFilter qf = new QFilter("person", "in", personIds);
        if (!CollectionUtils.isEmpty(orgIds)) {
            QFilter orgFilter = new QFilter("org", "in", orgIds);
            qf.and(orgFilter);
        }
        HRBaseServiceHelper laborServiceHelper = new HRBaseServiceHelper("hrpi_laborrelrecord");
        return laborServiceHelper.query("id,person,employee,lawentity,org,startdate,enddate,sysenddate,boid,bsled,bsed,businessstatus,creator,createtime,modifier,modifytime,description", new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish(), QFilterUtil.getDataStatusFilter(), QFilterUtil.empLatestRecord()});
    }

    public static DynamicObjectCollection getOnBoardEmptrel(List<Object> numberList) {
        QFilter qFilter = new QFilter("laborrelstatus.labrelstatusprd", "=", (Object)1010L);
        QFilter custFilter = new QFilter("empnumber", "in", numberList);
        return empentrelServiceHelper.queryOriginalCollection("id,person,empnumber,employee,laborreltype", new QFilter[]{qFilter, custFilter, QFilterUtil.getStatusFilters(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] getQuitEmptrel(Set<Long> personIds, String selectProps) {
        QFilter qFilter = new QFilter("laborrelstatus.labrelstatusprd", "=", (Object)HRPIValueConstants.LABRELSTATUSPRD_END);
        QFilter custFilter = new QFilter("person", "in", personIds);
        return empentrelServiceHelper.query(selectProps, new QFilter[]{qFilter, custFilter, QFilterUtil.getStatusFilters(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()});
    }

    public static Map<String, Map<Long, DynamicObject>> loadEmployeeInfo(Set<Long> employeeIds) {
        HashMap<String, Map<Long, DynamicObject>> result = new HashMap<String, Map<Long, DynamicObject>>(employeeIds.size());
        Object[] employeeDyArray = employeeServiceHelper.loadDynamicObjectArray(employeeIds.toArray(new Object[0]));
        if (!HRArrayUtils.isEmpty((Object[])employeeDyArray)) {
            RepositoryUtil.wrapResultFromSources(result, (DynamicObject[])employeeDyArray, "hrpi_employee", "id");
            QFilter idQf = new QFilter("employee", "in", employeeIds);
            QFilter[] qFilters = new QFilter[]{idQf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()};
            HRPIEmployeeRepository.loadEmployeeDys(qFilters, result);
        }
        return result;
    }

    private static void loadEmployeeDys(QFilter[] qFilters, Map<String, Map<Long, DynamicObject>> result) {
        HRPIPageConstants.EMPLOYEEUPENTITYS.forEach(personEntity -> {
            HRBaseServiceHelper serviceHelper;
            Object[] dynamicObjects;
            if (!personEntity.equals("hrpi_employee") && !HRArrayUtils.isEmpty((Object[])(dynamicObjects = (serviceHelper = new HRBaseServiceHelper(personEntity)).loadDynamicObjectArray(qFilters)))) {
                RepositoryUtil.wrapResultFromSources(result, (DynamicObject[])dynamicObjects, personEntity, "employee_id");
            }
        });
    }

    private static QFilter getFilter(Long employeeId) {
        return new QFilter("employee.id", "=", (Object)employeeId);
    }

    public static DynamicObject[] batchQueryEmployee(long id, int batchCount) {
        HRBaseServiceHelper employeeServiceHelper = new HRBaseServiceHelper("hrpi_employee");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", ">", (Object)id), QFilterUtil.getCurrentQf(), QFilterUtil.getStatusFilters(), QFilterUtil.getInitStatusFinish()};
        DynamicObject[] ids = employeeServiceHelper.query("id", qFilters, "id", batchCount);
        Object[] idList = Arrays.stream(ids).map(arg -> arg.getLong("id")).toArray();
        return employeeServiceHelper.loadDynamicObjectArray(idList);
    }

    public static DynamicObject[] getEmpPos(Date queryDate, List<Long> positionIds) {
        QFilter positionFilter = new QFilter("position", "in", positionIds);
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)queryDate).and("enddate", ">=", (Object)queryDate);
        String empPosProp = DynamicTransformUtil.getDynamicPropString(empposorgrellServiceHelper.getEntityName());
        QFilter commonFilter = QFilterUtil.getDataStatusFilter().and(QFilterUtil.getCurrentQf()).and(QFilterUtil.getInitStatusFinish());
        DynamicObject[] empPosDy = empposorgrellServiceHelper.query(empPosProp, new QFilter[]{positionFilter, dateFilter, commonFilter});
        return empPosDy;
    }

    public static DynamicObject[] getEmpEnt(List<Object> personIds) {
        String empEntProp = DynamicTransformUtil.getDynamicPropString(empentrelServiceHelper.getEntityName());
        return empentrelServiceHelper.query(empEntProp, new QFilter[]{new QFilter("person", "in", personIds), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] getLaborRecord(List<Long> PkValues) {
        String laborProp = DynamicTransformUtil.getDynamicPropString(laborRecordServiceHelper.getEntityName());
        return laborRecordServiceHelper.query(laborProp, new QFilter[]{new QFilter("id", "in", PkValues), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject getLaborRecord(Long employeeId, Long org) {
        QFilter empFilter = new QFilter("id", "=", (Object)employeeId);
        QFilter orgFilter = new QFilter("org", "=", (Object)org);
        return laborRecordServiceHelper.queryOne(new QFilter[]{empFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), orgFilter, QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] getEmpEntByBoId(List<Long> boIdList) {
        String empEntProp = DynamicTransformUtil.getDynamicPropString(empentrelServiceHelper.getEntityName());
        QFilter qFilter = new QFilter("boid", "in", boIdList);
        return empentrelServiceHelper.query(empEntProp + ",sourcevid", new QFilter[]{qFilter, QFilterUtil.getCurrentQf()});
    }

    public static boolean existByInitBatch(Long batchNumber) {
        return empentrelServiceHelper.isExists(new QFilter("initbatch", "=", (Object)batchNumber));
    }

    public static DynamicObject queryAppontRemoveRelDyByFilter(QFilter[] qFilters) {
        return appointRemoveRelServiceHelper.loadDynamicObject(qFilters);
    }

    public static List<Map<String, Object>> queryPersonUserRelAndEmpBySql(long id, int top, Map<Object, DynamicObject> labStatusMap) {
        String sql = "SELECT top " + top + ',' + 0 + " c.fpersonindexid,b.fpersonid,b.fid,b.fmid,b.flaborrelstatus,b.fempnumber from t_hrpi_employee b left join t_hrpi_personuserrel a on b.fpersonid = a.fpersonid inner join t_hrpi_person c on c.fid=b.fpersonid where b.fiscurrentversion='1' and b.finitstatus='2'  and c.fiscurrentversion ='1' and c.finitstatus='2' and a.fid is null and b.fid > " + id + " ORDER BY b.fid";
        return (List)DB.query((DBRoute)new DBRoute("hr"), (String)sql, null, resultSet -> {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)top);
            while (resultSet.next()) {
                HashMap<String, Object> tmpMap = new HashMap<String, Object>(16);
                long personId = resultSet.getLong("fpersonid");
                long pid = resultSet.getLong("fpersonindexid");
                long employeeId = resultSet.getLong("fid");
                long mid = resultSet.getLong("fmid");
                long prdId = resultSet.getLong("flaborrelstatus");
                String number = resultSet.getString("fempnumber");
                tmpMap.put("person", personId);
                tmpMap.put("personindexid", pid);
                tmpMap.put("employee", employeeId);
                tmpMap.put("mid", mid);
                DynamicObject dynamicObject = (DynamicObject)labStatusMap.get(prdId);
                if (dynamicObject != null) {
                    tmpMap.put("labrelstatusprd", "1");
                } else {
                    tmpMap.put("labrelstatusprd", "0");
                }
                tmpMap.put("number", number);
                resultList.add(tmpMap);
            }
            return resultList;
        });
    }

    public static List<Long> getPagePersonId(Long personId, int batchCount, Map<Object, DynamicObject> onBrdStatus) {
        Set<Object> onBrdSet = onBrdStatus.keySet();
        QFilter qf = new QFilter("id", ">", (Object)personId);
        QFilter onBrdFilter = new QFilter("laborrelstatus", "in", onBrdSet);
        Object[] query = employeeServiceHelper.query("person.id", new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish(), onBrdFilter}, "id", batchCount);
        if (HRArrayUtils.isNotEmpty((Object[])query)) {
            return Arrays.stream(query).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>(10);
    }

    public static DynamicObject[] fixIfRepeatNumber(DynamicObject[] empDys) {
        Set numbers = Arrays.stream(empDys).map(dy -> dy.getString("empnumber")).collect(Collectors.toSet());
        if (empDys.length == numbers.size()) {
            return empDys;
        }
        Collection<DynamicObject> fixedDys = Arrays.stream(empDys).collect(Collectors.toMap(dy -> dy.getString("empnumber"), dy -> dy, (o1, o2) -> o1.getDate("startdate").after(o2.getDate("startdate")) ? o1 : o2)).values();
        return fixedDys.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] listEmpByPersonIds(List<Long> personIds) {
        QFilter qFilter = new QFilter("person.id", "in", personIds);
        return employeeServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish(), QFilterUtil.isLatestRecord()});
    }

    public static DynamicObject[] listEmployeeByNumber(List<String> empNumbers) {
        QFilter qFilter = new QFilter("empnumber", "in", empNumbers);
        return employeeServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish(), QFilterUtil.isLatestRecord()});
    }

    public static DynamicObject[] listEmployeeByCustomerQFilter(String selectProps, QFilter[] customQFilters) {
        if (StringUtils.isEmpty((Object)selectProps)) {
            return employeeServiceHelper.queryOriginalArray(selectProps, customQFilters);
        }
        return employeeServiceHelper.loadDynamicObjectArray(customQFilters);
    }
}

