/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hrpi.business.domian.repository.RepositoryUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;

public class HRPIEmpposRepository {
    private static final Log LOGGER = LogFactory.getLog(HRPIEmpposRepository.class);
    private static final HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_empposorgrel");
    private static final String selProp = "id,name,adminorg.id,adminorgvid.id,position,positionvid.id,stdposition.id,stdpositionvid.id,job.id,jobvid.id,businessstatus,startdate,enddate,apositiontype";

    public static DynamicObject[] batchQueryEmppos(long id, int batchCount) {
        QFilter filter = new QFilter("adminorgvid.id", "=", (Object)0L);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", ">", (Object)id), filter};
        return helper.query(selProp, qFilters, "id", batchCount);
    }

    public static DynamicObject[] batchQueryAllEmpPos(QFilter filter, Long id, Integer batchCount) {
        filter.and(new QFilter("id", ">", (Object)id));
        filter.and(QFilterUtil.getInitStatusFinish()).and(QFilterUtil.getDataStatusFilter()).and(QFilterUtil.getCurrentQf());
        return helper.query("id, job, position, person", new QFilter[]{filter}, "id", batchCount.intValue());
    }

    public static DynamicObject[] batchQueryEmpPosByNumber(List<String> empNumberList) {
        QFilter filter = new QFilter("person.number", "in", empNumberList);
        filter.and(QFilterUtil.getInitStatusFinish()).and(QFilterUtil.getDataStatusFilter()).and(QFilterUtil.getCurrentQf());
        String selectField = "id, person, depemp, employee, adminorg, apositiontype, position, job, stdposition, startdate, enddate";
        return helper.query(selectField, new QFilter[]{filter});
    }

    public static Map<Long, List<DynamicObject>> getVidByBoId(String entityName, String selProp, List<Long> boids, List<QFilter> filters) {
        if (CollectionUtils.isEmpty(boids)) {
            return new HashMap<Long, List<DynamicObject>>();
        }
        ArrayList<QFilter> allFilter = new ArrayList<QFilter>();
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter boidFilter = new QFilter("boid", "in", boids).and(initStatusFilter).and(currentVersionFilter);
        allFilter.add(boidFilter);
        allFilter.addAll(filters);
        DynamicObject[] dys = RepositoryUtil.getDynamicObjectCollection(selProp, entityName, allFilter.toArray(new QFilter[0]));
        if (dys != null && dys.length > 0) {
            return Arrays.stream(dys).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        }
        return new HashMap<Long, List<DynamicObject>>();
    }

    public static void saveEmppos(List<DynamicObject> dys) {
        helper.save(dys.toArray(new DynamicObject[0]));
    }

    public static DynamicObject[] batchQueryAllEmpPosByDepEmp(List<Long> depEmpIdList, String selectProperties) {
        QFilter depEmpFilter = new QFilter("depemp", "in", depEmpIdList);
        depEmpFilter.and(QFilterUtil.getInitStatusFinish()).and(QFilterUtil.getDataStatusFilter()).and(QFilterUtil.getCurrentQf());
        return helper.query(selectProperties, new QFilter[]{depEmpFilter});
    }
}

