/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.repository;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hrpi.business.helper.CachedLoadReferenceObjectManagerHelper;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.HRPIValueConstants;

public class HRPIManFileRepository {
    public static final HRBaseServiceHelper manFileServiceHelper = new HRBaseServiceHelper("hspm_ermanfile");
    private static final HRBaseServiceHelper helper = new HRBaseServiceHelper("hspm_erfiletype");
    private static final List<Long> MAIN_ERFILETYPEASSIGN_IDS = Arrays.asList(1010L, 1150L, 1070L, 1190L, 1110L);

    public static DynamicObject[] getFileByEmpIdAndOrg(List<Long> employeeIds, List<Long> orgIds) {
        QFilter empFilter = new QFilter("employee", "in", employeeIds);
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter[] qFilters = new QFilter[]{empFilter, orgFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getStatusFilters(), QFilterUtil.getInitStatusFinish()};
        return manFileServiceHelper.queryOriginalArray("employee.id,id,org.id,depemp.id", qFilters);
    }

    public static DynamicObject[] getFileByEmpId(List<Long> employeeIds, String selectProperties) {
        QFilter empFilter = new QFilter("employee", "in", employeeIds);
        QFilter[] qFilters = new QFilter[]{empFilter, QFilterUtil.getInitStatusFinish()};
        return manFileServiceHelper.query(selectProperties, qFilters);
    }

    public static DynamicObject[] getFileByEmpId(List<Long> employeeIds) {
        QFilter empFilter = new QFilter("employee", "in", employeeIds);
        QFilter[] qFilters = new QFilter[]{empFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()};
        return manFileServiceHelper.query("employee.id,id,org.id,depemp.id,startdate", qFilters);
    }

    public static DynamicObject[] loadPrimaryByEmpId(Collection<Long> employeeIds) {
        QFilter empFilter = new QFilter("employee", "in", employeeIds);
        QFilter isPrimary = new QFilter("empposrel.isprimary", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{empFilter, isPrimary, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()};
        return manFileServiceHelper.queryOriginalArray(DynamicTransformUtil.getAllDbPropString("hspm_ermanfile"), qFilters);
    }

    public static DynamicObject[] getFileByEmpIdForStatus(List<Long> employeeIds) {
        QFilter empFilter = new QFilter("employee", "in", employeeIds);
        QFilter[] qFilters = new QFilter[]{empFilter, QFilterUtil.getCurrentQf(), new QFilter("filetype", "in", MAIN_ERFILETYPEASSIGN_IDS), QFilterUtil.getInitStatusFinish()};
        return CachedLoadReferenceObjectManagerHelper.disabledCache(() -> manFileServiceHelper.query("employee,id,org,depemp,startdate,enddate,person,filetype,sysenddate,bsed", qFilters));
    }

    public static Map<String, Long> getFileTypeByLabAndPosType(Collection<String> labAndPosTypes) {
        if (CollectionUtils.isEmpty(labAndPosTypes)) {
            return Maps.newHashMapWithExpectedSize((int)labAndPosTypes.size());
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter filter = null;
        for (String item : labAndPosTypes) {
            String[] items = item.split("_");
            Long labTypeId = Long.valueOf(items[0]);
            Long posTypeId = Long.valueOf(items[1]);
            QFilter labTypeFilter = new QFilter("laborreltypemul.fbasedataid", "=", (Object)labTypeId);
            QFilter posTypeFilter = new QFilter("postype", "=", (Object)posTypeId);
            QFilter labAndPosTypeFilter = labTypeFilter.and(posTypeFilter);
            if (filter == null) {
                filter = labAndPosTypeFilter;
                continue;
            }
            filter.or(labAndPosTypeFilter);
        }
        DynamicObject[] dys = helper.query("id,postype_id,laborreltype_id,laborreltypemul", new QFilter[]{filter, enableFilter});
        HashMap<String, Long> result = new HashMap<String, Long>(dys.length * 3);
        for (DynamicObject dy : dys) {
            MulBasedataDynamicObjectCollection labRelTypes = (MulBasedataDynamicObjectCollection)dy.getDynamicObjectCollection("laborreltypemul");
            String postypeIdStr = dy.getString("postype_id");
            long fileTypeId = dy.getLong("id");
            labRelTypes.forEach(labRelType -> {
                String labTypeIdStr = labRelType.getString("fbasedataid.id");
                result.put(labTypeIdStr + "_" + postypeIdStr, fileTypeId);
            });
        }
        return result;
    }

    public static DynamicObject[] listErFileByDepIds(Collection<Long> depEmpIds) {
        QFilter qFilter = new QFilter("depemp.id", "in", depEmpIds);
        QFilter filter = new QFilter("laborreltatus.fbasedataid.labrelstatusprd", "=", (Object)HRPIValueConstants.LABRELSTATUSPRD_END);
        DynamicObject[] fileTypes = helper.query("id", new QFilter[]{filter});
        Set fileTypeIds = Arrays.stream(fileTypes).map(item -> (Long)item.get("id")).collect(Collectors.toSet());
        QFilter fileTypeFilter = new QFilter("filetype", "not in", fileTypeIds);
        return manFileServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), fileTypeFilter, QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] getFileTypeByLaborRelStatus(Collection<Long> laborRelStatuss) {
        if (CollectionUtils.isEmpty(laborRelStatuss)) {
            return new DynamicObject[0];
        }
        QFilter laborreltatusFilter = new QFilter("laborreltatus.fbasedataid", "in", laborRelStatuss);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] fileTypes = helper.query("id, laborreltatus", new QFilter[]{laborreltatusFilter, enableFilter});
        return fileTypes;
    }

    public static DynamicObject[] listErManByPersonIds(String selectProps, List<Long> personIds) {
        QFilter qFilter = new QFilter("person", "in", personIds);
        if (StringUtils.isEmpty((Object)selectProps)) {
            return manFileServiceHelper.queryOriginalArray(selectProps, new QFilter[]{qFilter, QFilterUtil.getCurrentAndHisEffectFilter()});
        }
        return manFileServiceHelper.queryOriginalArray(DynamicTransformUtil.getDynamicPropString(manFileServiceHelper.getEntityName()), new QFilter[]{qFilter, QFilterUtil.getCurrentAndHisEffectFilter()});
    }
}

