/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.repository;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.repository.RepositoryUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.HRPIPageConstants;
import kd.hrmp.hrpi.common.IRPCConstants;

public class HRPIPersonRepository {
    public static final HRBaseServiceHelper personServiceHelper = new HRBaseServiceHelper("hrpi_person");
    private static final int INITIALCAPACITY = 4;
    private static final Log LOGGER = LogFactory.getLog(HRPIPersonRepository.class);

    public static DynamicObject[] listPersons(List<Long> personIds, String selectProperties) {
        QFilter qf = new QFilter("boid", "in", personIds);
        return personServiceHelper.query(selectProperties, new QFilter[]{qf});
    }

    public static DynamicObject[] listPersons(List<Long> personIds) {
        String selectProperties = "id,number,name,headsculpture,personindexid";
        QFilter qf = new QFilter("id", "in", personIds);
        return personServiceHelper.query(selectProperties, new QFilter[]{qf});
    }

    public static DynamicObject[] getPersonsByNumber(String selectProperties, Collection<String> numbers, Collection<String> nameList) {
        QFilter qf = new QFilter("number", "in", numbers);
        if (nameList != null && nameList.size() > 0) {
            QFilter nameFilter = new QFilter("name", "in", nameList);
            qf.and(nameFilter);
        }
        return personServiceHelper.query(selectProperties, new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter()});
    }

    public static DynamicObject[] getPersonsByNumber(String selectProperties, Collection<String> numbers, Collection<String> nameList, String orderBy) {
        QFilter qf = new QFilter("number", "in", numbers);
        if (nameList != null && nameList.size() > 0) {
            QFilter nameFilter = new QFilter("name", "in", nameList);
            qf.and(nameFilter);
        }
        return personServiceHelper.query(selectProperties, new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter()}, orderBy);
    }

    public static DynamicObject[] getPersonAttachs(String selectProperties, List<Long> personIds, String entityName, QFilter otherFilter) {
        QFilter qf = new QFilter("person.id", "in", personIds);
        Optional.ofNullable(otherFilter).ifPresent(arg_0 -> ((QFilter)qf).and(arg_0));
        HRBaseServiceHelper perServiceHelper = new HRBaseServiceHelper(entityName);
        return perServiceHelper.queryOriginalArray(selectProperties, new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish(), QFilterUtil.getDataStatusFilter()});
    }

    public static DynamicObject[] loadPersonAttachInfo(String selectProperties, Collection<Long> personIds, String entityName, QFilter otherFilter) {
        QFilter qf = new QFilter("person", "in", personIds);
        if (otherFilter != null) {
            qf.and(otherFilter);
        }
        HRBaseServiceHelper perServiceHelper = new HRBaseServiceHelper(entityName);
        return perServiceHelper.query(selectProperties, new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listPerson(List<Long> personIds) {
        QFilter qf = new QFilter("boid", "in", personIds);
        return RepositoryUtil.getDynamicObjectCollection("hrpi_person", new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listPertsprops(List<Long> personIds) {
        QFilter qf = new QFilter("person.id", "in", personIds);
        return RepositoryUtil.getDynamicObjectCollection("hrpi_pertsprop", new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listPernontsprops(List<Long> personIds) {
        QFilter qf = new QFilter("person.id", "in", personIds);
        return RepositoryUtil.getDynamicObjectCollection("hrpi_pernontsprop", new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listPernontspropsByProp(String selectProperties, List<Long> personIds) {
        QFilter qf = new QFilter("person.id", "in", personIds);
        HRBaseServiceHelper perServiceHelper = new HRBaseServiceHelper("hrpi_pernontsprop");
        return perServiceHelper.queryOriginalArray(selectProperties, new QFilter[]{qf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter()});
    }

    public static Long getPersonMainOrgId(Long personId) {
        DynamicObject empPosorgrel = HRPIDepempRepository.empRelServiceHelper.queryOriginalOne("adminorg.id", new QFilter[]{HRPIPersonRepository.getFilter(personId), HRPIPersonRepository.getPrimaryFilters(), QFilterUtil.getStatusFilters(), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
        return null != empPosorgrel ? Long.valueOf(empPosorgrel.getLong("adminorg.id")) : null;
    }

    public static Long getPersonMainPositionId(Long personId) {
        DynamicObject empPosorgrel = HRPIDepempRepository.empRelServiceHelper.queryOriginalOne("position.id", new QFilter[]{HRPIPersonRepository.getFilter(personId), HRPIPersonRepository.getPrimaryFilters(), QFilterUtil.getStatusFilters(), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
        return null != empPosorgrel ? Long.valueOf(empPosorgrel.getLong("position.id")) : null;
    }

    public static DynamicObject getPrimaryEmpposorgrel(Long personId) {
        HashSet<String> ignore = new HashSet<String>();
        ignore.add("issingle");
        ignore.add("enddate");
        ignore.add("businessstatus");
        String selectProps = DynamicTransformUtil.getDynamicPropString("hrpi_empposorgrel", ignore);
        return HRPIDepempRepository.empRelServiceHelper.queryOne(selectProps, new QFilter[]{HRPIPersonRepository.getFilter(personId), HRPIPersonRepository.getPrimaryFilters(), QFilterUtil.getStatusFilters(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listPrimaryEmpposorgrel(List<Long> personIds) {
        HashSet<String> ignore = new HashSet<String>();
        ignore.add("issingle");
        ignore.add("enddate");
        ignore.add("businessstatus");
        String selectProps = DynamicTransformUtil.getDynamicPropString("hrpi_empposorgrel", ignore);
        QFilter personFilter = new QFilter("person", "in", personIds);
        return HRPIDepempRepository.empRelServiceHelper.query(selectProps, new QFilter[]{personFilter, HRPIPersonRepository.getPrimaryFilters(), QFilterUtil.getStatusFilters(), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static List<Long> listPersonOrgIds(Long personId) {
        ArrayList<Long> list = null;
        DynamicObject[] empPosorgrels = HRPIDepempRepository.empRelServiceHelper.queryOriginalArray("adminorg.id", new QFilter[]{HRPIPersonRepository.getFilter(personId), QFilterUtil.getStatusFilters(), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
        if (null != empPosorgrels && empPosorgrels.length > 0) {
            list = new ArrayList<Long>(empPosorgrels.length);
            for (DynamicObject empPosorgrel : empPosorgrels) {
                list.add(empPosorgrel.getLong("adminorg.id"));
            }
        }
        return list;
    }

    public static DynamicObject[] listEmpposorgrels(Long personId) {
        HashSet<String> ignore = new HashSet<String>();
        ignore.add("issingle");
        ignore.add("businessstatus");
        String selectProps = DynamicTransformUtil.getDynamicPropString("hrpi_empposorgrel", ignore);
        return HRPIDepempRepository.empRelServiceHelper.query(selectProps, new QFilter[]{HRPIPersonRepository.getFilter(personId), QFilterUtil.getStatusFilters(), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listEmpposorgrels(String posType, List<Long> personIds) {
        QFilter personQf = new QFilter("person", "in", personIds);
        if (!"1".equals(posType)) {
            personQf.and(new QFilter("postype.number", "=", (Object)posType));
        }
        HashSet<String> ignore = new HashSet<String>();
        ignore.add("issingle");
        ignore.add("businessstatus");
        String selectProps = DynamicTransformUtil.getDynamicPropString("hrpi_empposorgrel", ignore);
        return HRPIDepempRepository.empRelServiceHelper.query(selectProps, new QFilter[]{personQf, QFilterUtil.getStatusFilters(), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listDataOfAllProperties(Collection<Long> personIds) {
        Set proSet = EntityMetadataCache.getDataEntityType((String)"hrpi_person").getAllFields().keySet();
        proSet.removeAll(IRPCConstants.IGNORE_SET);
        String selectProperties = "id," + String.join((CharSequence)",", proSet);
        return new HRBaseServiceHelper("hrpi_person").query(selectProperties, new QFilter[]{new QFilter("id", "in", personIds), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish(), QFilterUtil.getDataStatusFilter()});
    }

    public static DynamicObject[] listDataOfAllProperties(Collection<Long> personIds, String entityName) {
        Set proSet = EntityMetadataCache.getDataEntityType((String)entityName).getAllFields().keySet();
        proSet.removeAll(IRPCConstants.IGNORE_SET);
        String selectProperties = "id," + String.join((CharSequence)",", proSet);
        return new HRBaseServiceHelper(entityName).query(selectProperties, new QFilter[]{new QFilter("person.id", "in", personIds), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish(), QFilterUtil.getDataStatusFilter()});
    }

    @Deprecated
    public static List<Map<String, Long>> listPersonModelIds(Long personId, Boolean isAll) {
        Object[] objectArray;
        String sql = "select p.fid personid,e.fid employeeid,c.fid cmpempid,d.fid depempid    from t_hrpi_person p left join t_hrpi_employee e on (p.fid=e.fpersonid and e.fiscurrentversion='1')     left join t_hrpi_cmpemp c on (p.fid=c.fpersonid and c.fiscurrentversion='1')     left join t_hrpi_depemp d on (p.fid=d.fpersonid and d.fiscurrentversion='1')     where p.fid=?";
        if (isAll != null && !isAll.booleanValue()) {
            sql = sql + " and e.fbusinessstatus=? and c.fbusinessstatus=? and d.fbusinessstatus=?";
        }
        if (isAll != null && !isAll.booleanValue()) {
            Object[] objectArray2 = new Object[4];
            objectArray2[0] = personId;
            objectArray2[1] = "1";
            objectArray2[2] = "1";
            objectArray = objectArray2;
            objectArray2[3] = "1";
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = personId;
        }
        Object[] params = objectArray;
        return (List)HRDBUtil.query((DBRoute)DBRoute.of((String)"hr"), (String)sql, (Object[])params, rs -> {
            ArrayList tempList = new ArrayList(16);
            while (rs.next()) {
                HashMap<String, Long> map = new HashMap<String, Long>(4);
                map.put("person_id", rs.getLong("personid"));
                map.put("employee_id", rs.getLong("employeeid"));
                map.put("cmpemp_id", rs.getLong("cmpempid"));
                map.put("depemp_id", rs.getLong("depempid"));
                tempList.add(map);
            }
            return tempList;
        });
    }

    public static DynamicObject getHighextPereduexp(Long personId) {
        QFilter degreeFilter = new QFilter("ishighestdegree", "=", (Object)"1");
        return RepositoryUtil.getDynamicObject("hrpi_pereduexp", new QFilter[]{HRPIPersonRepository.getFilter(personId), degreeFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] listPersonAttachs(Long personId, String attachEntityName) {
        return HRPIPersonRepository.listPersonAttachs(Collections.singletonList(personId), null, attachEntityName);
    }

    public static DynamicObject[] listPersonAttachs(List<Long> personIds, String selectProps, QFilter custFilter, String attachEntityName, boolean queryHis) {
        QFilter[] qFilterArray;
        HRPIPersonRepository.checkPersonEntityName(attachEntityName);
        QFilter qf = new QFilter("person.id", "in", personIds);
        if (queryHis) {
            QFilter[] qFilterArray2 = new QFilter[5];
            qFilterArray2[0] = qf;
            qFilterArray2[1] = custFilter;
            qFilterArray2[2] = QFilterUtil.getHisVersionQf();
            qFilterArray2[3] = QFilterUtil.getHisDataStatusQf();
            qFilterArray = qFilterArray2;
            qFilterArray2[4] = QFilterUtil.getInitStatusFinish();
        } else {
            QFilter[] qFilterArray3 = new QFilter[5];
            qFilterArray3[0] = qf;
            qFilterArray3[1] = custFilter;
            qFilterArray3[2] = QFilterUtil.getCurrentQf();
            qFilterArray3[3] = QFilterUtil.getDataStatusFilter();
            qFilterArray = qFilterArray3;
            qFilterArray3[4] = QFilterUtil.getInitStatusFinish();
        }
        QFilter[] qFilters = qFilterArray;
        return RepositoryUtil.getOrigDynamicObjectCollection(selectProps, null, attachEntityName, qFilters, null);
    }

    public static DynamicObject[] listPersonAttachs(List<Long> personIds, QFilter custFilter, String attachEntityName) {
        HRPIPersonRepository.checkPersonEntityName(attachEntityName);
        HashSet<String> ignore = new HashSet<String>();
        ignore.add("issingle");
        ignore.add("businessstatus");
        QFilter qf = new QFilter("person.id", "in", personIds);
        return RepositoryUtil.getDynamicObjectCollection(ignore, attachEntityName, new QFilter[]{qf, custFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static int delPersonAttachs(List<Long> attachIds, String attachName, Boolean isDelBo) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(attachName);
        QFilter qf = new QFilter("id", "in", attachIds);
        Object[] dynamicObjects = serviceHelper.queryOriginalArray("boid", new QFilter[]{qf});
        if (!HRArrayUtils.isEmpty((Object[])dynamicObjects) && isDelBo.booleanValue()) {
            ArrayList<Long> boList = new ArrayList<Long>(dynamicObjects.length);
            for (Object delDy : dynamicObjects) {
                boList.add(delDy.getLong("boid"));
            }
            HRPIPersonRepository.getCallDelInf(attachName, boList);
            return attachIds.size();
        }
        return 0;
    }

    private static Map<String, Object> getCallDelInf(String entityName, List<Long> boList) {
        ArrayList<HashMap> delList = new ArrayList<HashMap>(1);
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)2);
        dataMap.put("entityNumber", entityName);
        dataMap.put("boIdList", boList);
        delList.add(dataMap);
        HashMap<String, Object> delPersonParams = new HashMap<String, Object>(16);
        delPersonParams.put("caller", "hspm");
        delPersonParams.put("data", delList);
        LOGGER.info("call.IHRPIPersonGenericService.deleteBatch");
        Map deleteBatchResult = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonGenericService", (String)"deleteBatch", (Object[])new Object[]{delPersonParams});
        LOGGER.info("call.IHRPIPersonGenericService.deleteBatch.result={}", (Object)deleteBatchResult);
        return deleteBatchResult;
    }

    public static DynamicObject[] getAllPerson(QFilter qFilter) {
        QFilter currentQf = QFilterUtil.getCurrentQf();
        if (qFilter != null) {
            currentQf.and(qFilter).and(QFilterUtil.getDataStatusFilter());
        }
        return personServiceHelper.queryOriginalArray("id,name,number,personindexid", new QFilter[]{currentQf, QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] getAllPersonById(QFilter qFilter) {
        return personServiceHelper.queryOriginalArray("id,name,number,personindexid", new QFilter[]{QFilterUtil.getInitStatusFinish(), qFilter});
    }

    public static DynamicObject[] checkPersonInfo(QFilter qFilter, String entityName, String checkFiled) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        return serviceHelper.query("person.id," + checkFiled, new QFilter[]{qFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static Map<String, Map<Long, DynamicObject>> loadPersonInfo(Set<Long> personIds) {
        HashMap<String, Map<Long, DynamicObject>> personResult = new HashMap<String, Map<Long, DynamicObject>>(personIds.size());
        Object[] personDyArray = personServiceHelper.loadDynamicObjectArray(personIds.toArray(new Object[0]));
        if (!HRArrayUtils.isEmpty((Object[])personDyArray)) {
            RepositoryUtil.wrapResultFromSources(personResult, (DynamicObject[])personDyArray, "hrpi_person", "id");
            QFilter idQf = new QFilter("person", "in", personIds);
            QFilter[] qFilters = new QFilter[]{idQf, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()};
            HRPIPersonRepository.loadPersonDys(qFilters, personResult);
        }
        return personResult;
    }

    private static void loadPersonDys(QFilter[] qFilters, Map<String, Map<Long, DynamicObject>> personResult) {
        HRPIPageConstants.PERSONENTITYS.forEach(personEntity -> {
            HRBaseServiceHelper serviceHelper;
            Object[] dynamicObjects;
            if (!personEntity.equals("hrpi_person") && !HRArrayUtils.isEmpty((Object[])(dynamicObjects = (serviceHelper = new HRBaseServiceHelper(personEntity)).loadDynamicObjectArray(qFilters)))) {
                RepositoryUtil.wrapResultFromSources(personResult, (DynamicObject[])dynamicObjects, personEntity, "person.id");
            }
        });
    }

    private static void checkPersonEntityName(String attachEntityName) {
        QFilter entityFilter = new QFilter("entity", "=", (Object)attachEntityName);
        Map entityCfMap = BusinessDataServiceHelper.loadFromCache((String)"hrpi_personentityconf", (String)"classify", (QFilter[])new QFilter[]{entityFilter});
        if (CollectionUtils.isEmpty((Map)entityCfMap) || !"perattached".equals(((DynamicObject)entityCfMap.values().stream().findFirst().get()).get("classify"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u81ea\u7136\u4eba\u9644\u8868\u7f16\u7801\u3002", (String)"HRPIPersonRepository_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    private static QFilter getFilter(Long personId) {
        return new QFilter("person", "=", (Object)personId);
    }

    private static QFilter getPrimaryFilters() {
        return new QFilter("isprimary", "=", (Object)"1");
    }

    public static DynamicObject[] getPersonInfo4SysUser(List<Long> personIds) {
        return personServiceHelper.query("id,number,name,initstatus", new QFilter[]{new QFilter("id", "in", personIds)});
    }

    public static int countPerson(List<QFilter> qFilterList) {
        return personServiceHelper.count("hrpi_person", qFilterList.toArray(new QFilter[0]));
    }
}

