/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.HRPIValueConstants;

public class HRPIPersonRolerelRepository {
    private static final Log LOGGER = LogFactory.getLog(HRPIPersonRolerelRepository.class);
    public static final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerel");
    private static final HRBaseServiceHelper suprelHelper = new HRBaseServiceHelper("hrpi_empsuprel");
    private static final HRBaseServiceHelper employeeServiceHelper = new HRBaseServiceHelper("hrpi_employee");
    public static final HRBaseServiceHelper workRoleHelp = new HRBaseServiceHelper("hbpm_workroleshr");

    @Deprecated
    public static List<DynamicObject> getMainChargePeoByOrgId(List<Long> orgIdList, Date queryDate) {
        QFilter[] qFilters;
        QFilter mainchargeFilter = new QFilter("mainpeoincharge", "=", (Object)Boolean.TRUE);
        QFilter orgFilter = new QFilter("adminorg", "in", orgIdList);
        if (queryDate == null) {
            qFilters = new QFilter[]{mainchargeFilter, orgFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getStatusFilters(), QFilterUtil.getInitStatusFinish()};
        } else {
            QFilter dateFilter = new QFilter("startdate", "<=", (Object)queryDate);
            dateFilter.and(new QFilter("enddate", ">=", (Object)queryDate));
            qFilters = new QFilter[]{mainchargeFilter, orgFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish(), dateFilter};
        }
        DynamicObject[] queryResult = serviceHelper.query("index,stdposition.id,stdposition.name,depemp.position,adminorg.id,businessstatus,role.name,role.mainpeoincharge,startdate,enddate,person.number,person.name,person.headsculpture,person.id,depemp.idemployee.id,employee.laborreltype.name,employee.laborrelstatus.name,depemp.postype.id,depemp.postype.name,depemp.isprimary", qFilters);
        return HRPIPersonRolerelRepository.filterLeaveOfMainCharge(queryResult);
    }

    private static List<DynamicObject> filterLeaveOfMainCharge(DynamicObject[] queryResult) {
        List employIdList = Arrays.stream(queryResult).distinct().map(item -> item.getLong("employee.id")).collect(Collectors.toList());
        QFilter employIdFilter = new QFilter("id", "in", employIdList);
        QFilter labrelStatuSprdFilter = new QFilter("laborrelstatus.labrelstatusprd.id", "=", (Object)1010);
        QFilter[] qFilters = new QFilter[]{employIdFilter, labrelStatuSprdFilter};
        Object[] idResult = null;
        try {
            idResult = employeeServiceHelper.query("id", qFilters);
        }
        catch (Exception exception) {
            LOGGER.error("filterLeaveOfMainCharge#employeeServiceHelper.query is exception:", (Throwable)exception);
            throw new KDException(new ErrorCode("filterLeaveOfMainCharge", "invoke employeeServiceHelper#query api exception"), new Object[0]);
        }
        if (HRArrayUtils.isNotEmpty((Object[])idResult)) {
            List idList = Arrays.stream(idResult).map(item -> item.getLong("id")).collect(Collectors.toList());
            return Arrays.stream(queryResult).filter(dynamicObject -> CollectionUtils.contains(idList.iterator(), (Object)dynamicObject.getLong("employee.id"))).collect(Collectors.toList());
        }
        return null;
    }

    public static DynamicObject[] getParentRoleRel(Set<Long> parentRoleIds) {
        QFilter personFilter = new QFilter("role.id", "in", parentRoleIds);
        return serviceHelper.queryOriginalArray("role.id,person.id,employee.id,depemp.id,person.number,person.name,person.headsculpture,adminorg.id,adminorg.name,adminorg.number", new QFilter[]{personFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getStatusFilters(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObject[] getParentRoleRel(Set<Long> parentRoleIds, Date date) {
        QFilter personFilter = new QFilter("role.id", "in", parentRoleIds);
        QFilter startDateFilter = new QFilter("startdate", "<=", (Object)date);
        QFilter endDateFilter = new QFilter("enddate", ">=", (Object)date);
        return serviceHelper.queryOriginalArray("role.id,person.id,employee.id,depemp.id,person.number,person.name,person.headsculpture,adminorg.id,adminorg.name,adminorg.number", new QFilter[]{personFilter, startDateFilter, endDateFilter, new QFilter("employee.laborrelstatus.labrelstatusprd", "=", (Object)HRPIValueConstants.LABRELSTATUSPRD_ING), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()});
    }

    public static DynamicObjectCollection getRolesByPersonId(String queryKey, List<Long> personIds) {
        return HRPIPersonRolerelRepository.getRolesByPersonId(queryKey, personIds, DateUtil.getCurrentDate());
    }

    public static DynamicObjectCollection getRolesByPersonId(String queryKey, List<Long> personIds, Date queryDate) {
        return HRPIPersonRolerelRepository.getRolesByPersonId(queryKey, personIds, queryDate, "role.id," + queryKey);
    }

    public static DynamicObjectCollection getRolesByPersonId(String queryKey, List<Long> personIds, Date queryDate, String select) {
        QFilter personFilter = new QFilter(queryKey, "in", personIds);
        QFilter startFilter = new QFilter("startdate", "<=", (Object)queryDate);
        QFilter endFilter = new QFilter("enddate", ">=", (Object)queryDate);
        return serviceHelper.queryOriginalCollection(select, new QFilter[]{personFilter, startFilter, endFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }

    public static List<DynamicObject> getAllParentRelations(Set<Long> roleIds) {
        return HRPIPersonRolerelRepository.getAllParentRelations(roleIds, DateUtil.getCurrentDate());
    }

    public static List<DynamicObject> getAllParentRelations(Set<Long> roleIds, Date queryDate) {
        try {
            Map roleMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IWorkRoleService", (String)"queryAllParentRelations", (Object[])new Object[]{queryDate, new ArrayList<Long>(roleIds), 1010L});
            LOGGER.info(" getAllParentRelations info {}", (Object)roleMap);
            return !roleMap.isEmpty() && (Boolean)roleMap.get("success") != false ? (List)roleMap.get("data") : Collections.emptyList();
        }
        catch (Exception ex) {
            LOGGER.error("getAllParentRelations roleIds:{} error:{}", (Object)roleIds.toArray(), (Object)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0a\u7ea7\u5de5\u4f5c\u89d2\u8272\u5f02\u5e38\u3002", (String)"PersonRoleServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    public static Map<Long, List<Map<String, Object>>> getPerSuperior(String queryKey, List<Long> ids) {
        return HRPIPersonRolerelRepository.getPerSuperior(queryKey, ids, DateUtil.getCurrentDate());
    }

    public static Map<Long, List<Map<String, Object>>> getPerSuperior(String queryKey, List<Long> ids, Date queryDate) {
        QFilter personQf = new QFilter(queryKey, "in", ids);
        QFilter typeQf = new QFilter("reporttype.id", "=", (Object)1010);
        QFilter startFilter = new QFilter("startdate", "<=", (Object)queryDate);
        QFilter endFilter = HRDateTimeUtils.getNowDate().compareTo(HRDateTimeUtils.dateFormatDate((Date)queryDate)) == 0 ? new QFilter("enddate", ">", (Object)queryDate) : new QFilter("enddate", ">=", (Object)queryDate);
        Object[] superiorDys = suprelHelper.queryOriginalArray("person.id,depemp.id,superioremployee.id,superiordepemp.id,superior.id,superior.number,superior.name,superior.headsculpture,superioradminorg.id,superioradminorg.name,superioradminorg.number,enddate", new QFilter[]{personQf, typeQf, startFilter, endFilter, new QFilter("superioremployee.laborrelstatus.labrelstatusprd", "=", (Object)HRPIValueConstants.LABRELSTATUSPRD_ING), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
        LOGGER.info("getPerSuperior count {}-->{}", (Object)queryKey, (Object)superiorDys.length);
        if (!HRArrayUtils.isEmpty((Object[])superiorDys)) {
            Map<Long, List<DynamicObject>> personGroupByOrg = Arrays.stream(superiorDys).collect(Collectors.groupingBy(dy -> dy.getLong(queryKey)));
            HashMap<Long, List<Map<String, Object>>> result = new HashMap<Long, List<Map<String, Object>>>(personGroupByOrg.size());
            for (Map.Entry<Long, List<DynamicObject>> longListEntry : personGroupByOrg.entrySet()) {
                List<DynamicObject> superiorList = longListEntry.getValue();
                ArrayList list = new ArrayList(superiorList.size());
                for (DynamicObject superior : superiorList) {
                    HashMap<String, Object> infoMap = new HashMap<String, Object>(16);
                    infoMap.put("superior.number", superior.getString("superior.number"));
                    infoMap.put("superior.name", superior.getString("superior.name"));
                    infoMap.put("superior.headsculpture", superior.getString("superior.headsculpture"));
                    infoMap.put("superioradminorg.id", superior.getLong("superioradminorg.id"));
                    infoMap.put("superioradminorg.name", superior.getString("superioradminorg.name"));
                    infoMap.put("superioradminorg.number", superior.getString("superioradminorg.number"));
                    infoMap.put("person.id", superior.getLong("superior.id"));
                    infoMap.put("depemp.id", superior.getLong("superiordepemp.id"));
                    infoMap.put("employee.id", superior.getLong("superioremployee.id"));
                    list.add(infoMap);
                }
                result.put(longListEntry.getKey(), list);
            }
            return result;
        }
        return new HashMap<Long, List<Map<String, Object>>>();
    }

    public static DynamicObject[] getPersonRoleByPersonIds(String selectProperties, List<Long> personIds, List<Long> adminOrgIds) {
        QFilter personFilter = new QFilter("person", "in", personIds);
        QFilter adminOrgFilter = new QFilter("adminorg", "in", adminOrgIds);
        QFilter mainFilter = new QFilter("mainpeoincharge", "=", (Object)"1");
        QFilter busFilter = new QFilter("businessstatus", "=", (Object)"1");
        QFilter currentQf = QFilterUtil.getCurrentQf();
        return serviceHelper.queryOriginalArray(selectProperties, new QFilter[]{adminOrgFilter, busFilter, personFilter, mainFilter, currentQf});
    }

    public static DynamicObject[] getMainChargeRole() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter mainChargeFilter = new QFilter("mainpeoincharge", "=", (Object)true);
        QFilter sourceTypeFilter = new QFilter("rolesourcetype", "=", (Object)1010L);
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)false);
        return workRoleHelp.query("id,mainpeoincharge,iscurrentversion,bsed,bsled,boid", new QFilter[]{enableFilter, mainChargeFilter, sourceTypeFilter, dataStatusFilter, currentVersionFilter});
    }

    public static DynamicObject[] getPersonRoleRel(String properties, Set<Long> roleIdSet) {
        QFilter roleFilter = new QFilter("role", "in", roleIdSet);
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)false);
        return serviceHelper.query(properties, new QFilter[]{roleFilter, dataStatusFilter, currentVersionFilter});
    }

    public static DynamicObject[] getPersonRoleRelByDepEmp(String properties, List<Long> depEmpIdList) {
        QFilter depEmpIdFilter = new QFilter("depemp", "in", depEmpIdList);
        depEmpIdFilter.and(QFilterUtil.getCurrentQf());
        depEmpIdFilter.and(QFilterUtil.getDataStatusFilter());
        depEmpIdFilter.and(QFilterUtil.getInitStatusFinish());
        return serviceHelper.query(properties, new QFilter[]{depEmpIdFilter});
    }

    public static DynamicObject[] getSuperiorByDepEmpIds(List<Long> depEmpIds, List<Long> reportTypeIds) {
        QFilter personFilter = new QFilter("depemp", "in", depEmpIds);
        String dynamicPropString = DynamicTransformUtil.getDynamicPropString(suprelHelper.getEntityName());
        QFilter typeFilter = new QFilter("reporttype", "in", reportTypeIds);
        return suprelHelper.query(dynamicPropString + ",hisversion,creator,createtime,modifier,modifytime,initstatus", new QFilter[]{personFilter, typeFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()});
    }
}

