/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.repository;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;

public class HRPISyncRepository {
    private static final Log LOGGER = LogFactory.getLog(HRPISyncRepository.class);
    private static final Set<String> MODELE_NTITY = new HashSet<String>();

    public static List<Map<String, Object>> getSyncInfo(String entityName, Long id, Long boId, Long relationId) {
        DynamicObject[] queryList = new DynamicObject[]{};
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        QFilter qFilter = HRPISyncRepository.getFilter(entityName, id, boId, relationId);
        if (null != qFilter) {
            queryList = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        }
        return DynamicTransformUtil.dynamicAllPropListToMap(Arrays.asList(queryList));
    }

    public static List<Map<String, Object>> getSyncInfo(String selectFileds, String entityName, Long id, Long boId, Long relationId) {
        return HRPISyncRepository.getSyncInfo(selectFileds, null, entityName, id, boId, relationId);
    }

    public static List<Map<String, Object>> getSyncInfo(String selectFields, QFilter custFilter, String entityName, Long id, Long boId, Long relationId) {
        String select = HRPISyncRepository.getQueryFiled(selectFields, entityName);
        if (HRStringUtils.isEmpty((String)select)) {
            LOGGER.info("getSyncInfo {} {} {} {} {} {}", new Object[]{selectFields, custFilter, entityName, id, boId, relationId});
            throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u6027\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HRPISyncRepository_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        DynamicObject[] queryDys = new DynamicObject[]{};
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        QFilter qFilter = HRPISyncRepository.getFilter(entityName, id, boId, relationId);
        if (null != qFilter) {
            QFilter[] qFilterArray;
            if (null == custFilter) {
                QFilter[] qFilterArray2 = new QFilter[1];
                qFilterArray = qFilterArray2;
                qFilterArray2[0] = qFilter;
            } else {
                QFilter[] qFilterArray3 = new QFilter[2];
                qFilterArray3[0] = qFilter;
                qFilterArray = qFilterArray3;
                qFilterArray3[1] = custFilter;
            }
            QFilter[] qfilters = qFilterArray;
            try {
                queryDys = serviceHelper.query(select, qfilters);
            }
            catch (Exception ex) {
                LOGGER.error("getSyncInfo {} {} {} {} {} {} error:{}", new Object[]{selectFields, custFilter, entityName, id, boId, relationId, ex});
                throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6761\u4ef6\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HRPISyncRepository_7", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
        return DynamicTransformUtil.dynamicListToMap(Arrays.asList(queryDys));
    }

    public static DynamicObject[] getSyncInfo(String selectFields, QFilter custFilter, String entityName) {
        String select = HRPISyncRepository.getQueryFiled(selectFields, entityName);
        if (HRStringUtils.isEmpty((String)select)) {
            LOGGER.info("getSyncInfo {} {} {}", new Object[]{selectFields, custFilter, entityName});
            throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u6027\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HRPISyncRepository_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        if (custFilter == null) {
            return null;
        }
        QFilter[] qFilters = new QFilter[]{custFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter()};
        return serviceHelper.query(select, qFilters);
    }

    private static String getQueryFiled(String selectProperties, String entityName) {
        String select = null;
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        if (!HRStringUtils.isEmpty((String)selectProperties) && null != dataEntityType) {
            String[] properties = selectProperties.split(",");
            HashSet<String> selectSet = new HashSet<String>(properties.length);
            selectSet.addAll(Arrays.asList(properties));
            for (String filed : selectSet) {
                if (null != dataEntityType.findProperty(filed)) continue;
                return null;
            }
            select = String.join((CharSequence)",", selectSet);
        }
        return select;
    }

    private static QFilter getFilter(String entityName, Long id, Long boId, Long relationId) {
        QFilter qFilter = null;
        if (null != id && id > 0L) {
            return new QFilter("id", "=", (Object)id);
        }
        if (null != boId && boId > 0L) {
            qFilter = new QFilter("boid", "=", (Object)boId);
        }
        if (null != relationId && relationId > 0L && !MODELE_NTITY.contains(entityName)) {
            QFilter relationQf = HRPISyncRepository.getRelationQf(entityName, relationId);
            qFilter = qFilter == null ? relationQf : qFilter.and(relationQf);
        }
        return qFilter;
    }

    private static QFilter getRelationQf(String entityName, Long relationId) {
        QFilter qf = null;
        QFilter entityFilter = new QFilter("entity", "=", (Object)entityName);
        Map entityCfMap = BusinessDataServiceHelper.loadFromCache((String)"hrpi_personentityconf", (String)"classify", (QFilter[])new QFilter[]{entityFilter});
        if (CollectionUtils.isEmpty((Map)entityCfMap)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5b9e\u4f53\u7f16\u7801\u3002", (String)"HRPISyncRepository_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        DynamicObject entityDy = entityCfMap.values().stream().findFirst().orElse(null);
        if (null != entityDy) {
            String classify;
            switch (classify = entityDy.getString("classify")) {
                case "perattached": {
                    qf = new QFilter("person.id", "=", (Object)relationId);
                    break;
                }
                case "empattached": {
                    qf = new QFilter("employee.id", "=", (Object)relationId);
                    break;
                }
                case "cmpempattached": {
                    qf = new QFilter("cmpemp.id", "=", (Object)relationId);
                    break;
                }
                case "depempattached": {
                    qf = new QFilter("depemp.id", "=", (Object)relationId);
                    break;
                }
            }
        }
        return qf;
    }

    public static DynamicObject[] listRangeInfo(String entityName, String selectFields, Date gteDate, Date ltDate, List<Long> personIdList, List<Long> employeeIdList, Map<String, Object> paramMap, String queryType) {
        if (gteDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u8d77\u59cb\u65e5\u671f\u3002", (String)"HRPISyncRepository_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (ltDate != null && gteDate.compareTo(ltDate) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d77\u59cb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u622a\u6b62\u65e5\u671f\u3002", (String)"HRPISyncRepository_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        gteDate = DateUtil.dateWithoutTime(gteDate);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter(HRStringUtils.equals((String)"1", (String)queryType) ? "startdate" : "bsed", ">=", (Object)gteDate));
        if (ltDate != null) {
            ltDate = DateUtil.dateWithoutTime(ltDate);
            qFilterList.add(new QFilter(HRStringUtils.equals((String)"1", (String)queryType) ? "startdate" : "bsed", "<", (Object)ltDate));
        }
        return HRPISyncRepository.listDataInfo(entityName, selectFields, qFilterList, personIdList, employeeIdList, paramMap, queryType);
    }

    public static DynamicObject[] listIntersectInfo(String entityName, String selectFields, Date gteDate, Date lteDate, List<Long> personIdList, List<Long> employeeIdList, Map<String, Object> paramMap, String queryType) {
        if (gteDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u8d77\u59cb\u65e5\u671f\u3002", (String)"HRPISyncRepository_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (lteDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u622a\u6b62\u65e5\u671f\u3002", (String)"HRPISyncRepository_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (gteDate.compareTo(lteDate) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d77\u59cb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u622a\u6b62\u65e5\u671f\u3002", (String)"HRPISyncRepository_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        gteDate = DateUtil.dateWithoutTime(gteDate);
        lteDate = DateUtil.dateWithoutTime(lteDate);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter(HRStringUtils.equals((String)"1", (String)queryType) ? "enddate" : "bsled", ">=", (Object)gteDate));
        qFilterList.add(new QFilter(HRStringUtils.equals((String)"1", (String)queryType) ? "startdate" : "bsed", "<=", (Object)lteDate));
        return HRPISyncRepository.listDataInfo(entityName, selectFields, qFilterList, personIdList, employeeIdList, paramMap, queryType);
    }

    private static DynamicObject[] listDataInfo(String entityName, String selectFields, List<QFilter> qFilterList, List<Long> personIdList, List<Long> employeeIdList, Map<String, Object> paramMap, String queryType) {
        String select = HRPISyncRepository.getQueryFiled(selectFields, entityName);
        if (HRStringUtils.isEmpty((String)select)) {
            LOGGER.info("listDataInfo {} {} {} {} {}", new Object[]{entityName, select, personIdList, employeeIdList, queryType});
            throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u6027\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HRPISyncRepository_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        QFilter entityFilter = new QFilter("entity", "=", (Object)entityName);
        Map entityCfMap = BusinessDataServiceHelper.loadFromCache((String)"hrpi_personentityconf", (String)"classify", (QFilter[])new QFilter[]{entityFilter});
        if (CollectionUtils.isEmpty((Map)entityCfMap)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5b9e\u4f53\u7f16\u7801\u3002", (String)"HRPISyncRepository_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(personIdList) && CollectionUtils.isEmpty(employeeIdList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u4f20\u4e00\u4e2a\u81ea\u7136\u4ebaID\u96c6\u6216\u4f01\u4e1a\u4ebaID\u96c6\u3002", (String)"HRPISyncRepository_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (!CollectionUtils.isEmpty(personIdList)) {
            qFilterList.add(new QFilter("person", "in", personIdList));
        }
        if (!CollectionUtils.isEmpty(employeeIdList)) {
            qFilterList.add(new QFilter("employee", "in", employeeIdList));
        }
        if (HRStringUtils.equals((String)"1", (String)queryType)) {
            qFilterList.add(QFilterUtil.getDataStatusFilter());
            qFilterList.add(QFilterUtil.getCurrentQf());
        } else {
            qFilterList.add(new QFilter("datastatus", "in", Arrays.asList("0", "1", "2")));
            qFilterList.add(new QFilter("iscurrentversion", "=", (Object)"0"));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        return serviceHelper.query(select, qFilterList.toArray(new QFilter[0]));
    }

    public static List<Map<String, Object>> listIntersectDataSocialworkageAndServicelengthInfo(Date gteDate, Date lteDate, List<Long> personIdList) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        DynamicObject[] empentrelDys = HRPISyncRepository.listIntersectInfo("hrpi_empentrel", "person,servicelength,bsed,bsled", gteDate, lteDate, personIdList, null, null, "2");
        if (empentrelDys == null || empentrelDys.length == 0) {
            return resultList;
        }
        Map<Long, List<DynamicObject>> personIdGroupByEmpentrelList = Arrays.stream(empentrelDys).collect(Collectors.groupingBy(dy -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"person")));
        HRBaseServiceHelper perserlenServiceHelper = new HRBaseServiceHelper("hrpi_perserlen");
        QFilter perserlenFilter = new QFilter("person", "in", personIdGroupByEmpentrelList.keySet());
        perserlenFilter.and(QFilterUtil.getDataStatusFilter());
        perserlenFilter.and(QFilterUtil.getCurrentQf());
        perserlenFilter.and(QFilterUtil.getInitStatusFinish());
        DynamicObject[] perserlenDys = perserlenServiceHelper.query("person,socialworkage", perserlenFilter.toArray());
        HashMap<Long, BigDecimal> personIdSocialworkageMap = new HashMap<Long, BigDecimal>(16);
        if (perserlenDys != null && perserlenDys.length > 0) {
            personIdSocialworkageMap.putAll(Arrays.stream(perserlenDys).collect(Collectors.toMap(dy -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"person"), dy -> dy.getBigDecimal("socialworkage"), (k1, k2) -> k1)));
        }
        for (Map.Entry<Long, List<DynamicObject>> entry : personIdGroupByEmpentrelList.entrySet()) {
            Long personId = entry.getKey();
            List<DynamicObject> empentrelDyList = entry.getValue();
            BigDecimal socialworkageValue = (BigDecimal)personIdSocialworkageMap.get(personId);
            List<Map<String, Object>> resultMap = DynamicTransformUtil.dynamicListToMap(empentrelDyList);
            resultMap.forEach(map -> map.put("socialworkage", socialworkageValue));
            resultList.addAll(resultMap);
        }
        return resultList;
    }

    static {
        MODELE_NTITY.add("hrpi_person");
        MODELE_NTITY.add("hrpi_employee");
        MODELE_NTITY.add("hrpi_cmpemp");
        MODELE_NTITY.add("hrpi_depemp");
    }
}

