/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.attachrevision.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.LogPrivacyUtil;
import kd.hrmp.hrpi.business.application.impl.charge.ChargeApplicationImpl;
import kd.hrmp.hrpi.business.domian.repository.HRPIAttachReviseConRepository;
import kd.hrmp.hrpi.business.domian.service.attachrevision.IAttachRevisionService;
import kd.hrmp.hrpi.business.domian.service.generic.IPersonGenericService;
import kd.hrmp.hrpi.business.domian.service.impl.HRPIOperationServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.HRPositionServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.PersonGenericServiceImpl;
import kd.hrmp.hrpi.business.helper.CachedLoadReferenceObjectManagerHelper;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.HRPIMsgConstants;
import kd.hrmp.hrpi.common.enums.ChangeSourceEnum;
import org.apache.commons.collections4.CollectionUtils;

public class AttachRevisionServiceImpl
implements IAttachRevisionService {
    private static final Log LOGGER = LogFactory.getLog(AttachRevisionServiceImpl.class);
    private static volatile IAttachRevisionService ATTACHREVISIONSERVICE;
    private static final String ENTITYNAME = "entityName";
    private static final String SYS_FIELD_TYPE = "0";
    private static final String CORE_FIELD_TYPE = "1";
    private static final String TIMING_SERIAL_FIELD_TYPE = "2";
    private static final String TIME_FIELD_TYPE = "3";
    private static final Integer success;
    public static final String HRPI_ATTACHREVISION_QUEUE = "kd.hrmp.hrpi.attachrevision.queue";
    private static final Map<String, String> SPECIALFIELD_MAP;
    private static final String HPFS_CHGEXTERNALRECORD_QUEUE = "hpfs_chgexternalrecord_queue";
    protected final IPersonGenericService personGenericService = PersonGenericServiceImpl.getInstance();
    protected static final HRBaseServiceHelper depEmpHelper;
    protected static final HRBaseServiceHelper empPosAllHelper;
    protected static final HRBaseServiceHelper manFileServiceHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IAttachRevisionService getInstance() {
        try {
            if (null != ATTACHREVISIONSERVICE) return ATTACHREVISIONSERVICE;
            Class<AttachRevisionServiceImpl> clazz = AttachRevisionServiceImpl.class;
            synchronized (AttachRevisionServiceImpl.class) {
                if (null != ATTACHREVISIONSERVICE) return ATTACHREVISIONSERVICE;
                try {
                    ATTACHREVISIONSERVICE = new AttachRevisionServiceImpl();
                    LOGGER.info("HRPIServiceFactory-dependency-check,new-AttachRevisionServiceImpl()-success");
                }
                catch (Throwable t) {
                    LOGGER.error("HRPIServiceFactory-dependency-check,new-AttachRevisionServiceImpl()-fail", t);
                }
                return ATTACHREVISIONSERVICE;
            }
        }
        catch (Throwable t) {
            LOGGER.error("HRPIServiceFactory-dependency-check,AttachRevisionServiceImpl-getInstance()-fail", t);
        }
        return ATTACHREVISIONSERVICE;
    }

    @Override
    public Map<String, Object> getFieldsFromReviseConfig(Map<String, Object> params) {
        if (HRMapUtils.isEmpty(params) || HRStringUtils.isEmpty((String)((String)params.get(ENTITYNAME)))) {
            return HRPIOperationServiceImpl.getFail("param is empty");
        }
        String entityName = (String)params.get(ENTITYNAME);
        DynamicObject entityMetaDy = HRPIAttachReviseConRepository.getEntityMetaIdOfEntityName(entityName);
        if (entityMetaDy != null) {
            Map<String, List<String>> reviseConfigMap;
            String entityMetaId = entityMetaDy.getString("id");
            LOGGER.info("AttachRevisionServiceImpl#getFieldsFromReviseConfig entityName={},entityMetaId={}", (Object)entityName, (Object)entityMetaId);
            if (HRStringUtils.isNotEmpty((String)entityMetaId) && !HRMapUtils.isEmpty(reviseConfigMap = HRPIAttachReviseConRepository.getReviseConfigByEntityMetaId(entityMetaId))) {
                return HRPIOperationServiceImpl.getSuccess(reviseConfigMap);
            }
        } else {
            return HRPIOperationServiceImpl.getFail("entityMetaDy is null");
        }
        return HRPIOperationServiceImpl.getFail("getFieldsFromReviseConfig is fail");
    }

    @Override
    public Map<String, Object> handlerAttachRevision(Map<String, Object> params) {
        Map<String, Object> fieldsFromReviseConfig = this.getFieldsFromReviseConfig(params);
        if (!((Boolean)fieldsFromReviseConfig.get("success")).booleanValue()) {
            return HRPIOperationServiceImpl.getFail("fieldsFromReviseConfig is failed");
        }
        Map fieldsReviseConfig = (Map)fieldsFromReviseConfig.get("data");
        if (!HRMapUtils.isEmpty((Map)fieldsReviseConfig)) {
            Set fieldType = fieldsReviseConfig.keySet();
            if (fieldType.contains(CORE_FIELD_TYPE)) {
                try (TXHandle ignored = TX.requiresNew();){
                    Map<String, Object> map = this.handlerCoreField(params, (List)fieldsReviseConfig.get(CORE_FIELD_TYPE));
                    return map;
                }
            }
            return HRPIOperationServiceImpl.getFail("not support type");
        }
        return HRPIOperationServiceImpl.getFail("fieldsFromReviseConfig is null");
    }

    private Map<String, Object> handlerCoreField(Map<String, Object> params, List<String> coreField) {
        String entityName = (String)params.get(ENTITYNAME);
        long id = (Long)params.get("id");
        Map reviseData = (Map)params.get("revisedata");
        HashMap<String, Object> reviseCoreData = new HashMap<String, Object>(reviseData.size());
        if (CollectionUtils.isEmpty(coreField)) {
            return HRPIOperationServiceImpl.getFail("coreField config is empty");
        }
        for (String field : coreField) {
            if (!reviseData.containsKey(field)) continue;
            reviseCoreData.put(field, reviseData.get(field));
        }
        LOGGER.info("reviseData={},filter reviseCoreData={}", (Object)LogPrivacyUtil.filterPrivacyProp((Map)reviseData), (Object)LogPrivacyUtil.filterPrivacyProp(reviseCoreData));
        if (HRStringUtils.equals((String)"hrpi_empposorgrel", (String)entityName)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
            DynamicObject originDy = serviceHelper.queryOne((Object)id);
            String apositiontype = originDy.getString("apositiontype");
            long positionId = originDy.getLong("position.id");
            long darkpositionId = originDy.getLong("darkposition.id");
            long adminOrgId = originDy.getLong("adminorg.id");
            long depempId = originDy.getLong("depemp.id");
            long employeeId = originDy.getLong("employee.id");
            long cmpEmpId = originDy.getLong("cmpemp.id");
            long personId = originDy.getLong("person.id");
            Date startDate = (Date)originDy.get("startdate");
            Date endDate = (Date)originDy.get("enddate");
            ArrayList addDarkPosParam = Lists.newArrayListWithExpectedSize((int)1);
            HashMap posParam = Maps.newHashMapWithExpectedSize((int)4);
            HashMap<String, Object> specialData = new HashMap<String, Object>();
            if (!HRMapUtils.isEmpty(reviseCoreData) && (reviseCoreData.containsKey("stdposition") || reviseCoreData.containsKey("job") || reviseCoreData.containsKey("position"))) {
                if (!reviseCoreData.containsKey("apositiontype")) {
                    if (!HRStringUtils.equals((String)CORE_FIELD_TYPE, (String)apositiontype)) {
                        if (!reviseCoreData.containsKey("stdposition") && !reviseCoreData.containsKey("job")) {
                            return HRPIOperationServiceImpl.getFail("stdposition or job can not empty");
                        }
                        try {
                            HRPositionServiceImpl.getInstance().disableDarkPosition(new Object[]{positionId});
                        }
                        catch (Exception exception) {
                            LOGGER.error("disableDarkPosition is exception:", (Throwable)exception);
                        }
                        Map<String, Object> result = this.getStringObjectMap(reviseCoreData, adminOrgId, personId, startDate, endDate, addDarkPosParam, posParam, specialData);
                        if (!HRMapUtils.isEmpty(result) && result.containsKey("success") && !((Boolean)result.get("success")).booleanValue()) {
                            return result;
                        }
                        LOGGER.info("darkPosResult={},specialData={}", result, specialData);
                    } else {
                        if (!reviseCoreData.containsKey("position")) {
                            return HRPIOperationServiceImpl.getFail("position can not empty");
                        }
                        long newPositionId = (Long)reviseCoreData.get("position");
                        if (positionId != newPositionId) {
                            Object[] positionIds = new Object[]{positionId, newPositionId};
                            DynamicObject[] dynamicObjects1 = HRBaseServiceHelper.create((String)"hbpm_positionhr").loadDynamicObjectArray(positionIds);
                            List isleaderPositionList = Arrays.stream(dynamicObjects1).filter(dy -> HRStringUtils.equals((String)CORE_FIELD_TYPE, (String)dy.getString("isleader"))).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                            LOGGER.info("addChargePersonByPosition#isleaderPositionList={}", JSONObject.toJSON(isleaderPositionList));
                            if (CollectionUtils.isNotEmpty(isleaderPositionList)) {
                                ArrayList<Map<String, Object>> chargePersonParam = new ArrayList<Map<String, Object>>(isleaderPositionList.size());
                                Iterator iterator = isleaderPositionList.iterator();
                                while (iterator.hasNext()) {
                                    long leader = (Long)iterator.next();
                                    HashMap<String, Object> param = new HashMap<String, Object>();
                                    if (positionId == leader) {
                                        param.put("operatetype", CORE_FIELD_TYPE);
                                        param.put("adminorg", adminOrgId);
                                    }
                                    if (newPositionId == leader) {
                                        param.put("operatetype", SYS_FIELD_TYPE);
                                        param.put("adminorg", reviseCoreData.getOrDefault("adminorg", adminOrgId));
                                    }
                                    param.put("person", personId);
                                    param.put("depemp", depempId);
                                    param.put("effdt", new Date());
                                    param.put("changesource", ChangeSourceEnum.POSITION_CHANGE.getId());
                                    chargePersonParam.add(param);
                                }
                                LOGGER.info("addChargePersonByPosition#chargePersonParam={}", chargePersonParam);
                                if (CollectionUtils.isNotEmpty(chargePersonParam)) {
                                    new ChargeApplicationImpl().setChargePerson(chargePersonParam);
                                }
                            } else {
                                LOGGER.info("positionId={} and newPositionId={} are not leaderPosition", (Object)positionId, (Object)newPositionId);
                            }
                        }
                    }
                } else {
                    String newApositiontype = (String)reviseCoreData.get("apositiontype");
                    if (!HRStringUtils.equals((String)apositiontype, (String)newApositiontype)) {
                        Map<String, Object> result;
                        if (HRStringUtils.equals((String)CORE_FIELD_TYPE, (String)apositiontype) && !HRStringUtils.equals((String)CORE_FIELD_TYPE, (String)newApositiontype)) {
                            if (!reviseCoreData.containsKey("stdposition") && !reviseCoreData.containsKey("job")) {
                                return HRPIOperationServiceImpl.getFail("stdposition or job can not empty");
                            }
                            result = this.getStringObjectMap(reviseCoreData, adminOrgId, personId, startDate, endDate, addDarkPosParam, posParam, specialData);
                            if (!HRMapUtils.isEmpty(result) && result.containsKey("success") && !((Boolean)result.get("success")).booleanValue()) {
                                return result;
                            }
                            LOGGER.info("newApositiontype={},result={},specialData={}", new Object[]{newApositiontype, result, specialData});
                        }
                        if (!HRStringUtils.equals((String)CORE_FIELD_TYPE, (String)apositiontype) && HRStringUtils.equals((String)CORE_FIELD_TYPE, (String)newApositiontype)) {
                            if (!reviseCoreData.containsKey("position")) {
                                return HRPIOperationServiceImpl.getFail("position can not empty");
                            }
                            if (HRStringUtils.equals((String)SYS_FIELD_TYPE, (String)apositiontype)) {
                                specialData.put("stdposition", null);
                            } else {
                                specialData.put("job", null);
                            }
                            LOGGER.info("apositiontype={},specialData={}", (Object)apositiontype, specialData);
                            try {
                                HRPositionServiceImpl.getInstance().disableDarkPosition(new Object[]{positionId});
                                LOGGER.info("positionId={},darkpositionId={}", (Object)positionId, (Object)darkpositionId);
                            }
                            catch (Exception exception) {
                                LOGGER.error("disableDarkPosition is exception:", (Throwable)exception);
                            }
                        }
                        if (HRStringUtils.equals((String)TIMING_SERIAL_FIELD_TYPE, (String)apositiontype) && HRStringUtils.equals((String)SYS_FIELD_TYPE, (String)newApositiontype) || HRStringUtils.equals((String)SYS_FIELD_TYPE, (String)apositiontype) && HRStringUtils.equals((String)TIMING_SERIAL_FIELD_TYPE, (String)newApositiontype)) {
                            try {
                                HRPositionServiceImpl.getInstance().disableDarkPosition(new Object[]{positionId});
                            }
                            catch (Exception exception) {
                                LOGGER.error("disableDarkPosition is exception:", (Throwable)exception);
                            }
                            result = this.getStringObjectMap(reviseCoreData, adminOrgId, personId, startDate, endDate, addDarkPosParam, posParam, specialData);
                            if (!HRMapUtils.isEmpty(result) && result.containsKey("success") && !((Boolean)result.get("success")).booleanValue()) {
                                return result;
                            }
                            if (reviseCoreData.containsKey("stdposition")) {
                                specialData.put("job", null);
                            }
                            LOGGER.info("apositiontype={},newApositiontype={},specialData={}", new Object[]{apositiontype, newApositiontype, specialData});
                        }
                    }
                }
            }
            if (!HRMapUtils.isEmpty(specialData)) {
                reviseCoreData.putAll(specialData);
            }
            if (reviseCoreData.containsKey("enddate")) {
                Object newEndDate = reviseCoreData.get("enddate");
                LOGGER.info("newEndDate={}", newEndDate);
                MainEntityType empPosType = EntityMetadataCache.getDataEntityType((String)"hrpi_empposorgrel");
                DynamicObject empPosInstance = (DynamicObject)empPosType.createInstance();
                DynamicObjectCollection empPosOrgRelCollection = new DynamicObjectCollection((DynamicObjectType)empPosType, null);
                HRDynamicObjectUtils.copy((DynamicObject)originDy, (DynamicObject)empPosInstance);
                empPosOrgRelCollection.add((Object)this.buildDy(newEndDate, "hrpi_empposorgrel", empPosInstance));
                MainEntityType empPosAllType = EntityMetadataCache.getDataEntityType((String)"hrpi_emporgrelall");
                DynamicObject empPosAllInstance = (DynamicObject)empPosAllType.createInstance();
                DynamicObjectCollection empPosAllCollection = new DynamicObjectCollection((DynamicObjectType)empPosAllType, null);
                ArrayList<QFilter> empPosAllQFilterList = new ArrayList<QFilter>();
                empPosAllQFilterList.add(new QFilter("depemp", "=", (Object)depempId));
                empPosAllQFilterList.add(QFilterUtil.getCurrentQf());
                DynamicObject empPosAllDy = empPosAllHelper.loadDynamicObject(empPosAllQFilterList.toArray(new QFilter[0]));
                HRDynamicObjectUtils.copy((DynamicObject)empPosAllDy, (DynamicObject)empPosAllInstance);
                empPosAllCollection.add((Object)this.buildDy(newEndDate, "hrpi_emporgrelall", empPosAllInstance));
                MainEntityType depEmpType = EntityMetadataCache.getDataEntityType((String)"hrpi_depemp");
                DynamicObject depEmpInstance = (DynamicObject)depEmpType.createInstance();
                DynamicObjectCollection depEmpCollection = new DynamicObjectCollection((DynamicObjectType)depEmpType, null);
                ArrayList<QFilter> depEmpFilterList = new ArrayList<QFilter>();
                depEmpFilterList.add(new QFilter("id", "=", (Object)depempId));
                depEmpFilterList.add(QFilterUtil.getCurrentQf());
                DynamicObject depEmpDy = depEmpHelper.loadDynamicObject(depEmpFilterList.toArray(new QFilter[0]));
                HRDynamicObjectUtils.copy((DynamicObject)depEmpDy, (DynamicObject)depEmpInstance);
                depEmpCollection.add((Object)this.buildDy(newEndDate, "hrpi_depemp", depEmpInstance));
                MainEntityType erManFileType = EntityMetadataCache.getDataEntityType((String)"hspm_ermanfile");
                DynamicObject erManFileInstance = (DynamicObject)erManFileType.createInstance();
                DynamicObjectCollection erManFileCollection = new DynamicObjectCollection((DynamicObjectType)erManFileType, null);
                ArrayList<QFilter> erManFileFilterList = new ArrayList<QFilter>();
                erManFileFilterList.add(new QFilter("empposrel", "=", (Object)id));
                erManFileFilterList.add(QFilterUtil.getCurrentQf());
                DynamicObject manFileDy = CachedLoadReferenceObjectManagerHelper.disabledCache(() -> manFileServiceHelper.loadDynamicObject(erManFileFilterList.toArray(new QFilter[0])));
                HRDynamicObjectUtils.copy((DynamicObject)manFileDy, (DynamicObject)erManFileInstance);
                erManFileCollection.add((Object)this.buildDy(newEndDate, "hspm_ermanfile", erManFileInstance));
                Map<String, Object> paramMap = this.buildDatasByCollection(empPosOrgRelCollection, empPosAllCollection, depEmpCollection, erManFileCollection);
                Map<String, Object> result = null;
                try {
                    result = this.personGenericService.saveBatch(paramMap);
                }
                catch (Exception exception) {
                    LOGGER.error("personGenericService.saveBatch is exception:", (Throwable)exception);
                }
                LOGGER.info("personGenericService.saveBatch#result={}", result);
                reviseCoreData.remove("enddate");
            }
            this.updateReviseData("hrpi_empposorgrel", id, reviseCoreData);
            this.updateReviseData("hrpi_depemp", depempId, reviseCoreData);
            this.updateEmpPosOrgRelAllData(depempId, reviseCoreData);
            this.invokeSyncPersonToSysUer(personId);
            HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
            requestMap.put("personId", personId);
            requestMap.put("employeeId", employeeId);
            requestMap.put("cmpEmpId", cmpEmpId);
            requestMap.put("depEmpId", depempId);
            requestMap.put("actionId", HRPIMsgConstants.ACTIONID_ATTACHREVISION);
            requestMap.put("bsed", System.currentTimeMillis());
            if (reviseCoreData.containsKey("adminorg")) {
                requestMap.put("billNo", String.valueOf(id).concat("#adm"));
            } else {
                requestMap.put("billNo", String.valueOf(id));
            }
            requestMap.put("billSource", entityName);
            requestMap.put("resultCallBackQueue", HRPI_ATTACHREVISION_QUEUE);
            ArrayList dataRowList = new ArrayList();
            HashMap dataRowMap = new HashMap();
            HashMap<String, Object> dataRowEntityMap = new HashMap<String, Object>(16);
            ArrayList<HashMap<String, Object>> dataRowEntityList = new ArrayList<HashMap<String, Object>>();
            dataRowEntityMap.put("idBefore", id);
            dataRowEntityMap.put("vidBefore", id);
            dataRowEntityMap.put("idAfter", id);
            dataRowEntityMap.put("vidAfter", id);
            dataRowEntityMap.put("flowType", CORE_FIELD_TYPE);
            dataRowEntityMap.put("chgMode", CORE_FIELD_TYPE);
            dataRowEntityList.add(dataRowEntityMap);
            dataRowMap.put(entityName, dataRowEntityList);
            dataRowList.add(dataRowMap);
            requestMap.put("dataRow", dataRowList);
            AttachRevisionServiceImpl.sendMsg(SerializationUtils.toJsonString(requestMap));
        }
        return HRPIOperationServiceImpl.getSuccess("revise is success");
    }

    private DynamicObject buildDy(Object endDate, String page, DynamicObject instance) {
        instance.set("id", (Object)ORM.create().genLongId(page));
        instance.set("enddate", endDate);
        instance.set("bsed", endDate);
        instance.set("bsled", (Object)HRBaseUtils.getMaxEndDate());
        return instance;
    }

    private Map<String, Object> getStringObjectMap(Map<String, Object> reviseCoreData, long adminOrgId, long personId, Date startDate, Date endDate, List<Map<String, Object>> addDarkPosParam, Map<String, Object> posParam, Map<String, Object> specialData) {
        if (reviseCoreData.containsKey("stdposition")) {
            long stdpositionId = (Long)reviseCoreData.get("stdposition");
            posParam.put("standardposition", stdpositionId);
        } else {
            long jobId = (Long)reviseCoreData.get("job");
            posParam.put("job", jobId);
            specialData.put("stdposition", jobId);
        }
        posParam.put("org", adminOrgId);
        posParam.put("effect", startDate);
        posParam.put("bsled", endDate);
        posParam.put("user", personId);
        addDarkPosParam.add(posParam);
        Map darkPosResult = null;
        darkPosResult = reviseCoreData.containsKey("stdposition") ? (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IStandardPositionService", (String)"addDarkPosition", (Object[])new Object[]{addDarkPosParam}) : (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IStandardPositionService", (String)"addDarkPositionByJob", (Object[])new Object[]{addDarkPosParam});
        if (!HRMapUtils.isEmpty((Map)darkPosResult)) {
            if (success.equals(darkPosResult.get("code"))) {
                List darkPosList = (List)darkPosResult.get("data");
                if (CollectionUtils.isNotEmpty((Collection)darkPosList)) {
                    for (Map item : darkPosList) {
                        if (!((Boolean)item.get("isSuccess")).booleanValue()) {
                            String msg = (String)item.get("errorMsg");
                            return HRPIOperationServiceImpl.getFail(ResManager.loadKDString((String)"\u751f\u6210\u6697\u5c97\u5931\u8d25:%s", (String)"AttachRevisionServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[]{msg}));
                        }
                        specialData.put("position", item.get("position"));
                        specialData.put("darkposition", item.get("position"));
                    }
                }
            } else {
                LOGGER.error("called IStandardPositionService.addDarkPosition or addDarkPositionByJob is exception:{}", (Object)JSONObject.toJSONString((Object)darkPosResult));
                return HRPIOperationServiceImpl.getFail("called IStandardPositionService.addDarkPosition or addDarkPositionByJob is exception");
            }
        }
        return darkPosResult;
    }

    private static void sendMsg(String msg) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("hr", HPFS_CHGEXTERNALRECORD_QUEUE);){
            pub.publish(msg);
        }
    }

    private void invokeSyncPersonToSysUer(long personId) {
        ArrayList<Map<String, Object>> userList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> temp = new HashMap<String, Object>(16);
        temp.put("personid", personId);
        temp.put("synctype", "update");
        userList.add(temp);
        Map<String, Object> result = HRPIOperationServiceImpl.getInstance().syncPersonToSysUer(userList);
        LOGGER.info("invokeSyncPersonToSysUer#result={}", result);
    }

    private void updateReviseData(String entityName, long id, Map<String, Object> reviseData) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter("boid", "=", (Object)id));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        try {
            Object[] reviseDys = serviceHelper.loadDynamicObjectArray(qFilterList.toArray(new QFilter[0]));
            if (HRArrayUtils.isNotEmpty((Object[])reviseDys)) {
                for (Object reviseDy : reviseDys) {
                    reviseData.forEach((arg_0, arg_1) -> AttachRevisionServiceImpl.lambda$updateReviseData$3(properties, (DynamicObject)reviseDy, arg_0, arg_1));
                }
                serviceHelper.updateDatas((DynamicObject[])reviseDys);
            }
        }
        catch (Exception exception) {
            LOGGER.error("updateReviseData is exception:", (Throwable)exception);
        }
    }

    private void updateEmpPosOrgRelAllData(long depempId, Map<String, Object> reviseData) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_emporgrelall");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter("depemp", "=", (Object)depempId));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"hrpi_emporgrelall");
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        try {
            Object[] empposDys = serviceHelper.loadDynamicObjectArray(qFilterList.toArray(new QFilter[0]));
            if (HRArrayUtils.isNotEmpty((Object[])empposDys)) {
                for (Object emp : empposDys) {
                    reviseData.forEach((arg_0, arg_1) -> AttachRevisionServiceImpl.lambda$updateEmpPosOrgRelAllData$4(properties, (DynamicObject)emp, arg_0, arg_1));
                }
                serviceHelper.updateDatas((DynamicObject[])empposDys);
            }
        }
        catch (Exception exception) {
            LOGGER.error("updateEmpPosOrgRelAllData is exception:", (Throwable)exception);
        }
    }

    protected Map<String, Object> buildDatasByCollection(DynamicObjectCollection ... collections) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        ArrayList datas = Lists.newArrayListWithExpectedSize((int)collections.length);
        for (DynamicObjectCollection collection : collections) {
            if (CollectionUtils.isEmpty((Collection)collection)) continue;
            HashMap item = Maps.newHashMapWithExpectedSize((int)1);
            item.put("hisDyns", collection);
            datas.add(item);
        }
        paramMap.put("data", datas);
        paramMap.put("caller", "revise");
        paramMap.put("mustAllSuccess", false);
        Long eventId = ORM.create().genLongId("hrpi_event");
        paramMap.put("eventId", eventId);
        return paramMap;
    }

    private static /* synthetic */ void lambda$updateEmpPosOrgRelAllData$4(DataEntityPropertyCollection properties, DynamicObject emp, String property, Object value) {
        if (properties.containsKey((Object)property)) {
            if (SPECIALFIELD_MAP.containsKey(property)) {
                if (value != null) {
                    DynamicObject basicInfo = BusinessDataServiceHelper.loadSingle((Object)value, (String)SPECIALFIELD_MAP.get(property));
                    if (basicInfo != null) {
                        emp.set(property, (Object)basicInfo.getString("name"));
                    }
                } else {
                    LOGGER.info("updateEmpPosOrgRelAllData#property={}", (Object)property);
                    emp.set(property, (Object)"");
                }
            } else {
                emp.set(property, value);
            }
        }
    }

    private static /* synthetic */ void lambda$updateReviseData$3(DataEntityPropertyCollection properties, DynamicObject reviseDy, String property, Object value) {
        if (properties.containsKey((Object)property)) {
            reviseDy.set(property, value);
        }
    }

    static {
        success = 200;
        SPECIALFIELD_MAP = new HashMap<String, String>(16);
        SPECIALFIELD_MAP.put("postype", "hbss_postype");
        SPECIALFIELD_MAP.put("position", "hbpm_positionhr");
        SPECIALFIELD_MAP.put("adminorg", "haos_adminorghr");
        SPECIALFIELD_MAP.put("variationtype", "hbss_actiontype");
        SPECIALFIELD_MAP.put("company", "haos_adminorghr");
        SPECIALFIELD_MAP.put("stdposition", "hbpm_stposition");
        SPECIALFIELD_MAP.put("job", "hbjm_jobhr");
        depEmpHelper = new HRBaseServiceHelper("hrpi_depemp");
        empPosAllHelper = new HRBaseServiceHelper("hrpi_emporgrelall");
        manFileServiceHelper = new HRBaseServiceHelper("hspm_ermanfile");
    }
}

