/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.attachrevision.mq.consumer;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hrpi.common.HRPIMsgConstants;

public class AttachRevisionConsumer
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(AttachRevisionConsumer.class);

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        LOGGER.info(MessageFormat.format("{0} message is {1}", "kd.hrmp.hrpi.attachrevision.queue", message));
        try {
            Map result = (Map)SerializationUtils.fromJsonString((String)((String)message), Map.class);
            Boolean success = (Boolean)result.get("success");
            if (!success.booleanValue()) {
                LOGGER.info(MessageFormat.format("{0} msg is {1}", "kd.hrmp.hrpi.attachrevision.queue", result.get("msg")));
                return;
            }
            Map dataMap = (Map)result.get("data");
            Long recordId = (Long)dataMap.get("recordId");
            Map<String, Object> messageContent = this.getMessageContent(recordId);
            String msgTitle = this.parseMsgTitle((Long)dataMap.get("personId"));
            this.sendReviseMsg(messageContent, recordId, msgTitle);
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
    }

    private String parseMsgTitle(Long personId) {
        DynamicObject hpfsChgactionDy;
        String name = "";
        DynamicObject dynamicObject = HRBaseServiceHelper.create((String)"hrpi_person").queryOne("name", (Object)personId);
        if (!HRObjectUtils.isEmpty((Object)dynamicObject)) {
            name = dynamicObject.getString("name");
        }
        if (!HRObjectUtils.isEmpty((Object)(hpfsChgactionDy = BusinessDataServiceHelper.loadSingle((Object)HRPIMsgConstants.ACTIONID_ATTACHREVISION, (String)"hpfs_chgaction")))) {
            String hpfsChgactionName = hpfsChgactionDy.getString("name");
            name = name + hpfsChgactionName;
        }
        return name;
    }

    private void sendReviseMsg(Map<String, Object> messageContent, Long recordId, String msgTitle) {
        HashMap<String, Object> messageParams = new HashMap<String, Object>(16);
        messageParams.put("msgNumber", String.format("%1$s_%2$s", recordId, System.nanoTime()));
        messageParams.put("msgPubNo", "MP20230826001101");
        messageParams.put("msgTitle", msgTitle);
        messageParams.put("actionId", HRPIMsgConstants.ACTIONID_ATTACHREVISION);
        messageParams.put("senderId", RequestContext.get().getCurrUserId());
        messageParams.put("sendTime", new Date());
        messageParams.put("params", SerializationUtils.serializeToBase64(messageContent));
        LOGGER.info(String.format("sendReviseMsg#messageParams:%s", JSONObject.toJSONString(messageParams)));
        HRProducerServiceHelper.publishAction(messageParams);
    }

    private Map<String, Object> getMessageContent(Long recordId) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("affactionId", HRPIMsgConstants.ACTIONID_ATTACHREVISION);
        params.put("chgcategoryId", HRPIMsgConstants.ACTIONID_ATTACHREVISION);
        params.put("recordId", recordId);
        return params;
    }
}

