/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.inte.api.IInteService;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.api.HisBatchDiscardApiBo;
import kd.hr.hbp.business.domain.model.newhismodel.api.HisDiscardApiBo;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.application.impl.ApplyApplicationImpl;
import kd.hrmp.hrpi.business.domian.builder.EmpNonEntBuilder;
import kd.hrmp.hrpi.business.domian.builder.ErManFileBuilder;
import kd.hrmp.hrpi.business.domian.repository.HRPICmpempRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIManFileRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.business.domian.service.IApplyService;
import kd.hrmp.hrpi.business.domian.service.impl.PersonServiceImpl;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.business.tools.ComparePropertyUtil;
import kd.hrmp.hrpi.common.HRPIPageConstants;
import kd.hrmp.hrpi.common.HRPIValueConstants;
import kd.hrmp.hrpi.common.IRPCConstants;
import kd.hrmp.hrpi.common.generic.result.PersonGenericResult;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ApplyServiceImpl
implements IApplyService {
    private static final Log LOG = LogFactory.getLog(ApplyServiceImpl.class);
    private static volatile IApplyService APPLYSERVICE;
    private static final String TRUE_NUMBER_ONE = "1";
    private Map<String, Map<String, Object>> companyResult = null;
    private static final Set<String> LOCK_PROP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IApplyService getInstance() {
        try {
            if (null != APPLYSERVICE) return APPLYSERVICE;
            Class<ApplyServiceImpl> clazz = ApplyServiceImpl.class;
            synchronized (ApplyServiceImpl.class) {
                if (null != APPLYSERVICE) return APPLYSERVICE;
                try {
                    APPLYSERVICE = new ApplyServiceImpl();
                    LOG.info("HRPIServiceFactory-dependency-check,new-ApplyServiceImpl()-success");
                }
                catch (Throwable t) {
                    LOG.error("HRPIServiceFactory-dependency-check,new-ApplyServiceImpl()-fail", t);
                }
                return APPLYSERVICE;
            }
        }
        catch (Throwable t) {
            LOG.error("HRPIServiceFactory-dependency-check,ApplyServiceImpl-getInstance()-fail", t);
        }
        return APPLYSERVICE;
    }

    @Override
    public void createPersonDys(Map<String, DynamicObjectCollection> dyColl, Map<String, Object> param) {
        Map info = (Map)param.get("baseinfo");
        if (info != null && !info.isEmpty()) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"hrpi_person");
            DynamicObject baseInstance = (DynamicObject)dataEntityType.createInstance();
            for (Map.Entry<String, Object> entry : info.entrySet()) {
                if (((String)entry.getKey()).equals("empposorgrels")) continue;
                this.setLocalProp(dataEntityType, baseInstance, entry);
            }
            this.setIdProp("hrpi_person", baseInstance, info);
            if (param.containsKey("samePersonId") && ((Boolean)param.get("samePersonId")).booleanValue() && this.needToFillBoId(baseInstance, param.get("hrpi_person"), (Collection<String>)ImmutableList.of((Object)"name", (Object)"number"))) {
                param.put("personChanged", true);
                baseInstance.set("id", (Object)ORM.create().genLongId("hrpi_person"));
                baseInstance.set("boid", ((DynamicObject)param.get("hrpi_person")).get("boid"));
            }
            if (!param.containsKey("samePersonId") || param.containsKey("samePersonId") && !((Boolean)param.get("samePersonId")).booleanValue() || param.containsKey("personChanged") && ((Boolean)param.get("personChanged")).booleanValue()) {
                this.wrapCommonProp(baseInstance);
                this.addMap("hrpi_person", baseInstance, dyColl);
            }
        }
    }

    @Override
    public Map<String, DynamicObjectCollection> updatePersonDys(List<Map<String, Object>> personInfoList) {
        HashMap<String, DynamicObjectCollection> result = new HashMap<String, DynamicObjectCollection>(16);
        try {
            HashSet<Long> personIds = new HashSet<Long>(personInfoList.size());
            personInfoList.forEach(employee -> personIds.add((Long)employee.get("person")));
            Map<String, Map<Long, DynamicObject>> personMap = HRPIPersonRepository.loadPersonInfo(personIds);
            if (personMap.isEmpty()) {
                LOG.info("updatePersonDys get empty object : {}", (Object)JSONObject.toJSONString(personIds));
                return result;
            }
            for (String personEntity : HRPIPageConstants.PERSONENTITYS) {
                String key = personEntity.equalsIgnoreCase("hrpi_person") || personEntity.equalsIgnoreCase("hspm_ermanfile") ? "baseinfo" : personEntity.split("_")[1];
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)personEntity);
                Map<Long, DynamicObject> personDys = personMap.get(personEntity);
                personInfoList.stream().filter(person -> person.get(key) != null && ((Map)person.get(key)).size() > 0).forEach(person -> {
                    DynamicObject personDy;
                    Long personId = (Long)person.get("person");
                    Map paramMap = (Map)person.get(key);
                    DynamicObject dynamicObject = personDy = null != personDys ? (DynamicObject)personDys.get(personId) : null;
                    if (this.isModify(paramMap, personDy, personEntity)) {
                        ApplyApplicationImpl.PER_ID_List_TL.get().add(personId);
                    }
                    if (key.equals("hrpi_pernontsprop")) {
                        paramMap.put("name", person.get("name"));
                    }
                    if (null != personDy) {
                        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                            if (LOCK_PROP.contains(entry.getKey())) continue;
                            this.setLocalProp(entityType, personDy, entry);
                        }
                        DynamicObject instance = (DynamicObject)entityType.createInstance();
                        HRDynamicObjectUtils.copy((DynamicObject)personDy, (DynamicObject)instance);
                        instance.set("id", (Object)new ORMImpl().genLongId(personEntity));
                        if ("hrpi_pertsprop".equals(personEntity)) {
                            instance.set("bsed", (Object)new Date());
                        }
                        this.addMap(personEntity, instance, result);
                    } else {
                        if (personEntity.equalsIgnoreCase("hrpi_pertsprop")) {
                            this.createPersonAttachDys("pertsprop", (Map<String, DynamicObjectCollection>)result, (Map<String, Object>)person);
                        }
                        if (personEntity.equalsIgnoreCase("hrpi_perregion")) {
                            this.createPersonAttachDys("perregion", (Map<String, DynamicObjectCollection>)result, (Map<String, Object>)person);
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            LOG.error("updateDys getDynamic error", (Throwable)ex);
            throw new KDBizException(" packed data error ");
        }
        return result;
    }

    private boolean isModify(Map<String, Object> param, DynamicObject dbDy, String prop) {
        if ("hrpi_percontact".equals(prop)) {
            String phoneNumber = dbDy.getString("phone");
            String newPhone = (String)param.get("phone");
            String peremail = dbDy.getString("peremail");
            String newPeremail = (String)param.get("peremail");
            String workPhone = dbDy.getString("workphone");
            String newWorkPhone = (String)param.get("workphone");
            return param.containsKey("phone") && !StringUtil.equals((String)newPhone, (String)phoneNumber) || param.containsKey("peremail") && !StringUtil.equals((String)peremail, (String)newPeremail) || param.containsKey("workphone") && !StringUtil.equals((String)workPhone, (String)newWorkPhone);
        }
        if ("hrpi_person".equals(prop)) {
            String name = dbDy.getString("name");
            String newName = (String)param.get("name");
            return param.containsKey("name") && !StringUtil.equals((String)newName, (String)name);
        }
        if ("hrpi_pernontsprop".equals(prop)) {
            Date birthDay = dbDy.getDate("birthday");
            Date newBirthDay = (Date)param.get("birthday");
            Long gender = (Long)dbDy.get("gender.id");
            Long newGender = (Long)param.get("gender");
            String headSculpture = dbDy.getString("headsculpture");
            String newHeadSculpture = (String)param.get("headsculpture");
            return Objects.equals(gender, newGender) || param.containsKey("birthday") && !this.isDateSame(birthDay, newBirthDay) || param.containsKey("headsculpture") && !StringUtil.equals((String)headSculpture, (String)newHeadSculpture);
        }
        return false;
    }

    private boolean isDateSame(Date date, Date newDate) {
        return date == null ? newDate == null : newDate != null && DateUtil.dayEquals(date, newDate);
    }

    @Override
    public long createPersonAttachDys(String key, Map<String, DynamicObjectCollection> dyColl, Map<String, Object> param) {
        String entityName = "hrpi_" + key;
        Map baseInfo = (Map)param.get("baseinfo");
        Map info = (Map)param.get(key);
        long entityId = 0L;
        if (info != null && !info.isEmpty()) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            DynamicObject instance = (DynamicObject)dataEntityType.createInstance();
            if (param.get(entityName) != null) {
                HRDynamicObjectUtils.copy((DynamicObject)((DynamicObject)param.get(entityName)), (DynamicObject)instance);
            }
            for (Map.Entry<String, Object> entry : info.entrySet()) {
                this.setLocalProp(dataEntityType, instance, entry);
            }
            instance.set("person", baseInfo.get("person"));
            if (entityName.equals("hrpi_percontact") && HRStringUtils.isEmpty((String)instance.getString("phone"))) {
                instance.set("phone", baseInfo.get("phone"));
                info.put("phone", baseInfo.get("phone"));
            }
            if (entityName.equals("hrpi_pernontsprop")) {
                instance.set("name", baseInfo.get("name"));
                info.put("name", baseInfo.get("name"));
            }
            if ("hrpi_pertsprop".equals(entityName)) {
                Date startDate = (Date)baseInfo.get("startdate");
                instance.set("bsed", (Object)(startDate != null ? startDate : new Date()));
                info.put("bsed", startDate != null ? startDate : new Date());
            }
            this.setIdProp(entityName, instance, baseInfo);
            this.wrapCommonProp(instance);
            Collection<String> properties = this.getAllProperties(entityName);
            properties.remove("boid");
            boolean bl = ComparePropertyUtil.instanceNotEqSysObj(instance, param.get(entityName), properties);
            if (bl) {
                this.addMap(entityName, instance, dyColl);
            }
            entityId = instance.getLong("id");
        }
        return entityId;
    }

    private Collection<String> getAllProperties(String entityName) {
        Set<String> properties = EntityMetadataCache.getDataEntityType((String)entityName).getAllFields().keySet();
        properties.removeAll(IRPCConstants.IGNORE_SET);
        return properties;
    }

    private boolean needToFillBoId(DynamicObject newObj, Object sysObj, Collection<String> properties) {
        AtomicBoolean b = new AtomicBoolean(false);
        if (sysObj == null) {
            return b.get();
        }
        properties.forEach(pro -> {
            if (newObj.containsProperty(pro) && ComparePropertyUtil.needBeCovered(((DynamicObject)sysObj).get(pro), newObj.get(pro))) {
                newObj.set(pro, ((DynamicObject)sysObj).get(pro));
                if (!b.get()) {
                    LOG.info("match data changed , the entity is {} , the property is {} ", (Object)((DynamicObject)sysObj).getDataEntityType().getName(), pro);
                    b.set(true);
                }
            }
        });
        return b.get();
    }

    @Override
    public Map<String, Long> createDepempDys(Map<String, DynamicObjectCollection> dyColl, long empTrelId, long nonPropId, Map<String, Object> param) {
        Map baseInfo = (Map)param.get("baseinfo");
        List empposorgrels = (List)baseInfo.get("empposorgrels");
        HashMap idMap = Maps.newHashMapWithExpectedSize((int)8);
        long emporgId = 0L;
        if (empposorgrels != null) {
            HashSet<Long> adminOrgIds = new HashSet<Long>(empposorgrels.size());
            HashSet<Long> positionIds = new HashSet<Long>(empposorgrels.size());
            HashSet<Long> stdPositionIds = new HashSet<Long>(empposorgrels.size());
            HashSet labAndPosTypes = Sets.newHashSetWithExpectedSize((int)empposorgrels.size());
            empposorgrels.forEach(emp -> {
                Long stdPositionId;
                Long adminOrgId = (Long)emp.get("adminorg");
                Long positionId = (Long)emp.get("position");
                adminOrgIds.add(adminOrgId);
                if (positionId != null) {
                    positionIds.add(positionId);
                }
                if (Objects.nonNull(stdPositionId = (Long)emp.get("stdposition"))) {
                    stdPositionIds.add(stdPositionId);
                }
                Long labTypeId = (Long)baseInfo.get("laborreltype");
                Long posTypeId = (Long)emp.get("postype");
                labAndPosTypes.add(String.join((CharSequence)"_", String.valueOf(labTypeId), String.valueOf(posTypeId)));
            });
            Map<Long, Long> hrBuMap = this.queryBuByAdminOrg(adminOrgIds);
            this.queryOrgAndPosInfo(adminOrgIds, positionIds, stdPositionIds);
            Map<String, Long> fileTypeMaps = HRPIManFileRepository.getFileTypeByLabAndPosType(labAndPosTypes);
            Iterator iterator = empposorgrels.iterator();
            while (iterator.hasNext()) {
                Map empposorgrel;
                boolean isPrimary = (Boolean)(empposorgrel = (Map)iterator.next()).get("isprimary");
                empposorgrel.put("isprimary", isPrimary ? TRUE_NUMBER_ONE : "0");
                Long positionId = (Long)empposorgrel.get("position");
                long jobId = 0L;
                if (empposorgrel.get("job") != null) {
                    jobId = (Long)empposorgrel.get("job");
                }
                for (String depemp : HRPIPageConstants.DEPEMPENTITYS) {
                    DynamicObject dynamicObject;
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)depemp);
                    DynamicObject baseInstance = (DynamicObject)dataEntityType.createInstance();
                    for (Map.Entry<String, Object> entry : empposorgrel.entrySet()) {
                        this.setLocalProp(dataEntityType, baseInstance, entry);
                    }
                    baseInstance.set("employee", baseInfo.get("employee"));
                    baseInstance.set("cmpemp", baseInfo.get("cmpemp"));
                    baseInstance.set("person", baseInfo.get("person"));
                    Long depempId = (Long)baseInfo.get("depemp");
                    if (dataEntityType.findProperty("depemp") != null) {
                        baseInstance.set("depemp", (Object)depempId);
                    }
                    this.setIdProp(depemp, baseInstance, baseInfo);
                    if (depemp.equals("hrpi_empposorgrel")) {
                        emporgId = baseInstance.getLong("id");
                        Long l = (Long)empposorgrel.get("adminorg");
                        Long companyId = Optional.ofNullable(this.companyResult).map(result -> (Map)result.get(String.valueOf(adminOrgId))).map(item -> (Long)item.get("belongcompany")).orElse(0L);
                        baseInstance.set("company", (Object)companyId);
                    }
                    if (depemp.equalsIgnoreCase("hrpi_depemp") || depemp.equalsIgnoreCase("hrpi_empposorgrel")) {
                        this.setPostionAndJob(positionId, jobId, dataEntityType, baseInstance);
                    }
                    if (depemp.equals("hrpi_personrolerel") && positionId != null && positionId > 0L && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)positionId, (String)"hbpm_positionhr")) != null) {
                        baseInstance.set("role", dynamicObject.get("workrole"));
                        baseInstance.set("mainpeoincharge", dynamicObject.get("workrole.mainpeoincharge"));
                        baseInstance.set("adminorg", dynamicObject.get("workrole.adminorg"));
                    }
                    this.setCommonProp(dataEntityType, baseInstance, empposorgrel);
                    baseInstance.set("businessstatus", (Object)(this.equalsMaxDate(baseInstance.getDate("enddate")) ? TRUE_NUMBER_ONE : "2"));
                    if (depemp.equals("hspm_ermanfile")) {
                        this.createErmanFileDy(empTrelId, nonPropId, param, baseInfo, emporgId, hrBuMap, fileTypeMaps, empposorgrel, baseInstance);
                    }
                    this.wrapCommonProp(baseInstance);
                    this.addMap(depemp, baseInstance, dyColl);
                    if (depemp.equals("hspm_ermanfile")) {
                        this.createQuitErManFile(dyColl, param, baseInstance);
                    }
                    idMap.put(depemp, baseInstance.getLong("id"));
                }
            }
        }
        return idMap;
    }

    private void setPostionAndJob(Long positionId, long jobId, MainEntityType dataEntityType, DynamicObject baseInstance) {
        Long stdPositionId = (Long)baseInstance.get("stdposition");
        if (positionId != null && positionId > 0L) {
            Map<Long, Map<String, Object>> posJobRelMap = ApplyApplicationImpl.TL_POSJOBRELMAP.get();
            if (posJobRelMap != null) {
                Map<String, Object> jobInfo = posJobRelMap.get(positionId);
                if (dataEntityType.findProperty("job") != null) {
                    baseInstance.set("job", Objects.nonNull(jobInfo) ? jobInfo.get("job") : null);
                }
                if (dataEntityType.findProperty("apositiontype") != null) {
                    baseInstance.set("apositiontype", (Object)TRUE_NUMBER_ONE);
                }
            }
        } else if (stdPositionId != null && stdPositionId > 0L) {
            Map<Long, Map<String, Object>> stdPosJobRelMap = ApplyApplicationImpl.TL_STDPOSJOBRELMAP.get();
            if (stdPosJobRelMap != null) {
                Map<String, Object> jobInfo = stdPosJobRelMap.get(stdPositionId);
                if (dataEntityType.findProperty("job") != null) {
                    baseInstance.set("job", Objects.nonNull(jobInfo) ? jobInfo.get("job") : null);
                }
                if (dataEntityType.findProperty("apositiontype") != null) {
                    baseInstance.set("apositiontype", (Object)"0");
                }
            }
        } else if (jobId > 0L && dataEntityType.findProperty("apositiontype") != null) {
            baseInstance.set("apositiontype", (Object)"2");
        }
    }

    private void createErmanFileDy(long empTrelId, long nonPropId, Map<String, Object> param, Map<String, Object> baseInfo, long emporgId, Map<Long, Long> hrBuMap, Map<String, Long> fileTypeMaps, Map<String, Object> empposorgrel, DynamicObject baseInstance) {
        baseInstance.set("name", baseInfo.get("name"));
        baseInstance.set("number", baseInfo.get("number"));
        baseInstance.set("affiliateadminorg", empposorgrel.get("adminorg"));
        baseInstance.set("empgroup", (Object)Long.parseLong("1010"));
        baseInstance.set("ismanaged", (Object)false);
        baseInstance.set("issystem", (Object)true);
        Long labTypeId = (Long)baseInfo.get("laborreltype");
        Long posTypeId = (Long)empposorgrel.get("postype");
        baseInstance.set("filetype", (Object)fileTypeMaps.get(String.join((CharSequence)"_", String.valueOf(labTypeId), String.valueOf(posTypeId))));
        baseInstance.set("empentrel", (Object)empTrelId);
        baseInstance.set("pernontsprop", (Object)nonPropId);
        baseInstance.set("empposrel", (Object)emporgId);
        baseInstance.set("org", (Object)hrBuMap.get(empposorgrel.get("adminorg")));
        baseInstance.set("businessstatus", (Object)(this.equalsMaxDate(baseInstance.getDate("enddate")) ? TRUE_NUMBER_ONE : "-1"));
    }

    private void queryOrgAndPosInfo(Set<Long> adminOrgIds, Set<Long> positionIds, Set<Long> stdPositionIds) {
        List jobs;
        Integer success;
        Map jobInfo;
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(adminOrgIds)) {
            this.companyResult = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"adminOrgInfoQuery", (Object[])new Object[]{new ArrayList<Long>(adminOrgIds), new Date()});
            LOG.info("\u8c03\u7528IHAOSBatchAdminOrgInfoQueryService.adminOrgInfoQuery\u7ed3\u679c:{}", (Object)JSONObject.toJSONString(this.companyResult));
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(positionIds)) {
            jobInfo = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IPositionService", (String)"queryPosition", (Object[])new Object[]{new ArrayList<Long>(positionIds)});
            success = 200;
            LOG.info("\u8c03\u7528IPositionService.queryPosition\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)jobInfo));
            if (success.equals(jobInfo.get("code"))) {
                jobs = (List)jobInfo.get("data");
                HashMap posJobRelMap = Maps.newHashMapWithExpectedSize((int)jobs.size());
                jobs.forEach(item -> posJobRelMap.put((Long)item.get("id"), item));
                ApplyApplicationImpl.TL_POSJOBRELMAP.set(posJobRelMap);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u201cIPositionService.queryPosition\u201d\u5f02\u5e38\u3002", (String)"HRPICommonDepInitService_8", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(stdPositionIds)) {
            jobInfo = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IStandardPositionQueryService", (String)"queryStandardPosition", (Object[])new Object[]{new ArrayList<Long>(stdPositionIds)});
            success = 200;
            LOG.info("\u8c03\u7528IStandardPositionQueryService.queryStandardPosition\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)jobInfo));
            if (success.equals(jobInfo.get("code"))) {
                jobs = (List)jobInfo.get("data");
                HashMap stdPosJobRelMap = Maps.newHashMapWithExpectedSize((int)jobs.size());
                jobs.forEach(item -> stdPosJobRelMap.put((Long)item.get("id"), item));
                ApplyApplicationImpl.TL_STDPOSJOBRELMAP.set(stdPosJobRelMap);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"IStandardPositionQueryService.queryStandardPosition\u5f02\u5e38\u3002", (String)"HRPICommonDepInitService_10", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
    }

    private Map<Long, Long> queryBuByAdminOrg(Set<Long> adminOrgIds) {
        HashMap<Long, Long> adminOrgBuRel = new HashMap<Long, Long>(adminOrgIds.size());
        HashMap orgId2BusinessType = Maps.newHashMapWithExpectedSize((int)adminOrgIds.size());
        HashSet businessTypeSet = Sets.newHashSetWithExpectedSize((int)1);
        businessTypeSet.add(HRPIValueConstants.BUSINESS_HR);
        for (Long adminOrgId : adminOrgIds) {
            orgId2BusinessType.put(adminOrgId, businessTypeSet);
        }
        List buResult = (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"getHrBuByBusinessType", (Object[])new Object[]{orgId2BusinessType, HRPIValueConstants.BUS_OBJ_TYPE_EMP});
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)buResult)) {
            LOG.info("\u8c03\u7528IHRCSStrategyService.getHrBuByBusinessType\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)buResult));
            for (Map bu : buResult) {
                adminOrgBuRel.put((Long)bu.get("adminOrgId"), (Long)bu.get("hrBuId"));
            }
        }
        return adminOrgBuRel;
    }

    @Override
    public Map<String, DynamicObjectCollection> updateAndAddDepempDys(List<Long> personIdList, List<Long> depempList, Map<String, Map<String, Long>> employeeIdMap, List<Map<String, Object>> addDepList, List<Map<String, Object>> updateDepList) {
        int size = addDepList.size() + updateDepList.size();
        HashMap<String, DynamicObjectCollection> result = new HashMap<String, DynamicObjectCollection>(16);
        List<DynamicObject> nonPersonList = PersonServiceImpl.getInstance().listBatchPropPersonAttachs(personIdList, "id,person,person.number,person.name", null, "hrpi_pernontsprop");
        HashMap nameMap = new HashMap(personIdList.size());
        nonPersonList.forEach(nonp -> {
            String number = nonp.getString("person.number");
            Map idMap = (Map)employeeIdMap.get(number);
            if (null != idMap) {
                Long nonPersonId = nonp.getLong("id");
                idMap.put("pernontsprop", nonPersonId);
                nameMap.put(nonPersonId, nonp.getString("person.name"));
            }
        });
        if (!updateDepList.isEmpty()) {
            Map<String, Map<Long, DynamicObject>> depeMap = HRPIDepempRepository.loadDepempInfo(new HashSet<Long>(depempList));
            updateDepList.forEach(emp -> {
                Long depempId = (Long)emp.get("depemp");
                Object isPrim = emp.get("isprimary");
                if (Objects.nonNull(isPrim)) {
                    Boolean isPrimary = this.getBoolean(isPrim);
                    emp.put("isprimary", isPrimary != false ? TRUE_NUMBER_ONE : "0");
                }
                for (String dempEntity : HRPIPageConstants.DEPEMPENTITYS) {
                    Map depempDys = (Map)depeMap.get(dempEntity);
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)dempEntity);
                    DynamicObject dy = (DynamicObject)depempDys.get(depempId);
                    if (StringUtils.equals((CharSequence)"hrpi_empposorgrel", (CharSequence)dempEntity) && this.isDarkPositionModify((Map<String, Object>)emp, dy).booleanValue()) {
                        if (Objects.isNull(ApplyApplicationImpl.DARK_POS_ID_List_TL.get())) {
                            ApplyApplicationImpl.DARK_POS_ID_List_TL.set(Maps.newHashMapWithExpectedSize((int)updateDepList.size()));
                        }
                        ApplyApplicationImpl.DARK_POS_ID_List_TL.get().put(depempId, dy.getLong("position.id"));
                    }
                    for (Map.Entry<String, Object> entry : emp.entrySet()) {
                        if (LOCK_PROP.contains(entry.getKey())) continue;
                        this.setLocalProp(entityType, dy, entry);
                    }
                    Date endDate = dy.getDate("enddate");
                    if (!this.equalsMaxDate(endDate)) {
                        dy.set("businessstatus", (Object)"2");
                    } else {
                        dy.set("businessstatus", (Object)TRUE_NUMBER_ONE);
                    }
                    if (dempEntity.equals("hspm_ermanfile")) {
                        dy.set("businessstatus", (Object)(this.equalsMaxDate(dy.getDate("enddate")) ? TRUE_NUMBER_ONE : "-1"));
                    }
                    this.setIsLatestRecord(dempEntity, dy, (Map)employeeIdMap.get((String)emp.get("number")));
                    DynamicObject dynamicObject = (DynamicObject)entityType.createInstance();
                    DynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)dynamicObject);
                    this.setNullForDarkPosition(depempId, dempEntity, dynamicObject);
                    dynamicObject.set("id", (Object)new ORMImpl().genLongId(dempEntity));
                    this.addMap(dempEntity, dynamicObject, result);
                    this.buildIdMap(dempEntity, size, (Long)dynamicObject.get("id"), depempId);
                }
            });
        }
        if (!addDepList.isEmpty()) {
            List<Map<String, Object>> subAddList = addDepList.stream().filter(dept -> dept.get("cmpemp") == null).collect(Collectors.toList());
            Map<Long, DynamicObject> depCmpRelMap = this.buildDepCmpRelMap(subAddList);
            addDepList.forEach(emp -> {
                String number = (String)emp.get("number");
                Map idMaps = (Map)employeeIdMap.get(number);
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                HashMap baseInfo = new HashMap(16);
                baseInfo.put("person", idMaps.get("person"));
                baseInfo.put("employee", idMaps.get("employee"));
                Long depId = (Long)emp.get("depemp");
                baseInfo.put("depemp", depId);
                baseInfo.put("laborreltype", idMaps.get("laborreltype"));
                Long cmpId = emp.get("cmpemp") != null ? (Long)emp.get("cmpemp") : (Long)Optional.ofNullable(depCmpRelMap.get(depId)).map(obj -> obj.get("id")).orElse(0L);
                baseInfo.put("cmpemp", cmpId);
                Long nonPersonId = (Long)idMaps.get("pernontsprop");
                baseInfo.put("number", number);
                baseInfo.put("name", nameMap.get(nonPersonId));
                baseInfo.put("empposorgrels", Collections.singletonList(emp));
                param.put("baseinfo", baseInfo);
                Map<String, Long> idMap = this.createDepempDys(result, (Long)idMaps.get("empentrel"), nonPersonId, param);
                for (Map.Entry<String, Long> entry : idMap.entrySet()) {
                    this.buildIdMap(entry.getKey(), size, entry.getValue(), depId);
                }
            });
        }
        return result;
    }

    private void setIsLatestRecord(String entityName, DynamicObject dy, Map<String, Long> idMaps) {
        if (!"hrpi_empposorgrel".equals(entityName)) {
            return;
        }
        if (dy.getBoolean("islatestrecord")) {
            return;
        }
        Long labRelStatusPrdId = null;
        if (idMaps != null) {
            labRelStatusPrdId = idMaps.get("labrelstatusprd_id");
        }
        if (HRPIValueConstants.LABRELSTATUSPRD_END.equals(labRelStatusPrdId)) {
            dy.set("islatestrecord", (Object)Boolean.TRUE);
        }
    }

    private void setNullForDarkPosition(Long depempId, String dempEntity, DynamicObject instance) {
        Map darkPosIdMap;
        if ((dempEntity.equals("hrpi_depemp") || dempEntity.equals("hrpi_empposorgrel")) && (darkPosIdMap = (Map)ApplyApplicationImpl.DARK_POS_ID_List_TL.get()) != null && darkPosIdMap.containsKey(depempId)) {
            instance.set("position", (Object)0L);
            instance.set("position_id", (Object)0L);
        }
    }

    private Boolean isDarkPositionModify(Map<String, Object> newDep, DynamicObject oldDep) {
        if (StringUtils.equals((CharSequence)TRUE_NUMBER_ONE, (CharSequence)oldDep.getString("apositiontype"))) {
            return false;
        }
        Long newStdPosId = (Long)newDep.get("stdposition");
        Long newJobId = (Long)newDep.get("job");
        Long newAdminOrgId = (Long)newDep.get("adminorg");
        if (Objects.nonNull(newStdPosId) && !newStdPosId.equals(oldDep.get("stdposition.id"))) {
            return true;
        }
        if (Objects.nonNull(newJobId) && !newJobId.equals(oldDep.get("job.id"))) {
            return true;
        }
        if (Objects.nonNull(newAdminOrgId) && !newAdminOrgId.equals(oldDep.get("adminorg.id"))) {
            return true;
        }
        return false;
    }

    private Boolean isJobModify(Map<String, Object> newDep, DynamicObject oldDep) {
        if (StringUtils.equals((CharSequence)TRUE_NUMBER_ONE, (CharSequence)oldDep.getString("apositiontype"))) {
            return false;
        }
        return false;
    }

    private void buildIdMap(String entityName, int size, long boId, Long depempId) {
        Map tmpIdMap;
        HashMap<String, Object> idMap = ApplyApplicationImpl.ID_MAP_TL.get();
        if (Objects.isNull(idMap)) {
            idMap = new HashMap();
            ApplyApplicationImpl.ID_MAP_TL.set(idMap);
        }
        if (CollectionUtils.isEmpty((Map)(tmpIdMap = (Map)idMap.get(entityName)))) {
            tmpIdMap = Maps.newHashMapWithExpectedSize((int)size);
            idMap.put(entityName, tmpIdMap);
        }
        tmpIdMap.put(boId, depempId);
    }

    private Map<Long, DynamicObject> buildDepCmpRelMap(List<Map<String, Object>> depList) {
        HashMap depCmpRelMap = Maps.newHashMapWithExpectedSize((int)depList.size());
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(depList)) {
            return depCmpRelMap;
        }
        HashSet numberSet = Sets.newHashSetWithExpectedSize((int)depList.size());
        depList.forEach(item -> numberSet.add((String)item.get("number")));
        DynamicObject[] cmps = HRPICmpempRepository.getCmpEmpByEmpNumber("id,person_id,employee.empnumber,startdate,enddate,managingscope_id,isprimaryscope", numberSet);
        Map<String, List<DynamicObject>> groupByEmpNumberForCmp = Arrays.stream(cmps).collect(Collectors.groupingBy(item -> item.getString("employee.empnumber")));
        depList.forEach(item -> {
            Long id = (Long)item.get("depemp");
            String empNumber = (String)item.get("number");
            Date startDate = (Date)item.get("startdate");
            Date endDate = (Date)item.get("enddate");
            List cmpList = (List)groupByEmpNumberForCmp.get(empNumber);
            for (DynamicObject cmp : cmpList) {
                Date cmpStartDate = cmp.getDate("startdate");
                Date cmpEndDate = cmp.getDate("enddate");
                Boolean isPrimary = (Boolean)cmp.get("isprimaryscope");
                if (cmpStartDate.after(startDate) || cmpEndDate.before(endDate) || !isPrimary.booleanValue()) continue;
                depCmpRelMap.put(id, cmp);
            }
        });
        return depCmpRelMap;
    }

    private Boolean getBoolean(Object isPrim) {
        if (isPrim instanceof String) {
            return TRUE_NUMBER_ONE.equals(isPrim);
        }
        return (Boolean)isPrim;
    }

    @Override
    public Map<String, Long> createEmployeeDys(Map<String, DynamicObjectCollection> dyColl, Map<String, Object> param) {
        HashMap idMap = Maps.newHashMapWithExpectedSize((int)8);
        Map info = (Map)param.get("baseinfo");
        if (info != null && !info.isEmpty()) {
            for (String entity : HRPIPageConstants.EMPLOYEEENTITYS) {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
                DynamicObject baseInstance = (DynamicObject)dataEntityType.createInstance();
                for (Map.Entry<String, Object> entry : info.entrySet()) {
                    if (((String)entry.getKey()).equals("empposorgrels")) continue;
                    this.setLocalProp(dataEntityType, baseInstance, entry);
                }
                this.setIdProp(entity, baseInstance, info);
                if (entity.equals("hrpi_employee") || entity.equals("hrpi_empentrel")) {
                    baseInstance.set("empnumber", info.get("number"));
                }
                idMap.put(entity, baseInstance.getLong("id"));
                this.setCommonProp(dataEntityType, baseInstance, info);
                baseInstance.set("businessstatus", (Object)TRUE_NUMBER_ONE);
                this.wrapCommonProp(baseInstance);
                this.addMap(entity, baseInstance, dyColl);
                Map baseinfo = (Map)param.get("baseinfo");
                Long l = (Long)baseinfo.get("labrelstatusprd");
                if (!"hrpi_empentrel".equals(entity) || !HRPIValueConstants.LABRELSTATUSPRD_END.equals(l)) continue;
                DynamicObject nonEntRel = EmpNonEntBuilder.createByEmpEntRel(baseInstance);
                nonEntRel.set("id", (Object)new ORMImpl().genLongId("hrpi_empentrel"));
                this.addMap("hrpi_empnonentrel", nonEntRel, dyColl);
                idMap.put("hrpi_empnonentrel", nonEntRel.getLong("id"));
            }
        }
        return idMap;
    }

    @Override
    public Map<String, Long> createCmpDys(Map<String, DynamicObjectCollection> dyColl, Map<String, Object> param) {
        HashMap idMap = Maps.newHashMapWithExpectedSize((int)8);
        Map info = (Map)param.get("baseinfo");
        if (info != null && !info.isEmpty()) {
            for (String entity : HRPIPageConstants.CMPENTITYS) {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
                DynamicObject baseInstance = (DynamicObject)dataEntityType.createInstance();
                for (Map.Entry<String, Object> entry : info.entrySet()) {
                    if (((String)entry.getKey()).equals("empposorgrels") || "number".equals(entry.getKey())) continue;
                    this.setLocalProp(dataEntityType, baseInstance, entry);
                }
                this.setIdProp(entity, baseInstance, info);
                idMap.put(entity, baseInstance.getLong("id"));
                this.setCommonProp(dataEntityType, baseInstance, info);
                baseInstance.set("businessstatus", (Object)(this.equalsMaxDate(baseInstance.getDate("enddate")) ? TRUE_NUMBER_ONE : "2"));
                this.wrapCommonProp(baseInstance);
                this.addMap(entity, baseInstance, dyColl);
            }
        }
        return idMap;
    }

    @Override
    public Map<String, DynamicObjectCollection> updateEmployeeDys(List<Map<String, Object>> employeeList) {
        HashMap<String, DynamicObjectCollection> result = new HashMap<String, DynamicObjectCollection>(16);
        try {
            int size = employeeList.size();
            HashSet quitEmployeeIds = Sets.newHashSetWithExpectedSize((int)size);
            Map<Long, Map<String, Object>> employeeIdMap = employeeList.stream().collect(Collectors.toMap(item -> (Long)item.get("employee"), item -> item, (v1, v2) -> v1));
            Map<String, Map<Long, DynamicObject>> employeeMap = HRPIEmployeeRepository.loadEmployeeInfo(employeeIdMap.keySet());
            if (employeeMap.isEmpty()) {
                LOG.info("updateEmployeeDys get empty object : {}", (Object)JSONObject.toJSONString(employeeIdMap.keySet()));
                return result;
            }
            for (String empEntity : HRPIPageConstants.EMPLOYEEUPENTITYS) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)empEntity);
                Map<Long, DynamicObject> empDys = employeeMap.get(empEntity);
                employeeList.forEach(emp -> {
                    Long employeeId = (Long)emp.get("employee");
                    DynamicObject empDy = (DynamicObject)empDys.get(employeeId);
                    DynamicObject instance = (DynamicObject)entityType.createInstance();
                    HRDynamicObjectUtils.copy((DynamicObject)empDy, (DynamicObject)instance);
                    for (Map.Entry<String, Object> entry : emp.entrySet()) {
                        if (LOCK_PROP.contains(entry.getKey())) continue;
                        this.setLocalProp(entityType, instance, entry);
                    }
                    instance.set("id", (Object)new ORMImpl().genLongId(empEntity));
                    this.addMap(empEntity, instance, result);
                    Long labStatusPrd = (Long)emp.get("labrelstatusprd");
                    if ("hrpi_empentrel".equals(empEntity) && HRPIValueConstants.LABRELSTATUSPRD_END.equals(labStatusPrd) && HRPIValueConstants.LABRELSTATUSPRD_ING.equals(empDy.get("labrelstatusprd_id"))) {
                        DynamicObject dynamicObject = EmpNonEntBuilder.createByEmpEntRel(instance);
                        dynamicObject.set("id", (Object)new ORMImpl().genLongId("hrpi_empentrel"));
                        this.addMap("hrpi_empnonentrel", dynamicObject, result);
                        quitEmployeeIds.add((Long)empDy.get("employee_id"));
                    }
                    this.buildIdMap(empEntity, size, (Long)instance.get("id"), employeeId);
                });
            }
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)quitEmployeeIds)) {
                this.buildQuitErManFile(result, quitEmployeeIds, employeeIdMap);
            }
        }
        catch (Exception ex) {
            LOG.error("updateEmployeeDys getDynamic error", (Throwable)ex);
            throw new KDBizException(" packed data error ");
        }
        return result;
    }

    private void buildQuitErManFile(Map<String, DynamicObjectCollection> result, Set<Long> quitEmployeeIds, Map<Long, Map<String, Object>> employeeIdMap) {
        DynamicObject[] erManFiles = HRPIManFileRepository.loadPrimaryByEmpId(quitEmployeeIds);
        BinaryOperator mergeFunction = (file1, file2) -> {
            Date startDate2;
            Date startDate1 = file1.getDate("startdate");
            if (startDate1.after(startDate2 = file2.getDate("startdate"))) {
                return file1;
            }
            return file2;
        };
        Map<Long, DynamicObject> lastErFileMap = Arrays.stream(erManFiles).collect(Collectors.toMap(file -> (Long)file.get("employee_id"), file -> file, mergeFunction));
        if (MapUtils.isNotEmpty(lastErFileMap)) {
            long[] longs = new ORMImpl().genLongIds("hspm_ermanfile", lastErFileMap.size());
            int index = 0;
            for (Map.Entry<Long, DynamicObject> item : lastErFileMap.entrySet()) {
                DynamicObject lastFile = item.getValue();
                Date endDate = (Date)employeeIdMap.get(item.getKey()).get("enddate");
                DynamicObject quitFile = ErManFileBuilder.createQuitErManFileByLast(lastFile, endDate);
                quitFile.set("id", (Object)longs[index++]);
                this.addMap("hspm_ermanfile", quitFile, result);
            }
            List<Long> empPosIds = lastErFileMap.values().stream().map(dy -> dy.getLong("empposrel")).collect(Collectors.toList());
            DynamicObject[] empPosArr = HRPIDepempRepository.listEmpposOrgrelsById(empPosIds);
            long[] empIds = ORM.create().genLongIds("hrpi_empposorgrel", empPosIds.size());
            for (int i = 0; i < empPosArr.length; ++i) {
                DynamicObject emp = empPosArr[i];
                DynamicObject lastrecordEmpPos = (DynamicObject)emp.getDynamicObjectType().createInstance();
                HRDynamicObjectUtils.copy((DynamicObject)emp, (DynamicObject)lastrecordEmpPos);
                lastrecordEmpPos.set("id", (Object)empIds[i]);
                lastrecordEmpPos.set("islatestrecord", (Object)Boolean.TRUE);
                this.addMap("hrpi_empposorgrel", lastrecordEmpPos, result);
            }
        }
    }

    @Override
    public void createQuitErManFile(Map<String, DynamicObjectCollection> result, Map<String, Object> param, DynamicObject lastFile) {
        Map baseinfo = (Map)param.get("baseinfo");
        Long labStatusPrd = (Long)baseinfo.get("labrelstatusprd");
        if (HRPIValueConstants.LABRELSTATUSPRD_END.equals(labStatusPrd)) {
            Date endDate = lastFile.getDate("enddate");
            DynamicObject quitFile = ErManFileBuilder.createQuitErManFileByLast(lastFile, endDate);
            quitFile.set("id", (Object)new ORMImpl().genLongId("hspm_ermanfile"));
            this.addMap("hspm_ermanfile", quitFile, result);
        }
    }

    @Override
    public Map<String, DynamicObjectCollection> updateEmpNumberWhenPreOnboard(Set<Long> successOldPersonId, Map<Long, String> oldNumberMap) {
        HashMap<String, DynamicObjectCollection> result = new HashMap<String, DynamicObjectCollection>();
        ArrayList<Long> successOldPersonIdList = new ArrayList<Long>(successOldPersonId);
        DynamicObject[] personArr = HRPIPersonRepository.listPerson(successOldPersonIdList);
        BiConsumer<DynamicObject, String> personReplace = (targetDy, replaceNumber) -> targetDy.set("number", replaceNumber);
        DynamicObjectCollection personCol = this.replaceOldNumber(personArr, "boid", oldNumberMap, personReplace);
        result.put("hrpi_person", personCol);
        DynamicObject[] employeeArr = HRPIEmployeeRepository.listEmployeeByPersonIds(null, successOldPersonIdList);
        BiConsumer<DynamicObject, String> employeeReplace = (targetDy, replaceNumber) -> targetDy.set("empnumber", replaceNumber);
        DynamicObjectCollection employeeCol = this.replaceOldNumber(employeeArr, "person_id", oldNumberMap, employeeReplace);
        result.put("hrpi_employee", employeeCol);
        DynamicObject[] empentrelArr = HRPIEmployeeRepository.listEmpEntByPersonIds(null, successOldPersonIdList);
        BiConsumer<DynamicObject, String> empEntReplace = (targetDy, replaceNumber) -> {
            String oldNumber = targetDy.getString("empnumber");
            targetDy.set("empnumber", replaceNumber);
            String number = targetDy.getString("number");
            if (!StringUtil.isEmpty((String)number)) {
                targetDy.set("number", (Object)number.replaceFirst(oldNumber, (String)replaceNumber));
            }
        };
        DynamicObjectCollection empEntCol = this.replaceOldNumber(empentrelArr, "person_id", oldNumberMap, empEntReplace);
        result.put("hrpi_empentrel", empEntCol);
        DynamicObject[] depArr = HRPIDepempRepository.listDepEmpDysByPerson(successOldPersonIdList);
        BiConsumer<DynamicObject, String> depReplace = (targetDy, replaceNumber) -> {
            String number = targetDy.getString("employee.empnumber");
            String oldNumber = targetDy.getString("number");
            targetDy.set("number", (Object)oldNumber.replaceFirst(number, (String)replaceNumber));
        };
        DynamicObjectCollection depCol = this.replaceOldNumber(depArr, "person_id", oldNumberMap, depReplace);
        result.put("hrpi_depemp", depCol);
        DynamicObject[] empPosArr = HRPIDepempRepository.listEmpposOrgrelDysByPerson(successOldPersonIdList);
        DynamicObjectCollection empPosCol = this.replaceOldNumber(empPosArr, "person_id", oldNumberMap, depReplace);
        result.put("hrpi_empposorgrel", empPosCol);
        DynamicObject[] erManArr = HRPIManFileRepository.listErManByPersonIds(null, successOldPersonIdList);
        DynamicObjectCollection erManCol = this.replaceOldNumber(erManArr, "person_id", oldNumberMap, personReplace);
        result.put("hrpi_empposorgrel", erManCol);
        return result;
    }

    private DynamicObjectCollection replaceOldNumber(DynamicObject[] arr, String keyField, Map<Long, String> oldNumberMap, BiConsumer<DynamicObject, String> replaceFuc) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        if (arr.length > 0) {
            long[] ids = ORM.create().genLongIds((IDataEntityType)arr[0].getDynamicObjectType(), arr.length);
            for (int i = 0; i < arr.length; ++i) {
                DynamicObject item = arr[i];
                Long key = (Long)item.get(keyField);
                DynamicObject target = (DynamicObject)item.getDynamicObjectType().createInstance();
                HRDynamicObjectUtils.copy((DynamicObject)item, (DynamicObject)target);
                target.set("id", (Object)ids[i]);
                replaceFuc.accept(target, oldNumberMap.get(key));
                collection.add((Object)target);
            }
        }
        return collection;
    }

    @Override
    public Map<String, Object> discardDeps(List<Long> depIdList) {
        HisBatchDiscardApiBo param = new HisBatchDiscardApiBo();
        ArrayList listBoId = Lists.newArrayListWithExpectedSize((int)4);
        for (String dempEntity : HRPIPageConstants.DISCARD_DEPEMPENTITYS) {
            if ("hrpi_depemp".equals(dempEntity)) {
                listBoId.add(this.buildHisModelParam(dempEntity, new HashSet<Long>(depIdList)));
                continue;
            }
            DynamicObject[] items = HRPIDepempRepository.listByDepIdsAndEntityName(dempEntity, depIdList, "boid");
            if (items.length <= 0) continue;
            HashSet idSet = Sets.newHashSetWithExpectedSize((int)depIdList.size());
            for (DynamicObject item : items) {
                idSet.add((Long)item.get("boid"));
            }
            listBoId.add(this.buildHisModelParam(dempEntity, idSet));
        }
        param.setHisDiscardApiBoList((List)listBoId);
        try (TXHandle h = TX.required();){
            try {
                HisModelController.getInstance().batchDiscardBoData(param);
            }
            catch (Exception ex) {
                h.markRollback();
                LOG.error("ApplyServiceImpl discardDeps error:{}", (Object)ExceptionUtils.getStackTrace((Throwable)ex));
                Map map = PersonGenericResult.exception((String)ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\u3002", (String)"ApplyServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                if (h != null) {
                    if (var5_5 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return map;
            }
        }
        return PersonGenericResult.ok();
    }

    private HisDiscardApiBo buildHisModelParam(String dempEntity, Set<Long> idSet) {
        HisDiscardApiBo entityParam = new HisDiscardApiBo();
        entityParam.setEntityNumber(dempEntity);
        entityParam.setBoIdSet(idSet);
        return entityParam;
    }

    private void setLocalProp(MainEntityType dataEntityType, DynamicObject baseInstance, Map.Entry<String, Object> keyValue) {
        IDataEntityProperty property = dataEntityType.findProperty(keyValue.getKey());
        if (property != null && !this.notNeedSetValue(dataEntityType, keyValue)) {
            Object value = keyValue.getValue();
            if (value instanceof Map) {
                LocaleString localeString = new LocaleString();
                Map langMap = (Map)value;
                IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
                List enabledLangList = service.getEnabledLang();
                enabledLangList.forEach(lang -> {
                    String number = lang.getNumber();
                    if (langMap.containsKey(number)) {
                        localeString.setItem(number, langMap.get(number));
                    }
                });
                baseInstance.set(keyValue.getKey(), (Object)localeString);
            } else {
                baseInstance.set(keyValue.getKey(), keyValue.getValue());
            }
            if (property instanceof BasedataProp) {
                baseInstance.set(String.join((CharSequence)"_", keyValue.getKey(), "id"), keyValue.getValue());
            }
        }
    }

    private boolean notNeedSetValue(MainEntityType type, Map.Entry<String, Object> keyValue) {
        String entityName = type.getName();
        String field = keyValue.getKey();
        if ("hrpi_empentrel".equals(entityName) && "number".equals(field)) {
            return true;
        }
        if ("hrpi_depemp".equals(entityName) && "number".equals(field)) {
            return true;
        }
        return "hrpi_empposorgrel".equals(entityName) && "number".equals(field);
    }

    protected void wrapCommonProp(DynamicObject baseInstance) {
        baseInstance.set("initstatus", (Object)"2");
    }

    protected void setIdProp(String entity, DynamicObject baseInstance, Map<String, Object> info) {
        switch (entity) {
            case "hrpi_person": {
                baseInstance.set("id", info.get("person"));
                break;
            }
            case "hrpi_employee": {
                baseInstance.set("id", info.get("employee"));
                break;
            }
            case "hrpi_cmpemp": {
                baseInstance.set("id", info.get("cmpemp"));
                break;
            }
            case "hrpi_depemp": {
                baseInstance.set("id", info.get("depemp"));
                break;
            }
            default: {
                baseInstance.set("id", (Object)ORM.create().genLongId(entity));
            }
        }
    }

    private void setCommonProp(MainEntityType dataEntityType, DynamicObject baseInstance, Map<String, Object> info) {
        if (dataEntityType.findProperty("enddate") != null && null == baseInstance.get("enddate")) {
            try {
                baseInstance.set("enddate", (Object)HRDateTimeUtils.parseDate((String)"2999-12-31"));
            }
            catch (ParseException e) {
                LOG.error("", (Throwable)e);
            }
        }
        if (dataEntityType.findProperty("bsed") != null) {
            baseInstance.set("bsed", info.get("startdate"));
            baseInstance.set("bsled", (Object)baseInstance.getDate("enddate"));
        }
    }

    private void addMap(String entityName, DynamicObject info, Map<String, DynamicObjectCollection> dyColl) {
        DynamicObjectCollection dyCol = dyColl.get(entityName);
        if (dyCol == null) {
            dyCol = new DynamicObjectCollection();
        }
        dyCol.add((Object)info);
        dyColl.put(entityName, dyCol);
    }

    private boolean equalsMaxDate(Date date) {
        if (null == date) {
            return false;
        }
        String dateStr = new SimpleDateFormat("yyyy-MM-dd").format(date);
        return "2999-12-31".equals(dateStr);
    }

    static {
        LOCK_PROP = new HashSet<String>(Arrays.asList("startdate", "postype", "laborreltype"));
    }
}

