/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hrpi.business.application.impl.EmployeeInfoQueryServiceImpl;
import kd.hrmp.hrpi.business.domian.service.BlackListEmpInfoService;
import kd.hrmp.hrpi.business.domian.service.HRPIServiceFactory;
import kd.hrmp.hrpi.business.domian.service.impl.HbpmServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class BlackListEmpInfoServiceImpl
implements BlackListEmpInfoService {
    private static final Log LOGGER = LogFactory.getLog(BlackListEmpInfoServiceImpl.class);

    @Override
    public List<Map<String, Object>> queryOutEmpInfoByCardInfo(Long cardType, String cardNumber) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("credentialsType", cardType);
        paramMap.put("numbers", Lists.newArrayList((Object[])new String[]{cardNumber}));
        Map<String, Object> personMap = HRPIServiceFactory.personService.getPersonInfoByCert(paramMap);
        if (personMap == null) {
            LOGGER.error("queryOutEmployeeInfoByCert error");
            return new ArrayList<Map<String, Object>>();
        }
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        Object data = personMap.get("data");
        if (data instanceof List) {
            List dataList = (List)data;
            resultList = this.assembleResultList(dataList, cardNumber, "number", "1");
        }
        return resultList;
    }

    @Override
    public List<Map<String, Object>> queryOutEmpInfoByPhone(String phone) {
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (StringUtils.isBlank((CharSequence)phone)) {
            return resultList;
        }
        HashMap fuzzyParam = Maps.newHashMapWithExpectedSize((int)3);
        fuzzyParam.put("phone", phone);
        fuzzyParam.put("fuzzyFlag", Boolean.FALSE);
        Map<String, Object> personInfoFuzzy = HRPIServiceFactory.personService.getPersonInfoFuzzy(fuzzyParam);
        if (personInfoFuzzy == null || Boolean.FALSE.equals(personInfoFuzzy.get("success"))) {
            LOGGER.error("getPersonInfoFuzzyDedupByPhoneAndName is error");
            return resultList;
        }
        Object data = personInfoFuzzy.get("data");
        if (data instanceof List) {
            List dataLists = (List)data;
            resultList = this.assembleResultList(dataLists, phone, "phone", "2");
        }
        return resultList;
    }

    @Override
    public Map<String, Object> queryOutEmpInfoByEmpId(List<Long> empidList) {
        Map<String, Object> returnMap = this.getQuitBaseInfoFromErman(empidList);
        List<Long> misOrgEmployeeId = this.getFieldFromHtmAdvance(empidList, returnMap);
        this.getFieldFromErmanAfterHtm(returnMap, misOrgEmployeeId);
        return returnMap;
    }

    private List<Long> getFieldFromHtmAdvance(List<Long> empidList, Map<String, Object> returnMap) {
        ArrayList<Long> misOrgId = new ArrayList<Long>();
        Map quitMap = (Map)HRMServiceHelper.invokeHRService((String)"htm", (String)"IQuitBillQuery", (String)"queryQuitBillByEmployeeIds", (Object[])new Object[]{empidList, ""});
        empidList.forEach(empId -> {
            Object quitObj = quitMap.get(empId);
            if (quitObj instanceof Map) {
                Map quitDyMap = (Map)quitObj;
                Object quitapply = quitDyMap.get("quitapply");
                if (HRObjectUtils.isEmpty(quitapply)) {
                    misOrgId.add((Long)empId);
                }
                Map map = (Map)returnMap.get(String.valueOf(empId));
                if (!HRObjectUtils.isEmpty(quitDyMap.get("aphone"))) {
                    map.put("phone", quitDyMap.get("aphone"));
                }
                if (!HRObjectUtils.isEmpty(quitDyMap.get("aemail"))) {
                    map.put("email", quitDyMap.get("aemail"));
                }
                map.put("quitdate", quitDyMap.get("contractenddate"));
                map.put("quitreason", quitDyMap.get("quitreason"));
                map.put("quittype", quitDyMap.get("quittype"));
                map.put("adminororg", quitDyMap.get("aaffiliateadminorg"));
                map.put("adminorg", quitDyMap.get("dephis"));
                map.put("position", quitDyMap.get("poshis"));
                map.put("job", quitDyMap.get("jobhis"));
            }
        });
        return misOrgId;
    }

    private void getFieldFromErmanAfterHtm(Map<String, Object> returnMap, List<Long> misOrgEmployeeId) {
        if (CollectionUtils.isEmpty(misOrgEmployeeId)) {
            return;
        }
        DynamicObject[] empposorgrelDys = this.getOrgRelateFieldsFromEmpposorgrel(misOrgEmployeeId);
        Map<Long, DynamicObject> empDyMap = Arrays.stream(empposorgrelDys).collect(Collectors.toMap(dy -> dy.getLong("employee.id"), dy -> dy, (oldDy, newDy) -> newDy));
        ArrayList<Long> departIds = new ArrayList<Long>(empDyMap.size());
        ArrayList<Long> positionIds = new ArrayList<Long>(empDyMap.size());
        ArrayList<Long> jobIds = new ArrayList<Long>(empDyMap.size());
        Set<Map.Entry<Long, DynamicObject>> entries = empDyMap.entrySet();
        for (Map.Entry<Long, DynamicObject> next : entries) {
            DynamicObject value = next.getValue();
            long adminorgId = value.getLong("adminorg.id");
            long positionId = value.getLong("position.id");
            long jobId = value.getLong("job.id");
            departIds.add(adminorgId);
            positionIds.add(positionId);
            jobIds.add(jobId);
        }
        Map<Long, Long> adminOrgHisMap = HbpmServiceImpl.getInstance().getAdminOrgHis(departIds);
        Map<Long, Long> hisPosMap = HbpmServiceImpl.getInstance().getPosHis(positionIds);
        Map<Long, Long> jobHisMap = HbpmServiceImpl.getInstance().getJobHis(jobIds);
        HRBaseServiceHelper ermanfileServiceHelper = new HRBaseServiceHelper("hspm_ermanfile");
        QFilter isPrimaryFilter = new QFilter("empposrel.isprimary", "=", (Object)Boolean.TRUE);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter businessFilter = new QFilter("businessstatus", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter employeeFilter = new QFilter("employee", "in", misOrgEmployeeId);
        Object[] ermanfileDys = ermanfileServiceHelper.query("employee,affiliateadminorg", new QFilter[]{isPrimaryFilter, isCurrentFilter, businessFilter, dataStatusFilter, initStatusFilter, employeeFilter});
        LOGGER.info("getFieldFromErmanAfterHtm.ermanfileServiceHelper.query.result={}", ermanfileDys);
        Map<Long, Long> empAndAdminOrgDyMap = Arrays.stream(ermanfileDys).collect(Collectors.toMap(dy -> dy.getLong("employee.id"), dy -> dy.getLong("affiliateadminorg.id"), (oldDy, newDy) -> newDy));
        misOrgEmployeeId.forEach(empId -> {
            Object empObj = empDyMap.get(empId);
            if (empObj instanceof DynamicObject) {
                DynamicObject empDy = (DynamicObject)empObj;
                long adminorgId = empDy.getLong("adminorg.id");
                long positionId = empDy.getLong("position.id");
                long jobId = empDy.getLong("job.id");
                Long adminOrgHisId = (Long)adminOrgHisMap.get(adminorgId);
                Long positionHisId = (Long)hisPosMap.get(positionId);
                Long jobHisId = (Long)jobHisMap.get(jobId);
                Map map = (Map)returnMap.get(String.valueOf(empId));
                map.put("adminororg", empAndAdminOrgDyMap.get(empId));
                map.put("adminorg", adminOrgHisId);
                map.put("position", positionHisId);
                map.put("job", jobHisId);
            }
        });
    }

    private DynamicObject[] getOrgRelateFieldsFromEmpposorgrel(List<Long> misOrgId) {
        HRBaseServiceHelper empposorgrelServiceHelper = new HRBaseServiceHelper("hrpi_empposorgrel");
        QFilter dataFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter isprimaryFilter = new QFilter("isprimary", "=", (Object)"1");
        QFilter islatestrecordFilter = new QFilter("islatestrecord", "=", (Object)Boolean.TRUE);
        QFilter empFilter = new QFilter("employee", "in", misOrgId);
        return empposorgrelServiceHelper.query("employee,adminorg,position,job", new QFilter[]{islatestrecordFilter, dataFilter, isCurrentFilter, isprimaryFilter, empFilter});
    }

    private Map<String, Object> getQuitBaseInfoFromErman(List<Long> empidList) {
        List<String> empIdStrList = empidList.stream().map(empId -> String.valueOf(empId)).collect(Collectors.toList());
        HashSet<String> searchTypeSet = new HashSet<String>(3);
        searchTypeSet.addAll(new ArrayList(ImmutableList.of((Object)"001", (Object)"003", (Object)"007")));
        EmployeeInfoQueryServiceImpl employeeInfoQueryService = new EmployeeInfoQueryServiceImpl();
        Map<String, Map<String, Object>> resultMaps = employeeInfoQueryService.queryEmployeeInfo("EMPID", empIdStrList, searchTypeSet, null);
        if (MapUtils.isEmpty(resultMaps)) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(empidList.size());
        empIdStrList.forEach(empIdStr -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Map resultMap = (Map)resultMaps.get(empIdStr);
            if (MapUtils.isEmpty((Map)resultMap)) {
                returnMap.put((String)empIdStr, null);
                return;
            }
            Map<String, Object> hrpiPernontspropMap = this.getObjectToMap(resultMap, "hrpi_pernontsprop");
            Map<String, Object> hrpiPercontactMap = this.getObjectToMap(resultMap, "hrpi_percontact");
            this.setEnableValue(hrpiPernontspropMap, "gender_id", "hbss_sex", "gender", map);
            map.put("empnumber", resultMap.getOrDefault("empnumber", ""));
            map.put("name", hrpiPernontspropMap.get("name"));
            map.put("employee", Long.valueOf(empIdStr));
            String hrpi_percre = resultMap.getOrDefault("hrpi_percre", "");
            if (hrpi_percre instanceof List) {
                List valueList = (List)((Object)hrpi_percre);
                for (Map stringObjectMap : valueList) {
                    Object ismajor = stringObjectMap.get("ismajor");
                    if (ismajor instanceof Boolean && ((Boolean)ismajor).booleanValue()) {
                        this.setEnableValue(stringObjectMap, "credentialstype_id", "hbss_credentialstype", "maincardtype", map);
                        map.put("maincardnumber", stringObjectMap.get("number"));
                        continue;
                    }
                    this.setEnableValue(stringObjectMap, "credentialstype_id", "hbss_credentialstype", "cardtype", map);
                    map.put("cardnumber", stringObjectMap.get("number"));
                }
            }
            map.put("phone", hrpiPercontactMap.getOrDefault("phone", ""));
            map.put("email", hrpiPercontactMap.getOrDefault("peremail", ""));
            this.setEnableValue(hrpiPernontspropMap, "nationality_id", "hbss_nationality", "nation", map);
            map.put("emppicture", hrpiPernontspropMap.getOrDefault("headsculpture", ""));
            map.put("person", resultMap.get("person_id"));
            returnMap.put((String)empIdStr, map);
        });
        return returnMap;
    }

    private Map<String, Object> getObjectToMap(Map<String, Object> resultMap, String key) {
        List valueList;
        Map finalResultMap = Maps.newHashMapWithExpectedSize((int)16);
        Object value = resultMap.get(key);
        if (value instanceof ArrayList && CollectionUtils.isNotEmpty((Collection)(valueList = (List)resultMap.get(key)))) {
            finalResultMap = (Map)valueList.get(0);
        }
        return finalResultMap;
    }

    private void setEnableValue(Map<String, Object> map, String key, String entityName, String realKey, Map<String, Object> returnMap) {
        Object value = map.getOrDefault(key, 0L);
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)2);
        qFilters.add(new QFilter("id", "=", value));
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        boolean flag = serviceHelper.isExists(qFilters.toArray(new QFilter[0]));
        if (flag) {
            returnMap.put(realKey, value);
        }
    }

    private List<Map<String, Object>> assembleResultList(List<Map<String, Object>> dataList, String number, String numberType, String hitType) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> stringObjectMap : dataList) {
            Object empentrel;
            if (!number.equals(String.valueOf(stringObjectMap.get(numberType))) || !((empentrel = stringObjectMap.get("hrpi_empentrel")) instanceof Map)) continue;
            Map empentrelMap = (Map)empentrel;
            Object labrelstatuscls = empentrelMap.get("laborrelstatus_labrelstatuscls_id");
            if (!Long.valueOf(1040L).equals(labrelstatuscls) && !Long.valueOf(1050L).equals(labrelstatuscls)) continue;
            HashMap result = new HashMap(16);
            result.put("employeeid", empentrelMap.get("employee_id"));
            result.put("employee", empentrelMap.get("employee"));
            result.put("emptype", empentrelMap.get("laborreltype_id"));
            if (stringObjectMap.get("hrpi_person") instanceof Map) {
                List<DynamicObject> cardList;
                Optional<DynamicObject> majorCardDy;
                Map person = (Map)stringObjectMap.get("hrpi_person");
                result.put("personindexid", person.get("personindexid"));
                result.put("name", person.get("name"));
                result.put("empnumber", person.get("number"));
                result.put("emppicture", person.get("headsculpture"));
                Object personId = person.get("id");
                result.put("person", personId);
                if (stringObjectMap.get("hrpi_percre") instanceof Map) {
                    Map percre = (Map)stringObjectMap.get("hrpi_percre");
                    result.put("nation", percre.get("nationality"));
                    result.put("cardtype", percre.get("credentialstype_id"));
                    result.put("cardnumber", percre.get("number"));
                } else if (personId instanceof Long && (majorCardDy = (cardList = HRPIServiceFactory.personService.listPersonAttachs((Long)personId, "hrpi_percre")).stream().filter(cardDy -> cardDy.getBoolean("ismajor")).findFirst()).isPresent()) {
                    DynamicObject dynamicObject = majorCardDy.get();
                    result.put("cardtype", dynamicObject.getLong("credentialstype_id"));
                    result.put("cardnumber", dynamicObject.getString("number"));
                }
            }
            if (stringObjectMap.get("hrpi_pernontsprop") instanceof Map) {
                Map pernontsprop = (Map)stringObjectMap.get("hrpi_pernontsprop");
                result.put("gender", pernontsprop.get("gender_id"));
            }
            if (stringObjectMap.get("hrpi_percontact") instanceof Map) {
                Map percontact = (Map)stringObjectMap.get("hrpi_percontact");
                result.put("phone", percontact.get("phone"));
                result.put("email", percontact.get("peremail"));
            }
            result.put("hittype", hitType);
            resultList.add(result);
        }
        return resultList;
    }
}

