/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hrmp.hrpi.business.domian.repository.HRPIBlackListLogRepository;
import kd.hrmp.hrpi.business.domian.service.IBlackListLogService;
import kd.hrmp.hrpi.common.enums.BlackListLogEnum;

public class BlackListLogServiceImpl
implements IBlackListLogService {
    private static final Log LOGGER = LogFactory.getLog(BlackListLogServiceImpl.class);
    private static volatile IBlackListLogService BLACKLISTLOGSERVICE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IBlackListLogService getInstance() {
        try {
            if (null != BLACKLISTLOGSERVICE) return BLACKLISTLOGSERVICE;
            Class<BlackListLogServiceImpl> clazz = BlackListLogServiceImpl.class;
            synchronized (BlackListLogServiceImpl.class) {
                if (null != BLACKLISTLOGSERVICE) return BLACKLISTLOGSERVICE;
                try {
                    BLACKLISTLOGSERVICE = new BlackListLogServiceImpl();
                    LOGGER.info("HRPIServiceFactory-dependency-check,new-BlackListLogServiceImpl()-success");
                }
                catch (Throwable t) {
                    LOGGER.error("HRPIServiceFactory-dependency-check,new-BlackListLogServiceImpl()-fail", t);
                }
                return BLACKLISTLOGSERVICE;
            }
        }
        catch (Throwable t) {
            LOGGER.error("HRPIServiceFactory-dependency-check,BlackListLogServiceImpl-getInstance()-fail", t);
        }
        return BLACKLISTLOGSERVICE;
    }

    @Override
    public Map<String, Object> saveBlackListLog(Map<String, Object> params) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        result.put("success", Boolean.FALSE);
        result.put("ErrMsg", "saveBlackListLog is fail !!!");
        result.put("data", null);
        if (params == null) {
            return result;
        }
        try {
            String operation = (String)params.get("operation");
            HashSet operationSet = Sets.newHashSet((Object[])new String[]{BlackListLogEnum.ADD.getValue(), BlackListLogEnum.REMOVE.getValue(), BlackListLogEnum.UPDATE.getValue()});
            if (!operationSet.contains(operation)) {
                return result;
            }
            DynamicObject dynamicObject = this.getBlackListLog(params, operation);
            if (BlackListLogEnum.UPDATE.getValue().equals(operation)) {
                this.addEntryEntity(params, dynamicObject);
            }
            HRPIBlackListLogRepository.saveBlackListLog(dynamicObject);
            result.put("success", Boolean.TRUE);
            result.put("ErrMsg", null);
            result.put("data", null);
            return result;
        }
        catch (Exception e) {
            LOGGER.error("handleSaveInfoSyncError", (Throwable)e);
            return result;
        }
    }

    private DynamicObject getBlackListLog(Map<String, Object> params, String operation) {
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hrpi_blacklistlog"));
        SecureRandom random = new SecureRandom();
        String number = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(Instant.now().toEpochMilli()) + (random.nextInt(900) + 100);
        dynamicObject.set("number", (Object)number);
        dynamicObject.set("operation", (Object)operation);
        dynamicObject.set("creator", params.get("creator"));
        dynamicObject.set("personname", params.get("personname"));
        dynamicObject.set("issysperson", params.get("issysperson"));
        dynamicObject.set("empnumber", params.get("empnumber"));
        if (params.get("createtime") != null) {
            dynamicObject.set("createtime", params.get("createtime"));
        }
        dynamicObject.set("personnumber", params.get("personnumber"));
        dynamicObject.set("description", params.get("description"));
        dynamicObject.set("operationreason", params.get("operationreason"));
        dynamicObject.set("source", params.get("source"));
        return dynamicObject;
    }

    private void addEntryEntity(Map<String, Object> params, DynamicObject dynamicObject) {
        if (params.get("entryentity") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9ed1\u540d\u5355\u65e5\u5fd7\u5206\u5f55\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"BlackListLogServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        List list = (List)params.get("entryentity");
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        for (Map map : list) {
            DynamicObject tmpDynamicObject = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
            tmpDynamicObject.set("fieldname", map.get("fieldname"));
            tmpDynamicObject.set("updatebefore", map.get("updatebefore"));
            tmpDynamicObject.set("updateafter", map.get("updateafter"));
            tmpDynamicObject.set("operationname", (Object)BlackListLogEnum.UPDATE.getValue());
            dynamicObjectCollection.add((Object)tmpDynamicObject);
        }
    }
}

