/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.LogPrivacyUtil;
import kd.hrmp.hrpi.business.domian.repository.BlackListForPageUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIBlackListRepository;
import kd.hrmp.hrpi.business.domian.service.BlackListService;
import kd.hrmp.hrpi.business.domian.service.impl.BlackListEmpInfoServiceImpl;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;

public class BlackListServiceImpl
implements BlackListService {
    private static final Log LOGGER = LogFactory.getLog(BlackListServiceImpl.class);

    @Override
    public List<Map<String, Object>> queryBlackListByPid(Long pid, String property) {
        if (pid != 0L) {
            QFilter pidFilter = new QFilter(property, "=", (Object)pid);
            QFilter[] qFilters = new QFilter[]{pidFilter};
            DynamicObject[] dynamicObjects = HRPIBlackListRepository.getInstance().queryByFilter("", qFilters);
            if (dynamicObjects == null || dynamicObjects.length == 0) {
                return new ArrayList<Map<String, Object>>();
            }
            return this.resultTransferList(dynamicObjects);
        }
        return new ArrayList<Map<String, Object>>();
    }

    @Override
    public List<Map<String, Object>> queryBlackListByCardInfo(String name, Long cardId, String cardNum) {
        QFilter cardTypeFilter = new QFilter("entryentity.cardtype", "=", (Object)cardId);
        QFilter cardNumFilter = new QFilter("entryentity.cardnumber", "=", (Object)cardNum);
        if (this.validateNameIsEmpty(name).booleanValue()) {
            QFilter[] qFilters = new QFilter[]{cardTypeFilter, cardNumFilter};
            DynamicObject[] dynamicObjects = HRPIBlackListRepository.getInstance().queryByFilter("", qFilters);
            if (dynamicObjects == null || dynamicObjects.length == 0) {
                return new ArrayList<Map<String, Object>>();
            }
            return this.resultTransferList(dynamicObjects);
        }
        QFilter nameFilter = new QFilter("name", "=", (Object)name);
        QFilter[] qFilters = new QFilter[]{nameFilter, cardTypeFilter, cardNumFilter};
        return this.queryAndTransferResult(qFilters);
    }

    @Override
    public List<Map<String, Object>> queryBlackListByContactNum(String name, String property, String contactNum) {
        QFilter contactFilter = new QFilter(property, "=", (Object)contactNum);
        if (this.validateNameIsEmpty(name).booleanValue()) {
            QFilter[] qFilters = new QFilter[]{contactFilter};
            DynamicObject[] dynamicObjects = HRPIBlackListRepository.getInstance().queryByFilter("", qFilters);
            if (dynamicObjects == null || dynamicObjects.length == 0) {
                return new ArrayList<Map<String, Object>>();
            }
            return this.resultTransferList(dynamicObjects);
        }
        QFilter nameFilter = new QFilter("name", "=", (Object)name);
        QFilter[] filters = new QFilter[]{nameFilter, contactFilter};
        return this.queryAndTransferResult(filters);
    }

    private List<Map<String, Object>> queryAndTransferResult(QFilter[] filters) {
        DynamicObject[] dynamicObjects = HRPIBlackListRepository.getInstance().queryByFilter("", filters);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        return this.resultTransferList(dynamicObjects);
    }

    @Override
    public List<Map<String, Object>> queryBlackListByFields(Map<String, Object> paramMap) {
        Object pid = paramMap.get("pid");
        if (HRObjectUtils.isEmpty((Object)pid) && pid instanceof Long) {
            QFilter pidFilter = new QFilter("personindex", "=", (Object)((Long)pid));
            QFilter[] qFilters = new QFilter[]{pidFilter};
            DynamicObject[] dynamicObjects = HRPIBlackListRepository.getInstance().queryByFilter("", qFilters);
            if (dynamicObjects == null || dynamicObjects.length == 0) {
                return new ArrayList<Map<String, Object>>();
            }
            return this.resultTransferList(dynamicObjects);
        }
        Object name = paramMap.get("name");
        Object phone = paramMap.get("phone");
        Object email = paramMap.get("email");
        Object cardParam = paramMap.get("cardParam");
        if (!(name instanceof String && phone instanceof String && email instanceof String && cardParam instanceof List)) {
            throw new KDBizException("illegal param type");
        }
        List cardList = (List)cardParam;
        return cardList;
    }

    private Boolean validateNameIsEmpty(String name) {
        return HRStringUtils.isEmpty((String)name);
    }

    private List<Map<String, Object>> resultTransferList(DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(dynamicObjects.length);
        for (DynamicObject dy : dynamicObjects) {
            Map<String, Object> dyMap = this.dyToMap(dy);
            resultList.add(dyMap);
        }
        return resultList;
    }

    private Map<String, Object> dyToMap(DynamicObject dy) {
        HashMap<String, Object> dyMap = new HashMap<String, Object>(1);
        dyMap.put("id", dy.getLong("id"));
        dyMap.put("name", dy.getString("name"));
        dyMap.put("empnumber", dy.getString("empnumber"));
        dyMap.put("number", dy.getString("number"));
        dyMap.put("phone", dy.getString("phone"));
        dyMap.put("email", dy.getString("email"));
        dyMap.put("gender", dy.getString("gender.name"));
        dyMap.put("nation", dy.getString("nation.name"));
        dyMap.put("toreason", dy.getString("toreason.name"));
        dyMap.put("reasondetail", dy.getString("reasondetail"));
        dyMap.put("createtime", dy.getDate("createtime"));
        dyMap.put("creator", dy.getString("creator.name"));
        dyMap.put("datasource", dy.getString("datasource"));
        dyMap.put("issysperson", dy.getString("issysperson"));
        dyMap.put("employeeid", dy.getLong("employee.id"));
        dyMap.put("pid", dy.getLong("personindex"));
        dyMap.put("adminororg", dy.getString("adminororg.name"));
        DynamicObjectCollection entryentity = dy.getDynamicObjectCollection("entryentity");
        entryentity.stream().filter(dynamicObject -> dynamicObject.getBoolean("ismaincard")).forEach(dyFilter -> {
            dyMap.put("maincardtype", dyFilter.getString("cardtype.name"));
            dyMap.put("maincardtypeid", dyFilter.getLong("cardtype.id"));
            dyMap.put("maincardnumber", dyFilter.getString("cardnumber"));
        });
        entryentity.stream().filter(dynamicObject -> !dynamicObject.getBoolean("ismaincard")).forEach(dyFilter -> {
            dyMap.put("cardtype", dyFilter.getString("cardtype.name"));
            dyMap.put("cardtypeid", dyFilter.getLong("cardtype.id"));
            dyMap.put("cardnumber", dyFilter.getString("cardnumber"));
        });
        return dyMap;
    }

    @Override
    public Map<String, Object> newBlackList(List<Map<String, Object>> paramList) {
        if (this.validateParamIsEmpty(paramList).booleanValue()) {
            return this.resultMapWithCode(Boolean.FALSE, "param is empty", null, "302");
        }
        if (this.validateParamSize(paramList).booleanValue()) {
            return this.resultMapWithCode(Boolean.FALSE, "data can not more than 1000", null, "302");
        }
        HashSet<String> nameCardPhoneSet = new HashSet<String>();
        for (Map<String, Object> paramMap : paramList) {
            Boolean result = this.checkMustParam(paramMap);
            if (result.booleanValue()) {
                Boolean typeResult = this.checkParamDataType(paramMap);
                if (!typeResult.booleanValue()) {
                    String tip = ResManager.loadKDString((String)"\u5b58\u5728\u59d3\u540d\u6216\u624b\u673a\u53f7\u7801\u6216\u52a0\u5165\u9ed1\u540d\u5355\u539f\u56e0\u6570\u636e\u7c7b\u578b\u4e0d\u7b26\u5408\u8981\u6c42\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BlackListServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
                    return this.resultMapWithCode(Boolean.FALSE, tip, null, "302");
                }
                boolean isDuplicate = nameCardPhoneSet.add(this.assembleKey(paramMap));
                if (!isDuplicate) {
                    String tip = ResManager.loadKDString((String)"\u5b58\u5728\u59d3\u540d\u548c\u624b\u673a\u53f7\u7801\u548c\u52a0\u5165\u9ed1\u540d\u5355\u539f\u56e0\u90fd\u4e00\u6837\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BlackListServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
                    return this.resultMapWithCode(Boolean.FALSE, tip, null, "302");
                }
                Object maincardtype = paramMap.get("maincardtype");
                Object cardtype = paramMap.get("cardtype");
                Boolean mainCardInfoIsFull = this.checkCardInfoIsFull(paramMap, "maincardtype", "maincardnumber");
                Boolean cardInfoIsFull = this.checkCardInfoIsFull(paramMap, "cardtype", "cardnumber");
                if (!mainCardInfoIsFull.booleanValue() || !cardInfoIsFull.booleanValue()) {
                    String tip = ResManager.loadKDString((String)"\u5b58\u5728\u8bc1\u4ef6\u4fe1\u606f\u586b\u5199\u4e0d\u5b8c\u6574\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BlackListServiceImpl_18", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
                    return this.resultMapWithCode(Boolean.FALSE, tip, null, "302");
                }
                if (HRObjectUtils.isEmpty((Object)cardtype) || !HRObjectUtils.isEmpty((Object)maincardtype)) continue;
                String tip = ResManager.loadKDString((String)"\u5fc5\u987b\u5b58\u5728\u4e00\u6761\u4e3b\u8bc1\u4ef6\u4fe1\u606f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BlackListServiceImpl_19", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
                return this.resultMapWithCode(Boolean.FALSE, tip, null, "302");
            }
            String tip = ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BlackListServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
            return this.resultMapWithCode(result, tip, null, "302");
        }
        return this.commonOperation("1", paramList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> newBlackListForSysPerson(List<Map<String, Object>> paramList) {
        if (this.validateParamIsEmpty(paramList).booleanValue()) {
            return this.resultMapWithCode(Boolean.FALSE, "param is empty", null, "302");
        }
        if (this.validateParamSize(paramList).booleanValue()) {
            return this.resultMapWithCode(Boolean.FALSE, "data can not more than 1000", null, "302");
        }
        String tip = this.validateMustParamBatch(paramList);
        if (HRStringUtils.isNotEmpty((String)tip)) {
            return this.resultMapWithCode(Boolean.FALSE, tip, null, "302");
        }
        HashMap<String, String> operateMap = new HashMap<String, String>(paramList.size());
        try (TXHandle required = TX.required();){
            Map<Long, DynamicObject> existEmpDyMap = this.getExistBlacklistMapByEmpId(paramList);
            List<Map<String, Object>> noExistDyMapList = this.filterExistedData(paramList, existEmpDyMap, operateMap);
            Map<String, Object> quitInfoMap = this.getQuitInfByEmpId(CollectionUtils.isEmpty(existEmpDyMap) ? paramList : noExistDyMapList);
            List<Map<String, Object>> blacklistInfoMapList = this.assembleSysPersonBlacklist(CollectionUtils.isEmpty(existEmpDyMap) ? paramList : noExistDyMapList, quitInfoMap, operateMap);
            List<DynamicObject> dynamicObjects = HRPIBlackListRepository.getInstance().assembleDy(blacklistInfoMapList);
            HRPIBlackListRepository.getInstance().saveAtt(dynamicObjects.toArray(new DynamicObject[0]));
            Set<String> empSet = quitInfoMap.keySet();
            empSet.stream().forEach(str -> operateMap.put((String)str, "insert success"));
            dynamicObjects.forEach(dynamicObject -> BlackListForPageUtils.getInstance().saveBlackListLog("1", (DynamicObject)dynamicObject, null));
            if (paramList.size() == dynamicObjects.size()) {
                Map<String, Object> map = this.resultMapWithCode(Boolean.TRUE, "all success", operateMap, "300");
                return map;
            }
            Map<String, Object> map = this.resultMapWithCode(Boolean.TRUE, "some success", operateMap, "301");
            return map;
        }
    }

    private List<Map<String, Object>> filterExistedData(List<Map<String, Object>> paramList, Map<Long, DynamicObject> existEmpDyMap, Map<String, String> operateMap) {
        List<Map<String, Object>> noExistDyMapList = new ArrayList<Map<String, Object>>();
        if (!CollectionUtils.isEmpty(existEmpDyMap)) {
            paramList.stream().filter(map -> !HRObjectUtils.isEmpty(existEmpDyMap.get(Long.valueOf(String.valueOf(map.get("employee")))))).forEach(map -> operateMap.put(String.valueOf(map.get("employee")), "data existed already"));
            noExistDyMapList = paramList.stream().filter(map -> HRObjectUtils.isEmpty(existEmpDyMap.get(Long.valueOf(String.valueOf(map.get("employee")))))).collect(Collectors.toList());
        }
        return noExistDyMapList;
    }

    private Map<Long, DynamicObject> getExistBlacklistMapByEmpId(List<Map<String, Object>> paramList) {
        List empIdList = paramList.stream().map(map -> Long.valueOf(String.valueOf(map.get("employee")))).collect(Collectors.toList());
        QFilter empFilter = new QFilter("employee", "in", empIdList);
        DynamicObject[] existDys = HRPIBlackListRepository.getInstance().queryByFilter("employee,number", new QFilter[]{empFilter});
        return Arrays.stream(existDys).collect(Collectors.toMap(dy -> dy.getLong("employee.id"), dy -> dy, (oldDy, newDy) -> newDy));
    }

    @Override
    public Map<String, Object> editBlackList(List<Map<String, Object>> paramList) {
        if (this.validateParamIsEmpty(paramList).booleanValue()) {
            return this.resultMapWithCode(Boolean.FALSE, "param is empty", null, "302");
        }
        if (this.validateParamSize(paramList).booleanValue()) {
            return this.resultMapWithCode(Boolean.FALSE, "data can not more than 1000", null, "302");
        }
        HashSet<String> duplicatNumberSet = new HashSet<String>(paramList.size());
        for (Map<String, Object> map : paramList) {
            Object number = map.get("number");
            Object issysperson = map.get("issysperson");
            if ("0".equals(String.valueOf(issysperson)) && HRObjectUtils.isEmpty((Object)number)) {
                return this.resultMapWithCode(Boolean.FALSE, "no system person,number is must input,please check data", null, "302");
            }
            Object employee = map.get("employee");
            Object empnumber = map.get("empnumber");
            if ("1".equals(String.valueOf(issysperson)) && HRObjectUtils.isEmpty((Object)employee) && HRObjectUtils.isEmpty((Object)empnumber)) {
                return this.resultMapWithCode(Boolean.FALSE, "inner person,must input one of employee or empnumber,please check data.", null, "302");
            }
            boolean isExistNum = duplicatNumberSet.add(String.valueOf(number));
            if (isExistNum) continue;
            return this.resultMapWithCode(Boolean.FALSE, "exist duplicate number data", null, "302");
        }
        return this.commonOperation("3", paramList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> commonOperation(String operateType, List<Map<String, Object>> paramList) {
        Map<String, Object> errKey;
        HashMap<String, String> operateMap = new HashMap<String, String>();
        ArrayList<Map<String, Object>> dyList = new ArrayList<Map<String, Object>>(paramList.size());
        HashSet<String> rightSet = new HashSet<String>();
        for (Map<String, Object> paramMap : paramList) {
            Map<String, Object> dyMap = new HashMap<String, Object>(1);
            dyMap.putAll(paramMap);
            Object numKey = paramMap.get("number");
            Map<String, Object> map = errKey = HRObjectUtils.isEmpty((Object)numKey) ? this.assembleKey(paramMap) : String.valueOf(numKey);
            if ("1".equals(operateType) && "1".equals(String.valueOf(paramMap.get("issysperson"))) && HRObjectUtils.isEmpty((Object)paramMap.get("employee"))) {
                this.tipAssemble(operateMap, (String)((Object)errKey), ResManager.loadKDString((String)"\u4eba\u5458\u7c7b\u578b\u4e3a\u7cfb\u7edf\u5185\u4eba\u5458\u65f6,\u4f01\u4e1a\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a;", (String)"BlackListServiceImpl_17", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            if ("1".equals(operateType) && "0".equals(String.valueOf(paramMap.get("issysperson"))) && !HRObjectUtils.isEmpty((Object)paramMap.get("employee"))) {
                this.tipAssemble(operateMap, (String)((Object)errKey), ResManager.loadKDString((String)"\u4eba\u5458\u7c7b\u578b\u4e3a\u7cfb\u7edf\u5916\u4eba\u5458\u65f6,\u4f01\u4e1a\u4ebaID\u4e0d\u9700\u8981\u586b\u5199;", (String)"BlackListServiceImpl_21", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            if (!HRObjectUtils.isEmpty((Object)paramMap.get("gender"))) {
                dyMap = this.assembleBaseData(dyMap, paramMap, operateMap, "hbss_sex", "gender");
            }
            if (!HRObjectUtils.isEmpty((Object)paramMap.get("nation"))) {
                dyMap = this.assembleBaseData(dyMap, paramMap, operateMap, "hbss_nationality", "nation");
            }
            dyMap = this.assembleBaseData(dyMap, paramMap, operateMap, "hrpi_toblacklistreason", "toreason");
            dyMap = this.assembleBaseData(dyMap, paramMap, operateMap, "haos_adminorghr", "adminororg");
            if (!HRObjectUtils.isEmpty((Object)paramMap.get("maincardtype"))) {
                dyMap = this.assembleBaseData(dyMap, paramMap, operateMap, "hbss_credentialstype", "maincardtype");
            }
            if (!HRObjectUtils.isEmpty((Object)paramMap.get("employee"))) {
                dyMap = this.checkEmployeeIsExist(dyMap, paramMap, operateMap, "hrpi_employee", "employee", operateType);
            }
            if (!HRObjectUtils.isEmpty((Object)paramMap.get("cardtype"))) {
                dyMap = this.assembleBaseData(dyMap, paramMap, operateMap, "hbss_credentialstype", "cardtype");
            }
            if (!"3".equals(String.valueOf(paramMap.get("datasource")))) {
                LOGGER.info("commonOperation.datasource={}", (Object)String.valueOf(paramMap.get("datasource")));
                dyMap = this.assembleBaseData(dyMap, paramMap, operateMap, "haos_adminorghr", "adminorg");
                dyMap = this.assembleBaseData(dyMap, paramMap, operateMap, "hbpm_positionhr", "position");
                dyMap = this.assembleBaseData(dyMap, paramMap, operateMap, "hbjm_jobhr", "job");
                dyMap = this.assembleBaseData(dyMap, paramMap, operateMap, "htm_quitreason", "quitreason");
                dyMap = this.assembleBaseData(dyMap, paramMap, operateMap, "htm_quittypenew", "quittype");
            }
            Object maincardnumber = dyMap.get("maincardnumber");
            Object maincardtype = dyMap.get("maincardtype");
            this.checkIdFormat((Map<String, String>)operateMap, (String)((Object)errKey), maincardtype, maincardnumber);
            Object cardtype = dyMap.get("cardtype");
            Object cardnumber = dyMap.get("cardnumber");
            this.checkIdFormat((Map<String, String>)operateMap, (String)((Object)errKey), cardtype, cardnumber);
            if (!HRObjectUtils.isEmpty((Object)cardtype) && !HRObjectUtils.isEmpty((Object)maincardtype) && cardtype instanceof DynamicObject && maincardtype instanceof DynamicObject && ((DynamicObject)maincardtype).getString("number").equals(((DynamicObject)cardtype).getString("number"))) {
                this.tipAssemble((Map<String, String>)operateMap, (String)((Object)errKey), ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u4eba\u4e0d\u80fd\u8f93\u5165\u4e24\u4e2a\u4e00\u6837\u7684\u8bc1\u4ef6\u7c7b\u578b;", (String)"BlackListServiceImpl_14", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            if (!HRStringUtils.isEmpty((String)((String)operateMap.get(errKey)))) continue;
            dyList.add(dyMap);
            rightSet.add((String)((Object)errKey));
        }
        if (CollectionUtils.isEmpty(dyList)) {
            return this.resultMapWithCode(Boolean.FALSE, "all data can not pass validate", operateMap, "304");
        }
        TXHandle tx = TX.required();
        List<Object> assembleDyList = new ArrayList(dyList.size());
        HashMap<String, DynamicObject> sourceDyMap = new HashMap<String, DynamicObject>(dyList.size());
        try {
            if ("1".equals(operateType)) {
                assembleDyList = HRPIBlackListRepository.getInstance().assembleDy(dyList);
            }
            if ("3".equals(operateType)) {
                assembleDyList = HRPIBlackListRepository.getInstance().assembleDyEdit(dyList, operateMap, rightSet, sourceDyMap);
            }
            HRPIBlackListRepository.getInstance().saveAtt(assembleDyList.toArray(new DynamicObject[0]));
            assembleDyList.forEach(dynamicObject -> {
                DynamicObject sourceDy = (DynamicObject)sourceDyMap.get(dynamicObject.getString("number"));
                BlackListForPageUtils.getInstance().saveBlackListLog(operateType, (DynamicObject)dynamicObject, HRObjectUtils.isEmpty((Object)sourceDy) ? null : sourceDy);
            });
            HashMap successMap = new HashMap(rightSet.size());
            rightSet.stream().forEach(keyStr -> successMap.put(keyStr, "success"));
            if (CollectionUtils.isEmpty(operateMap)) {
                errKey = this.resultMapWithCode(Boolean.TRUE, "all success", successMap, "300");
                return errKey;
            }
            operateMap.putAll(successMap);
            errKey = this.resultMapWithCode(Boolean.TRUE, "some sucess", operateMap, "301");
            return errKey;
        }
        catch (Exception ex) {
            LOGGER.error("BlackListServiceImpl.newBlackList.error", (Throwable)ex);
            HashMap<String, String> failMap = new HashMap<String, String>(rightSet.size());
            rightSet.stream().forEach(keyStr -> failMap.put((String)keyStr, "fail to operation for exe"));
            if (!CollectionUtils.isEmpty(operateMap)) {
                failMap.putAll(operateMap);
            }
            tx.markRollback();
            Map<String, Object> map = this.resultMapWithCode(Boolean.FALSE, "fail", failMap, "304");
            return map;
        }
        finally {
            tx.close();
        }
    }

    private void checkIdFormat(Map<String, String> operateMap, String errKey, Object cardType, Object cardNumber) {
        if (!HRObjectUtils.isEmpty((Object)cardType) && cardType instanceof DynamicObject && "1010_S".equals(((DynamicObject)cardType).getString("number")) && !HRObjectUtils.isEmpty((Object)cardNumber) && this.checkIsString(cardNumber).booleanValue() && !CommonServiceUtil.validIdentityCardNo(null, "CN01", String.valueOf(cardNumber))) {
            this.tipAssemble(operateMap, errKey, ResManager.loadKDString((String)"\u8eab\u4efd\u8bc1\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b", (String)"BlackListServiceImpl_13", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    private Boolean checkIsString(Object isString) {
        if (!(isString instanceof String)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Map<String, Object> assembleBaseData(Map<String, Object> dyMap, Map<String, Object> paramMap, Map<String, String> operateMap, String entity, String field) {
        String errKey = this.getErrKey(paramMap);
        Object fieldToValue = paramMap.get(field);
        if (!HRObjectUtils.isEmpty((Object)fieldToValue)) {
            if (fieldToValue instanceof String) {
                DynamicObject[] dys = this.queryBaseDataByName(entity, String.valueOf(fieldToValue));
                if (dys.length == 0) {
                    this.tipAssemble(operateMap, errKey, ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff1b", (String)"BlackListServiceImpl_9", (String)"hrmp-hrpi-business", (Object[])new Object[]{field}));
                    dyMap.put(field, null);
                    return dyMap;
                }
                if (dys.length > 1) {
                    this.tipAssemble(operateMap, errKey, ResManager.loadKDString((String)"\u6839\u636e%s\u4e0d\u80fd\u5b9a\u4f4d\u5230\u552f\u4e00\u7684\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u68c0\u67e5\uff1b", (String)"BlackListServiceImpl_10", (String)"hrmp-hrpi-business", (Object[])new Object[]{field}));
                    dyMap.put(field, null);
                    return dyMap;
                }
                dyMap.put(field, dys[0]);
                return dyMap;
            }
            LOGGER.info("data.type.mismatch ={}", (Object)field);
            this.tipAssemble(operateMap, errKey, ResManager.loadKDString((String)"%s\u6570\u636e\u7c7b\u578b\u4e0d\u7b26\u5408\u7cfb\u7edf\u8981\u6c42\uff0c\u8bf7\u68c0\u67e5\uff1b", (String)"BlackListServiceImpl_11", (String)"hrmp-hrpi-business", (Object[])new Object[]{field}));
            dyMap.put(field, null);
            return dyMap;
        }
        return dyMap;
    }

    private String getErrKey(Map<String, Object> paramMap) {
        if ("3".equals(String.valueOf(paramMap.get("datasource"))) && "1".equals(paramMap.get("issysperson"))) {
            return paramMap.get("employee") + "";
        }
        Object numKey = paramMap.get("number");
        String errKey = HRObjectUtils.isEmpty((Object)numKey) ? this.assembleKey(paramMap) : String.valueOf(numKey);
        return errKey;
    }

    private Map<String, Object> checkEmployeeIsExist(Map<String, Object> dyMap, Map<String, Object> paramMap, Map<String, String> operateMap, String entity, String field, String operateType) {
        Object numKey = paramMap.get("number");
        String errKey = HRObjectUtils.isEmpty((Object)numKey) ? this.assembleKey(paramMap) : String.valueOf(numKey);
        Object fieldToValue = paramMap.get(field);
        if (fieldToValue instanceof Long) {
            DynamicObject dynamicObject = this.queryBaseDataById(entity, (Long)fieldToValue);
            if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
                this.tipAssemble(operateMap, errKey, ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff1b", (String)"BlackListServiceImpl_9", (String)"hrmp-hrpi-business", (Object[])new Object[]{field}));
                dyMap.put(field, null);
                return dyMap;
            }
            if ("1".equals(operateType)) {
                QFilter employeeFilter = new QFilter("employee", "=", fieldToValue);
                DynamicObject[] blackListDys = HRPIBlackListRepository.getInstance().queryByFilter("id,number,employee", new QFilter[]{employeeFilter});
                if (blackListDys.length != 0) {
                    this.tipAssemble(operateMap, errKey, ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u5b58\u5728\u9ed1\u540d\u5355\u4e2d\uff1b", (String)"BlackListServiceImpl_16", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                    dyMap.put(field, null);
                    return dyMap;
                }
            }
            dyMap.put(field, dynamicObject);
            return dyMap;
        }
        this.tipAssemble(operateMap, errKey, ResManager.loadKDString((String)"%s\u6570\u636e\u7c7b\u578b\u4e0d\u7b26\u5408\u7cfb\u7edf\u8981\u6c42\uff0c\u8bf7\u68c0\u67e5\uff1b", (String)"BlackListServiceImpl_11", (String)"hrmp-hrpi-business", (Object[])new Object[]{field}));
        dyMap.put(field, null);
        return dyMap;
    }

    private void tipAssemble(Map<String, String> operateMap, String errKey, String tipMsg) {
        if (HRStringUtils.isEmpty((String)tipMsg)) {
            return;
        }
        String existedMsg = operateMap.get(errKey);
        if (HRObjectUtils.isEmpty((Object)existedMsg)) {
            operateMap.put(errKey, tipMsg);
            return;
        }
        operateMap.put(errKey, existedMsg + tipMsg);
    }

    private DynamicObject[] queryBaseDataByName(String entityName, String field) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        QFilter filter = new QFilter("name", "=", (Object)field);
        if ("haos_adminorghr".equals(entityName)) {
            QFilter isCurrentFileter = new QFilter("iscurrentversion", "=", (Object)"1");
            return serviceHelper.query("id,number", new QFilter[]{filter, isCurrentFileter});
        }
        return serviceHelper.query("id,number", new QFilter[]{filter});
    }

    private DynamicObject queryBaseDataById(String entityName, Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        return serviceHelper.queryOne("id,number", (Object)id);
    }

    private Boolean checkParamDataType(Map<String, Object> paramMap) {
        Object name = paramMap.get("name");
        Object toreason = paramMap.get("toreason");
        Object phone = paramMap.get("phone");
        if (!(name instanceof String && toreason instanceof String && phone instanceof String)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private String assembleKey(Map<String, Object> paramMap) {
        Object name = paramMap.get("name");
        Object phone = paramMap.get("phone");
        Object toreason = paramMap.get("toreason");
        if (name instanceof String && toreason instanceof String && phone instanceof String) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(name).append(phone).append(toreason);
            return stringBuilder.toString();
        }
        return "";
    }

    private Boolean checkMustParam(Map<String, Object> paramMap) {
        Object name = paramMap.get("name");
        Object toreason = paramMap.get("toreason");
        Object phone = paramMap.get("phone");
        Object issysperson = paramMap.get("issysperson");
        Object datasource = paramMap.get("datasource");
        Object adminororg = paramMap.get("adminororg");
        if (HRObjectUtils.isEmpty((Object)name) || HRObjectUtils.isEmpty((Object)toreason) || HRObjectUtils.isEmpty((Object)phone) || HRObjectUtils.isEmpty((Object)issysperson) || HRObjectUtils.isEmpty((Object)datasource) || HRObjectUtils.isEmpty((Object)adminororg)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkCardInfoIsFull(Map<String, Object> paramMap, String typeKey, String numKey) {
        Object cardtype = paramMap.get(typeKey);
        Object cardnumber = paramMap.get(numKey);
        if (!HRObjectUtils.isEmpty((Object)cardtype) && HRObjectUtils.isEmpty((Object)cardnumber) || HRObjectUtils.isEmpty((Object)cardtype) && !HRObjectUtils.isEmpty((Object)cardnumber)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> deleteBlackList(Map<String, Object> paramMap) {
        if (CollectionUtils.isEmpty(paramMap) || HRObjectUtils.isEmpty((Object)paramMap.get("number")) || HRObjectUtils.isEmpty((Object)paramMap.get("rmReason")) || HRObjectUtils.isEmpty((Object)"reReasonDetail")) {
            LOGGER.info("BlackListServiceImpl.deleteBlackList.param={}", (Object)LogPrivacyUtil.filterPrivacyProp(paramMap));
            return this.resultMap(Boolean.FALSE, "param is empty or must param is empty", null);
        }
        try (TXHandle tx = TX.required();){
            Object number = paramMap.get("number");
            QFilter numFilter = new QFilter("number", "=", number);
            QFilter[] qFilters = new QFilter[]{numFilter};
            DynamicObject[] dynamicObjects = this.queryBaseDataByName("hrpi_blacklistrmreason", String.valueOf(paramMap.get("rmReason")));
            if (dynamicObjects.length == 0 || dynamicObjects.length > 1) {
                Map<String, Object> map = this.resultMap(Boolean.FALSE, "rmreason base data do not exist or more than one by name", null);
                return map;
            }
            DynamicObject dynamicObject = HRPIBlackListRepository.getInstance().queryOne("", qFilters);
            if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
                LOGGER.info("BlackListServiceImpl.deleteBlackList.queryByNumber.result={}", (Object)dynamicObject);
                Map<String, Object> map = this.resultMap(Boolean.FALSE, "the person do not exist in black list", null);
                return map;
            }
            HRPIBlackListRepository.getInstance().delAttment(qFilters);
            HRBaseServiceHelper rmServiceHelper = new HRBaseServiceHelper("hpfs_rmblacklist");
            DynamicObject rmDy = rmServiceHelper.generateEmptyDynamicObject();
            rmDy.set("rmreasonstr", paramMap.get("rmReason"));
            rmDy.set("rmreasondetail", paramMap.get("rmReasonDetail"));
            Map<String, Object> result = BlackListForPageUtils.getInstance().saveBlackListLog("2", dynamicObject, rmDy);
            if (CollectionUtils.isEmpty(result) || result.get("success") instanceof Boolean && !((Boolean)result.get("success")).booleanValue()) {
                Map<String, Object> map = this.resultMap(Boolean.FALSE, "fail to save operation log", null);
                return map;
            }
            Map<String, Object> map = this.resultMap(Boolean.TRUE, "delete success", null);
            return map;
        }
    }

    @Override
    public Map<String, Object> getBlacklistInfo(Map<String, Object> paramMap) {
        Map<String, String> validateMap = this.validateCardTypeAndNum(paramMap);
        if (!CollectionUtils.isEmpty(validateMap)) {
            return this.resultMapWithCode(Boolean.FALSE, "param check fail", validateMap, "303");
        }
        HashMap<String, String> paramKeyMap = new HashMap<String, String>(paramMap.size());
        HashSet<String> fieldSet = new HashSet<String>();
        List<QFilter> filterList = this.assembleQFilters(paramMap, paramKeyMap, fieldSet);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(paramMap.size());
        try {
            DynamicObject[] dynamicObjects = HRPIBlackListRepository.getInstance().queryByFilter("", filterList.toArray(new QFilter[0]));
            List<Map<String, Object>> dyMapList = this.resultTransferList(dynamicObjects);
            if (CollectionUtils.isEmpty(dyMapList)) {
                return this.resultMapWithCode(Boolean.TRUE, "success but no data", resultMap, "301");
            }
            this.assembleResultMap(dyMapList, resultMap, paramKeyMap, fieldSet);
            return this.resultMapWithCode(Boolean.TRUE, "success", resultMap, "300");
        }
        catch (Exception exe) {
            LOGGER.error("BlackListServiceImpl.getBlacklistInfo.error", (Throwable)exe);
            return this.resultMapWithCode(Boolean.FALSE, "fail for exe", resultMap, "304");
        }
    }

    private void assembleResultMap(List<Map<String, Object>> dyMapList, Map<String, Object> resultMap, Map<String, String> paramKeyMap, Set<String> fieldSet) {
        LOGGER.info("BlackListServiceImpl.assembleResultMap.dyMapList={}", dyMapList);
        for (Map<String, Object> map : dyMapList) {
            StringBuilder mainCardKey = new StringBuilder();
            StringBuilder notMainCardKey = new StringBuilder();
            this.isContainKey(map, fieldSet, "name", mainCardKey, notMainCardKey);
            this.isContainKey(map, fieldSet, "phone", mainCardKey, notMainCardKey);
            this.isContainKey(map, fieldSet, "email", mainCardKey, notMainCardKey);
            this.isContainKey(map, fieldSet, "cardtype", mainCardKey, notMainCardKey);
            this.isContainKey(map, fieldSet, "cardnumber", mainCardKey, notMainCardKey);
            String mainKey = paramKeyMap.get(mainCardKey.toString());
            String notMainKey = paramKeyMap.get(notMainCardKey.toString());
            resultMap.put(HRStringUtils.isEmpty((String)mainKey) ? notMainKey : mainKey, map);
        }
    }

    private void isContainKey(Map<String, Object> map, Set<String> fieldSet, String fieldKey, StringBuilder mainCardKey, StringBuilder notMainCardKey) {
        if (fieldSet.contains(fieldKey)) {
            if ("cardtype".equals(fieldKey)) {
                mainCardKey.append(map.get("maincardtypeid"));
                notMainCardKey.append(map.get("cardtypeid"));
                return;
            }
            if ("cardnumber".equals(fieldKey)) {
                mainCardKey.append(map.get("maincardnumber"));
                notMainCardKey.append(map.get("cardnumber"));
                return;
            }
            mainCardKey.append(map.get(fieldKey));
            notMainCardKey.append(map.get(fieldKey));
        }
    }

    private List<QFilter> assembleQFilters(Map<String, Object> paramMap, Map<String, String> paramKeyMap, Set<String> fieldSet) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        ArrayList<Object> nameList = new ArrayList<Object>();
        ArrayList<Object> cardtypeList = new ArrayList<Object>();
        ArrayList<Object> cardnumberList = new ArrayList<Object>();
        ArrayList<Object> emailList = new ArrayList<Object>();
        ArrayList<Object> phoneList = new ArrayList<Object>();
        for (Map.Entry<String, Object> stringObjectEntry : paramMap.entrySet()) {
            StringBuilder stringKey = new StringBuilder();
            String key = stringObjectEntry.getKey();
            Map value = (Map)stringObjectEntry.getValue();
            this.assempleParamList(value, nameList, stringKey, "name", fieldSet);
            this.assempleParamList(value, phoneList, stringKey, "phone", fieldSet);
            this.assempleParamList(value, emailList, stringKey, "email", fieldSet);
            this.assempleParamList(value, cardtypeList, stringKey, "cardtype", fieldSet);
            this.assempleParamList(value, cardnumberList, stringKey, "cardnumber", fieldSet);
            paramKeyMap.put(stringKey.toString(), key);
        }
        this.assembleFilterList(filterList, nameList, "name");
        this.assembleFilterList(filterList, phoneList, "phone");
        this.assembleFilterList(filterList, emailList, "email");
        this.assembleFilterList(filterList, cardtypeList, "entryentity.cardtype");
        this.assembleFilterList(filterList, cardnumberList, "entryentity.cardnumber");
        return filterList;
    }

    private void assembleFilterList(List<QFilter> filterList, List<Object> paramList, String fieldKey) {
        if (!CollectionUtils.isEmpty(paramList)) {
            QFilter nameFilter = new QFilter(fieldKey, "in", paramList);
            filterList.add(nameFilter);
        }
    }

    private void assempleParamList(Map<String, Object> value, List<Object> list, StringBuilder stringKey, String fieldKey, Set<String> fieldSet) {
        Object fieldValue = value.get(fieldKey);
        if (!HRObjectUtils.isEmpty((Object)fieldValue)) {
            list.add(fieldValue);
            stringKey.append(fieldValue);
            fieldSet.add(fieldKey);
        }
    }

    private Map<String, String> validateCardTypeAndNum(Map<String, Object> paramMap) {
        HashMap<String, String> validateMap = new HashMap<String, String>(paramMap.size());
        for (Map.Entry<String, Object> stringObjectEntry : paramMap.entrySet()) {
            String key = stringObjectEntry.getKey();
            Object value = stringObjectEntry.getValue();
            if (!(value instanceof Map)) {
                validateMap.put(key, "value data type error");
                continue;
            }
            Map map = (Map)value;
            Object cardtype = map.get("cardtype");
            Object cardnumber = map.get("cardnumber");
            if ((HRObjectUtils.isEmpty(cardtype) || !HRObjectUtils.isEmpty(cardnumber)) && (!HRObjectUtils.isEmpty(cardtype) || HRObjectUtils.isEmpty(cardnumber))) continue;
            validateMap.put(key, "cardtype and cardnumber should keep consistent.");
        }
        LOGGER.info("BlackListServiceImpl.validateCardTypeAndNum.result={}", validateMap);
        return validateMap;
    }

    private Map<String, Object> resultMap(Boolean result, String msg, Object data) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", result);
        resultMap.put("message", msg);
        resultMap.put("data", data);
        return resultMap;
    }

    private Map<String, Object> resultMapWithCode(Boolean result, String msg, Object data, String code) {
        Map<String, Object> resultMap = this.resultMap(result, msg, data);
        resultMap.put("code", code);
        return resultMap;
    }

    private Boolean validateParamIsEmpty(List<Map<String, Object>> paramList) {
        return CollectionUtils.isEmpty(paramList);
    }

    private Boolean validateParamSize(List<Map<String, Object>> paramList) {
        return paramList.size() > 1000;
    }

    private String validateMustParamBatch(List<Map<String, Object>> paramList) {
        for (Map<String, Object> map : paramList) {
            Object quitdate;
            Object employee = map.get("employee");
            Object name = map.get("name");
            Object toreason = map.get("toreason");
            Object datasource = map.get("datasource");
            Object issysperson = map.get("issysperson");
            if (HRObjectUtils.isEmpty((Object)employee) || HRObjectUtils.isEmpty((Object)name) || HRObjectUtils.isEmpty((Object)toreason) || HRObjectUtils.isEmpty((Object)datasource) || HRObjectUtils.isEmpty((Object)issysperson)) {
                return ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BlackListServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
            }
            if (!(employee instanceof Long && name instanceof String && toreason instanceof String && datasource instanceof String && issysperson instanceof String)) {
                return ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BlackListServiceImpl_28", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
            }
            String datasourceStr = String.valueOf(datasource);
            if (!"3".equals(datasourceStr) || !HRObjectUtils.isEmpty((Object)(quitdate = map.get("quitdate")))) continue;
            return ResManager.loadKDString((String)"\u79bb\u804c\u4eba\u5458\u7684\u79bb\u804c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BlackListServiceImpl_29", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
        }
        return "";
    }

    private Map<String, Object> getQuitInfByEmpId(List<Map<String, Object>> paramList) {
        List<Long> empIdList = paramList.stream().map(map -> Long.valueOf(String.valueOf(map.get("employee")))).collect(Collectors.toList());
        BlackListEmpInfoServiceImpl empInfoService = new BlackListEmpInfoServiceImpl();
        return empInfoService.queryOutEmpInfoByEmpId(empIdList);
    }

    private List<Map<String, Object>> assembleSysPersonBlacklist(List<Map<String, Object>> paramList, Map<String, Object> quitInfoMap, Map<String, String> operateMap) {
        for (Map<String, Object> map : paramList) {
            String datasource = String.valueOf(map.get("datasource"));
            String empIdStr = String.valueOf(map.get("employee"));
            Object quitInfoObj = quitInfoMap.get(empIdStr);
            if (!HRObjectUtils.isEmpty((Object)quitInfoObj) && quitInfoObj instanceof Map) {
                Map quitDyMap = (Map)quitInfoObj;
                quitDyMap.put("issysperson", map.get("issysperson"));
                quitDyMap.put("datasource", map.get("datasource"));
                quitDyMap.put("reasondetail", map.get("reasondetail"));
                this.assembleBaseData(quitDyMap, map, operateMap, "hrpi_toblacklistreason", "toreason");
                if (!"3".equals(datasource)) continue;
                if (!HRObjectUtils.isEmpty((Object)map.get("phone"))) {
                    quitDyMap.put("phone", map.get("phone"));
                }
                if (!HRObjectUtils.isEmpty((Object)map.get("email"))) {
                    quitDyMap.put("email", map.get("email"));
                }
                quitDyMap.put("quitreason", map.get("quitreason"));
                quitDyMap.put("quittype", map.get("quittype"));
                quitDyMap.put("quitdate", map.get("quitdate"));
                quitDyMap.put("creator", map.get("creator"));
                continue;
            }
            operateMap.put(empIdStr, ResManager.loadKDString((String)"\u6839\u636e\u4f01\u4e1a\u4ebaID\u67e5\u4e0d\u5230\u79bb\u804c\u4eba\u5458\u4fe1\u606f\u3002", (String)"BlackListServiceImpl_27", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        ArrayList<Map<String, Object>> blacklistInfoMapList = new ArrayList<Map<String, Object>>(quitInfoMap.size());
        Set<Map.Entry<String, Object>> entries = quitInfoMap.entrySet();
        Iterator<Map.Entry<String, Object>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> map = iterator.next();
            Object value = map.getValue();
            String key = map.getKey();
            if (!HRObjectUtils.isEmpty((Object)value) && value instanceof Map) {
                Map objDyMap = (Map)value;
                blacklistInfoMapList.add(objDyMap);
                continue;
            }
            operateMap.put(key, ResManager.loadKDString((String)"\u6839\u636e\u4f01\u4e1a\u4ebaID\u67e5\u4e0d\u5230\u79bb\u804c\u4eba\u5458\u4fe1\u606f\u3002", (String)"BlackListServiceImpl_27", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            iterator.remove();
        }
        return blacklistInfoMapList;
    }
}

