/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.application.impl.charge.ChargePersonParam;
import kd.hrmp.hrpi.business.domian.repository.HRPIChargeLogRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIChargePersonRepository;
import kd.hrmp.hrpi.business.domian.service.IChargeService;
import kd.hrmp.hrpi.common.HRPIChargePersonConstants;
import kd.hrmp.hrpi.common.enums.ChangeSourceEnum;
import kd.hrmp.hrpi.common.model.charge.ModifyResult;

public class ChargeServiceImpl
implements IChargeService,
HRPIChargePersonConstants {
    private static final Log logger = LogFactory.getLog(ChargeServiceImpl.class);
    private static volatile IChargeService CHARGESERVICE;
    private HRPIChargePersonRepository chargeRepository = HRPIChargePersonRepository.getInstance();
    private HRPIChargeLogRepository chargeLogRepository = HRPIChargeLogRepository.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IChargeService getInstance() {
        try {
            if (null != CHARGESERVICE) return CHARGESERVICE;
            Class<ChargeServiceImpl> clazz = ChargeServiceImpl.class;
            synchronized (ChargeServiceImpl.class) {
                if (null != CHARGESERVICE) return CHARGESERVICE;
                try {
                    CHARGESERVICE = new ChargeServiceImpl();
                    logger.info("HRPIServiceFactory-dependency-check,new-ChargeServiceImpl()-success");
                }
                catch (Throwable t) {
                    logger.error("HRPIServiceFactory-dependency-check,new-ChargeServiceImpl()-fail", t);
                }
                return CHARGESERVICE;
            }
        }
        catch (Throwable t) {
            logger.error("HRPIServiceFactory-dependency-check,ChargeServiceImpl-getInstance()-fail", t);
        }
        return CHARGESERVICE;
    }

    @Override
    public void addChargePerson(List<DynamicObject> chargePersons) {
        Date nowWithoutTime = HRDateTimeUtils.truncateDate((Date)new Date());
        for (DynamicObject chargePerson : chargePersons) {
            if (chargePerson.getDate("leffdt").after(nowWithoutTime)) {
                chargePerson.set("datastatus", (Object)"1");
                continue;
            }
            chargePerson.set("datastatus", (Object)"2");
        }
        this.chargeRepository.save(chargePersons.toArray(new DynamicObject[0]));
    }

    @Override
    public void removeChargePerson(List<DynamicObject> chargePersonList) {
        for (DynamicObject chargePerson : chargePersonList) {
            if (chargePerson.getDate("leffdt").before(chargePerson.getDate("effdt"))) {
                chargePerson.set("datastatus", (Object)"-2");
                continue;
            }
            chargePerson.set("datastatus", (Object)"2");
        }
        this.chargeRepository.save(chargePersonList.toArray(new DynamicObject[0]));
    }

    private ModifyResult modifyChargePerson(DynamicObject chargePerson, boolean changeCheck) {
        ModifyResult returnResult = new ModifyResult();
        DynamicObject oldChargePerson = this.chargeRepository.loadOneById(chargePerson.getLong("id"));
        DynamicObject newChargePerson = this.chargeRepository.getServiceHelper().generateEmptyDynamicObject();
        if (changeCheck && oldChargePerson.getDate("effdt").getTime() == chargePerson.getDate("effdt").getTime() && oldChargePerson.getString("ismain").equals(chargePerson.getString("ismain"))) {
            return null;
        }
        HRDynamicObjectUtils.copy((DynamicObject)chargePerson, (DynamicObject)newChargePerson);
        long id = ORM.create().genLongId("hrpi_chargeperson");
        newChargePerson.set("id", (Object)id);
        returnResult.setOldCharge(oldChargePerson);
        returnResult.setNewCharge(newChargePerson);
        oldChargePerson.set("datastatus", (Object)"-2");
        this.chargeRepository.save(new DynamicObject[]{newChargePerson, oldChargePerson});
        return returnResult;
    }

    @Override
    public ModifyResult modifyChargePerson(DynamicObject chargePerson) {
        return this.modifyChargePerson(chargePerson, true);
    }

    @Override
    public void discardChargePerson(List<DynamicObject> chargePersonList) {
        chargePersonList.forEach(chargePerson -> chargePerson.set("datastatus", (Object)"-2"));
        this.chargeRepository.save(chargePersonList.toArray(new DynamicObject[0]));
    }

    @Override
    public ModifyResult modifyChargePersonWithoutCheck(DynamicObject chargePerson) {
        return this.modifyChargePerson(chargePerson, false);
    }

    @Override
    public void writeChargeLog(ChargePersonParam chargePersonParam, String operateType) {
        List<DynamicObject> chargePersonList = chargePersonParam.getChargePersons();
        if (CollectionUtils.isEmpty(chargePersonList) || HRStringUtils.equals((String)operateType, (String)"2")) {
            return;
        }
        Map<Object, Object> orgEffDtGroupMap = Maps.newHashMapWithExpectedSize((int)16);
        if (chargePersonParam.isGroupLog()) {
            for (DynamicObject chargePerson : chargePersonList) {
                long adminOrgId = chargePerson.getLong("adminorg.id");
                Date effDt = chargePerson.getDate("effdt");
                String groupKey2 = adminOrgId + "-" + effDt;
                List chargePersonGroupList2 = orgEffDtGroupMap.getOrDefault(groupKey2, new ArrayList());
                chargePersonGroupList2.add(chargePerson);
                orgEffDtGroupMap.put(groupKey2, chargePersonGroupList2);
            }
        } else {
            orgEffDtGroupMap = chargePersonList.stream().collect(Collectors.groupingBy(chargePersonDy -> chargePersonDy.getString("chargeperson.id") + "-" + chargePersonDy.getString("adminorg.id")));
        }
        HRBaseServiceHelper serviceHelper = this.chargeLogRepository.getServiceHelper();
        ArrayList chargeLogList = Lists.newArrayListWithExpectedSize((int)16);
        orgEffDtGroupMap.forEach((groupKey, chargePersonGroupList) -> {
            DynamicObject chargeLog = serviceHelper.generateEmptyDynamicObject();
            DynamicObject chargePerson = (DynamicObject)chargePersonGroupList.get(0);
            Object adminOrg = chargePerson.get("adminorg");
            chargeLog.set("adminorg", adminOrg);
            chargeLog.set("operatetype", (Object)operateType);
            Date date = "0".equals(operateType) ? chargePerson.getDate("effdt") : chargePerson.getDate("leffdt");
            chargeLog.set("effdt", (Object)date);
            Object chargePersonId = chargePerson.get("chargeperson");
            Object employee = chargePerson.get("chargeperson.employee");
            chargeLog.set("changesource", (Object)chargePersonParam.getChangeSourceId(adminOrg, chargePersonId, employee));
            chargeLog.set("explain", chargePerson.get("explain"));
            chargeLog.set("creator", (Object)RequestContext.get().getCurrUserId());
            DynamicObjectCollection person = chargeLog.getDynamicObjectCollection("person");
            chargePersonGroupList.forEach(item -> {
                DynamicObject object = new DynamicObject(person.getDynamicObjectType());
                object.set("fbasedataid", item.get("chargeperson"));
                person.add((Object)object);
            });
            chargeLogList.add(chargeLog);
        });
        this.chargeLogRepository.save(chargeLogList.toArray(new DynamicObject[0]));
    }

    @Override
    public void writeChargeLog(DynamicObject chargePerson, String operateType, ChangeSourceEnum changeSourceEnum, ModifyResult modifyResult) {
        if (modifyResult == null || chargePerson == null || !HRStringUtils.equals((String)operateType, (String)"2")) {
            return;
        }
        HRBaseServiceHelper serviceHelper = this.chargeLogRepository.getServiceHelper();
        DynamicObject chargeLog = serviceHelper.generateEmptyDynamicObject();
        chargeLog.set("adminorg", chargePerson.get("adminorg"));
        chargeLog.set("operatetype", (Object)operateType);
        chargeLog.set("effdt", chargePerson.get("effdt"));
        chargeLog.set("explain", chargePerson.get("explain"));
        chargeLog.set("changesource", (Object)changeSourceEnum.getId());
        chargeLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        DynamicObjectCollection personList = chargeLog.getDynamicObjectCollection("person");
        DynamicObject person = new DynamicObject(personList.getDynamicObjectType());
        person.set("fbasedataid", (Object)chargePerson.getDynamicObject("chargeperson"));
        personList.add((Object)person);
        DynamicObjectCollection chargeLogEntryList = chargeLog.getDynamicObjectCollection("entryentity");
        if (modifyResult.getOldCharge().getDate("effdt").getTime() != modifyResult.getNewCharge().getDate("effdt").getTime()) {
            DynamicObject chargeLogEntry = new DynamicObject(chargeLogEntryList.getDynamicObjectType());
            chargeLogEntry.set("modifyfieldname", (Object)"effdt");
            chargeLogEntry.set("beforecharge", (Object)modifyResult.getOldCharge());
            chargeLogEntry.set("aftercharge", (Object)modifyResult.getNewCharge());
            chargeLogEntryList.add((Object)chargeLogEntry);
        }
        if (!modifyResult.getOldCharge().getString("ismain").equals(modifyResult.getNewCharge().getString("ismain"))) {
            DynamicObject isMainChargeLogEntry = new DynamicObject(chargeLogEntryList.getDynamicObjectType());
            isMainChargeLogEntry.set("modifyfieldname", (Object)"ismain");
            isMainChargeLogEntry.set("beforecharge", (Object)modifyResult.getOldCharge());
            isMainChargeLogEntry.set("aftercharge", (Object)modifyResult.getNewCharge());
            chargeLogEntryList.add((Object)isMainChargeLogEntry);
        }
        this.chargeLogRepository.saveOne(chargeLog);
    }

    @Override
    public void setPositionCharge(ChargePersonParam chargePersonParam, String operateType) {
        List<DynamicObject> chargePersonList = chargePersonParam.getChargePersons();
        HashMap param = Maps.newHashMapWithExpectedSize((int)chargePersonList.size());
        Set adminOrgIds = chargePersonList.stream().map(chargePerson -> chargePerson.getDynamicObject("chargeperson").getLong("adminorg.id")).collect(Collectors.toSet());
        long adminOrgId0 = chargePersonList.stream().map(chargePerson -> chargePerson.getLong("adminorg.id")).findFirst().get();
        chargePersonList.stream().filter(chargePerson -> {
            long adminOrgId = chargePerson.getLong("adminorg.id");
            DynamicObject depEmpInfo = chargePerson.getDynamicObject("chargeperson");
            String positionType = depEmpInfo.getString("apositiontype");
            long depEmpId = depEmpInfo.getLong("id");
            long employeeId = chargePerson.getLong("chargeperson.employee.id");
            Long changeSourceId = chargePersonParam.getChangeSourceId(adminOrgId, depEmpId, employeeId);
            return "1".equals(operateType) || ChangeSourceEnum.MANUAL_ENTRY.getId().equals(changeSourceId) && ("0".equals(positionType) || "2".equals(positionType));
        }).forEach(chargePerson -> {
            DynamicObject depEmpInfo = chargePerson.getDynamicObject("chargeperson");
            param.put(depEmpInfo.getLong("position.id"), chargePerson.getDate("effdt"));
        });
        if (!CollectionUtils.isEmpty((Map)param)) {
            if (adminOrgIds.contains(adminOrgId0)) {
                logger.info("invoke hbpm IDarkPostionService handlePositionIsLeader method, param:{}, operateType:{}", (Object)JSON.toJSONString((Object)param), (Object)operateType);
                HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IDarkPostionService", (String)"handlePositionIsLeader", (Object[])new Object[]{param, "1".equals(operateType)});
            } else {
                String paramValue = this.queryParamValueOfOdcConfigParam();
                if ("0".equals(operateType) && HRStringUtils.equals((String)"0", (String)paramValue)) {
                    logger.info("outerdeptchargeperson={}", (Object)paramValue);
                    return;
                }
                logger.info("invoke hbpm IDarkPostionService handlePositionIsLeaderV2 method, param:{}, operateType:{}", (Object)JSON.toJSONString((Object)param), (Object)operateType);
                HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IDarkPostionService", (String)"handlePositionIsLeaderV2", (Object[])new Object[]{param, "1".equals(operateType), adminOrgId0});
            }
        }
    }

    private String queryParamValueOfOdcConfigParam() {
        return (String)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSOdcConfigParamService", (String)"queryParamValueOfOdcConfigParam", (Object[])new Object[]{"outerdeptchargeperson"});
    }
}

