/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.qing.util.MapUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hrmp.hrpi.business.application.impl.charge.ChargeApplicationImpl;
import kd.hrmp.hrpi.business.domian.builder.GenericParamBuilder;
import kd.hrmp.hrpi.business.domian.builder.ServiceResultBuilder;
import kd.hrmp.hrpi.business.domian.repository.HBSSBaseDataRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIManFileRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.business.domian.repository.RepositoryUtil;
import kd.hrmp.hrpi.business.domian.service.IDepempService;
import kd.hrmp.hrpi.business.domian.service.IHRPIOperationService;
import kd.hrmp.hrpi.business.domian.service.generic.IPersonGenericService;
import kd.hrmp.hrpi.business.domian.service.impl.HRPIOperationServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.PersonGenericServiceImpl;
import kd.hrmp.hrpi.business.helper.HRPIBusinessDataServiceHelper;
import kd.hrmp.hrpi.business.helper.ResultBuilder;
import kd.hrmp.hrpi.business.helper.ValidateHelper;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.HRPIValueConstants;
import kd.hrmp.hrpi.common.IRPCConstants;
import kd.hrmp.hrpi.common.entity.ChangePrimaryEntity;
import kd.hrmp.hrpi.common.enums.ErrorCodeEnum;

public class DepempServiceImpl
implements IDepempService<DynamicObject> {
    private static final Log LOG = LogFactory.getLog(DepempServiceImpl.class);
    public static final String HBSS_POSTYPE = "hbss_postype";
    private static volatile IDepempService DEPEMPSERVICE;
    private static final Set<String> MODIFY_PROP_POSORGREL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDepempService getInstance() {
        try {
            if (null != DEPEMPSERVICE) return DEPEMPSERVICE;
            Class<DepempServiceImpl> clazz = DepempServiceImpl.class;
            synchronized (DepempServiceImpl.class) {
                if (null != DEPEMPSERVICE) return DEPEMPSERVICE;
                try {
                    DEPEMPSERVICE = new DepempServiceImpl();
                    LOG.info("HRPIServiceFactory-dependency-check,new-DepempServiceImpl()-success");
                }
                catch (Throwable t) {
                    LOG.error("HRPIServiceFactory-dependency-check,new-DepempServiceImpl()-fail", t);
                }
                return DEPEMPSERVICE;
            }
        }
        catch (Throwable t) {
            LOG.error("HRPIServiceFactory-dependency-check,DepempServiceImpl-getInstance()-fail", t);
        }
        return DEPEMPSERVICE;
    }

    @Override
    public DynamicObject getDepemp(Long depempId) {
        return HRPIDepempRepository.getDepemp(depempId);
    }

    @Override
    public Map<String, Long> getDepempIds(Long depempId) {
        DynamicObject depempIds = HRPIDepempRepository.getDepempModelIds(depempId);
        if (null != depempIds) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            try {
                map.put("person_id", depempIds.getLong("person"));
                map.put("employee_id", depempIds.getLong("employee"));
                map.put("cmpemp_id", depempIds.getLong("cmpemp"));
                map.put("depemp_id", depempIds.getLong("id"));
            }
            catch (Exception ex) {
                throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25", (String)"DepempServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            return map;
        }
        return new HashMap<String, Long>(0);
    }

    @Override
    public DynamicObject getEmpOrgrel(Long depempId) {
        Object[] dynamicObjects = HRPIDepempRepository.listEmpposOrgrelDys(Collections.singletonList(depempId));
        return HRArrayUtils.isEmpty((Object[])dynamicObjects) ? null : dynamicObjects[0];
    }

    @Override
    public DynamicObject getDataEmpOrgrel(Long depempId) {
        Object[] dynamicObjects = HRPIDepempRepository.listDataEmpposOrgrelDys(Collections.singletonList(depempId));
        return HRArrayUtils.isEmpty((Object[])dynamicObjects) ? null : dynamicObjects[0];
    }

    @Override
    public List<DynamicObject> listDataEmpOrgrels(List<Long> depempIds) {
        return Arrays.asList(HRPIDepempRepository.listDataEmpposOrgrels(depempIds));
    }

    @Override
    public List<DynamicObject> listEmpOrgrels(List<Long> depempIds) {
        return Arrays.asList(HRPIDepempRepository.listEmpposOrgrels(depempIds));
    }

    @Override
    public List<Map<String, Object>> listEmpersonByDutyworkroles(List<Long> dutyworkrolesIdList) {
        DynamicObject[] empjobRelDyArr;
        if (CollectionUtils.isEmpty(dutyworkrolesIdList)) {
            return new ArrayList<Map<String, Object>>();
        }
        DynamicObject[] depempDyArr = HRPIDepempRepository.listDepempByDutyworkroles(dutyworkrolesIdList);
        if (depempDyArr == null || depempDyArr.length == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        HashMap<Long, Map<String, Object>> personIdFieldMap = new HashMap<Long, Map<String, Object>>(16);
        List<Long> personIdList = Arrays.stream(depempDyArr).map(dynamicObject -> dynamicObject.getLong("person.id")).collect(Collectors.toList());
        DynamicObject[] pernonDyArr = HRPIPersonRepository.getPersonAttachs("person.id,person.number,person.name,person.headsculpture,age,gender.id,gender.number,gender.name", personIdList, "hrpi_pernontsprop", null);
        if (pernonDyArr != null && pernonDyArr.length > 0) {
            for (DynamicObject dynamicObject2 : pernonDyArr) {
                long personId = dynamicObject2.getLong("person.id");
                this.putIdFieldMap(personIdFieldMap, dynamicObject2, personId);
            }
        }
        HashMap<Long, Map<String, Object>> employeeIdFieldMap = new HashMap<Long, Map<String, Object>>(16);
        List<Long> employeeIdList = Arrays.stream(depempDyArr).map(dynamicObject -> dynamicObject.getLong("employee.id")).collect(Collectors.toList());
        DynamicObject[] empentrelDyArr = HRPIEmployeeRepository.listFieldsEmployeeAttachs(employeeIdList, "employee.id,servicelength", "hrpi_empentrel");
        if (empentrelDyArr != null && empentrelDyArr.length > 0) {
            for (DynamicObject dynamicObject3 : empentrelDyArr) {
                long employeeId = dynamicObject3.getLong("employee.id");
                this.putIdFieldMap(employeeIdFieldMap, dynamicObject3, employeeId);
            }
        }
        DynamicObject[] dynamicObjectArray = HRPIEmployeeRepository.listFieldsEmployeeAttachs(employeeIdList, "employee.id,socialworkage", "hrpi_perserlen");
        if (pernonDyArr != null && pernonDyArr.length > 0) {
            for (DynamicObject dynamicObject4 : dynamicObjectArray) {
                long employeeId = dynamicObject4.getLong("employee.id");
                this.putIdFieldMap(employeeIdFieldMap, dynamicObject4, employeeId);
            }
        }
        if ((empjobRelDyArr = HRPIEmployeeRepository.listFieldsEmployeeAttachs(employeeIdList, "employee.id,joblevel.id,joblevel.number,joblevel.name", "hrpi_empjobrel")) != null && empjobRelDyArr.length > 0) {
            for (DynamicObject dynamicObject5 : empjobRelDyArr) {
                long employeeId = dynamicObject5.getLong("employee.id");
                this.putIdFieldMap(employeeIdFieldMap, dynamicObject5, employeeId);
            }
        }
        return Arrays.stream(depempDyArr).map(dynamicObject -> {
            long employeeId;
            Map employeeFieldMap;
            Map<String, Object> resultMap = DynamicTransformUtil.dynamicObjectToMap(dynamicObject);
            long personId = (Long)resultMap.get("person.id");
            Map personFieldMap = (Map)personIdFieldMap.get(personId);
            if (!CollectionUtils.isEmpty((Map)personFieldMap)) {
                resultMap.putAll(personFieldMap);
            }
            if (!CollectionUtils.isEmpty((Map)(employeeFieldMap = (Map)employeeIdFieldMap.get(employeeId = ((Long)resultMap.get("employee.id")).longValue())))) {
                resultMap.putAll(employeeFieldMap);
            }
            return resultMap;
        }).collect(Collectors.toList());
    }

    private void putIdFieldMap(Map<Long, Map<String, Object>> idFieldMap, DynamicObject dynamicObject, long id) {
        Map<String, Object> fieldMap = idFieldMap.get(id);
        if (CollectionUtils.isEmpty(fieldMap)) {
            fieldMap = DynamicTransformUtil.dynamicObjectToMap(dynamicObject);
            idFieldMap.put(id, fieldMap);
        } else {
            fieldMap.putAll(DynamicTransformUtil.dynamicObjectToMap(dynamicObject));
        }
    }

    @Override
    public int countIntersectEmpOrgrels(Date gteDate, Date lteDate, Map<String, Object> paramMap) {
        List<QFilter> qFilterList = this.getIntersectEmpOrgrelsQFilters(gteDate, lteDate, paramMap);
        return HRPIDepempRepository.countIntersectEmpOrgrels(qFilterList);
    }

    @Override
    public List<Map<String, Object>> listIntersectEmpOrgrels(Date gteDate, Date lteDate, Map<String, Object> paramMap, Long id, int top) {
        List<QFilter> qFilterList = this.getIntersectEmpOrgrelsQFilters(gteDate, lteDate, paramMap);
        qFilterList.add(new QFilter("id", ">", (Object)id));
        return this.listIntersectEmpOrgrels(top, qFilterList);
    }

    @Override
    public List<Map<String, Object>> listIntersectEmpOrgrelsByDepempIds(List<Long> depempIds) {
        Map<Long, Map<String, Object>> depempIdFieldMap;
        if (null == depempIds || depempIds.size() == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        DynamicObject[] depempDyArr = HRPIDepempRepository.listDepByDepIdsNotInitFinish(depempIds, "id,person,orgteam,dutyworkroles,postype,employee,enddate,startdate");
        if (depempDyArr == null || depempDyArr.length == 0) {
            LOG.warn("DepempServiceImpl#listIntersectEmpOrgrelsByDepempIds depempDyArr is empty");
            return new ArrayList<Map<String, Object>>();
        }
        Map<Long, Map<String, Object>> employeeIdFieldMap = this.getEmployeeFieldMapByDepemps(depempDyArr);
        List<Map<String, Object>> result = this.mergeResult(depempDyArr, employeeIdFieldMap, depempIdFieldMap = this.getDepempIdFieldMapByDepemps(depempDyArr));
        if (Objects.nonNull(result)) {
            LOG.info("DepempServiceImpl#listIntersectEmpOrgrelsByDepempIds result size {}", (Object)result.size());
        } else {
            LOG.info("DepempServiceImpl#listIntersectEmpOrgrelsByDepempIds result is null");
        }
        return result;
    }

    private List<Map<String, Object>> listIntersectEmpOrgrels(int top, List<QFilter> qFilterList) {
        DynamicObject[] depempDyArr = HRPIBusinessDataServiceHelper.load("hrpi_depemp", "id,person,orgteam,dutyworkroles,postype,employee,enddate,startdate", qFilterList.toArray(new QFilter[0]), "id", top);
        if (depempDyArr == null || depempDyArr.length == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        Map<Long, Map<String, Object>> employeeIdFieldMap = this.getEmployeeFieldMapByDepemps(depempDyArr);
        Map<Long, Map<String, Object>> depempIdFieldMap = this.getDepempIdFieldMapByDepemps(depempDyArr);
        return this.mergeResult(depempDyArr, employeeIdFieldMap, depempIdFieldMap);
    }

    private List<Map<String, Object>> mergeResult(DynamicObject[] depempDyArr, Map<Long, Map<String, Object>> employeeIdFieldMap, Map<Long, Map<String, Object>> depempIdFieldMap) {
        return Arrays.stream(depempDyArr).map(dynamicObject -> {
            long employeeId;
            Map employeeFieldMap;
            Map<String, Object> resultMap = DynamicTransformUtil.dynamicObjectToMap(dynamicObject);
            long depempId = (Long)resultMap.get("id");
            Map empposFieldMap = (Map)depempIdFieldMap.get(depempId);
            if (!CollectionUtils.isEmpty((Map)empposFieldMap)) {
                resultMap.putAll(empposFieldMap);
            }
            if (!CollectionUtils.isEmpty((Map)(employeeFieldMap = (Map)employeeIdFieldMap.get(employeeId = ((Long)resultMap.get("employee_id")).longValue())))) {
                resultMap.putAll(employeeFieldMap);
            }
            resultMap.put("id", depempId);
            return resultMap;
        }).collect(Collectors.toList());
    }

    private Map<Long, Map<String, Object>> getEmployeeFieldMapByDepemps(DynamicObject[] depempDyArr) {
        List<Long> employeeIdList = Arrays.stream(depempDyArr).map(depempDy -> depempDy.getLong("employee_id")).collect(Collectors.toList());
        DynamicObject[] employeeDyArr = HRPIEmployeeRepository.queryListEmployeeIds(employeeIdList, "id,laborreltype");
        HashMap<Long, Map<String, Object>> employeeIdFieldMap = new HashMap<Long, Map<String, Object>>(16);
        if (employeeDyArr != null && employeeDyArr.length > 0) {
            for (DynamicObject employeeDy : employeeDyArr) {
                long employeeId = employeeDy.getLong("id");
                this.putIdFieldMap(employeeIdFieldMap, employeeDy, employeeId);
            }
        }
        return employeeIdFieldMap;
    }

    private Map<Long, Map<String, Object>> getDepempIdFieldMapByDepemps(DynamicObject[] depempDyArr) {
        List<Long> depempIdList = Arrays.stream(depempDyArr).map(depempDy -> depempDy.getLong("id")).collect(Collectors.toList());
        DynamicObject[] empposDyArr = HRPIDepempRepository.listEmpExpByDepIds(depempIdList, "id,depemp,job");
        HashMap<Long, Map<String, Object>> depempIdFieldMap = new HashMap<Long, Map<String, Object>>(16);
        if (empposDyArr != null && empposDyArr.length > 0) {
            for (DynamicObject empposDy : empposDyArr) {
                long depempId = empposDy.getLong("depemp.id");
                this.putIdFieldMap(depempIdFieldMap, empposDy, depempId);
            }
        }
        return depempIdFieldMap;
    }

    private List<QFilter> getIntersectEmpOrgrelsQFilters(Date gteDate, Date lteDate, Map<String, Object> paramMap) {
        if (gteDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u8d77\u59cb\u65e5\u671f\u3002", (String)"HRPISyncRepository_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (lteDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u622a\u6b62\u65e5\u671f\u3002", (String)"HRPISyncRepository_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (gteDate.compareTo(lteDate) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d77\u59cb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u622a\u6b62\u65e5\u671f\u3002", (String)"HRPISyncRepository_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (!CollectionUtils.isEmpty(paramMap)) {
            List postcategoryIdList;
            List postypeIdList;
            List orgteamIdList = (List)paramMap.get("orgteamIdList");
            if (!CollectionUtils.isEmpty((Collection)orgteamIdList)) {
                qFilterList.add(new QFilter("orgteam", "in", (Object)orgteamIdList));
            }
            if (!CollectionUtils.isEmpty((Collection)(postypeIdList = (List)paramMap.get("postypeIdList")))) {
                qFilterList.add(new QFilter("postype", "in", (Object)postypeIdList));
            }
            if (!CollectionUtils.isEmpty((Collection)(postcategoryIdList = (List)paramMap.get("postcategoryIdList")))) {
                qFilterList.add(new QFilter("postype.postcategory", "in", (Object)postcategoryIdList));
            }
        }
        qFilterList.add(QFilterUtil.getCurrentQf());
        qFilterList.add(QFilterUtil.getDataStatusFilter());
        gteDate = DateUtil.dateWithoutTime(gteDate);
        lteDate = DateUtil.dateWithoutTime(lteDate);
        QFilter dateFilter = new QFilter("startdate", ">=", (Object)gteDate).and(new QFilter("startdate", "<=", (Object)lteDate));
        dateFilter.or(new QFilter("startdate", "<=", (Object)gteDate).and(new QFilter("enddate", ">=", (Object)lteDate)));
        dateFilter.or(new QFilter("enddate", ">=", (Object)gteDate).and(new QFilter("enddate", "<=", (Object)lteDate)));
        dateFilter.or(new QFilter("startdate", ">=", (Object)gteDate).and(new QFilter("enddate", "<=", (Object)lteDate)));
        qFilterList.add(dateFilter);
        return qFilterList;
    }

    @Override
    public Map<String, Object> updatePosOrgRel(List<Map<String, Object>> empPosList) {
        DynamicObject[] empPosRels;
        if (CollectionUtils.isEmpty(empPosList)) {
            ServiceResultBuilder.fail("empPosList is empty");
        }
        HashSet depEmpIds = Sets.newHashSetWithExpectedSize((int)empPosList.size());
        HashMap empPosMap = Maps.newHashMapWithExpectedSize((int)empPosList.size());
        for (Map<String, Object> empPos : empPosList) {
            Object boId = empPos.get("boId");
            if (Objects.nonNull(boId)) {
                empPosMap.put((Long)boId, empPos);
                continue;
            }
            depEmpIds.add((Long)empPos.get("depEmpId"));
        }
        MainEntityType empPosType = EntityMetadataCache.getDataEntityType((String)"hrpi_empposorgrel");
        DynamicObjectCollection empPosCollection = new DynamicObjectCollection((DynamicObjectType)empPosType, null);
        ArrayList errorMsg = Lists.newArrayListWithExpectedSize((int)empPosList.size());
        if (!CollectionUtils.isEmpty((Map)empPosMap) && (empPosRels = HRPIDepempRepository.loadEmpPosByBoId(empPosMap.keySet())).length > 0) {
            long[] ids = ORM.create().genLongIds((IDataEntityType)empPosType, empPosRels.length);
            for (int i = 0; i < empPosRels.length; ++i) {
                DynamicObject oldEmpPos = empPosRels[i];
                DynamicObject empPos = (DynamicObject)empPosType.createInstance();
                HRDynamicObjectUtils.copy((DynamicObject)oldEmpPos, (DynamicObject)empPos);
                Long key = (Long)oldEmpPos.get("boid");
                Map map = (Map)empPosMap.get(key);
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    if (!MODIFY_PROP_POSORGREL.contains(entry.getKey())) continue;
                    DynamicTransformUtil.setLocalProp(empPosType, empPos, entry);
                }
                empPos.set("id", (Object)ids[i]);
                empPosCollection.add((Object)empPos);
            }
        }
        Map<String, Object> param = GenericParamBuilder.buildDatasByCollection(false, empPosCollection);
        IPersonGenericService personGenericService = PersonGenericServiceImpl.getInstance();
        Map<String, Object> result = personGenericService.saveBatch(param);
        ServiceResultBuilder.wrapResult(result, errorMsg);
        return result;
    }

    @Override
    public Map<String, Object> listEmpOrgRelGroup(Map<String, Object> requestMap) {
        QFilter personFiler;
        LOG.info("listEmpOrgRelGroup start : {} ", requestMap);
        HashSet errorSet = Sets.newHashSet();
        ValidateHelper validator = ValidateHelper.getInstance(errorSet);
        try {
            validator.validateReqMapNotNull().or(validator.validateMustInput("sign", "signList")).or(validator.validateArgType(ValidateHelper.isStringType, "sign", "businessStatus")).or(validator.validateLimit("sign", IRPCConstants.LIMIT_FILED_QEMPPOSORG)).or(validator.validateArgType(ValidateHelper.isListType, "signList")).or(validator.validateListSize("signList", 10000)).or(validator.validateLimit("businessStatus", IRPCConstants.LIMIT_BUSINESS_STATUS_ENUM_EXTRA)).or(validator.validateArgType(ValidateHelper.isLongType, "postatecls")).or(validator.validateLimit("postatecls", IRPCConstants.LIMIT_POSTATECLS_ENUM)).or(validator.validateListSize("signList", 10000)).test(requestMap);
            if (errorSet.size() > 0) {
                return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), JSONObject.toJSONString((Object)errorSet)).get();
            }
        }
        catch (Exception exception) {
            LOG.error("validate request param occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), String.format(ErrorCodeEnum.VALIDATE_FAILED.getInfo(), exception.getMessage(), JSONObject.toJSONString((Object)errorSet))).get();
        }
        String selectPros = DynamicTransformUtil.getDynamicPropString("hrpi_empposorgrel", IRPCConstants.IGNORE_SET);
        Map<Object, Object> personIdWithNumber = Maps.newHashMap();
        if ("number".equals(requestMap.get("sign"))) {
            DynamicObject[] employeeDys = HRPIEmployeeRepository.fixIfRepeatNumber(HRPIEmployeeRepository.employeeServiceHelper.query("person.id,empnumber,startdate", new QFilter[]{new QFilter("empnumber", "in", requestMap.get("signList")), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.isLatestRecord()}));
            personIdWithNumber = Arrays.stream(employeeDys).collect(Collectors.toMap(dy -> dy.getLong("person.id"), dy -> dy.getString("empnumber"), (k1, k2) -> k1));
            personFiler = new QFilter("person", "in", personIdWithNumber.keySet());
        } else {
            personFiler = new QFilter((String)requestMap.get("sign"), "in", requestMap.get("signList"));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(Arrays.asList(personFiler, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()));
        String businessStatusO = Optional.ofNullable(requestMap.get("businessStatus")).orElseGet(() -> "1");
        if (!"*".equals(businessStatusO)) {
            filters.add(new QFilter("businessStatus", "=", (Object)businessStatusO));
        }
        Optional<Object> poStateClsO = Optional.ofNullable(requestMap.get("postatecls"));
        poStateClsO.ifPresent(o -> filters.add(new QFilter("posstatus.poststatecls.id", "=", requestMap.get("postatecls"))));
        DynamicObject[] empRelDys = HRPIDepempRepository.empRelServiceHelper.query(selectPros, filters.toArray(new QFilter[0]));
        List<Map<String, Object>> listMaps = DynamicTransformUtil.dynamicListToMap(Arrays.asList(empRelDys));
        Map<Object, Object> res = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(personIdWithNumber)) {
            Map<Long, List<Map>> tempRes = listMaps.stream().collect(Collectors.groupingBy(map -> (Long)map.get("person_id")));
            for (Map.Entry<Long, List<Map>> entry : tempRes.entrySet()) {
                res.put(personIdWithNumber.get(entry.getKey()), entry.getValue());
            }
        } else {
            res = listMaps.stream().collect(Collectors.groupingBy(map -> String.valueOf(map.get(requestMap.get("sign") + "_id"))));
        }
        return ResultBuilder.success(res).get();
    }

    @Override
    public Map<String, Object> listEmpOrgRelByPos(Map<String, Object> requestMap) {
        LOG.info("listEmpOrgRelByPos start : {} ", requestMap);
        HashSet errorSet = Sets.newHashSet();
        ValidateHelper validator = ValidateHelper.getInstance(errorSet);
        try {
            validator.validateReqMapNotNull().or(validator.validateMustInput("sign", "signList", "qTimeModel", "dateOne")).or(validator.validateArgType(ValidateHelper.isStringType, "sign", "businessStatus", "qTimeModel")).or(validator.validateArgType(ValidateHelper.isBooleanType, "includeSubOrg")).or(validator.validateArgType(ValidateHelper.isListType, "signList")).or(validator.validateArgType(ValidateHelper.isLongType, "maxId")).or(validator.validateArgType(ValidateHelper.isIntegerType, "singlePageRows")).or(validator.validateLimit("sign", IRPCConstants.LIMIT_POS_ENUM)).or(validator.validateLimit("businessStatus", IRPCConstants.LIMIT_BUSINESS_STATUS_ENUM)).or(validator.validateLimit("qTimeModel", IRPCConstants.LIMIT_TIMEMODEL_ENUM)).or(validator.validateDateRel("dateOne", "dateTwo")).or(validator.validatePairInput("maxId", "singlePageRows")).test(requestMap);
            if (null == requestMap.get("singlePageRows")) {
                validator.validateListSize("signList", 3000).test(requestMap);
            }
            if (errorSet.size() > 0) {
                return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), JSONObject.toJSONString((Object)errorSet)).get();
            }
        }
        catch (Exception exception) {
            LOG.error("validate request param occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), String.format(ErrorCodeEnum.VALIDATE_FAILED.getInfo(), exception.getMessage(), JSONObject.toJSONString((Object)errorSet))).get();
        }
        String selectPros = DynamicTransformUtil.getDynamicPropString("hrpi_empposorgrel", IRPCConstants.IGNORE_SET);
        QFilter[] qFilters = this.getQueryEmpOrgByPosFilters(requestMap);
        DynamicObject[] empOrgObjs = null != requestMap.get("singlePageRows") ? HRPIDepempRepository.empRelServiceHelper.query(selectPros, qFilters, "id", ((Integer)requestMap.get("singlePageRows")).intValue()) : HRPIDepempRepository.empRelServiceHelper.query(selectPros, qFilters);
        if (null == empOrgObjs || empOrgObjs.length == 0) {
            return ResultBuilder.success(Collections.emptyMap()).addMsg("there is no data in the condition").get();
        }
        Long maxEmpOrgId = Arrays.stream(empOrgObjs).max(Comparator.comparingLong(x -> x.getLong("id"))).get().getLong("id");
        List personIds = Arrays.stream(empOrgObjs).map(o -> o.getLong("person_id")).collect(Collectors.toList());
        QFilter qFilterPerson = new QFilter("id", "in", personIds);
        DynamicObject[] persons = RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "id", "personindexid", "headsculpture", "number"), null, "hrpi_person", new QFilter[]{qFilterPerson}, null);
        DynamicObject[] empS = RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "employee", "laborreltype", "laborrelstatus", "startdate"), null, "hrpi_empentrel", new QFilter[]{new QFilter("person_id", "in", personIds), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.isLatestRecord()}, null);
        Map<Long, Map> personIdWithPersonObj = DynamicTransformUtil.dynamicListToMap(Arrays.asList(persons)).stream().collect(Collectors.toMap(map -> (Long)map.get("id"), map -> map, (k1, k2) -> k1));
        Map<Long, Map> personIdWithEmp = DynamicTransformUtil.dynamicListToMap(Arrays.asList(empS)).stream().collect(Collectors.toMap(map -> (Long)map.get("person_id"), map -> map, (k1, k2) -> k1));
        Map<String, List<Map>> groupBySign = DynamicTransformUtil.dynamicListToMap(Arrays.asList(empOrgObjs)).stream().collect(Collectors.groupingBy(map -> String.valueOf(map.get(requestMap.get("sign") + "_id"))));
        groupBySign.values().forEach(list -> list.forEach(map -> {
            HashMap oldMap = new HashMap(map);
            map.put("hrpi_empposorgrel", oldMap);
            map.put("hrpi_person", personIdWithPersonObj.get(map.get("person_id")));
            map.put("hrpi_empentrel", personIdWithEmp.get(map.get("person_id")));
            map.keySet().removeIf(key -> !Arrays.asList("hrpi_empposorgrel", "hrpi_person", "hrpi_empentrel").contains(key));
        }));
        return ResultBuilder.success(groupBySign).put("maxId", maxEmpOrgId).get();
    }

    private QFilter[] getQueryEmpOrgByPosFilters(Map<String, Object> requestMap) {
        String sign = (String)requestMap.get("sign");
        if ("adminorg".equals(sign) && null != requestMap.get("includeSubOrg") && ((Boolean)requestMap.get("includeSubOrg")).booleanValue()) {
            this.fillOrgIdsWithSubOrg(requestMap, "signList");
        }
        QFilter filterPos = new QFilter((String)requestMap.get("sign"), "in", requestMap.get("signList"));
        QFilter filterBusiness = new QFilter("businessstatus", "=", Optional.ofNullable(requestMap.get("businessStatus")).orElse("1"));
        QFilter dateFilter = QFilterUtil.getTimeFilter((String)requestMap.get("qTimeModel"), DateUtil.getDate(requestMap.get("dateOne")), DateUtil.getDate(requestMap.get("dateTwo")));
        if (null != requestMap.get("maxId")) {
            QFilter filterPKid = new QFilter("id", ">", requestMap.get("maxId"));
            return new QFilter[]{filterPos, QFilterUtil.getDataStatusFilter(), filterBusiness, QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish(), filterPKid, dateFilter};
        }
        return new QFilter[]{filterPos, QFilterUtil.getDataStatusFilter(), filterBusiness, QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish(), dateFilter};
    }

    private void fillOrgIdsWithSubOrg(Map<String, Object> requestMap, String key) {
        LOG.info("Start invoke IHAOSBatchAdminOrgInfoQueryService.batchGetAllSubOrg ... ");
        List batchGetAllSubOrgList = (List)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"batchGetAllSubOrg", (Object[])new Object[]{requestMap.get(key), new Date()});
        List orgIds = batchGetAllSubOrgList.stream().map(batchGetAllSubOrgMap -> Long.valueOf(String.valueOf(batchGetAllSubOrgMap.get("orgId")))).collect(Collectors.toList());
        requestMap.put(key, orgIds);
    }

    @Override
    public Map<String, Object> listEmpOrgRelByAdminOrg(Map<String, Object> requestMap) {
        LOG.info("listEmpOrgRelByAdminOrg start : {} ", requestMap);
        HashSet errorSet = Sets.newHashSet();
        ValidateHelper validator = ValidateHelper.getInstance(errorSet);
        try {
            validator.validateReqMapNotNull().or(validator.validateMustInput("orgIds", "dateTime")).or(validator.validateArgType(ValidateHelper.isListType, "orgIds")).or(validator.validateArgType(ValidateHelper.isLongType, "maxId")).or(validator.validateArgType(ValidateHelper.isIntegerType, "singlePageRows")).or(validator.validatePairInput("maxId", "singlePageRows")).test(requestMap);
            if (null == requestMap.get("singlePageRows")) {
                validator.validateListSize("orgIds", 3000).test(requestMap);
            }
            if (errorSet.size() > 0) {
                return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), JSONObject.toJSONString((Object)errorSet)).get();
            }
        }
        catch (Exception exception) {
            LOG.error("validate request param occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), String.format(ErrorCodeEnum.VALIDATE_FAILED.getInfo(), exception.getMessage(), JSONObject.toJSONString((Object)errorSet))).get();
        }
        String selectProperties = DynamicTransformUtil.getDynamicPropString("hrpi_empposorgrel", IRPCConstants.IGNORE_SET);
        QFilter[] qFilters = this.getQueryEmpOrgByOrgFilters(requestMap);
        DynamicObject[] empOrgObjs = null != requestMap.get("maxId") ? HRPIDepempRepository.empRelServiceHelper.query(selectProperties, qFilters, "id", ((Integer)requestMap.get("singlePageRows")).intValue()) : HRPIDepempRepository.empRelServiceHelper.query(selectProperties, qFilters);
        if (null == empOrgObjs || empOrgObjs.length == 0) {
            return ResultBuilder.success(Collections.emptyMap()).addMsg("there is no data in the condition").get();
        }
        Long maxEmpOrgId = Arrays.stream(empOrgObjs).max(Comparator.comparingLong(x -> x.getLong("id"))).get().getLong("id");
        Map<Long, List<Map>> groupByOrgIds = DynamicTransformUtil.dynamicListToMap(Arrays.asList(empOrgObjs)).stream().collect(Collectors.groupingBy(map -> (Long)map.get("adminorg_id")));
        return ResultBuilder.success(groupByOrgIds).put("maxId", maxEmpOrgId).get();
    }

    private QFilter[] getQueryEmpOrgByOrgFilters(Map<String, Object> requestMap) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        Optional.ofNullable(requestMap.get("maxId")).ifPresent(f -> filters.add(new QFilter("id", ">", f)));
        Date timeRule = DateUtil.getDate(requestMap.get("dateTime"));
        filters.addAll(Arrays.asList(new QFilter("adminorg", "in", requestMap.get("orgIds")), new QFilter("businessstatus", "=", (Object)"1").and(new QFilter("startdate", "<=", (Object)timeRule)).or(new QFilter("businessstatus", "=", (Object)"2").and(new QFilter("enddate", ">=", (Object)timeRule))), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()));
        return filters.toArray(new QFilter[0]);
    }

    @Override
    public Map<String, Object> listDepEmpInfo(List<Map<String, Object>> requestList) {
        LOG.info("listDepEmpInfo start : {} ", requestList);
        HashSet errorSet = Sets.newHashSet();
        ValidateHelper validator = ValidateHelper.getInstance(errorSet);
        try {
            validator.validateReqListNotNull().or(validator.validateListSize(30000)).test(requestList);
            Optional.ofNullable(requestList).ifPresent(list -> list.forEach(map -> validator.validateArgType(ValidateHelper.isMapType).or(validator.validateMustInput("number")).or(validator.validateArgType(ValidateHelper.isStringType, "number")).or(validator.validateArgType(ValidateHelper.isLongType, "adminorg", "position")).test((Map)map)));
            if (errorSet.size() > 0) {
                return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), JSONObject.toJSONString((Object)errorSet)).get();
            }
        }
        catch (Exception exception) {
            LOG.error("validate request param occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), String.format(ErrorCodeEnum.VALIDATE_FAILED.getInfo(), exception.getMessage(), JSONObject.toJSONString((Object)errorSet))).get();
        }
        Map<String, Map> numberWithCondition = requestList.stream().collect(Collectors.toMap(mapItem -> (String)mapItem.get("number"), mapItem -> mapItem, (k1, k2) -> k1));
        DynamicObject[] employeeDys = HRPIEmployeeRepository.fixIfRepeatNumber(HRPIEmployeeRepository.employeeServiceHelper.query("person.id,empnumber,startdate", new QFilter[]{new QFilter("empnumber", "in", numberWithCondition.keySet()), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.isLatestRecord()}));
        Map<Long, String> personIdWithNumber = Arrays.stream(employeeDys).collect(Collectors.toMap(dy -> dy.getLong("person.id"), dy -> dy.getString("empnumber"), (k1, k2) -> k1));
        String selectProperties = DynamicTransformUtil.getDynamicPropString("hrpi_depemp", IRPCConstants.IGNORE_SET);
        Map<Long, List<DynamicObject>> personIdWithObjs = Arrays.stream(HRPIDepempRepository.depempServiceHelper.query(selectProperties, new QFilter[]{new QFilter("person", "in", personIdWithNumber.keySet()), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()})).collect(Collectors.groupingBy(dy -> dy.getLong("person_id")));
        HashMap numberWithObjs = Maps.newHashMapWithExpectedSize((int)personIdWithObjs.size());
        AtomicBoolean pass = new AtomicBoolean(true);
        personIdWithObjs.forEach((k, v) -> {
            Map condition = (Map)numberWithCondition.get(personIdWithNumber.get(k));
            List filterList = v.stream().filter(dy -> {
                pass.set(true);
                Optional.ofNullable(condition).flatMap(m -> Optional.ofNullable(m.get("adminorg"))).ifPresent(org_id -> {
                    if (!org_id.equals(dy.getLong("adminorg_id"))) {
                        pass.set(false);
                    }
                });
                Optional.ofNullable(condition).flatMap(m -> Optional.ofNullable(m.get("position"))).ifPresent(pos_id -> {
                    if (!pos_id.equals(dy.getLong("position_id"))) {
                        pass.set(false);
                    }
                });
                return pass.get();
            }).collect(Collectors.toList());
            numberWithObjs.put(personIdWithNumber.get(k), filterList);
        });
        return ResultBuilder.success(numberWithObjs).get();
    }

    @Override
    public Map<String, Object> listMainEmpOrgRelByAdminOrg(Map<String, Object> requestMap) {
        LOG.info("listMainEmpOrgRelByAdminOrg start : {} ", requestMap);
        HashSet errorSet = Sets.newHashSet();
        ValidateHelper validator = ValidateHelper.getInstance(errorSet);
        try {
            validator.validateReqMapNotNull().or(validator.validateMustInput("orgIds", "includeSubOrg")).or(validator.validateArgType(ValidateHelper.isListType, "orgIds", "postype", "labrelstatuscls", "labrelstatusprd")).or(validator.validateArgType(ValidateHelper.isStringType, "businessStatus")).or(validator.validateArgType(ValidateHelper.isBooleanType, "includeSubOrg", "jumpFilterBusinessStatus")).or(validator.validateArgType(ValidateHelper.isQFilterType, "customFilter")).or(validator.validateLimit("businessStatus", IRPCConstants.LIMIT_BUSINESS_STATUS_ENUM)).or(validator.validateListSize("orgIds", 3000)).test(requestMap);
            if (errorSet.size() > 0) {
                return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), JSONObject.toJSONString((Object)errorSet)).get();
            }
        }
        catch (Exception exception) {
            LOG.error("validate request param occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), String.format(ErrorCodeEnum.VALIDATE_FAILED.getInfo(), exception.getMessage(), JSONObject.toJSONString((Object)errorSet))).get();
        }
        List<QFilter> filters = this.getMainEmpOrgRelByAdminOrgFilters(requestMap);
        DynamicObject[] empPosRelObjs = HRPIDepempRepository.empRelServiceHelper.query("employee,depemp,adminorg", filters.toArray(new QFilter[0]));
        if (null == empPosRelObjs || empPosRelObjs.length == 0) {
            return ResultBuilder.success(Collections.emptyMap()).addMsg("there is no data in the condition").get();
        }
        List<Long> empIdsNeedKeep = this.filterEmpIds(requestMap, Arrays.stream(empPosRelObjs).map(dy -> dy.getLong("employee_id")).collect(Collectors.toList()));
        Map<Long, List<DynamicObject>> orgWithEmpRel = Arrays.stream(empPosRelObjs).filter(dy -> empIdsNeedKeep.contains(dy.getLong("employee_id"))).collect(Collectors.groupingBy(dy -> dy.getLong("adminorg_id")));
        if (MapUtils.isEmpty(orgWithEmpRel)) {
            return ResultBuilder.success(Collections.emptyMap()).addMsg("there is no data in the condition").get();
        }
        HashMap resMap = Maps.newHashMapWithExpectedSize((int)orgWithEmpRel.size());
        orgWithEmpRel.forEach((k, v) -> {
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)2);
            dataMap.put("count", v.size());
            dataMap.put("ids", v.stream().map(dy -> dy.getLong("depemp_id")).collect(Collectors.toList()));
            resMap.put(k, dataMap);
        });
        return ResultBuilder.success(resMap).get();
    }

    private List<Long> filterEmpIds(Map<String, Object> requestMap, List<Long> empIdList) {
        if (null == requestMap.get("labrelstatuscls") && null == requestMap.get("labrelstatusprd")) {
            return empIdList;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("employee", "in", empIdList));
        Optional.ofNullable(requestMap.get("labrelstatuscls")).ifPresent(clsList -> filters.add(new QFilter("laborrelstatus.labrelstatuscls", "in", clsList)));
        Optional.ofNullable(requestMap.get("labrelstatusprd")).ifPresent(prdList -> filters.add(new QFilter("labrelstatusprd", "in", prdList)));
        filters.add(QFilterUtil.getDataStatusFilter());
        return Arrays.stream(HRPIEmployeeRepository.empentrelServiceHelper.query("employee", filters.toArray(new QFilter[0]))).map(dy -> dy.getLong("employee_id")).distinct().collect(Collectors.toList());
    }

    private List<QFilter> getMainEmpOrgRelByAdminOrgFilters(Map<String, Object> requestMap) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (((Boolean)requestMap.get("includeSubOrg")).booleanValue()) {
            this.fillOrgIdsWithSubOrg(requestMap, "orgIds");
        }
        filters.add(new QFilter("adminorg", "in", requestMap.get("orgIds")));
        if (null == requestMap.get("jumpFilterBusinessStatus") || !((Boolean)requestMap.get("jumpFilterBusinessStatus")).booleanValue()) {
            filters.add(new QFilter("businessstatus", "=", Optional.ofNullable(requestMap.get("businessStatus")).orElse("1")));
        }
        Date dateTime = Optional.ofNullable(DateUtil.getDate(requestMap.get("dateTime"))).orElseGet(Date::new);
        filters.add(new QFilter("startdate", "<=", (Object)dateTime).and(new QFilter("enddate", ">=", (Object)dateTime)));
        Optional.ofNullable(requestMap.get("postype")).ifPresent(posTypeList -> filters.add(new QFilter("postype", "in", posTypeList)));
        Optional.ofNullable(requestMap.get("customFilter")).ifPresent(filter -> filters.add((QFilter)filter));
        filters.add(QFilterUtil.getDataStatusFilter());
        filters.add(QFilterUtil.getCurrentQf());
        filters.add(QFilterUtil.getInitStatusFinish());
        return filters;
    }

    @Override
    public Map<String, Object> listMainEmpOrgRelByAdminOrg(List<Long> orgIds, Boolean includeSubOrg, Date dateTime, List<Long> posTypes) {
        return this.listMainEmpOrgRelByAdminOrg(orgIds, includeSubOrg, dateTime, posTypes, Boolean.FALSE);
    }

    @Override
    public Map<String, Object> listMainEmpOrgRelByAdminOrg(List<Long> orgIds, Boolean includeSubOrg, Date dateTime, List<Long> posTypes, Boolean jumpFilterBusinessStatus) {
        HashMap requestMap = Maps.newHashMapWithExpectedSize((int)8);
        requestMap.put("orgIds", orgIds);
        requestMap.put("includeSubOrg", includeSubOrg);
        requestMap.put("dateTime", dateTime);
        requestMap.put("postype", posTypes);
        Optional.ofNullable(dateTime).ifPresent(d -> {
            if (DateUtil.isSameDay(d, new Date()) || d.after(new Date())) {
                requestMap.put("labrelstatusprd", Collections.singletonList(IRPCConstants.IN_LABOUR));
            }
        });
        requestMap.put("jumpFilterBusinessStatus", jumpFilterBusinessStatus);
        return this.listMainEmpOrgRelByAdminOrg(requestMap);
    }

    @Override
    public void syncEmpOrgRelToAll(DynamicObjectCollection empOrgRels) {
        DynamicObject[] empRelAllsToUpdate;
        HashMap depempIdOrgRelMap = Maps.newHashMapWithExpectedSize((int)empOrgRels.size());
        ArrayList depempIds = Lists.newArrayListWithCapacity((int)empOrgRels.size());
        empOrgRels.forEach(empOrgRel -> {
            Long depempId = empOrgRel.getLong("depemp.id");
            depempIdOrgRelMap.put(depempId, empOrgRel);
            depempIds.add(depempId);
        });
        for (DynamicObject empOrgAllToUpdate : empRelAllsToUpdate = HRPIDepempRepository.queryEmpOrgRelAllForSync(depempIds)) {
            Long depempId = empOrgAllToUpdate.getLong("depemp.id");
            DynamicObject empOrgRel2 = (DynamicObject)depempIdOrgRelMap.get(depempId);
            this.setEmpOrgRelFieldToAll(empOrgRel2, empOrgAllToUpdate);
        }
    }

    private void setEmpOrgRelFieldToAll(DynamicObject empOrgRel, DynamicObject empRelAll) {
        Stream.of("person", "startdate", "enddate", "sysenddate", "servicelength", "isprimary", "isexistprobation", "depemp", "workplace", "businessstatus", "apositiontype", "startprobation", "endprobation", "employee", "cmpemp", "description").forEach(field -> this.syncField(empOrgRel, empRelAll, (String)field, (String)field));
        Stream.of("variationtype", "company", "adminorg", "position", "job", "stdposition").forEach(field -> this.syncField(empOrgRel, empRelAll, (String)field, field + ".name"));
        if (empRelAll.getDataEntityType().getProperties().containsKey((Object)"isinsystem")) {
            empOrgRel.set("isinsystem", (Object)"1");
        }
    }

    private void syncField(DynamicObject empOrgRel, DynamicObject empRelAll, String fieldTarget, String fieldOrigin) {
        if (!empRelAll.getDataEntityType().getProperties().containsKey((Object)fieldTarget)) {
            LOG.warn("EmpOrgRelAll don't contain field {}", (Object)fieldTarget);
            return;
        }
        if (!empOrgRel.getDataEntityType().getProperties().containsKey((Object)fieldOrigin)) {
            LOG.warn("EmpOrgRel don't contain field {}", (Object)fieldOrigin);
            return;
        }
        empRelAll.set(fieldTarget, empOrgRel.get(fieldOrigin));
    }

    @Override
    public Map<String, Object> changePrimaryEmpPosOrgRel(List<Map<String, Object>> changeParams) {
        LOG.info("changePrimaryEmpPosOrgRel-->{}", changeParams);
        try {
            HashMap<Long, Object> errorMap = new HashMap<Long, Object>(16);
            HashMap<Long, ChangePrimaryEntity> empPosIds = new HashMap<Long, ChangePrimaryEntity>(16);
            HashMap<Long, ChangePrimaryEntity> depEmpIds = new HashMap<Long, ChangePrimaryEntity>(16);
            this.validateMustField(changeParams, errorMap, empPosIds, depEmpIds);
            return this.filterAndWriteData(empPosIds, depEmpIds, errorMap);
        }
        catch (Exception esc) {
            LOG.error("changePrimaryEmpPosOrgRelError", (Throwable)esc);
            HashMap<String, Object> tmpMap = new HashMap<String, Object>();
            this.getRetFail(tmpMap, "request interface exception", "500");
            return tmpMap;
        }
    }

    private void validateMustField(List<Map<String, Object>> changeParams, Map<Long, Object> errorMap, Map<Long, ChangePrimaryEntity> empPosIds, Map<Long, ChangePrimaryEntity> depEmpIds) throws ParseException {
        ArrayList<Map<String, Object>> successParams = new ArrayList<Map<String, Object>>(10);
        Set<Long> tmpEmpIds = changeParams.stream().filter(tempMap -> tempMap.get("id") instanceof Long && (Long)tempMap.get("id") != 0L).map(tempMap -> (Long)tempMap.get("id")).collect(Collectors.toSet());
        Set<Long> tmpDepEmpIds = changeParams.stream().filter(tempMap -> tempMap.get("depempid") instanceof Long && (Long)tempMap.get("depempid") != 0L).map(tempMap -> (Long)tempMap.get("depempid")).collect(Collectors.toSet());
        Map<Object, Object> empposIdMap = new HashMap(16);
        Map<Object, Object> depIdMap = new HashMap(16);
        if (!CollectionUtils.isEmpty(tmpEmpIds)) {
            empposIdMap = this.queryEmployeeId(tmpEmpIds, "hrpi_empposorgrel");
        }
        if (!CollectionUtils.isEmpty(tmpDepEmpIds)) {
            depIdMap = this.queryEmployeeId(tmpDepEmpIds, "hrpi_depemp");
        }
        for (Map<String, Object> changeParam : changeParams) {
            Long tmpEmpId;
            Object depEmpObj;
            long empPosId = 0L;
            long depEmpId = 0L;
            Date updateDate = null;
            Object idObj = changeParam.get("id");
            if (idObj instanceof Long) {
                empPosId = (Long)idObj;
            }
            if ((depEmpObj = changeParam.get("depempid")) instanceof Long) {
                depEmpId = (Long)depEmpObj;
            }
            if (empPosId == 0L && depEmpId == 0L) {
                LOG.info("changePrimaryEmpPosOrgRelIdEmpty-->{}", changeParam);
                this.appendError(errorMap, "id", depEmpId, empPosId, "query id is null,");
                continue;
            }
            Object endDateObj = changeParam.get("updatedate");
            if (endDateObj instanceof Date) {
                updateDate = (Date)endDateObj;
            } else if (endDateObj instanceof String) {
                updateDate = HRDateTimeUtils.parseDate((String)((String)endDateObj));
            }
            if (updateDate == null) {
                String errorKey = "depempid";
                LOG.info("changePrimaryEmpPosOrgRelDateEmpty-->{}", changeParam);
                if (empPosId != 0L) {
                    errorKey = "id";
                }
                this.appendError(errorMap, errorKey, depEmpId, empPosId, "query id is null,");
                continue;
            }
            if (empPosId != 0L) {
                tmpEmpId = (Long)empposIdMap.get(empPosId);
                if (tmpEmpId == null || tmpEmpId == 0L) {
                    this.appendError(errorMap, "id", depEmpId, empPosId, "query employee id is null,");
                    continue;
                }
                changeParam.put("tmpemployeeid", tmpEmpId);
            } else if (depEmpId != 0L) {
                tmpEmpId = (Long)depIdMap.get(depEmpId);
                if (tmpEmpId == null || tmpEmpId == 0L) {
                    this.appendError(errorMap, "depempid", depEmpId, empPosId, "query employee id is null,");
                    continue;
                }
                changeParam.put("tmpemployeeid", tmpEmpId);
            }
            successParams.add(changeParam);
        }
        this.removeSamePersonChange(successParams, empPosIds, depEmpIds, errorMap);
    }

    private void removeSamePersonChange(List<Map<String, Object>> successParams, Map<Long, ChangePrimaryEntity> empPosIds, Map<Long, ChangePrimaryEntity> depEmpIds, Map<Long, Object> errorMap) throws ParseException {
        Map<Long, Long> employeeCountMap = successParams.stream().filter(tempMap -> (Long)tempMap.get("tmpemployeeid") != 0L).collect(Collectors.groupingBy(tempMap -> (Long)tempMap.get("tmpemployeeid"), Collectors.counting()));
        for (Map<String, Object> changeParam : successParams) {
            Object endDateObj;
            Object depEmpObj;
            long depEmpId = 0L;
            long empPosId = 0L;
            Date updateDate = null;
            Object idObj = changeParam.get("id");
            if (idObj instanceof Long) {
                empPosId = (Long)idObj;
            }
            if ((depEmpObj = changeParam.get("depempid")) instanceof Long) {
                depEmpId = (Long)depEmpObj;
            }
            if ((endDateObj = changeParam.get("updatedate")) instanceof Date) {
                updateDate = (Date)endDateObj;
            } else if (endDateObj instanceof String) {
                updateDate = HRDateTimeUtils.parseDate((String)((String)endDateObj));
            }
            ChangePrimaryEntity changePrimaryEntity = new ChangePrimaryEntity();
            changePrimaryEntity.setUpdateDate(updateDate);
            long tmpEmployId = (Long)changeParam.get("tmpemployeeid");
            if (empPosId != 0L) {
                if (employeeCountMap.get(tmpEmployId) == null || employeeCountMap.get(tmpEmployId) == 1L) {
                    empPosIds.put(empPosId, changePrimaryEntity);
                    continue;
                }
                this.appendError(errorMap, "id", depEmpId, empPosId, "find same employee multiple param,");
                continue;
            }
            if (depEmpId == 0L) continue;
            if (employeeCountMap.get(tmpEmployId) == null || employeeCountMap.get(tmpEmployId) == 1L) {
                depEmpIds.put(depEmpId, changePrimaryEntity);
                continue;
            }
            this.appendError(errorMap, "depempid", depEmpId, empPosId, "find same employee multiple param,");
        }
    }

    private Map<Long, Long> queryEmployeeId(Set<Long> empIdSet, String entityName) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("employee.id,id", new QFilter[]{new QFilter("id", "in", empIdSet)});
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("employee.id"), (k1, k2) -> k1));
    }

    private Map<String, Object> filterAndWriteData(Map<Long, ChangePrimaryEntity> empPosIds, Map<Long, ChangePrimaryEntity> depEmpIds, Map<Long, Object> errorMap) {
        HashMap<String, Object> retMap = new HashMap<String, Object>(16);
        if (HRMapUtils.isEmpty(empPosIds) && HRMapUtils.isEmpty(depEmpIds)) {
            if (!HRMapUtils.isEmpty(errorMap)) {
                this.getRetFail(retMap, JSON.toJSONString(errorMap), "201");
            } else {
                this.getRetFail(retMap, "query id is null", "201");
            }
            LOG.info("filterAndWriteDataIdFail-->{}-->{}", errorMap, retMap);
            return retMap;
        }
        HashMap<Long, ChangePrimaryEntity> employeeIdAndDateMap = new HashMap<Long, ChangePrimaryEntity>(16);
        ArrayList<DynamicObject> successNoMainDys = new ArrayList<DynamicObject>(10);
        if (!HRMapUtils.isEmpty(empPosIds)) {
            this.filterMainData(errorMap, successNoMainDys, HRPIDepempRepository.listDataEmpOrgrelsById(empPosIds.keySet(), "id"), "id", empPosIds, employeeIdAndDateMap);
        }
        if (!HRMapUtils.isEmpty(depEmpIds)) {
            this.filterMainData(errorMap, successNoMainDys, HRPIDepempRepository.listDataEmpOrgrelsById(depEmpIds.keySet(), "depemp.id"), "depemp", depEmpIds, employeeIdAndDateMap);
        }
        if (CollectionUtils.isEmpty(successNoMainDys)) {
            if (!HRMapUtils.isEmpty(errorMap)) {
                this.getRetFail(retMap, JSON.toJSONString(errorMap), "201");
            } else {
                this.getRetFail(retMap, "query db data is null", "201");
            }
            LOG.info("filterAndWriteDataFail-->{}-->{}", errorMap, retMap);
            return retMap;
        }
        HashMap<String, DynamicObjectCollection> saveMap = new HashMap<String, DynamicObjectCollection>(16);
        List<Long> employeeList = successNoMainDys.stream().filter(dy -> dy.getLong("employee.id") != 0L).map(dy -> dy.getLong("employee.id")).collect(Collectors.toList());
        DynamicObject[] primaryDys = HRPIDepempRepository.listPrimaryDys("hrpi_empposorgrel", employeeList, "1", "employee");
        List<DynamicObject> successMainDys = this.filterNoMainData(errorMap, employeeIdAndDateMap, primaryDys);
        if (!CollectionUtils.isEmpty(successMainDys)) {
            this.buildHisData(successMainDys, employeeIdAndDateMap, saveMap, "hrpi_empposorgrel", "0");
        }
        Iterator noMainIt = successNoMainDys.iterator();
        List allowEmployIds = successMainDys.stream().filter(dy -> dy.getLong("employee.id") != 0L).map(dy -> dy.getLong("employee.id")).collect(Collectors.toList());
        while (noMainIt.hasNext()) {
            DynamicObject nextDy = (DynamicObject)noMainIt.next();
            long tmpEmpId = nextDy.getLong("employee.id");
            long tmpDepId = nextDy.getLong("depemp.id");
            long id = nextDy.getLong("id");
            if (allowEmployIds.contains(tmpEmpId)) continue;
            this.appendError(errorMap, "depempid", tmpDepId, id, "primary validate not pass,");
            noMainIt.remove();
        }
        if (CollectionUtils.isEmpty(successNoMainDys)) {
            LOG.info("filterAndWriteDataNotSuccessData-->{}-->{}-->{}", new Object[]{employeeList, retMap, errorMap});
            this.getRetFail(retMap, "remove validate not pass data", "201");
            return retMap;
        }
        this.buildHisData(successNoMainDys, employeeIdAndDateMap, saveMap, "hrpi_empposorgrel", "1");
        this.queryAndBuildHisData("hrpi_emporgrelall", employeeIdAndDateMap, successNoMainDys, saveMap);
        this.queryAndBuildHisData("hrpi_depemp", employeeIdAndDateMap, successNoMainDys, saveMap);
        IHRPIOperationService service = HRPIOperationServiceImpl.getInstance();
        Map<String, Object> reMap = service.doSaveOrUpdate(saveMap, false);
        this.buildRetMap(retMap, errorMap, reMap);
        LOG.info("filterAndWriteData-->{}-->{}-->{}", new Object[]{employeeList, retMap, errorMap});
        return retMap;
    }

    private List<DynamicObject> filterNoMainData(Map<Long, Object> errorMap, Map<Long, ChangePrimaryEntity> employeeIdAndDateMap, DynamicObject[] primaryDys) {
        ArrayList<DynamicObject> successMainDys = new ArrayList<DynamicObject>(10);
        for (DynamicObject dy : primaryDys) {
            Date date = dy.getDate("startdate");
            long employeeId = dy.getLong("employee.id");
            long depEmpId = dy.getLong("depemp.id");
            ChangePrimaryEntity changePrimaryEntity = employeeIdAndDateMap.get(employeeId);
            if (changePrimaryEntity == null) continue;
            Date updateDate = changePrimaryEntity.getUpdateDate();
            if (HRDateTimeUtils.dayAfter((Date)date, (Date)updateDate)) {
                this.appendError(errorMap, "depempid", depEmpId, 0L, "updatedate greater than primary startdate,");
                continue;
            }
            successMainDys.add(dy);
        }
        return successMainDys;
    }

    private void buildRetMap(Map<String, Object> retMap, Map<Long, Object> errorMap, Map<String, Object> reMap) {
        if (((Boolean)reMap.get("success")).booleanValue()) {
            if (HRMapUtils.isEmpty(errorMap)) {
                this.getRetSuccess(retMap, null, "200");
            } else {
                String jsonString = JSON.toJSONString(errorMap);
                this.getRetFail(retMap, jsonString, "202");
            }
        } else {
            this.getRetFail(retMap, "request save fail", "203");
        }
    }

    private void queryAndBuildHisData(String entityName, Map<Long, ChangePrimaryEntity> employeeIdAndDateMap, List<DynamicObject> successDys, Map<String, DynamicObjectCollection> saveMap) {
        List<Long> employeeList = successDys.stream().filter(dy -> dy.getLong("employee.id") != 0L).map(dy -> dy.getLong("employee.id")).collect(Collectors.toList());
        List<Long> depEmpList = successDys.stream().filter(dy -> dy.getLong("depemp.id") != 0L).map(dy -> dy.getLong("depemp.id")).collect(Collectors.toList());
        DynamicObject[] noPrimaryDys = HRPIDepempRepository.listPrimaryDys(entityName, depEmpList, "0", "depemp");
        this.buildHisData(Arrays.asList(noPrimaryDys), employeeIdAndDateMap, saveMap, entityName, "1");
        DynamicObject[] primaryDys = HRPIDepempRepository.listPrimaryDys(entityName, employeeList, "1", "employee");
        this.buildHisData(Arrays.asList(primaryDys), employeeIdAndDateMap, saveMap, entityName, "0");
    }

    private void buildHisData(List<DynamicObject> successDys, Map<Long, ChangePrimaryEntity> depIdAndDateMap, Map<String, DynamicObjectCollection> saveMap, String entityName, String primary) {
        DynamicObjectCollection dynamicObjects = saveMap.get(entityName);
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            dynamicObjects = new DynamicObjectCollection();
        }
        for (DynamicObject dy : successDys) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
            DynamicObject emptyDy = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)emptyDy);
            emptyDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
            emptyDy.set("modifytime", (Object)new Date());
            emptyDy.set("isprimary", (Object)primary);
            emptyDy.set("initstatus", (Object)"2");
            long employeeId = dy.getLong("employee.id");
            ChangePrimaryEntity changePrimaryEntity = depIdAndDateMap.get(employeeId);
            if (changePrimaryEntity != null) {
                Date updateDate = changePrimaryEntity.getUpdateDate();
                emptyDy.set("bsed", (Object)updateDate);
            }
            dynamicObjects.add((Object)emptyDy);
        }
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            saveMap.put(entityName, dynamicObjects);
        }
    }

    private void filterMainData(Map<Long, Object> errorMap, List<DynamicObject> successDys, List<DynamicObject> empPosDys, String key, Map<Long, ChangePrimaryEntity> empPosIds, Map<Long, ChangePrimaryEntity> employeeIdAndDateMap) {
        Set<Long> posCateGory = this.getPosCateGory();
        for (DynamicObject dy : empPosDys) {
            Date updateDate;
            long posTypeId = dy.getLong("postype.id");
            long depEmpId = dy.getLong("depemp.id");
            long employeeId = dy.getLong("employee.id");
            long empPosId = dy.getLong("id");
            String primary = dy.getString("isprimary");
            if ("1".equals(primary)) {
                this.appendError(errorMap, key, depEmpId, empPosId, "param is primary empPosOrgRel,");
                continue;
            }
            if (!posCateGory.contains(posTypeId)) {
                this.appendError(errorMap, key, depEmpId, empPosId, "param is not full postype,");
                continue;
            }
            ChangePrimaryEntity changePrimaryEntity = null;
            changePrimaryEntity = "id".equals(key) ? empPosIds.get(empPosId) : empPosIds.get(depEmpId);
            Date date = dy.getDate("startdate");
            if (HRDateTimeUtils.dayAfter((Date)date, (Date)(updateDate = changePrimaryEntity.getUpdateDate()))) {
                this.appendError(errorMap, key, depEmpId, empPosId, "updatedate greater than no primary startdate,");
                continue;
            }
            employeeIdAndDateMap.put(employeeId, changePrimaryEntity);
            successDys.add(dy);
        }
    }

    private void appendError(Map<Long, Object> errorMap, String key, long depEmpId, long empPosId, String error) {
        StringBuilder strErr = new StringBuilder();
        Object errObj = null;
        errObj = key.equals("id") ? errorMap.get(empPosId) : errorMap.get(depEmpId);
        if (errObj instanceof String) {
            String oldError = (String)errObj;
            strErr.append(oldError);
            strErr.append(key).append("-").append(error);
            if (key.equals("id")) {
                errorMap.put(empPosId, strErr);
            } else {
                errorMap.put(depEmpId, strErr);
            }
        } else if (key.equals("id")) {
            errorMap.put(empPosId, key + "-" + error);
        } else {
            errorMap.put(depEmpId, key + "-" + error);
        }
    }

    public Set<Long> getPosCateGory() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(HBSS_POSTYPE);
        QFilter postFilter = new QFilter("postcategory", "=", (Object)HRPIValueConstants.POS_CATEGORY_FULL);
        Object[] dynamicObject1 = serviceHelper.query("id", new QFilter[]{postFilter});
        if (HRArrayUtils.isNotEmpty((Object[])dynamicObject1)) {
            return Arrays.stream(dynamicObject1).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        }
        return new HashSet<Long>(1);
    }

    private void getRetFail(Map<String, Object> result, String message, String errorCode) {
        this.buildResult(result, false, message, null, errorCode);
    }

    private void getRetSuccess(Map<String, Object> result, Object data, String errorCode) {
        this.buildResult(result, true, null, data, errorCode);
    }

    private void buildResult(Map<String, Object> result, boolean flag, String message, Object data, String errorCode) {
        result.put("success", flag);
        result.put("message", message);
        result.put("code", errorCode);
        if (null != data) {
            result.put("data", data);
        }
    }

    @Override
    public DynamicObject[] getErManFile(String key, List<Object> values) {
        return this.getErManFile(key, values, QFilterUtil.getDataStatusFilter().and(QFilterUtil.getStatusFilters()).and(QFilterUtil.getInitStatusFinish()).and(QFilterUtil.getCurrentQf()));
    }

    @Override
    public DynamicObject[] getErManFile(String key, List<Object> values, QFilter customFilter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!StringUtils.isEmpty((Object)key) && !CollectionUtils.isEmpty(values)) {
            filters.add(new QFilter(key, "in", values));
        }
        Optional.ofNullable(customFilter).ifPresent(filters::add);
        if (CollectionUtils.isEmpty(filters)) {
            LOG.error("invoke method getErManFile without filter ...");
            throw new KDBizException("invoke method getErManFile without filter");
        }
        return HRPIManFileRepository.manFileServiceHelper.loadDynamicObjectArray(filters.toArray(new QFilter[0]));
    }

    @Override
    public void updateIndex(Map<Long, Object> map) {
        DynamicObject[] dys;
        for (DynamicObject dy : dys = HRPIDepempRepository.queryEffectingByBoIds("id,boid,sort", map.keySet())) {
            dy.set("sort", map.get(dy.getLong("boid")));
        }
        HRPIDepempRepository.save(dys);
    }

    @Override
    public Map<String, Object> listPersonEmpOrgRel(String personType, List<Long> ids) {
        return this.listPersonEmpOrgRel(personType, ids, new Date());
    }

    @Override
    public Map<String, Object> listPersonEmpOrgRel(String personType, List<Long> ids, Date date) {
        QFilter personFilter;
        List<Map<String, Object>> empObjs;
        Map<Object, Object> mapping;
        LOG.info("listPersonEmpOrgRel start : {}, ids:{}, date:{} ", new Object[]{personType, ids, date});
        HashSet errorSet = Sets.newHashSet();
        try {
            Optional.ofNullable(personType).ifPresent(type -> ValidateHelper.addErrorMsg(!IRPCConstants.LIMIT_PERSON_TYPE.contains(type), errorSet, "the personType limit user/person/employee/depemp"));
            ValidateHelper.addErrorMsg(CollectionUtils.isEmpty(ids), errorSet, "ids cannot be empty");
            Optional.ofNullable(date).ifPresent(d -> ValidateHelper.addErrorMsg(!DateUtil.isSameDay(d, new Date()) && d.after(new Date()), errorSet, "not support the future time"));
            if (errorSet.size() > 0) {
                return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), JSONObject.toJSONString((Object)errorSet)).get();
            }
        }
        catch (Exception exception) {
            LOG.error("validate request param occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), String.format(ErrorCodeEnum.VALIDATE_FAILED.getInfo(), exception.getMessage(), JSONObject.toJSONString((Object)errorSet))).get();
        }
        switch (personType) {
            case "user": {
                mapping = Arrays.stream(RepositoryUtil.getDynamicObjectCollection("user,employee", "hrpi_personuserrel", new QFilter[]{new QFilter("user", "in", ids)})).collect(Collectors.toMap(dy -> dy.getLong("employee"), dy -> dy.getLong("user"), (k1, k2) -> k1));
                if (CollectionUtils.isEmpty((Map)mapping) || !mapping.values().stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().anyMatch(entry -> (Long)entry.getValue() > 1L)) break;
                Set isNotLastIds = Arrays.stream(RepositoryUtil.getDynamicObjectCollection("id", "hrpi_employee", new QFilter[]{new QFilter("id", "in", mapping.keySet()), QFilterUtil.isNotLatestRecord()})).map(dy -> (Long)dy.getPkValue()).collect(Collectors.toSet());
                mapping.keySet().removeAll(isNotLastIds);
                break;
            }
            case "person": {
                mapping = Arrays.stream(RepositoryUtil.getDynamicObjectCollection("id,person.id", "hrpi_employee", new QFilter[]{new QFilter("person", "in", ids), QFilterUtil.isLatestRecord(), QFilterUtil.getCurrentQf()})).collect(Collectors.toMap(dy -> (Long)dy.getPkValue(), dy -> dy.getLong("person.id"), (k1, k2) -> k1));
                break;
            }
            default: {
                mapping = Maps.newHashMap();
                LOG.info("query by employee or dempemp .");
            }
        }
        if (CollectionUtils.isEmpty(empObjs = DynamicTransformUtil.dynamicListToMap(Arrays.asList(RepositoryUtil.getDynamicObjectCollection(IRPCConstants.IGNORE_SET, "hrpi_empposorgrel", new QFilter[]{personFilter = "depemp".equals(personType) ? new QFilter("depemp", "in", ids) : new QFilter("employee", "in", "employee".equals(personType) ? ids : mapping.keySet()), QFilterUtil.getContainFilter(date), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()}))))) {
            return ResultBuilder.success(Maps.newHashMap()).addMsg("there is no data in the condition").get();
        }
        Map<Long, Long> posTypeWithCls = Arrays.stream(RepositoryUtil.getDynamicObjectCollection("id,postcategory.id", HBSS_POSTYPE, null)).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("postcategory.id")));
        empObjs.forEach(map -> {
            map.put("postcategory_id", posTypeWithCls.get(map.get("postype_id")));
            map.put("depemp", map.get("depemp_id"));
        });
        if ("person".equals(personType) || "user".equals(personType)) {
            empObjs.forEach(map -> map.put(personType, mapping.get(map.get("employee"))));
        }
        Map<Long, List<Map>> res = empObjs.stream().collect(Collectors.groupingBy(v -> (Long)v.get(personType)));
        return ResultBuilder.success(res).get();
    }

    @Override
    public Map<String, Object> listPersonBeChargeOf(String personType, List<Long> ids) {
        return this.listPersonBeChargeOf(personType, ids, new Date());
    }

    @Override
    public Map<String, Object> listPersonBeChargeOf(String personType, List<Long> ids, Date date) {
        Map<Object, Object> mapping;
        LOG.info("listPersonBeChargeOf start : {}, ids:{}, date:{} ", new Object[]{personType, ids, date});
        HashSet errorSet = Sets.newHashSet();
        try {
            ValidateHelper.addErrorMsg(CollectionUtils.isEmpty(ids), errorSet, "ids cannot be empty");
            Optional.ofNullable(personType).ifPresent(type -> ValidateHelper.addErrorMsg(!IRPCConstants.LIMIT_PERSON_TYPE.contains(type), errorSet, "the personType limit user/person/employee/depemp"));
            Optional.ofNullable(date).ifPresent(d -> ValidateHelper.addErrorMsg(!DateUtil.isSameDay(d, new Date()) && d.after(new Date()), errorSet, "not support the future time"));
            if (errorSet.size() > 0) {
                return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), JSONObject.toJSONString((Object)errorSet)).get();
            }
        }
        catch (Exception exception) {
            LOG.error("validate request param occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), String.format(ErrorCodeEnum.VALIDATE_FAILED.getInfo(), exception.getMessage(), JSONObject.toJSONString((Object)errorSet))).get();
        }
        switch (personType) {
            case "user": {
                mapping = Arrays.stream(RepositoryUtil.getDynamicObjectCollection("user,person", "hrpi_personuserrel", new QFilter[]{new QFilter("user", "in", ids), new QFilter("enable", "=", (Object)Character.valueOf('1'))})).collect(Collectors.toMap(dy -> dy.getLong("person"), dy -> dy.getLong("user"), (k1, k2) -> k1));
                break;
            }
            case "employee": {
                mapping = Arrays.stream(RepositoryUtil.getDynamicObjectCollection("id,person", "hrpi_employee", new QFilter[]{new QFilter("id", "in", ids)})).collect(Collectors.toMap(dy -> dy.getLong("person_id"), dy -> (Long)dy.getPkValue(), (k1, k2) -> k1));
                break;
            }
            case "depemp": {
                mapping = Arrays.stream(RepositoryUtil.getDynamicObjectCollection("id,person", "hrpi_depemp", new QFilter[]{new QFilter("id", "in", ids)})).collect(Collectors.toMap(dy -> dy.getLong("person_id"), dy -> (Long)dy.getPkValue(), (k1, k2) -> k1));
                break;
            }
            default: {
                mapping = Maps.newHashMap();
                LOG.info("query by person , invoke rpc instead .");
            }
        }
        ChargeApplicationImpl service = new ChargeApplicationImpl();
        Map<Long, List<Map<String, Object>>> res = service.queryChargeByPersonId("person".equals(personType) ? ids : new ArrayList(mapping.keySet()), date);
        if (CollectionUtils.isEmpty(res)) {
            return ResultBuilder.success(Maps.newHashMap()).addMsg("there is no data in the condition").get();
        }
        HashMap resM = Maps.newHashMap();
        if (!"person".equals(personType)) {
            res.forEach((key, value) -> resM.put(mapping.get(key), value));
            return ResultBuilder.success(resM).get();
        }
        return ResultBuilder.success(res).get();
    }

    @Override
    public Map<String, Object> queryDepEmpIdByEmpNumbers(List<String> empNumbers) {
        LOG.info("queryDepEmpIdByEmpNumbers start : {} ", empNumbers);
        HashSet errorSet = Sets.newHashSet();
        ValidateHelper validator = ValidateHelper.getInstance(errorSet);
        try {
            validator.validateReqListNotNull().test(empNumbers);
            if (errorSet.size() > 0) {
                return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), JSONObject.toJSONString((Object)errorSet)).get();
            }
        }
        catch (Exception exception) {
            LOG.error("queryDepEmpIdByEmpNumbers validate request param occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), String.format(ErrorCodeEnum.VALIDATE_FAILED.getInfo(), exception.getMessage(), JSONObject.toJSONString((Object)errorSet))).get();
        }
        QFilter empnumberFilter = new QFilter("employee.empnumber", "in", empNumbers);
        QFilter primaryFilter = new QFilter("isprimary", "=", (Object)"1");
        QFilter labrelstatusprdFilter = new QFilter("employee.laborrelstatus", "in", HBSSBaseDataRepository.queryLaborrelstatusWorkingState(Collections.singletonList(IRPCConstants.IN_LABOUR)));
        QFilter[] filters = new QFilter[]{empnumberFilter, primaryFilter, labrelstatusprdFilter, QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()};
        String selectProperties = DynamicTransformUtil.getDynamicPropString("hrpi_depemp", IRPCConstants.IGNORE_SET);
        DynamicObject[] depempDyns = HRPIDepempRepository.depempServiceHelper.query(selectProperties, filters);
        Map<String, DynamicObject> empNumberToDepEmpDynMap = Arrays.stream(depempDyns).collect(Collectors.toMap(dy -> dy.getString("employee.empnumber"), dy -> dy, (v1, v2) -> v2));
        return ResultBuilder.success(empNumberToDepEmpDynMap).get();
    }

    static {
        MODIFY_PROP_POSORGREL = new HashSet<String>(Arrays.asList("number", "islatestrecord", "description", "startdate", "enddate", "sysenddate", "company", "businessstatus"));
    }
}

