/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.qing.util.MapUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.config.IDevParamConfigService;
import kd.hrmp.hrpi.business.domian.repository.DevParamConfigRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmpEntrelRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRolerelRepository;
import kd.hrmp.hrpi.business.domian.repository.RepositoryUtil;
import kd.hrmp.hrpi.business.domian.service.IEmployeeService;
import kd.hrmp.hrpi.business.domian.service.IHRPISerLenCalService;
import kd.hrmp.hrpi.business.helper.ResultBuilder;
import kd.hrmp.hrpi.business.helper.ValidateHelper;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.IRPCConstants;
import kd.hrmp.hrpi.common.enums.ErrorCodeEnum;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;
import kd.sdk.hr.hrmp.hrpi.extpoint.PersonSerLenExtUtil;
import kd.sdk.hr.hrmp.hrpi.extpoint.dto.PersonSerLenDto;

public class EmployeeServiceImpl
implements IEmployeeService<DynamicObject> {
    private static final Log LOGGER = LogFactory.getLog(EmployeeServiceImpl.class);
    private static volatile IEmployeeService EMPLOYEESERVICE;
    private static final Set<String> CHECK_FILEDS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IEmployeeService getInstance() {
        try {
            if (null != EMPLOYEESERVICE) return EMPLOYEESERVICE;
            Class<EmployeeServiceImpl> clazz = EmployeeServiceImpl.class;
            synchronized (EmployeeServiceImpl.class) {
                if (null != EMPLOYEESERVICE) return EMPLOYEESERVICE;
                try {
                    EMPLOYEESERVICE = new EmployeeServiceImpl();
                    LOGGER.info("HRPIServiceFactory-dependency-check,new-EmployeeServiceImpl()-success");
                }
                catch (Throwable t) {
                    LOGGER.error("HRPIServiceFactory-dependency-check,new-EmployeeServiceImpl()-fail", t);
                }
                return EMPLOYEESERVICE;
            }
        }
        catch (Throwable t) {
            LOGGER.error("HRPIServiceFactory-dependency-check,EmployeeServiceImpl-getInstance()-fail", t);
        }
        return EMPLOYEESERVICE;
    }

    @Override
    public Map checkEmployeeStatus(List<Object> checkList, String checkProp) {
        if (!CHECK_FILEDS.contains(checkProp) || checkList == null || checkList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u53c2\u6570\u3002", (String)"HRPIEmployeeRepository_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        String checkFiled = "employee".equals(checkProp) ? "id" : checkProp;
        boolean isString = "EMPNUMBER".equals(checkFiled);
        DynamicObjectCollection employeeList = HRPIEmployeeRepository.isExistEmployee(checkList, checkFiled);
        HashMap result = isString ? new HashMap(checkList.size()) : new HashMap(checkList.size());
        checkList.forEach(check -> result.put(check, Boolean.FALSE));
        if (!employeeList.isEmpty()) {
            employeeList.forEach(emp -> result.put(isString ? emp.getString(checkFiled) : Long.valueOf(emp.getLong(checkFiled)), Boolean.TRUE));
        }
        return result;
    }

    @Override
    public Map<Long, DynamicObject> getEmployeeStatus(List<Long> employeeIds) {
        String prop = "laborrelstatus.id";
        HashMap<Long, DynamicObject> employStatus = new HashMap<Long, DynamicObject>(employeeIds.size());
        Object[] empList = HRPIEmployeeRepository.listEmployeeIds(new HashSet<Long>(employeeIds));
        if (!HRArrayUtils.isEmpty((Object[])empList)) {
            Set laborrelIds = Arrays.stream(empList).map(emp -> emp.getLong(prop)).collect(Collectors.toSet());
            QFilter entityFilter = new QFilter("id", "in", laborrelIds);
            Map entityCfMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_laborrelstatus", (String)"name,fnumber,laborreltypecls,labrelstatuscls,labrelstatusprd", (QFilter[])new QFilter[]{entityFilter});
            if (!CollectionUtils.isEmpty((Map)entityCfMap)) {
                for (Object emp2 : empList) {
                    employStatus.put(emp2.getLong("id"), (DynamicObject)entityCfMap.get(emp2.getLong(prop)));
                }
            }
        }
        return employStatus;
    }

    @Override
    public DynamicObject getEmployee(Long employeeId) {
        return HRPIEmployeeRepository.getEmployee(employeeId);
    }

    @Override
    public List<DynamicObject> listEmployees(List<Long> employeeIds) {
        return Arrays.asList(HRPIEmployeeRepository.listEmployeeIds(employeeIds));
    }

    @Override
    public List<DynamicObject> listEmployeesByNumber(List<String> numbers) {
        return Arrays.asList(HRPIEmployeeRepository.listEmployeesByNombers(numbers));
    }

    @Override
    public DynamicObject getEmpentrel(Long employeeId) {
        return HRPIEmployeeRepository.getEmpentrel(employeeId);
    }

    @Override
    public List<DynamicObject> listEmployeeAttachs(Long employeeId, String attachEntityName) {
        return Arrays.asList(HRPIEmployeeRepository.listEmployeeAttachs(employeeId, attachEntityName));
    }

    @Override
    public List<DynamicObject> listBatchEmployeeAttachs(List<Long> employeeIds, QFilter qFilter, String attachEntityName) {
        DynamicObject[] dynamicObjects;
        try {
            dynamicObjects = HRPIEmployeeRepository.listBatchEmployeeAttachs(employeeIds, qFilter, attachEntityName);
        }
        catch (Exception ex) {
            LOGGER.error("list listBatchPersonAttachs filter", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6761\u4ef6\u3002", (String)"EmployeeServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return Arrays.asList(dynamicObjects);
    }

    @Override
    public List<DynamicObject> listBatchPropEmployeeAttachs(List<Long> employeeIds, String selectProps, String attachEntityName) {
        DynamicObject[] dynamicObjects;
        try {
            dynamicObjects = HRPIEmployeeRepository.listFieldsEmployeeAttachs(employeeIds, selectProps, attachEntityName);
        }
        catch (Exception ex) {
            LOGGER.error("list listBatchPropEmployeeAttachs filter", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6761\u4ef6\u3002", (String)"EmployeeServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return Arrays.asList(dynamicObjects);
    }

    @Override
    public List<DynamicObject> listBatchEmployeeByPerson(List<Long> personIds, QFilter qFilter, String attachEntityName) {
        DynamicObject[] dynamicObjects;
        try {
            dynamicObjects = HRPIEmployeeRepository.listBatchEmployeeAttachsByPerson(personIds, qFilter, attachEntityName);
        }
        catch (Exception ex) {
            LOGGER.error("list listBatchPersonAttachs filter", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6761\u4ef6\u3002", (String)"EmployeeServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return Arrays.asList(dynamicObjects);
    }

    @Override
    public int countEmpentrelByByTypeclsAndStatusCls(List<Long> labreltypeclsList, List<Long> labrelstatusclsList) {
        if (CollectionUtils.isEmpty(labreltypeclsList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u5206\u7c7b\u3002", (String)"EmployeeServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(labrelstatusclsList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u5206\u7c7b\u3002", (String)"EmployeeServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return HRPIEmployeeRepository.countEmpentrelByByTypeclsAndStatusCls(labreltypeclsList, labrelstatusclsList);
    }

    @Override
    public List<DynamicObject> listEmpentrelByByTypeclsAndStatusCls(List<Long> labreltypeclsList, List<Long> labrelstatusclsList, int start, int limit) {
        if (CollectionUtils.isEmpty(labreltypeclsList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u5206\u7c7b\u3002", (String)"EmployeeServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(labrelstatusclsList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u5206\u7c7b\u3002", (String)"EmployeeServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return Arrays.asList(HRPIEmployeeRepository.listEmpentrelByByTypeclsAndStatusCls(labreltypeclsList, labrelstatusclsList, "person,employee,laborreltype,laborrelstatus", start, limit));
    }

    @Override
    public List<DynamicObject> listEmpentrelByByTypeclsAndStatusCls(List<Long> labreltypeclsList, List<Long> labrelstatusclsList, String selectProperties, long id, int top) {
        if (CollectionUtils.isEmpty(labreltypeclsList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u5206\u7c7b\u3002", (String)"EmployeeServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(labrelstatusclsList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u5206\u7c7b\u3002", (String)"EmployeeServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return Arrays.asList(HRPIEmployeeRepository.listEmpentrelByByTypeclsAndStatusCls(labreltypeclsList, labrelstatusclsList, selectProperties, id, top));
    }

    @Override
    public List<Map<String, Object>> getOrgHisPerson(Date queryDate, List<Long> positionIds) {
        LOGGER.info("queryDate is : {} positionIds is: {}.", (Object)queryDate, positionIds);
        if (queryDate == null) {
            queryDate = new Date();
        }
        queryDate = HRDateTimeUtils.truncateDate((Date)queryDate);
        if (positionIds == null || positionIds.size() == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        DynamicObject[] empPosDys = HRPIEmployeeRepository.getEmpPos(queryDate, positionIds);
        if (empPosDys != null && empPosDys.length > 0) {
            DynamicObject[] empEnts;
            ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
            List<Object> personIds = Arrays.stream(empPosDys).map(empPos -> empPos.get("person.id")).collect(Collectors.toList());
            for (DynamicObject dy : empEnts = HRPIEmployeeRepository.getEmpEnt(personIds)) {
                Object personId = dy.get("person.id");
                List collect = Arrays.stream(empPosDys).filter(empPos -> empPos.get("person.id").equals(personId)).collect(Collectors.toList());
                if (collect == null || collect.size() <= 0) continue;
                HashMap<String, Object> dyMap = new HashMap<String, Object>();
                DynamicObject empPosRelDy = (DynamicObject)collect.get(0);
                if (empPosRelDy == null) continue;
                dyMap.put("positionId", empPosRelDy.get("position.id"));
                dyMap.put("isprimary", empPosRelDy.get("isprimary"));
                dyMap.put("postype", empPosRelDy.getDynamicObject("postype"));
                dyMap.put("posstatus", empPosRelDy.getDynamicObject("posstatus"));
                dyMap.put("name", dy.get("person.name"));
                dyMap.put("headsculpture", dy.get("person.headsculpture"));
                dyMap.put("laborreltype", dy.getDynamicObject("laborreltype"));
                dyMap.put("laborrelstatus", dy.get("laborrelstatus"));
                resultList.add(dyMap);
            }
            return resultList;
        }
        return new ArrayList<Map<String, Object>>();
    }

    @Override
    public Map<String, Object> listEmpAndPersonInfoByTimeCondition(Map<String, Object> requestMap) {
        LOGGER.info("listEmpAndPersonInfoByTimeCondition start : {} ", requestMap);
        HashSet errorSet = Sets.newHashSet();
        ValidateHelper validator = ValidateHelper.getInstance(errorSet);
        try {
            validator.validateReqMapNotNull().or(validator.validateMustInput("sign", "signList", "qTimeModel", "dateOne")).or(validator.validateArgType(ValidateHelper.isStringType, "sign", "businessStatus", "qTimeModel")).or(validator.validateArgType(ValidateHelper.isListType, "signList")).or(validator.validateLimit("sign", ImmutableList.of((Object)"person", (Object)"employee", (Object)"empnumber"))).or(validator.validateLimit("businessStatus", IRPCConstants.LIMIT_BUSINESS_STATUS_ENUM)).or(validator.validateLimit("qTimeModel", IRPCConstants.LIMIT_TIMEMODEL_ENUM)).or(validator.validateListSize("signList", 10000)).or(validator.validateDateRel("dateOne", "dateTwo")).test(requestMap);
            if (errorSet.size() > 0) {
                return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), JSONObject.toJSONString((Object)errorSet)).get();
            }
        }
        catch (Exception exception) {
            LOGGER.error("validate request param occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), String.format(ErrorCodeEnum.VALIDATE_FAILED.getInfo(), exception.getMessage(), JSONObject.toJSONString((Object)errorSet))).get();
        }
        String selectPros = DynamicTransformUtil.getDynamicPropString("hrpi_empentrel", IRPCConstants.IGNORE_SET);
        QFilter[] qFilters = this.getQueryEmpEntRelFilters(requestMap);
        DynamicObject[] empEntRelObjs = HRPIEmployeeRepository.empentrelServiceHelper.query(selectPros, qFilters);
        if (null == empEntRelObjs || empEntRelObjs.length == 0) {
            return ResultBuilder.success(Collections.emptyMap()).addMsg("there is no data in the condition").get();
        }
        List personIds = Arrays.stream(empEntRelObjs).map(dy -> dy.getLong("person_id")).collect(Collectors.toList());
        List<Map<String, Object>> empListMap = DynamicTransformUtil.dynamicListToMap(Arrays.asList(empEntRelObjs));
        Map<Long, Map> personIdWithPerson = DynamicTransformUtil.dynamicListToMap(Arrays.asList(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "id", "personindexid", "headsculpture", "number"), null, "hrpi_person", new QFilter[]{new QFilter("id", "in", personIds)}, null))).stream().collect(Collectors.toMap(map -> (Long)map.get("id"), map -> map));
        QFilter[] qFilterPerNonArray = new QFilter[]{new QFilter("person", "in", personIds), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()};
        Map<Long, Map> personIdWithPerNon = DynamicTransformUtil.dynamicListToMap(Arrays.asList(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "phone"), null, "hrpi_percontact", qFilterPerNonArray, null))).stream().collect(Collectors.toMap(map -> (Long)map.get("person_id"), map -> map, (k1, k2) -> k1));
        Map<Long, Map> personIdWithPerCon = DynamicTransformUtil.dynamicListToMap(Arrays.asList(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "gender"), null, "hrpi_pernontsprop", qFilterPerNonArray, null))).stream().collect(Collectors.toMap(map -> (Long)map.get("person_id"), map -> map));
        empListMap.forEach(map -> {
            HashMap empMap = new HashMap(map);
            map.put("hrpi_empentrel", empMap);
            map.put("hrpi_person", personIdWithPerson.get(map.get("person_id")));
            map.put("hrpi_pernontsprop", personIdWithPerNon.get(map.get("person_id")));
            map.put("hrpi_percontact", personIdWithPerCon.get(map.get("person_id")));
            map.keySet().removeIf(key -> !Arrays.asList("hrpi_empentrel", "hrpi_person", "hrpi_pernontsprop", "hrpi_percontact", requestMap.get("sign")).contains(key));
        });
        return ResultBuilder.success(empListMap).get();
    }

    private QFilter[] getQueryEmpEntRelFilters(Map<String, Object> requestMap) {
        QFilter pFilter = new QFilter((String)requestMap.get("sign"), "in", requestMap.get("signList"));
        QFilter filterBusiness = new QFilter("businessstatus", "=", Optional.ofNullable(requestMap.get("businessStatus")).orElse("1"));
        QFilter dateFilter = QFilterUtil.getTimeFilter((String)requestMap.get("qTimeModel"), DateUtil.getDate(requestMap.get("dateOne")), DateUtil.getDate(requestMap.get("dateTwo")));
        return new QFilter[]{pFilter, filterBusiness, dateFilter, QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish(), QFilterUtil.isLatestRecord()};
    }

    @Override
    public Map<String, Object> listEmpNonInfoWithIds(Map<String, Object> requestMap) {
        LOGGER.info("listEmpNonInfoWithIds start : {} ", requestMap);
        if ("empnumber".equals(requestMap.get("sign"))) {
            LOGGER.error("listEmpNonInfoWithIds not support the empnumber as a param , you can use person or employee");
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), "not support empnumber").get();
        }
        return this.listEmpNonInfo(requestMap);
    }

    @Override
    public Map<String, Object> listEmpNonInfo(Map<String, Object> requestMap) {
        QFilter[] qFilters;
        LOGGER.info("listEmpNonInfo start : {} ", requestMap);
        HashSet errorSet = Sets.newHashSet();
        ValidateHelper validator = ValidateHelper.getInstance(errorSet);
        try {
            validator.validateReqMapNotNull().or(validator.validateMustInput("sign", "signList")).or(validator.validateArgType(ValidateHelper.isStringType, "sign", "businessStatus")).or(validator.validateArgType(ValidateHelper.isListType, "signList")).or(validator.validateLimit("sign", ImmutableList.of((Object)"person", (Object)"employee", (Object)"empnumber"))).or(validator.validateLimit("businessStatus", IRPCConstants.LIMIT_BUSINESS_STATUS_ENUM)).or(validator.validateListSize("signList", 10000)).test(requestMap);
            if (errorSet.size() > 0) {
                return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), JSONObject.toJSONString((Object)errorSet)).get();
            }
        }
        catch (Exception exception) {
            LOGGER.error("validate request param occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), String.format(ErrorCodeEnum.VALIDATE_FAILED.getInfo(), exception.getMessage(), JSONObject.toJSONString((Object)errorSet))).get();
        }
        Map<Object, Long> relationShip = this.getRelationShip(requestMap);
        if (MapUtils.isEmpty(relationShip)) {
            return ResultBuilder.success(Collections.emptyList()).addMsg("there is no data in the condition").get();
        }
        String selectProperties = DynamicTransformUtil.getDynamicPropString("hrpi_empnonentrel", IRPCConstants.IGNORE_SET);
        List<Map<String, Object>> empNonDataMaps = DynamicTransformUtil.dynamicListToMap(Arrays.asList(RepositoryUtil.getDynamicObjectCollection(selectProperties, null, "hrpi_empnonentrel", qFilters = this.getEmpNonFilters(requestMap, relationShip.keySet()), null)));
        if (CollectionUtils.isEmpty(empNonDataMaps)) {
            return ResultBuilder.success(Collections.emptyList()).addMsg("there is no data in the condition").get();
        }
        empNonDataMaps.forEach(map -> map.put("personindexid", relationShip.get(map.get("person".equals(requestMap.get("sign")) ? "person_id" : requestMap.get("sign")))));
        Map<Long, List<Map>> groupedByIndexIdMap = empNonDataMaps.stream().collect(Collectors.groupingBy(map -> (Long)map.get("personindexid")));
        HashMap resMap = Maps.newHashMapWithExpectedSize((int)groupedByIndexIdMap.size());
        relationShip.forEach((k, v) -> {
            HashMap tempMap = Maps.newHashMapWithExpectedSize((int)4);
            tempMap.put("sign", k);
            tempMap.put("personindexid", v);
            tempMap.put("times", null == groupedByIndexIdMap.get(v) ? 0 : ((List)groupedByIndexIdMap.get(v)).size());
            tempMap.put("signList", groupedByIndexIdMap.get(v));
            resMap.put(k, tempMap);
        });
        return ResultBuilder.success(resMap).get();
    }

    private QFilter[] getEmpNonFilters(Map<String, Object> requestMap, Set<Object> conditionSets) {
        QFilter pFilter = new QFilter((String)requestMap.get("sign"), "in", conditionSets);
        QFilter filterBusiness = new QFilter("businessstatus", "=", Optional.ofNullable(requestMap.get("businessStatus")).orElse("1"));
        return new QFilter[]{pFilter, QFilterUtil.getCurrentQf(), filterBusiness, QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish(), QFilterUtil.empLatestRecord()};
    }

    private Map<Object, Long> getRelationShip(Map<String, Object> requestMap) {
        String sign = (String)requestMap.get("sign");
        if ("employee".equals(sign)) {
            Map<Long, Long> personIdWithEmpId = Arrays.stream(RepositoryUtil.getDynamicObjectCollection("id,person", null, "hrpi_employee", new QFilter[]{new QFilter("id", "in", requestMap.get("signList")), QFilterUtil.getInitStatusFinish()}, null)).collect(Collectors.toMap(dy -> dy.getLong("person_id"), dy -> dy.getLong("id"), (k1, k2) -> k1));
            Map<Long, Long> personIdWithIndexId = Arrays.stream(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "id", "personindexid"), null, "hrpi_person", new QFilter[]{new QFilter("id", "in", personIdWithEmpId.keySet()), QFilterUtil.getInitStatusFinish()}, null)).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("personindexid"), (k1, k2) -> k1));
            Map<Long, Long> personIdWithIndexIdReal = Arrays.stream(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "id", "personindexid"), null, "hrpi_person", new QFilter[]{new QFilter("personindexid", "in", personIdWithIndexId.values()), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()}, null)).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("personindexid"), (k1, k2) -> k1));
            if (personIdWithIndexId.size() == personIdWithIndexIdReal.size()) {
                HashMap resMap = Maps.newHashMapWithExpectedSize((int)personIdWithIndexId.size());
                personIdWithIndexIdReal.forEach((k, v) -> resMap.put(personIdWithEmpId.get(k), v));
                LOGGER.info("Every personId/employeeId link just one piece personIndexId in this requestMap's data , shows there are no person have reentry the company . ");
                return resMap;
            }
            Map<Long, Long> realPersonIdWithEmpId = Arrays.stream(RepositoryUtil.getDynamicObjectCollection("id,person", null, "hrpi_employee", new QFilter[]{new QFilter("person", "in", personIdWithIndexIdReal.keySet()), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()}, null)).collect(Collectors.toMap(dy -> dy.getLong("person_id"), dy -> dy.getLong("id"), (k1, k2) -> k1));
            HashMap resMap = Maps.newHashMapWithExpectedSize((int)realPersonIdWithEmpId.size());
            personIdWithIndexIdReal.forEach((k, v) -> resMap.put(realPersonIdWithEmpId.get(k), v));
            return resMap;
        }
        if ("person".equals(sign)) {
            Map<Object, Long> personIdWithIndexId = Arrays.stream(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "id", "personindexid"), null, "hrpi_person", new QFilter[]{new QFilter("id", "in", requestMap.get("signList")), QFilterUtil.getInitStatusFinish()}, null)).collect(Collectors.toMap(dy -> dy.get("id"), dy -> dy.getLong("personindexid"), (k1, k2) -> k1));
            return Arrays.stream(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "id", "personindexid"), null, "hrpi_person", new QFilter[]{new QFilter("personindexid", "in", personIdWithIndexId.values()), QFilterUtil.getCurrentQf()}, null)).collect(Collectors.toMap(dy -> dy.get("id"), dy -> dy.getLong("personindexid"), (k1, k2) -> k1));
        }
        LOGGER.warn("As a update about person's number . One number can match more than one person , we shouldn't use emp_number as a query param");
        Map<Object, Long> numberWithIndexId = Arrays.stream(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "number", "personindexid"), null, "hrpi_person", new QFilter[]{new QFilter("number", "in", requestMap.get("signList")), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()}, null)).collect(Collectors.toMap(dy -> dy.get("number"), dy -> dy.getLong("personindexid"), (k1, k2) -> k1));
        return Arrays.stream(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "number", "personindexid"), null, "hrpi_person", new QFilter[]{new QFilter("personindexid", "in", numberWithIndexId.values()), QFilterUtil.getCurrentQf()}, null)).collect(Collectors.toMap(dy -> dy.get("number"), dy -> dy.getLong("personindexid"), (k1, k2) -> k1));
    }

    @Override
    public Map<String, Object> listEmpInfoByRole(Map<String, Object> requestMap) {
        LOGGER.info("listEmpInfoByRole start : {} ", requestMap);
        HashSet errorSet = Sets.newHashSet();
        ValidateHelper validator = ValidateHelper.getInstance(errorSet);
        try {
            validator.validateReqMapNotNull().or(validator.validateMustInput("roleIds", "qTimeModel", "dateOne")).or(validator.validateArgType(ValidateHelper.isListType, "roleIds")).or(validator.validateArgType(ValidateHelper.isStringType, "businessStatus", "qTimeModel")).or(validator.validateArgType(ValidateHelper.isLongType, "maxId")).or(validator.validateArgType(ValidateHelper.isIntegerType, "singlePageRows")).or(validator.validateLimit("businessStatus", IRPCConstants.LIMIT_BUSINESS_STATUS_ENUM)).or(validator.validateLimit("qTimeModel", IRPCConstants.LIMIT_TIMEMODEL_ENUM)).or(validator.validateDateRel("dateOne", "dateTwo")).or(validator.validatePairInput("maxId", "singlePageRows")).test(requestMap);
            if (errorSet.size() > 0) {
                return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), JSONObject.toJSONString((Object)errorSet)).get();
            }
        }
        catch (Exception exception) {
            LOGGER.error("validate request param occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), String.format(ErrorCodeEnum.VALIDATE_FAILED.getInfo(), exception.getMessage(), JSONObject.toJSONString((Object)errorSet))).get();
        }
        String selectProperties = DynamicTransformUtil.getDynamicPropString("hrpi_personrolerel", IRPCConstants.IGNORE_SET);
        QFilter[] qFilters = this.getPersonRoleByRoleIdFilter(requestMap);
        DynamicObject[] personRoles = null != requestMap.get("singlePageRows") ? HRPIPersonRolerelRepository.serviceHelper.query(selectProperties, qFilters, "id", ((Integer)requestMap.get("singlePageRows")).intValue()) : RepositoryUtil.getDynamicObjectCollection(selectProperties, null, "hrpi_personrolerel", qFilters, null);
        if (null == personRoles || personRoles.length == 0) {
            return ResultBuilder.success(Collections.emptyMap()).addMsg("there is no data in the condition").get();
        }
        List<Map<String, Object>> sourceList = DynamicTransformUtil.dynamicListToMap(Arrays.asList(personRoles));
        Map<Long, HashMap> personIdWithPersonRole = sourceList.stream().collect(Collectors.toMap(map -> (Long)map.get("person_id"), HashMap::new, (k1, k2) -> k1));
        sourceList.forEach(map -> map.entrySet().removeIf(o -> !Arrays.asList("role", "role_id", "person_id", "employee_id").contains(o.getKey())));
        List personIds = Arrays.stream(personRoles).map(dy -> dy.getLong("person_id")).collect(Collectors.toList());
        Map<Long, Map> personIdWithPerson = DynamicTransformUtil.dynamicListToMap(Arrays.asList(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "id", "headsculpture", "number", "name"), null, "hrpi_person", new QFilter[]{new QFilter("id", "in", personIds), QFilterUtil.getInitStatusFinish()}, null))).stream().collect(Collectors.toMap(map -> (Long)map.get("id"), map -> map, (k1, k2) -> k1));
        Map<Long, Map> personIdWithGender = DynamicTransformUtil.dynamicListToMap(Arrays.asList(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "gender"), null, "hrpi_pernontsprop", new QFilter[]{new QFilter("person", "in", personIds), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()}, null))).stream().collect(Collectors.toMap(map -> (Long)map.get("person_id"), map -> map, (k1, k2) -> k1));
        Map<Long, Map> personIdWithPhone = DynamicTransformUtil.dynamicListToMap(Arrays.asList(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "phone"), null, "hrpi_percontact", new QFilter[]{new QFilter("person", "in", personIds), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()}, null))).stream().collect(Collectors.toMap(map -> (Long)map.get("person_id"), map -> map, (k1, k2) -> k1));
        Map<Long, Map> personIdWithEmpInfo = DynamicTransformUtil.dynamicListToMap(Arrays.asList(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "employee", "laborreltype", "laborrelstatus", "startdate"), null, "hrpi_empentrel", new QFilter[]{new QFilter("person", "in", personIds), QFilterUtil.getCurrentQf(), QFilterUtil.getStatusFilters(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()}, null))).stream().collect(Collectors.toMap(map -> (Long)map.get("person_id"), map -> map, (k1, k2) -> k1));
        DynamicTransformUtil.mergeMap(sourceList, new Tuple((Object)"hrpi_personrolerel", personIdWithPersonRole), new Tuple((Object)"hrpi_person", personIdWithPerson), new Tuple((Object)"hrpi_pernontsprop", personIdWithGender), new Tuple((Object)"hrpi_percontact", personIdWithPhone), new Tuple((Object)"hrpi_empentrel", personIdWithEmpInfo));
        Map<Long, List<Map>> roleIdWithData = sourceList.stream().collect(Collectors.groupingBy(map -> (Long)map.get("role_id")));
        long maxId = Arrays.stream(personRoles).max(Comparator.comparingLong(x -> x.getLong("id"))).get().getLong("id");
        return ResultBuilder.success(roleIdWithData).put("maxId", maxId).get();
    }

    private QFilter[] getPersonRoleByRoleIdFilter(Map<String, Object> requestMap) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        Optional.ofNullable(requestMap.get("maxId")).ifPresent(f -> filters.add(new QFilter("id", ">", f)));
        filters.addAll(Arrays.asList(new QFilter("role", "in", requestMap.get("roleIds")), new QFilter("businessstatus", "=", Optional.ofNullable(requestMap.get("businessStatus")).orElse("1")), QFilterUtil.getTimeFilter(requestMap), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()));
        return filters.toArray(new QFilter[0]);
    }

    @Override
    public Map<String, Object> listPersonRole(Map<String, Object> requestMap) {
        LOGGER.info("listPersonRole start : {} ", requestMap);
        HashSet errorSet = Sets.newHashSet();
        ValidateHelper validator = ValidateHelper.getInstance(errorSet);
        try {
            validator.validateReqMapNotNull().or(validator.validateMustInput("sign", "signList", "qTimeModel", "dateOne")).or(validator.validateArgType(ValidateHelper.isListType, "signList")).or(validator.validateArgType(ValidateHelper.isStringType, "sign", "businessStatus", "qTimeModel")).or(validator.validateLimit("sign", Arrays.asList("number", "person", "employee"))).or(validator.validateLimit("businessStatus", IRPCConstants.LIMIT_BUSINESS_STATUS_ENUM)).or(validator.validateLimit("qTimeModel", IRPCConstants.LIMIT_TIMEMODEL_ENUM)).or(validator.validateDateRel("dateOne", "dateTwo")).or(validator.validateListSize("signList", 10000)).test(requestMap);
            if (errorSet.size() > 0) {
                return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), JSONObject.toJSONString((Object)errorSet)).get();
            }
        }
        catch (Exception exception) {
            LOGGER.error("validate request param occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), String.format(ErrorCodeEnum.VALIDATE_FAILED.getInfo(), exception.getMessage(), JSONObject.toJSONString((Object)errorSet))).get();
        }
        String selectProperties = DynamicTransformUtil.getDynamicPropString("hrpi_personrolerel", IRPCConstants.IGNORE_SET);
        Map<Object, Object> personIdWithNumber = Maps.newHashMapWithExpectedSize((int)((List)requestMap.get("signList")).size());
        if ("number".equals(requestMap.get("sign")) && MapUtils.isEmpty(personIdWithNumber = Arrays.stream(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "id", "number"), null, "hrpi_person", new QFilter[]{new QFilter("number", "in", requestMap.get("signList")), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()}, null)).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("number"), (k1, k2) -> k1)))) {
            return ResultBuilder.success(Collections.emptyMap()).addMsg("there is no data in the condition").get();
        }
        QFilter[] filters = this.getPersonRoleFilters(requestMap, personIdWithNumber);
        ConcurrentHashMap<Object, List<Map>> idWithListData = new ConcurrentHashMap<Object, List<Map>>(DynamicTransformUtil.dynamicListToMap(Arrays.asList(RepositoryUtil.getDynamicObjectCollection(selectProperties, null, "hrpi_personrolerel", filters, null))).stream().collect(Collectors.groupingBy(map -> map.get(this.getKey(requestMap)))));
        if (MapUtils.isEmpty(idWithListData)) {
            return ResultBuilder.success(Collections.emptyMap()).addMsg("there is no data in the condition").get();
        }
        if (MapUtils.isNotEmpty((Map)personIdWithNumber)) {
            HashMap finalNumberWithPersonID = personIdWithNumber;
            ((ConcurrentHashMap.KeySetView)idWithListData.keySet()).forEach(k -> Optional.ofNullable(finalNumberWithPersonID.get(k)).ifPresent(nKey -> {
                List cfr_ignored_0 = (List)idWithListData.put(nKey, (List<Map>)idWithListData.remove(k));
            }));
        }
        return ResultBuilder.success(idWithListData).get();
    }

    private Object getKey(Map<String, Object> requestMap) {
        return "number".equals(requestMap.get("sign")) || "person".equals(requestMap.get("sign")) ? "person_id" : requestMap.get("sign");
    }

    private QFilter[] getPersonRoleFilters(Map<String, Object> requestMap, Map<Long, String> numberWithPersonID) {
        QFilter personFilter = "number".equals(requestMap.get("sign")) ? new QFilter("person", "in", numberWithPersonID.keySet()) : new QFilter((String)requestMap.get("sign"), "in", requestMap.get("signList"));
        QFilter statusFilter = new QFilter("businessstatus", "=", Optional.ofNullable(requestMap.get("businessStatus")).orElse("1"));
        return new QFilter[]{personFilter, statusFilter, QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getTimeFilter(requestMap), QFilterUtil.getInitStatusFinish(), QFilterUtil.empLatestRecord()};
    }

    @Override
    public Map<String, Object> listPersonServiceAgeWithIds(Map<String, Object> requestMap) {
        LOGGER.info("listPersonServiceAgeWithIds start : {} ", requestMap);
        if ("empnumber".equals(requestMap.get("sign"))) {
            LOGGER.error("listPersonServiceAgeWithIds not support the empnumber as a param , you can use person or employee");
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), "not support empnumber").get();
        }
        return this.listPersonServiceAge(requestMap);
    }

    @Override
    public Map<String, Object> listPersonServiceAge(Map<String, Object> requestMap) {
        LOGGER.info("listPersonServiceAge start : {} ", requestMap);
        HashSet errorSet = Sets.newHashSet();
        ValidateHelper validator = ValidateHelper.getInstance(errorSet);
        try {
            validator.validateReqMapNotNull().or(validator.validateMustInput("sign", "signList", "dateTime")).or(validator.validateArgType(ValidateHelper.isListType, "signList")).or(validator.validateArgType(ValidateHelper.isStringType, "sign", "queryResult")).or(validator.validateLimit("sign", Arrays.asList("empnumber", "person", "employee"))).or(validator.validateLimit("queryResult", Arrays.asList("socialWorkAge", "companyWorkAge"))).or(validator.validateListSize("signList", 10000)).test(requestMap);
            if (errorSet.size() > 0) {
                return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), JSONObject.toJSONString((Object)errorSet)).get();
            }
        }
        catch (Exception exception) {
            LOGGER.error("validate request param occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), String.format(ErrorCodeEnum.VALIDATE_FAILED.getInfo(), exception.getMessage(), JSONObject.toJSONString((Object)errorSet))).get();
        }
        if (null != requestMap.get("queryResult")) {
            Map<Object, BigDecimal> res = this.executeAgeCalc(requestMap);
            if (MapUtils.isEmpty(res)) {
                return ResultBuilder.success(res).addMsg("there is no data in the condition").get();
            }
            return ResultBuilder.success(res).get();
        }
        HashMap resMap = Maps.newHashMapWithExpectedSize((int)((List)requestMap.get("signList")).size());
        Map<Object, BigDecimal> socialRes = this.socialWorkAgeCalc(requestMap);
        Map<Object, BigDecimal> companyRes = this.companyWorkAgeCalc(requestMap);
        ((List)requestMap.get("signList")).forEach(o -> {
            HashMap ages = Maps.newHashMapWithExpectedSize((int)2);
            ages.put("socialWorkAge", socialRes.get(o));
            ages.put("companyWorkAge", companyRes.get(o));
            resMap.put(o, ages);
        });
        return ResultBuilder.success(resMap).get();
    }

    @Override
    public Map<String, Object> insertOrUpdateAppointRemoveRel(Map<String, Object> requestMap) {
        LOGGER.info("insertOrUpdateAppointRemoveRel start : {} ", requestMap);
        HashSet errorSet = Sets.newHashSet();
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        try {
            Long personid = (Long)requestMap.get("personid");
            Long employeeid = (Long)requestMap.get("employeeid");
            if (Objects.isNull(personid) || personid == 0L) {
                errorSet.add(ResManager.loadKDString((String)"\u53c2\u6570\u201c\u81ea\u7136\u4eba\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EmployeeServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            } else {
                ArrayList<Long> personIds = new ArrayList<Long>(1);
                personIds.add(personid);
                DynamicObject[] personDys = HRPIPersonRepository.listPersons(personIds);
                if (personDys.length == 0) {
                    errorSet.add(ResManager.loadKDString((String)"\u8be5\u81ea\u7136\u4eba\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"EmployeeServiceImpl_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                }
            }
            if (Objects.isNull(employeeid) || employeeid == 0L) {
                errorSet.add(ResManager.loadKDString((String)"\u53c2\u6570\u201c\u4f01\u4e1a\u4eba\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EmployeeServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            } else {
                ArrayList<Long> employeeIds = new ArrayList<Long>(1);
                employeeIds.add(employeeid);
                DynamicObject[] employeeDys = HRPIEmployeeRepository.listEmployeeIds(employeeIds);
                if (employeeDys.length == 0) {
                    errorSet.add(ResManager.loadKDString((String)"\u8be5\u4f01\u4e1a\u4eba\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"EmployeeServiceImpl_7", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                }
            }
            if (errorSet.size() > 0) {
                responseMap.put("message", JSONObject.toJSONString((Object)errorSet));
                responseMap.put("success", false);
                return responseMap;
            }
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrpi_appointremoverel");
            String datatype = (String)requestMap.get("datatype");
            if (HRStringUtils.equals((String)datatype, (String)"insert")) {
                DynamicObject newEffectAppointRemoveRelDy = hrBaseServiceHelper.generateEmptyDynamicObject();
                Long boid = (Long)requestMap.get("appointrecordid");
                if (Objects.isNull(boid) || boid == 0L) {
                    newEffectAppointRemoveRelDy.set("id", (Object)ORM.create().genLongId("hrpi_appointremoverel"));
                } else {
                    newEffectAppointRemoveRelDy.set("id", (Object)boid);
                }
                responseMap.put("boid", newEffectAppointRemoveRelDy.getLong("id"));
                this.setAppointRemoveRelDyFields(newEffectAppointRemoveRelDy, requestMap);
                this.useHisVersionChange(new DynamicObject[]{newEffectAppointRemoveRelDy}, responseMap);
            } else if (HRStringUtils.equals((String)datatype, (String)"update")) {
                DynamicObject effectDy = this.queryEffectAppointRemoveRelDy(requestMap);
                if (HRObjectUtils.isEmpty((Object)effectDy)) {
                    responseMap.put("message", ResManager.loadKDString((String)"\u4efb\u514d\u7ecf\u5386\u4e3a\u7a7a\u3002", (String)"EmployeeServiceImpl_8", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                    responseMap.put("success", false);
                    return responseMap;
                }
                DynamicObject dynamicObject = hrBaseServiceHelper.generateEmptyDynamicObject();
                HashSet<String> ignoreFields = new HashSet<String>();
                ignoreFields.add("id");
                HRDynamicObjectUtils.copy((DynamicObject)effectDy, (DynamicObject)dynamicObject, ignoreFields);
                if (Objects.nonNull(requestMap.get("empposorgrelid"))) {
                    dynamicObject.set("empposrel_id", requestMap.get("empposorgrelid"));
                }
                if (Objects.nonNull(requestMap.get("appointtypeid"))) {
                    dynamicObject.set("appointtype_id", requestMap.get("appointtypeid"));
                }
                if (Objects.nonNull(requestMap.get("dismisstypeid"))) {
                    dynamicObject.set("dismisstype_id", requestMap.get("dismisstypeid"));
                }
                if (Objects.nonNull(requestMap.get("cadrecatid"))) {
                    dynamicObject.set("cadrecat_id", requestMap.get("cadrecatid"));
                }
                if (Objects.nonNull(requestMap.get("apptreasonggroupid"))) {
                    dynamicObject.set("apptreasonggroup_id", requestMap.get("apptreasonggroupid"));
                }
                dynamicObject.set("appointtypestatus", requestMap.get("appointtypestatus"));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                if (requestMap.get("dismissdate") instanceof String) {
                    dynamicObject.set("dismissdate", (Object)sdf.parse((String)requestMap.get("dismissdate")));
                } else if (requestMap.get("dismissdate") instanceof Date) {
                    dynamicObject.set("dismissdate", requestMap.get("dismissdate"));
                }
                if (requestMap.get("dismissdispatchdate") instanceof String) {
                    dynamicObject.set("dismissdispatchdate", (Object)sdf.parse((String)requestMap.get("dismissdispatchdate")));
                } else if (requestMap.get("dismissdispatchdate") instanceof Date) {
                    dynamicObject.set("dismissdispatchdate", requestMap.get("dismissdispatchdate"));
                }
                dynamicObject.set("appointreason", requestMap.get("appointreason"));
                dynamicObject.set("dismissdispatchnymber", requestMap.get("dismissdispatchnymber"));
                dynamicObject.set("description", requestMap.get("description"));
                dynamicObject.set("bsed", (Object)new Date());
                dynamicObject.set("initstatus", (Object)"2");
                this.useHisVersionChange(new DynamicObject[]{dynamicObject}, responseMap);
            } else if (HRStringUtils.equals((String)datatype, (String)"reappointment")) {
                DynamicObject effectDy = this.queryEffectAppointRemoveRelDy(requestMap);
                if (HRObjectUtils.isEmpty((Object)effectDy)) {
                    responseMap.put("message", ResManager.loadKDString((String)"\u4efb\u514d\u7ecf\u5386\u4e3a\u7a7a\u3002", (String)"EmployeeServiceImpl_8", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                    responseMap.put("success", false);
                    return responseMap;
                }
                DynamicObject invalidedAppointRemoveRelDy = hrBaseServiceHelper.generateEmptyDynamicObject();
                HashSet<String> ignoreFields = new HashSet<String>();
                ignoreFields.add("id");
                HRDynamicObjectUtils.copy((DynamicObject)effectDy, (DynamicObject)invalidedAppointRemoveRelDy, ignoreFields);
                invalidedAppointRemoveRelDy.set("dismisstype_id", requestMap.get("dismisstypeid"));
                invalidedAppointRemoveRelDy.set("appointtypestatus", (Object)"2");
                invalidedAppointRemoveRelDy.set("businessstatus", (Object)"2");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                if (requestMap.get("dismissdate") instanceof String && HRStringUtils.isNotEmpty((String)((String)requestMap.get("dismissdate")))) {
                    invalidedAppointRemoveRelDy.set("dismissdate", (Object)sdf.parse((String)requestMap.get("dismissdate")));
                } else if (requestMap.get("dismissdate") instanceof Date && Objects.nonNull(requestMap.get("dismissdate"))) {
                    invalidedAppointRemoveRelDy.set("dismissdate", requestMap.get("dismissdate"));
                }
                if (requestMap.get("dismissdispatchdate") instanceof String && HRStringUtils.isNotEmpty((String)((String)requestMap.get("dismissdispatchdate")))) {
                    invalidedAppointRemoveRelDy.set("dismissdispatchdate", (Object)sdf.parse((String)requestMap.get("dismissdispatchdate")));
                } else if (requestMap.get("dismissdispatchdate") instanceof Date && Objects.nonNull(requestMap.get("dismissdispatchdate"))) {
                    invalidedAppointRemoveRelDy.set("dismissdispatchdate", requestMap.get("dismissdispatchdate"));
                }
                if (requestMap.get("dismissdispatchnymber") instanceof String && HRStringUtils.isNotEmpty((String)((String)requestMap.get("dismissdispatchnymber")))) {
                    invalidedAppointRemoveRelDy.set("dismissdispatchnymber", requestMap.get("dismissdispatchnymber"));
                }
                invalidedAppointRemoveRelDy.set("bsed", (Object)new Date());
                invalidedAppointRemoveRelDy.set("initstatus", (Object)"2");
                DynamicObject newEffectAppointRemoveRelDy = hrBaseServiceHelper.generateEmptyDynamicObject();
                responseMap.put("boid", requestMap.get("newappointrecordid"));
                newEffectAppointRemoveRelDy.set("id", requestMap.get("newappointrecordid"));
                this.setAppointRemoveRelDyFields(newEffectAppointRemoveRelDy, requestMap);
                newEffectAppointRemoveRelDy.set("dismisstype", null);
                newEffectAppointRemoveRelDy.set("empposrel", effectDy.get("empposrel.id"));
                newEffectAppointRemoveRelDy.set("appointtypestatus", (Object)"1");
                newEffectAppointRemoveRelDy.set("dismissdate", null);
                newEffectAppointRemoveRelDy.set("dismissdispatchdate", null);
                newEffectAppointRemoveRelDy.set("dismissdispatchnymber", (Object)"");
                this.useHisVersionChange(new DynamicObject[]{invalidedAppointRemoveRelDy, newEffectAppointRemoveRelDy}, responseMap);
            }
        }
        catch (Exception exception) {
            LOGGER.error("insertOrUpdateAppointRemoveRel request occur exception : ", (Throwable)exception);
            responseMap.put("success", false);
            responseMap.put("message", exception.getMessage());
            return responseMap;
        }
        return responseMap;
    }

    private void setAppointRemoveRelDyFields(DynamicObject dy, Map<String, Object> requestMap) throws ParseException {
        dy.set("person", requestMap.get("personid"));
        dy.set("employee", requestMap.get("employeeid"));
        dy.set("adminorgvid", requestMap.get("adminorgvid"));
        dy.set("apositiontype", requestMap.get("apositiontype"));
        dy.set("positionvid", requestMap.get("positionvid"));
        dy.set("stdpositionvid", requestMap.get("stdpositionvid"));
        dy.set("jobvid", requestMap.get("jobvid"));
        dy.set("appointtype", requestMap.get("appointtypeid"));
        dy.set("dismisstype", requestMap.get("dismisstypeid"));
        dy.set("appointtypestatus", requestMap.get("appointtypestatus"));
        dy.set("empposrel", requestMap.get("empposorgrelid"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (requestMap.get("appointdate") instanceof String) {
            dy.set("appointdate", (Object)sdf.parse((String)requestMap.get("appointdate")));
        } else if (requestMap.get("appointdate") instanceof Date) {
            dy.set("appointdate", requestMap.get("appointdate"));
        }
        if (requestMap.get("dismissdate") instanceof String) {
            dy.set("dismissdate", (Object)sdf.parse((String)requestMap.get("dismissdate")));
        } else if (requestMap.get("dismissdate") instanceof Date) {
            dy.set("dismissdate", requestMap.get("dismissdate"));
        }
        if (requestMap.get("appointdispatchdate") instanceof String) {
            dy.set("appointdispatchdate", (Object)sdf.parse((String)requestMap.get("appointdispatchdate")));
        } else if (requestMap.get("appointdispatchdate") instanceof Date) {
            dy.set("appointdispatchdate", requestMap.get("appointdispatchdate"));
        }
        if (requestMap.get("dismissdispatchdate") instanceof String) {
            dy.set("dismissdispatchdate", (Object)sdf.parse((String)requestMap.get("dismissdispatchdate")));
        } else if (requestMap.get("dismissdispatchdate") instanceof Date) {
            dy.set("dismissdispatchdate", requestMap.get("dismissdispatchdate"));
        }
        dy.set("cadrecat", requestMap.get("cadrecatid"));
        dy.set("appointreason", requestMap.get("appointreason"));
        dy.set("isprimappoint", requestMap.get("isprimappoint"));
        dy.set("apptreasonggroup", requestMap.get("apptreasonggroupid"));
        dy.set("appointdispatchnymber", requestMap.get("appointdispatchnymber"));
        dy.set("dismissdispatchnymber", requestMap.get("dismissdispatchnymber"));
        dy.set("businessstatus", (Object)"1");
        dy.set("description", requestMap.get("description"));
        dy.set("bsed", (Object)new Date());
        dy.set("initstatus", (Object)"2");
    }

    private DynamicObject queryEffectAppointRemoveRelDy(Map<String, Object> requestMap) {
        Long appointRemoveRelBoid = (Long)requestMap.get("appointrecordid");
        QFilter boidFilter = new QFilter("boid", "=", (Object)appointRemoveRelBoid);
        QFilter isCurFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        return RepositoryUtil.getDynamicObject("hrpi_appointremoverel", new QFilter[]{boidFilter, isCurFilter, dataStatusFilter});
    }

    private void useHisVersionChange(DynamicObject[] dynamicObjects, Map<String, Object> responseMap) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEntityNumber("hrpi_appointremoverel");
        hisVersionParamBo.setEffImmediately(true);
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setHisDyns(dynamicObjects);
        HisResponse response = HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
        String code = response.getCode();
        if (HRStringUtils.equals((String)code, (String)EnumResponseCode.SUCCESS.getCode())) {
            responseMap.put("success", true);
        } else {
            responseMap.put("success", false);
            responseMap.put("message", response.getErrorMessage());
        }
    }

    private Map<Object, BigDecimal> executeAgeCalc(Map<String, Object> requestMap) {
        if ("socialWorkAge".equals(requestMap.get("queryResult"))) {
            return this.socialWorkAgeCalc(requestMap);
        }
        return this.companyWorkAgeCalc(requestMap);
    }

    private Map<Object, BigDecimal> companyWorkAgeCalc(Map<String, Object> requestMap) {
        Map<Object, Long> reqWithPersonIndexId;
        if ("employee".equals(requestMap.get("sign"))) {
            Map<Long, Long> empWithPersonId = Arrays.stream(HRPIEmployeeRepository.employeeServiceHelper.query("id,person", new QFilter[]{new QFilter("id", "in", requestMap.get("signList")), QFilterUtil.getInitStatusFinish()})).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("person_id")));
            Map<Long, Long> personIdWithPersonIndexId = Arrays.stream(HRPIPersonRepository.personServiceHelper.query("id,personindexid", new QFilter[]{new QFilter("id", "in", empWithPersonId.values()), QFilterUtil.getInitStatusFinish()})).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("personindexid")));
            reqWithPersonIndexId = empWithPersonId.keySet().stream().collect(Collectors.toMap(k -> k, k -> (Long)personIdWithPersonIndexId.get(empWithPersonId.get(k))));
        } else {
            reqWithPersonIndexId = Arrays.stream(HRPIPersonRepository.personServiceHelper.query("id,number,personindexid", this.getPersonFilters(requestMap))).collect(Collectors.toMap(dy -> {
                if ("person".equals(requestMap.get("sign"))) {
                    return dy.getLong("id");
                }
                return dy.getString("number");
            }, dy -> dy.getLong("personindexid"), (k1, k2) -> k1));
        }
        if (MapUtils.isEmpty(reqWithPersonIndexId)) {
            return Maps.newHashMap();
        }
        Map<Long, Long> personMap = Arrays.stream(HRPIPersonRepository.personServiceHelper.query("id,personindexid", new QFilter[]{new QFilter("personindexid", "in", reqWithPersonIndexId.values()), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()})).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("personindexid")));
        List<Map<String, Object>> empEntMaps = DynamicTransformUtil.dynamicListToMap(Arrays.asList(HRPIEmployeeRepository.empentrelServiceHelper.query("person,adjustlength,startdate,enddate,serviceagescheme", new QFilter[]{new QFilter("person", "in", personMap.keySet()), QFilterUtil.getDataStatusFilter(), QFilterUtil.getStatusFilters(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()})));
        empEntMaps.forEach(map -> map.put("personindexid", personMap.get(map.get("person_id"))));
        Map<Long, List<Map>> personIndexIdWithListMap = empEntMaps.stream().collect(Collectors.groupingBy(map -> (Long)map.get("personindexid")));
        HashMap resMap = Maps.newHashMapWithExpectedSize((int)((List)requestMap.get("signList")).size());
        ((List)requestMap.get("signList")).forEach(o -> resMap.put(o, this.doCalcCompanyWorkAge(DateUtil.getDate(requestMap.get("dateTime")), (List)personIndexIdWithListMap.get(reqWithPersonIndexId.get(o)))));
        return resMap;
    }

    private BigDecimal doCalcCompanyWorkAge(Date date, List<Map<String, Object>> dataMaps) {
        if (CollectionUtils.isEmpty(dataMaps)) {
            return null;
        }
        dataMaps.sort(EmployeeServiceImpl::compare);
        BigDecimal age = new BigDecimal(0);
        boolean timeMatchData = false;
        boolean ageContinue = false;
        for (Map<String, Object> dataMap : dataMaps) {
            BigDecimal years;
            if (date.before((Date)dataMap.get("startdate"))) continue;
            if (!date.before((Date)dataMap.get("startdate")) && date.before((Date)dataMap.get("enddate"))) {
                years = DateUtil.calcYearsDiff(date, (Date)dataMap.get("startdate"));
                age = age.add(years).add((BigDecimal)dataMap.get("adjustlength"));
                timeMatchData = true;
                if ("1".equals(dataMap.get("serviceagescheme")) || StringUtils.isEmpty((Object)dataMap.get("serviceagescheme"))) break;
                ageContinue = true;
                continue;
            }
            if (timeMatchData && !ageContinue || !((Date)dataMap.get("enddate")).before(date)) continue;
            years = DateUtil.calcYearsDiff((Date)dataMap.get("enddate"), (Date)dataMap.get("startdate"));
            age = age.add(years).add((BigDecimal)dataMap.get("adjustlength"));
            timeMatchData = true;
            if ("1".equals(dataMap.get("serviceagescheme")) || StringUtils.isEmpty((Object)dataMap.get("serviceagescheme"))) break;
            ageContinue = true;
        }
        return age;
    }

    private static int compare(Map<String, Object> map0, Map<String, Object> map1) {
        return ((Date)map0.get("startdate")).before((Date)map1.get("startdate")) ? 1 : -1;
    }

    private QFilter[] getPersonFilters(Map<String, Object> requestMap) {
        if ("empnumber".equals(requestMap.get("sign"))) {
            return new QFilter[]{new QFilter("number", "in", requestMap.get("signList")), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()};
        }
        return new QFilter[]{new QFilter("id", "in", requestMap.get("signList")), QFilterUtil.getInitStatusFinish()};
    }

    private Map<Object, BigDecimal> socialWorkAgeCalc(Map<String, Object> requestMap) {
        ArrayList<Long> employeeIds;
        Map<Long, Object> employeeIdWithReq = null;
        if (!"employee".equals(requestMap.get("sign"))) {
            employeeIdWithReq = this.getEmployeeIdWithReqMap(requestMap);
            employeeIds = new ArrayList<Long>(employeeIdWithReq.keySet());
        } else {
            employeeIds = (ArrayList<Long>)requestMap.get("signList");
        }
        if (CollectionUtils.isEmpty((Collection)employeeIds)) {
            return Maps.newHashMap();
        }
        Date dateReq = DateUtil.getDate(requestMap.get("dateTime"));
        Map<Object, BigDecimal> personIdWithSocialWorkAge = Arrays.stream(RepositoryUtil.getDynamicObjectCollection("person,joinworktime,adjustworktime,adjustworkage,employee", null, "hrpi_perserlen", new QFilter[]{new QFilter("employee", "in", employeeIds), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getStatusFilters(), QFilterUtil.getInitStatusFinish()}, null)).collect(Collectors.toMap(dy -> dy.getLong("employee_id"), dy -> this.doCalcSocialWorkAge(dateReq, (DynamicObject)dy)));
        if (null != employeeIdWithReq) {
            HashMap flushDataMap = Maps.newHashMapWithExpectedSize((int)employeeIdWithReq.size());
            Map<Long, Object> finalPersonIdWithReq = employeeIdWithReq;
            personIdWithSocialWorkAge.keySet().forEach(k -> {
                BigDecimal cfr_ignored_0 = (BigDecimal)flushDataMap.put(finalPersonIdWithReq.get(k), personIdWithSocialWorkAge.get(k));
            });
            return flushDataMap;
        }
        return personIdWithSocialWorkAge;
    }

    private Map<Long, Object> getEmployeeIdWithReqMap(Map<String, Object> requestMap) {
        QFilter qFilters = new QFilter((String)requestMap.get("sign"), "in", requestMap.get("signList")).and(QFilterUtil.getCurrentQf()).and(QFilterUtil.getDataStatusFilter()).and(QFilterUtil.getStatusFilters()).and(QFilterUtil.getInitStatusFinish());
        if ("person".equals(requestMap.get("sign"))) {
            qFilters.and(QFilterUtil.isLatestRecord());
        }
        Map tmpMap = Arrays.stream(RepositoryUtil.getDynamicObjectCollection("person,startdate,empnumber,employee,islatestrecord", null, "hrpi_empentrel", qFilters.toArray(), null)).collect(Collectors.toMap(dy -> dy.getLong("person_id"), Function.identity(), (empentrel1, empentrel2) -> {
            if (HRPIDynamicObjectUtil.booleanValueIsTrue((String)empentrel1.getString("islatestrecord"))) {
                if (HRPIDynamicObjectUtil.booleanValueIsTrue((String)empentrel2.getString("islatestrecord"))) {
                    Date startdate2;
                    Date startdate1 = empentrel1.getDate("startdate");
                    return HRDateTimeUtils.dayAfter((Date)startdate1, (Date)(startdate2 = empentrel2.getDate("startdate"))) ? empentrel1 : empentrel2;
                }
                return empentrel1;
            }
            return empentrel2;
        }));
        return tmpMap.values().stream().collect(Collectors.toMap(dy -> dy.getLong("employee_id"), dy -> dy.get("person".equals(requestMap.get("sign")) ? "person_id" : "empnumber")));
    }

    private BigDecimal doCalcSocialWorkAge(Date date, DynamicObject dynamicObject) {
        Date joinWorkTime = dynamicObject.getDate("joinworktime");
        if (null == joinWorkTime) {
            return new BigDecimal(0);
        }
        BigDecimal adjustWorkTime = dynamicObject.getBigDecimal("adjustworktime");
        BigDecimal years = DateUtil.calcYearsDiff(date, joinWorkTime);
        BigDecimal adjustWorkAge = dynamicObject.getBigDecimal("adjustworkage");
        if (null == adjustWorkAge) {
            adjustWorkAge = new BigDecimal(0);
        }
        return years.add(adjustWorkAge);
    }

    @Override
    @Deprecated
    public Map<String, Object> listPersonServiceLenByDateRange(Map<String, Object> requestMap) {
        LOGGER.info("listPersonServiceLenByDateRange start : {} ", requestMap);
        Map<String, Object> validatorMap = this.paramValidator(requestMap);
        if (validatorMap != null && !((Boolean)validatorMap.get("success")).booleanValue()) {
            return validatorMap;
        }
        List employeeIds = (List)requestMap.get("employeeids");
        Date startDate = (Date)requestMap.get("startdate");
        Date endDate = (Date)requestMap.get("enddate");
        BigDecimal precision = BigDecimal.valueOf((Double)requestMap.get("precision"));
        Map<Long, Map<String, Double>> empSocialWorkAgeMap = IHRPISerLenCalService.IHRPISERLENCALSERVICE.empSocialWorkAgeCal(employeeIds, startDate, endDate, precision);
        Map<Long, Long> empIdPerIdMap = this.getEmpIdPerIdMapByEmpIds(employeeIds);
        Map<Long, Long> perIdPIDMap = this.getPerIdPIDMapByPerIds(empIdPerIdMap.values());
        Map<Long, Long> empIdPIDMap = empIdPerIdMap.keySet().stream().collect(Collectors.toMap(k -> k, k -> (Long)perIdPIDMap.get(empIdPerIdMap.get(k))));
        Map<Long, Long> allPerIdPIDMap = this.getPerIdPIDMapByPIDs(perIdPIDMap.values());
        Map<Long, Map<String, Double>> empCompanyWorkAgeMap = IHRPISerLenCalService.IHRPISERLENCALSERVICE.empCompanyWorkAgeCal(employeeIds, startDate, endDate, precision, empIdPIDMap, allPerIdPIDMap);
        Map<Long, Map<String, Double>> empComSerCountAgeMap = IHRPISerLenCalService.IHRPISERLENCALSERVICE.empComSerCountCal(employeeIds, startDate, endDate, precision, empIdPIDMap, allPerIdPIDMap);
        LinkedHashMap resultMap = new LinkedHashMap(16);
        for (Long employeeId : employeeIds) {
            HashMap<String, Map<String, Double>> map = new HashMap<String, Map<String, Double>>(16);
            map.put("socialWork", empSocialWorkAgeMap.get(employeeId));
            map.put("companyWork", empCompanyWorkAgeMap.get(employeeId));
            map.put("comSerCount", empComSerCountAgeMap.get(employeeId));
            resultMap.put(employeeId, map);
        }
        return ResultBuilder.success(resultMap).get();
    }

    @Override
    public Map<String, Object> listPersonServiceLenByDateRangeNew(Map<String, Object> requestMap) {
        LOGGER.info("listPersonServiceLenByDateRangeNew start : {} ", requestMap);
        Map<String, Object> validatorMap = this.paramValidator(requestMap);
        if (validatorMap != null && !((Boolean)validatorMap.get("success")).booleanValue()) {
            return validatorMap;
        }
        List employeeIds = (List)requestMap.get("employeeids");
        Date startDate = (Date)requestMap.get("startdate");
        Date endDate = (Date)requestMap.get("enddate");
        BigDecimal precision = BigDecimal.valueOf((Double)requestMap.get("precision"));
        if (precision.compareTo(BigDecimal.valueOf(0.5)) != 0) {
            precision = new BigDecimal("1");
        }
        Map<Object, Object> empSocialWorkAgeMap = new HashMap(16);
        PersonSerLenDto personSerLenDto = new PersonSerLenDto(employeeIds, startDate, endDate, precision, empSocialWorkAgeMap);
        PersonSerLenExtUtil.empSocialWorkAgeCal((PersonSerLenDto)personSerLenDto);
        if (!personSerLenDto.isEnableExt()) {
            empSocialWorkAgeMap = IHRPISerLenCalService.IHRPISERLENCALSERVICENEW.empSocialWorkAgeCal(employeeIds, startDate, endDate, precision);
        }
        Map<Long, Long> empIdPerIdMap = this.getEmpIdPerIdMapByEmpIds(employeeIds);
        Map<Long, Long> perIdPIDMap = this.getPerIdPIDMapByPerIds(empIdPerIdMap.values());
        Map<Long, Long> empIdPIDMap = empIdPerIdMap.keySet().stream().collect(Collectors.toMap(k -> k, k -> (Long)perIdPIDMap.get(empIdPerIdMap.get(k))));
        Map<Long, Long> allPerIdPIDMap = this.getPerIdPIDMapByPIDs(perIdPIDMap.values());
        Map<Object, Object> empCompanyWorkAgeMap = new HashMap(16);
        PersonSerLenDto empCompanyWorkAgeDTO = new PersonSerLenDto(employeeIds, startDate, endDate, precision, empIdPIDMap, allPerIdPIDMap, empCompanyWorkAgeMap);
        PersonSerLenExtUtil.empCompanyWorkAgeCal((PersonSerLenDto)empCompanyWorkAgeDTO);
        if (!empCompanyWorkAgeDTO.isEnableExt()) {
            empCompanyWorkAgeMap = IHRPISerLenCalService.IHRPISERLENCALSERVICENEW.empCompanyWorkAgeCal(employeeIds, startDate, endDate, precision, empIdPIDMap, allPerIdPIDMap);
        }
        Map<Object, Object> empComSerCountAgeMap = new HashMap(16);
        PersonSerLenDto empComSerCountAgeDTO = new PersonSerLenDto(employeeIds, startDate, endDate, precision, empIdPIDMap, allPerIdPIDMap, empComSerCountAgeMap);
        PersonSerLenExtUtil.empComSerCountCal((PersonSerLenDto)empComSerCountAgeDTO);
        if (!empComSerCountAgeDTO.isEnableExt()) {
            empComSerCountAgeMap = IHRPISerLenCalService.IHRPISERLENCALSERVICENEW.empComSerCountCal(employeeIds, startDate, endDate, precision, empIdPIDMap, allPerIdPIDMap);
        }
        LinkedHashMap resultMap = new LinkedHashMap(16);
        for (Long employeeId : employeeIds) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("socialWork", empSocialWorkAgeMap.get(employeeId));
            map.put("companyWork", empCompanyWorkAgeMap.get(employeeId));
            map.put("comSerCount", empComSerCountAgeMap.get(employeeId));
            resultMap.put(employeeId, map);
        }
        return ResultBuilder.success(resultMap).get();
    }

    @Override
    public Map<String, Object> queryServiceLenNewCalcMethodEffectiveDate() {
        String effectivedate = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("effectivedate_new_calcservicelength");
        LOGGER.info("effectivedate_new_calcservicelength value: {} ", (Object)effectivedate);
        Date eDate = null;
        if (!StringUtils.isEmpty((Object)effectivedate)) {
            try {
                eDate = HRDateTimeUtils.parseDate((String)effectivedate, (String)"yyyy-MM-dd");
            }
            catch (Exception exception) {
                LOGGER.error("effectivedate:{} parseDate ex \uff1a ", (Object)effectivedate, (Object)exception);
                return ResultBuilder.failed("500", "effectivedate format exception").get();
            }
        }
        return ResultBuilder.success(eDate).get();
    }

    @Override
    public Map<String, Object> updateServiceLenNewCalcMethodEffectiveDate(Date effectDate) {
        if (effectDate == null) {
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), "date params must be required").get();
        }
        DynamicObject configObject = DevParamConfigRepository.loadConfigByBusinessKey("effectivedate_new_calcservicelength");
        if (configObject == null) {
            LOGGER.info("effectivedate_new_calcservicelength is empty");
            String msg = ResManager.loadKDString((String)"\u3010\u540e\u53f0\u914d\u7f6e\u9879\u7f16\u7801\u3011\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u66f4\u65b0\u751f\u6548\u65e5\u671f\u3002", (String)"EmployeeServiceImpl_10", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), msg).get();
        }
        String formatDateStr = HRDateTimeUtils.format((Date)effectDate, (String)"yyyy-MM-dd");
        configObject.set("businessvalue", (Object)formatDateStr);
        DevParamConfigRepository.updateDevParamConfig(new DynamicObject[]{configObject});
        LOGGER.info("effectivedate_new_calcservicelength update success,newValue:{}", (Object)formatDateStr);
        IHRAppCache ihrAppCache = HRAppCache.get((String)"hrpi:DevelopParamConfig");
        LOGGER.info("effectivedate_new_calcservicelength before_value:{}", ihrAppCache.get("effectivedate_new_calcservicelength", String.class));
        ihrAppCache.remove("effectivedate_new_calcservicelength");
        LOGGER.info("effectivedate_new_calcservicelength after_value:{}", ihrAppCache.get("effectivedate_new_calcservicelength", String.class));
        return ResultBuilder.success(null).get();
    }

    private Map<Long, Long> getEmpIdPerIdMapByEmpIds(Collection<Long> employeeIds) {
        Map<Long, Long> empIdPerIdMap = Arrays.stream(HRPIEmployeeRepository.employeeServiceHelper.query("id,person", new QFilter[]{new QFilter("id", "in", employeeIds), QFilterUtil.getInitStatusFinish()})).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("person_id")));
        return empIdPerIdMap;
    }

    private Map<Long, Long> getPerIdPIDMapByPerIds(Collection<Long> personIds) {
        Map<Long, Long> perIdPIDMap = Arrays.stream(HRPIPersonRepository.personServiceHelper.query("id,personindexid", new QFilter[]{new QFilter("id", "in", personIds), QFilterUtil.getInitStatusFinish()})).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("personindexid")));
        return perIdPIDMap;
    }

    private Map<Long, Long> getPerIdPIDMapByPIDs(Collection<Long> PIDs) {
        Map<Long, Long> perIdPIDMap = Arrays.stream(HRPIPersonRepository.personServiceHelper.query("id,personindexid", new QFilter[]{new QFilter("personindexid", "in", PIDs), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()})).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("personindexid")));
        return perIdPIDMap;
    }

    private Map<String, Object> paramValidator(Map<String, Object> requestMap) {
        HashSet errorSet = Sets.newHashSet();
        ValidateHelper validator = ValidateHelper.getInstance(errorSet);
        try {
            validator.validateReqMapNotNull().or(validator.validateMustInput("employeeids", "startdate", "enddate", "precision")).or(validator.validateArgType(ValidateHelper.isListType, "employeeids")).or(validator.validateArgType(ValidateHelper.isDateType, "startdate", "enddate")).or(validator.validateArgType(ValidateHelper.isDoubleType, "precision")).or(validator.validateListSize("signList", 10000)).test(requestMap);
            if (errorSet.size() > 0) {
                return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), JSONObject.toJSONString((Object)errorSet)).get();
            }
            Date startDate = (Date)requestMap.get("startdate");
            Date endDate = (Date)requestMap.get("enddate");
            if (startDate != null && endDate != null && HRDateTimeUtils.dayAfter((Date)startDate, (Date)endDate)) {
                String msg = ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"EmployeeServiceImpl_9", (String)"hrmp-hrpi-business", (Object[])new Object[0]);
                return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), msg).get();
            }
        }
        catch (Exception exception) {
            LOGGER.error("validate request param occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), String.format(ErrorCodeEnum.VALIDATE_FAILED.getInfo(), exception.getMessage(), JSONObject.toJSONString((Object)errorSet))).get();
        }
        return null;
    }

    @Override
    public Map<String, Object> listEmpJobRel(List<Long> employeeIds, QFilter customerFilter) {
        LOGGER.info("listEmpJobRel start : employeeIds: {} , customerFilter :{} ", employeeIds, (Object)customerFilter);
        try {
            Map<Long, List<Map>> empIdWithObjs = DynamicTransformUtil.dynamicListToMap(Arrays.asList(RepositoryUtil.getDynamicObjectCollection(Sets.newHashSet(), "hrpi_empjobrel", new QFilter[]{new QFilter("employee", "in", employeeIds), customerFilter}))).stream().collect(Collectors.groupingBy(map -> (Long)map.get("employee")));
            if (CollectionUtils.isEmpty(empIdWithObjs) || CollectionUtils.isEmpty(empIdWithObjs.values())) {
                return ResultBuilder.success(Collections.emptyMap()).addMsg("there is no data in the condition").get();
            }
            Set aFidIds = empIdWithObjs.values().stream().flatMap(Collection::stream).map(map -> (Long)map.get("boid")).collect(Collectors.toSet());
            DynamicObject[] chgRecordEntries = new HRBaseServiceHelper("hpfs_chgrecordentry").query("chgrecord,chgentity,idafter,chgmode,flowtype", new QFilter[]{new QFilter("chgentity", "=", (Object)"hrpi_empjobrel"), new QFilter("idafter", "in", aFidIds)});
            Map<Long, List<Map>> idAfterWithEntries = DynamicTransformUtil.dynamicListToMap(Arrays.asList(chgRecordEntries)).stream().collect(Collectors.groupingBy(map -> (Long)map.get("idafter")));
            Set chgRecordIds = idAfterWithEntries.values().stream().flatMap(Collection::stream).map(map -> (Long)map.get("chgrecord")).collect(Collectors.toSet());
            DynamicObject[] chgRecords = new HRBaseServiceHelper("hpfs_chgrecord").query("chgaction,chgcategory,chgrule,datastatus,billsource,billno,effecttime,bill", new QFilter[]{new QFilter("id", "in", chgRecordIds)});
            Map<Long, Map> idWithObjs = DynamicTransformUtil.dynamicListToMap(Arrays.asList(chgRecords)).stream().collect(Collectors.toMap(map -> (Long)map.get("id"), map -> map));
            idAfterWithEntries.values().stream().flatMap(Collection::stream).forEach(map -> map.putAll((Map)idWithObjs.get(map.get("chgrecord"))));
            empIdWithObjs.values().stream().flatMap(Collection::stream).forEach(map -> {
                List tempList = (List)idAfterWithEntries.get(map.get("boid"));
                Optional.ofNullable(tempList).ifPresent(list -> map.put("chgInfos", list));
            });
            return ResultBuilder.success(empIdWithObjs).get();
        }
        catch (Exception exception) {
            LOGGER.error("listEmpJobRel occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.PROCESS_ERROR.getCode(), exception.getMessage()).get();
        }
    }

    @Override
    public Map<String, Object> listEmpJobRel(List<Long> employeeIds) {
        return this.listEmpJobRel(employeeIds, QFilterUtil.getDataStatusFilter().and(QFilterUtil.getInitStatusFinish()).and(QFilterUtil.getCurrentQf()));
    }

    @Override
    public Map<String, Object> getEmpIdByEmpentrelNumbers(List<String> empentrelNumbers) {
        LOGGER.info("getEmpIdByEmpentrelNumbers start : empentrelNumbers: {}  ", empentrelNumbers);
        try {
            DynamicObject[] empEntrels;
            ArrayList result = new ArrayList(empentrelNumbers.size());
            for (DynamicObject empEntrel : empEntrels = HRPIEmpEntrelRepository.getInstance().listDynByNumbers(empentrelNumbers)) {
                HashMap<String, Object> empentrelNumberToEmpIdMap = new HashMap<String, Object>(16);
                empentrelNumberToEmpIdMap.put("empentrelNumber", empEntrel.getString("number"));
                empentrelNumberToEmpIdMap.put("employeeId", empEntrel.getLong("employee.id"));
                result.add(empentrelNumberToEmpIdMap);
            }
            return ResultBuilder.success(result).get();
        }
        catch (Exception exception) {
            LOGGER.error("getEmpIdByEmpentrelNumbers occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.PROCESS_ERROR.getCode(), exception.getMessage()).get();
        }
    }

    static {
        CHECK_FILEDS = new HashSet<String>(Arrays.asList("EMPNUMBER", "person", "employee"));
    }
}

