/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.business.domian.service.IHRPIOperationService;
import kd.hrmp.hrpi.business.domian.service.impl.SyncPersonToUserServiceImpl;

public class HRPIOperationServiceImpl
implements IHRPIOperationService {
    private static final Log LOGGER = LogFactory.getLog(HRPIOperationServiceImpl.class);
    private static volatile IHRPIOperationService HRPIOPERATIONSERVICE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IHRPIOperationService getInstance() {
        try {
            if (null != HRPIOPERATIONSERVICE) return HRPIOPERATIONSERVICE;
            Class<HRPIOperationServiceImpl> clazz = HRPIOperationServiceImpl.class;
            synchronized (HRPIOperationServiceImpl.class) {
                if (null != HRPIOPERATIONSERVICE) return HRPIOPERATIONSERVICE;
                try {
                    HRPIOPERATIONSERVICE = new HRPIOperationServiceImpl();
                    LOGGER.info("HRPIServiceFactory-dependency-check,new-HRPIOperationServiceImpl()-success");
                }
                catch (Throwable t) {
                    LOGGER.error("HRPIServiceFactory-dependency-check,new-HRPIOperationServiceImpl()-fail", t);
                }
                return HRPIOPERATIONSERVICE;
            }
        }
        catch (Throwable t) {
            LOGGER.error("HRPIServiceFactory-dependency-check,HRPIOperationServiceImpl-getInstance()-fail", t);
        }
        return HRPIOPERATIONSERVICE;
    }

    @Override
    public Map<String, Object> saveOrUpdateInfo(Map<String, DynamicObjectCollection> attachMap) {
        return this.doSaveOrUpdate(attachMap, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> doSaveOrUpdate(Map<String, DynamicObjectCollection> attachMap, boolean currnetBsed) {
        Map<String, Object> result;
        if (null == attachMap || attachMap.isEmpty()) {
            return HRPIOperationServiceImpl.getFail("param is empty.");
        }
        try (TXHandle txHandle = TX.required();){
            HisVersionParamListBo params = this.createParams(attachMap, currnetBsed);
            HisResponse response = HisModelController.getInstance().batchHisVersionChange(params);
            LOGGER.info("request success", (Object)((BatchVersionChangeRespData)response.getData()).getEventId());
            result = "200".equals(response.getCode()) ? HRPIOperationServiceImpl.getSuccess(this.successData((BatchVersionChangeRespData)response.getData())) : HRPIOperationServiceImpl.getFail(response.getErrorMessage());
        }
        return result;
    }

    private List<Map<String, Object>> successData(BatchVersionChangeRespData data) {
        List versionChangeRespDataList = data.getVersionChangeRespDataList();
        Long eventId = data.getEventId();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(versionChangeRespDataList.size());
        for (VersionChangeRespData versionChangeRespData : versionChangeRespDataList) {
            HashMap<String, Object> mapResult = new HashMap<String, Object>(16);
            Object[] newDynamicObjects = versionChangeRespData.getNewDynamicObjects();
            Long itemEventId = versionChangeRespData.getEventId();
            mapResult.put("eventid", itemEventId == null || itemEventId == 0L ? eventId : itemEventId);
            mapResult.put("entitynumber", versionChangeRespData.getEntityNumber());
            if (!HRArrayUtils.isEmpty((Object[])newDynamicObjects)) {
                mapResult.put("ids", Arrays.stream(newDynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
            }
            list.add(mapResult);
        }
        return list;
    }

    private HisVersionParamListBo createParams(Map<String, DynamicObjectCollection> attachMap, boolean currnetBsed) {
        HisVersionParamListBo listBo = new HisVersionParamListBo();
        listBo.setEffImmediately(Boolean.TRUE.booleanValue());
        listBo.setAtomicTrans(Boolean.TRUE.booleanValue());
        ArrayList<HisVersionParamBo> paramBoList = new ArrayList<HisVersionParamBo>(attachMap.size());
        listBo.setListHisVersionParamBo(paramBoList);
        return this.handleData(attachMap, listBo, paramBoList, currnetBsed);
    }

    private HisVersionParamListBo handleData(Map<String, DynamicObjectCollection> attachMap, HisVersionParamListBo listBo, List<HisVersionParamBo> paramBoList, boolean currnetBsed) {
        for (Map.Entry<String, DynamicObjectCollection> dyInfo : attachMap.entrySet()) {
            HisVersionParamBo paramBo = new HisVersionParamBo();
            String entityName = dyInfo.getKey();
            DynamicObjectCollection dyCollection = dyInfo.getValue();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            IDataEntityProperty effectiveProp = dataEntityType.findProperty("bsed");
            long[] pkIds = new ORMImpl().genLongIds(entityName, dyCollection.size());
            for (int i = 0; i < dyCollection.size(); ++i) {
                DynamicObject dyCol = (DynamicObject)dyCollection.get(i);
                if (dyCol.getLong("boid") > 0L || dyCol.getLong("id") == 0L) {
                    dyCol.set("id", (Object)pkIds[i]);
                    if (effectiveProp != null) {
                        dyCol.set("createtime", null);
                    }
                }
                if (!currnetBsed || null == effectiveProp) continue;
                if ("hrpi_empjobrel".equals(entityName)) {
                    if (dyCol.getLong("boid") > 0L) {
                        dyCol.set("bsed", (Object)new Date());
                        continue;
                    }
                    dyCol.set("bsed", dyCol.get("startdate"));
                    continue;
                }
                dyCollection.forEach(dy -> dy.set("bsed", (Object)new Date()));
            }
            this.setMainBo(listBo, entityName, pkIds);
            paramBo.setEntityNumber(entityName);
            paramBo.setHisDyns((DynamicObject[])dyCollection.toArray((Object[])new DynamicObject[0]));
            paramBoList.add(paramBo);
        }
        listBo.setListHisVersionParamBo(paramBoList);
        return listBo;
    }

    private void setMainBo(HisVersionParamListBo listBo, String entityName, long[] pkIds) {
        if (null == listBo.getMainBoId() && HRStringUtils.isEmpty((String)listBo.getMainEntityNumber())) {
            listBo.setMainBoId(Long.valueOf(pkIds[0]));
            listBo.setMainEntityNumber(entityName);
        }
    }

    @Override
    public Map<String, Object> deleteInfo(List<Long> attachIds, String attachName, Boolean isDelBo) {
        Map<String, Object> result;
        if (null == attachIds || attachIds.isEmpty() || HRStringUtils.isEmpty((String)attachName)) {
            return HRPIOperationServiceImpl.getFail("param is empty.");
        }
        try (TXHandle required = TX.required();){
            try {
                Map<Object, DynamicObject> entityCfMap = HRPIOperationServiceImpl.getPersonEntityConf(attachName);
                result = CollectionUtils.isEmpty(entityCfMap) ? HRPIOperationServiceImpl.getFail("entityname does not exits.") : HRPIOperationServiceImpl.getSuccess(HRPIPersonRepository.delPersonAttachs(attachIds, attachName, isDelBo == null || isDelBo != false ? Boolean.TRUE : Boolean.FALSE));
            }
            catch (Exception e) {
                LOGGER.error("deleteInfo error", (Throwable)e);
                required.markRollback();
                result = HRPIOperationServiceImpl.getFail("delete error.");
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> syncPersonToSysUer(List<Map<String, Object>> userList) {
        return this.diffTypeSyncPersonToSysUer(userList, "0");
    }

    @Override
    public Map<String, Object> syncHRPersonToSysUser(List<Map<String, Object>> syncUserList) {
        return SyncPersonToUserServiceImpl.getInstance().syncHRPersonToSysUser(syncUserList);
    }

    @Override
    public Map<String, Object> diffTypeSyncPersonToSysUer(List<Map<String, Object>> userList, String taskType) {
        long startTime = System.currentTimeMillis();
        LOGGER.warn("syncPersonToSysUerParam:{},oneIsTaskShowThisType:{}", userList, (Object)taskType);
        Map<String, Object> resultMap = HRPIOperationServiceImpl.getSuccess(null);
        if (userList == null || userList.size() == 0) {
            return HRPIOperationServiceImpl.getFail("params is empty.");
        }
        try {
            Map<String, List<Map<String, Object>>> groupMap = SyncPersonToUserServiceImpl.getInstance().groupParamListMap(userList, new HashMap<String, String>(16));
            if (groupMap.size() == 0) {
                return HRPIOperationServiceImpl.getFail("check finish data is empty.");
            }
            block32: for (Map.Entry<String, List<Map<String, Object>>> tempMap : groupMap.entrySet()) {
                HashMap<String, String> errorMap = new HashMap<String, String>(16);
                String syncType = tempMap.getKey();
                if (HRStringUtils.isNotEmpty((String)syncType)) {
                    syncType = syncType.toLowerCase(Locale.ENGLISH);
                }
                List<Map<String, Object>> tempUserList = tempMap.getValue();
                switch (syncType) {
                    case "join": 
                    case "transfer": 
                    case "parttime": 
                    case "parttimeend": 
                    case "update": 
                    case "openapi": 
                    case "add": 
                    case "chgupdate": 
                    case "directorupdate": 
                    case "disableupdate": 
                    case "useraddnew": 
                    case "userupdate": 
                    case "back_update": {
                        Map<String, Object> temMap = SyncPersonToUserServiceImpl.getInstance().handleJoinPerson(tempUserList, "0", syncType, errorMap);
                        this.handleLogAndRetInfo(tempUserList, taskType, resultMap, temMap);
                        continue block32;
                    }
                    case "quit": 
                    case "disable": 
                    case "userdisable": 
                    case "personuserreldisable": {
                        Map<String, Object> temMap = SyncPersonToUserServiceImpl.getInstance().handleQuitPerson(tempUserList, "0", "0", syncType, errorMap);
                        this.handleLogAndRetInfo(tempUserList, taskType, resultMap, temMap);
                        continue block32;
                    }
                    case "back_quit": 
                    case "back_join": {
                        Map<String, Object> temMap = SyncPersonToUserServiceImpl.getInstance().handleBackPerson(tempUserList, syncType, errorMap);
                        this.handleLogAndRetInfo(tempUserList, taskType, resultMap, temMap);
                        continue block32;
                    }
                    case "enble_bos_user": {
                        Map<String, Object> temMap = SyncPersonToUserServiceImpl.getInstance().handleDisEnablePerson("1", tempUserList, syncType, errorMap);
                        this.handleLogAndRetInfo(tempUserList, taskType, resultMap, temMap);
                        continue block32;
                    }
                    case "disble_bos_user": {
                        Map<String, Object> temMap = SyncPersonToUserServiceImpl.getInstance().handleDisEnablePerson("0", tempUserList, syncType, errorMap);
                        this.handleLogAndRetInfo(tempUserList, taskType, resultMap, temMap);
                        continue block32;
                    }
                }
                HashMap<String, Object> tMap = new HashMap<String, Object>(10);
                tMap.put("data", "not support type");
                tMap.put("success", false);
                this.handleLogAndRetInfo(tempUserList, taskType, resultMap, tMap);
            }
        }
        catch (Exception eex) {
            LOGGER.error("syncPersonToSysUerError", (Throwable)eex);
            Map<String, Object> fail = HRPIOperationServiceImpl.getFail("syncPersonToSysUer error.");
            SyncPersonToUserServiceImpl.getInstance().recordLog(userList, fail, eex, "0", "0", taskType);
            return fail;
        }
        LOGGER.warn(MessageFormat.format("syncPersonToSysUerAllTime:{0},useTime:{1}", taskType, TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime)));
        return resultMap;
    }

    private void handleLogAndRetInfo(List<Map<String, Object>> userList, String taskType, Map<String, Object> resultMap, Map<String, Object> temMap) {
        if ("2".equals(taskType)) {
            return;
        }
        String status = "0";
        if (((Boolean)temMap.get("success")).booleanValue()) {
            status = "1";
            if (((Boolean)resultMap.get("success")).booleanValue()) {
                resultMap.put("success", true);
            }
        } else {
            resultMap.put("success", false);
            resultMap.put("message", "has not success data");
            Object totalData = resultMap.get("data");
            if (temMap.containsKey("data")) {
                Object temData = temMap.get("data");
                if (Objects.isNull(totalData)) {
                    resultMap.put("data", temData);
                } else if (temData instanceof Map) {
                    if (totalData instanceof Map) {
                        Map totalMap = (Map)totalData;
                        totalMap.putAll((Map)temData);
                        resultMap.put("data", totalMap);
                    }
                } else {
                    resultMap.put("data", temMap);
                }
            }
        }
        SyncPersonToUserServiceImpl.getInstance().recordLog(userList, temMap, null, "0", status, taskType);
    }

    @Override
    public Map<String, Object> updateLaborRelRecord(List<Map<String, Object>> updateList) {
        try {
            Map<String, Object> retMap = this.doUpdateLaborRelRecord(updateList, false);
            LOGGER.info(MessageFormat.format("doUpdateLaborRelRecordResult:{0}", retMap));
            return retMap;
        }
        catch (Exception esc) {
            LOGGER.error((Throwable)esc);
            return HRPIOperationServiceImpl.getFail("invoke fail.");
        }
    }

    @Override
    public Map<String, Object> doUpdateLaborRelRecord(List<Map<String, Object>> updateList, boolean quitType) throws ParseException {
        Object[] labRelRecordByPersonIds;
        LOGGER.info(MessageFormat.format("doUpdateLaborRelRecordStart:{0}", updateList));
        HashMap<Long, String> errorMap = new HashMap<Long, String>(16);
        if (CollectionUtils.isEmpty(updateList)) {
            return HRPIOperationServiceImpl.getFail("param is empty");
        }
        Set<Long> personIds = updateList.stream().map(tempMap -> (Long)tempMap.get("personid")).collect(Collectors.toSet());
        Set<Long> orgIds = updateList.stream().map(tempMap -> (Long)tempMap.get("orgid")).collect(Collectors.toSet());
        if (quitType) {
            orgIds = null;
        }
        if (HRArrayUtils.isEmpty((Object[])(labRelRecordByPersonIds = HRPIEmployeeRepository.getLabRelRecordByPersonIds(personIds, orgIds)))) {
            return HRPIOperationServiceImpl.getFail("query data is empty");
        }
        Map<String, DynamicObject> dbRecordMap = Arrays.stream(labRelRecordByPersonIds).collect(Collectors.toMap(this::proKey, tmp -> tmp, (v1, v2) -> v1));
        List<Map<String, Object>> validateSuccessList = this.validateInfo(updateList, errorMap, dbRecordMap, quitType);
        if (CollectionUtils.isEmpty(validateSuccessList)) {
            return HRPIOperationServiceImpl.getResult(false, "validate error", errorMap);
        }
        return this.doUpdateRecord((DynamicObject[])labRelRecordByPersonIds, validateSuccessList, errorMap, quitType);
    }

    private Map<String, Object> doUpdateRecord(DynamicObject[] labRelRecordByPersonIds, List<Map<String, Object>> validateSuccessList, Map<Long, String> errorMap, boolean quitType) throws ParseException {
        Map<String, Map<String, Object>> paramMap = validateSuccessList.stream().collect(Collectors.toMap(tmp -> tmp.get("personid") + "-" + tmp.get("orgid"), tmp -> tmp, (v1, v2) -> v1));
        HashMap<String, DynamicObjectCollection> saveMap = new HashMap<String, DynamicObjectCollection>(labRelRecordByPersonIds.length);
        HRBaseServiceHelper labServiceHelper = new HRBaseServiceHelper("hrpi_laborrelrecord");
        DynamicObjectCollection oldDys = new DynamicObjectCollection();
        for (DynamicObject oldDy : labRelRecordByPersonIds) {
            String key = this.proKey(oldDy);
            DynamicObject emptyDy = labServiceHelper.generateEmptyDynamicObject();
            if (!quitType) {
                this.createHisRecord(paramMap, oldDy, key, emptyDy);
            } else {
                Map tmpParamMap = paramMap.get(key);
                Date valueDate = (Date)tmpParamMap.get("startdate");
                Date endDbDate = oldDy.getDate("enddate");
                if (HRDateTimeUtils.dayEquals((Date)endDbDate, (Date)valueDate)) {
                    LOGGER.info("labordatequals");
                    continue;
                }
                HRDynamicObjectUtils.copy((DynamicObject)oldDy, (DynamicObject)emptyDy);
                emptyDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
                emptyDy.set("modifytime", (Object)new Date());
                emptyDy.set("bsed", (Object)valueDate);
                emptyDy.set("enddate", (Object)HRDateTimeUtils.addDay((Date)valueDate, (long)-1L));
                emptyDy.set("sysenddate", (Object)valueDate);
            }
            if (emptyDy.getDataEntityType().getProperties().containsKey((Object)"initstatus")) {
                emptyDy.set("initstatus", (Object)"2");
            }
            oldDys.add((Object)emptyDy);
        }
        if (!CollectionUtils.isEmpty((Collection)oldDys)) {
            saveMap.put("hrpi_laborrelrecord", oldDys);
            Map<String, Object> retMap = this.doSaveOrUpdate(saveMap, false);
            if (((Boolean)retMap.get("success")).booleanValue()) {
                if (errorMap.size() > 0) {
                    return HRPIOperationServiceImpl.getResult(false, "validate error", errorMap);
                }
            } else {
                return HRPIOperationServiceImpl.getResult(false, "invoke error", errorMap);
            }
        }
        return HRPIOperationServiceImpl.getSuccess(null);
    }

    private void createHisRecord(Map<String, Map<String, Object>> paramMap, DynamicObject oldDy, String key, DynamicObject emptyDy) {
        HashSet<String> ignoreSet = new HashSet<String>(16);
        ignoreSet.add("lawentity");
        ignoreSet.add("description");
        HRDynamicObjectUtils.copy((DynamicObject)oldDy, (DynamicObject)emptyDy, ignoreSet);
        Map<String, Object> tmpParamMap = paramMap.get(key);
        if (HRMapUtils.isEmpty(tmpParamMap)) {
            LOGGER.info("createHisRecordFindNull->{}", (Object)key);
            return;
        }
        Long lawEntityId = (Long)tmpParamMap.get("lawentityid");
        Date valueDate = (Date)tmpParamMap.get("startdate");
        emptyDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        emptyDy.set("modifytime", (Object)new Date());
        emptyDy.set("bsed", (Object)valueDate);
        emptyDy.set("lawentity", (Object)lawEntityId);
        if (lawEntityId == null || lawEntityId == 0L) {
            HRBaseServiceHelper lawService = new HRBaseServiceHelper("hbss_lawentity");
            DynamicObject dynamicObject = lawService.generateEmptyDynamicObject();
            emptyDy.set("lawentity", (Object)dynamicObject);
        }
        String desc = (String)tmpParamMap.get("description");
        emptyDy.set("description", (Object)desc);
        emptyDy.set("boid", (Object)oldDy.getLong("boid"));
    }

    private String proKey(DynamicObject dy) {
        return dy.get("person.id") + "-" + dy.get("org.id");
    }

    private List<Map<String, Object>> validateInfo(List<Map<String, Object>> updateList, Map<Long, String> errorMap, Map<String, DynamicObject> recordMap, boolean quitType) {
        ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>(updateList.size());
        for (Map<String, Object> updateMap : updateList) {
            StringBuilder errorBuilder = new StringBuilder();
            if (updateMap == null || updateMap.size() == 0) continue;
            Long personId = (Long)updateMap.get("personid");
            Long orgId = (Long)updateMap.get("orgid");
            Long lawEntityId = (Long)updateMap.get("lawentityid");
            Date startDate = (Date)updateMap.get("startdate");
            DynamicObject dbLawEntityDy = recordMap.get(personId + "-" + orgId);
            if (personId == null || personId == 0L) {
                errorBuilder.append("personId is empty");
            }
            if (orgId == null || orgId == 0L) {
                errorBuilder.append("orgId is empty");
            }
            if (dbLawEntityDy == null) {
                errorBuilder.append("laborrelrecord not exist");
            }
            if (!quitType && dbLawEntityDy != null && lawEntityId != null && lawEntityId.equals(dbLawEntityDy.getLong("lawentity.id"))) {
                errorBuilder.append("laborrelrecord exist need not update");
            }
            if (startDate == null) {
                errorBuilder.append("startdate is empty");
            }
            if (HRStringUtils.isEmpty((String)errorBuilder.toString())) {
                successList.add(updateMap);
                continue;
            }
            errorMap.put(personId, errorBuilder.toString());
        }
        return successList;
    }

    public static Map<String, Object> getFail(String message) {
        return HRPIOperationServiceImpl.getResult(false, message, null);
    }

    public static Map<String, Object> getSuccess(Object data) {
        return HRPIOperationServiceImpl.getResult(true, null, data);
    }

    public static Map<String, Object> getResult(boolean flag, String message, Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", flag);
        result.put("message", message);
        if (null != data) {
            result.put("data", data);
        }
        return result;
    }

    public static Map<Object, DynamicObject> getPersonEntityConf(String attachName) {
        QFilter entityFilter = new QFilter("entity", "=", (Object)attachName);
        entityFilter.and(new QFilter("classify", "=", (Object)"perattached"));
        return BusinessDataServiceHelper.loadFromCache((String)"hrpi_personentityconf", (String)"classify", (QFilter[])new QFilter[]{entityFilter});
    }
}

