/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRPerserlenHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.RepositoryUtil;
import kd.hrmp.hrpi.business.domian.service.IHRPISerLenCalService;
import kd.hrmp.hrpi.business.infrastructure.utils.BusinessDataUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;

@Deprecated
public class HRPISerLenCalServiceImpl
implements IHRPISerLenCalService {
    private static final Log LOGGER = LogFactory.getLog(HRPISerLenCalServiceImpl.class);

    @Override
    @Deprecated
    public Map<Long, Map<String, Double>> empSocialWorkAgeCal(List<Long> employeeIds, Date startDate, Date endDate, BigDecimal precision) {
        DynamicObject[] perSerLenDyns;
        HashMap<Long, Map<String, Double>> empSocialWorkAgeMap = new HashMap<Long, Map<String, Double>>(16);
        for (DynamicObject perSerLenDyn : perSerLenDyns = RepositoryUtil.getDynamicObjectCollection("employee,joinworktime,adjustworkage", null, "hrpi_perserlen", new QFilter[]{new QFilter("employee", "in", employeeIds), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getStatusFilters(), QFilterUtil.getInitStatusFinish()}, null)) {
            long employeeId = perSerLenDyn.getDynamicObject("employee").getLong("id");
            Date joinWorkTime = perSerLenDyn.getDate("joinworktime");
            if (HRObjectUtils.isEmpty((Object)joinWorkTime)) continue;
            BigDecimal adjustWorkAge = perSerLenDyn.getBigDecimal("adjustworkage");
            if (adjustWorkAge == null) {
                adjustWorkAge = BigDecimal.ZERO;
            }
            Map<String, Double> socialWorkAgeMap = new LinkedHashMap<String, Double>(16);
            if (startDate.compareTo(joinWorkTime) < 0) {
                if (endDate.compareTo(joinWorkTime) > 0) {
                    this.setDateRangeInMap(startDate, HRDateTimeUtils.addDay((Date)joinWorkTime, (long)-1L), socialWorkAgeMap, BigDecimal.ZERO);
                    socialWorkAgeMap.putAll(this.getSplitDateMap(joinWorkTime, endDate, joinWorkTime, adjustWorkAge, precision));
                } else {
                    this.setDateRangeInMap(startDate, endDate, socialWorkAgeMap, BigDecimal.ZERO);
                }
            } else {
                socialWorkAgeMap = this.getSplitDateMap(startDate, endDate, joinWorkTime, adjustWorkAge, precision);
            }
            empSocialWorkAgeMap.put(employeeId, this.mergeSameSerLenHandle(socialWorkAgeMap));
        }
        return empSocialWorkAgeMap;
    }

    private Map<String, Double> mergeSameSerLenHandle(Map<String, Double> serlenMap) {
        LinkedHashMap<String, Double> resultMap = new LinkedHashMap<String, Double>();
        Object[] serlenMapEntryArray = serlenMap.entrySet().toArray();
        block0: for (int i = 0; i < serlenMapEntryArray.length; ++i) {
            Map.Entry entry = (Map.Entry)serlenMapEntryArray[i];
            if (i == serlenMapEntryArray.length - 1) {
                resultMap.put((String)entry.getKey(), (Double)entry.getValue());
            }
            int j = 1;
            while (i + j < serlenMapEntryArray.length) {
                String newKey;
                Map.Entry lastEntry;
                Map.Entry notSameEntry = (Map.Entry)serlenMapEntryArray[i + j];
                if (entry.getValue() != null && !((Double)entry.getValue()).equals(notSameEntry.getValue())) {
                    lastEntry = (Map.Entry)serlenMapEntryArray[i + j - 1];
                    newKey = ((String)entry.getKey()).split("~")[0] + "~" + ((String)lastEntry.getKey()).split("~")[1];
                    resultMap.put(newKey, (Double)entry.getValue());
                    i = i + j - 1;
                    continue block0;
                }
                if (entry.getValue() != null && ((Double)entry.getValue()).equals(notSameEntry.getValue()) && i + j == serlenMapEntryArray.length - 1) {
                    lastEntry = (Map.Entry)serlenMapEntryArray[i + j];
                    newKey = ((String)entry.getKey()).split("~")[0] + "~" + ((String)lastEntry.getKey()).split("~")[1];
                    resultMap.put(newKey, (Double)entry.getValue());
                    i += j;
                    continue block0;
                }
                ++j;
            }
        }
        return resultMap;
    }

    private Map<String, Double> getSplitDateMap(Date startDate, Date endDate, Date joinWorkTime, BigDecimal adjustTime, BigDecimal precision) {
        BigDecimal minWorkYear = BusinessDataUtil.getWorkYear(startDate, joinWorkTime, adjustTime);
        BigDecimal maxWorkYear = BusinessDataUtil.getWorkYear(endDate, joinWorkTime, adjustTime);
        return this.continuousSocialWorkSerLenHandle(joinWorkTime, adjustTime, startDate, endDate, minWorkYear, maxWorkYear, precision);
    }

    @Override
    public Map<Long, Map<String, Double>> empCompanyWorkAgeCal(List<Long> employeeIds, Date startDate, Date endDate, BigDecimal precision, Map<Long, Long> empIdPIDMap, Map<Long, Long> allPerIdPIDMap) {
        Map<Long, List<DynamicObject>> pIDEmpEntRelsMap = this.getPIDEmpEntRelsMap(allPerIdPIDMap);
        Map<Long, Map<String, Double>> empCompanyWorkAgeMap = new LinkedHashMap<Long, Map<String, Double>>(16);
        if (pIDEmpEntRelsMap.size() > 0) {
            Map<Long, List<DynamicObject>> empEmpEntRelsMap = empIdPIDMap.entrySet().stream().collect(Collectors.toMap(entry -> (Long)entry.getKey(), entry -> pIDEmpEntRelsMap.get(entry.getValue()) != null ? (List)pIDEmpEntRelsMap.get(entry.getValue()) : new ArrayList(10)));
            empCompanyWorkAgeMap = this.doEmpCompanyWorkAgeCal(empEmpEntRelsMap, startDate, endDate, precision);
        }
        return empCompanyWorkAgeMap;
    }

    private Map<Long, List<DynamicObject>> getPIDEmpEntRelsMap(Map<Long, Long> allPerIdPIDMap) {
        Map<Long, List<DynamicObject>> perIdEmpEntRelMap = Arrays.stream(HRPIEmployeeRepository.empentrelServiceHelper.query("person,adjustlength,startdate,enddate,serviceagescheme", new QFilter[]{new QFilter("person", "in", allPerIdPIDMap.keySet()), QFilterUtil.getDataStatusFilter(), QFilterUtil.getStatusFilters(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()})).collect(Collectors.groupingBy(dy -> dy.getDynamicObject("person").getLong("id")));
        return this.getPIDDynListMap(allPerIdPIDMap, perIdEmpEntRelMap);
    }

    private Map<Long, Map<String, Double>> doEmpCompanyWorkAgeCal(Map<Long, List<DynamicObject>> empEmpEntRelsMap, Date startDate, Date endDate, BigDecimal precision) {
        HashMap<Long, Map<String, Double>> empCompanyWorkAgeMap = new HashMap<Long, Map<String, Double>>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : empEmpEntRelsMap.entrySet()) {
            BigDecimal len;
            Long employeeId = entry.getKey();
            List<DynamicObject> empEntRels = entry.getValue();
            empEntRels.sort(Comparator.comparing(o -> o.getDate("startdate")));
            ArrayList<Date> allDate = new ArrayList<Date>();
            LinkedHashMap<Date, DynamicObject> dateDynMap = new LinkedHashMap<Date, DynamicObject>();
            this.listAllDate(startDate, endDate, empEntRels, allDate, dateDynMap);
            List<Map<String, Object>> empEntRelMapList = DynamicTransformUtil.dynamicListToMap(empEntRels);
            LinkedHashMap<String, Double> serlenMap = new LinkedHashMap<String, Double>();
            BigDecimal startDateCompanyWorkAge = this.doCalcCompanyWorkAge(startDate, empEntRelMapList);
            BigDecimal endDateCompanyWorkAge = this.doCalcCompanyWorkAge(endDate, empEntRelMapList);
            if (allDate.size() == 2) {
                serlenMap.putAll(this.continuousCompanyWorkAge(startDate, endDate, precision, empEntRelMapList));
            } else if (allDate.size() == 3) {
                Date middleDate = (Date)allDate.get(1);
                DynamicObject empEntRelObj = (DynamicObject)dateDynMap.get(middleDate);
                Date empEntRelObjStartDate = empEntRelObj.getDate("startdate");
                Date empEntRelObjEndDate = empEntRelObj.getDate("enddate");
                if (startDate.compareTo(empEntRelObjStartDate) > 0 && startDate.compareTo(empEntRelObjEndDate) <= 0) {
                    serlenMap.putAll(this.continuousCompanyWorkAge(startDate, this.getEndDate(startDate, middleDate), precision, empEntRelMapList));
                    len = this.doCalcCompanyWorkAge(middleDate, empEntRelMapList).divide(precision, 0, RoundingMode.DOWN).multiply(precision);
                    this.setDateRangeInMap(middleDate, endDate, serlenMap, len);
                } else {
                    len = startDateCompanyWorkAge.divide(precision, 0, RoundingMode.DOWN).multiply(precision);
                    this.setDateRangeInMap(startDate, this.getEndDate(startDate, middleDate), serlenMap, len);
                    serlenMap.putAll(this.continuousCompanyWorkAge(middleDate, endDate, precision, empEntRelMapList));
                }
            } else {
                for (int i = 1; i < allDate.size(); ++i) {
                    Date date = (Date)allDate.get(i);
                    Date preDate = (Date)allDate.get(i - 1);
                    if (dateDynMap.get(preDate) == null) {
                        Date nextDate = (Date)allDate.get(i + 1);
                        if (((DynamicObject)dateDynMap.get(date)).equals(dateDynMap.get(nextDate))) {
                            len = startDateCompanyWorkAge.divide(precision, 0, RoundingMode.DOWN).multiply(precision);
                            this.setDateRangeInMap(startDate, this.getEndDate(startDate, date), serlenMap, len);
                            continue;
                        }
                        serlenMap.putAll(this.continuousCompanyWorkAge(startDate, this.getEndDate(startDate, date), precision, empEntRelMapList));
                        continue;
                    }
                    if (dateDynMap.get(date) == null) {
                        Date prePreDate = (Date)allDate.get(i - 2);
                        if (((DynamicObject)dateDynMap.get(preDate)).equals(dateDynMap.get(prePreDate))) {
                            len = endDateCompanyWorkAge.divide(precision, 0, RoundingMode.DOWN).multiply(precision);
                            this.setDateRangeInMap(preDate, endDate, serlenMap, len);
                            continue;
                        }
                        serlenMap.putAll(this.continuousCompanyWorkAge(preDate, endDate, precision, empEntRelMapList));
                        continue;
                    }
                    if (((DynamicObject)dateDynMap.get(date)).equals(dateDynMap.get(preDate))) {
                        serlenMap.putAll(this.continuousCompanyWorkAge(preDate, this.getEndDate(preDate, date), precision, empEntRelMapList));
                        continue;
                    }
                    BigDecimal len2 = this.doCalcCompanyWorkAge(preDate, empEntRelMapList).divide(precision, 0, RoundingMode.DOWN).multiply(precision);
                    this.setDateRangeInMap(preDate, this.getEndDate(preDate, date), serlenMap, len2);
                }
            }
            empCompanyWorkAgeMap.put(employeeId, this.mergeSameSerLenHandle(serlenMap));
        }
        return empCompanyWorkAgeMap;
    }

    private Date getEndDate(Date startDate, Date endDate) {
        if (startDate != null && startDate.equals(endDate)) {
            return endDate;
        }
        return HRDateTimeUtils.addDay((Date)endDate, (long)-1L);
    }

    private void listAllDate(Date startDate, Date endDate, List<DynamicObject> dyns, List<Date> allDate, Map<Date, DynamicObject> dateDynMap) {
        allDate.add(startDate);
        for (int i = 0; i < dyns.size(); ++i) {
            DynamicObject dyn = dyns.get(i);
            Date dynStartDate = dyn.getDate("startdate");
            Date dynEndDate = dyn.getDate("enddate");
            if (dynStartDate.compareTo(startDate) >= 0 && dynStartDate.compareTo(endDate) <= 0) {
                dateDynMap.put(dynStartDate, dyn);
                allDate.add(dynStartDate);
            }
            if (dynEndDate.compareTo(startDate) < 0 || dynEndDate.compareTo(endDate) > 0) continue;
            dateDynMap.put(dynEndDate, dyn);
            allDate.add(dynEndDate);
        }
        allDate.add(endDate);
    }

    private Map<String, Double> continuousCompanyWorkAge(Date startDate, Date endDate, BigDecimal precision, List<Map<String, Object>> empEntRelMapList) {
        BigDecimal minWorkYear = this.doCalcCompanyWorkAge(startDate, empEntRelMapList);
        BigDecimal maxWorkYear = this.doCalcCompanyWorkAge(endDate, empEntRelMapList);
        Map<String, Double> serlenMap = this.continuousSerLenHandle(startDate, endDate, minWorkYear, maxWorkYear, precision);
        return serlenMap;
    }

    private BigDecimal doCalcCompanyWorkAge(Date date, List<Map<String, Object>> dataMaps) {
        dataMaps.sort(HRPISerLenCalServiceImpl::compare);
        BigDecimal age = new BigDecimal(0);
        boolean timeMatchData = false;
        boolean ageContinue = false;
        for (int i = 0; i < dataMaps.size(); ++i) {
            BigDecimal years;
            if (date.before((Date)dataMaps.get(i).get("startdate"))) continue;
            if (!date.before((Date)dataMaps.get(i).get("startdate")) && date.compareTo((Date)dataMaps.get(i).get("enddate")) <= 0) {
                years = DateUtil.calcYearsDiff(date, (Date)dataMaps.get(i).get("startdate"));
                age = age.add(years).add((BigDecimal)dataMaps.get(i).get("adjustlength"));
                timeMatchData = true;
                if ("1".equals(dataMaps.get(i).get("serviceagescheme")) || StringUtils.isEmpty((Object)dataMaps.get(i).get("serviceagescheme"))) break;
                ageContinue = true;
                continue;
            }
            if (timeMatchData && !ageContinue || !((Date)dataMaps.get(i).get("enddate")).before(date)) continue;
            years = DateUtil.calcYearsDiff((Date)dataMaps.get(i).get("enddate"), (Date)dataMaps.get(i).get("startdate"));
            age = age.add(years).add((BigDecimal)dataMaps.get(i).get("adjustlength"));
            timeMatchData = true;
            if ("1".equals(dataMaps.get(i).get("serviceagescheme")) || StringUtils.isEmpty((Object)dataMaps.get(i).get("serviceagescheme"))) break;
            ageContinue = true;
        }
        return age;
    }

    private static int compare(Map<String, Object> map0, Map<String, Object> map1) {
        return ((Date)map0.get("startdate")).before((Date)map1.get("startdate")) ? 1 : -1;
    }

    @Override
    public Map<Long, Map<String, Double>> empComSerCountCal(List<Long> employeeIds, Date startDate, Date endDate, BigDecimal precision, Map<Long, Long> empIdPIDMap, Map<Long, Long> allPerIdPIDMap) {
        Map<Long, List<DynamicObject>> pidPerSerLensMap = this.getPIDPerSerLensMap(allPerIdPIDMap);
        Map<Long, Map<String, Double>> empComSerCountMap = new LinkedHashMap<Long, Map<String, Double>>(16);
        if (pidPerSerLensMap.size() > 0) {
            Map<Long, List<DynamicObject>> empPerSerLensMap = empIdPIDMap.entrySet().stream().collect(Collectors.toMap(entry -> (Long)entry.getKey(), entry -> pidPerSerLensMap.get(entry.getValue()) != null ? (List)pidPerSerLensMap.get(entry.getValue()) : new ArrayList(10)));
            empComSerCountMap = this.doEmpComSerCountCal(empPerSerLensMap, startDate, endDate, precision);
        }
        return empComSerCountMap;
    }

    private Map<Long, List<DynamicObject>> getPIDPerSerLensMap(Map<Long, Long> allPerIdPIDMap) {
        HRBaseServiceHelper perSerLenHelper = new HRBaseServiceHelper("hrpi_perserlen");
        Map<Long, List<DynamicObject>> perIdPerSerLenMap = Arrays.stream(perSerLenHelper.query("person,employee.id,employee.startdate,employee.enddate,firstjoincomdate,joincomdate,adjustcomtime,comsercount", new QFilter[]{new QFilter("person", "in", allPerIdPIDMap.keySet()), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf()})).collect(Collectors.groupingBy(dy -> dy.getDynamicObject("person").getLong("id")));
        return this.getPIDDynListMap(allPerIdPIDMap, perIdPerSerLenMap);
    }

    private Map<Long, List<DynamicObject>> getPIDDynListMap(Map<Long, Long> allPerIdPIDMap, Map<Long, List<DynamicObject>> perIdPerSerLenMap) {
        HashMap<Long, List<DynamicObject>> pIdPerSerLensMap = new HashMap<Long, List<DynamicObject>>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : perIdPerSerLenMap.entrySet()) {
            Long personId = entry.getKey();
            Long pID = allPerIdPIDMap.get(personId);
            ArrayList empEntRelList = (ArrayList)pIdPerSerLensMap.get(pID);
            if (empEntRelList == null) {
                empEntRelList = new ArrayList();
            }
            empEntRelList.addAll(entry.getValue());
            pIdPerSerLensMap.put(pID, empEntRelList);
        }
        return pIdPerSerLensMap;
    }

    private Map<Long, Map<String, Double>> doEmpComSerCountCal(Map<Long, List<DynamicObject>> empPerSerLensMap, Date startDate, Date endDate, BigDecimal precision) {
        HashMap<Long, Map<String, Double>> empComSerCountMap = new HashMap<Long, Map<String, Double>>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : empPerSerLensMap.entrySet()) {
            BigDecimal len;
            Long employeeId = entry.getKey();
            List<DynamicObject> empPerSerLens = entry.getValue();
            empPerSerLens.sort(Comparator.comparing(o -> o.getDate("joincomdate")));
            ArrayList<Date> allDate = new ArrayList<Date>();
            LinkedHashMap<Date, DynamicObject> dateDynMap = new LinkedHashMap<Date, DynamicObject>();
            this.listAllEmpComSerCountDate(startDate, endDate, empPerSerLens, allDate, dateDynMap);
            LinkedHashMap<String, Double> serlenMap = new LinkedHashMap<String, Double>();
            BigDecimal startDateCalComSerCount = this.doCalComSerCount(startDate, empPerSerLens);
            BigDecimal endDateCalComSerCount = this.doCalComSerCount(endDate, empPerSerLens);
            if (allDate.size() == 2) {
                serlenMap.putAll(this.continuousCalComSerCount(startDate, endDate, precision, empPerSerLens));
            } else if (allDate.size() == 3) {
                Date middleDate = (Date)allDate.get(1);
                DynamicObject perSerLen = (DynamicObject)dateDynMap.get(middleDate);
                Date perSerLenStartDate = perSerLen.getDate("joincomdate");
                Date perSerLenEndDate = perSerLen.getDynamicObject("employee").getDate("enddate");
                if (startDate.compareTo(perSerLenStartDate) > 0 && startDate.compareTo(perSerLenEndDate) <= 0) {
                    serlenMap.putAll(this.continuousCalComSerCount(startDate, this.getEndDate(startDate, middleDate), precision, empPerSerLens));
                    len = this.doCalComSerCount(middleDate, empPerSerLens).divide(precision, 0, RoundingMode.DOWN).multiply(precision);
                    this.setDateRangeInMap(middleDate, endDate, serlenMap, len);
                } else {
                    len = startDateCalComSerCount.divide(precision, 0, RoundingMode.DOWN).multiply(precision);
                    this.setDateRangeInMap(startDate, this.getEndDate(startDate, middleDate), serlenMap, len);
                    serlenMap.putAll(this.continuousCalComSerCount(middleDate, endDate, precision, empPerSerLens));
                }
            } else {
                for (int i = 1; i < allDate.size(); ++i) {
                    Date date = (Date)allDate.get(i);
                    Date preDate = (Date)allDate.get(i - 1);
                    if (dateDynMap.get(preDate) == null) {
                        Date nextDate = (Date)allDate.get(i + 1);
                        if (((DynamicObject)dateDynMap.get(date)).equals(dateDynMap.get(nextDate))) {
                            len = startDateCalComSerCount.divide(precision, 0, RoundingMode.DOWN).multiply(precision);
                            this.setDateRangeInMap(startDate, this.getEndDate(startDate, date), serlenMap, len);
                            continue;
                        }
                        serlenMap.putAll(this.continuousCalComSerCount(startDate, this.getEndDate(startDate, date), precision, empPerSerLens));
                        continue;
                    }
                    if (dateDynMap.get(date) == null) {
                        Date prePreDate = (Date)allDate.get(i - 2);
                        if (((DynamicObject)dateDynMap.get(preDate)).equals(dateDynMap.get(prePreDate))) {
                            len = endDateCalComSerCount.divide(precision, 0, RoundingMode.DOWN).multiply(precision);
                            this.setDateRangeInMap(preDate, endDate, serlenMap, len);
                            continue;
                        }
                        serlenMap.putAll(this.continuousCalComSerCount(preDate, endDate, precision, empPerSerLens));
                        continue;
                    }
                    if (((DynamicObject)dateDynMap.get(date)).equals(dateDynMap.get(preDate))) {
                        serlenMap.putAll(this.continuousCalComSerCount(preDate, this.getEndDate(preDate, date), precision, empPerSerLens));
                        continue;
                    }
                    BigDecimal len2 = this.doCalComSerCount(preDate, empPerSerLens).divide(precision, 0, RoundingMode.DOWN).multiply(precision);
                    this.setDateRangeInMap(preDate, this.getEndDate(preDate, date), serlenMap, len2);
                }
            }
            empComSerCountMap.put(employeeId, this.mergeSameSerLenHandle(serlenMap));
        }
        return empComSerCountMap;
    }

    private void listAllEmpComSerCountDate(Date startDate, Date endDate, List<DynamicObject> dyns, List<Date> allDate, Map<Date, DynamicObject> dateDynMap) {
        allDate.add(startDate);
        for (DynamicObject dyn : dyns) {
            Date dynStartDate = dyn.getDate("joincomdate");
            Date dynEndDate = dyn.getDynamicObject("employee").getDate("enddate");
            if (dynStartDate.compareTo(startDate) >= 0 && dynStartDate.compareTo(endDate) <= 0) {
                dateDynMap.put(dynStartDate, dyn);
                allDate.add(dynStartDate);
            }
            if (dynEndDate.compareTo(startDate) < 0 || dynEndDate.compareTo(endDate) > 0) continue;
            dateDynMap.put(dynEndDate, dyn);
            allDate.add(dynEndDate);
        }
        allDate.add(endDate);
    }

    private Map<String, Double> continuousCalComSerCount(Date startDate, Date endDate, BigDecimal precision, List<DynamicObject> empComSerCountList) {
        BigDecimal minWorkYear = this.doCalComSerCount(startDate, empComSerCountList);
        BigDecimal maxWorkYear = this.doCalComSerCount(endDate, empComSerCountList);
        return this.continuousSerLenHandle(startDate, endDate, minWorkYear, maxWorkYear, precision);
    }

    private BigDecimal doCalComSerCount(Date date, List<DynamicObject> empPerSerLens) {
        empPerSerLens.sort(Comparator.comparing(dy1 -> dy1.getDate("joincomdate")).reversed());
        BigDecimal comSerCount = new BigDecimal(0);
        for (int i = 0; i < empPerSerLens.size(); ++i) {
            DynamicObject nextEmpPerSerLen;
            DynamicObject currentEmpPerSerLen = empPerSerLens.get(i);
            Date joinComDate = currentEmpPerSerLen.getDate("joincomdate");
            BigDecimal adjustComTime = currentEmpPerSerLen.getBigDecimal("adjustcomtime");
            Date endDate = currentEmpPerSerLen.getDynamicObject("employee").getDate("enddate");
            if (date.compareTo(joinComDate) >= 0 && date.compareTo(endDate) <= 0) {
                DynamicObject preEmpPerSerLen = i > 0 ? empPerSerLens.get(i - 1) : null;
                BigDecimal currentComSerCount = BusinessDataUtil.getServiceLength(date, joinComDate, adjustComTime);
                BigDecimal preComSerCount = preEmpPerSerLen != null ? preEmpPerSerLen.getBigDecimal("comsercount") : BigDecimal.ZERO;
                comSerCount = comSerCount.add(currentComSerCount).add(preComSerCount);
                break;
            }
            if (date.compareTo(joinComDate) < 0 || date.compareTo(endDate) < 0) continue;
            DynamicObject dynamicObject = nextEmpPerSerLen = i != empPerSerLens.size() - 1 ? empPerSerLens.get(i + 1) : null;
            if (nextEmpPerSerLen != null && date.compareTo(nextEmpPerSerLen.getDate("joincomdate")) > 0) break;
            comSerCount = currentEmpPerSerLen.getBigDecimal("comsercount");
            break;
        }
        return comSerCount;
    }

    private Map<String, Double> continuousSerLenHandle(Date startDate, Date endDate, BigDecimal minSerLen, BigDecimal maxSerLen, BigDecimal precision) {
        BigDecimal end;
        LinkedHashMap<String, Double> serlenMap = new LinkedHashMap<String, Double>();
        BigDecimal start = minSerLen.divide(precision, 0, RoundingMode.DOWN);
        if (start.compareTo(end = maxSerLen.divide(precision, 0, RoundingMode.DOWN)) == 0) {
            BigDecimal len = start.multiply(precision);
            this.setDateRangeInMap(startDate, endDate, serlenMap, len);
        } else {
            BigDecimal precisionDay = precision.multiply(new BigDecimal(365));
            BigDecimal firstAddDay = minSerLen.divide(precision, 0, RoundingMode.UP).subtract(minSerLen.divide(precision)).multiply(precisionDay).setScale(0, RoundingMode.DOWN);
            Date firstDate = HRDateTimeUtils.addDay((Date)startDate, (long)firstAddDay.longValue());
            while (firstDate.getTime() < startDate.getTime()) {
                firstDate = HRPerserlenHelper.getAddMonthDate((Date)firstDate, (Date)firstDate, (BigDecimal)precision);
            }
            this.diffPrecision(firstDate, startDate, endDate, precision, serlenMap, start, firstDate);
        }
        return serlenMap;
    }

    private Map<String, Double> continuousSocialWorkSerLenHandle(Date joinWorkTime, BigDecimal adjustTime, Date startDate, Date endDate, BigDecimal minSerLen, BigDecimal maxSerLen, BigDecimal precision) {
        BigDecimal end;
        LinkedHashMap<String, Double> serlenMap = new LinkedHashMap<String, Double>();
        BigDecimal start = minSerLen.divide(precision, 0, RoundingMode.DOWN);
        if (start.compareTo(end = maxSerLen.divide(precision, 0, RoundingMode.DOWN)) == 0) {
            BigDecimal len = start.multiply(precision);
            this.setDateRangeInMap(startDate, endDate, serlenMap, len);
        } else {
            this.diffPrecision(joinWorkTime, startDate, endDate, precision, serlenMap, start);
        }
        return serlenMap;
    }

    private void diffPrecision(Date joinWorkTime, Date startDate, Date endDate, BigDecimal precision, Map<String, Double> serlenMap, BigDecimal start) {
        Date firstDate = HRPerserlenHelper.getAddMonthDate((Date)joinWorkTime, (Date)joinWorkTime, (BigDecimal)precision);
        while (firstDate.getTime() < startDate.getTime()) {
            firstDate = HRPerserlenHelper.getAddMonthDate((Date)joinWorkTime, (Date)firstDate, (BigDecimal)precision);
        }
        this.diffPrecision(joinWorkTime, startDate, endDate, precision, serlenMap, start, firstDate);
    }

    private void diffPrecision(Date baseDate, Date startDate, Date endDate, BigDecimal precision, Map<String, Double> serlenMap, BigDecimal start, Date firstDate) {
        BigDecimal len;
        Date sDate;
        if (!firstDate.equals(startDate)) {
            this.setDateRangeInMap(startDate, HRDateTimeUtils.addDay((Date)firstDate, (long)-1L), serlenMap, start.multiply(precision));
        }
        Date eDate = firstDate;
        int i = 0;
        while (true) {
            sDate = eDate;
            eDate = HRPerserlenHelper.getAddMonthDate((Date)baseDate, (Date)eDate, (BigDecimal)precision);
            len = !firstDate.equals(startDate) ? start.add(new BigDecimal(i + 1)).multiply(precision) : start.add(new BigDecimal(i)).multiply(precision);
            if (eDate.compareTo(endDate) >= 0) break;
            this.setDateRangeInMap(sDate, HRDateTimeUtils.addDay((Date)eDate, (long)-1L), serlenMap, len);
            ++i;
        }
        this.setDateRangeInMap(sDate, endDate, serlenMap, len);
    }

    private void setDateRangeInMap(Date startDate, Date endDate, Map<String, Double> serlenMap, BigDecimal len) {
        String startDateStr = HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd");
        String endDateStr = HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
        serlenMap.put(startDateStr + "~" + endDateStr, len.doubleValue());
    }
}

