/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRPerserlenHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.RepositoryUtil;
import kd.hrmp.hrpi.business.domian.service.IHRPISerLenCalService;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;

public class HRPISerLenCalServiceNewImpl
implements IHRPISerLenCalService {
    public static final String JOINCOMDATE = "joincomdate";
    public static final String ADJUSTCOMTIME = "adjustcomtime";
    public static final String COMSERCOUNT = "comsercount";
    private static final Log LOGGER = LogFactory.getLog(HRPISerLenCalServiceNewImpl.class);
    public static final String STARTDATE = "startdate";
    public static final String ENDDATE = "enddate";
    private static volatile HRPISerLenCalServiceNewImpl INSTANCE;

    private HRPISerLenCalServiceNewImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HRPISerLenCalServiceNewImpl getInstance() {
        if (null != INSTANCE) return INSTANCE;
        Class<HRPISerLenCalServiceNewImpl> clazz = HRPISerLenCalServiceNewImpl.class;
        synchronized (HRPISerLenCalServiceNewImpl.class) {
            if (null != INSTANCE) return INSTANCE;
            INSTANCE = new HRPISerLenCalServiceNewImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public Map<Long, Map<String, Double>> empSocialWorkAgeCal(List<Long> employeeIds, Date startDate, Date endDate, BigDecimal precision) {
        DynamicObject[] perSerLenDyns;
        HashMap<Long, Map<String, Double>> empSocialWorkAgeMap = new HashMap<Long, Map<String, Double>>(employeeIds.size() * 2);
        for (DynamicObject perSerLenDyn : perSerLenDyns = RepositoryUtil.getDynamicObjectCollection("employee,joinworktime,adjustworkage", null, "hrpi_perserlen", new QFilter[]{new QFilter("employee", "in", employeeIds), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getStatusFilters(), QFilterUtil.getInitStatusFinish()}, null)) {
            long employeeId = perSerLenDyn.getDynamicObject("employee").getLong("id");
            Date joinWorkTime = perSerLenDyn.getDate("joinworktime");
            if (HRObjectUtils.isEmpty((Object)joinWorkTime)) continue;
            BigDecimal adjustWorkAge = perSerLenDyn.getBigDecimal("adjustworkage");
            if (adjustWorkAge == null) {
                adjustWorkAge = BigDecimal.ZERO;
            }
            Map<String, Double> socialWorkAgeMap = new LinkedHashMap<String, Double>(16);
            if (startDate.compareTo(joinWorkTime) < 0) {
                if (endDate.compareTo(joinWorkTime) >= 0) {
                    this.setDateRangeInMap(startDate, HRDateTimeUtils.addDay((Date)joinWorkTime, (long)-1L), socialWorkAgeMap, BigDecimal.ZERO);
                    socialWorkAgeMap.putAll(this.getSplitDateMap(joinWorkTime, endDate, joinWorkTime, adjustWorkAge, precision));
                } else {
                    this.setDateRangeInMap(startDate, endDate, socialWorkAgeMap, BigDecimal.ZERO);
                }
            } else {
                socialWorkAgeMap = this.getSplitDateMap(startDate, endDate, joinWorkTime, adjustWorkAge, precision);
            }
            empSocialWorkAgeMap.put(employeeId, this.mergeSameSerLenHandle(socialWorkAgeMap));
        }
        return empSocialWorkAgeMap;
    }

    private Map<String, Double> mergeSameSerLenHandle(Map<String, Double> serlenMap) {
        LinkedHashMap<String, Double> resultMap = new LinkedHashMap<String, Double>();
        Object[] serlenMapEntryArray = serlenMap.entrySet().toArray();
        block0: for (int i = 0; i < serlenMapEntryArray.length; ++i) {
            Map.Entry entry = (Map.Entry)serlenMapEntryArray[i];
            if (i == serlenMapEntryArray.length - 1) {
                resultMap.put((String)entry.getKey(), (Double)entry.getValue());
            }
            int j = 1;
            while (i + j < serlenMapEntryArray.length) {
                String newKey;
                Map.Entry lastEntry;
                Map.Entry notSameEntry = (Map.Entry)serlenMapEntryArray[i + j];
                if (entry.getValue() != null && !((Double)entry.getValue()).equals(notSameEntry.getValue())) {
                    lastEntry = (Map.Entry)serlenMapEntryArray[i + j - 1];
                    newKey = ((String)entry.getKey()).split("~")[0] + "~" + ((String)lastEntry.getKey()).split("~")[1];
                    resultMap.put(newKey, (Double)entry.getValue());
                    i = i + j - 1;
                    continue block0;
                }
                if (entry.getValue() != null && ((Double)entry.getValue()).equals(notSameEntry.getValue()) && i + j == serlenMapEntryArray.length - 1) {
                    lastEntry = (Map.Entry)serlenMapEntryArray[i + j];
                    newKey = ((String)entry.getKey()).split("~")[0] + "~" + ((String)lastEntry.getKey()).split("~")[1];
                    resultMap.put(newKey, (Double)entry.getValue());
                    i += j;
                    continue block0;
                }
                ++j;
            }
        }
        return resultMap;
    }

    private Map<String, Double> getSplitDateMap(Date startDate, Date endDate, Date joinWorkTime, BigDecimal adjustTime, BigDecimal precision) {
        BigDecimal minWorkYear = HRPerserlenHelper.calcYearsDiffWithRoundingMode((Date)startDate, (Date)joinWorkTime, (RoundingMode)RoundingMode.DOWN);
        BigDecimal maxWorkYear = HRPerserlenHelper.calcYearsDiffWithRoundingMode((Date)endDate, (Date)joinWorkTime, (RoundingMode)RoundingMode.DOWN);
        return this.continuousSocialWorkSerLenHandle(joinWorkTime, startDate, endDate, minWorkYear, maxWorkYear, precision, adjustTime);
    }

    @Override
    public Map<Long, Map<String, Double>> empCompanyWorkAgeCal(List<Long> employeeIds, Date startDate, Date endDate, BigDecimal precision, Map<Long, Long> empIdPIDMap, Map<Long, Long> allPerIdPIDMap) {
        Map<Long, List<DynamicObject>> pIDEmpEntRelsMap = this.getPIDEmpEntRelsMap(allPerIdPIDMap);
        Map<Long, Map<String, Double>> empCompanyWorkAgeMap = new LinkedHashMap<Long, Map<String, Double>>(16);
        if (pIDEmpEntRelsMap.size() > 0) {
            Map<Long, List<DynamicObject>> empEmpEntRelsMap = empIdPIDMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> pIDEmpEntRelsMap.get(entry.getValue()) != null ? (List)pIDEmpEntRelsMap.get(entry.getValue()) : new ArrayList(10)));
            empCompanyWorkAgeMap = this.doEmpCompanyWorkAgeCal(empEmpEntRelsMap, startDate, endDate, precision);
        }
        return empCompanyWorkAgeMap;
    }

    private Map<Long, List<DynamicObject>> getPIDEmpEntRelsMap(Map<Long, Long> allPerIdPIDMap) {
        Map<Long, List<DynamicObject>> perIdEmpEntRelMap = Arrays.stream(HRPIEmployeeRepository.empentrelServiceHelper.query("person,adjustlength,startdate,enddate,serviceagescheme", new QFilter[]{new QFilter("person", "in", allPerIdPIDMap.keySet()), QFilterUtil.getDataStatusFilter(), QFilterUtil.getStatusFilters(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()})).collect(Collectors.groupingBy(dy -> dy.getDynamicObject("person").getLong("id")));
        return this.getPIDDynListMap(allPerIdPIDMap, perIdEmpEntRelMap);
    }

    private Map<Long, Map<String, Double>> doEmpCompanyWorkAgeCal(Map<Long, List<DynamicObject>> empEmpEntRelsMap, Date startDate, Date endDate, BigDecimal precision) {
        HashMap<Long, Map<String, Double>> empCompanyWorkAgeMap = new HashMap<Long, Map<String, Double>>(empEmpEntRelsMap.size() * 2);
        for (Map.Entry<Long, List<DynamicObject>> entry : empEmpEntRelsMap.entrySet()) {
            Long employeeId = entry.getKey();
            List<DynamicObject> empEntRels = entry.getValue();
            Comparator<DynamicObject> comparing = Comparator.comparing(o -> o.getDate(STARTDATE));
            Comparator<DynamicObject> dynamicObjectComparator = comparing.thenComparing(p -> p.getDate(ENDDATE));
            empEntRels.sort(dynamicObjectComparator);
            ArrayList<Tuple<Date, DynamicObject>> allDateMap = new ArrayList<Tuple<Date, DynamicObject>>(10);
            this.listAllDate(startDate, endDate, empEntRels, allDateMap);
            List<Map<String, Object>> empEntRelMapList = DynamicTransformUtil.dynamicListToMap(empEntRels);
            LinkedHashMap<String, Double> companyWorkAgeMap = new LinkedHashMap<String, Double>();
            BigDecimal startDateCompanyWorkAge = this.doCalcCompanyWorkAge(startDate, empEntRelMapList, precision);
            BigDecimal endDateCompanyWorkAge = this.doCalcCompanyWorkAge(endDate, empEntRelMapList, precision);
            if (allDateMap.size() == 2) {
                DynamicObject curEmpent = this.getCurrentEmpent(startDate, endDate, empEntRels);
                if (null != curEmpent) {
                    companyWorkAgeMap.putAll(this.continuousCompanyWorkAge(startDate, endDate, precision, empEntRelMapList, curEmpent));
                } else {
                    this.setDateRangeInMap(startDate, endDate, companyWorkAgeMap, BigDecimal.ZERO);
                }
            } else if (allDateMap.size() == 3) {
                if (null == ((Tuple)allDateMap.get((int)0)).item2) {
                    this.calculateCompanyWorkAgeSingle(allDateMap, companyWorkAgeMap, startDate, endDate, precision, empEntRelMapList, startDateCompanyWorkAge);
                } else {
                    this.calculateCompanyWorkAgeMulti(allDateMap, companyWorkAgeMap, startDate, endDate, precision, empEntRelMapList, startDateCompanyWorkAge);
                }
            } else {
                this.calculateCompanyWorkAgeMulti(allDateMap, companyWorkAgeMap, startDate, endDate, precision, empEntRelMapList, startDateCompanyWorkAge);
            }
            empCompanyWorkAgeMap.put(employeeId, this.mergeSameSerLenHandle(companyWorkAgeMap));
        }
        return empCompanyWorkAgeMap;
    }

    private void calculateCompanyWorkAgeSingle(List<Tuple<Date, DynamicObject>> allDateMap, Map<String, Double> companyWorkAgeMap, Date startDate, Date endDate, BigDecimal precision, List<Map<String, Object>> empEntRelMapList, BigDecimal startDateCompanyWorkAge) {
        Date middleDate = (Date)allDateMap.get((int)1).item1;
        DynamicObject empEntRelObj = (DynamicObject)allDateMap.get((int)1).item2;
        Date empEntRelObjStartDate = empEntRelObj.getDate(STARTDATE);
        Date empEntRelObjEndDate = empEntRelObj.getDate(ENDDATE);
        if (startDate.compareTo(empEntRelObjStartDate) > 0 && startDate.compareTo(empEntRelObjEndDate) <= 0) {
            companyWorkAgeMap.putAll(this.continuousCompanyWorkAge(startDate, this.getEndDate(startDate, middleDate), precision, empEntRelMapList, empEntRelObj));
            this.setDateRangeInMap(middleDate, endDate, companyWorkAgeMap, BigDecimal.ZERO);
        } else {
            if (startDate.compareTo(middleDate) < 0) {
                this.setDateRangeInMap(startDate, this.getEndDate(startDate, middleDate), companyWorkAgeMap, BigDecimal.ZERO);
            } else {
                this.setDateRangeInMap(startDate, this.getEndDate(startDate, middleDate), companyWorkAgeMap, startDateCompanyWorkAge);
            }
            companyWorkAgeMap.putAll(this.continuousCompanyWorkAge(middleDate, endDate, precision, empEntRelMapList, empEntRelObj));
        }
    }

    private void calculateCompanyWorkAgeMulti(List<Tuple<Date, DynamicObject>> allDateMap, Map<String, Double> companyWorkAgeMap, Date startDate, Date endDate, BigDecimal precision, List<Map<String, Object>> empEntRelMapList, BigDecimal startDateCompanyWorkAge) {
        for (int i = 1; i < allDateMap.size(); ++i) {
            Date curDate = (Date)allDateMap.get((int)i).item1;
            Date preDate = (Date)allDateMap.get((int)(i - 1)).item1;
            DynamicObject preDateEmpEnt = (DynamicObject)allDateMap.get((int)(i - 1)).item2;
            DynamicObject curDateEmpEnt = (DynamicObject)allDateMap.get((int)i).item2;
            if (preDateEmpEnt == null) {
                if (curDateEmpEnt.equals(allDateMap.get((int)(i + 1)).item2)) {
                    if (i == 1 && preDate.compareTo(curDate) < 0) {
                        this.setDateRangeInMap(preDate, this.getEndDate(preDate, curDate), companyWorkAgeMap, BigDecimal.ZERO);
                        continue;
                    }
                    this.setDateRangeInMap(startDate, this.getEndDate(startDate, curDate), companyWorkAgeMap, startDateCompanyWorkAge);
                    continue;
                }
                companyWorkAgeMap.putAll(this.continuousCompanyWorkAge(startDate, this.getEndDate(startDate, curDate), precision, empEntRelMapList, curDateEmpEnt));
                continue;
            }
            if (curDateEmpEnt == null) {
                DynamicObject prePreDateEmpEnt = (DynamicObject)allDateMap.get((int)(i - 2)).item2;
                if (preDateEmpEnt.equals(prePreDateEmpEnt)) {
                    BigDecimal len = BigDecimal.ZERO;
                    this.setDateRangeInMap(preDate, endDate, companyWorkAgeMap, len);
                    continue;
                }
                companyWorkAgeMap.putAll(this.continuousCompanyWorkAge(preDate, endDate, precision, empEntRelMapList, preDateEmpEnt));
                continue;
            }
            if (curDateEmpEnt.equals(preDateEmpEnt)) {
                companyWorkAgeMap.putAll(this.continuousCompanyWorkAge(preDate, this.getEndDate(preDate, curDate), precision, empEntRelMapList, curDateEmpEnt));
                continue;
            }
            if (!preDate.before(curDate)) continue;
            BigDecimal len = BigDecimal.ZERO;
            this.setDateRangeInMap(preDate, this.getEndDate(preDate, curDate), companyWorkAgeMap, len);
        }
    }

    private Date getEndDate(Date startDate, Date endDate) {
        if (startDate != null && startDate.equals(endDate)) {
            return endDate;
        }
        return HRDateTimeUtils.addDay((Date)endDate, (long)-1L);
    }

    private void listAllDate(Date startDate, Date endDate, List<DynamicObject> dyns, List<Tuple<Date, DynamicObject>> allDateMap) {
        Optional<DynamicObject> optional = dyns.stream().filter(dynamicObject -> dynamicObject.getDate(STARTDATE).compareTo(startDate) == 0).findFirst();
        if (!optional.isPresent()) {
            allDateMap.add((Tuple<Date, DynamicObject>)Tuple.create((Object)startDate, null));
        }
        for (DynamicObject dyn : dyns) {
            Date dynStartDate = dyn.getDate(STARTDATE);
            Date dynEndDate = dyn.getDate(ENDDATE);
            if (dynStartDate.compareTo(startDate) >= 0 && dynStartDate.compareTo(endDate) <= 0) {
                allDateMap.add((Tuple<Date, DynamicObject>)Tuple.create((Object)dynStartDate, (Object)dyn));
            }
            if (dynEndDate.compareTo(startDate) < 0 || dynEndDate.compareTo(endDate) > 0) continue;
            Date oneDayAfterDynEndDate = HRDateTimeUtils.addDay((Date)dynEndDate, (long)1L);
            allDateMap.add((Tuple<Date, DynamicObject>)Tuple.create((Object)oneDayAfterDynEndDate, (Object)dyn));
        }
        allDateMap.add((Tuple<Date, DynamicObject>)Tuple.create((Object)endDate, null));
    }

    private DynamicObject getCurrentEmpent(Date startDate, Date endDate, List<DynamicObject> empEntRels) {
        for (DynamicObject dyn : empEntRels) {
            Date dynEndDate;
            Date dynStartDate;
            DynamicObject currentDyn = this.getCurrentDyn(startDate, endDate, empEntRels, dyn, dynStartDate = dyn.getDate(STARTDATE), dynEndDate = dyn.getDate(ENDDATE));
            if (currentDyn == null) continue;
            return currentDyn;
        }
        return null;
    }

    private Map<String, Double> continuousCompanyWorkAge(Date startDate, Date endDate, BigDecimal precision, List<Map<String, Object>> empEntRelMapList, DynamicObject curEmpEntRel) {
        BigDecimal minWorkYear = this.doCalcCompanyWorkAgeWithoutAdjust(startDate, curEmpEntRel);
        BigDecimal maxWorkYear = this.doCalcCompanyWorkAgeWithoutAdjust(endDate, curEmpEntRel);
        Date firstDate = curEmpEntRel.getDate(STARTDATE);
        BigDecimal preComWorkAgeSum = BigDecimal.ZERO;
        String ageScheme = curEmpEntRel.getString("serviceagescheme");
        if ("2".equals(ageScheme)) {
            preComWorkAgeSum = this.doCalcCompanyWorkAge(firstDate, empEntRelMapList, precision);
        }
        BigDecimal adjustLength = BigDecimal.ZERO;
        if (firstDate.compareTo(startDate) <= 0) {
            adjustLength = curEmpEntRel.getBigDecimal("adjustlength");
        }
        BigDecimal addAge = preComWorkAgeSum.add(adjustLength);
        Map<String, Double> serlenMap = this.continuousComWorkAgeHandle(firstDate, startDate, endDate, minWorkYear, maxWorkYear, precision, addAge);
        return serlenMap;
    }

    private BigDecimal doCalcCompanyWorkAge(Date date, List<Map<String, Object>> dataMaps, BigDecimal precision) {
        dataMaps.sort(HRPISerLenCalServiceNewImpl::compareAsc);
        BigDecimal age = BigDecimal.ZERO;
        for (Map<String, Object> dataMap : dataMaps) {
            Date startDate = (Date)dataMap.get(STARTDATE);
            if (date.compareTo(startDate) <= 0) continue;
            Date endDate = (Date)dataMap.get(ENDDATE);
            Object ageScheme = dataMap.get("serviceagescheme");
            BigDecimal adjustLength = (BigDecimal)dataMap.get("adjustlength");
            BigDecimal years = BigDecimal.ZERO;
            if (!date.before(startDate) && date.compareTo(endDate) <= 0) {
                years = DateUtil.calcYearsDiff(date, startDate);
            } else if (endDate.before(date)) {
                years = DateUtil.calcYearsDiff(endDate, startDate);
            }
            if ("1".equals(ageScheme) || StringUtils.isEmpty((Object)ageScheme)) {
                age = years.add(adjustLength);
                continue;
            }
            age = age.add(years).add(adjustLength);
        }
        return age;
    }

    private BigDecimal doCalcCompanyWorkAgeWithoutAdjust(Date date, DynamicObject curEmpEntRel) {
        BigDecimal age = BigDecimal.ZERO;
        Date startDate = curEmpEntRel.getDate(STARTDATE);
        if (date.before(startDate)) {
            return BigDecimal.ZERO;
        }
        Date endDate = curEmpEntRel.getDate(ENDDATE);
        if (!date.before(startDate) && date.compareTo(endDate) <= 0) {
            age = HRPerserlenHelper.calcYearsDiffWithRoundingMode((Date)date, (Date)startDate, (RoundingMode)RoundingMode.DOWN);
            return age;
        }
        if (endDate.before(date)) {
            age = DateUtil.calcYearsDiff(endDate, startDate);
            return age;
        }
        return age;
    }

    private static int compareAsc(Map<String, Object> map0, Map<String, Object> map1) {
        return ((Date)map0.get(STARTDATE)).before((Date)map1.get(STARTDATE)) ? -1 : 1;
    }

    @Override
    public Map<Long, Map<String, Double>> empComSerCountCal(List<Long> employeeIds, Date startDate, Date endDate, BigDecimal precision, Map<Long, Long> empIdPIDMap, Map<Long, Long> allPerIdPIDMap) {
        Map<Long, List<DynamicObject>> pidPerSerLensMap = this.getPIDPerSerLensMap(allPerIdPIDMap);
        Map<Long, Map<String, Double>> empComSerCountMap = new LinkedHashMap<Long, Map<String, Double>>(16);
        if (pidPerSerLensMap.size() > 0) {
            Map<Long, List<DynamicObject>> empPerSerLensMap = empIdPIDMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> pidPerSerLensMap.get(entry.getValue()) != null ? (List)pidPerSerLensMap.get(entry.getValue()) : new ArrayList(10)));
            empComSerCountMap = this.doEmpComSerCountCal(empPerSerLensMap, startDate, endDate, precision);
        }
        return empComSerCountMap;
    }

    private Map<Long, List<DynamicObject>> getPIDPerSerLensMap(Map<Long, Long> allPerIdPIDMap) {
        HRBaseServiceHelper perSerLenHelper = new HRBaseServiceHelper("hrpi_perserlen");
        Map<Long, List<DynamicObject>> perIdPerSerLenMap = Arrays.stream(perSerLenHelper.query("person,employee.id,employee.startdate,employee.enddate,firstjoincomdate,joincomdate,adjustcomtime,comsercount", new QFilter[]{new QFilter("person", "in", allPerIdPIDMap.keySet()), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf()})).collect(Collectors.groupingBy(dy -> dy.getDynamicObject("person").getLong("id")));
        return this.getPIDDynListMap(allPerIdPIDMap, perIdPerSerLenMap);
    }

    private Map<Long, List<DynamicObject>> getPIDDynListMap(Map<Long, Long> allPerIdPIDMap, Map<Long, List<DynamicObject>> perIdPerSerLenMap) {
        HashMap<Long, List<DynamicObject>> pIdPerSerLensMap = new HashMap<Long, List<DynamicObject>>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : perIdPerSerLenMap.entrySet()) {
            Long personId = entry.getKey();
            Long pID = allPerIdPIDMap.get(personId);
            ArrayList empEntRelList = (ArrayList)pIdPerSerLensMap.get(pID);
            if (empEntRelList == null) {
                empEntRelList = new ArrayList();
            }
            empEntRelList.addAll(entry.getValue());
            pIdPerSerLensMap.put(pID, empEntRelList);
        }
        return pIdPerSerLensMap;
    }

    private Map<Long, Map<String, Double>> doEmpComSerCountCal(Map<Long, List<DynamicObject>> empPerSerLensMap, Date startDate, Date endDate, BigDecimal precision) {
        HashMap<Long, Map<String, Double>> empComSerCountMap = new HashMap<Long, Map<String, Double>>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : empPerSerLensMap.entrySet()) {
            Long employeeId = entry.getKey();
            List<DynamicObject> empPerSerLens = entry.getValue();
            empPerSerLens.sort(Comparator.comparing(o -> o.getDate(JOINCOMDATE)));
            ArrayList<Tuple<Date, DynamicObject>> allDateMap = new ArrayList<Tuple<Date, DynamicObject>>(10);
            this.listAllEmpComSerCountDate(startDate, endDate, empPerSerLens, allDateMap);
            LinkedHashMap<String, Double> serlenMap = new LinkedHashMap<String, Double>();
            BigDecimal startDateCalComSerCount = this.doCalComSerCount(startDate, empPerSerLens, precision);
            if (allDateMap.size() == 2) {
                DynamicObject curPerSerLen = this.getCurrentPerServLen(startDate, endDate, empPerSerLens);
                if (null != curPerSerLen) {
                    serlenMap.putAll(this.continuousCalComSerCount(startDate, endDate, precision, empPerSerLens, curPerSerLen));
                } else {
                    this.setDateRangeInMap(startDate, endDate, serlenMap, BigDecimal.ZERO);
                }
            } else if (allDateMap.size() == 3) {
                if (null == ((Tuple)allDateMap.get((int)0)).item2) {
                    this.calculateComSerCountSingle(allDateMap, serlenMap, startDate, endDate, precision, empPerSerLens, startDateCalComSerCount);
                } else {
                    this.calculateComSerCountMulti(allDateMap, serlenMap, startDate, endDate, precision, empPerSerLens, startDateCalComSerCount);
                }
            } else {
                this.calculateComSerCountMulti(allDateMap, serlenMap, startDate, endDate, precision, empPerSerLens, startDateCalComSerCount);
            }
            empComSerCountMap.put(employeeId, this.mergeSameSerLenHandle(serlenMap));
        }
        return empComSerCountMap;
    }

    private void calculateComSerCountSingle(List<Tuple<Date, DynamicObject>> allDateMap, Map<String, Double> serlenMap, Date startDate, Date endDate, BigDecimal precision, List<DynamicObject> empPerSerLens, BigDecimal startDateCalComSerCount) {
        Date middleDate = ((Date)allDateMap.get((int)1).item1).compareTo(endDate) > 0 ? endDate : (Date)allDateMap.get((int)1).item1;
        DynamicObject perSerLen = (DynamicObject)allDateMap.get((int)1).item2;
        Date perSerLenStartDate = perSerLen.getDate(JOINCOMDATE);
        Date perSerLenEndDate = perSerLen.getDynamicObject("employee").getDate(ENDDATE);
        if (perSerLenEndDate.compareTo(endDate) == 0) {
            middleDate = HRDateTimeUtils.addDay((Date)middleDate, (long)1L);
        }
        if (startDate.compareTo(perSerLenStartDate) > 0 && startDate.compareTo(perSerLenEndDate) <= 0) {
            serlenMap.putAll(this.continuousCalComSerCount(startDate, this.getEndDate(startDate, middleDate), precision, empPerSerLens, perSerLen));
            this.setDateRangeInMap(middleDate, endDate, serlenMap, BigDecimal.ZERO);
        } else {
            if (startDate.compareTo(middleDate) < 0) {
                this.setDateRangeInMap(startDate, this.getEndDate(startDate, middleDate), serlenMap, BigDecimal.ZERO);
            } else {
                this.setDateRangeInMap(startDate, this.getEndDate(startDate, middleDate), serlenMap, startDateCalComSerCount);
            }
            serlenMap.putAll(this.continuousCalComSerCount(middleDate, endDate, precision, empPerSerLens, perSerLen));
        }
    }

    private void calculateComSerCountMulti(List<Tuple<Date, DynamicObject>> allDateMap, Map<String, Double> serlenMap, Date startDate, Date endDate, BigDecimal precision, List<DynamicObject> empPerSerLens, BigDecimal startDateCalComSerCount) {
        for (int i = 1; i < allDateMap.size(); ++i) {
            Date curDate = (Date)allDateMap.get((int)i).item1;
            Date preDate = (Date)allDateMap.get((int)(i - 1)).item1;
            DynamicObject preDatePerSerLen = (DynamicObject)allDateMap.get((int)(i - 1)).item2;
            DynamicObject curDatePerSerLen = (DynamicObject)allDateMap.get((int)i).item2;
            if (preDatePerSerLen == null) {
                if (curDatePerSerLen.equals(allDateMap.get((int)(i + 1)).item2)) {
                    if (i == 1 && preDate.compareTo(curDate) < 0) {
                        this.setDateRangeInMap(preDate, this.getEndDate(preDate, curDate), serlenMap, BigDecimal.ZERO);
                        continue;
                    }
                    this.setDateRangeInMap(startDate, this.getEndDate(startDate, curDate), serlenMap, startDateCalComSerCount);
                    continue;
                }
                serlenMap.putAll(this.continuousCalComSerCount(startDate, this.getEndDate(startDate, curDate), precision, empPerSerLens, curDatePerSerLen));
                continue;
            }
            if (curDatePerSerLen == null) {
                if (preDatePerSerLen.equals(allDateMap.get((int)(i - 2)).item2)) {
                    this.setDateRangeInMap(preDate, endDate, serlenMap, BigDecimal.ZERO);
                    continue;
                }
                serlenMap.putAll(this.continuousCalComSerCount(preDate, endDate, precision, empPerSerLens, preDatePerSerLen));
                continue;
            }
            if (curDatePerSerLen.equals(preDatePerSerLen)) {
                serlenMap.putAll(this.continuousCalComSerCount(preDate, this.getEndDate(preDate, curDate), precision, empPerSerLens, curDatePerSerLen));
                continue;
            }
            BigDecimal len = BigDecimal.ZERO;
            if (!preDate.before(curDate)) continue;
            this.setDateRangeInMap(preDate, this.getEndDate(preDate, curDate), serlenMap, len);
        }
    }

    private void listAllEmpComSerCountDate(Date startDate, Date endDate, List<DynamicObject> dyns, List<Tuple<Date, DynamicObject>> allDateMap) {
        Optional<DynamicObject> optional = dyns.stream().filter(dynamicObject -> dynamicObject.getDate(JOINCOMDATE).compareTo(startDate) == 0).findFirst();
        if (!optional.isPresent()) {
            allDateMap.add((Tuple<Date, DynamicObject>)Tuple.create((Object)startDate, null));
        }
        for (DynamicObject dyn : dyns) {
            Date dynStartDate = dyn.getDate(JOINCOMDATE);
            Date dynEndDate = dyn.getDynamicObject("employee").getDate(ENDDATE);
            if (dynStartDate.compareTo(startDate) >= 0 && dynStartDate.compareTo(endDate) <= 0) {
                allDateMap.add((Tuple<Date, DynamicObject>)Tuple.create((Object)dynStartDate, (Object)dyn));
            }
            if (dynEndDate.compareTo(startDate) < 0 || dynEndDate.compareTo(endDate) > 0) continue;
            Date oneDayAfterDynEndDate = HRDateTimeUtils.addDay((Date)dynEndDate, (long)1L);
            allDateMap.add((Tuple<Date, DynamicObject>)Tuple.create((Object)oneDayAfterDynEndDate, (Object)dyn));
        }
        allDateMap.add((Tuple<Date, DynamicObject>)Tuple.create((Object)endDate, null));
    }

    private DynamicObject getCurrentPerServLen(Date startDate, Date endDate, List<DynamicObject> dyns) {
        for (DynamicObject dyn : dyns) {
            Date dynEndDate;
            Date dynStartDate;
            DynamicObject currentDyn = this.getCurrentDyn(startDate, endDate, dyns, dyn, dynStartDate = dyn.getDate(JOINCOMDATE), dynEndDate = dyn.getDynamicObject("employee").getDate(ENDDATE));
            if (currentDyn == null) continue;
            return currentDyn;
        }
        return null;
    }

    private DynamicObject getCurrentDyn(Date startDate, Date endDate, List<DynamicObject> dyns, DynamicObject dyn, Date dynStartDate, Date dynEndDate) {
        if (dynStartDate.compareTo(startDate) <= 0 && dynEndDate.compareTo(endDate) >= 0) {
            return dyn;
        }
        if (dynStartDate.compareTo(startDate) >= 0 && dynStartDate.compareTo(endDate) <= 0) {
            return dyn;
        }
        if (dynEndDate.compareTo(startDate) >= 0 && dynEndDate.compareTo(endDate) <= 0) {
            return dyn;
        }
        return null;
    }

    private Map<String, Double> continuousCalComSerCount(Date startDate, Date endDate, BigDecimal precision, List<DynamicObject> empPerSerLens, DynamicObject curEmpPerSerLen) {
        BigDecimal minWorkYear = this.doCalComSerCountWithoutAdjust(startDate, curEmpPerSerLen);
        BigDecimal maxWorkYear = this.doCalComSerCountWithoutAdjust(endDate, curEmpPerSerLen);
        return this.continuousComSerLenHandle(startDate, endDate, minWorkYear, maxWorkYear, precision, empPerSerLens, curEmpPerSerLen);
    }

    private BigDecimal doCalComSerCountWithoutAdjust(Date date, DynamicObject curComSerCount) {
        BigDecimal comSerCount = BigDecimal.ZERO;
        Date joinComDate = curComSerCount.getDate(JOINCOMDATE);
        Date endDate = curComSerCount.getDynamicObject("employee").getDate(ENDDATE);
        if (date.compareTo(joinComDate) >= 0 && date.compareTo(endDate) <= 0) {
            comSerCount = HRPerserlenHelper.calcYearsDiffWithRoundingMode((Date)date, (Date)joinComDate, (RoundingMode)RoundingMode.DOWN);
        }
        return comSerCount;
    }

    private BigDecimal doCalComSerCount(Date date, List<DynamicObject> empPerSerLens, BigDecimal precision) {
        BigDecimal comSerCount = BigDecimal.ZERO;
        BigDecimal addCount = BigDecimal.ZERO;
        for (int i = 0; i < empPerSerLens.size(); ++i) {
            DynamicObject nextEmpPerSerLen;
            DynamicObject currentEmpPerSerLen = empPerSerLens.get(i);
            Date joinComDate = currentEmpPerSerLen.getDate(JOINCOMDATE);
            BigDecimal adjustComTime = currentEmpPerSerLen.getBigDecimal(ADJUSTCOMTIME);
            Date endDate = currentEmpPerSerLen.getDynamicObject("employee").getDate(ENDDATE);
            if (date.compareTo(joinComDate) > 0 && date.compareTo(endDate) <= 0) {
                BigDecimal currentComSerCount = HRPerserlenHelper.calcYearsDiffNew((Date)date, (Date)joinComDate);
                currentComSerCount = currentComSerCount.divide(precision, 0, RoundingMode.DOWN).multiply(precision);
                comSerCount = comSerCount.add(currentComSerCount);
                DynamicObject preEmpPerSerLen = i > 0 ? empPerSerLens.get(i - 1) : null;
                BigDecimal preComSerCount = preEmpPerSerLen != null ? preEmpPerSerLen.getBigDecimal(COMSERCOUNT) : BigDecimal.ZERO;
                addCount = addCount.add(preComSerCount).add(adjustComTime);
                continue;
            }
            if (date.compareTo(joinComDate) < 0 || date.compareTo(endDate) < 0) continue;
            DynamicObject dynamicObject = nextEmpPerSerLen = i != empPerSerLens.size() - 1 ? empPerSerLens.get(i + 1) : null;
            if (nextEmpPerSerLen != null && date.compareTo(nextEmpPerSerLen.getDate(JOINCOMDATE)) > 0) continue;
            addCount = currentEmpPerSerLen.getBigDecimal(COMSERCOUNT);
        }
        return comSerCount.add(addCount);
    }

    private Map<String, Double> continuousComWorkAgeHandle(Date firstDate, Date startDate, Date endDate, BigDecimal minSerLen, BigDecimal maxSerLen, BigDecimal precision, BigDecimal addAge) {
        BigDecimal end;
        LinkedHashMap<String, Double> serlenMap = new LinkedHashMap<String, Double>();
        BigDecimal start = minSerLen.divide(precision, 0, RoundingMode.DOWN);
        if (start.compareTo(end = maxSerLen.divide(precision, 0, RoundingMode.DOWN)) == 0) {
            BigDecimal len = start.multiply(precision).add(addAge);
            this.setDateRangeInMap(startDate, endDate, serlenMap, len);
        } else {
            Date baseDate = new Date(firstDate.getTime());
            while (firstDate.getTime() < startDate.getTime()) {
                firstDate = HRPerserlenHelper.getAddMonthDate((Date)baseDate, (Date)firstDate, (BigDecimal)precision);
            }
            this.diffPrecision(baseDate, startDate, endDate, precision, serlenMap, start, firstDate, addAge);
        }
        return serlenMap;
    }

    private Map<String, Double> continuousComSerLenHandle(Date startDate, Date endDate, BigDecimal minSerLen, BigDecimal maxSerLen, BigDecimal precision, List<DynamicObject> empPerSerLens, DynamicObject curEmpPerSerLen) {
        BigDecimal end;
        BigDecimal start;
        LinkedHashMap<String, Double> serlenMap = new LinkedHashMap<String, Double>();
        BigDecimal addCount = BigDecimal.ZERO;
        BigDecimal curAdjustcomtime = curEmpPerSerLen.getBigDecimal(ADJUSTCOMTIME);
        if (null == curAdjustcomtime) {
            curAdjustcomtime = BigDecimal.ZERO;
        }
        addCount = addCount.add(curAdjustcomtime);
        int indexOfCur = empPerSerLens.indexOf(curEmpPerSerLen);
        if (indexOfCur - 1 >= 0) {
            DynamicObject empPerSerLen = empPerSerLens.get(indexOfCur - 1);
            BigDecimal comsercount = empPerSerLen.getBigDecimal(COMSERCOUNT);
            if (null == comsercount) {
                comsercount = BigDecimal.ZERO;
            }
            addCount = addCount.add(comsercount);
        }
        if ((start = minSerLen.divide(precision, 0, RoundingMode.DOWN)).compareTo(end = maxSerLen.divide(precision, 0, RoundingMode.DOWN)) == 0) {
            BigDecimal len = start.multiply(precision).add(addCount);
            this.setDateRangeInMap(startDate, endDate, serlenMap, len);
        } else {
            Date firstDate = curEmpPerSerLen.getDate(JOINCOMDATE);
            while (firstDate.getTime() < startDate.getTime()) {
                firstDate = HRPerserlenHelper.getAddMonthDate((Date)curEmpPerSerLen.getDate(JOINCOMDATE), (Date)firstDate, (BigDecimal)precision);
            }
            this.diffPrecision(curEmpPerSerLen.getDate(JOINCOMDATE), startDate, endDate, precision, serlenMap, start, firstDate, addCount);
        }
        return serlenMap;
    }

    private Map<String, Double> continuousSocialWorkSerLenHandle(Date joinWorkTime, Date startDate, Date endDate, BigDecimal minSerLen, BigDecimal maxSerLen, BigDecimal precision, BigDecimal adjustTime) {
        BigDecimal end;
        LinkedHashMap<String, Double> serlenMap = new LinkedHashMap<String, Double>();
        BigDecimal start = minSerLen.divide(precision, 0, RoundingMode.DOWN);
        if (start.compareTo(end = maxSerLen.divide(precision, 0, RoundingMode.DOWN)) == 0) {
            BigDecimal len = start.multiply(precision).add(adjustTime);
            this.setDateRangeInMap(startDate, endDate, serlenMap, len);
        } else {
            this.diffPrecision(joinWorkTime, startDate, endDate, precision, serlenMap, start, adjustTime);
        }
        return serlenMap;
    }

    private void diffPrecision(Date joinWorkTime, Date startDate, Date endDate, BigDecimal precision, Map<String, Double> serlenMap, BigDecimal start, BigDecimal adjustTime) {
        Date firstDate = HRPerserlenHelper.getAddMonthDate((Date)joinWorkTime, (Date)joinWorkTime, (BigDecimal)precision);
        while (firstDate.getTime() < startDate.getTime()) {
            firstDate = HRPerserlenHelper.getAddMonthDate((Date)joinWorkTime, (Date)firstDate, (BigDecimal)precision);
        }
        this.diffPrecision(joinWorkTime, startDate, endDate, precision, serlenMap, start, firstDate, adjustTime);
    }

    private void diffPrecision(Date baseDate, Date startDate, Date endDate, BigDecimal precision, Map<String, Double> serlenMap, BigDecimal start, Date firstDate) {
        BigDecimal len;
        Date sDate;
        if (!firstDate.equals(startDate)) {
            this.setDateRangeInMap(startDate, HRDateTimeUtils.addDay((Date)firstDate, (long)-1L), serlenMap, start.multiply(precision));
        }
        Date eDate = firstDate;
        int i = 0;
        while (true) {
            sDate = eDate;
            eDate = HRPerserlenHelper.getAddMonthDate((Date)baseDate, (Date)eDate, (BigDecimal)precision);
            len = !firstDate.equals(startDate) ? start.add(new BigDecimal(i + 1)).multiply(precision) : start.add(new BigDecimal(i)).multiply(precision);
            if (eDate.compareTo(endDate) >= 0) break;
            this.setDateRangeInMap(sDate, HRDateTimeUtils.addDay((Date)eDate, (long)-1L), serlenMap, len);
            ++i;
        }
        this.setDateRangeInMap(sDate, endDate, serlenMap, len);
    }

    private void diffPrecision(Date baseDate, Date startDate, Date endDate, BigDecimal precision, Map<String, Double> serlenMap, BigDecimal start, Date firstDate, BigDecimal addCount) {
        BigDecimal len;
        Date sDate;
        if (firstDate.compareTo(startDate) != 0) {
            this.setDateRangeInMap(startDate, HRDateTimeUtils.addDay((Date)firstDate, (long)-1L), serlenMap, start.multiply(precision).add(addCount));
        }
        Date eDate = firstDate;
        int i = 0;
        while (true) {
            sDate = eDate;
            eDate = HRPerserlenHelper.getAddMonthDate((Date)baseDate, (Date)eDate, (BigDecimal)precision);
            len = firstDate.compareTo(startDate) != 0 ? start.add(new BigDecimal(i + 1)).multiply(precision) : start.add(new BigDecimal(i)).multiply(precision);
            if (eDate.compareTo(endDate) > 0) break;
            this.setDateRangeInMap(sDate, HRDateTimeUtils.addDay((Date)eDate, (long)-1L), serlenMap, len.add(addCount));
            ++i;
        }
        this.setDateRangeInMap(sDate, endDate, serlenMap, len.add(addCount));
    }

    private void setDateRangeInMap(Date startDate, Date endDate, Map<String, Double> serlenMap, BigDecimal len) {
        if (startDate.compareTo(endDate) > 0) {
            return;
        }
        String startDateStr = HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd");
        String endDateStr = HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
        serlenMap.put(startDateStr + "~" + endDateStr, len.doubleValue());
    }
}

