/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hrpi.business.domian.service.IHRPositionService;
import org.apache.commons.collections.CollectionUtils;

public class HRPositionServiceImpl
implements IHRPositionService {
    private static final Log LOG = LogFactory.getLog(HRPositionServiceImpl.class);
    private static volatile IHRPositionService HRPOSITIONSERVICE;
    private static final Integer success;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IHRPositionService getInstance() {
        try {
            if (null != HRPOSITIONSERVICE) return HRPOSITIONSERVICE;
            Class<HRPositionServiceImpl> clazz = HRPositionServiceImpl.class;
            synchronized (HRPositionServiceImpl.class) {
                if (null != HRPOSITIONSERVICE) return HRPOSITIONSERVICE;
                try {
                    HRPOSITIONSERVICE = new HRPositionServiceImpl();
                    LOG.info("HRPIServiceFactory-dependency-check,new-HRPositionServiceImpl()-success");
                }
                catch (Throwable t) {
                    LOG.error("HRPIServiceFactory-dependency-check,new-HRPositionServiceImpl()-fail", t);
                }
                return HRPOSITIONSERVICE;
            }
        }
        catch (Throwable t) {
            LOG.error("HRPIServiceFactory-dependency-check,HRPositionServiceImpl-getInstance()-fail", t);
        }
        return HRPOSITIONSERVICE;
    }

    @Override
    public Map<String, Map<String, Object>> addDarkPosByStdPos(List<Map<String, Object>> param) {
        HashMap darkPosMap = Maps.newHashMapWithExpectedSize((int)param.size());
        if (CollectionUtils.isNotEmpty(param)) {
            Map darkPosResult = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IStandardPositionService", (String)"addDarkPosition", (Object[])new Object[]{param});
            LOG.info("addDarkPosByStdPos#param:{},darkPosResult={}", param, (Object)darkPosResult);
            if (success.equals(darkPosResult.get("code"))) {
                List darkPosList = (List)darkPosResult.get("data");
                darkPosList.forEach(item -> {
                    Long org = (Long)item.get("org");
                    Long stdPos = (Long)item.get("standardposition");
                    Long user = (Long)item.get("user");
                    Date effect = (Date)item.get("effect");
                    Date bsled = (Date)item.get("bsled");
                    String key = String.join((CharSequence)"_", String.valueOf(org), String.valueOf(stdPos), String.valueOf(user), HRDateTimeUtils.formatDate((Date)effect), HRDateTimeUtils.formatDate((Date)bsled));
                    darkPosMap.put(key, item);
                });
            } else {
                LOG.error("\u8c03\u7528IStandardPositionService.addDarkPosition\u5f02\u5e38:{}", (Object)JSONObject.toJSONString((Object)darkPosResult));
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u201cIStandardPositionService.addDarkPosition\u201d\u5f02\u5e38\u3002", (String)"HRPositionServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
        return darkPosMap;
    }

    @Override
    public Map<String, Map<String, Object>> addDarkPosByJob(List<Map<String, Object>> param) {
        HashMap darkPosMap = Maps.newHashMapWithExpectedSize((int)param.size());
        if (CollectionUtils.isNotEmpty(param)) {
            Map darkPosResult = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IStandardPositionService", (String)"addDarkPositionByJob", (Object[])new Object[]{param});
            LOG.info("addDarkPosByJob#param:{},darkPosResult={}", param, (Object)darkPosResult);
            if (success.equals(darkPosResult.get("code"))) {
                List darkPosList = (List)darkPosResult.get("data");
                darkPosList.forEach(item -> {
                    Long org = (Long)item.get("org");
                    Long job = (Long)item.get("job");
                    Long user = (Long)item.get("user");
                    Date effect = (Date)item.get("effect");
                    Date bsled = (Date)item.get("bsled");
                    darkPosMap.put(String.join((CharSequence)"_", String.valueOf(org), String.valueOf(job), String.valueOf(user), HRDateTimeUtils.formatDate((Date)effect), HRDateTimeUtils.formatDate((Date)bsled)), item);
                });
            } else {
                LOG.error("\u8c03\u7528IStandardPositionService.addDarkPositionByJob\u5f02\u5e38:{}", (Object)JSONObject.toJSONString((Object)darkPosResult));
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u201cIStandardPositionService.addDarkPositionByJob\u201d\u5f02\u5e38\u3002", (String)"HRPositionServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
        return darkPosMap;
    }

    @Override
    public Map<String, Map<String, Object>> validateDarkPosByStdPos(List<Map<String, Object>> param) {
        HashMap darkPosMap = Maps.newHashMapWithExpectedSize((int)param.size());
        if (CollectionUtils.isNotEmpty(param)) {
            Map darkPosResult = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IStandardPositionService", (String)"validateAddDarkPosition", (Object[])new Object[]{param});
            LOG.info("addDarkPosByStdPos#param:{},darkPosResult={}", param, (Object)darkPosResult);
            if (success.equals(darkPosResult.get("code"))) {
                List darkPosList = (List)darkPosResult.get("data");
                darkPosList.forEach(item -> {
                    Long org = (Long)item.get("org");
                    Long stdPos = (Long)item.get("standardposition");
                    Long user = (Long)item.get("user");
                    Date effect = (Date)item.get("effect");
                    Date bsled = (Date)item.get("bsled");
                    String key = String.join((CharSequence)"_", String.valueOf(org), String.valueOf(stdPos), String.valueOf(user), HRDateTimeUtils.formatDate((Date)effect), HRDateTimeUtils.formatDate((Date)bsled));
                    darkPosMap.put(key, item);
                });
            } else {
                LOG.error("\u8c03\u7528IStandardPositionService.addDarkPosition\u5f02\u5e38:{}", (Object)JSONObject.toJSONString((Object)darkPosResult));
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u201cIStandardPositionService.validateDarkPosByStdPos\u201d\u5f02\u5e38\u3002", (String)"HRPositionServiceImpl_7", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
        return darkPosMap;
    }

    @Override
    public Map<String, Map<String, Object>> validateDarkPosByJob(List<Map<String, Object>> param) {
        HashMap darkPosMap = Maps.newHashMapWithExpectedSize((int)param.size());
        if (CollectionUtils.isNotEmpty(param)) {
            Map darkPosResult = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IStandardPositionService", (String)"validateAddDarkPositionByJob", (Object[])new Object[]{param});
            LOG.info("addDarkPosByJob#param:{},darkPosResult={}", param, (Object)darkPosResult);
            if (success.equals(darkPosResult.get("code"))) {
                List darkPosList = (List)darkPosResult.get("data");
                darkPosList.forEach(item -> {
                    Long org = (Long)item.get("org");
                    Long job = (Long)item.get("job");
                    Long user = (Long)item.get("user");
                    Date effect = (Date)item.get("effect");
                    Date bsled = (Date)item.get("bsled");
                    darkPosMap.put(String.join((CharSequence)"_", String.valueOf(org), String.valueOf(job), String.valueOf(user), HRDateTimeUtils.formatDate((Date)effect), HRDateTimeUtils.formatDate((Date)bsled)), item);
                });
            } else {
                LOG.error("\u8c03\u7528IStandardPositionService.addDarkPositionByJob\u5f02\u5e38:{}", (Object)JSONObject.toJSONString((Object)darkPosResult));
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u201cIStandardPositionService.validateDarkPosByJob\u201d\u5f02\u5e38\u3002", (String)"HRPositionServiceImpl_8", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
        return darkPosMap;
    }

    @Override
    public Map<String, Map<String, Object>> addDarkPositionForInit(List<Map<String, Object>> param) {
        HashMap darkPosMap = Maps.newHashMapWithExpectedSize((int)param.size());
        if (CollectionUtils.isNotEmpty(param)) {
            Map darkPosResult = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IInitPositionAndJobService", (String)"initAddDarkPosition", (Object[])new Object[]{param});
            LOG.info("addDarkPosByJob#param:{},darkPosResult={}", param, (Object)darkPosResult);
            if (success.equals(darkPosResult.get("code"))) {
                List darkPosList = (List)darkPosResult.get("data");
                darkPosList.forEach(item -> {
                    Long org = (Long)item.get("org");
                    Long stdPos = (Long)item.get("standardposition");
                    Long user = (Long)item.get("user");
                    Date effect = (Date)item.get("effect");
                    Date bsled = (Date)item.get("bsled");
                    String key = String.join((CharSequence)"_", String.valueOf(org), String.valueOf(stdPos), String.valueOf(user), HRDateTimeUtils.formatDate((Date)effect), HRDateTimeUtils.formatDate((Date)bsled));
                    darkPosMap.put(key, item);
                });
            } else {
                LOG.error("\u8c03\u7528IInitPositionAndJobService.initAddDarkPosition\u5f02\u5e38:{}", (Object)JSONObject.toJSONString((Object)darkPosResult));
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u201cIInitPositionAndJobService.initAddDarkPosition\u201d\u5f02\u5e38\u3002", (String)"HRPositionServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
        return darkPosMap;
    }

    @Override
    public Map<String, Map<String, Object>> addDarkPosByJobForInit(List<Map<String, Object>> param) {
        HashMap darkPosMap = Maps.newHashMapWithExpectedSize((int)param.size());
        if (CollectionUtils.isNotEmpty(param)) {
            Map darkPosResult = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IInitPositionAndJobService", (String)"initAddDarkPositionByJob", (Object[])new Object[]{param});
            LOG.info("addDarkPosByJob#param:{},darkPosResult={}", param, (Object)darkPosResult);
            if (success.equals(darkPosResult.get("code"))) {
                List darkPosList = (List)darkPosResult.get("data");
                darkPosList.forEach(item -> {
                    Long org = (Long)item.get("org");
                    Long job = (Long)item.get("job");
                    Long user = (Long)item.get("user");
                    Date effect = (Date)item.get("effect");
                    Date bsled = (Date)item.get("bsled");
                    String key = String.join((CharSequence)"_", String.valueOf(org), String.valueOf(job), String.valueOf(user), HRDateTimeUtils.formatDate((Date)effect), HRDateTimeUtils.formatDate((Date)bsled));
                    darkPosMap.put(key, item);
                });
            } else {
                LOG.error("\u8c03\u7528IInitPositionAndJobService.initAddDarkPositionByJob\u5f02\u5e38:{}", (Object)JSONObject.toJSONString((Object)darkPosResult));
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u201cIInitPositionAndJobService.initAddDarkPositionByJob\u201d\u5f02\u5e38\u3002", (String)"HRPositionServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
        return darkPosMap;
    }

    @Override
    public void disableDarkPosition(Object[] positionIds) {
        if (positionIds != null && positionIds.length > 0) {
            ArrayList params = Lists.newArrayListWithExpectedSize((int)positionIds.length);
            for (int i = 0; i < positionIds.length; ++i) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("position", positionIds[i]);
                params.add(param);
            }
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbpm", (String)"IStandardPositionService", (String)"disableDarkPosition", (Object[])new Object[]{params});
            if (!success.equals(result.get("code"))) {
                LOG.error("\u8c03\u7528IStandardPositionService.disableDarkPosition\u5f02\u5e38:{}", (Object)JSONObject.toJSONString((Object)result));
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u201cIStandardPositionService.disableDarkPosition\u201d\u5f02\u5e38\u3002", (String)"HRPositionServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void rollbackPosition(Long initBatch) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbpm", (String)"IInitPositionAndJobService", (String)"rollbackPosition", (Object[])new Object[]{initBatch});
        if (!success.equals(result.get("code"))) {
            LOG.error("\u8c03\u7528IInitPositionAndJobService.rollbackPosition\u5f02\u5e38:{}", (Object)JSONObject.toJSONString((Object)result));
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u201cIInitPositionAndJobService.rollbackPosition\u201d\u5f02\u5e38\u3002", (String)"HRPositionServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    @Override
    public void changePositionInitStatus(Long initBatch, String initStatus) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("initbatch", initBatch);
        param.put("initstatus", initStatus);
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbpm", (String)"IInitPositionAndJobService", (String)"refreshPositionInitStatus", (Object[])new Object[]{param});
        if (!success.equals(result.get("code"))) {
            LOG.error("\u8c03\u7528IInitPositionAndJobService.refreshPositionInitStatus\u5f02\u5e38:{}", (Object)JSONObject.toJSONString((Object)result));
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u201cIInitPositionAndJobService.refreshPositionInitStatus\u201d\u5f02\u5e38\u3002", (String)"HRPositionServiceImpl_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    static {
        success = 200;
    }
}

