/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hrpi.business.domian.service.IHbpmService;

public class HbpmServiceImpl
implements IHbpmService {
    private static final Log LOGGER = LogFactory.getLog(HbpmServiceImpl.class);
    private static final HbpmServiceImpl hbpmService = new HbpmServiceImpl();

    public static HbpmServiceImpl getInstance() {
        return hbpmService;
    }

    @Override
    public Map<Long, Long> getAdminOrgHis(List<Long> adminOrgIds) {
        return this.getAdminOrgHis(adminOrgIds, new Date());
    }

    @Override
    public Map<Long, Long> getStdPosHis(List<Long> stdPositionIds) {
        return this.getStdPosHis(stdPositionIds, new Date());
    }

    @Override
    public Map<Long, Long> getPosHis(List<Long> positionIds) {
        return this.getPosHis(positionIds, new Date());
    }

    @Override
    public Map<Long, Long> getJobHis(List<Long> jobIds) {
        return this.getJobHis(jobIds, new Date());
    }

    @Override
    public Long getAdminOrgHis(Long adminOrgId) {
        Map<Long, Long> result = this.getAdminOrgHis(Lists.newArrayList((Object[])new Long[]{adminOrgId}));
        return Optional.ofNullable(result.get(adminOrgId)).orElse(0L);
    }

    @Override
    public Long getPosHis(Long positionId) {
        Map<Long, Long> posHisMap = this.getPosHis(Lists.newArrayList((Object[])new Long[]{positionId}));
        return Optional.ofNullable(posHisMap.get(positionId)).orElse(0L);
    }

    @Override
    public Long getStdPosHis(Long stdPositionId) {
        Map<Long, Long> result = this.getStdPosHis(Lists.newArrayList((Object[])new Long[]{stdPositionId}));
        return Optional.ofNullable(result.get(stdPositionId)).orElse(0L);
    }

    @Override
    public Long getJobHis(Long jobId) {
        Map<Long, Long> jobHisMap = this.getJobHis(Lists.newArrayList((Object[])new Long[]{jobId}));
        return Optional.ofNullable(jobHisMap.get(jobId)).orElse(0L);
    }

    private void setHisPosCurIdHisId(Map<Long, Long> currIdHisIdMap, List<HashMap<String, Object>> list) {
        if (!CollectionUtils.isEmpty(list)) {
            for (HashMap<String, Object> map : list) {
                Object vid = map.get("id");
                Object id = map.get("boid");
                if (vid == null || id == null) continue;
                currIdHisIdMap.put((Long)id, (Long)vid);
            }
        }
    }

    private void filterEmpty(List<Long> ids) {
        LOGGER.info("before filter ids|{}", (Object)JSON.toJSONString(ids));
        ids.removeIf(HRObjectUtils::isEmpty);
        LOGGER.info("after filter ids|{}", (Object)JSON.toJSONString(ids));
    }

    @Override
    public Map<Long, Long> getAdminOrgHis(List<Long> adminOrgIds, Date date) {
        this.filterEmpty(adminOrgIds);
        LinkedHashMap<Long, Long> result = new LinkedHashMap<Long, Long>(adminOrgIds.size());
        if (adminOrgIds.isEmpty()) {
            return result;
        }
        try {
            Map adminOrgHisMap = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"adminOrgInfoQuery", (Object[])new Object[]{adminOrgIds, date});
            LOGGER.info("HbpmServiceImpl.getAdminOrgHis======adminOrgIds|{}adminOrgHisMap|{}", (Object)JSON.toJSONString(adminOrgIds), (Object)JSON.toJSONString((Object)adminOrgHisMap));
            if (CollectionUtils.isEmpty((Map)adminOrgHisMap)) {
                return result;
            }
            adminOrgHisMap.forEach((key, adminOrgHisInfo) -> result.put(Long.parseLong(key), HRJSONUtils.getLongValOfCustomParam(adminOrgHisInfo.get("vid"))));
            LOGGER.info("getAdminOrgHis result|{}", (Object)JSON.toJSONString(result));
        }
        catch (Exception ex) {
            LOGGER.error("HbpmServiceImpl.getAdminOrgHis======adminOrgId|{}  error..", adminOrgIds, (Object)ex);
        }
        return result;
    }

    @Override
    public Map<Long, Long> getStdPosHis(List<Long> stdPositionIds, Date date) {
        this.filterEmpty(stdPositionIds);
        LinkedHashMap<Long, Long> result = new LinkedHashMap<Long, Long>(stdPositionIds.size());
        if (stdPositionIds.isEmpty()) {
            return result;
        }
        try {
            Map personInfoMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IStandardPositionQueryService", (String)"queryStandardPosition", (Object[])new Object[]{stdPositionIds, date});
            LOGGER.info("HbpmServiceImpl.getStdPos======stdPositionId|{}getStdPos|{}", (Object)JSON.toJSONString(stdPositionIds), (Object)JSON.toJSONString((Object)personInfoMap));
            List dataMap = (List)personInfoMap.get("data");
            if (CollectionUtils.isEmpty((Collection)dataMap)) {
                return result;
            }
            dataMap.forEach(data -> result.put(HRJSONUtils.getLongValOfCustomParam(data.get("boid")), HRJSONUtils.getLongValOfCustomParam(data.get("id"))));
            LOGGER.info("getHisStdPos result|{}", (Object)JSON.toJSONString(result));
        }
        catch (Exception ex) {
            LOGGER.error("HbpmServiceImpl.getStdPos======stdPositionId|{}  error..", (Object)JSON.toJSONString(stdPositionIds), (Object)ex);
        }
        return result;
    }

    @Override
    public Map<Long, Long> getPosHis(List<Long> positionIds, Date date) {
        this.filterEmpty(positionIds);
        LinkedHashMap<Long, Long> currIdHisIdMap = new LinkedHashMap<Long, Long>(positionIds.size());
        if (positionIds.isEmpty()) {
            return currIdHisIdMap;
        }
        try {
            Map personInfoMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IPositionService", (String)"queryPositionHis", (Object[])new Object[]{positionIds, date});
            LOGGER.info("IPositionService queryPositionHis param|{} response|{}", (Object)JSON.toJSONString(positionIds), (Object)JSON.toJSONString((Object)personInfoMap));
            HashMap dataMap = (HashMap)personInfoMap.get("data");
            if (CollectionUtils.isEmpty((Map)dataMap)) {
                return currIdHisIdMap;
            }
            List list = (List)dataMap.get("hisdata");
            this.setHisPosCurIdHisId(currIdHisIdMap, list);
            LOGGER.info("getPosHis result|{}", (Object)JSON.toJSONString((Object)personInfoMap));
        }
        catch (Exception ex) {
            LOGGER.error("HbpmServiceImpl.getHisPos======positionId|{}  error..", positionIds, (Object)ex);
        }
        return currIdHisIdMap;
    }

    @Override
    public Map<Long, Long> getJobHis(List<Long> jobIds, Date date) {
        this.filterEmpty(jobIds);
        HashMap<Long, Long> currIdHisIdMap = new HashMap<Long, Long>(jobIds.size());
        if (jobIds.isEmpty()) {
            return currIdHisIdMap;
        }
        try {
            Map jobHisMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMHisVerService", (String)"selectJobHisinfo", (Object[])new Object[]{jobIds, date});
            LOGGER.info("IHBJMHisVerService selectJobHisinfo param response|{}", (Object)JSON.toJSONString(jobIds), (Object)JSON.toJSONString((Object)jobHisMap));
            if (CollectionUtils.isEmpty((Map)jobHisMap)) {
                return currIdHisIdMap;
            }
            List dataMap = (List)jobHisMap.get("data");
            if (CollectionUtils.isEmpty((Collection)dataMap)) {
                return currIdHisIdMap;
            }
            for (Map map : dataMap) {
                Object vid = map.get("id");
                Object id = map.get("boid");
                if (vid == null || id == null) continue;
                currIdHisIdMap.put((Long)id, Long.valueOf(vid.toString()));
            }
            LOGGER.info("getJobHis result|{}", (Object)JSON.toJSONString(currIdHisIdMap));
        }
        catch (Exception ex) {
            LOGGER.error("HbpmServiceImpl.getJobHis======jobBoid error..", (Throwable)ex);
        }
        return currIdHisIdMap;
    }
}

