/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelAttachController;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.api.attachment.HisAttachmentDataBo;
import kd.hr.hbp.business.domain.model.newhismodel.api.attachment.HisAttachmentParamBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.model.hismodel.HisAttachmentBo;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.service.IPerBankCardService;

public class PerBankCardServiceImpl
implements IPerBankCardService {
    private static Log LOGGER = LogFactory.getLog(PerBankCardServiceImpl.class);
    private static volatile IPerBankCardService PERBANKCARDSERVICE;
    private static final String HRPI_PERBANKCARD = "hrpi_perbankcard";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IPerBankCardService getInstance() {
        try {
            if (null != PERBANKCARDSERVICE) return PERBANKCARDSERVICE;
            Class<PerBankCardServiceImpl> clazz = PerBankCardServiceImpl.class;
            synchronized (PerBankCardServiceImpl.class) {
                if (null != PERBANKCARDSERVICE) return PERBANKCARDSERVICE;
                try {
                    PERBANKCARDSERVICE = new PerBankCardServiceImpl();
                    LOGGER.info("HRPIServiceFactory-dependency-check,new-PerBankCardServiceImpl()-success");
                }
                catch (Throwable t) {
                    LOGGER.error("HRPIServiceFactory-dependency-check,new-PerBankCardServiceImpl()-fail", t);
                }
                return PERBANKCARDSERVICE;
            }
        }
        catch (Throwable t) {
            LOGGER.error("HRPIServiceFactory-dependency-check,PerBankCardServiceImpl-getInstance()-fail", t);
        }
        return PERBANKCARDSERVICE;
    }

    @Override
    public boolean deletePerBankCard(Boolean isHasRight, List<Map<String, Object>> mapList) {
        DynamicObject[] perBankCardObjs = this.getPerBankCardDeleteObjs(mapList);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", String.valueOf(isHasRight));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"donothing_delete", (String)HRPI_PERBANKCARD, (DynamicObject[])perBankCardObjs, (OperateOption)operateOption);
        return operationResult.isSuccess();
    }

    @Override
    public boolean addPerBankCard(List<Map<String, Object>> mapList) {
        DynamicObject[] perBankCardObjs = this.getPerBankCardObjs(mapList);
        this.setDynamicObjectArray(perBankCardObjs, mapList);
        OperateOption operateOption = OperateOption.create();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)HRPI_PERBANKCARD, (DynamicObject[])perBankCardObjs, (OperateOption)operateOption);
        return operationResult.isSuccess();
    }

    @Override
    public boolean modifyPerBankCard(List<Map<String, Object>> mapList) {
        OperationResult operationResult = this.getHisVersionChangeResult(mapList);
        return operationResult.isSuccess();
    }

    @Override
    public boolean addPerBankCardNoPer(List<Map<String, Object>> mapList) {
        DynamicObject[] perBankCardObjs = this.getPerBankCardObjs(mapList);
        this.setDynamicObjectArray(perBankCardObjs, mapList);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)HRPI_PERBANKCARD, (DynamicObject[])perBankCardObjs, (OperateOption)operateOption);
        return operationResult.isSuccess();
    }

    @Override
    public Map<String, Object> addPerBankCardResult(Map<String, Object> param) {
        if (param == null) {
            return ApiResult.toMap((ApiResult)ApiResult.fail((String)"param is null"));
        }
        List mapList = (List)param.get("dataList");
        DynamicObject[] perBankCardObjs = this.getPerBankCardObjs(mapList);
        this.setDynamicObjectArray(perBankCardObjs, mapList);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", (String)param.getOrDefault("ishasright", "true"));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)HRPI_PERBANKCARD, (DynamicObject[])perBankCardObjs, (OperateOption)operateOption);
        return ApiResult.toMap((ApiResult)ApiResult.success((Object)operationResult));
    }

    @Override
    public Map<String, Object> modifyPerBankCardResult(Map<String, Object> param) {
        if (param == null) {
            return ApiResult.toMap((ApiResult)ApiResult.fail((String)"param is null"));
        }
        List mapList = (List)param.get("dataList");
        OperationResult operationResult = this.getHisVersionChangeResult(mapList);
        return ApiResult.toMap((ApiResult)ApiResult.success((Object)operationResult));
    }

    private OperationResult getHisVersionChangeResult(List<Map<String, Object>> mapList) {
        DynamicObject[] perBankCardObjs = this.getPerBankCardModifyObjs(mapList);
        this.setDynamicObjectArray(perBankCardObjs, mapList);
        Set<Long> idSet = Arrays.stream(perBankCardObjs).map(data -> (Long)data.get("id")).collect(Collectors.toSet());
        HisAttachmentDataBo attachmentBos = this.getAttachmentBos(idSet);
        HisResponse<VersionChangeRespData> hisResponse = this.modifyPerBankCardByHisModel(perBankCardObjs, attachmentBos.getMapHisAttachmentBos());
        this.uploadHisAttachment(attachmentBos);
        OperationResult operationResult = new OperationResult();
        if ("200".equals(hisResponse.getCode())) {
            operationResult.setSuccess(true);
        } else {
            operationResult.setSuccess(false);
            operationResult.setMessage(hisResponse.getErrorMessage());
        }
        return operationResult;
    }

    private DynamicObject[] getPerBankCardModifyObjs(List<Map<String, Object>> mapList) {
        HRBaseServiceHelper perBankCardServiceHelper = new HRBaseServiceHelper(HRPI_PERBANKCARD);
        List id = mapList.stream().map(map -> map.get("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", id);
        DynamicObject[] perBankcardArray = perBankCardServiceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        ArrayList<DynamicObject> perBankcardList = new ArrayList<DynamicObject>(mapList.size());
        long[] bankCardIds = DB.genLongIds((String)HRPI_PERBANKCARD, (int)mapList.size());
        for (int index = 0; index < mapList.size(); ++index) {
            DynamicObject perBankcard = perBankcardArray[index];
            HashSet ignoreField = Sets.newHashSet();
            ignoreField.add("id");
            ignoreField.add("sourcevid");
            DynamicObject perBankcardNew = perBankCardServiceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)perBankcard, (DynamicObject)perBankcardNew, (Set)ignoreField, (boolean)true);
            perBankcardNew.set("id", (Object)bankCardIds[index]);
            perBankcardList.add(perBankcardNew);
        }
        return perBankcardList.toArray(new DynamicObject[0]);
    }

    private DynamicObject[] getPerBankCardDeleteObjs(List<Map<String, Object>> mapList) {
        HRBaseServiceHelper perBankCardServiceHelper = new HRBaseServiceHelper(HRPI_PERBANKCARD);
        List id = mapList.stream().map(map -> map.get("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", id);
        DynamicObject[] objs = perBankCardServiceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        return objs;
    }

    private DynamicObject[] getPerBankCardObjs(List<Map<String, Object>> mapList) {
        HRBaseServiceHelper perBankCardServiceHelper = new HRBaseServiceHelper(HRPI_PERBANKCARD);
        DynamicObject[] objs = new DynamicObject[mapList.size()];
        for (int i = 0; i < mapList.size(); ++i) {
            DynamicObject obj = perBankCardServiceHelper.generateEmptyDynamicObject();
            obj.set("id", mapList.get(i).get("id"));
            objs[i] = obj;
        }
        return objs;
    }

    private void setDynamicObjectArray(DynamicObject[] objs, List<Map<String, Object>> mapList) {
        for (int i = 0; i < mapList.size(); ++i) {
            Map<String, Object> map = mapList.get(i);
            objs[i].set("username", map.get("username"));
            objs[i].set("bankdeposit", (Object)this.getDynamicObjectById("bd_bebank", (Long)map.get("bankdeposit.id")));
            List list = (List)map.get("cardpurpose.id");
            if (list.isEmpty()) {
                objs[i].set("cardpurpose", (Object)new DynamicObjectCollection());
            } else {
                objs[i].set("cardpurpose", (Object)this.getMulBaseDataDyColl(HRPI_PERBANKCARD, (List)map.get("cardpurpose.id"), "cardpurpose", "hbss_bankpurpose"));
            }
            objs[i].set("accountrelation", (Object)this.getDynamicObjectById("hbss_payrollacrelation", (Long)map.get("accountrelation.id")));
            objs[i].set("bankcardnum", map.get("bankcardnum"));
            objs[i].set("description", map.get("description"));
            objs[i].set("person", (Object)this.getDynamicObjectById("hrpi_person", (Long)map.get("person.id")));
            objs[i].set("employee", (Object)this.getDynamicObjectById("hrpi_employee", (Long)map.get("employee.id")));
            objs[i].set("modifier", (Object)RequestContext.get().getCurrUserId());
            objs[i].set("initdatasource", (Object)"0");
            objs[i].set("initstatus", (Object)"2");
            objs[i].set("boid", map.get("boid"));
            List attachmentData = (List)map.get("attachment");
            if (CollectionUtils.isEmpty((Collection)attachmentData)) continue;
            this.uploadAttachment(attachmentData, objs[i].getLong("id"));
            try (TXHandle txHandle = TX.requiresNew();){
                HashMap<String, List> attachemnts = new HashMap<String, List>(16);
                attachemnts.put("attachmentpanel", attachmentData);
                AttachmentServiceHelper.upload((String)HRPI_PERBANKCARD, (Object)objs[i].get("id"), (String)"attachmentpanel", (List)attachmentData);
                continue;
            }
        }
    }

    private HisAttachmentDataBo getAttachmentBos(Set<Long> idSet) {
        HisAttachmentParamBo attachmentParamBo = new HisAttachmentParamBo();
        attachmentParamBo.setEntityNumber(HRPI_PERBANKCARD);
        attachmentParamBo.setIdSet(idSet);
        HisResponse attachmentDataBo = HisModelAttachController.getInstance().generateAttachmentMap(attachmentParamBo);
        return (HisAttachmentDataBo)attachmentDataBo.getData();
    }

    private HisResponse<VersionChangeRespData> modifyPerBankCardByHisModel(DynamicObject[] perBankCardObjs, Map<Long, List<HisAttachmentBo>> mapHisAttachmentBos) {
        HisModelController hisModelController = new HisModelController();
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEntityNumber(HRPI_PERBANKCARD);
        hisVersionParamBo.setEffImmediately(true);
        hisVersionParamBo.setOperateType(EnumHisOperateType.NO_TIME_SAVE_VERSION.getType());
        hisVersionParamBo.setHisDyns(perBankCardObjs);
        hisVersionParamBo.setMapHisAttachmentBos(mapHisAttachmentBos);
        return hisModelController.noLineTimeHisVersionChange(hisVersionParamBo);
    }

    private void uploadHisAttachment(HisAttachmentDataBo attachmentDataBo) {
        HisModelAttachController.getInstance().uploadAttachmentMap(attachmentDataBo);
    }

    private void uploadAttachment(List<Map<String, Object>> attachmentData, Long id) {
        if (CollectionUtils.isEmpty(attachmentData)) {
            return;
        }
        for (int index = 0; index < attachmentData.size(); ++index) {
            Map<String, Object> attach = attachmentData.get(index);
            String url = String.valueOf(attach.get("url"));
            String name = String.valueOf(attach.get("name"));
            if (url.contains("tempfile/download.do?configKey")) {
                url = AttachmentServiceHelper.saveTempToFileService((String)url, (String)"hrpi", (String)HRPI_PERBANKCARD, (Object)id, (String)name);
            }
            attach.put("url", url);
            String uId = UUID.randomUUID().toString();
            uId = uId.replace("-", "");
            uId = uId.length() > 30 ? uId.substring(0, 30) : uId;
            attach.put("uid", uId + "-" + index);
            attach.put("entityNum", HRPI_PERBANKCARD);
            attach.put("fattachmentpanel", "attachmentpanel");
            attach.put("billPkId", String.valueOf(id));
            attach.put("lastModified", System.currentTimeMillis());
            this.setAttachmentData(attach);
        }
    }

    private void setAttachmentData(Map<String, Object> attachmentData) {
        String url = String.valueOf(attachmentData.get("url"));
        String previewUrl = String.valueOf(attachmentData.get("previewurl"));
        attachmentData.put("url", this.getRelativePath(url));
        attachmentData.put("previewurl", this.getRelativePath(previewUrl));
    }

    private String getRelativePath(String url) {
        if (HRStringUtils.isEmpty((String)url)) {
            return url;
        }
        if (url.contains("path=") && (url = url.substring(url.indexOf("path="), url.indexOf("&kdedcba"))).startsWith("path=")) {
            url = url.replaceFirst("path=", "");
        }
        try {
            String decode = URLDecoder.decode(url, "UTF-8");
            while (decode.startsWith("//")) {
                decode = decode.substring(1);
            }
            return decode;
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("saveAttachment error:", (Throwable)e);
            return url;
        }
    }

    private DynamicObjectCollection getMulBaseDataDyColl(String entityName, List<Long> fieldValueIds, String fieldName, String mulBasedataEntity) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        DynamicObject dyObj = helper.generateEmptyDynamicObject();
        DynamicObjectCollection dyColl = dyObj.getDynamicObjectCollection(fieldName);
        if (CollectionUtils.isEmpty(fieldValueIds)) {
            return dyColl;
        }
        DynamicObjectType dynamicObjectType = dyColl.getDynamicObjectType();
        for (Long fieldValueId : fieldValueIds) {
            DynamicObject mulBasedataDy = new DynamicObject(dynamicObjectType);
            DynamicObject personDy = this.getDynamicObjectById(mulBasedataEntity, fieldValueId);
            mulBasedataDy.set("fbasedataid", (Object)personDy);
            dyColl.add((Object)mulBasedataDy);
        }
        return dyColl;
    }

    private DynamicObject getDynamicObjectById(String entityName, Long id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return id == null || id == 0L ? null : new DynamicObject((DynamicObjectType)type, (Object)id);
    }
}

