/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hrpi.business.domian.service.IPerfResultService;

public class PerfResultServiceImpl
implements IPerfResultService {
    private static final Log LOGGER = LogFactory.getLog(PerfResultServiceImpl.class);
    private static final IPerfResultService PERFRESULTSERVICE = new PerfResultServiceImpl();
    public static final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_perfresult");

    public static IPerfResultService getInstance() {
        return PERFRESULTSERVICE;
    }

    @Override
    public boolean sysPerfResult(List<Map<String, Object>> paramList) {
        LOGGER.info("sysPerfResult param : {} ", paramList);
        if (ObjectUtils.isEmpty(paramList)) {
            return true;
        }
        Set boIdList = paramList.stream().map(param -> param.get("boid")).collect(Collectors.toSet());
        QFilter boIdFilter = new QFilter("boid", "in", boIdList);
        serviceHelper.deleteByFilter(new QFilter[]{boIdFilter});
        ArrayList<DynamicObject> perfResultList = new ArrayList<DynamicObject>(paramList.size());
        for (Map<String, Object> param2 : paramList) {
            DynamicObject perfResult = serviceHelper.generateEmptyDynamicObject();
            DataEntityPropertyCollection properties = perfResult.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                if (param2.get(property.getName()) == null) continue;
                if (property instanceof EntryProp) {
                    this.initEntryEntity(param2, perfResult, property.getName());
                    continue;
                }
                perfResult.set(property.getName(), param2.get(property.getName()));
            }
            perfResult.set("initstatus", (Object)"2");
            perfResultList.add(perfResult);
        }
        serviceHelper.save(perfResultList.toArray(new DynamicObject[0]));
        return true;
    }

    private void initEntryEntity(Map<String, Object> param, DynamicObject perfResult, String entryEntity) {
        DynamicObjectCollection entity = perfResult.getDynamicObjectCollection(entryEntity);
        List entityParams = (List)param.get(entryEntity);
        for (Map entityParam : entityParams) {
            DynamicObject levelResultDy = entity.addNew();
            DataEntityPropertyCollection levelResultProps = levelResultDy.getDataEntityType().getProperties();
            for (IDataEntityProperty levelResultProp : levelResultProps) {
                if (entityParam.get(levelResultProp.getName()) == null) continue;
                levelResultDy.set(levelResultProp.getName(), entityParam.get(levelResultProp.getName()));
            }
        }
    }

    @Override
    public List<DynamicObject> queryPerfResultByEmployee(List<Long> employeeIds, Boolean isHis) {
        QFilter hisFilter;
        Object[] dys;
        LOGGER.info("queryPerfResultByEmployee param\uff0cemployeeIds\uff1a{}\uff0c isHis\uff1a{} ", employeeIds, (Object)isHis);
        if (ObjectUtils.isEmpty(employeeIds)) {
            return new ArrayList<DynamicObject>(10);
        }
        QFilter employeeFilter = new QFilter("employee", "in", employeeIds).and("datastatus", "=", (Object)"1");
        if (isHis == null) {
            isHis = false;
        }
        if (ObjectUtils.isEmpty((Object[])(dys = serviceHelper.loadDynamicObjectArray(new QFilter[]{employeeFilter, hisFilter = new QFilter("iscurrentversion", "=", (Object)(isHis == false ? 1 : 0))})))) {
            return new ArrayList<DynamicObject>(10);
        }
        return Arrays.asList(dys);
    }
}

