/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.application.charge.IChargeApplication;
import kd.hrmp.hrpi.business.application.impl.charge.ChargeApplicationImpl;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRolerelRepository;
import kd.hrmp.hrpi.business.domian.service.IPersonRoleService;
import kd.hrmp.hrpi.business.domian.service.superior.PersonSuperiorFetchHelper;
import kd.hrmp.hrpi.business.domian.service.superior.handler.common.SuperiorCommonParamParse;
import kd.hrmp.hrpi.business.domian.service.superior.handler.impl.AddSuperiorHandlerImpl;
import kd.hrmp.hrpi.business.domian.service.superior.handler.impl.DelSuperiorHandlerImpl;
import kd.hrmp.hrpi.business.domian.service.superior.handler.impl.ExpireSuperiorHandlerImpl;
import kd.hrmp.hrpi.business.domian.service.superior.handler.impl.UpdateSuperiorHandlerImpl;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.common.entity.SuperiorEntity;

public class PersonRoleServiceImpl
implements IPersonRoleService {
    private static final Log logger = LogFactory.getLog(PersonRoleServiceImpl.class);
    private static volatile IPersonRoleService PERSONROLESERVICE;
    private final IChargeApplication chargeApplication = new ChargeApplicationImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IPersonRoleService getInstance() {
        try {
            if (null != PERSONROLESERVICE) return PERSONROLESERVICE;
            Class<PersonRoleServiceImpl> clazz = PersonRoleServiceImpl.class;
            synchronized (PersonRoleServiceImpl.class) {
                if (null != PERSONROLESERVICE) return PERSONROLESERVICE;
                try {
                    PERSONROLESERVICE = new PersonRoleServiceImpl();
                    logger.info("HRPIServiceFactory-dependency-check,new-PersonRoleServiceImpl()-success");
                }
                catch (Throwable t) {
                    logger.error("HRPIServiceFactory-dependency-check,new-PersonRoleServiceImpl()-fail", t);
                }
                return PERSONROLESERVICE;
            }
        }
        catch (Throwable t) {
            logger.error("HRPIServiceFactory-dependency-check,PersonRoleServiceImpl-getInstance()-fail", t);
        }
        return PERSONROLESERVICE;
    }

    @Override
    public Map<Long, List<Map<String, Object>>> getDirectSuperiorByDepempId(List<Long> depempIds) {
        return this.getSuperior("depemp.id", depempIds, DateUtil.getCurrentDate());
    }

    @Override
    public Map<Long, List<Map<String, Object>>> getDirectSuperior(List<Long> personIds) {
        return this.getSuperior("person.id", personIds, DateUtil.getCurrentDate());
    }

    @Override
    public Map<Long, List<Map<String, Object>>> getDirectSuperior(List<Long> personIds, Date queryDate) {
        return this.getSuperior("person.id", personIds, queryDate);
    }

    @Override
    public Map<Long, List<Map<String, Object>>> getDirectSuperiorByDepempId(List<Long> depempIds, Date queryDate) {
        return this.getSuperior("depemp.id", depempIds, queryDate);
    }

    private void treatJobAndStdPos(Map<Long, List<Map<String, Object>>> resultMap, String tag, List<Map<String, Object>> aPartParamList) {
        HashMap infInParamMap = Maps.newHashMapWithExpectedSize((int)16);
        List orgIdList = aPartParamList.stream().map(map -> (Long)map.get("org")).collect(Collectors.toList());
        HashMap personIdVsOrgIdListMap = Maps.newHashMapWithExpectedSize((int)orgIdList.size());
        for (Map<String, Object> paramMap : aPartParamList) {
            Long org = this.getLongValueFromMap(paramMap, "org");
            Long person = this.getLongValueFromMap(paramMap, "person");
            HashSet orgIdSet = Sets.newHashSetWithExpectedSize((int)2);
            orgIdSet.add(org);
            personIdVsOrgIdListMap.put(person, orgIdSet);
        }
        infInParamMap.put("org", orgIdList);
        String relationMapOrgKey = "orgRelationMap";
        infInParamMap.put(relationMapOrgKey, personIdVsOrgIdListMap);
        logger.info("invoke getSuperior infInParamMap={}", (Object)infInParamMap, (Object)tag);
        Map<Long, List<Map<String, Object>>> superiorResult = PersonSuperiorFetchHelper.getSuperior(infInParamMap, new Date(), tag);
        resultMap.putAll(superiorResult);
    }

    private void treatPositionType(Map<Long, List<Map<String, Object>>> resultMap, String tag, List<Map<String, Object>> aPartParamList) {
        HashMap infInParamMap = Maps.newHashMapWithExpectedSize((int)16);
        List roleIdList = aPartParamList.stream().map(map -> (Long)map.get("role")).collect(Collectors.toList());
        List orgIdList = aPartParamList.stream().map(map -> (Long)map.get("org")).collect(Collectors.toList());
        HashMap personIdVsRoleIdListMap = Maps.newHashMapWithExpectedSize((int)roleIdList.size());
        HashMap personIdVsOrgIdListMap = Maps.newHashMapWithExpectedSize((int)orgIdList.size());
        for (Map<String, Object> paramMap : aPartParamList) {
            Long role = this.getLongValueFromMap(paramMap, "role");
            Long org = this.getLongValueFromMap(paramMap, "org");
            Long person = this.getLongValueFromMap(paramMap, "person");
            HashSet roleIdSet = Sets.newHashSetWithExpectedSize((int)2);
            HashSet orgIdSet = Sets.newHashSetWithExpectedSize((int)2);
            roleIdSet.add(role);
            orgIdSet.add(org);
            personIdVsRoleIdListMap.put(person, roleIdSet);
            personIdVsOrgIdListMap.put(person, orgIdSet);
        }
        String relationMapRoleKey = "roleRelationMap";
        String relationMapOrgKey = "orgRelationMap";
        infInParamMap.put("role", roleIdList);
        infInParamMap.put("org", orgIdList);
        infInParamMap.put(relationMapRoleKey, personIdVsRoleIdListMap);
        infInParamMap.put(relationMapOrgKey, personIdVsOrgIdListMap);
        logger.info("invoke getSuperior infInParamMap={}", (Object)infInParamMap, (Object)tag);
        Map<Long, List<Map<String, Object>>> superiorResult = PersonSuperiorFetchHelper.getSuperior(infInParamMap, new Date(), tag);
        resultMap.putAll(superiorResult);
    }

    private Long getLongValueFromMap(Map<String, Object> map, String fieldName) {
        Object objValue = map.get(fieldName);
        if (Objects.nonNull(objValue)) {
            return (Long)objValue;
        }
        return 0L;
    }

    @Override
    public Map<Long, List<Map<String, Object>>> listSuperior(List<Map<String, Object>> paramList) {
        logger.info("listSuperior paramList={}", paramList);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)paramList.size());
        if (CollectionUtils.isEmpty(paramList)) {
            return resultMap;
        }
        try {
            Iterator<Map<String, Object>> iterator = paramList.iterator();
            while (iterator.hasNext()) {
                Map<String, Object> param = iterator.next();
                if (Objects.isNull(param.get("person"))) {
                    return Maps.newHashMapWithExpectedSize((int)0);
                }
                StringBuilder sb = new StringBuilder();
                List<String> fieldList = Arrays.asList("tag", "org", "apositiontype", "querydate");
                for (String field : fieldList) {
                    if (!Objects.isNull(param.get(field))) continue;
                    sb.append(String.format("%s is empty!", field));
                }
                if (Objects.nonNull(param.get("apositiontype")) && HRStringUtils.equals((String)((String)param.get("apositiontype")), (String)"1") && Objects.isNull(param.get("role"))) {
                    sb.append("role is empty!");
                }
                if (HRStringUtils.isEmpty((String)sb.toString())) continue;
                Long personId = (Long)param.get("person");
                ArrayList resultList = Lists.newArrayListWithExpectedSize((int)1);
                HashMap map2 = Maps.newHashMapWithExpectedSize((int)1);
                map2.put("errMsg", sb.toString());
                resultList.add(map2);
                resultMap.put(personId, resultList);
                iterator.remove();
            }
            Map<String, List<Map>> tagVsParamListMap = paramList.stream().collect(Collectors.groupingBy(map -> (String)map.get("tag")));
            for (Map.Entry<String, List<Map>> tagEntry : tagVsParamListMap.entrySet()) {
                String tag = tagEntry.getKey();
                List<Map> partParamList = tagEntry.getValue();
                Map<String, List<Map>> aPositionTypeVsParamListMap = partParamList.stream().collect(Collectors.groupingBy(map -> (String)map.get("apositiontype")));
                for (Map.Entry<String, List<Map>> entry : aPositionTypeVsParamListMap.entrySet()) {
                    String aPositionType = entry.getKey();
                    List<Map<String, Object>> aPartParamList = entry.getValue();
                    if (HRStringUtils.equals((String)aPositionType, (String)"1")) {
                        this.treatPositionType(resultMap, tag, aPartParamList);
                        continue;
                    }
                    this.treatJobAndStdPos(resultMap, tag, aPartParamList);
                }
            }
        }
        catch (Exception ex) {
            logger.error("listSuperior error", (Throwable)ex);
            return Maps.newHashMapWithExpectedSize((int)1);
        }
        return resultMap;
    }

    private Map<Long, List<Map<String, Object>>> getSuperior(String queryKey, List<Long> ids, Date queryDate) {
        logger.info("getDirectSuperior {} start : ids {}", (Object)queryKey, ids);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        if ("depemp.id".equals(queryKey)) {
            paramMap.put("depemp", ids);
        } else {
            paramMap.put("person", ids);
        }
        return PersonSuperiorFetchHelper.getSuperior(paramMap, queryDate);
    }

    private Map<Long, Set<Long>> getPersonParentRole(List<Long> ids, Multimap<Long, Long> personRoleMap, Map<Long, Long> allParentRelationIds) {
        HashMap<Long, Set<Long>> personParentRoles = new HashMap<Long, Set<Long>>(ids.size());
        for (Map.Entry personRole : personRoleMap.entries()) {
            Long parentId = allParentRelationIds.get(personRole.getValue());
            if (null == parentId || parentId <= 0L) continue;
            HashSet<Long> parentRoleList = (HashSet<Long>)personParentRoles.get(personRole.getKey());
            if (null == parentRoleList) {
                parentRoleList = new HashSet<Long>();
            }
            parentRoleList.add(parentId);
            personParentRoles.put((Long)personRole.getKey(), (Set<Long>)parentRoleList);
        }
        return personParentRoles;
    }

    private static List<DynamicObject> findSuperiorList(Map<Long, List<DynamicObject>> result, Set<Long> parentRoles) {
        LinkedList<DynamicObject> superiorList = new LinkedList<DynamicObject>();
        parentRoles.forEach(roleId -> {
            List infoList = (List)result.get(roleId);
            if (null != infoList) {
                superiorList.addAll(infoList);
            }
        });
        return superiorList;
    }

    @Override
    public List<Map<String, Object>> getSuperiorByRole(List<Long> roleIds) {
        Object[] superiorDyCols;
        logger.info("getSuperiorByRole start : roleIds {}", roleIds);
        Map<Long, Long> parentRoleIds = PersonRoleServiceImpl.getAllParentRelationIds(new HashSet<Long>(roleIds));
        logger.info("getSuperiorByRole start : parentRoleIds {}", parentRoleIds);
        if (!parentRoleIds.isEmpty() && !HRArrayUtils.isEmpty((Object[])(superiorDyCols = HRPIPersonRolerelRepository.getParentRoleRel(new HashSet<Long>(parentRoleIds.values()), DateUtil.getCurrentDate())))) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(superiorDyCols.length);
            this.addSuperiorList(list, Arrays.asList(superiorDyCols));
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public Map<Long, List<Map<String, Object>>> listSuperiorByOrg(List<Long> roleIds) {
        Object[] superiorDyCols;
        logger.info("listSuperiorByOrg start : roleIds {}", roleIds);
        Map<Long, Long> parentRoleIds = PersonRoleServiceImpl.getAllParentRelationIds(new HashSet<Long>(roleIds));
        logger.info("listSuperiorByOrg start : parentRoleIds {}", parentRoleIds);
        if (!parentRoleIds.isEmpty() && !HRArrayUtils.isEmpty((Object[])(superiorDyCols = HRPIPersonRolerelRepository.getParentRoleRel(new HashSet<Long>(parentRoleIds.values()))))) {
            Map<Long, List<DynamicObject>> superiorParentGroup = Arrays.stream(superiorDyCols).collect(Collectors.groupingBy(dy -> dy.getLong("role.id")));
            HashMap<Long, List<Map<String, Object>>> result = new HashMap<Long, List<Map<String, Object>>>(superiorParentGroup.size());
            for (Map.Entry<Long, Long> roleInfo : parentRoleIds.entrySet()) {
                Long parentRoleId = roleInfo.getValue();
                List<DynamicObject> superiorList = superiorParentGroup.get(parentRoleId);
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(superiorList.size());
                this.addSuperiorList(list, superiorList);
                result.put(roleInfo.getKey(), list);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    private void addSuperiorList(List<Map<String, Object>> result, List<DynamicObject> superiorList) {
        for (DynamicObject superior : superiorList) {
            HashMap<String, Object> infoMap = new HashMap<String, Object>(16);
            infoMap.put("superior.number", superior.getString("person.number"));
            infoMap.put("superior.name", superior.getString("person.name"));
            infoMap.put("superior.headsculpture", superior.getString("person.headsculpture"));
            infoMap.put("superioradminorg.id", superior.getLong("adminorg.id"));
            infoMap.put("superioradminorg.name", superior.getString("adminorg.name"));
            infoMap.put("superioradminorg.number", superior.getString("adminorg.number"));
            infoMap.put("person.id", superior.getLong("person.id"));
            infoMap.put("depemp.id", superior.getLong("depemp.id"));
            infoMap.put("employee.id", superior.getLong("employee.id"));
            result.add(infoMap);
        }
    }

    private static Map<Long, Long> getAllParentRelationIds(Set<Long> roleIds) {
        List<DynamicObject> roleList = HRPIPersonRolerelRepository.getAllParentRelations(roleIds);
        logger.info(" parentRelationIds info {}", roleList);
        HashMap<Long, Long> parentRoleIds = new HashMap<Long, Long>(roleList.size());
        roleList.stream().filter(role -> roleIds.contains(role.getLong("role.id"))).forEach(parRole -> parentRoleIds.put(parRole.getLong("role.id"), parRole.getLong("parent.id")));
        return parentRoleIds;
    }

    private static Map<Long, Long> getAllParentRelationIds(Set<Long> roleIds, Date queryDate) {
        List<DynamicObject> roleList = HRPIPersonRolerelRepository.getAllParentRelations(roleIds, queryDate);
        logger.info(" parentRelationIds info {}", roleList);
        HashMap<Long, Long> parentRoleIds = new HashMap<Long, Long>(roleList.size());
        roleList.stream().filter(role -> roleIds.contains(role.getLong("role.id"))).forEach(parRole -> parentRoleIds.put(parRole.getLong("role.id"), parRole.getLong("parent.id")));
        return parentRoleIds;
    }

    @Override
    public List<Map<String, Object>> getSuperiorByOrg(List<Long> orgIds) {
        Map orgList;
        logger.info("getSuperiorByOrg start : orgIds {}", orgIds);
        try {
            orgList = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgStructQueryService", (String)"adminOrgStructQuery", (Object[])new Object[]{orgIds, new Date(), Boolean.FALSE});
            logger.info("getSuperiorByOrg parentOrgList {}", (Object)orgList);
        }
        catch (Exception ex) {
            logger.error("getSuperiorByOrg orgIds:{} error:{}", (Object)orgIds.toArray(), (Object)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5f02\u5e38\u3002", (String)"PersonRoleServiceImpl_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (null != orgList && orgList.size() > 0) {
            ArrayListMultimap parentOrgId = ArrayListMultimap.create();
            for (Map.Entry parentOrgMap : orgList.entrySet()) {
                Map parent = (Map)parentOrgMap.getValue();
                parentOrgId.put((Object)((Long)parent.get("parentorg")), (Object)Long.valueOf((String)parentOrgMap.getKey()));
            }
            if (!parentOrgId.isEmpty()) {
                List<Map<String, Object>> mainChargeInfoByOrg = this.getMainChargeInfoByOrg(new ArrayList<Long>(parentOrgId.keySet()), null);
                mainChargeInfoByOrg.forEach(arg_0 -> PersonRoleServiceImpl.lambda$getSuperiorByOrg$11((Multimap)parentOrgId, arg_0));
                return mainChargeInfoByOrg;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<Map<String, Object>> getMainChargeByOrg(List<Long> orgIdList) {
        return this.getMainChargeInfoByOrg(orgIdList, null);
    }

    @Override
    public List<Map<String, Object>> getMainChargeInfoByOrg(List<Long> orgIdList, Date queryDate) {
        logger.info("getMainChargeInfoByOrg start : orgIdList {}", orgIdList);
        Map<Long, List<Map<String, Object>>> mainChargeMap = null;
        try {
            mainChargeMap = this.chargeApplication.queryChargePersonByOrgId(orgIdList, queryDate);
        }
        catch (Exception ex) {
            logger.error("queryChargePersonByOrgId error", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25", (String)"PersonRoleServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (HRMapUtils.isEmpty(mainChargeMap)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> ResultList = new ArrayList<Map<String, Object>>(mainChargeMap.size());
        mainChargeMap.forEach((key, entryValue) -> {
            if (!CollectionUtils.isEmpty((Collection)entryValue)) {
                for (Map result : entryValue) {
                    result.put("startdate", result.get("effdt"));
                    result.put("enddate", result.get("leffdt"));
                    result.put("employee", result.get("employee.id"));
                    result.put("role", result.get("workrole.name"));
                    result.put("businessstatus", result.get("datastatus"));
                    ResultList.add(result);
                }
            }
        });
        return ResultList;
    }

    @Override
    public HrApiResponse<Map<String, Object>> addSuperior(List<Map<String, Object>> superiorList) {
        return this.handleSuperiorRel(superiorList, "add");
    }

    @Override
    public HrApiResponse<Map<String, Object>> updateSuperior(List<Map<String, Object>> superiorList) {
        return this.handleSuperiorRel(superiorList, "update");
    }

    @Override
    public HrApiResponse<Map<String, Object>> expireSuperior(List<Map<String, Object>> superiorList) {
        return this.handleSuperiorRel(superiorList, "expire");
    }

    @Override
    public HrApiResponse<Map<String, Object>> delSuperior(List<Map<String, Object>> superiorList) {
        return this.handleSuperiorRel(superiorList, "delete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HrApiResponse<Map<String, Object>> handleSuperiorRel(List<Map<String, Object>> superiorList, String methodType) {
        logger.info("###{}SuperiorInterface-start {}", (Object)methodType, superiorList);
        ArrayList<Map<String, Object>> handleSuperList = new ArrayList<Map<String, Object>>(superiorList);
        HrApiResponse hrApiResponseResults = new HrApiResponse();
        HashMap<String, Object> retMap = new HashMap<String, Object>(16);
        SuperiorEntity superiorEntity = new SuperiorEntity(handleSuperList, new DynamicObjectCollection(), new DynamicObjectCollection(), new DynamicObjectCollection(), new DynamicObjectCollection(), methodType, new HashMap(10));
        try {
            if (CollectionUtils.isEmpty(handleSuperList)) {
                HrApiResponse hrApiResponse = HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)"param is empty please check");
                return hrApiResponse;
            }
            this.handleSuperior(superiorEntity);
            Map failMap = superiorEntity.getFailMap();
            retMap.put("fail", failMap);
            hrApiResponseResults.setSuccess(true);
            if (HRMapUtils.isEmpty((Map)failMap)) {
                hrApiResponseResults.setCode(EnumResponseCode.SUCCESS.getCode());
            } else {
                hrApiResponseResults.setCode("202");
            }
            hrApiResponseResults.setData(retMap);
        }
        catch (Exception exception) {
            logger.error("###{}SuperiorInterface--error", (Object)methodType, (Object)exception);
            HrApiResponse hrApiResponse = HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)exception.getMessage());
            return hrApiResponse;
        }
        finally {
            SuperiorCommonParamParse.getInstance().printSaveInfo(superiorEntity, retMap);
        }
        return hrApiResponseResults;
    }

    private void handleSuperior(SuperiorEntity superiorEntity) {
        switch (superiorEntity.getMethodType()) {
            case "add": {
                AddSuperiorHandlerImpl addSuperiorHandler = new AddSuperiorHandlerImpl();
                addSuperiorHandler.validateAndSaveDate(superiorEntity);
                break;
            }
            case "update": {
                UpdateSuperiorHandlerImpl updateSuperiorHandler = new UpdateSuperiorHandlerImpl();
                updateSuperiorHandler.validateAndSaveDate(superiorEntity);
                break;
            }
            case "expire": {
                ExpireSuperiorHandlerImpl expireSuperiorHandler = new ExpireSuperiorHandlerImpl();
                expireSuperiorHandler.validateAndSaveDate(superiorEntity);
                break;
            }
            case "delete": {
                DelSuperiorHandlerImpl delSuperiorHandler = new DelSuperiorHandlerImpl();
                delSuperiorHandler.validateAndSaveDate(superiorEntity);
                break;
            }
        }
    }

    private static /* synthetic */ void lambda$getSuperiorByOrg$11(Multimap parentOrgId, Map mainChargeInfo) {
        Long adminPrentOrgId = (Long)mainChargeInfo.get("adminorg");
        Collection longs = parentOrgId.get((Object)adminPrentOrgId);
        long adminOrgId = longs.stream().findFirst().orElse(0L);
        mainChargeInfo.put("queryadminorg", adminOrgId);
    }
}

