/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.qing.util.MapUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.LogPrivacyUtil;
import kd.hrmp.hrpi.business.domian.repository.HRPIBosUserRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.business.domian.repository.RepositoryUtil;
import kd.hrmp.hrpi.business.domian.service.IPersonService;
import kd.hrmp.hrpi.business.helper.HRPIBusinessDataServiceHelper;
import kd.hrmp.hrpi.business.helper.ResultBuilder;
import kd.hrmp.hrpi.business.helper.ValidateHelper;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.business.tools.StaffAdminorgConfigUtil;
import kd.hrmp.hrpi.common.HRPIValueConstants;
import kd.hrmp.hrpi.common.entity.CheckPersonEntity;
import kd.hrmp.hrpi.common.enums.ErrorCodeEnum;

public class PersonServiceImpl
implements IPersonService<DynamicObject> {
    private static final Log LOGGER = LogFactory.getLog(PersonServiceImpl.class);
    private static final long HBSS_POSTCATEGORY_1010_S = 1010L;
    private static volatile IPersonService PERSONSERVICE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IPersonService getInstance() {
        try {
            if (null != PERSONSERVICE) return PERSONSERVICE;
            Class<PersonServiceImpl> clazz = PersonServiceImpl.class;
            synchronized (PersonServiceImpl.class) {
                if (null != PERSONSERVICE) return PERSONSERVICE;
                try {
                    PERSONSERVICE = new PersonServiceImpl();
                    LOGGER.info("HRPIServiceFactory-dependency-check,new-PersonServiceImpl()-success");
                }
                catch (Throwable t) {
                    LOGGER.error("HRPIServiceFactory-dependency-check,new-PersonServiceImpl()-fail", t);
                }
                return PERSONSERVICE;
            }
        }
        catch (Throwable t) {
            LOGGER.error("HRPIServiceFactory-dependency-check,PersonServiceImpl-getInstance()-fail", t);
        }
        return PERSONSERVICE;
    }

    @Override
    public Map<String, Object> getPersonBaseInfo(Long personId) {
        if (personId <= 0L) {
            return new HashMap<String, Object>(0);
        }
        List<DynamicObject> personEntityDynamicArray = this.getPersonEntityDynamicArray(personId, false, false);
        return personEntityDynamicArray.isEmpty() ? new HashMap(0) : DynamicTransformUtil.dynamicObjectsToMap(personEntityDynamicArray);
    }

    @Override
    public Map<String, Object> getPersonInfo(Long personId) {
        if (personId <= 0L) {
            return new HashMap<String, Object>(0);
        }
        List<DynamicObject> personEntityDynamicArray = this.getPersonEntityDynamicArray(personId, true, false);
        return personEntityDynamicArray.isEmpty() ? new HashMap(0) : DynamicTransformUtil.dynamicObjectsToMap(personEntityDynamicArray);
    }

    @Override
    public List<Map<String, Object>> listPersonInfos(List<Long> personIds) {
        if (CollectionUtils.isEmpty(personIds)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        Map<Long, List<DynamicObject>> personInfoMap = this.listPersonEntityDynamicArray(personIds, true, false);
        return personInfoMap.isEmpty() ? new ArrayList<Map<String, Object>>(0) : personInfoMap.values().stream().map(DynamicTransformUtil::dynamicObjectsToMap).collect(Collectors.toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<DynamicObject> getPersonEntityDynamicArray(Long personId, boolean hasOrg, boolean hasLeaders) {
        ArrayList<DynamicObject> dyLists = new ArrayList<DynamicObject>();
        try {
            DynamicObject primaryEmpposorgrel;
            List<Long> personIds = Collections.singletonList(personId);
            Object[] personDynamics = HRPIPersonRepository.listPersons(personIds);
            if (HRArrayUtils.isEmpty((Object[])personDynamics)) return dyLists;
            dyLists.add((DynamicObject)personDynamics[0]);
            this.addQueryInfo(dyLists, HRPIPersonRepository.listPernontsprops(personIds));
            this.addQueryInfo(dyLists, HRPIPersonRepository.listPertsprops(personIds));
            if (hasOrg && (primaryEmpposorgrel = HRPIPersonRepository.getPrimaryEmpposorgrel(personId)) != null) {
                this.addQueryInfo(dyLists, new DynamicObject[]{primaryEmpposorgrel});
            }
            if (!hasLeaders) return dyLists;
        }
        catch (Exception ex) {
            LOGGER.error("getPersonEntityDynamicArray", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"PersonServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return dyLists;
    }

    private Map<Long, List<DynamicObject>> listPersonEntityDynamicArray(List<Long> personIds, boolean hasOrg, boolean hasLeaders) {
        if (null == personIds) {
            return new HashMap<Long, List<DynamicObject>>();
        }
        Map<Long, List<DynamicObject>> personInfoMap = this.initPersonInfoMap(personIds);
        try {
            DynamicObject[] personDyns = HRPIPersonRepository.listPersons(personIds);
            this.addQueryInfo(personInfoMap, personDyns, "id");
            DynamicObject[] pernontspropDyns = HRPIPersonRepository.listPernontsprops(personIds);
            this.addQueryInfo(personInfoMap, pernontspropDyns, "person.id");
            DynamicObject[] pertsoriosDyns = HRPIPersonRepository.listPertsprops(personIds);
            this.addQueryInfo(personInfoMap, pertsoriosDyns, "person.id");
            if (hasOrg) {
                DynamicObject[] primaryEmpposorgrelDyns = HRPIPersonRepository.listPrimaryEmpposorgrel(personIds);
                this.addQueryInfo(personInfoMap, primaryEmpposorgrelDyns, "person.id");
            }
        }
        catch (Exception ex) {
            LOGGER.error("listPersonEntityDynamicArray", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"PersonServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return personInfoMap;
    }

    private Map<Long, List<DynamicObject>> initPersonInfoMap(List<Long> personIds) {
        Map<Long, List<DynamicObject>> personMap = personIds.stream().distinct().collect(Collectors.toMap(personId -> personId, s -> new ArrayList()));
        return personMap;
    }

    private void addQueryInfo(Map<Long, List<DynamicObject>> personMap, DynamicObject[] dynamicObjects, String keyField) {
        if (!HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            Arrays.asList(dynamicObjects).forEach(dy -> {
                long id = dy.getLong(keyField);
                List list = (List)personMap.get(id);
                list.add(dy);
            });
        }
    }

    private void addQueryInfo(List<DynamicObject> list, DynamicObject[] dynamicObjects) {
        if (!HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            list.add(dynamicObjects[0]);
        }
    }

    @Override
    public Long getPersonMainOrgId(Long personId) {
        return HRPIPersonRepository.getPersonMainOrgId(personId);
    }

    @Override
    public List<Long> listPersonOrgIds(Long personId) {
        return HRPIPersonRepository.listPersonOrgIds(personId);
    }

    @Override
    public DynamicObject getPrimaryEmpposorgrel(Long personId) {
        return HRPIPersonRepository.getPrimaryEmpposorgrel(personId);
    }

    @Override
    public List<DynamicObject> listEmpposorgrels(Long personId) {
        return Arrays.asList(HRPIPersonRepository.listEmpposorgrels(personId));
    }

    @Override
    public List<Map<String, Object>> listEmpposorgrels(String posType, List<Long> personIds) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        Object[] dynamicObjects = HRPIPersonRepository.listEmpposorgrels(posType, personIds);
        if (!HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            try {
                QFilter statusQf = new QFilter("enable", "=", (Object)"1");
                Map entityCfMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_laborrelstatus", (String)"labrelstatuscls,labrelstatusprd", (QFilter[])new QFilter[]{statusQf});
                IDataEntityType dataEntityType = dynamicObjects[0].getDataEntityType();
                DataEntityPropertyCollection properties = dataEntityType.getProperties();
                for (Object empInfo : dynamicObjects) {
                    HashMap<String, Object> map = new HashMap<String, Object>(properties.size());
                    for (IDataEntityProperty property : properties) {
                        Object mapValue;
                        if (property.getName().startsWith("employee") || property.getName().startsWith("person")) continue;
                        Object propObj = empInfo.get(property);
                        Object object = mapValue = propObj instanceof ILocaleString ? ((ILocaleString)propObj).getLocaleValue() : propObj;
                        if (propObj instanceof DynamicObject) {
                            DynamicTransformUtil.setBaseData(property.getName(), empInfo.getDynamicObject(property.getName()), map);
                            continue;
                        }
                        map.put(property.getName(), mapValue);
                    }
                    map.put("person_id", empInfo.getString("person.id"));
                    map.put("employee_id", empInfo.getString("employee.id"));
                    map.put("number", empInfo.getString("person.number"));
                    map.put("name", empInfo.getString("person.name"));
                    map.put("isprimary", empInfo.getBoolean("isprimary"));
                    DynamicTransformUtil.setBaseData("postype", empInfo.getDynamicObject("postype"), map);
                    DynamicTransformUtil.setBaseData("posstatus", empInfo.getDynamicObject("posstatus"), map);
                    DynamicTransformUtil.setBaseData("laborrelstatus", empInfo.getDynamicObject("employee.laborrelstatus"), map);
                    DynamicTransformUtil.setBaseData("laborreltype", empInfo.getDynamicObject("employee.laborreltype"), map);
                    DynamicTransformUtil.setBaseData("enterprise", empInfo.getDynamicObject("employee.enterprise"), map);
                    DynamicObject labStatusDy = (DynamicObject)entityCfMap.get(empInfo.getDynamicObject("employee.laborrelstatus").getLong("id"));
                    if (null != labStatusDy) {
                        DynamicTransformUtil.setBaseData("labrelstatusprd", labStatusDy.getDynamicObject("labrelstatusprd"), map);
                        DynamicTransformUtil.setBaseData("labrelstatuscls", labStatusDy.getDynamicObject("labrelstatuscls"), map);
                    }
                    map.put("startdate", empInfo.getDate("startdate"));
                    map.put("sysenddate", empInfo.getDate("sysenddate"));
                    resultList.add(map);
                }
            }
            catch (Exception ex) {
                LOGGER.error("listEmpposorgrels", (Throwable)ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u8fd4\u56de\u4efb\u804c\u4fe1\u606f\u9519\u8bef\u3002", (String)"PersonServiceImpl_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
        }
        return resultList;
    }

    @Override
    public List<Map<String, Long>> listPersonModelIds(Long personId, Boolean isAll) {
        return HRPIPersonRepository.listPersonModelIds(personId, isAll);
    }

    @Override
    public boolean isBelongOrg(Long personId, Long orgId, boolean checkSubOrg) {
        boolean isBelong;
        Long personMainOrgId = this.getPersonMainOrgId(personId);
        boolean bl = isBelong = personMainOrgId != null && personMainOrgId.equals(orgId);
        if (isBelong) {
            return true;
        }
        if (checkSubOrg) {
            List lstSubOrgs;
            try {
                lstSubOrgs = (List)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSService", (String)"getSubAdminOrgList", (Object[])new Object[]{Collections.singletonList(orgId), "1"});
            }
            catch (KDException e) {
                LOGGER.error("isBelongOrg orgId:{} error:{}", (Object)orgId, (Object)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u670d\u52a1\u5f02\u5e38\u3002", (String)"PersonServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            return null != lstSubOrgs && lstSubOrgs.contains(orgId);
        }
        return false;
    }

    @Override
    public boolean isBelongPosition(Long personId, Long positionId) {
        Long personMainPositionId = HRPIPersonRepository.getPersonMainPositionId(personId);
        return personMainPositionId != null && personMainPositionId.equals(positionId);
    }

    @Override
    public List<DynamicObject> listPersonAttachs(Long personId, String attachEntityName) {
        return Arrays.asList(HRPIPersonRepository.listPersonAttachs(personId, attachEntityName));
    }

    @Override
    public List<DynamicObject> listBatchPropPersonAttachs(List<Long> personIds, String selectProps, QFilter qFilter, String attachEntityName) {
        DynamicObject[] dynamicObjects;
        try {
            dynamicObjects = HRPIPersonRepository.listPersonAttachs(personIds, selectProps, qFilter, attachEntityName, false);
        }
        catch (Exception ex) {
            LOGGER.error("list listBatchPropPersonAttachs filter", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6761\u4ef6\u3002", (String)"PersonServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return Arrays.asList(dynamicObjects);
    }

    @Override
    public List<DynamicObject> listBatchPropHisPersonAttachs(List<Long> personIds, String selectProps, QFilter qFilter, String attachEntityName) {
        DynamicObject[] dynamicObjects;
        try {
            dynamicObjects = HRPIPersonRepository.listPersonAttachs(personIds, selectProps, qFilter, attachEntityName, true);
        }
        catch (Exception ex) {
            LOGGER.error("list listBatchPropHisPersonAttachs filter", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6761\u4ef6\u3002", (String)"PersonServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return Arrays.asList(dynamicObjects);
    }

    @Override
    public List<DynamicObject> listBatchPersonAttachs(List<Long> personIds, QFilter qFilter, String attachEntityName) {
        DynamicObject[] dynamicObjects;
        try {
            dynamicObjects = HRPIPersonRepository.listPersonAttachs(personIds, qFilter, attachEntityName);
        }
        catch (Exception ex) {
            LOGGER.error("list personAttaches filter", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6761\u4ef6\u3002", (String)"PersonServiceImpl_4", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return Arrays.asList(dynamicObjects);
    }

    @Override
    public Map<String, Object> queryPersonInfoByUserIds(List<Long> userIds) {
        return this.getIdByUserId(userIds, "0");
    }

    @Override
    public Map<String, Object> getPersonModelIdByUserId(Long userId) {
        ArrayList<Long> userIds = new ArrayList<Long>(10);
        userIds.add(userId);
        return this.getIdByUserId(userIds, "1");
    }

    @Override
    public Map<String, Object> getPersonModelId() {
        long currUserId = RequestContext.get().getCurrUserId();
        ArrayList<Long> userIds = new ArrayList<Long>(10);
        userIds.add(currUserId);
        return this.getIdByUserId(userIds, "1");
    }

    private Map<String, Object> getIdByUserId(List<Long> userId, String single) {
        Map<String, Object> success;
        LOGGER.info("getIdByUserIdParam:{}", userId);
        DynamicObject[] dbDy = HRPIBosUserRepository.getPersonIdsByUserId(userId);
        if (dbDy == null || dbDy.length == 0) {
            return PersonServiceImpl.getFail("query data is null.");
        }
        if ("1".equals(single)) {
            DynamicObject dynamicObject = dbDy.length > 1 ? Arrays.stream(dbDy).sorted((dy1, dy2) -> {
                long timeDiff = dy1.getDate("createtime").getTime() - dy2.getDate("createtime").getTime();
                return timeDiff > 0L ? -1 : 1;
            }).findFirst().get() : dbDy[0];
            Map reMap = dynamicObject == null ? Collections.emptyMap() : HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)dynamicObject);
            success = PersonServiceImpl.getSuccess(reMap);
        } else {
            dbDy = Arrays.stream(dbDy).sorted((dy1, dy2) -> {
                long timeDiff = dy1.getDate("createtime").getTime() - dy2.getDate("createtime").getTime();
                return timeDiff > 0L ? 1 : -1;
            }).collect(Collectors.toList()).toArray(new DynamicObject[dbDy.length]);
            HashMap<Long, Map> retMap = new HashMap<Long, Map>(dbDy.length);
            for (DynamicObject dy : dbDy) {
                Map reMap = HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)dy);
                retMap.put(dy.getLong("user"), reMap);
            }
            success = PersonServiceImpl.getSuccess(retMap);
        }
        LOGGER.info("getIdByUserIdParamReturn:{}", success);
        return success;
    }

    @Override
    public Map<String, Object> getUserIdByPersonInfo(Map<String, List<Long>> idMaps) {
        LOGGER.info("getUserIdByPersonInfoParam:{}", idMaps);
        if (idMaps == null) {
            return PersonServiceImpl.getFail("query term is null.");
        }
        if (idMaps.size() > 1) {
            return PersonServiceImpl.getFail("only support single type query.");
        }
        Set<String> queryTypeSet = idMaps.keySet();
        String queryType = null;
        if (queryTypeSet.contains("person")) {
            queryType = "person";
        } else if (queryTypeSet.contains("employee")) {
            queryType = "employee";
        }
        if (HRStringUtils.isEmpty((String)queryType)) {
            return PersonServiceImpl.getFail("not support query type.");
        }
        List<Long> ids = idMaps.get(queryType);
        QFilter qFilter = new QFilter(queryType, "in", ids);
        List dynamicObjects = Arrays.stream(HRPIBosUserRepository.getUserIdByPersonInfo(qFilter)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return PersonServiceImpl.getFail("query data is null.");
        }
        if ("person".equals(queryType)) {
            Set employeeIds = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getLong("employee")).collect(Collectors.toSet());
            Set notLatestRecordIds = Arrays.stream(HRPIEmployeeRepository.employeeServiceHelper.query("id", new QFilter[]{new QFilter("id", "in", employeeIds), QFilterUtil.notLatestRecord()})).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            dynamicObjects.removeIf(dy -> notLatestRecordIds.contains(dy.getLong("employee")));
        }
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return PersonServiceImpl.getFail("data is null after remove not latestRecord dynamicObject .");
        }
        HashMap<Long, Map> retMap = new HashMap<Long, Map>(dynamicObjects.size());
        for (DynamicObject dy2 : dynamicObjects) {
            Map reMap = HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)dy2);
            retMap.put(dy2.getLong(queryType), reMap);
        }
        Map<String, Object> success = PersonServiceImpl.getSuccess(retMap);
        LOGGER.info("getUserIdByPersonInfoReturn:{}", success);
        return success;
    }

    @Override
    public List<Map<String, Object>> checkPerson(List<Map<String, Object>> checkList) {
        if (checkList == null || checkList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6709\u6548\u6821\u9a8c\u503c\u3002", (String)"PersonServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        try {
            this.doCheckPerson(checkList, false, false, "0");
        }
        catch (Exception ex) {
            LOGGER.error(" checkPerson error", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u552f\u4e00\u6027\u6821\u9a8c\u5931\u8d25\u3002", (String)"PersonServiceImpl_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return checkList;
    }

    @Override
    public List<Map<String, Object>> checkPersonByOpt(List<Map<String, Object>> checkList, String queryType) {
        boolean onlyValidBos = false;
        boolean onlyValidHr = false;
        if ("0".equals(queryType)) {
            onlyValidBos = false;
            onlyValidHr = false;
        } else if ("1".equals(queryType)) {
            onlyValidBos = true;
            onlyValidHr = false;
        } else if ("2".equals(queryType)) {
            onlyValidBos = false;
            onlyValidHr = true;
        } else {
            throw new KDBizException("not support queryType");
        }
        if (checkList == null || checkList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6709\u6548\u6821\u9a8c\u503c\u3002", (String)"PersonServiceImpl_5", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        try {
            this.doCheckPerson(checkList, onlyValidBos, onlyValidHr, queryType);
        }
        catch (Exception ex) {
            LOGGER.error(" checkPerson error", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u552f\u4e00\u6027\u6821\u9a8c\u5931\u8d25\u3002", (String)"PersonServiceImpl_6", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return checkList;
    }

    @Override
    public void doCheckPerson(List<Map<String, Object>> checkList, boolean onlyValidBos, boolean onlyValidHr, String queryType) {
        LOGGER.info("startCheckPerson:{},{},{}", new Object[]{onlyValidBos, onlyValidHr, queryType});
        HashMap<String, CheckPersonEntity> nameAndNumberMap = new HashMap<String, CheckPersonEntity>(16);
        HashMap<String, CheckPersonEntity> nameAndPhoneMap = new HashMap<String, CheckPersonEntity>(16);
        if (!onlyValidHr) {
            this.getBosUserInfo(checkList, nameAndNumberMap, nameAndPhoneMap);
        }
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        Map<String, QFilter> existOtherFilter = this.buildFilterMap(statusFilter);
        Map<String, QFilter> validateQfilter = this.getValidateQfilter(checkList, nameAndNumberMap, nameAndPhoneMap, existOtherFilter);
        HashMap<String, Long> phoneCheckMap = new HashMap<String, Long>(checkList.size());
        HashMap<String, Long> numberCheckMap = new HashMap<String, Long>(checkList.size());
        HashMap<String, Long> pereMailCheckMap = new HashMap<String, Long>(checkList.size());
        HashMap<String, Long> personNumberCheckMap = new HashMap<String, Long>(checkList.size());
        if (!onlyValidBos) {
            this.checkNumberAndPhone("number", validateQfilter.get("numberQfilter"), "hrpi_percre", numberCheckMap);
            this.checkNumberAndPhone("phone", validateQfilter.get("phoneQfilter"), "hrpi_percontact", phoneCheckMap);
            this.checkNumberAndPhone("peremail", validateQfilter.get("mailQfilter"), "hrpi_percontact", pereMailCheckMap);
            this.checkPersonNumber(validateQfilter.get("personNumberQfilter"), personNumberCheckMap);
        }
        ArrayList<Map<String, String>> userMap = new ArrayList<Map<String, String>>(10);
        if (!onlyValidHr && existOtherFilter.get("1") != null) {
            QFilter filter = existOtherFilter.get("0");
            statusFilter.and(filter);
            this.checkPersonFromBosUser(statusFilter, userMap);
        }
        Set<Object> onBoardPersonSet = new HashSet(16);
        HashMap<Long, DynamicObject> personMap = new HashMap(16);
        if (!onlyValidBos) {
            onBoardPersonSet = this.getOnBoardInfo(checkList, phoneCheckMap, numberCheckMap, pereMailCheckMap, personNumberCheckMap);
            DynamicObject[] allPerson = HRPIPersonRepository.getAllPerson(new QFilter("id", "in", onBoardPersonSet));
            personMap = Arrays.stream(allPerson).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v1));
        }
        for (Map<String, Object> checkMap : checkList) {
            ArrayList<Map<String, String>> hrErrorList = new ArrayList<Map<String, String>>(10);
            ArrayList<Map<String, String>> bosErrorList = new ArrayList<Map<String, String>>(10);
            boolean hrFlag = false;
            boolean bosFlag = false;
            if (!onlyValidBos) {
                hrFlag = onBoardPersonSet.isEmpty() ? true : this.handleHrRepeatPrompt(checkMap, onBoardPersonSet, numberCheckMap, phoneCheckMap, pereMailCheckMap, personNumberCheckMap, personMap, hrErrorList);
            }
            checkMap.put("checkhr", hrErrorList);
            if (!onlyValidHr) {
                Map<String, Map<String, String>> cardMap = this.buildValidateMap(userMap, "idcard");
                Map<String, Map<String, String>> mailMap = this.buildValidateMap(userMap, "email");
                Map<String, Map<String, String>> numberMap = this.buildValidateMap(userMap, "number");
                Map<String, Map<String, String>> phoneMap = this.buildValidateMap(userMap, "phone");
                bosFlag = this.handleBosRepeatPrompt(checkMap, cardMap, mailMap, numberMap, phoneMap, bosErrorList);
            }
            checkMap.put("checkbos", bosErrorList);
            if ("0".equals(queryType)) {
                checkMap.put("result", bosFlag && hrFlag);
            } else if ("1".equals(queryType)) {
                checkMap.put("result", bosFlag);
            } else if ("2".equals(queryType)) {
                checkMap.put("result", hrFlag);
            }
            LOGGER.info("endCheckPerson:{},{},{}", new Object[]{bosFlag, hrFlag, checkMap.get("result")});
        }
    }

    @Override
    public HrApiResponse<Map<Long, Object>> personInfoByPersonId(Map<String, Object> params) {
        LOGGER.info("###personInfoByPersonId-start {}", params);
        HrApiResponse hrApiResponseResults = new HrApiResponse();
        try {
            Optional<String> message = this.validatePersonInfoByPersonIdParams(params);
            if (message.isPresent()) {
                return HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)message.get());
            }
            Map<String, Object> entityNameMap = this.dealFields(params);
            List<DynamicObject> queryPersonInfosResults = this.queryPersonInfos(params, entityNameMap);
            Map entityNameAndFieldsMap = entityNameMap.entrySet().stream().collect(HashMap::new, (map, data) -> {
                Map value = (Map)data.getValue();
                map.put(data.getKey(), value.get("fields"));
            }, HashMap::putAll);
            hrApiResponseResults.setData(this.mergePersonInfosResult(queryPersonInfosResults, entityNameAndFieldsMap));
        }
        catch (Exception exception) {
            LOGGER.error("###personInfoByPersonId-error", (Throwable)exception);
            return HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)exception.getMessage());
        }
        LOGGER.info("###personInfoByPersonId-end");
        return hrApiResponseResults;
    }

    @Override
    public HrApiResponse<Set<Long>> getPersonIdByOrgIds(Map<String, Object> params) {
        LOGGER.info("###getPersonIdByOrgIds-start {}", params);
        HrApiResponse hrApiResponseResults = new HrApiResponse();
        try {
            Optional<String> message = this.validatePersonIdByOrgIdsParams(params);
            if (message.isPresent()) {
                return HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)message.get());
            }
            hrApiResponseResults.setData(this.queryPersonIdByOrgIds(params));
        }
        catch (Exception exception) {
            LOGGER.error("###getPersonIdByOrgIds-error", (Throwable)exception);
            return HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)exception.getMessage());
        }
        LOGGER.info("###getPersonIdByOrgIds-end");
        return hrApiResponseResults;
    }

    private Set<Long> queryPersonIdByOrgIds(Map<String, Object> params) {
        Set<Long> personIdSet;
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)16);
        Long maxPersonId = (Long)params.get("maxPersonId");
        int top = (Integer)params.get("top");
        int sum = 0;
        while (!CollectionUtils.isEmpty(personIdSet = this.getPersonIdSet(params, maxPersonId))) {
            personIds.addAll(personIdSet);
            maxPersonId = Collections.max(personIdSet);
            if ((sum += personIdSet.size()) < top) continue;
        }
        return personIds;
    }

    private Set<Long> getPersonIdSet(Map<String, Object> params, Long maxPersonId) {
        ArrayList qFilters = Lists.newArrayListWithCapacity((int)10);
        String queryField = (String)params.get("queryField");
        qFilters.add(new QFilter(queryField, "in", params.get("orgId")));
        qFilters.add(new QFilter("person.id", ">", (Object)maxPersonId));
        qFilters.add(QFilterUtil.getDataStatusFilter());
        qFilters.add(QFilterUtil.getCurrentQf());
        if (Objects.nonNull(params.get("startdate")) && Objects.nonNull(params.get("enddate"))) {
            String startDateKey = "startdate";
            String endDateKey = "enddate";
            this.addDateFilter(params, qFilters, startDateKey, endDateKey);
        }
        int top = (Integer)params.get("top");
        DynamicObject[] depEmpDys = HRPIBusinessDataServiceHelper.load("hrpi_depemp", "person", qFilters.toArray(new QFilter[0]), "person.id", top);
        return Arrays.stream(depEmpDys).map(data -> data.getLong("person_id")).collect(Collectors.toSet());
    }

    private void addDateFilter(Map<String, Object> params, List<QFilter> qFilters, String startDateKey, String endDateKey) {
        Date startDateValue = DateUtil.dateWithoutTime((Date)params.get("startdate"));
        Date endDateValue = DateUtil.dateWithoutTime((Date)params.get("enddate"));
        QFilter dateFilter = this.getDateFilter(startDateKey, startDateValue, endDateKey, endDateValue);
        qFilters.add(dateFilter);
    }

    private QFilter getDateFilter(String startDateKey, Date startDateValue, String endDateKey, Date endDateValue) {
        QFilter dateFilter = new QFilter(startDateKey, ">=", (Object)startDateValue).and(new QFilter(startDateKey, "<=", (Object)endDateValue));
        dateFilter.or(new QFilter(startDateKey, "<=", (Object)startDateValue).and(new QFilter(endDateKey, ">=", (Object)startDateValue)));
        dateFilter.or(new QFilter(endDateKey, ">=", (Object)startDateValue).and(new QFilter(endDateKey, "<=", (Object)endDateValue)));
        dateFilter.or(new QFilter(startDateKey, "<=", (Object)endDateValue).and(new QFilter(endDateKey, ">=", (Object)endDateValue)));
        return dateFilter;
    }

    private Optional<String> validatePersonIdByOrgIdsParams(Map<String, Object> params) {
        Date endDate;
        Date startDate;
        MainEntityType dataEntityType;
        DynamicProperty property;
        String staffAdminorg = StaffAdminorgConfigUtil.getStaffAdminorg();
        if (!StringUtils.isEmpty((String)staffAdminorg) && null == (property = (dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hrpi_depemp")).getProperty(staffAdminorg))) {
            return Optional.of(MessageFormat.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4eba\u5b9e\u4f53\u4e0d\u5b58\u5728\u8be5\u5360\u7f16\u5b57\u6bb5{0}", (String)"PersonServiceImpl_26", (String)"hrmp-hrpi-business", (Object[])new Object[0]), staffAdminorg));
        }
        params.put("queryField", StringUtils.isEmpty((String)staffAdminorg) ? "adminorg" : staffAdminorg);
        if (Objects.isNull(params) || Objects.isNull(params.get("orgId")) || CollectionUtils.isEmpty((Collection)((List)params.get("orgId")))) {
            return Optional.of(ResManager.loadKDString((String)"\u7ec4\u7ec7ID\u201corgId\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PersonServiceImpl_12", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (Objects.isNull(params.get("startdate")) && Objects.nonNull(params.get("enddate")) || Objects.isNull(params.get("enddate")) && Objects.nonNull(params.get("startdate"))) {
            return Optional.of(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u201cstartdate\u201d\u548c\u7ed3\u675f\u65e5\u671f\u201cenddate\u201d\u5fc5\u987b\u540c\u65f6\u586b\u5199\u3002", (String)"PersonServiceImpl_13", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (Objects.nonNull(params.get("startdate")) && HRDateTimeUtils.dayAfter((Date)(startDate = (Date)params.get("startdate")), (Date)(endDate = (Date)params.get("enddate")))) {
            return Optional.of(MessageFormat.format(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u201c{0}\u201d\u9700\u8981\u65e9\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u201c{1}\u201d\u3002", (String)"PersonServiceImpl_16", (String)"hrmp-hrpi-business", (Object[])new Object[0]), HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"), HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd")));
        }
        if (Objects.isNull(params.get("maxPersonId"))) {
            return Optional.of(ResManager.loadKDString((String)"\u6700\u5927\u81ea\u7136\u4ebaID\u201cmaxPersonId\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PersonServiceImpl_14", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (Objects.isNull(params.get("top"))) {
            return Optional.of(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u6570\u201ctop\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PersonServiceImpl_15", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private Map<Long, Object> mergePersonInfosResult(List<DynamicObject> queryPersonInfosResults, Map<String, Object> entityNameAndFieldsMap) {
        Map<Long, List<DynamicObject>> personMap = queryPersonInfosResults.stream().collect(Collectors.groupingBy(data -> data.getLong("person.id")));
        return this.getPersonIdAndEntityName(entityNameAndFieldsMap, personMap);
    }

    private Map<Long, Object> getPersonIdAndEntityName(Map<String, Object> entityNameAndFieldsMap, Map<Long, List<DynamicObject>> personMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)entityNameAndFieldsMap.size());
        for (Map.Entry<Long, List<DynamicObject>> person : personMap.entrySet()) {
            Map<String, List<DynamicObject>> entityNameMap = person.getValue().stream().collect(Collectors.groupingBy(data -> data.getDataEntityType().getName()));
            Map<String, List<Map<String, Object>>> entityNameAndFields = this.getEntityNameAndFields(entityNameAndFieldsMap, entityNameMap);
            resultMap.put(person.getKey(), entityNameAndFields);
        }
        return resultMap;
    }

    private Map<String, List<Map<String, Object>>> getEntityNameAndFields(Map<String, Object> entityNameAndFieldsMap, Map<String, List<DynamicObject>> entityNameMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)entityNameAndFieldsMap.size());
        for (Map.Entry<String, List<DynamicObject>> entityName : entityNameMap.entrySet()) {
            String[] fields = ((String)entityNameAndFieldsMap.get(entityName.getKey())).split(",");
            List<DynamicObject> lists = entityName.getValue();
            List entityNames = lists.stream().map(data -> {
                HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)lists.size());
                for (String field : fields) {
                    fieldMap.put(field, data.get(field));
                }
                return fieldMap;
            }).collect(Collectors.toList());
            resultMap.put(entityName.getKey(), entityNames);
        }
        return resultMap;
    }

    private List<DynamicObject> queryPersonInfos(Map<String, Object> params, Map<String, Object> entityNameMap) {
        ArrayList results = Lists.newArrayListWithCapacity((int)16);
        for (Map.Entry<String, Object> entry : entityNameMap.entrySet()) {
            ArrayList qFilters = Lists.newArrayListWithCapacity((int)3);
            qFilters.add(new QFilter("person", "in", params.get("person_id")));
            qFilters.add(QFilterUtil.getDataStatusFilter());
            qFilters.add(QFilterUtil.getCurrentQf());
            Map value = (Map)entry.getValue();
            if (!MapUtils.isEmpty((Map)value) && ((Boolean)value.get("datefilter")).booleanValue()) {
                String startDateKey = (String)value.get("startdate");
                String endDateKey = (String)value.get("enddate");
                this.addDateFilter(params, qFilters, startDateKey, endDateKey);
            }
            this.addQfilter(entry.getKey(), qFilters);
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entry.getKey());
            DynamicObject[] query = hrBaseServiceHelper.query((String)value.get("fields"), qFilters.toArray(new QFilter[0]));
            results.addAll(Arrays.stream(query).collect(Collectors.toList()));
        }
        return results;
    }

    private void addQfilter(String entityName, List<QFilter> qFilters) {
        switch (entityName) {
            case "hrpi_depemp": 
            case "hrpi_empposorgrel": {
                qFilters.add(new QFilter("isprimary", "=", (Object)"1").and("postype.postcategory", "=", (Object)1010L));
                break;
            }
            case "hrpi_emporgrelall": {
                qFilters.add(new QFilter("depemp.isprimary", "=", (Object)"1").and("depemp.postype.postcategory", "=", (Object)1010L));
                break;
            }
            case "hspm_ermanfile": {
                qFilters.add(new QFilter("empposrel.isprimary", "=", (Object)"1").and("empposrel.postype.postcategory", "=", (Object)1010L));
                break;
            }
        }
    }

    private Optional<String> validatePersonInfoByPersonIdParams(Map<String, Object> params) {
        Date endDate;
        if (MapUtils.isEmpty(params) || Objects.isNull(params.get("person_id")) || CollectionUtils.isEmpty((Collection)((List)params.get("person_id")))) {
            return Optional.of(ResManager.loadKDString((String)"\u81ea\u7136\u4ebaID\u201cperson_id\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PersonServiceImpl_7", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (Objects.isNull(params.get("startdate"))) {
            return Optional.of(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u201cstartdate\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PersonServiceImpl_17", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (Objects.isNull(params.get("enddate"))) {
            return Optional.of(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u201cenddate\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PersonServiceImpl_18", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        Date startDate = (Date)params.get("startdate");
        if (HRDateTimeUtils.dayAfter((Date)startDate, (Date)(endDate = (Date)params.get("enddate")))) {
            return Optional.of(MessageFormat.format(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u201c{0}\u201d\u9700\u8981\u65e9\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u201c{1}\u201d\u3002", (String)"PersonServiceImpl_16", (String)"hrmp-hrpi-business", (Object[])new Object[0]), HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"), HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd")));
        }
        Object entityNameAndFields = params.get("entitynameAndFields");
        if (Objects.isNull(entityNameAndFields) || CollectionUtils.isEmpty((Collection)((List)params.get("entitynameAndFields")))) {
            return Optional.of(ResManager.loadKDString((String)"\u4eba\u5458\u4fe1\u606f\u8868\u6807\u8bc6\u548c\u5b57\u6bb5\u201centitynameAndFields\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PersonServiceImpl_8", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        List entityNameAndFieldList = (List)params.get("entitynameAndFields");
        if (entityNameAndFieldList.stream().anyMatch(data -> Objects.isNull(data.get("entityname")))) {
            return Optional.of(ResManager.loadKDString((String)"\u4eba\u5458\u4fe1\u606f\u8868\u6807\u8bc6\u201centityname\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PersonServiceImpl_19", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        if (entityNameAndFieldList.stream().anyMatch(data -> Objects.isNull(data.get("fields")))) {
            return Optional.of(ResManager.loadKDString((String)"\u67e5\u8be2\u5c5e\u6027\u201cfields\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PersonServiceImpl_20", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        for (Map entityNameAndField : entityNameAndFieldList) {
            if (!Objects.nonNull(entityNameAndField.get("datefilter")) || !((Boolean)entityNameAndField.get("datefilter")).booleanValue()) continue;
            if (Objects.isNull(entityNameAndField.get("startdate"))) {
                return Optional.of(ResManager.loadKDString((String)"\u65f6\u95f4\u8fc7\u6ee4\u6807\u8bc6\u201cdatefilter\u201d\u4e3a\u201ctrue\u201d\u65f6\uff0c\u5f00\u59cb\u65e5\u671f\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PersonServiceImpl_21", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            if (!Objects.isNull(entityNameAndField.get("enddate"))) continue;
            return Optional.of(ResManager.loadKDString((String)"\u65f6\u95f4\u8fc7\u6ee4\u6807\u8bc6\u201cdatefilter\u201d\u4e3a\u201ctrue\u201d\u65f6\uff0c\u7ed3\u675f\u65e5\u671f\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PersonServiceImpl_22", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return this.validSameEntityName(entityNameAndFieldList);
    }

    private Optional<String> validSameEntityName(List<Map<String, Object>> entityNameAndFieldList) {
        Map<Object, List<Map>> entityNameMap = entityNameAndFieldList.stream().collect(Collectors.groupingBy(data -> data.get("entityname")));
        if (entityNameMap.size() == entityNameAndFieldList.size()) {
            return Optional.empty();
        }
        for (Map.Entry<Object, List<Map>> entry : entityNameMap.entrySet()) {
            if (entry.getValue().stream().map(data -> data.get("startdate")).distinct().count() > 1L) {
                return Optional.of(MessageFormat.format(ResManager.loadKDString((String)"\u76f8\u540c\u4eba\u5458\u4fe1\u606f\u8868\u6807\u8bc6\u201c{0}\u201d\u7684\u5f00\u59cb\u65e5\u671f\u6807\u8bc6\u8981\u4e00\u81f4\u3002", (String)"PersonServiceImpl_23", (String)"hrmp-hrpi-business", (Object[])new Object[0]), entry.getKey()));
            }
            if (entry.getValue().stream().map(data -> data.get("enddate")).distinct().count() > 1L) {
                return Optional.of(MessageFormat.format(ResManager.loadKDString((String)"\u76f8\u540c\u4eba\u5458\u4fe1\u606f\u8868\u6807\u8bc6\u201c{0}\u201d\u7684\u7ed3\u675f\u65e5\u671f\u6807\u8bc6\u8981\u4e00\u81f4\u3002", (String)"PersonServiceImpl_24", (String)"hrmp-hrpi-business", (Object[])new Object[0]), entry.getKey()));
            }
            if (entry.getValue().stream().map(data -> data.get("datefilter")).distinct().count() <= 1L) continue;
            return Optional.of(MessageFormat.format(ResManager.loadKDString((String)"\u76f8\u540c\u4eba\u5458\u4fe1\u606f\u8868\u6807\u8bc6\u201c{0}\u201d\u7684\u65f6\u95f4\u8fc7\u6ee4\u6807\u8bc6\u8981\u4e00\u81f4\u3002", (String)"PersonServiceImpl_25", (String)"hrmp-hrpi-business", (Object[])new Object[0]), entry.getKey()));
        }
        return Optional.empty();
    }

    private Map<String, Object> dealFields(Map<String, Object> params) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)1);
        List entityNameAndFields = (List)params.get("entitynameAndFields");
        Map<String, List<Map>> entityNameMap = entityNameAndFields.stream().collect(Collectors.groupingBy(data -> (String)data.get("entityname")));
        for (Map.Entry<String, List<Map>> entry : entityNameMap.entrySet()) {
            boolean dateFilter;
            if (CollectionUtils.isEmpty((Collection)entry.getValue())) continue;
            HashMap innerResultMap = Maps.newHashMapWithExpectedSize((int)4);
            String fields = entry.getValue().stream().map(data -> (String)data.get("fields")).collect(Collectors.joining(","));
            Set fieldSet = Arrays.stream(fields.split(",")).collect(Collectors.toSet());
            fieldSet.add("person.id");
            Object dateFilterObj = entry.getValue().get(0).get("datefilter");
            boolean bl = dateFilter = Objects.nonNull(dateFilterObj) && (Boolean)dateFilterObj != false;
            if (dateFilter) {
                String startDate = (String)entry.getValue().get(0).get("startdate");
                String endDate = (String)entry.getValue().get(0).get("enddate");
                innerResultMap.put("startdate", startDate);
                innerResultMap.put("enddate", endDate);
                fieldSet.add(startDate);
                fieldSet.add(endDate);
            }
            innerResultMap.put("datefilter", dateFilter);
            innerResultMap.put("fields", String.join((CharSequence)",", fieldSet));
            resultMap.put(entry.getKey(), innerResultMap);
        }
        return resultMap;
    }

    private void judgeSameTerm(Set<String> mailSysSet, Set<String> cardNoSysSet, long cardTypeId, String cardNo, String mail, CheckPersonEntity namePhoneEntity) {
        if (cardTypeId == HRPIValueConstants.CARD_TYPE && !cardNo.equals(namePhoneEntity.getCardNo())) {
            cardNoSysSet.add(cardNo);
        }
        if (HRStringUtils.isNotEmpty((String)mail) && !mail.equals(namePhoneEntity.getMail())) {
            mailSysSet.add(mail);
        }
    }

    private Map<String, Map<String, String>> buildValidateMap(List<Map<String, String>> userMap, String validateField) {
        HashMap<String, Map<String, String>> retMap = new HashMap<String, Map<String, String>>(16);
        for (Map<String, String> tmpMap : userMap) {
            String field = tmpMap.get(validateField);
            if (HRStringUtils.isEmpty((String)field)) continue;
            retMap.put(field, tmpMap);
        }
        return retMap;
    }

    private boolean handleBosRepeatPrompt(Map<String, Object> checkMap, Map<String, Map<String, String>> cardMap, Map<String, Map<String, String>> mailMap, Map<String, Map<String, String>> numberMap, Map<String, Map<String, String>> phoneMap, List<Map<String, String>> bosErrorList) {
        boolean numberFlag = this.validateBosField("number", checkMap, numberMap, bosErrorList);
        boolean cardNoFlag = this.validateBosField("cardno", checkMap, cardMap, bosErrorList);
        boolean phoneFlag = this.validateBosField("phone", checkMap, phoneMap, bosErrorList);
        boolean mailFlag = this.validateBosField("email", checkMap, mailMap, bosErrorList);
        return numberFlag && cardNoFlag && phoneFlag && mailFlag;
    }

    private boolean validateBosField(String validateKey, Map<String, Object> checkMap, Map<String, Map<String, String>> mailMap, List<Map<String, String>> bosErrorList) {
        Map<String, String> userMap;
        HashMap<String, String> bosErrorMap = new HashMap<String, String>(16);
        String validateValue = (String)checkMap.get(validateKey);
        if ("phone".equals(validateKey) && HRStringUtils.isNotEmpty((String)validateValue)) {
            validateValue = this.getPhone(validateValue);
        }
        if ((userMap = mailMap.get(validateValue)) != null && userMap.size() > 0) {
            bosErrorMap.put("repeatkey", validateKey);
            String name = userMap.get("name");
            bosErrorMap.put("repeatname", name);
            String number = userMap.get("number");
            bosErrorMap.put("repeatnumber", number);
            bosErrorMap.put("isforbidden", userMap.get("isforbidden"));
            bosErrorList.add(bosErrorMap);
            LOGGER.info("validateBosField:{},{},{}", new Object[]{validateKey, name, number});
            return false;
        }
        return true;
    }

    private String getPhone(String validateValue) {
        if (validateValue.startsWith("+")) {
            validateValue = validateValue.substring(validateValue.indexOf(43) + 1);
        }
        if (validateValue.startsWith("86-") || validateValue.startsWith("+86-")) {
            validateValue = validateValue.substring(validateValue.indexOf(45) + 1);
        }
        return validateValue;
    }

    private boolean handleHrRepeatPrompt(Map<String, Object> checkMap, Set<Long> onBoardPersonSet, Map<String, Long> numberCheckMap, Map<String, Long> phoneCheckMap, Map<String, Long> pereMailCheckMap, Map<String, Long> personNumberCheckMap, Map<Long, DynamicObject> personMap, List<Map<String, String>> hrErrorList) {
        boolean cardFlag = this.validateRep("cardno", checkMap, onBoardPersonSet, numberCheckMap, personMap, hrErrorList);
        boolean phoneFlag = this.validateRep("phone", checkMap, onBoardPersonSet, phoneCheckMap, personMap, hrErrorList);
        boolean pereMailFlag = this.validateRep("email", checkMap, onBoardPersonSet, pereMailCheckMap, personMap, hrErrorList);
        boolean personNumberFlag = this.validateRep("number", checkMap, onBoardPersonSet, personNumberCheckMap, personMap, hrErrorList);
        return cardFlag && phoneFlag && pereMailFlag && personNumberFlag;
    }

    private boolean validateRep(String key, Map<String, Object> checkMap, Set<Long> onBoardPersonSet, Map<String, Long> numberCheckMap, Map<Long, DynamicObject> personMap, List<Map<String, String>> hrErrorList) {
        String number = (String)checkMap.get(key);
        Long personId = numberCheckMap.get(number);
        boolean numberFlag = onBoardPersonSet.contains(personId);
        HashMap<String, String> hrErrorMap = new HashMap<String, String>(16);
        if (numberFlag) {
            DynamicObject personDy = personMap.get(personId);
            if (personDy != null) {
                String repName = personDy.getString("name");
                String repNumber = personDy.getString("number");
                hrErrorMap.put("repeatkey", key);
                hrErrorMap.put("repeatname", repName);
                hrErrorMap.put("repeatnumber", repNumber);
                LOGGER.info("validateRep:{},{},{}", new Object[]{key, repName, personId});
                hrErrorList.add(hrErrorMap);
            }
            return false;
        }
        return true;
    }

    private Map<String, QFilter> buildFilterMap(QFilter statusFilter) {
        HashMap<String, QFilter> existOtherFilter = new HashMap<String, QFilter>(16);
        existOtherFilter.put("0", statusFilter);
        return existOtherFilter;
    }

    private Set<Long> getOnBoardInfo(List<Map<String, Object>> checkList, Map<String, Long> phoneCheckMap, Map<String, Long> numberCheckMap, Map<String, Long> pereMailCheckMap, Map<String, Long> personNumberCheckMap) {
        HashSet<Long> personSet = new HashSet<Long>(checkList.size());
        personSet.addAll(numberCheckMap.values());
        personSet.addAll(phoneCheckMap.values());
        personSet.addAll(pereMailCheckMap.values());
        personSet.addAll(personNumberCheckMap.values());
        HashSet<Long> onBoardPersonSet = new HashSet<Long>();
        if (!personSet.isEmpty()) {
            DynamicObject[] onBoardEmployee;
            for (DynamicObject employee : onBoardEmployee = HRPIEmployeeRepository.getOnBoardEmployee(personSet)) {
                onBoardPersonSet.add(employee.getLong("person.id"));
            }
        }
        return onBoardPersonSet;
    }

    private void getBosUserInfo(List<Map<String, Object>> checkList, Map<String, CheckPersonEntity> nameAndNumberMap, Map<String, CheckPersonEntity> nameAndPhoneMap) {
        DynamicObject[] phoneByNumbers;
        CheckPersonEntity checkPersonEntity;
        DynamicObject[] personsByNumbers;
        ArrayList<String> numbers = new ArrayList<String>(10);
        ArrayList<String> numberNameList = new ArrayList<String>(10);
        ArrayList<String> phoneNameList = new ArrayList<String>(10);
        ArrayList<String> phoneList = new ArrayList<String>(10);
        for (Map<String, Object> checkMap : checkList) {
            String number = (String)checkMap.get("number");
            String name = (String)checkMap.get("name");
            String phone = (String)checkMap.get("phone");
            if (HRStringUtils.isEmpty((String)number) && HRStringUtils.isNotEmpty((String)phone)) {
                if (HRStringUtils.isNotEmpty((String)name)) {
                    phoneNameList.add(name);
                }
                if (!HRStringUtils.isNotEmpty((String)phone)) continue;
                phone = this.getPhone(phone);
                phoneList.add(phone);
                continue;
            }
            if (HRStringUtils.isNotEmpty((String)name)) {
                numberNameList.add(name);
            }
            if (!HRStringUtils.isNotEmpty((String)number)) continue;
            numbers.add(number);
        }
        if (numbers.size() > 0 && numberNameList.size() > 0 && (personsByNumbers = HRPIBosUserRepository.getBosUserByTerm("id,name,number,idcard,email,phone", numbers, numberNameList, "number", "name")) != null && personsByNumbers.length > 0) {
            for (DynamicObject dy : personsByNumbers) {
                checkPersonEntity = this.getCheckPersonEntity(dy);
                nameAndNumberMap.put(dy.getString("number") + dy.getString("name"), checkPersonEntity);
            }
        }
        if (phoneNameList.size() > 0 && phoneList.size() > 0 && (phoneByNumbers = HRPIBosUserRepository.getBosUserByTerm("id,name,phone,number,idcard,email", phoneList, phoneNameList, "phone", "name")) != null && phoneByNumbers.length > 0) {
            for (DynamicObject dy : phoneByNumbers) {
                checkPersonEntity = this.getCheckPersonEntity(dy);
                nameAndPhoneMap.put(dy.getString("phone") + dy.getString("name"), checkPersonEntity);
            }
        }
    }

    private CheckPersonEntity getCheckPersonEntity(DynamicObject dy) {
        CheckPersonEntity checkPersonEntity = new CheckPersonEntity();
        checkPersonEntity.setName(dy.getString("name"));
        checkPersonEntity.setNumber(dy.getString("number"));
        checkPersonEntity.setCardNo(dy.getString("idcard"));
        checkPersonEntity.setMail(dy.getString("email"));
        checkPersonEntity.setPhone(dy.getString("phone"));
        return checkPersonEntity;
    }

    private void checkPersonFromBosUser(QFilter filter, List<Map<String, String>> userMap) {
        DynamicObject[] bosUserInfo = HRPIBosUserRepository.getBosUserInfo(new QFilter[]{filter});
        if (bosUserInfo != null && bosUserInfo.length > 0) {
            for (DynamicObject dynamicObject : bosUserInfo) {
                HashMap<String, String> tmpMap = new HashMap<String, String>(16);
                tmpMap.put("number", dynamicObject.getString("number"));
                tmpMap.put("idcard", dynamicObject.getString("idcard"));
                tmpMap.put("phone", dynamicObject.getString("phone"));
                tmpMap.put("email", dynamicObject.getString("email"));
                tmpMap.put("name", dynamicObject.getString("name"));
                tmpMap.put("isforbidden", dynamicObject.getBoolean("isforbidden") ? "1" : "0");
                userMap.add(tmpMap);
            }
        }
    }

    private Map<String, QFilter> getValidateQfilter(List<Map<String, Object>> checkList, Map<String, CheckPersonEntity> nameAndNumberMap, Map<String, CheckPersonEntity> nameAndPhoneMap, Map<String, QFilter> existOtherFilter) {
        HashSet<String> cardNoSet = new HashSet<String>(checkList.size());
        HashSet<String> phoneSet = new HashSet<String>(checkList.size());
        HashSet<String> phoneSysSet = new HashSet<String>(checkList.size());
        HashSet<String> numberSysSet = new HashSet<String>(checkList.size());
        HashSet<String> mailSet = new HashSet<String>(checkList.size());
        HashSet<String> mailSysSet = new HashSet<String>(checkList.size());
        HashSet<String> numberSet = new HashSet<String>(checkList.size());
        HashSet<String> cardNoSysSet = new HashSet<String>(checkList.size());
        HashMap<String, QFilter> resultMap = new HashMap<String, QFilter>(checkList.size());
        for (Map<String, Object> checkInfo : checkList) {
            String number = (String)checkInfo.get("number");
            String name = (String)checkInfo.get("name");
            Object cardTypeObj = checkInfo.get("cardtype");
            long cardTypeId = 0L;
            if (Objects.nonNull(cardTypeObj) && cardTypeObj instanceof Long) {
                LOGGER.warn("getValidateQfilterWarn");
                cardTypeId = (Long)cardTypeObj;
            }
            String phone = (String)checkInfo.get("phone");
            String cardNo = (String)checkInfo.get("cardno");
            String mail = (String)checkInfo.get("email");
            if (HRStringUtils.isNotEmpty((String)phone)) {
                phoneSet.add(phone);
            }
            if (HRStringUtils.isNotEmpty((String)cardNo)) {
                cardNoSet.add(cardNo);
            }
            if (HRStringUtils.isNotEmpty((String)mail)) {
                mailSet.add(mail);
            }
            CheckPersonEntity nameNumberEntity = nameAndNumberMap.get(number + name);
            CheckPersonEntity namePhoneEntity = null;
            if (HRStringUtils.isNotEmpty((String)phone)) {
                namePhoneEntity = nameAndPhoneMap.get(this.getPhone(phone) + name);
            }
            if (HRStringUtils.isNotEmpty((String)number)) {
                numberSet.add(number);
            }
            if (HRStringUtils.isNotEmpty((String)number) && HRStringUtils.isNotEmpty((String)name) && nameNumberEntity != null) {
                if (HRStringUtils.isNotEmpty((String)phone) && !(phone = this.getPhone(phone)).equals(nameNumberEntity.getPhone())) {
                    phoneSysSet.add(phone);
                }
                this.judgeSameTerm(mailSysSet, cardNoSysSet, cardTypeId, cardNo, mail, nameNumberEntity);
                continue;
            }
            if (HRStringUtils.isNotEmpty((String)phone) && HRStringUtils.isNotEmpty((String)name) && namePhoneEntity != null) {
                this.judgeSameTerm(mailSysSet, cardNoSysSet, cardTypeId, cardNo, mail, namePhoneEntity);
                continue;
            }
            if (HRStringUtils.isNotEmpty((String)number)) {
                numberSysSet.add(number);
            }
            if (HRStringUtils.isNotEmpty((String)phone)) {
                phone = this.getPhone(phone);
                phoneSysSet.add(phone);
            }
            if (cardTypeId == 1010L) {
                cardNoSysSet.add(cardNo);
            }
            if (!HRStringUtils.isNotEmpty((String)mail)) continue;
            mailSysSet.add(mail);
        }
        QFilter numberQfilter = !cardNoSet.isEmpty() ? new QFilter("number", "in", cardNoSet) : null;
        QFilter phoneQfilter = !phoneSet.isEmpty() ? new QFilter("phone", "in", phoneSet) : null;
        QFilter mailQfilter = !mailSet.isEmpty() ? new QFilter("peremail", "in", mailSet) : null;
        QFilter personNumberQfilter = !numberSet.isEmpty() ? new QFilter("number", "in", numberSet) : null;
        QFilter tmpFilter = this.setOtherFilter("number", numberSysSet, null, existOtherFilter);
        QFilter phoneFilter = this.setOtherFilter("phone", phoneSysSet, tmpFilter, existOtherFilter);
        QFilter cardNoFilter = this.setOtherFilter("idcard", cardNoSysSet, phoneFilter, existOtherFilter);
        QFilter lastFilter = this.setOtherFilter("email", mailSysSet, cardNoFilter, existOtherFilter);
        existOtherFilter.put("0", lastFilter);
        resultMap.put("numberQfilter", numberQfilter);
        resultMap.put("phoneQfilter", phoneQfilter);
        resultMap.put("mailQfilter", mailQfilter);
        resultMap.put("personNumberQfilter", personNumberQfilter);
        return resultMap;
    }

    private QFilter setOtherFilter(String field, Set<String> valueSet, QFilter filter, Map<String, QFilter> existOtherFilter) {
        if (valueSet.size() > 0) {
            QFilter qFilter = new QFilter(field, "in", valueSet);
            if (filter != null) {
                qFilter.or(filter);
            }
            QFilter initFilter = existOtherFilter.get("0");
            existOtherFilter.put("1", initFilter);
            return qFilter;
        }
        return filter;
    }

    private void checkNumberAndPhone(String checkFileds, QFilter qFilter, String entityName, Map<String, Long> resultMap) {
        DynamicObject[] checkDys;
        if (qFilter == null) {
            return;
        }
        for (DynamicObject check : checkDys = HRPIPersonRepository.checkPersonInfo(qFilter, entityName, checkFileds)) {
            long personId = check.getLong("person.id");
            resultMap.put(check.getString(checkFileds), personId);
        }
    }

    private void checkPersonNumber(QFilter qFilter, Map<String, Long> resultMap) {
        DynamicObject[] checkDys;
        if (qFilter == null) {
            return;
        }
        for (DynamicObject check : checkDys = HRPIPersonRepository.personServiceHelper.query("id,number", new QFilter[]{qFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()})) {
            long personId = check.getLong("id");
            resultMap.put(check.getString("number"), personId);
        }
    }

    protected static Map<String, Object> getFail(String message) {
        LOGGER.info("PersonServiceImpl#getFail:{}", (Object)message);
        return PersonServiceImpl.getResult(false, message, null);
    }

    protected static Map<String, Object> getSuccess(Object data) {
        return PersonServiceImpl.getResult(true, null, data);
    }

    protected static Map<String, Object> getResult(boolean flag, String message, Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", flag);
        result.put("message", message);
        if (null != data) {
            result.put("data", data);
        }
        return result;
    }

    @Override
    public Map<String, Object> getPersonInfoByCert(Map<String, Object> certInfosMap) {
        LOGGER.info("getPersonInfoByCert start ");
        HashSet errorSet = Sets.newHashSet();
        ValidateHelper validator = ValidateHelper.getInstance(errorSet);
        try {
            validator.validateMustInput("credentialsType", "numbers").or(validator.validateArgType(ValidateHelper.isLongType, "credentialsType")).or(validator.validateArgType(ValidateHelper.isListType, "numbers")).or(validator.validateListSize("numbers", 10000)).test(certInfosMap);
            if (errorSet.size() > 0) {
                return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), JSONObject.toJSONString((Object)errorSet)).get();
            }
        }
        catch (Exception exception) {
            LOGGER.error("validate request param occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), String.format(ErrorCodeEnum.VALIDATE_FAILED.getInfo(), exception.getMessage())).get();
        }
        QFilter certTypeFilter = new QFilter("credentialstype", "=", certInfosMap.get("credentialsType"));
        QFilter numberLimitFilter = new QFilter("number", "in", certInfosMap.get("numbers"));
        QFilter[] qFilterArray = new QFilter[]{numberLimitFilter, certTypeFilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()};
        DynamicObject[] certObjs = RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "credentialstype", "number"), null, "hrpi_percre", qFilterArray, null);
        List personIds = Arrays.stream(certObjs).distinct().map(obj -> obj.getLong("person_id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(personIds)) {
            return ResultBuilder.success(Collections.emptyList()).addMsg("there is no data in the condition").get();
        }
        QFilter[] qFilterPersonArray = new QFilter[]{new QFilter("id", "in", personIds), QFilterUtil.getInitStatusFinish()};
        DynamicObject[] persons = RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "id", "personindexid", "headsculpture", "number"), null, "hrpi_person", qFilterPersonArray, null);
        QFilter[] qFilterPerNonArray = new QFilter[]{new QFilter("person", "in", personIds), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()};
        DynamicObject[] perNons = RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "gender"), null, "hrpi_pernontsprop", qFilterPerNonArray, null);
        DynamicObject[] perCons = RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "phone"), null, "hrpi_percontact", qFilterPerNonArray, null);
        QFilter[] qFilterEmpArray = new QFilter[]{new QFilter("person", "in", personIds), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getStatusFilters(), QFilterUtil.empLatestRecord(), QFilterUtil.getInitStatusFinish()};
        DynamicObject[] empNons = RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "employee", "laborreltype", "laborrelstatus", "startdate", "enddate"), null, "hrpi_empnonentrel", qFilterEmpArray, null);
        DynamicObject[] emps = RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "employee", "laborreltype", "laborrelstatus", "startdate", "enddate"), null, "hrpi_empentrel", qFilterEmpArray, null);
        List<Map<String, Object>> resListMap = DynamicTransformUtil.dynamicListToMap(Arrays.asList(certObjs));
        Map<Long, Map> personIdWithPerCreMap = resListMap.stream().collect(Collectors.toMap(map -> (Long)map.get("person_id"), HashMap::new, (k1, k2) -> k1));
        Map<Long, Map> personIdWithPersonMap = DynamicTransformUtil.dynamicListToMap(Arrays.asList(persons)).stream().collect(Collectors.toMap(map -> (Long)map.get("id"), map -> map));
        Map<Long, Map> personIdWithPersonNonMap = DynamicTransformUtil.dynamicListToMap(Arrays.asList(perNons)).stream().collect(Collectors.toMap(map -> (Long)map.get("person_id"), map -> map));
        Map<Long, Map> personIdWithPersonConMap = DynamicTransformUtil.dynamicListToMap(Arrays.asList(perCons)).stream().collect(Collectors.toMap(map -> (Long)map.get("person_id"), map -> map));
        Map<Long, Map> personIdWithEmpNonMap = DynamicTransformUtil.dynamicListToMap(Arrays.asList(empNons)).stream().collect(Collectors.toMap(map -> (Long)map.get("person_id"), map -> map));
        Map<Long, DynamicObject> collect = Arrays.stream(emps).collect(Collectors.toMap(dy -> dy.getLong("person_id"), dy -> dy));
        List<Map<String, Object>> empListMap = DynamicTransformUtil.dynamicListToMap(Arrays.asList(emps));
        this.addClsInfo(collect, empListMap);
        this.addPrdInfo(collect, empListMap);
        Map<Long, Map> personIdWithEmpMap = empListMap.stream().collect(Collectors.toMap(map -> (Long)map.get("person_id"), map -> map));
        resListMap.forEach(map -> {
            if (!map.containsKey("person_id")) {
                map.put("person_id", map.get("id"));
            }
        });
        DynamicTransformUtil.mergeMap(resListMap, new Tuple((Object)"hrpi_percre", personIdWithPerCreMap), new Tuple((Object)"hrpi_person", personIdWithPersonMap), new Tuple((Object)"hrpi_pernontsprop", personIdWithPersonNonMap), new Tuple((Object)"hrpi_percontact", personIdWithPersonConMap), new Tuple((Object)"hrpi_empnonentrel", personIdWithEmpNonMap), new Tuple((Object)"hrpi_empentrel", personIdWithEmpMap));
        Map<Long, Long> indexWithPersonId = DynamicTransformUtil.dynamicListToMap(Arrays.asList(persons)).stream().collect(Collectors.toMap(map -> (Long)map.get("personindexid"), map -> (Long)map.get("id"), (value1, value2) -> {
            Date dateOne = (Date)((Map)personIdWithEmpMap.get(value1)).get("startdate");
            Date dateTwo = (Date)((Map)personIdWithEmpMap.get(value2)).get("startdate");
            return dateTwo.after(dateOne) ? value2 : value1;
        }));
        Collection<Long> needKeep = indexWithPersonId.values();
        List<Map> disListMap = resListMap.stream().filter(map -> needKeep.contains(map.get("person_id"))).collect(Collectors.toList());
        disListMap.forEach(map -> {
            map.keySet().removeAll(Arrays.asList("person", "id", "credentialstype", "person_id"));
            map.forEach((key, value) -> {
                if (value instanceof Map) {
                    ((Map)value).keySet().removeAll(Arrays.asList("person", "person_id"));
                }
            });
        });
        return ResultBuilder.success(disListMap).get();
    }

    @Override
    public Map<String, Object> getPersonInfoFuzzy(Map<String, Object> fuzzyParam) {
        LOGGER.info("getPersonInfoFuzzy start : {}", (Object)LogPrivacyUtil.filterPrivacyProp(fuzzyParam, Collections.singletonList("phone")));
        HashSet errorSet = Sets.newHashSet();
        ValidateHelper validator = ValidateHelper.getInstance(errorSet);
        try {
            validator.validateReqMapNotNull().or(validator.validateOneOfItemsMustInput("name", "phone")).or(validator.validateMustInput("fuzzyFlag")).or(validator.validateArgType(ValidateHelper.isStringType, "name", "phone")).or(validator.validateArgType(ValidateHelper.isBooleanType, "fuzzyFlag")).test(fuzzyParam);
            Optional.ofNullable(fuzzyParam.get("fuzzyFlag")).ifPresent(fP -> {
                if (fP instanceof Boolean && ((Boolean)fP).booleanValue()) {
                    validator.validateMustInput("matchArgs", "similarity").or(validator.validateArgType(ValidateHelper.isDoubleType, "similarity")).or(validator.validateSimilarityLimit("similarity")).or(validator.validateMatchArgs("matchArgs")).test(fuzzyParam);
                }
            });
            if (errorSet.size() > 0) {
                return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), JSONObject.toJSONString((Object)errorSet)).get();
            }
        }
        catch (Exception exception) {
            LOGGER.error("validate request param occur exception : ", (Throwable)exception);
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_ERROR.getCode(), String.format(ErrorCodeEnum.VALIDATE_FAILED.getInfo(), exception.getMessage(), JSONObject.toJSONString((Object)errorSet))).get();
        }
        AtomicReference<HashSet> personIds = new AtomicReference<HashSet>(Sets.newHashSet());
        AtomicReference<HashMap> personMap = new AtomicReference<HashMap>(Maps.newHashMap());
        AtomicReference<HashMap> personConMap = new AtomicReference<HashMap>(Maps.newHashMap());
        Optional.ofNullable(fuzzyParam.get("name")).ifPresent(queryName -> {
            DynamicObject[] objects = RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "id", "headsculpture", "number", "name", "personindexid"), null, "hrpi_person", new QFilter[]{new QFilter("name", "=", queryName), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()}, null);
            Optional.ofNullable(objects).ifPresent(objectArray -> personMap.set((HashMap)DynamicTransformUtil.dynamicListToMap(Arrays.asList(objectArray)).stream().collect(Collectors.toMap(map -> (Long)map.get("id"), map -> map))));
            personIds.set((HashSet)((Map)personMap.get()).keySet());
        });
        Optional.ofNullable(fuzzyParam.get("phone")).ifPresent(queryPhone -> {
            DynamicObject[] objects = RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "phone"), null, "hrpi_percontact", new QFilter[]{new QFilter("phone", "=", queryPhone), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()}, null);
            Optional.ofNullable(objects).ifPresent(objectArray -> personConMap.set((HashMap)DynamicTransformUtil.dynamicListToMap(Arrays.asList(objectArray)).stream().collect(Collectors.toMap(map -> (Long)map.get("person_id"), map -> map))));
            personIds.set((HashSet)((Map)personConMap.get()).keySet());
        });
        if (!StringUtils.isEmpty((String)((String)fuzzyParam.get("name"))) && !StringUtils.isEmpty((String)((String)fuzzyParam.get("phone")))) {
            personIds.set((HashSet)this.mixPersonIdByIntersection(personMap.get(), personConMap.get()));
        }
        if (CollectionUtils.isEmpty((Collection)personIds.get())) {
            return ResultBuilder.success(Collections.emptyList()).addMsg("there is no data in the condition").get();
        }
        HashMap personWithSim = Maps.newHashMapWithExpectedSize((int)((Set)personIds.get()).size());
        ((Set)personIds.get()).forEach(id -> personWithSim.put(id, 0.0));
        Tuple<Map<Long, List<Map<String, Object>>>, Map<Long, List<Map<String, Object>>>> mapsOfEduPreWork = this.calcSimilarity(personWithSim, fuzzyParam);
        if (CollectionUtils.isEmpty(personWithSim.keySet())) {
            return ResultBuilder.success(Collections.emptyList()).addMsg("there is no data in the condition").get();
        }
        QFilter[] qFilterPerNonArray = new QFilter[]{new QFilter("person", "in", personWithSim.keySet()), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()};
        Map<Long, Map> personIdWithPersonNonMap = DynamicTransformUtil.dynamicListToMap(Arrays.asList(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "gender"), null, "hrpi_pernontsprop", qFilterPerNonArray, null))).stream().distinct().collect(Collectors.toMap(map -> (Long)map.get("person_id"), map -> map));
        Map<Long, Map> personIdWithPersonConMap = DynamicTransformUtil.dynamicListToMap(Arrays.asList(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "phone"), null, "hrpi_percontact", qFilterPerNonArray, null))).stream().collect(Collectors.toMap(map -> (Long)map.get("person_id"), map -> map));
        QFilter[] qFilterEmpArray = new QFilter[]{new QFilter("person", "in", personWithSim.keySet()), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getStatusFilters(), QFilterUtil.getInitStatusFinish()};
        Map<Long, Map> personIdWithEmpNonMap = DynamicTransformUtil.dynamicListToMap(Arrays.asList(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "employee", "laborreltype", "laborrelstatus", "startdate"), null, "hrpi_empnonentrel", qFilterEmpArray, null))).stream().collect(Collectors.toMap(map -> (Long)map.get("person_id"), map -> map));
        ArrayList<QFilter> filters = new ArrayList<QFilter>(Arrays.asList(qFilterEmpArray));
        filters.add(QFilterUtil.isLatestRecord());
        DynamicObject[] emps = RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "employee", "laborreltype", "laborrelstatus", "startdate"), null, "hrpi_empentrel", filters.toArray(new QFilter[0]), null);
        Map<Long, DynamicObject> collect = Arrays.stream(emps).collect(Collectors.toMap(map -> (Long)map.get("person_id"), map -> map));
        Map<Long, Map> personIdWithEmpMap = DynamicTransformUtil.dynamicListToMap(Arrays.asList(RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "employee", "laborreltype", "laborrelstatus", "startdate"), null, "hrpi_empentrel", filters.toArray(new QFilter[0]), null))).stream().collect(Collectors.toMap(map -> (Long)map.get("person_id"), map -> map));
        this.addClsInfo(collect, personIdWithEmpMap.values());
        ((Map)personMap.get()).entrySet().removeIf(o -> !personWithSim.containsKey(o.getKey()));
        ((Map)personConMap.get()).entrySet().removeIf(o -> !personWithSim.containsKey(o.getKey()));
        Set<Long> personIdsAfterFilter = this.mixPersonIdByCollection(personMap.get(), personConMap.get());
        Map<Long, Map> personIdWithPersonMap = DynamicTransformUtil.dynamicListToMap(Arrays.asList(HRPIPersonRepository.personServiceHelper.query(String.join((CharSequence)",", "id", "headsculpture", "number", "name", "personindexid"), new QFilter[]{new QFilter("id", "in", personIdsAfterFilter), QFilterUtil.getInitStatusFinish()}))).stream().collect(Collectors.toMap(map -> (Long)map.get("id"), map -> map));
        List<Map<String, Object>> resListMap = this.mergeNewMap(personMap.get(), personConMap.get());
        resListMap.forEach(map -> {
            if (!map.containsKey("person_id")) {
                map.put("person_id", map.get("id"));
            }
        });
        DynamicTransformUtil.mergeMap(resListMap, new Tuple((Object)"hrpi_person", personIdWithPersonMap), new Tuple((Object)"hrpi_pereduexp", mapsOfEduPreWork.item1), new Tuple((Object)"hrpi_preworkexp", mapsOfEduPreWork.item2), new Tuple((Object)"hrpi_pernontsprop", personIdWithPersonNonMap), new Tuple((Object)"hrpi_percontact", personIdWithPersonConMap), new Tuple((Object)"hrpi_empnonentrel", personIdWithEmpNonMap), new Tuple((Object)"hrpi_empentrel", personIdWithEmpMap));
        resListMap.forEach(map -> {
            map.keySet().removeAll(Arrays.asList("person", "id", "person_id"));
            map.forEach((key, value) -> {
                if (value instanceof Map) {
                    ((Map)value).keySet().removeAll(Arrays.asList("person", "person_id"));
                } else if (value instanceof List) {
                    ((List)value).forEach(o -> {
                        if (o instanceof Map) {
                            ((Map)o).keySet().removeAll(Arrays.asList("person", "person_id"));
                        }
                    });
                }
            });
        });
        return ResultBuilder.success(resListMap).get();
    }

    @Override
    public Map<String, Object> queryPersonInfoByPage(Integer pageIndex, Integer pageSize) {
        if (pageIndex != null && pageIndex > 0 && pageSize != null && pageSize > 0) {
            int total;
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            qFilterList.add(QFilterUtil.getInitStatusFinish());
            qFilterList.add(QFilterUtil.getCurrentQf());
            qFilterList.add(QFilterUtil.getDataStatusFilter());
            DynamicObject[] personDyArray = new DynamicObject[]{};
            try {
                if (pageIndex != null && pageSize != null) {
                    personDyArray = HRPIBusinessDataServiceHelper.load("hrpi_person", "id,number,name", qFilterList.toArray(new QFilter[0]), "id", pageIndex - 1, pageSize);
                }
                total = HRPIPersonRepository.countPerson(qFilterList);
            }
            catch (Exception exception) {
                LOGGER.error("queryPersonInfoByPage is exception:", (Throwable)exception);
                throw new KDException(new ErrorCode("queryPersonInfoByPage", "invoke queryPersonInfo api exception"), new Object[0]);
            }
            resultMap.put("pageIndex", pageIndex);
            resultMap.put("pageSize", pageSize);
            resultMap.put("data", DynamicTransformUtil.dynamicListToMap(Arrays.asList(personDyArray)));
            resultMap.put("total", total);
            resultMap.put("lastPage", pageIndex >= (total % pageSize == 0 ? total / pageSize : total / pageSize + 1));
            return resultMap;
        }
        return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), ErrorCodeEnum.VALIDATE_FAILED.getInfo()).get();
    }

    @Override
    public Map<String, Object> updatePersonHeadSculpture(String personNumber, String path) {
        if (HRStringUtils.isEmpty((String)personNumber) || HRStringUtils.isEmpty((String)path)) {
            return ResultBuilder.failed(ErrorCodeEnum.VALIDATE_FAILED.getCode(), ErrorCodeEnum.VALIDATE_FAILED.getInfo()).get();
        }
        List personIDs = Arrays.stream(HRPIEmployeeRepository.fixIfRepeatNumber(HRPIEmployeeRepository.listEmpEntByNumbers(String.join((CharSequence)",", "person_id", "empnumber", "startdate"), Collections.singletonList(personNumber)))).map(dy -> dy.getLong("person_id")).collect(Collectors.toList());
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter("boid", "in", personIDs));
        try {
            String pictureField;
            Object[] dynamicObjects = HRPIPersonRepository.personServiceHelper.loadDynamicObjectArray(qFilterList.toArray(new QFilter[0]));
            if (HRArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
                pictureField = Optional.of(Arrays.stream(dynamicObjects).findFirst().map(dynamicObject -> dynamicObject.getString("headsculpture")).get()).orElse("");
                Arrays.stream(dynamicObjects).forEach(dynamicObject -> dynamicObject.set("headsculpture", (Object)path));
                HRPIPersonRepository.personServiceHelper.updateDatas((DynamicObject[])dynamicObjects);
                long personId = (Long)Arrays.stream(dynamicObjects).filter(dy -> HRStringUtils.equals((String)"true", (String)dy.getString("iscurrentversion"))).map(DataEntityBase::getPkValue).findFirst().get();
                LOGGER.info("personId={}", (Object)personId);
                QFilter[] qFilterPerNonArray = new QFilter[]{new QFilter("person", "=", (Object)personId)};
                Object[] collection = RepositoryUtil.getDynamicObjectCollection("hrpi_pernontsprop", qFilterPerNonArray);
                if (HRArrayUtils.isNotEmpty((Object[])collection)) {
                    Arrays.stream(collection).forEach(dynamicObject -> dynamicObject.set("headsculpture", (Object)path));
                    new HRBaseServiceHelper("hrpi_pernontsprop").updateDatas((DynamicObject[])collection);
                }
                try (TXHandle txHandle = TX.notSupported();){
                    long userId;
                    DynamicObject dynamicObject2 = null;
                    DynamicObject rel = new HRBaseServiceHelper("hrpi_personuserrel").queryOne("user", new QFilter[]{new QFilter("person", "=", (Object)personId)});
                    if (null != rel && 0L != (userId = rel.getLong("user"))) {
                        dynamicObject2 = HRPIBosUserRepository.getBosUserHelper().loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)userId)});
                    }
                    if (null != dynamicObject2 && !HRObjectUtils.isEmpty(dynamicObject2)) {
                        dynamicObject2.set("picturefield", (Object)path);
                        HRPIBosUserRepository.getBosUserHelper().updateDataOne(dynamicObject2);
                    }
                    LOGGER.error("bos user is not exist personNumber={}", (Object)personNumber);
                }
            } else {
                return PersonServiceImpl.getResult(false, "person number is not exist", personNumber);
            }
            try {
                if (HRStringUtils.isNotEmpty((String)pictureField) && !HRStringUtils.equals((String)path, (String)pictureField)) {
                    FileService fs = FileServiceFactory.getAttachmentFileService();
                    fs.delete(pictureField);
                    boolean flag = fs.exists(pictureField);
                    LOGGER.info("updatePersonHeadSculpture#personNumber={},oldPictureField={},deleteFlag={}", new Object[]{personNumber, pictureField, flag});
                }
            }
            catch (Exception exception) {
                LOGGER.error("FileService delete is exception:{},personNumber={},pictureField={}", new Object[]{exception, personNumber, pictureField});
            }
        }
        catch (Exception exception) {
            LOGGER.error("updatePersonHeadSculpture is exception:", (Throwable)exception);
            return PersonServiceImpl.getResult(false, exception.getMessage(), personNumber);
        }
        return PersonServiceImpl.getSuccess(personNumber);
    }

    private void addClsInfo(Map<Long, DynamicObject> collect, Collection<Map<String, Object>> personIdWithEmpMap) {
        personIdWithEmpMap.forEach(map -> {
            Long personId = (Long)map.get("person_id");
            Optional.ofNullable(collect.get(personId)).flatMap(empItem -> Optional.ofNullable(empItem.getDynamicObject("laborrelstatus"))).flatMap(status -> Optional.ofNullable(status.getDynamicObject("labrelstatuscls"))).ifPresent(cls -> {
                map.put("laborrelstatus_labrelstatuscls_id", cls.getPkValue());
                map.put("laborrelstatus_labrelstatuscls", cls.getString("name"));
            });
        });
    }

    private void addPrdInfo(Map<Long, DynamicObject> collect, Collection<Map<String, Object>> personIdWithEmpMap) {
        personIdWithEmpMap.forEach(map -> {
            Long personId = (Long)map.get("person_id");
            Optional.ofNullable(collect.get(personId)).flatMap(empItem -> Optional.ofNullable(empItem.getDynamicObject("laborrelstatus"))).flatMap(status -> Optional.ofNullable(status.getDynamicObject("labrelstatusprd"))).ifPresent(cls -> {
                map.put("laborrelstatus_labrelstatusprd_id", cls.getPkValue());
                map.put("laborrelstatus_labrelstatusprd", cls.getString("name"));
            });
        });
    }

    private List<Map<String, Object>> mergeNewMap(Map<Long, Map<String, Object>> personMap, Map<Long, Map<String, Object>> personConMap) {
        ArrayList<Map<String, Object>> reqListMap = new ArrayList<Map<String, Object>>(personMap.size());
        if (personMap.size() == 0 || personConMap.size() == 0) {
            reqListMap.addAll((personMap.size() == 0 ? personConMap : personMap).values());
            return reqListMap;
        }
        personMap.forEach((key, value) -> {
            if (MapUtils.isNotEmpty((Map)((Map)personConMap.get(key)))) {
                value.putAll((Map)personConMap.get(key));
            }
            HashMap nMap = new HashMap(value);
            reqListMap.add(nMap);
        });
        return reqListMap;
    }

    private Tuple<Map<Long, List<Map<String, Object>>>, Map<Long, List<Map<String, Object>>>> calcSimilarity(Map<Long, Double> personWithSim, Map<String, Object> fuzzyParam) {
        List inputPreWorks;
        QFilter[] qFilters = new QFilter[]{new QFilter("person", "in", personWithSim.keySet()), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), QFilterUtil.getInitStatusFinish()};
        DynamicObject[] perEduExp = RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "admissiondate", "graduateschool"), null, "hrpi_pereduexp", qFilters, null);
        Map<Long, List<Map>> perEduExpGrouped = DynamicTransformUtil.dynamicListToMap(Arrays.asList(perEduExp)).stream().collect(Collectors.groupingBy(o -> (Long)o.get("person_id")));
        DynamicObject[] preWork = RepositoryUtil.getDynamicObjectCollection(String.join((CharSequence)",", "person", "unitname"), null, "hrpi_preworkexp", qFilters, null);
        Map<Long, List<Map>> preWorkGrouped = DynamicTransformUtil.dynamicListToMap(Arrays.asList(preWork)).stream().collect(Collectors.groupingBy(o -> (Long)o.get("person_id")));
        if (!((Boolean)fuzzyParam.get("fuzzyFlag")).booleanValue()) {
            return new Tuple(perEduExpGrouped, preWorkGrouped);
        }
        Map matchArgs = (Map)fuzzyParam.get("matchArgs");
        Double similarity = (Double)fuzzyParam.get("similarity");
        AtomicInteger totalRows = new AtomicInteger(0);
        List inputEduExps = (List)matchArgs.get("hrpi_pereduexp");
        if (CollectionUtils.isNotEmpty((Collection)inputEduExps)) {
            totalRows.addAndGet(inputEduExps.size());
        }
        if (CollectionUtils.isNotEmpty((Collection)(inputPreWorks = (List)matchArgs.get("hrpi_preworkexp")))) {
            totalRows.addAndGet(inputPreWorks.size());
        }
        if (totalRows.get() == 0) {
            LOGGER.error("The matchArgs's data is null , can't calculate similarity ... ");
            throw new KDBizException("The matchArgs's data is null , can't calculate similarity ... ");
        }
        personWithSim.forEach((k, v) -> {
            AtomicInteger matchRows = new AtomicInteger(0);
            if (CollectionUtils.isNotEmpty((Collection)inputEduExps)) {
                this.calcSameCountEduExp((List)perEduExpGrouped.get(k), matchRows, inputEduExps);
            }
            if (CollectionUtils.isNotEmpty((Collection)inputPreWorks)) {
                this.calcSameCountPreWork((List)preWorkGrouped.get(k), matchRows, inputPreWorks);
            }
            personWithSim.put((Long)k, (double)matchRows.get() / ((double)totalRows.get() * 1.0));
        });
        personWithSim.entrySet().removeIf(o -> BigDecimal.valueOf((Double)o.getValue()).compareTo(BigDecimal.valueOf(similarity)) < 0);
        perEduExpGrouped.entrySet().removeIf(o -> !personWithSim.containsKey(o.getKey()));
        preWorkGrouped.entrySet().removeIf(o -> !personWithSim.containsKey(o.getKey()));
        return new Tuple(perEduExpGrouped, preWorkGrouped);
    }

    private void calcSameCountPreWork(List<Map<String, Object>> maps, AtomicInteger matchRows, List<Map<String, Object>> inputPreWorks) {
        if (CollectionUtils.isEmpty(maps)) {
            return;
        }
        maps.forEach(outMap -> inputPreWorks.forEach(innerMap -> {
            if (innerMap.get("unitname").equals(outMap.get("unitname"))) {
                matchRows.getAndIncrement();
            }
        }));
    }

    private void calcSameCountEduExp(List<Map<String, Object>> maps, AtomicInteger matchRows, List<Map<String, Object>> inputEduExps) {
        if (CollectionUtils.isEmpty(maps)) {
            return;
        }
        maps.forEach(outMap -> inputEduExps.forEach(innerMap -> {
            if (Objects.equals(innerMap.get("graduateschool_id"), outMap.get("graduateschool_id")) && this.sameDate(DateUtil.getDate(innerMap.get("admissiondate")), DateUtil.getDate(outMap.get("admissiondate")))) {
                matchRows.getAndIncrement();
            }
        }));
    }

    private boolean sameDate(Date dateO, Date dateT) {
        if (null == dateO && null == dateT) {
            return true;
        }
        if (null == dateO || null == dateT) {
            return false;
        }
        Calendar cO = Calendar.getInstance();
        cO.setTime(dateO);
        Calendar cT = Calendar.getInstance();
        cT.setTime(dateT);
        return cO.get(1) == cT.get(1) && cO.get(2) == cT.get(2);
    }

    private Set<Long> mixPersonIdByIntersection(Map<Long, Map<String, Object>> personMap, Map<Long, Map<String, Object>> personConMap) {
        HashSet personIds = Sets.newHashSet();
        if (MapUtils.isEmpty(personMap) && MapUtils.isEmpty(personConMap)) {
            return personIds;
        }
        personIds.addAll(personMap.keySet());
        personIds.retainAll(personConMap.keySet());
        return personIds;
    }

    private Set<Long> mixPersonIdByCollection(Map<Long, Map<String, Object>> personMap, Map<Long, Map<String, Object>> personConMap) {
        HashSet personIds = Sets.newHashSet();
        if (MapUtils.isEmpty(personMap) && MapUtils.isEmpty(personConMap)) {
            return personIds;
        }
        personIds.addAll(personMap.keySet());
        personIds.addAll(personConMap.keySet());
        return personIds;
    }
}

