/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.service.HRPIServiceFactory;
import kd.hrmp.hrpi.business.domian.service.IQueryByOrgService;

public class QueryByOrgServiceImpl
implements IQueryByOrgService {
    private static final Log LOGGER = LogFactory.getLog(QueryByOrgServiceImpl.class);
    private static volatile IQueryByOrgService QUERYBYORGSERVICE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IQueryByOrgService getInstance() {
        try {
            if (null != QUERYBYORGSERVICE) return QUERYBYORGSERVICE;
            Class<QueryByOrgServiceImpl> clazz = QueryByOrgServiceImpl.class;
            synchronized (QueryByOrgServiceImpl.class) {
                if (null != QUERYBYORGSERVICE) return QUERYBYORGSERVICE;
                try {
                    QUERYBYORGSERVICE = new QueryByOrgServiceImpl();
                    LOGGER.info("HRPIServiceFactory-dependency-check,new-QueryByOrgServiceImpl()-success");
                }
                catch (Throwable t) {
                    LOGGER.error("HRPIServiceFactory-dependency-check,new-QueryByOrgServiceImpl()-fail", t);
                }
                return QUERYBYORGSERVICE;
            }
        }
        catch (Throwable t) {
            LOGGER.error("HRPIServiceFactory-dependency-check,QueryByOrgServiceImpl-getInstance()-fail", t);
        }
        return QUERYBYORGSERVICE;
    }

    @Override
    public Map<Long, Set<Long>> getAllUsersOfOrg(String posType, List<Long> orgIds, boolean includeSubOrg) {
        Map<Long, Set<Long>> result;
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyMap();
        }
        try {
            List batchGetAllSubOrgList;
            List<Object> orgFinalIds = includeSubOrg ? (!CollectionUtils.isEmpty((Collection)(batchGetAllSubOrgList = (List)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"batchGetAllSubOrg", (Object[])new Object[]{orgIds, new Date()}))) ? batchGetAllSubOrgList.stream().map(batchGetAllSubOrgMap -> Long.valueOf(String.valueOf(batchGetAllSubOrgMap.get("orgId")))).collect(Collectors.toList()) : orgIds) : orgIds;
            result = HRPIDepempRepository.getAllUsersOfOrg(posType, orgFinalIds);
        }
        catch (KDException e) {
            LOGGER.error("orgFinalIds orgIds:{} error:{}", orgIds, (Object)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u670d\u52a1\u5f02\u5e38\u3002", (String)"PersonServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        catch (Exception ex) {
            LOGGER.error("getAllUsers orgIds:{} error:{}", orgIds, (Object)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"PersonServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return result;
    }

    @Override
    public Map<Long, Set<Long>> getAllUsersOfOrgteam(String posType, List<Long> orgteamIds, boolean includeSubOrg) {
        Map<Long, Set<Long>> result;
        if (CollectionUtils.isEmpty(orgteamIds)) {
            return Collections.emptyMap();
        }
        try {
            result = HRPIDepempRepository.getAllUsersOfOrgteam(posType, orgteamIds);
        }
        catch (KDException e) {
            LOGGER.error("orgFinalIds orgIds:{} error:{}", orgteamIds, (Object)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u670d\u52a1\u5f02\u5e38\u3002", (String)"PersonServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        catch (Exception ex) {
            LOGGER.error("getAllUsers orgIds:{} error:{}", orgteamIds, (Object)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"PersonServiceImpl_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return result;
    }

    @Override
    public Map<Long, Set<Long>> getAllUsersOfPosition(String posType, List<Long> positionIds) {
        return CollectionUtils.isEmpty(positionIds) ? Collections.emptyMap() : HRPIDepempRepository.getAllUsersOfPosition(posType, positionIds);
    }

    @Override
    public Map<Long, Set<Long>> getAllUsersOfDutyworkroles(String posType, List<Long> dutyworkrolesIds) {
        return CollectionUtils.isEmpty(dutyworkrolesIds) ? Collections.emptyMap() : HRPIDepempRepository.getAllUsersOfDutyworkroles(posType, dutyworkrolesIds);
    }

    @Override
    public List<Map<String, Object>> listPersonInfoFromProjteam(Long projTeamId) {
        return null;
    }

    @Override
    public List<Map<String, Object>> getPersonByOrgs(List<Long> adminOrgIds, Date queryDate) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        Object[] currentPersonByAdminOrg = HRPIDepempRepository.getCurrentPersonByAdminOrgs(adminOrgIds, queryDate);
        if (!HRArrayUtils.isEmpty((Object[])currentPersonByAdminOrg)) {
            Map<Long, List<DynamicObject>> personGroupByOrg = Arrays.stream(currentPersonByAdminOrg).collect(Collectors.groupingBy(dy -> dy.getLong("adminorg.id")));
            this.getPersonByOrgGroup(resultList, personGroupByOrg);
        }
        return resultList;
    }

    @Override
    public List<Map<String, Object>> getPersonByOrgteams(List<Long> orgteamIds, Date queryDate) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        Object[] currentPersonByOrgteam = HRPIDepempRepository.getCurrentPersonByOrgteams(orgteamIds, queryDate);
        if (!HRArrayUtils.isEmpty((Object[])currentPersonByOrgteam)) {
            Map<Long, List<DynamicObject>> personGroupByOrgteam = Arrays.stream(currentPersonByOrgteam).collect(Collectors.groupingBy(dy -> dy.getLong("orgteam.id")));
            this.getPersonByOrgGroup(resultList, personGroupByOrgteam);
        }
        return resultList;
    }

    private void getPersonByOrgGroup(List<Map<String, Object>> list, Map<Long, List<DynamicObject>> personGroupByOrg) {
        try {
            for (Map.Entry<Long, List<DynamicObject>> mapInfo : personGroupByOrg.entrySet()) {
                List<DynamicObject> currentPersonList = mapInfo.getValue();
                int count = mapInfo.getValue().size();
                for (DynamicObject personInfo : currentPersonList) {
                    HashMap<String, Object> personMap = new HashMap<String, Object>(16);
                    personMap.put("id", personInfo.getLong("id"));
                    personMap.put("person", personInfo.getLong("person.id"));
                    personMap.put("employee", personInfo.getLong("employee.id"));
                    personMap.put("orgteam", personInfo.getLong("orgteam.id"));
                    personMap.put("otclassify", personInfo.getLong("otclassify.id"));
                    personMap.put("adminorg", personInfo.getLong("adminorg.id"));
                    personMap.put("name", personInfo.getString("person.name"));
                    personMap.put("number", personInfo.getString("person.number"));
                    personMap.put("postype", personInfo.getString("postype.name"));
                    personMap.put("count", count);
                    list.add(personMap);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("getCurrentPersonByAdminOrg error", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25", (String)"QueryByOrgServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    @Override
    public Map<String, Object> getActivePersonByOrg(Long adminOrgId) {
        DynamicObject[] currentPersonDys = HRPIDepempRepository.getCurrentPersonByAdminOrgs(Collections.singletonList(adminOrgId), null);
        return this.getActivePersonByCurrentPerson(currentPersonDys);
    }

    @Override
    public Map<String, Object> getActivePersonByOrgteam(Long orgteamId) {
        DynamicObject[] currentPersonDys = HRPIDepempRepository.getCurrentPersonByOrgteams(Collections.singletonList(orgteamId), null);
        return this.getActivePersonByCurrentPerson(currentPersonDys);
    }

    private Map<String, Object> getActivePersonByCurrentPerson(DynamicObject[] currentPersonDys) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        int personCount = 0;
        if (!HRArrayUtils.isEmpty((Object[])currentPersonDys)) {
            personCount = currentPersonDys.length;
            ArrayList personList = new ArrayList(personCount);
            try {
                for (DynamicObject personInfo : currentPersonDys) {
                    HashMap<String, Object> personMap = new HashMap<String, Object>(16);
                    personMap.put("id", personInfo.getLong("id"));
                    personMap.put("person", personInfo.getLong("person.id"));
                    personMap.put("employee", personInfo.getLong("employee.id"));
                    personMap.put("name", personInfo.getString("person.name"));
                    personMap.put("number", personInfo.getString("person.number"));
                    personMap.put("postype", personInfo.getString("postype.name"));
                    personList.add(personMap);
                }
            }
            catch (Exception ex) {
                LOGGER.error("getActivePersonByOrg error", (Throwable)ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25", (String)"QueryByOrgServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            }
            resultMap.put("list", personList);
        }
        resultMap.put("count", personCount);
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> getPersonCountAndChargeInfo(List<Long> adminOrgIds, Date queryDate) {
        LOGGER.info("getPersonCountAndChargeInfo adminOrgIds {} queryData {}", adminOrgIds, (Object)queryDate);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(adminOrgIds.size());
        List<Map<String, Object>> mainChargePeoDys = HRPIServiceFactory.roleService.getMainChargeInfoByOrg(adminOrgIds, queryDate);
        Object[] currentPersonDys = HRPIDepempRepository.getCurrentPersonByOrgteams(adminOrgIds, queryDate);
        if (CollectionUtils.isEmpty(mainChargePeoDys) && HRArrayUtils.isEmpty((Object[])currentPersonDys)) {
            return resultList;
        }
        try {
            this.getCountMap(resultList, mainChargePeoDys, (DynamicObject[])currentPersonDys);
        }
        catch (Exception ex) {
            LOGGER.error("getPersonCountAndChargeInfo error", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25", (String)"QueryByOrgServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return resultList;
    }

    @Override
    public List<Map<String, Object>> getPersonChargeInfo(List<Long> adminOrgIds, Date queryDate) {
        LOGGER.info("getPersonCountAndChargeInfo adminOrgIds {} queryData {}", adminOrgIds, (Object)queryDate);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(adminOrgIds.size());
        List<Map<String, Object>> mainChargePeoDys = HRPIServiceFactory.roleService.getMainChargeInfoByOrg(adminOrgIds, queryDate);
        Object[] currentPersonDys = HRPIDepempRepository.getCurrentPersonByOrgs("orgteam.id", adminOrgIds, queryDate);
        if (CollectionUtils.isEmpty(mainChargePeoDys) && HRArrayUtils.isEmpty((Object[])currentPersonDys)) {
            return resultList;
        }
        try {
            this.getCountMap(resultList, mainChargePeoDys, (DynamicObject[])currentPersonDys);
        }
        catch (Exception ex) {
            LOGGER.error("getPersonCountAndChargeInfo error", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25", (String)"QueryByOrgServiceImpl_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return resultList;
    }

    private void getCountMap(List<Map<String, Object>> resultList, List<Map<String, Object>> mainChargePeoDys, DynamicObject[] currentPersonDys) {
        Map countMap = !HRArrayUtils.isEmpty((Object[])currentPersonDys) ? Arrays.stream(currentPersonDys).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("adminorg.id"), Collectors.counting())) : Collections.emptyMap();
        Map manChargeMap = !CollectionUtils.isEmpty(mainChargePeoDys) ? mainChargePeoDys.stream().collect(Collectors.groupingBy(chargeMap -> (Long)chargeMap.get("adminorg"), Collectors.toList())) : Collections.emptyMap();
        LOGGER.info("getPersonCountAndChargeInfo countMap {}", manChargeMap);
        HashSet queryOrgIdSet = new HashSet(countMap.keySet());
        queryOrgIdSet.addAll(manChargeMap.keySet());
        queryOrgIdSet.forEach(orgId -> {
            Long aLong = (Long)countMap.get(orgId);
            int count = aLong == null ? 0 : Integer.parseInt(aLong.toString());
            List mainChargePeoItem = (List)manChargeMap.get(orgId);
            if (!CollectionUtils.isEmpty((Collection)mainChargePeoItem)) {
                mainChargePeoItem.forEach(mainChargeMap -> {
                    mainChargeMap.put("count", count);
                    resultList.add((Map<String, Object>)mainChargeMap);
                });
            } else {
                HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
                itemMap.put("adminorg", orgId);
                itemMap.put("name", "");
                itemMap.put("number", "");
                itemMap.put("headsculpture", "");
                itemMap.put("laborreltype", "");
                itemMap.put("laborrelstatus", "");
                itemMap.put("startdate", null);
                itemMap.put("enddate", null);
                itemMap.put("postype", "");
                itemMap.put("isprimary", "");
                itemMap.put("person", 0L);
                itemMap.put("businessstatus", "");
                itemMap.put("position", "");
                itemMap.put("stdposition", "");
                itemMap.put("count", count);
                resultList.add(itemMap);
            }
        });
    }
}

