/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.service.IHRPIOperationService;
import kd.hrmp.hrpi.business.domian.service.ISynChargeToUserService;
import kd.hrmp.hrpi.business.domian.service.impl.HRPIOperationServiceImpl;
import kd.hrmp.hrpi.common.HRPIChargePersonConstants;
import kd.hrmp.hrpi.common.model.charge.SynChargeToUserModel;

public class SynChargeToUserService
implements ISynChargeToUserService,
HRPIChargePersonConstants {
    private static final Log logger = LogFactory.getLog(SynChargeToUserService.class);
    private static volatile ISynChargeToUserService SYNCHARGETOUSERSERVICE;
    static final ThreadPool THREAD_POOL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ISynChargeToUserService getInstance() {
        try {
            if (null != SYNCHARGETOUSERSERVICE) return SYNCHARGETOUSERSERVICE;
            Class<SynChargeToUserService> clazz = SynChargeToUserService.class;
            synchronized (SynChargeToUserService.class) {
                if (null != SYNCHARGETOUSERSERVICE) return SYNCHARGETOUSERSERVICE;
                try {
                    SYNCHARGETOUSERSERVICE = new SynChargeToUserService();
                    logger.info("HRPIServiceFactory-dependency-check,new-SynChargeToUserService()-success");
                }
                catch (Throwable t) {
                    logger.error("HRPIServiceFactory-dependency-check,new-SynChargeToUserService()-fail", t);
                }
                return SYNCHARGETOUSERSERVICE;
            }
        }
        catch (Throwable t) {
            logger.error("HRPIServiceFactory-dependency-check,SynChargeToUserService-getInstance()-fail", t);
        }
        return SYNCHARGETOUSERSERVICE;
    }

    @Override
    public void addCharge(SynChargeToUserModel model) {
        IHRPIOperationService hrpiOperationService = HRPIOperationServiceImpl.getInstance();
        hrpiOperationService.diffTypeSyncPersonToSysUer(this.getUserMapList(model.getChargePersonList()), "directorupdate");
    }

    @Override
    public void removeCharge(SynChargeToUserModel model) {
        IHRPIOperationService hrpiOperationService = HRPIOperationServiceImpl.getInstance();
        hrpiOperationService.diffTypeSyncPersonToSysUer(this.getUserMapList(model.getChargePersonList()), "directorupdate");
    }

    @Override
    public void addCharge(List<DynamicObject> chargePersonList) {
        this.synCharge(chargePersonList);
    }

    @Override
    public void removeCharge(List<DynamicObject> chargePersonList) {
        this.synCharge(chargePersonList);
    }

    private void synCharge(List<DynamicObject> chargePersonList) {
        if (CollectionUtils.isEmpty(chargePersonList)) {
            return;
        }
        try {
            List<Map<String, Object>> userMapList;
            IHRPIOperationService hrpiOperationService = HRPIOperationServiceImpl.getInstance();
            Object chargePerson = chargePersonList.get(0).get("chargeperson");
            if (chargePerson instanceof Long) {
                List<Long> idList = chargePersonList.stream().map(dy -> dy.getLong("chargeperson")).collect(Collectors.toList());
                DynamicObject[] array = HRPIDepempRepository.listDepempIds(idList, "id,person");
                userMapList = this.getUserMapList(array);
            } else {
                SynChargeToUserModel model = new SynChargeToUserModel();
                model.setChargePersonList(chargePersonList);
                userMapList = this.getUserMapList(model.getChargePersonList());
            }
            THREAD_POOL.execute(() -> {
                logger.info("SynChargeToUserService synCharge begin!");
                hrpiOperationService.diffTypeSyncPersonToSysUer(userMapList, "directorupdate");
                logger.info("SynChargeToUserService synCharge end!");
            });
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private List<Map<String, Object>> getUserMapList(DynamicObject[] array) {
        return Arrays.stream(array).map(dy -> {
            HashMap<String, Object> userMap = new HashMap<String, Object>();
            userMap.put("name", dy.getString("person.name"));
            userMap.put("number", dy.getString("person.number"));
            userMap.put("personid", dy.get("person.id"));
            userMap.put("synctype", "directorupdate");
            return userMap;
        }).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getUserMapList(List<DynamicObject> chargePersonList) {
        return chargePersonList.stream().map(dy -> {
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("name", dy.getString("chargeperson.person.name"));
            userMap.put("number", dy.getString("chargeperson.person.number"));
            userMap.put("synctype", "directorupdate");
            return userMap;
        }).collect(Collectors.toList());
    }

    static {
        THREAD_POOL = ThreadPools.newCachedThreadPool((String)"SynChargeToUserService");
    }
}

