/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.IUserService;
import kd.bos.permission.model.UserParam;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.service.ext.ISyncUserService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.ext.SyncParamModel;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIBosUserRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIChargePersonRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRolerelRepository;
import kd.hrmp.hrpi.business.domian.service.IPersonRoleService;
import kd.hrmp.hrpi.business.domian.service.IPersonService;
import kd.hrmp.hrpi.business.domian.service.ISyncPersonToUserService;
import kd.hrmp.hrpi.business.domian.service.impl.HRPIOperationServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.PersonRoleServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.PersonServiceImpl;
import kd.hrmp.hrpi.business.helper.SyncPersonToUserServiceHelper;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.business.tools.PersonModelConfigUtil;
import kd.hrmp.hrpi.common.util.ResultUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class SyncPersonToUserServiceImpl
implements ISyncPersonToUserService {
    private static final Log LOGGER = LogFactory.getLog(SyncPersonToUserServiceImpl.class);
    private static volatile ISyncPersonToUserService SYNCPERSONTOUSERSERVICE;
    private static final String SCENCE = "kd.hrmp.hrpi.business.domian.service.impl.SyncPersonToUserServiceImpl#updateSyncUserParam";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ISyncPersonToUserService getInstance() {
        try {
            if (null != SYNCPERSONTOUSERSERVICE) return SYNCPERSONTOUSERSERVICE;
            Class<SyncPersonToUserServiceImpl> clazz = SyncPersonToUserServiceImpl.class;
            synchronized (SyncPersonToUserServiceImpl.class) {
                if (null != SYNCPERSONTOUSERSERVICE) return SYNCPERSONTOUSERSERVICE;
                try {
                    SYNCPERSONTOUSERSERVICE = new SyncPersonToUserServiceImpl();
                    LOGGER.info("HRPIServiceFactory-dependency-check,new-SyncPersonToUserServiceImpl()-success");
                }
                catch (Throwable t) {
                    LOGGER.error("HRPIServiceFactory-dependency-check,new-SyncPersonToUserServiceImpl()-fail", t);
                }
                return SYNCPERSONTOUSERSERVICE;
            }
        }
        catch (Throwable t) {
            LOGGER.error("HRPIServiceFactory-dependency-check,SyncPersonToUserServiceImpl-getInstance()-fail", t);
        }
        return SYNCPERSONTOUSERSERVICE;
    }

    @Override
    public Map<String, Object> handleQuitPerson(List<Map<String, Object>> tempUserList, String status, String taskType, String syncType, Map<String, String> errorMap) {
        List<DynamicObject> personInfo = this.getPersonInfo(tempUserList, syncType);
        List<Long> personIdsList = personInfo.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        DynamicObject[] beforeSavePersonUserRel = HRPIBosUserRepository.getPersonUserRel("person", personIdsList, syncType);
        List<Long> dbUserIds = Arrays.stream(beforeSavePersonUserRel).map(dy -> dy.getLong("user")).collect(Collectors.toList());
        DynamicObject[] bosUser = null;
        if (!CollectionUtils.isEmpty(dbUserIds)) {
            bosUser = HRPIBosUserRepository.getBosUserById("id,enable,number,name", dbUserIds);
        }
        if (HRArrayUtils.isEmpty(bosUser)) {
            this.buildEmptyError(tempUserList, errorMap, "not have personuserrel data.");
            return HRPIOperationServiceImpl.getResult(false, "not have personuserrel data.", errorMap);
        }
        HashMap<Long, String> dbUserMap = new HashMap<Long, String>(16);
        List<UserParam> paramList = this.setDisableUserInfo(status, errorMap, bosUser, dbUserMap);
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        if (paramList.size() <= 0) {
            this.buildEmptyError(tempUserList, errorMap, "not have success data.");
            return HRPIOperationServiceImpl.getResult(false, "not have success data.", errorMap);
        }
        ArrayList<Long> userIds = new ArrayList<Long>(10);
        if (!"personuserreldisable".equals(syncType)) {
            this.updateUserInfoStatus(status, errorMap, dbUserMap, paramList, userService, userIds, syncType);
        }
        if ("0".equals(status) && (userIds.size() > 0 || "personuserreldisable".equals(syncType)) && !"userdisable".equals(syncType)) {
            SyncPersonToUserServiceHelper.disableRel(beforeSavePersonUserRel);
        }
        if (errorMap.size() > 0) {
            return HRPIOperationServiceImpl.getResult(false, "user result error.", errorMap);
        }
        return HRPIOperationServiceImpl.getSuccess(null);
    }

    @Override
    public Map<String, Object> handleBackPerson(List<Map<String, Object>> tempUserList, String syncType, Map<String, String> errorMap) {
        List<DynamicObject> personInfo = this.getPersonInfo(tempUserList, syncType);
        Map<Long, List<Long>> personEmpListMap = tempUserList.stream().filter(map -> null != map.get("employeeid") && (Long)map.get("employeeid") > 0L).collect(Collectors.toMap(map -> (Long)map.get("personid"), map -> Collections.singletonList((Long)map.get("employeeid")), (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        }));
        List<Long> personIdsList = personInfo.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        DynamicObject[] beforeSavePersonUserRel = this.getRollBackUserRelate(personEmpListMap, personIdsList, syncType);
        List<Long> dbUserIds = Arrays.stream(beforeSavePersonUserRel).map(dy -> dy.getLong("user")).collect(Collectors.toList());
        DynamicObject[] bosUser = null;
        if (!CollectionUtils.isEmpty(dbUserIds)) {
            bosUser = HRPIBosUserRepository.getBosUserByIdAndSyn("id,enable,number,name", dbUserIds, syncType);
        }
        if (HRArrayUtils.isEmpty(bosUser)) {
            this.buildEmptyError(tempUserList, errorMap, "not have personuserrel data.");
            return HRPIOperationServiceImpl.getResult(false, "not have personuserrel data.", errorMap);
        }
        HashMap<Long, String> dbUserMap = new HashMap<Long, String>(16);
        List<UserParam> paramList = this.setBackUserInfo(bosUser, dbUserMap);
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        if (CollectionUtils.isEmpty(paramList)) {
            this.buildEmptyError(tempUserList, errorMap, "not have success data.");
            return HRPIOperationServiceImpl.getResult(false, "not have success data.", errorMap);
        }
        ArrayList<Long> userIds = new ArrayList<Long>(10);
        this.updUserInfoStatus(errorMap, dbUserMap, paramList, userService, userIds, syncType);
        if ("back_quit".equals(syncType)) {
            this.enableRel(beforeSavePersonUserRel);
        } else if ("back_join".equals(syncType)) {
            SyncPersonToUserServiceHelper.disableRel(beforeSavePersonUserRel);
        }
        if (errorMap.size() > 0) {
            return HRPIOperationServiceImpl.getResult(false, "user result error.", errorMap);
        }
        return HRPIOperationServiceImpl.getSuccess(null);
    }

    private DynamicObject[] getRollBackUserRelate(Map<Long, List<Long>> personEmpListMap, List<Long> personIdsList, String syncType) {
        ArrayList<DynamicObject> relate = new ArrayList<DynamicObject>();
        if (null != personEmpListMap && personEmpListMap.size() > 0) {
            List employeeIds = personEmpListMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            personIdsList.removeAll(Arrays.asList(personEmpListMap.keySet().toArray()));
            QFilter empQFilter = new QFilter("employee", "in", employeeIds);
            relate.addAll(Arrays.asList(HRPIBosUserRepository.getUserRelateByPersonInfo(empQFilter)));
        }
        DynamicObject[] personUserRelate = HRPIBosUserRepository.getPersonUserRelBySynType("person", personIdsList, syncType);
        relate.addAll(Arrays.asList(personUserRelate));
        return relate.toArray(new DynamicObject[relate.size()]);
    }

    @Override
    public Map<String, Object> handleDisEnablePerson(String status, List<Map<String, Object>> tempUserList, String syncType, Map<String, String> errorMap) {
        List<DynamicObject> personInfo = this.getPersonInfo(tempUserList, syncType);
        List<Long> personIdsList = personInfo.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        DynamicObject[] beforeSavePersonUserRel = HRPIBosUserRepository.getPersonUserRelBySynType("person", personIdsList, syncType);
        List<Long> dbUserIds = Arrays.stream(beforeSavePersonUserRel).map(dy -> dy.getLong("user")).collect(Collectors.toList());
        DynamicObject[] bosUser = null;
        if (!CollectionUtils.isEmpty(dbUserIds)) {
            bosUser = HRPIBosUserRepository.getBosUserByIdAndSyn("id,enable,isforbidden,number,name", dbUserIds, syncType);
        }
        if (HRArrayUtils.isEmpty(bosUser)) {
            this.buildEmptyError(tempUserList, errorMap, "not have personuserrel data.");
            return HRPIOperationServiceImpl.getResult(false, "not have personuserrel data.", errorMap);
        }
        HashMap<Long, String> dbUserMap = new HashMap<Long, String>(16);
        List<UserParam> paramList = this.setDisableUserInfo(status, errorMap, bosUser, dbUserMap);
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        if (paramList.size() <= 0) {
            this.buildEmptyError(tempUserList, errorMap, "not have success data.");
            return HRPIOperationServiceImpl.getResult(false, "not have success data.", errorMap);
        }
        ArrayList<Long> userIds = new ArrayList<Long>(10);
        this.updUserInfoStatus(errorMap, dbUserMap, paramList, userService, userIds, syncType);
        if (errorMap.size() > 0) {
            return HRPIOperationServiceImpl.getResult(false, "user result error.", errorMap);
        }
        return HRPIOperationServiceImpl.getSuccess(null);
    }

    private void buildEmptyError(List<Map<String, Object>> tempUserList, Map<String, String> errorMap, String tip) {
        for (Map<String, Object> tmp : tempUserList) {
            String number = (String)tmp.get("number");
            if (errorMap.size() != 0) continue;
            errorMap.put(number, tip);
        }
    }

    private void updateUserInfoStatus(String status, Map<String, String> errorMap, Map<Long, String> dbUserMap, List<UserParam> paramList, IUserService userService, List<Long> userIds, String syncType) {
        try (TXHandle txHandle = TX.requiresNew();){
            long startTime = System.currentTimeMillis();
            if ("0".equals(status) && !"userdisable".equals(syncType)) {
                userService.disableUser(paramList);
            } else if ("0".equals(status) && "userdisable".equals(syncType)) {
                userService.disableUser(paramList);
                userService.disable(paramList);
            } else if ("1".equals(status)) {
                userService.enableUser(paramList);
            }
            LOGGER.info(MessageFormat.format("disableUserUseTime:{0}", System.currentTimeMillis() - startTime));
            for (UserParam result : paramList) {
                if (!result.isSuccess()) {
                    this.buildErrorInfo(errorMap, result, result.getDataMap(), "0", dbUserMap);
                    continue;
                }
                if (!"0".equals(status)) continue;
                userIds.add(result.getId());
            }
        }
        catch (Exception esc) {
            LOGGER.error("invokeStatusUpdateError", (Throwable)esc);
            throw new KDBizException("invoke status update error." + this.subStringErrorInfo(esc));
        }
    }

    private void updUserInfoStatus(Map<String, String> errorMap, Map<Long, String> dbUserMap, List<UserParam> paramList, IUserService userService, List<Long> userIds, String syncType) {
        LOGGER.info("==updUserInfoStatus.parmas{}:==", paramList);
        try (TXHandle txHandle = TX.requiresNew();){
            long startTime = System.currentTimeMillis();
            if ("back_quit".equals(syncType)) {
                userService.enableUser(paramList);
                List disableUserList = paramList.stream().filter(userParam -> ((String)userParam.getDataMap().get("backenable")).equals("0")).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(disableUserList)) {
                    userService.enable(paramList);
                }
            }
            if ("back_join".equals(syncType)) {
                userService.disableUser(paramList);
                userService.disable(paramList);
            }
            if ("enble_bos_user".equals(syncType)) {
                userService.enable(paramList);
            }
            if ("disble_bos_user".equals(syncType)) {
                userService.disable(paramList);
            }
            LOGGER.info(MessageFormat.format("==updUserInfoStatus:{0}", System.currentTimeMillis() - startTime));
            for (UserParam result : paramList) {
                if (!result.isSuccess()) {
                    this.buildErrorInfo(errorMap, result, result.getDataMap(), "0", dbUserMap);
                    continue;
                }
                userIds.add(result.getId());
            }
        }
        catch (Exception esc) {
            LOGGER.error("invokeStatusUpdateError", (Throwable)esc);
            throw new KDBizException("invoke status update error." + this.subStringErrorInfo(esc));
        }
    }

    private List<UserParam> setDisableUserInfo(String status, Map<String, String> errorMap, DynamicObject[] bosUser, Map<Long, String> dbUserMap) {
        ArrayList<UserParam> paramList = new ArrayList<UserParam>();
        for (DynamicObject dy : bosUser) {
            String number = dy.getString("number");
            String name = dy.getString("name");
            dbUserMap.put(dy.getLong("id"), number);
            if (status.equals(dy.getString("enable"))) {
                errorMap.put(number, "has the same user status.");
                continue;
            }
            UserParam user = new UserParam();
            user.setId(dy.getLong("id"));
            HashMap<String, String> temMap = new HashMap<String, String>(16);
            temMap.put("name", name);
            temMap.put("number", number);
            user.setDataMap(temMap);
            paramList.add(user);
        }
        return paramList;
    }

    private List<UserParam> setBackUserInfo(DynamicObject[] bosUser, Map<Long, String> dbUserMap) {
        if (bosUser == null || bosUser.length == 0) {
            return new ArrayList<UserParam>(1);
        }
        ArrayList<UserParam> paramList = new ArrayList<UserParam>(bosUser.length);
        for (DynamicObject dy : bosUser) {
            String number = dy.getString("number");
            String name = dy.getString("name");
            dbUserMap.put(dy.getLong("id"), number);
            UserParam user = new UserParam();
            user.setId(dy.getLong("id"));
            HashMap temMap = Maps.newHashMapWithExpectedSize((int)4);
            temMap.put("name", name);
            temMap.put("number", number);
            temMap.put("backenable", dy.getString("enable"));
            user.setDataMap((Map)temMap);
            paramList.add(user);
        }
        return paramList;
    }

    private void enableRel(DynamicObject[] personUserRelDys) {
        try {
            DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
            if (personUserRelDys != null) {
                for (DynamicObject dy : personUserRelDys) {
                    dy.set("enable", (Object)"1");
                    dy.set("modifytime", (Object)new Date());
                    dy.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    dynamicObjects.add((Object)dy);
                }
                HRPIBosUserRepository.saveUser(dynamicObjects);
            }
        }
        catch (Exception esc) {
            LOGGER.error("handleStatusError", (Throwable)esc);
            throw new KDBizException("handle status error." + this.subStringErrorInfo(esc));
        }
    }

    @Override
    public Map<String, Object> handleJoinPerson(List<Map<String, Object>> tempUserList, String taskType, String syncType, Map<String, String> errorMap) {
        Map<Long, Long> successPersonAndBosIdRel;
        long startTime = System.currentTimeMillis();
        ArrayList<UserParam> userParams = new ArrayList<UserParam>(10);
        Map<String, Object> resultMap = HRPIOperationServiceImpl.getSuccess(null);
        List<DynamicObject> personsByNumberList = this.getPersonInfo(tempUserList, syncType);
        HashMap<String, Long> personNumberUserMap = new HashMap<String, Long>(16);
        HashMap<Long, Long> personUserIdMap = new HashMap<Long, Long>(16);
        DynamicObject[] beforeSavePersonUserRel = this.buildPersonAndUserRel(tempUserList, syncType, personsByNumberList, personNumberUserMap, personUserIdMap);
        Map<Long, Map<String, Long>> personModelIds = this.buildUserInfo(userParams, errorMap, personsByNumberList, syncType, personNumberUserMap, personUserIdMap, null);
        LOGGER.warn(MessageFormat.format("syncPersonToSysUerQueryTime->{0}", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime)));
        if (errorMap.size() > 0) {
            resultMap = HRPIOperationServiceImpl.getResult(false, "check data error.", errorMap);
        }
        if ((successPersonAndBosIdRel = this.saveUserInfo(userParams, errorMap, personsByNumberList)).size() == 0) {
            this.buildEmptyError(tempUserList, errorMap, "not have success data.");
            return HRPIOperationServiceImpl.getResult(false, "not have success data.", errorMap);
        }
        if ("userupdate".equals(syncType)) {
            this.enableBosUser(successPersonAndBosIdRel);
        }
        this.savePersonUserRelInfo(personModelIds, successPersonAndBosIdRel, beforeSavePersonUserRel);
        if (errorMap.size() > 0) {
            resultMap = HRPIOperationServiceImpl.getResult(false, "validate data error.", errorMap);
        }
        LOGGER.warn(MessageFormat.format("syncPersonToSysUerTotalTime:{0}", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime)));
        return resultMap;
    }

    private void enableBosUser(Map<Long, Long> successPersonAndBosIdRel) {
        Throwable throwable;
        TXHandle txHandle;
        List<Long> bosUserId = successPersonAndBosIdRel.values().stream().collect(Collectors.toList());
        DynamicObject[] bosUser = null;
        if (!CollectionUtils.isEmpty(bosUserId)) {
            bosUser = HRPIBosUserRepository.getBosUserById("id,enable,number,name,isforbidden", bosUserId);
        }
        if (Objects.isNull(bosUser)) {
            LOGGER.error("SyncPersonToUserServiceImpl#enableBosUser error, bosUser is null");
            return;
        }
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        List<DynamicObject> disableUser = Arrays.asList(bosUser).stream().filter(user -> HRStringUtils.equals((String)user.getString("enable"), (String)"0") || HRStringUtils.equals((String)user.getString("enable"), (String)"false")).collect(Collectors.toList());
        List<DynamicObject> forbiddenUser = Arrays.asList(bosUser).stream().filter(user -> HRStringUtils.equals((String)user.getString("isforbidden"), (String)"1") || HRStringUtils.equals((String)user.getString("isforbidden"), (String)"true")).collect(Collectors.toList());
        if (Objects.nonNull(disableUser) && disableUser.size() > 0) {
            List<UserParam> enableList = this.buildSyncStatusUserList(disableUser);
            try {
                txHandle = TX.notSupported();
                throwable = null;
                try {
                    userService.enable(enableList);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (txHandle != null) {
                        if (throwable != null) {
                            try {
                                txHandle.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            txHandle.close();
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("SyncPersonToUserServiceImpl#enableBosUser syncEnable error, the exception message is {}");
            }
        }
        if (Objects.nonNull(forbiddenUser) && forbiddenUser.size() > 0) {
            List<UserParam> enableUserList = this.buildSyncStatusUserList(forbiddenUser);
            try {
                txHandle = TX.notSupported();
                throwable = null;
                try {
                    userService.enableUser(enableUserList);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (txHandle != null) {
                        if (throwable != null) {
                            try {
                                txHandle.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            txHandle.close();
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("SyncPersonToUserServiceImpl#enableBosUser syncUserStatus error, the exception message is {}");
            }
        }
    }

    private List<UserParam> buildSyncStatusUserList(List<DynamicObject> bosUser) {
        ArrayList<UserParam> paramList = new ArrayList<UserParam>(10);
        for (DynamicObject dy : bosUser) {
            String number = dy.getString("number");
            String name = dy.getString("name");
            UserParam user = new UserParam();
            user.setId(dy.getLong("id"));
            HashMap<String, String> temMap = new HashMap<String, String>(16);
            temMap.put("name", name);
            temMap.put("number", number);
            user.setDataMap(temMap);
            paramList.add(user);
        }
        return paramList;
    }

    private DynamicObject[] buildPersonAndUserRel(List<Map<String, Object>> tempUserList, String syncType, List<DynamicObject> personsByNumberList, Map<String, Long> personNumberUserMap, Map<Long, Long> personUserIdMap) {
        Object[] bosUser;
        if (HRStringUtils.equals((String)syncType, (String)"useraddnew")) {
            return new DynamicObject[0];
        }
        List<Long> personIdsList = personsByNumberList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Object[] beforeSavePersonUserRel = null;
        if (!CollectionUtils.isEmpty(personIdsList)) {
            beforeSavePersonUserRel = HRPIBosUserRepository.getPersonUserRel("person", personIdsList, syncType);
            if (HRArrayUtils.isNotEmpty((Object[])beforeSavePersonUserRel)) {
                for (Object object : beforeSavePersonUserRel) {
                    personUserIdMap.put(object.getLong("person"), object.getLong("user"));
                }
            }
            if ("disableupdate".equals(syncType)) {
                LOGGER.info(MessageFormat.format("buildPersonAndUserRel:{0}", personNumberUserMap));
                personsByNumberList.removeIf(dy -> !personUserIdMap.containsKey(dy.getLong("id")));
            } else if ("userupdate".equals(syncType)) {
                Object[] oldPersonUserRel;
                HashMap<Long, Long> oldPersonNewPersonMap = new HashMap<Long, Long>();
                ArrayList<Long> oldPersonList = new ArrayList<Long>();
                for (Map<String, Object> map : tempUserList) {
                    if (map == null || map.get("oldpersonid") == null) continue;
                    oldPersonNewPersonMap.put((Long)map.get("oldpersonid"), (Long)map.get("personid"));
                    oldPersonList.add((Long)map.get("oldpersonid"));
                }
                if (oldPersonList.size() > 0 && HRArrayUtils.isNotEmpty((Object[])(oldPersonUserRel = HRPIBosUserRepository.getPersonUserRel("person", oldPersonList, syncType)))) {
                    for (Object dy4 : oldPersonUserRel) {
                        if (oldPersonNewPersonMap.get(dy4.getLong("person")) == null) continue;
                        personUserIdMap.put((Long)oldPersonNewPersonMap.get(dy4.getLong("person")), dy4.getLong("user"));
                    }
                }
            }
        }
        List<String> numbers = tempUserList.stream().map(tempMap -> (String)tempMap.get("number")).collect(Collectors.toList());
        QFilter nameFilter = null;
        if (!"update".equals(syncType)) {
            List nameList = tempUserList.stream().map(tempMap -> (String)tempMap.get("name")).collect(Collectors.toList());
            nameFilter = new QFilter("name", "in", nameList);
        }
        if (HRArrayUtils.isNotEmpty((Object[])(bosUser = HRPIBosUserRepository.getBosUser("id,enable,number,name", numbers, nameFilter)))) {
            for (Object userDy : bosUser) {
                personNumberUserMap.put(userDy.getString("number"), userDy.getLong("id"));
            }
        }
        if (HRArrayUtils.isEmpty((Object[])beforeSavePersonUserRel)) {
            return beforeSavePersonUserRel;
        }
        Map<Long, DynamicObject> map = Arrays.stream(beforeSavePersonUserRel).collect(Collectors.toMap(dy -> dy.getLong("user"), dy -> dy, (dy1, dy2) -> dy1));
        Object[] bosUserById = HRPIBosUserRepository.getBosUserById("id,name,number", new ArrayList<Long>(map.keySet()));
        if (HRArrayUtils.isEmpty((Object[])bosUserById)) {
            return beforeSavePersonUserRel;
        }
        for (Object userDy : bosUserById) {
            DynamicObject userPersonDy;
            long userId = userDy.getLong("id");
            String number = userDy.getString("number");
            Long personId = personNumberUserMap.get(number);
            if (personId == null || personId == 0L) {
                personNumberUserMap.put(number, userDy.getLong("id"));
            }
            if ((userPersonDy = map.get(userId)) == null) continue;
            long relPersonId = userPersonDy.getLong("person");
            personUserIdMap.put(relPersonId, userId);
        }
        return beforeSavePersonUserRel;
    }

    private List<DynamicObject> getPersonInfo(List<Map<String, Object>> tempUserList, String syncType) {
        Object[] personsByNumbers;
        ArrayList<DynamicObject> personsByNumberList = new ArrayList<DynamicObject>(10);
        ArrayList<Map<String, Object>> personIdList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> numberList = new ArrayList<Map<String, Object>>(10);
        for (Map<String, Object> tempMap2 : tempUserList) {
            if (tempMap2.containsKey("personid")) {
                Object persObj = tempMap2.get("personid");
                if (persObj instanceof Long) {
                    if ((Long)persObj != 0L) {
                        personIdList.add(tempMap2);
                        continue;
                    }
                    this.addNotEmptyData(numberList, tempMap2);
                    continue;
                }
                this.addNotEmptyData(numberList, tempMap2);
                continue;
            }
            this.addNotEmptyData(numberList, tempMap2);
        }
        List personIds = personIdList.stream().map(tempMap -> (Long)tempMap.get("personid")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(personIds)) {
            Object[] allPerson = null;
            allPerson = "back_join".equals(syncType) ? HRPIPersonRepository.getAllPersonById(new QFilter("id", "in", personIds)) : HRPIPersonRepository.getAllPerson(new QFilter("id", "in", personIds));
            if (HRArrayUtils.isNotEmpty((Object[])allPerson)) {
                personsByNumberList.addAll(Arrays.asList(allPerson));
                Map<Long, DynamicObject> numberMap = Arrays.stream(allPerson).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (dy1, dy2) -> dy1));
                for (Map<String, Object> tempMap3 : tempUserList) {
                    long personId;
                    DynamicObject dynamicObject;
                    Object persObj;
                    if (!tempMap3.containsKey("personid") || !((persObj = tempMap3.get("personid")) instanceof Long) || (dynamicObject = numberMap.get(personId = ((Long)tempMap3.get("personid")).longValue())) == null) continue;
                    tempMap3.put("number", dynamicObject.getString("number"));
                    tempMap3.put("name", dynamicObject.getString("name"));
                }
            }
        }
        List<String> numbers = numberList.stream().map(tempMap -> (String)tempMap.get("number")).collect(Collectors.toList());
        List<String> nameList = new ArrayList<String>();
        if (!"update".equals(syncType)) {
            nameList = numberList.stream().map(tempMap -> (String)tempMap.get("name")).collect(Collectors.toList());
        }
        if (HRArrayUtils.isNotEmpty((Object[])(personsByNumbers = HRPIPersonRepository.getPersonsByNumber("id,name,number,personindexid", numbers, nameList)))) {
            personsByNumberList.addAll(Arrays.asList(personsByNumbers));
        }
        return personsByNumberList;
    }

    private void addNotEmptyData(List<Map<String, Object>> numberList, Map<String, Object> tempMap) {
        if (HRStringUtils.isNotEmpty((String)((String)tempMap.get("number"))) && HRStringUtils.isNotEmpty((String)((String)tempMap.get("name")))) {
            numberList.add(tempMap);
        }
    }

    private Map<Long, Map<String, Long>> buildUserInfo(List<UserParam> userParams, Map<String, String> errorMap, List<DynamicObject> personsByNumberList, String syncType, Map<String, Long> personNumberUserMap, Map<Long, Long> personUserIdMap, List<Long> employeeId) {
        long startTime = System.currentTimeMillis();
        Map<Long, DynamicObject> personMap = personsByNumberList.stream().collect(Collectors.toMap(appDy -> appDy.getLong("id"), appDy -> appDy, (key1, key2) -> key1));
        ArrayList<Long> personIdList = new ArrayList<Long>(personMap.keySet());
        Map<Long, DynamicObject> timePersonMap = this.transferPersonDyToMap(personIdList, "hrpi_pernontsprop", null);
        Map<Long, DynamicObjectCollection> perceMap = this.transferPersonDyToListMap(personIdList, "hrpi_percre");
        Map<Long, DynamicObject> contactAttMap = this.transferPersonDyToMap(personIdList, "hrpi_percontact", null);
        Map<Long, DynamicObjectCollection> addressMap = this.transferPersonDyToListMap(personIdList, "hrpi_peraddress");
        Object[] empposeDys = null;
        if (!CollectionUtils.isEmpty(employeeId)) {
            empposeDys = HRPIDepempRepository.getEmpposOrgrelByEmployeeIds(employeeId);
        } else if (!CollectionUtils.isEmpty(personIdList)) {
            empposeDys = HRPIDepempRepository.getEmpposOrgrelByPersonIds(personIdList);
        }
        LOGGER.warn(MessageFormat.format("syncPersonToSysUerQueryBaseTime->{0}", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime)));
        Map<Long, DynamicObject> employeeMap = this.buildEmpPosePersonCache((DynamicObject[])empposeDys, "employee");
        Map<Long, DynamicObject> postMap = this.buildEmpPosePersonCache((DynamicObject[])empposeDys, "hbpm_positionhr");
        Map<Long, DynamicObject> stdPostMap = this.buildEmpPosePersonCache((DynamicObject[])empposeDys, "hbpm_stposition");
        List<Object> bosPositionIdList = Lists.newArrayListWithExpectedSize((int)0);
        if (this.getPosSynPlatParam()) {
            try {
                HRBaseServiceHelper bosPositionHelper = new HRBaseServiceHelper("bos_position");
                DynamicObject[] allBosPositionDynArr = bosPositionHelper.loadDynamicObjectArray(new QFilter[]{QFilterUtil.alwaysEqualsFilter()});
                bosPositionIdList = Arrays.stream(allBosPositionDynArr).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
            }
            catch (Exception ex) {
                LOGGER.error("buildUserInfo query bosposition error!", (Throwable)ex);
            }
        }
        LOGGER.warn(MessageFormat.format("syncPersonToSysUerQueryIdTime->{0}", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime)));
        HRPIChargePersonRepository chargePersonRepository = HRPIChargePersonRepository.getInstance();
        HashMap<Long, Boolean> depEmpAreChargeMap = new HashMap(personsByNumberList.size());
        if (HRArrayUtils.isNotEmpty((Object[])empposeDys)) {
            Set<Long> depIds = Arrays.stream(empposeDys).map(dy -> dy.getLong("depemp.id")).collect(Collectors.toSet());
            depEmpAreChargeMap = chargePersonRepository.isDepEmpAreCharge(depIds);
        }
        LOGGER.warn(MessageFormat.format("syncPersonToSysUerQueryMainTime->{0}", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime)));
        HashMap<Long, Map<String, Long>> personModelIds = new HashMap<Long, Map<String, Long>>(16);
        Map<Long, DynamicObjectCollection> empPosMap = this.assessMultParams((DynamicObject[])empposeDys, personModelIds, employeeMap, personMap);
        Map<Long, Long> superUserMap = this.buildSuperior((DynamicObject[])empposeDys, syncType);
        LOGGER.info("SyncPersonToUserServiceImpl.buildUserInfo.superUserMap={}", superUserMap);
        Map<String, DynamicObject> contactTypeMap = this.genContactDy();
        ArrayList<Long> personSet = new ArrayList<Long>(10);
        for (DynamicObject personDy : personsByNumberList) {
            StringBuilder errorStr = new StringBuilder();
            String number = personDy.getString("number");
            long dbPid = personDy.getLong("id");
            UserParam userParam = new UserParam();
            Long userId = personUserIdMap.get(dbPid);
            if (userId == null || userId == 0L) {
                userId = personNumberUserMap.get(number);
            }
            if (userId != null && userId != 0L) {
                userParam.setId(userId.longValue());
            } else if ("update".equals(syncType)) {
                errorStr.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u7528\u6237\u4e0d\u5b58\u5728\u6216\u7cfb\u7edf\u7528\u6237\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d\uff0c\u8bf7\u65b0\u589e\u6216\u4fee\u6539\u4f7f\u7528\u72b6\u6001\u540e\u66f4\u65b0\u3002", (String)"SyncPersonToUserServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
                errorMap.put(number, errorStr.toString());
            }
            Map<String, Object> dataMap = this.buildBaseInfo(personMap, timePersonMap, contactAttMap, perceMap, personDy, errorStr);
            long personId = personDy.getLong("id");
            DynamicObjectCollection empPoseRelDys = empPosMap.get(personId);
            if (CollectionUtils.isEmpty((Collection)empPoseRelDys)) {
                personSet.add(personId);
            }
            this.buildEmpposeRel(empPoseRelDys, dataMap, errorStr, superUserMap, postMap, stdPostMap, depEmpAreChargeMap, bosPositionIdList);
            this.buildContact(addressMap, dataMap, contactAttMap, personDy, contactTypeMap);
            if (HRStringUtils.isEmpty((String)errorStr.toString())) {
                userParam.setDataMap(dataMap);
                userParams.add(userParam);
            } else {
                errorMap.put(number, errorStr.toString());
            }
            this.updateSyncUserParam(new SyncParamModel(userParam, personDy));
        }
        this.handleEmpDep(personModelIds, personSet, personMap);
        return personModelIds;
    }

    private boolean getPosSynPlatParam() {
        try {
            HRBaseServiceHelper odcConfigParamHelper = new HRBaseServiceHelper("haos_odcconfigparam");
            QFilter synPlatFormFilter = new QFilter("number", "=", (Object)"isPositionSyncPlatform");
            DynamicObject odcConfigParamDyn = odcConfigParamHelper.loadDynamicObject(new QFilter[]{synPlatFormFilter});
            if (Objects.isNull(odcConfigParamDyn)) {
                return false;
            }
            String paramValue = odcConfigParamDyn.getString("value");
            return HRStringUtils.equals((String)"1", (String)paramValue);
        }
        catch (Exception ex) {
            LOGGER.error("getPosSynPlatParam error!", (Throwable)ex);
            return false;
        }
    }

    private void updateSyncUserParam(SyncParamModel syncParamModel) {
        HRPluginProxy pluginProxy = new HRPluginProxy(null, ISyncUserService.class, SCENCE, null);
        pluginProxy.callReplace(plugin -> {
            plugin.updateSyncUserParam(syncParamModel);
            return null;
        });
    }

    private void handleEmpDep(Map<Long, Map<String, Long>> personModelIds, List<Long> personSet, Map<Long, DynamicObject> personIdMaps) {
        if (personSet.size() == 0) {
            return;
        }
        DynamicObject[] depDys = HRPIDepempRepository.getDepEmpByPersonIds(personSet);
        if (depDys == null || depDys.length == 0) {
            return;
        }
        Map<Long, DynamicObject> employeeMap = this.buildEmpPosePersonCache(depDys, "employee");
        for (DynamicObject dynamicObject : depDys) {
            long personId = dynamicObject.getLong("person.id");
            boolean primary = dynamicObject.getBoolean("isprimary");
            if (!primary) continue;
            this.buildPersonModelIds(personModelIds, employeeMap, personIdMaps, dynamicObject, personId);
        }
    }

    private Map<Long, Long> buildSuperior(DynamicObject[] empposeDys, String syncType) {
        Map dataMap;
        long startTime = System.currentTimeMillis();
        if (empposeDys == null || empposeDys.length == 0) {
            return new HashMap<Long, Long>(16);
        }
        List<Long> empId = Arrays.stream(empposeDys).map(dy -> dy.getLong("depemp.id")).collect(Collectors.toList());
        HashMap personMap = new HashMap(empId.size());
        IPersonRoleService personRoleService = PersonRoleServiceImpl.getInstance();
        LOGGER.info("SyncPersonToUserServiceImpl#buildSuperior.empId:{}", empId);
        Map<Long, List<Map<String, Object>>> directSuperiorMap = personRoleService.getDirectSuperiorByDepempId(empId);
        LOGGER.info("SyncPersonToUserServiceImpl#buildSuperior.directSuperiorMap:{}", directSuperiorMap);
        LOGGER.warn(MessageFormat.format("syncPersonToSysUerQuerySuperiorTime->{0}", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime)));
        HashMap<Long, List<Long>> supPersonIdMap = new HashMap<Long, List<Long>>(empId.size());
        ArrayList personIds = new ArrayList(empId.size());
        for (Map.Entry<Long, List<Map<String, Object>>> directSuperior : directSuperiorMap.entrySet()) {
            List<Map<String, Object>> superiors = directSuperior.getValue();
            if (superiors == null || superiors.size() <= 0) continue;
            Long emp = directSuperior.getKey();
            List superIds = superiors.stream().map(tempMap -> (Long)tempMap.get("person.id")).collect(Collectors.toList());
            supPersonIdMap.put(emp, superIds);
            personIds.addAll(superIds);
        }
        LOGGER.info("SyncPersonToUserServiceImpl#buildSuperior.supPersonIdMap:{}, personIds:{}", supPersonIdMap, personIds);
        if (supPersonIdMap.size() == 0) {
            return new HashMap<Long, Long>(16);
        }
        HashMap<String, List<Long>> personIdMap = new HashMap<String, List<Long>>();
        personIdMap.put("person", personIds);
        IPersonService personService = PersonServiceImpl.getInstance();
        Map<String, Object> personUserInfo = personService.getUserIdByPersonInfo(personIdMap);
        if (personUserInfo != null && personUserInfo.size() > 0 && (dataMap = (Map)personUserInfo.get("data")) != null && dataMap.size() > 0) {
            for (Map.Entry data : dataMap.entrySet()) {
                Map value = (Map)data.getValue();
                if (value == null || value.size() <= 0) continue;
                personMap.put(data.getKey(), (Long)value.get("user"));
            }
        }
        LOGGER.info("SyncPersonToUserServiceImpl#buildSuperior.personMap:{}", personMap);
        HashMap<Long, Long> retMap = new HashMap<Long, Long>(supPersonIdMap.size());
        block2: for (Map.Entry supMap : supPersonIdMap.entrySet()) {
            List superIds = (List)supMap.getValue();
            for (Long superId : superIds) {
                Long userId = (Long)personMap.get(superId);
                if (userId == null || userId == 0L) continue;
                retMap.put((Long)supMap.getKey(), userId);
                continue block2;
            }
        }
        LOGGER.info("SyncPersonToUserServiceImpl#buildSuperior.retMap:{}", retMap);
        if (!"2".equals(syncType)) {
            this.recordErrorLogRetrySync(empposeDys, empId, supPersonIdMap, retMap);
        }
        return retMap;
    }

    private void recordErrorLogRetrySync(DynamicObject[] empposeDys, List<Long> empId, Map<Long, List<Long>> supPersonIdMap, HashMap<Long, Long> retMap) {
        if (supPersonIdMap.size() == retMap.size()) {
            return;
        }
        ArrayList<Map<String, Object>> userList = new ArrayList<Map<String, Object>>(10);
        Map<Long, Long> depEmpAndPersonIdMap = Arrays.stream(empposeDys).collect(Collectors.toMap(dy -> dy.getLong("depemp.id"), dy -> dy.getLong("person.id"), (k1, k2) -> k1));
        HashSet<Long> syncPersonSet = new HashSet<Long>(16);
        for (Long depEmpId : empId) {
            Long superUserId;
            List<Long> superPersonIds = supPersonIdMap.get(depEmpId);
            if (CollectionUtils.isEmpty(superPersonIds) || (superUserId = retMap.get(depEmpId)) != null && superUserId != 0L) continue;
            Long syncPersonId = depEmpAndPersonIdMap.get(depEmpId);
            this.addSyncPerson(userList, syncPersonSet, syncPersonId);
            this.addSyncPerson(userList, syncPersonSet, superPersonIds.get(0));
        }
        if (!CollectionUtils.isEmpty(userList)) {
            this.recordLog(userList, new HashMap<String, Object>(), null, null, "0", "0");
        }
    }

    private void addSyncPerson(List<Map<String, Object>> userList, Set<Long> syncPersonSet, Long syncPersonId) {
        if (syncPersonSet.add(syncPersonId)) {
            HashMap<String, Object> tmpMap = new HashMap<String, Object>(16);
            tmpMap.put("personid", syncPersonId);
            tmpMap.put("synctype", "join");
            userList.add(tmpMap);
        }
    }

    private Map<Long, DynamicObject> buildEmpPosePersonCache(DynamicObject[] empposeDys, String entityName) {
        if (HRArrayUtils.isEmpty((Object[])empposeDys)) {
            return new HashMap<Long, DynamicObject>(16);
        }
        if ("person".equals(entityName)) {
            Set personIds = Arrays.stream(empposeDys).map(dy -> dy.getLong("person.id")).collect(Collectors.toSet());
            DynamicObject[] personDys = HRPIPersonRepository.listPersons(new ArrayList<Long>(personIds));
            return this.buildDataMap(personDys);
        }
        if ("employee".equals(entityName)) {
            Set<Long> employeeIds = Arrays.stream(empposeDys).map(dy -> dy.getLong("employee.id")).collect(Collectors.toSet());
            DynamicObject[] employeeDys = HRPIEmployeeRepository.listEmployeeIds(employeeIds);
            return this.buildDataMap(employeeDys);
        }
        if ("hbpm_positionhr".equals(entityName)) {
            Set<Long> postIds = Arrays.stream(empposeDys).map(dy -> dy.getLong("position.id")).collect(Collectors.toSet());
            Set stfPostIds = Arrays.stream(empposeDys).filter(dy -> dy.getLong("darkposition.id") != 0L).map(dy -> dy.getLong("darkposition.id")).collect(Collectors.toSet());
            if (stfPostIds.size() > 0) {
                postIds.addAll(stfPostIds);
            }
            return this.setBaseDataMap("id,name,job.name", postIds, "hbpm_positionhr");
        }
        if ("hbpm_stposition".equals(entityName)) {
            Set<Long> stdPostIds = Arrays.stream(empposeDys).map(dy -> dy.getLong("stdposition.id")).collect(Collectors.toSet());
            return this.setBaseDataMap("id,name", stdPostIds, "hbpm_stposition");
        }
        return new HashMap<Long, DynamicObject>(16);
    }

    private Map<Long, DynamicObject> buildDataMap(DynamicObject[] employeeDys) {
        if (employeeDys != null && employeeDys.length > 0) {
            return Arrays.stream(employeeDys).collect(Collectors.toMap(appDy -> appDy.getLong("id"), appDy -> appDy, (v1, v2) -> v1));
        }
        return new HashMap<Long, DynamicObject>(16);
    }

    private Map<Long, DynamicObject> setBaseDataMap(String props, Set<Long> postIds, String entityName) {
        HRBaseServiceHelper postHelper = new HRBaseServiceHelper(entityName);
        QFilter qFilter = new QFilter("id", "in", postIds);
        DynamicObject[] postDys = postHelper.queryOriginalArray(props, new QFilter[]{qFilter});
        return this.buildDataMap(postDys);
    }

    private void savePersonUserRelInfo(Map<Long, Map<String, Long>> personModelIds, Map<Long, Long> successPersonAndBosIdRel, DynamicObject[] personUserRel) {
        try {
            Map<Long, DynamicObject> personUserRelMap = Arrays.stream(personUserRel).collect(Collectors.toMap(appDy -> appDy.getLong("person"), appDy -> appDy, (k1, k2) -> k1));
            HRBaseServiceHelper personUserRelHelper = HRPIBosUserRepository.getPersonUserRelHelper();
            DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
            for (Map.Entry<Long, Long> tempIdMap : successPersonAndBosIdRel.entrySet()) {
                long personId = tempIdMap.getKey();
                Long userId = tempIdMap.getValue();
                Map<String, Long> idMapValue = personModelIds.get(personId);
                if (idMapValue == null) continue;
                DynamicObject tmpDy = personUserRelHelper.generateEmptyDynamicObject();
                DynamicObject userDy = personUserRelMap.get(personId);
                if (userDy != null) {
                    userDy.set("id", (Object)userDy.getLong("id"));
                    userDy.set("user", (Object)userId);
                    this.setDyInfo(dynamicObjects, userDy, idMapValue, "0");
                    continue;
                }
                tmpDy.set("user", (Object)userId);
                this.setDyInfo(dynamicObjects, tmpDy, idMapValue, "1");
            }
            HRPIBosUserRepository.saveUser(dynamicObjects);
        }
        catch (Exception ex) {
            LOGGER.error("handleRelationError", (Throwable)ex);
            throw new KDBizException("handle relation error." + this.subStringErrorInfo(ex));
        }
    }

    private Map<Long, Long> saveUserInfo(List<UserParam> userParams, Map<String, String> errorMap, List<DynamicObject> personsByNumberList) {
        Map<String, Long> numberPersonIdMap = personsByNumberList.stream().collect(Collectors.toMap(appDy -> appDy.getString("number"), appDy -> appDy.getLong("id"), (key1, key2) -> key1));
        HashMap<Long, Long> userIdAndNumber = new HashMap<Long, Long>(16);
        try (TXHandle txHandle = TX.notSupported();){
            if (userParams.size() > 0) {
                IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
                long startTime = System.currentTimeMillis();
                userService.addOrUpdate(userParams);
                LOGGER.warn(MessageFormat.format("syncPersonToSysUerSaveTime:{0}", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime)));
            }
            for (UserParam result : userParams) {
                Map dataMap = result.getDataMap();
                if (result.isSuccess()) {
                    if (dataMap == null) continue;
                    String number = (String)dataMap.get("number");
                    Long personId = numberPersonIdMap.get(number);
                    userIdAndNumber.put(personId, result.getId());
                    continue;
                }
                this.buildErrorInfo(errorMap, result, dataMap, "1", null);
            }
        }
        catch (Exception ex) {
            LOGGER.error("handleSaveInfoSyncError", (Throwable)ex);
            throw new KDBizException("invoke save error." + this.subStringErrorInfo(ex));
        }
        return userIdAndNumber;
    }

    @Override
    public void recordLog(List<Map<String, Object>> userList, Map<String, Object> errorMap, Exception ex, String validateError, String status, String taskType) {
        HRBaseServiceHelper syncLogHelper = HRPIBosUserRepository.getSyncLogHelper();
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        for (Map<String, Object> tempMap : userList) {
            String number = (String)tempMap.get("number");
            String name = (String)tempMap.get("name");
            HashMap<String, Object> temMap = new HashMap<String, Object>(16);
            String syncType = (String)tempMap.get("synctype");
            temMap.put("number", number);
            temMap.put("name", name);
            temMap.put("personid", tempMap.get("personid"));
            temMap.put("synctype", syncType);
            DynamicObject dynamicObject = syncLogHelper.generateEmptyDynamicObject();
            dynamicObject.set("number", (Object)number);
            dynamicObject.set("synctype", (Object)syncType);
            dynamicObject.set("name", (Object)name);
            dynamicObject.set("param", (Object)SerializationUtils.toJsonString(temMap));
            dynamicObject.set("status", (Object)status);
            if ("0".equals(validateError) && errorMap.size() > 0) {
                this.buildErrorMessage(errorMap, number, dynamicObject);
            } else {
                this.buildValidateError(errorMap, number, dynamicObject);
            }
            if ("1".equals(taskType)) {
                dynamicObject.set("trytime", (Object)3);
            }
            this.buildError(ex, dynamicObject);
            long accountId = RequestContext.get().getCurrUserId();
            long admin = 1L;
            if (accountId != 0L) {
                admin = accountId;
            }
            dynamicObject.set("creator", (Object)admin);
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObjects.add((Object)dynamicObject);
        }
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            HRPIBosUserRepository.saveSyncLog(dynamicObjects);
        }
    }

    private void buildValidateError(Map<String, Object> errorMap, String number, DynamicObject dynamicObject) {
        if (errorMap != null && errorMap.size() > 0) {
            Object errObj = errorMap.get(number);
            if (errObj != null) {
                dynamicObject.set("rtparam", errObj);
            } else {
                dynamicObject.set("rtparam", (Object)"validate date not pass");
            }
        } else {
            dynamicObject.set("rtparam", (Object)"validate date not pass");
        }
        dynamicObject.set("status", (Object)"0");
    }

    private void buildError(Exception ex, DynamicObject dynamicObject) {
        if (ex != null) {
            String message = ex.getMessage();
            int length = 200;
            if (ex instanceof KDBizException) {
                dynamicObject.set("errorlog", (Object)this.doSubString(length, message));
                dynamicObject.set("errorlog_tag", (Object)ex.getMessage());
            } else {
                dynamicObject.set("errorlog", (Object)this.doSubString(length, message));
                dynamicObject.set("errorlog_tag", (Object)this.subStringErrorInfo(ex));
            }
        }
    }

    private void buildErrorMessage(Map<String, Object> errorMap, String number, DynamicObject dynamicObject) {
        Object dataObj = errorMap.get("data");
        if (dataObj instanceof Map) {
            Object strObj = ((Map)dataObj).get(number);
            if (strObj instanceof String) {
                String errorString = (String)strObj;
                this.buildEmptyMapOrErrorInfo(dynamicObject, errorString);
            } else {
                dynamicObject.set("status", (Object)"1");
                dynamicObject.set("rtparam", (Object)"");
            }
        } else {
            dynamicObject.set("rtparam", dataObj);
        }
    }

    private void buildEmptyMapOrErrorInfo(DynamicObject dynamicObject, String errorString) {
        if (HRStringUtils.isNotEmpty((String)errorString) && errorString.length() > 2000) {
            dynamicObject.set("rtparam", (Object)errorString.substring(0, 2000));
        } else {
            dynamicObject.set("rtparam", (Object)errorString);
        }
        dynamicObject.set("status", (Object)"0");
    }

    private void buildErrorInfo(Map<String, String> errorMap, UserParam result, Map<String, Object> dataMap, String type, Map<Long, String> dbUserMap) {
        if (dataMap != null || HRStringUtils.isNotEmpty((String)result.getMsg())) {
            String number = null;
            if ("0".equals(type)) {
                number = dbUserMap.get(result.getId());
                if (HRStringUtils.isEmpty((String)number)) {
                    number = String.valueOf(result.getId());
                }
            } else if ("1".equals(type) && dataMap != null) {
                number = (String)dataMap.get("number");
            }
            String error = errorMap.get(number);
            String msg = result.getMsg();
            error = HRStringUtils.isNotEmpty((String)error) ? error + msg : msg;
            errorMap.put(number, error);
        }
    }

    private void setDyInfo(DynamicObjectCollection dynamicObjects, DynamicObject userDy, Map<String, Long> idMapValue, String type) {
        long currUserId = RequestContext.get().getCurrUserId();
        userDy.set("person", (Object)idMapValue.get("person"));
        userDy.set("personindexid", (Object)idMapValue.get("personindexid"));
        userDy.set("employee", (Object)idMapValue.get("employee"));
        userDy.set("mid", (Object)idMapValue.get("mid"));
        userDy.set("cmpemp", (Object)idMapValue.get("cmpemp"));
        if (null == userDy.getString("enable")) {
            userDy.set("enable", (Object)"1");
        }
        if ("0".equals(type)) {
            userDy.set("modifytime", (Object)new Date());
            if (currUserId == 0L) {
                userDy.set("modifier", (Object)1);
            } else {
                userDy.set("modifier", (Object)currUserId);
            }
        } else {
            userDy.set("modifytime", (Object)new Date());
            userDy.set("createtime", (Object)new Date());
            if (currUserId == 0L) {
                userDy.set("creator", (Object)1);
            } else {
                userDy.set("creator", (Object)currUserId);
            }
        }
        dynamicObjects.add((Object)userDy);
    }

    public static Map<Long, Long> getDepCateGory(DynamicObject[] empposeDys) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_postype");
        Map<Long, Long> retMap = new HashMap<Long, Long>(16);
        if (HRArrayUtils.isEmpty((Object[])empposeDys)) {
            return retMap;
        }
        Set pstypeSet = Arrays.stream(empposeDys).map(dy -> dy.getLong("postype.id")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(pstypeSet)) {
            return retMap;
        }
        QFilter qFilter = new QFilter("id", "in", pstypeSet);
        Object[] dys = serviceHelper.query("postcategory", new QFilter[]{qFilter});
        if (HRArrayUtils.isNotEmpty((Object[])dys)) {
            retMap = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("postcategory.id")));
        }
        return retMap;
    }

    private Map<Long, DynamicObjectCollection> assessMultParams(DynamicObject[] empposeDys, Map<Long, Map<String, Long>> personModelIds, Map<Long, DynamicObject> employeeMap, Map<Long, DynamicObject> personIdMap) {
        if (empposeDys == null || empposeDys.length == 0) {
            return new HashMap<Long, DynamicObjectCollection>(16);
        }
        HashMap<Long, DynamicObjectCollection> retMap = new HashMap<Long, DynamicObjectCollection>(16);
        for (DynamicObject dynamicObject : empposeDys) {
            long personId = dynamicObject.getLong("person.id");
            String primary = dynamicObject.getString("isprimary");
            DynamicObjectCollection oldList = (DynamicObjectCollection)retMap.get(personId);
            if (oldList == null || oldList.size() == 0) {
                oldList = new DynamicObjectCollection();
            }
            if ("1".equals(primary)) {
                this.buildPersonModelIds(personModelIds, employeeMap, personIdMap, dynamicObject, personId);
            }
            oldList.add((Object)dynamicObject);
            retMap.put(personId, oldList);
        }
        return retMap;
    }

    private void buildPersonModelIds(Map<Long, Map<String, Long>> personModelIds, Map<Long, DynamicObject> employeeMap, Map<Long, DynamicObject> personIdMap, DynamicObject dynamicObject, long personId) {
        HashMap<String, Long> tempMap = new HashMap<String, Long>(16);
        tempMap.put("person", personId);
        DynamicObject perDy = personIdMap.get(personId);
        if (perDy != null) {
            tempMap.put("personindexid", perDy.getLong("personindexid"));
        } else {
            tempMap.put("personindexid", 0L);
        }
        long employeeId = dynamicObject.getLong("employee.id");
        tempMap.put("employee", employeeId);
        DynamicObject empDy = employeeMap.get(employeeId);
        if (empDy != null) {
            tempMap.put("mid", empDy.getLong("mid"));
        } else {
            tempMap.put("mid", 0L);
        }
        tempMap.put("cmpemp", dynamicObject.getLong("cmpemp.id"));
        personModelIds.put(personId, tempMap);
    }

    private void buildContact(Map<Long, DynamicObjectCollection> addressMap, Map<String, Object> dataMap, Map<Long, DynamicObject> contactAttMap, DynamicObject personDy, Map<String, DynamicObject> contactTypeMap) {
        DynamicObjectCollection addDys;
        long personId = personDy.getLong("id");
        HRBaseServiceHelper bosUserHelper = HRPIBosUserRepository.getBosUserHelper();
        DynamicObjectCollection contactDys = new DynamicObjectCollection();
        DynamicObject contactDy = contactAttMap.get(personId);
        int index = 0;
        if (contactDy != null) {
            String workPhone;
            String mail;
            String phone = contactDy.getString("phone");
            if (HRStringUtils.isNotEmpty((String)phone)) {
                DynamicObject contactEntryDy = bosUserHelper.generateEmptyEntryDynamicObject("contactentity");
                contactEntryDy.set("contacttype", (Object)contactTypeMap.get("3"));
                contactEntryDy.set("contact", (Object)phone);
                contactEntryDy.set("seq", (Object)index);
                ++index;
                contactDys.add((Object)contactEntryDy);
            }
            if (HRStringUtils.isNotEmpty((String)(mail = contactDy.getString("peremail")))) {
                DynamicObject contactEntryDy = bosUserHelper.generateEmptyEntryDynamicObject("contactentity");
                contactEntryDy.set("contacttype", (Object)contactTypeMap.get("2"));
                contactEntryDy.set("contact", (Object)mail);
                contactEntryDy.set("seq", (Object)index);
                ++index;
                contactDys.add((Object)contactEntryDy);
            }
            if (HRStringUtils.isNotEmpty((String)(workPhone = contactDy.getString("workphone")))) {
                DynamicObject contactEntryDy = bosUserHelper.generateEmptyEntryDynamicObject("contactentity");
                contactEntryDy.set("contacttype", (Object)contactTypeMap.get("4"));
                contactEntryDy.set("contact", (Object)workPhone);
                contactEntryDy.set("seq", (Object)index);
                ++index;
                contactDys.add((Object)contactEntryDy);
            }
        }
        if ((addDys = addressMap.get(personId)) != null && addDys.size() > 0) {
            DynamicObject addDy = (DynamicObject)addDys.get(0);
            long countryCode = addDy.getLong("countrycode.id");
            dataMap.put("country", countryCode);
            String addressInfo = addDy.getString("addressinfo");
            if (HRStringUtils.isNotEmpty((String)addressInfo)) {
                DynamicObject contactEntryDy = bosUserHelper.generateEmptyEntryDynamicObject("contactentity");
                contactEntryDy.set("contacttype", (Object)contactTypeMap.get("1"));
                contactEntryDy.set("contact", (Object)addressInfo);
                contactEntryDy.set("seq", (Object)index);
                contactDys.add((Object)contactEntryDy);
            }
        } else {
            dataMap.put("country", null);
        }
        if (contactDys.size() > 0) {
            dataMap.put("contactentity", contactDys);
        }
    }

    private Map<String, DynamicObject> genContactDy() {
        HRBaseServiceHelper contactTypeHelper = new HRBaseServiceHelper("bos_user_contacttype");
        QFilter qFilter = new QFilter("id", ">", (Object)0L);
        Object[] dynamicObjects = contactTypeHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        if (HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return new HashMap<String, DynamicObject>(4);
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getString("id"), dy -> dy));
    }

    private void buildEmpposeRel(DynamicObjectCollection empPoseRelDys, Map<String, Object> dataMap, StringBuilder errorStr, Map<Long, Long> superUserMap, Map<Long, DynamicObject> postMap, Map<Long, DynamicObject> stdPostMap, Map<Long, Boolean> depEmpAreChargeMap, List<Long> bosPositionIdList) {
        if (CollectionUtils.isEmpty((Collection)empPoseRelDys)) {
            return;
        }
        ArrayList<HashMap<String, Object>> posList = new ArrayList<HashMap<String, Object>>();
        for (DynamicObject empPose : empPoseRelDys) {
            HashMap<String, Object> entryMap = new HashMap<String, Object>(16);
            long adminOrg = empPose.getLong("adminorg.id");
            long positionLong = empPose.getLong("position.id");
            if (this.getPosSynPlatParam()) {
                this.setPositionValueNew(errorStr, bosPositionIdList, postMap, empPose, entryMap, adminOrg, positionLong);
            } else {
                this.setPositionValueOld(errorStr, postMap, stdPostMap, empPose, entryMap, adminOrg, positionLong);
            }
            if (HRStringUtils.isNotEmpty((String)errorStr.toString())) break;
            if (depEmpAreChargeMap != null) {
                entryMap.put("isincharge", depEmpAreChargeMap.get(empPose.getLong("depemp.id")));
            }
            entryMap.put("dpt", adminOrg);
            entryMap.put("superior", superUserMap.get(empPose.getLong("depemp.id")));
            String primary = empPose.getString("isprimary");
            if ("1".equals(primary)) {
                entryMap.put("ispartjob", "0");
            } else {
                entryMap.put("ispartjob", "1");
            }
            posList.add(entryMap);
        }
        if (posList.size() > 0) {
            dataMap.put("entryentity", posList);
        }
    }

    private void setPositionValueNew(StringBuilder errorStr, List<Long> bosPositionIdList, Map<Long, DynamicObject> postMap, DynamicObject empPose, Map<String, Object> entryMap, long adminOrg, long positionLong) {
        if (adminOrg == 0L) {
            errorStr.append("department is empty.");
        }
        if (positionLong == 0L) {
            errorStr.append("position is empty.");
        }
        if (!HRStringUtils.isEmpty((String)errorStr.toString())) {
            return;
        }
        String aPositionType = empPose.getString("apositiontype");
        if (HRStringUtils.equals((String)aPositionType, (String)"1")) {
            LOGGER.info("setPositionValueNew aPositionType:position");
            if (bosPositionIdList.contains(positionLong)) {
                LOGGER.info("setPositionValueNew bosPositionIdList contains positionLong");
                entryMap.put("post", positionLong);
                DynamicObject positionDyn = postMap.get(positionLong);
                if (Objects.isNull(positionDyn)) {
                    errorStr.append("position is not exist.");
                    return;
                }
                String jobName = positionDyn.getString("job.name");
                if (!HRStringUtils.isEmpty((String)jobName)) {
                    entryMap.put("position", jobName);
                } else {
                    String positionName = positionDyn.getString("name");
                    entryMap.put("position", positionName);
                }
            } else {
                errorStr.append("position is not in platform.");
            }
        } else {
            LOGGER.info("setPositionValueNew aPositionType: not position");
            entryMap.put("position", empPose.getString("position.name"));
        }
    }

    private void setPositionValueOld(StringBuilder errorStr, Map<Long, DynamicObject> postMap, Map<Long, DynamicObject> stdPostMap, DynamicObject empPose, Map<String, Object> entryMap, long adminOrg, long positionLong) {
        boolean std = false;
        if (positionLong == 0L) {
            positionLong = empPose.getLong("stdposition.id");
            std = true;
        }
        if (adminOrg == 0L) {
            errorStr.append("department is empty.");
        }
        if (positionLong == 0L) {
            errorStr.append("position is empty.");
        } else {
            String postName = null;
            long postId = positionLong;
            if (std) {
                DynamicObject dynamicObject = stdPostMap.get(positionLong);
                if (dynamicObject != null) {
                    postName = dynamicObject.getString("name");
                }
                postId = empPose.getLong("darkposition.id");
            } else {
                DynamicObject dynamicObject = postMap.get(positionLong);
                if (dynamicObject != null) {
                    postName = dynamicObject.getString("name");
                }
            }
            entryMap.put("position", postName);
        }
    }

    private Map<String, Object> buildBaseInfo(Map<Long, DynamicObject> personMap, Map<Long, DynamicObject> timePersonMap, Map<Long, DynamicObject> contactAttMap, Map<Long, DynamicObjectCollection> perceMap, DynamicObject personDy, StringBuilder errorStr) {
        DynamicObjectCollection perceMapDys;
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        long personId = personDy.getLong("id");
        DynamicObject personMapDy = personMap.get(personId);
        if (personMapDy != null) {
            String number;
            String name = personMapDy.getString("name");
            if (HRStringUtils.isEmpty((String)name)) {
                errorStr.append("name is empty.");
            }
            if (HRStringUtils.isEmpty((String)(number = personMapDy.getString("number")))) {
                errorStr.append("number is empty.");
            }
            if (HRStringUtils.isNotEmpty((String)errorStr.toString())) {
                return dataMap;
            }
            dataMap.put("name", name);
            dataMap.put("number", number);
            dataMap.put("usertype", 1);
        }
        if ((perceMapDys = perceMap.get(personId)) != null && perceMapDys.size() > 0) {
            DynamicObject perceDy = (DynamicObject)perceMapDys.get(0);
            if (perceDy != null) {
                dataMap.put("idcard", perceDy.getString("number"));
            }
        } else {
            dataMap.put("idcard", null);
        }
        DynamicObject timePersonDy = timePersonMap.get(personId);
        if (timePersonDy != null) {
            dataMap.put("birthday", timePersonDy.get("birthday"));
            dataMap.put("picturefield", timePersonDy.getString("headsculpture"));
            long genderId = timePersonDy.getLong("gender.id");
            String genderStr = "0";
            if (genderId == 1010L) {
                genderStr = "1";
            } else if (genderId == 1020L) {
                genderStr = "2";
            }
            dataMap.put("gender", genderStr);
        } else {
            dataMap.put("picturefield", null);
            dataMap.put("gender", null);
            dataMap.put("birthday", null);
        }
        DynamicObject contactMap = contactAttMap.get(personId);
        if (contactMap != null) {
            String phone = contactMap.getString("phone");
            dataMap.put("phone", phone);
            dataMap.put("email", contactMap.getString("peremail"));
        } else {
            dataMap.put("phone", null);
            dataMap.put("email", null);
        }
        dataMap.put("source", "HR");
        return dataMap;
    }

    private Map<Long, DynamicObject> transferPersonDyToMap(List<Long> personIdList, String entityName, List<Long> adminOrgIds) {
        if ("hrpi_pernontsprop".equals(entityName)) {
            DynamicObject[] timePersons = HRPIPersonRepository.listPernontspropsByProp("nameen,birthday,headsculpture,gender.id,person.id", personIdList);
            return Arrays.stream(timePersons).collect(Collectors.toMap(appDy -> appDy.getLong("person.id"), appDy -> appDy, (v1, v2) -> v1));
        }
        if ("hrpi_percontact".equals(entityName)) {
            DynamicObject[] contactAtts = HRPIPersonRepository.getPersonAttachs("phone,peremail,workphone,person.id", personIdList, "hrpi_percontact", null);
            return Arrays.stream(contactAtts).collect(Collectors.toMap(appDy -> appDy.getLong("person.id"), appDy -> appDy, (v1, v2) -> v1));
        }
        if ("hrpi_personrolerel".equals(entityName)) {
            DynamicObject[] rolesByPersonId = HRPIPersonRolerelRepository.getPersonRoleByPersonIds("mainpeoincharge,person.id", personIdList, adminOrgIds);
            return Arrays.stream(rolesByPersonId).collect(Collectors.toMap(appDy -> appDy.getLong("person.id"), appDy -> appDy, (v1, v2) -> v1));
        }
        return new HashMap<Long, DynamicObject>(16);
    }

    private Map<Long, DynamicObjectCollection> transferPersonDyToListMap(List<Long> persons, String entityName) {
        String selectProperties = null;
        QFilter otherFilter = null;
        if ("hrpi_percre".equals(entityName)) {
            otherFilter = new QFilter("credentialstype", "=", (Object)1010);
            selectProperties = "number,person.id";
        } else if ("hrpi_peraddress".equals(entityName)) {
            selectProperties = "addressinfo,countrycode.id,person.id,createtime";
            otherFilter = new QFilter("addresstype", "=", (Object)1010L);
        }
        if (HRStringUtils.isEmpty((String)selectProperties)) {
            return new HashMap<Long, DynamicObjectCollection>(16);
        }
        DynamicObject[] perAttachs = HRPIPersonRepository.getPersonAttachs(selectProperties, persons, entityName, otherFilter);
        return this.assessAbleMultMap(perAttachs, entityName);
    }

    private Map<Long, DynamicObjectCollection> assessAbleMultMap(DynamicObject[] dynamicObjects, String entityName) {
        HashMap<Long, DynamicObjectCollection> retMap = new HashMap<Long, DynamicObjectCollection>(16);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return retMap;
        }
        if ("hrpi_peraddress".equals(entityName)) {
            List sortCollection = Arrays.stream(dynamicObjects).sorted(Comparator.comparing(dy -> dy.getDate("createtime"))).collect(Collectors.toList());
            for (int i = sortCollection.size() - 1; i >= 0; --i) {
                this.buildData(retMap, (DynamicObject)sortCollection.get(i));
            }
            return retMap;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            this.buildData(retMap, dynamicObject);
        }
        return retMap;
    }

    private void buildData(Map<Long, DynamicObjectCollection> retMap, DynamicObject dynamicObject) {
        long personIds = dynamicObject.getLong("person.id");
        DynamicObjectCollection oldList = retMap.get(personIds);
        if (oldList == null || oldList.size() == 0) {
            oldList = new DynamicObjectCollection();
        }
        oldList.add((Object)dynamicObject);
        retMap.put(personIds, oldList);
    }

    @Override
    @Deprecated
    public Map<String, List<Map<String, Object>>> groupParamListMap(List<Map<String, Object>> userList, SyncPersonToUserServiceImpl syncService, Map<String, String> checkErrMap) {
        return this.groupParamListMap(userList, checkErrMap);
    }

    @Override
    public Map<String, List<Map<String, Object>>> groupParamListMap(List<Map<String, Object>> userList, Map<String, String> checkErrMap) {
        ArrayList<Map<String, Object>> errorList = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Object> checkErrObjMap = new HashMap<String, Object>(16);
        LinkedHashMap<String, List<Map<String, Object>>> groupMap = new LinkedHashMap<String, List<Map<String, Object>>>(16);
        for (Map<String, Object> tempMap : userList) {
            StringBuilder errorStr = new StringBuilder();
            String number = (String)tempMap.get("number");
            String name = (String)tempMap.get("name");
            String syncType = (String)tempMap.get("synctype");
            if (HRStringUtils.isNotEmpty((String)syncType)) {
                syncType = syncType.toLowerCase(Locale.ENGLISH);
            }
            long personId = 0L;
            if (tempMap.containsKey("personid")) {
                Object personObj = tempMap.get("personid");
                if (personObj instanceof Long) {
                    personId = (Long)personObj;
                } else if (personObj != null) {
                    errorStr.append("personid type error");
                    continue;
                }
            }
            if (HRStringUtils.isEmpty((String)syncType)) {
                errorStr.append("synctype is empty");
            }
            if (personId == 0L && (HRStringUtils.isEmpty((String)number) || HRStringUtils.isEmpty((String)syncType) || HRStringUtils.isEmpty((String)name))) {
                errorStr.append(String.format(Locale.ROOT, "param is empty, %s,%s,%s", number, syncType, name));
            }
            if (personId != 0L && HRStringUtils.isEmpty((String)syncType)) {
                errorStr.append(String.format(Locale.ROOT, "inparam is empty, %s,%s,%s,%s", personId, number, syncType, name));
            }
            if (HRStringUtils.isNotEmpty((String)errorStr.toString())) {
                checkErrMap.put(number, errorStr.toString());
                checkErrObjMap.put(number, errorStr.toString());
                errorList.add(tempMap);
                continue;
            }
            ArrayList<Map<String, Object>> list = (ArrayList<Map<String, Object>>)groupMap.get(syncType);
            if (list == null || list.size() == 0) {
                list = new ArrayList<Map<String, Object>>();
            }
            list.add(tempMap);
            groupMap.put(syncType, list);
        }
        if (!CollectionUtils.isEmpty(errorList)) {
            LOGGER.warn("validateDateError--->{}", checkErrMap);
            this.recordLog(errorList, checkErrObjMap, null, "1", "0", "1");
        }
        return groupMap;
    }

    @Override
    public Map<String, Object> syncHRPersonToSysUser(List<Map<String, Object>> params) {
        LOGGER.info("syncHRPersonToSysUser begin:{}", params);
        Map resultMap = ResultUtils.buildSuccess(null);
        HashMap<String, String> errorMap = new HashMap<String, String>();
        Map<Long, Map<String, Object>> empParamMap = this.convert2EmployeeMap(params);
        if (empParamMap.size() == 0) {
            String errorInfo = "The request parameter is illegal, and valid employee data cannot be found";
            LOGGER.error("syncHRPersonToSysUser error {}", (Object)errorInfo);
            return ResultUtils.buildFail((String)errorInfo);
        }
        Map<Long, DynamicObject> userRelateMap = this.findUserRelate(empParamMap.keySet());
        HashSet<Long> toUpdateEmployeeIds = new HashSet<Long>();
        HashSet<Long> toAddEmployeeIds = new HashSet<Long>();
        HashMap<String, Long> personNumberUserMap = new HashMap<String, Long>(16);
        this.groupByEmployee(empParamMap, userRelateMap, personNumberUserMap, toUpdateEmployeeIds, toAddEmployeeIds);
        this.syncToUpdateUserInfo(empParamMap, userRelateMap, personNumberUserMap, toUpdateEmployeeIds, errorMap);
        this.syncNewUserInfo(empParamMap, userRelateMap, toAddEmployeeIds, errorMap);
        if (errorMap.size() > 0) {
            resultMap = ResultUtils.buildResult((boolean)Boolean.FALSE, (String)"has not success data", errorMap);
        }
        this.recordSyncLog(empParamMap, resultMap);
        return resultMap;
    }

    private Map<Long, Map<String, Object>> convert2EmployeeMap(List<Map<String, Object>> params) {
        HashMap<Long, Map<String, Object>> employeeMap = new HashMap<Long, Map<String, Object>>();
        if (CollectionUtils.isEmpty(params)) {
            LOGGER.error("syncHRPersonToSysUser error, params is empty");
            return employeeMap;
        }
        SyncPersonToUserServiceHelper.populateEmployeeMap(params, "employeeId", "id", SyncPersonToUserServiceHelper.filterEmpParams(), SyncPersonToUserServiceHelper.queryEmpArrByEmployeeIdStrs(), employeeMap);
        SyncPersonToUserServiceHelper.populateEmployeeMap(params, "personId", "person.id", SyncPersonToUserServiceHelper.filterPersonIdParams(), SyncPersonToUserServiceHelper.queryEmpArrByPersonIdStrs(), employeeMap);
        SyncPersonToUserServiceHelper.populateEmployeeMap(params, "number", "empnumber", SyncPersonToUserServiceHelper.filterNumberParams(), SyncPersonToUserServiceHelper.queryEmpArrByNumbers(), employeeMap);
        employeeMap.values().stream().map(map -> ((DynamicObject)map.get("empDy")).getLong("person.id")).collect(Collectors.toList());
        return employeeMap;
    }

    private Map<Long, DynamicObject> findUserRelate(Collection employeeIds) {
        HashMap<Long, DynamicObject> empUserRelateMap = new HashMap<Long, DynamicObject>();
        QFilter empQFilter = new QFilter("employee", "in", (Object)employeeIds);
        Object[] userRelateArr = HRPIBosUserRepository.getUserRelateByPersonInfo(empQFilter);
        if (HRArrayUtils.isNotEmpty((Object[])userRelateArr)) {
            Arrays.stream(userRelateArr).forEach(userRelate -> empUserRelateMap.put(userRelate.getLong("employee"), (DynamicObject)userRelate));
        }
        return empUserRelateMap;
    }

    private void groupByEmployee(Map<Long, Map<String, Object>> empParamMap, Map<Long, DynamicObject> userRelateMap, Map<String, Long> personNumberUserMap, Set<Long> toUpdateEmployeeIds, Set<Long> toAddEmployeeIds) {
        toUpdateEmployeeIds.addAll(userRelateMap.keySet());
        toAddEmployeeIds.addAll(empParamMap.keySet());
        toAddEmployeeIds.removeAll(toUpdateEmployeeIds);
        this.associationHrUserAndBosUser(empParamMap, personNumberUserMap, toUpdateEmployeeIds, toAddEmployeeIds);
        this.filterUseOldBosUserEmp(empParamMap, userRelateMap, personNumberUserMap, toUpdateEmployeeIds, toAddEmployeeIds);
    }

    private void filterUseOldBosUserEmp(Map<Long, Map<String, Object>> empParamMap, Map<Long, DynamicObject> userRelateMap, Map<String, Long> personNumberUserMap, Set<Long> toUpdateEmployeeIds, Set<Long> toAddEmployeeIds) {
        HRBaseServiceHelper actionHelper;
        Object[] actionDys;
        HashMap<Long, Boolean> createNewUserMap = new HashMap<Long, Boolean>();
        boolean useOldPersonStrategy = PersonModelConfigUtil.useOldBosUserConfigOn();
        createNewUserMap.put(0L, !useOldPersonStrategy);
        HashSet actionIds = new HashSet();
        toAddEmployeeIds.forEach(employeeId -> {
            Map paramMap = (Map)empParamMap.get(employeeId);
            actionIds.add(this.getParamMapActionId(paramMap, 0L));
        });
        if (!CollectionUtils.isEmpty(actionIds) && HRArrayUtils.isNotEmpty((Object[])(actionDys = (actionHelper = new HRBaseServiceHelper("hpfs_chgaction")).loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", actionIds)})))) {
            Arrays.asList(actionDys).stream().filter(action -> Objects.nonNull("createnewbosuser")).forEach(action -> createNewUserMap.put(action.getLong("id"), action.getBoolean("createnewbosuser")));
        }
        HashMap<Long, Long> midEmpIdMap = new HashMap<Long, Long>();
        toAddEmployeeIds.stream().forEach(employeeId -> {
            DynamicObject empDy;
            Map paramMap = (Map)empParamMap.get(employeeId);
            Boolean createNewBosUser = (Boolean)createNewUserMap.get(this.getParamMapActionId(paramMap, 0L));
            if (!createNewBosUser.booleanValue() && (empDy = (DynamicObject)((Map)empParamMap.get(employeeId)).get("empDy")).getLong("id") != empDy.getLong("mid")) {
                midEmpIdMap.put(empDy.getLong("mid"), empDy.getLong("id"));
            }
        });
        Map<Long, Long> midLastEmpIdMap = SyncPersonToUserServiceHelper.getLasterEmployeeIdByMid(midEmpIdMap);
        List lasterEmpIds = midLastEmpIdMap.values().stream().collect(Collectors.toList());
        QFilter empQFilter = new QFilter("employee", "in", lasterEmpIds);
        DynamicObject[] userRelateByPersonInfo = HRPIBosUserRepository.getUserRelateByPersonInfo(empQFilter);
        Arrays.asList(userRelateByPersonInfo).stream().forEach(relate -> {
            long mid = relate.getLong("mid");
            Long employeeId = (Long)midEmpIdMap.get(mid);
            DynamicObject empDy = (DynamicObject)((Map)empParamMap.get(employeeId)).get("empDy");
            personNumberUserMap.put(empDy.getString("empnumber"), relate.getLong("user"));
            toAddEmployeeIds.remove(employeeId);
            toUpdateEmployeeIds.add(employeeId);
        });
    }

    private Long getParamMapActionId(Map<String, Object> paramMap, Long defaultValue) {
        try {
            LOGGER.info("SyncPersonToUserServiceImpl#getParamMapActionId requestParam is {}", paramMap.get("param"));
            Map requestParam = (Map)paramMap.get("param");
            Object actionId = requestParam.get("actionId");
            return Long.parseLong(actionId.toString());
        }
        catch (Exception ex) {
            LOGGER.error("SyncPersonToUserServiceImpl#getParamMapActionId error", (Throwable)ex);
            return defaultValue;
        }
    }

    private void associationHrUserAndBosUser(Map<Long, Map<String, Object>> empParamMap, Map<String, Long> personNumberUserMap, Set<Long> toUpdateEmployeeIds, Set<Long> toAddEmployeeIds) {
        if (CollectionUtils.isEmpty(toAddEmployeeIds)) {
            LOGGER.info("SyncPersonToUserServiceImpl#associationHrUserAndBosUser toAddEmployeeIds is empty");
            return;
        }
        List<DynamicObject> empDys = toAddEmployeeIds.stream().map(toAddEmployeeId -> (DynamicObject)((Map)empParamMap.get(toAddEmployeeId)).get("empDy")).collect(Collectors.toList());
        List<String> numberList = empDys.stream().map(dy -> dy.getString("empnumber")).collect(Collectors.toList());
        List nameList = empDys.stream().map(dy -> dy.getString("person.name")).collect(Collectors.toList());
        QFilter nameQFilter = new QFilter("name", "in", nameList);
        DynamicObject[] exitBosUser = HRPIBosUserRepository.getBosUser("id,enable,number,name", numberList, nameQFilter);
        List<Long> exitBosUserId = Arrays.asList(exitBosUser).stream().map(user -> user.getLong("id")).collect(Collectors.toList());
        DynamicObject[] hrAndBosUserRelate = SyncPersonToUserServiceHelper.getHRAndBosUserRelateByBosUserIds(exitBosUserId);
        List exitRelateBosUserIds = Arrays.asList(hrAndBosUserRelate).stream().map(relate -> relate.getLong("user")).collect(Collectors.toList());
        for (DynamicObject bosUser : exitBosUser) {
            long userId = bosUser.getLong("id");
            if (exitRelateBosUserIds.contains(userId)) continue;
            personNumberUserMap.put(bosUser.getString("number"), bosUser.getLong("id"));
        }
        Set<String> updateNumbers = personNumberUserMap.keySet();
        if (!CollectionUtils.isEmpty(updateNumbers)) {
            empDys.forEach(emp -> {
                String empNumber = emp.getString("empnumber");
                if (updateNumbers.contains(empNumber)) {
                    long empId = emp.getLong("id");
                    toUpdateEmployeeIds.add(empId);
                    toAddEmployeeIds.remove(empId);
                }
            });
        }
    }

    private void syncToUpdateUserInfo(Map<Long, Map<String, Object>> empParamMap, Map<Long, DynamicObject> userRelateMap, Map<String, Long> personNumberUserMap, Set<Long> toUpdateEmployeeIds, Map<String, String> errorMap) {
        ArrayList<DynamicObject> toUpdateEmployeeDy = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> toDisableUserStatusEmployeeDy = new ArrayList<DynamicObject>();
        empParamMap.forEach((employeeId, param) -> {
            if (toUpdateEmployeeIds.contains(employeeId)) {
                DynamicObject empDy = (DynamicObject)param.get("empDy");
                DynamicObject relate = (DynamicObject)userRelateMap.get(employeeId);
                param.put("syncType", "update");
                DynamicObject laborelStatusDy = empDy.getDynamicObject("laborrelstatus");
                String enable = "1";
                if (laborelStatusDy.getLong("labrelstatusprd.id") == 1010L) {
                    toUpdateEmployeeDy.add(empDy);
                } else {
                    toDisableUserStatusEmployeeDy.add(empDy);
                    enable = "0";
                }
                if (null != relate) {
                    relate.set("enable", (Object)enable);
                }
            }
        });
        SyncPersonToUserServiceHelper.disableUserStatus(userRelateMap, personNumberUserMap, toDisableUserStatusEmployeeDy, errorMap);
        SyncPersonToUserServiceHelper.enableUser(userRelateMap, personNumberUserMap, toUpdateEmployeeDy, errorMap);
        this.syncSyncUserByEmployee(userRelateMap, toUpdateEmployeeDy, personNumberUserMap, "update", errorMap);
    }

    private void syncUserRelateEnable(List<DynamicObject> toUpdateEmployeeDy, List<DynamicObject> toDisableUserStatusEmployeeDy) {
        ArrayList employeeIds = new ArrayList();
        List updateEmployeeId = toUpdateEmployeeDy.stream().map(employee -> employee.getLong("id")).collect(Collectors.toList());
        List disableEmployeeId = toDisableUserStatusEmployeeDy.stream().map(employee -> employee.getLong("id")).collect(Collectors.toList());
        employeeIds.addAll(updateEmployeeId);
        employeeIds.addAll(disableEmployeeId);
        QFilter qFilter = new QFilter("employee", "in", employeeIds);
        DynamicObject[] userRelateByPersonInfo = HRPIBosUserRepository.getUserRelateByPersonInfo(qFilter);
        DynamicObjectCollection updateCollection = new DynamicObjectCollection();
        for (DynamicObject relate : userRelateByPersonInfo) {
            long employeeId = relate.getLong("employee");
            if (updateEmployeeId.contains(employeeId) && HRStringUtils.equals((String)"0", (String)relate.getString("enable"))) {
                relate.set("enable", (Object)"1");
                updateCollection.add((Object)relate);
                continue;
            }
            if (!disableEmployeeId.contains(employeeId) || !HRStringUtils.equals((String)"1", (String)relate.getString("enable"))) continue;
            relate.set("enable", (Object)"0");
            updateCollection.add((Object)relate);
        }
        if (updateCollection.size() > 0) {
            HRPIBosUserRepository.saveUser(updateCollection);
        }
    }

    private void syncSyncUserByEmployee(Map<Long, DynamicObject> userRelateMap, List<DynamicObject> toSyncEmployeeDy, Map<String, Long> personNumberUserMap, String syncType, Map<String, String> errorMap) {
        if (CollectionUtils.isEmpty(toSyncEmployeeDy)) {
            LOGGER.info("SyncPersonToUserServiceImpl#syncSyncUserByEmployee toSyncEmployeeDy is empty");
            return;
        }
        ArrayList<UserParam> userParams = new ArrayList<UserParam>(10);
        List<Long> employeeIds = toSyncEmployeeDy.stream().map(map -> map.getLong("id")).collect(Collectors.toList());
        List personIds = toSyncEmployeeDy.stream().map(map -> map.getLong("person.id")).collect(Collectors.toList());
        ArrayList beforeSavePersonUserRelList = new ArrayList();
        List<Object> personsByNumberList = Arrays.asList((Object[])HRPIPersonRepository.getAllPerson(new QFilter("id", "in", personIds)).clone());
        HashMap<Long, Long> personUserIdMap = new HashMap<Long, Long>(16);
        userRelateMap.forEach((employeeId, relate) -> {
            if (employeeIds.contains(employeeId)) {
                personUserIdMap.put(relate.getLong("person"), relate.getLong("user"));
                beforeSavePersonUserRelList.add(relate);
            }
        });
        Map<Long, Map<String, Long>> personModelIds = this.buildUserInfo(userParams, errorMap, personsByNumberList, syncType, personNumberUserMap, personUserIdMap, employeeIds);
        Map<Long, Long> successPersonAndBosIdRel = this.saveUserInfo(userParams, errorMap, personsByNumberList);
        this.savePersonUserRelInfo(personModelIds, successPersonAndBosIdRel, beforeSavePersonUserRelList.toArray(new DynamicObject[beforeSavePersonUserRelList.size()]));
    }

    private void syncNewUserInfo(Map<Long, Map<String, Object>> empParamMap, Map<Long, DynamicObject> userRelateMap, Set<Long> toAddEmployeeIds, Map<String, String> errorMap) {
        if (CollectionUtils.isEmpty(toAddEmployeeIds)) {
            LOGGER.info("SyncPersonToUserServiceImpl#syncNewUserInfo toAddEmployeeIds is empty");
            return;
        }
        ArrayList<DynamicObject> toAddEmployeeDy = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> toDisableUserStatusEmployeeDy = new ArrayList<DynamicObject>();
        empParamMap.forEach((employeeId, param) -> {
            if (toAddEmployeeIds.contains(employeeId)) {
                DynamicObject empDy = (DynamicObject)param.get("empDy");
                param.put("syncType", "add");
                toAddEmployeeDy.add(empDy);
                DynamicObject laborelStatusDy = empDy.getDynamicObject("laborrelstatus");
                if (laborelStatusDy.getLong("labrelstatusprd.id") == 1020L) {
                    toDisableUserStatusEmployeeDy.add(empDy);
                }
            }
        });
        this.disableConflictBosUser(toAddEmployeeDy, errorMap);
        this.syncSyncUserByEmployee(userRelateMap, toAddEmployeeDy, new HashMap<String, Long>(), "add", errorMap);
        SyncPersonToUserServiceHelper.disableUserStatus(userRelateMap, new HashMap<String, Long>(), toDisableUserStatusEmployeeDy, errorMap);
    }

    public void recordSyncLog(Map<Long, Map<String, Object>> empParamMap, Map<String, Object> resultMap) {
        HRBaseServiceHelper syncLogHelper = HRPIBosUserRepository.getSyncLogHelper();
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        String status = (Boolean)resultMap.get("success") != false ? "1" : "0";
        empParamMap.forEach((empId, map) -> {
            String number = (String)map.get("number");
            String name = (String)map.get("name");
            DynamicObject dynamicObject = syncLogHelper.generateEmptyDynamicObject();
            dynamicObject.set("number", (Object)number);
            dynamicObject.set("synctype", map.get("syncType"));
            dynamicObject.set("name", (Object)name);
            dynamicObject.set("param", map.get("param"));
            dynamicObject.set("status", (Object)status);
            this.buildErrorMessage(resultMap, number, dynamicObject);
            long accountId = RequestContext.get().getCurrUserId();
            long admin = 1L;
            if (accountId != 0L) {
                admin = accountId;
            }
            dynamicObject.set("creator", (Object)admin);
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObjects.add((Object)dynamicObject);
        });
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            HRPIBosUserRepository.saveSyncLog(dynamicObjects);
        }
    }

    private void disableConflictBosUser(List<DynamicObject> employeeList, Map<String, String> errorMap) {
        List<Long> personIdList = employeeList.stream().map(emp -> emp.getLong("person.id")).collect(Collectors.toList());
        List<Long> midList = employeeList.stream().map(emp -> emp.getLong("mid")).collect(Collectors.toList());
        Object[] oldRelateData = SyncPersonToUserServiceHelper.getHRAndBosUserRelateByPersonIdOrMid(personIdList, midList);
        ArrayList<Long> bosUserId = new ArrayList<Long>();
        if (HRArrayUtils.isNotEmpty((Object[])oldRelateData)) {
            bosUserId.addAll(Arrays.asList(oldRelateData).stream().map(relate -> relate.getLong("user")).collect(Collectors.toList()));
        }
        List<String> numberList = employeeList.stream().map(emp -> emp.getString("empnumber")).collect(Collectors.toList());
        Object[] conflictBosUser = this.getConflictBosUserByNumberOrBosUserId(numberList, bosUserId);
        ArrayList cannotSyncNumber = new ArrayList();
        if (HRArrayUtils.isEmpty((Object[])conflictBosUser)) {
            LOGGER.info("SyncPersonToUserService#disableConflictBosUser getConflictBosUserByNumber result is empty");
            return;
        }
        List<Long> bosUserIds = Arrays.asList(conflictBosUser).stream().map(bosUser -> bosUser.getLong("id")).collect(Collectors.toList());
        DynamicObject[] conflictBosUserRelate = SyncPersonToUserServiceHelper.getHRAndBosUserRelateByBosUserIds(bosUserIds);
        List exitHRBosUser = Arrays.asList(conflictBosUserRelate).stream().map(dy -> dy.getLong("user")).collect(Collectors.toList());
        DynamicObject[] needToDisableUser = (DynamicObject[])Arrays.asList(conflictBosUser).stream().filter(user -> exitHRBosUser.contains(user.getLong("id"))).toArray(DynamicObject[]::new);
        SyncPersonToUserServiceHelper.disableUserByBosUserInfo(needToDisableUser, errorMap);
        if (conflictBosUser.length < bosUserIds.size()) {
            cannotSyncNumber.addAll(Arrays.asList(conflictBosUser).stream().filter(user -> !exitHRBosUser.contains(user.get("id"))).map(user -> user.getString("number")).collect(Collectors.toList()));
            employeeList.removeIf(emp -> cannotSyncNumber.contains(emp.getString("empnumber")));
        }
    }

    private DynamicObject[] getConflictBosUserByNumberOrBosUserId(List<String> numberList, List<Long> bosUserId) {
        QFilter numberQFilter = new QFilter("number", "in", numberList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        if (!CollectionUtils.isEmpty(bosUserId)) {
            QFilter bosUserIdQFilter = new QFilter("id", "in", bosUserId);
            numberQFilter.or(bosUserIdQFilter);
        }
        return HRPIBosUserRepository.getBosUserAllInfoByCustomerFilter(numberQFilter.and(enableFilter));
    }

    private String subStringErrorInfo(Exception exception) {
        int length = 1800;
        String stackTrace = ExceptionUtils.getStackTrace((Throwable)exception);
        return this.doSubString(length, stackTrace);
    }

    private String doSubString(int length, String stackTrace) {
        if (stackTrace.length() > length) {
            return stackTrace.substring(0, length);
        }
        return stackTrace;
    }
}

