/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRolerelRepository;
import kd.hrmp.hrpi.business.domian.service.IWorkFlowService;
import kd.hrmp.hrpi.business.domian.service.impl.PersonRoleServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.PersonServiceImpl;
import kd.hrmp.hrpi.business.domian.service.superior.PersonSuperiorFetchHelper;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.common.enums.RelationType;

public class WorkFlowServiceImpl
implements IWorkFlowService {
    private static final Log LOGGER = LogFactory.getLog(WorkFlowServiceImpl.class);
    private static volatile IWorkFlowService WORKFLOWSERVICE;
    private static final String DEPEMPPARM = "depemp";
    private static final String DEPEMPQUERYPARM = "depempquery";
    private static final String PERSONQUERYPARM = "personquery";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IWorkFlowService getInstance() {
        try {
            if (null != WORKFLOWSERVICE) return WORKFLOWSERVICE;
            Class<WorkFlowServiceImpl> clazz = WorkFlowServiceImpl.class;
            synchronized (WorkFlowServiceImpl.class) {
                if (null != WORKFLOWSERVICE) return WORKFLOWSERVICE;
                try {
                    WORKFLOWSERVICE = new WorkFlowServiceImpl();
                    LOGGER.info("HRPIServiceFactory-dependency-check,new-WorkFlowServiceImpl()-success");
                }
                catch (Throwable t) {
                    LOGGER.error("HRPIServiceFactory-dependency-check,new-WorkFlowServiceImpl()-fail", t);
                }
                return WORKFLOWSERVICE;
            }
        }
        catch (Throwable t) {
            LOGGER.error("HRPIServiceFactory-dependency-check,IWorkFlowService-getInstance()-fail", t);
        }
        return WORKFLOWSERVICE;
    }

    @Override
    public List<Long> getEmpsuprel(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params, RelationType personRelation) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        if (referencePersons != null && !referencePersons.isEmpty() && null != params && !params.isEmpty()) {
            LOGGER.info(" workflow param {} {}", (Object)businessKey, params);
            switch (personRelation) {
                case LEADER: {
                    List<Long> paramIds = this.getParamId(params, personRelation.getType());
                    List<Map<String, Object>> mainChargeByOrg = PersonRoleServiceImpl.getInstance().getMainChargeByOrg(paramIds);
                    mainChargeByOrg.forEach(chargeInfo -> userIds.add((Long)chargeInfo.get("person")));
                    break;
                }
                case SUPERIOR_LEADER: {
                    List<Long> paramIds = this.getParamId(params, personRelation.getType());
                    List<Map<String, Object>> parentAdminOrgCharegeInfo = PersonRoleServiceImpl.getInstance().getSuperiorByOrg(paramIds);
                    parentAdminOrgCharegeInfo.forEach(chargeInfo -> userIds.add((Long)chargeInfo.get("person")));
                    break;
                }
                case SUPERIOR: {
                    Date date = this.getDate(params);
                    this.getNewSuperior(params, userIds, date, false);
                    break;
                }
                case INDIRECT_SUPERIOR: {
                    this.getNewSuperior(params, userIds, new Date(), true);
                    break;
                }
            }
        }
        return userIds.isEmpty() ? userIds : this.transPersonIdToUserId(userIds);
    }

    private Date getDate(Map<String, Object> params) {
        Date currentDate = DateUtil.getCurrentDate();
        Object param = params.get("date");
        if (param instanceof Date) {
            currentDate = (Date)param;
        } else if (param instanceof String) {
            try {
                currentDate = HRDateTimeUtils.parseDate((String)((String)param));
            }
            catch (Exception es) {
                try {
                    currentDate = HRDateTimeUtils.parseDate((String)((String)param), (String)"yyyy-MM-dd");
                }
                catch (Exception ex) {
                    LOGGER.error("parseError1", (Throwable)es);
                }
                LOGGER.error("parseError", (Throwable)es);
            }
        }
        return currentDate;
    }

    private void getNewSuperior(Map<String, Object> params, List<Long> userIds, Date date, boolean findParent) {
        Set<Long> depSets = this.getIds(params, DEPEMPPARM, DEPEMPQUERYPARM);
        Set<Long> personSets = this.getIds(params, PERSONQUERYPARM, "person");
        this.findSuperior(new ArrayList<Long>(depSets), true, userIds, date, findParent);
        this.findSuperior(new ArrayList<Long>(personSets), false, userIds, date, findParent);
    }

    private void findSuperior(List<Long> paramIds, boolean queryByDepemp, List<Long> userIds, Date date, boolean findParent) {
        if (paramIds != null && !paramIds.isEmpty()) {
            String queryKey = queryByDepemp ? DEPEMPPARM : "person";
            HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
            paramMap.put(queryKey, paramIds);
            Map<Long, List<Map<String, Object>>> directSuperiorMap = PersonSuperiorFetchHelper.getSuperior(paramMap, date);
            if (!findParent) {
                for (List<Map<String, Object>> value : directSuperiorMap.values()) {
                    value.forEach(superior -> userIds.add((Long)superior.get("person.id")));
                }
                return;
            }
            if (!HRMapUtils.isEmpty(directSuperiorMap)) {
                List directDys = directSuperiorMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                List queryKeyIds = directDys.stream().map(dy -> (Long)dy.get(queryKey + ".id")).collect(Collectors.toList());
                HashMap<String, Object> dirParamMap = new HashMap<String, Object>(4);
                dirParamMap.put(queryKey, queryKeyIds);
                Map<Long, List<Map<String, Object>>> indirectSuperiorMap = PersonSuperiorFetchHelper.getSuperior(dirParamMap, date);
                for (List<Map<String, Object>> value : indirectSuperiorMap.values()) {
                    value.forEach(superior -> userIds.add((Long)superior.get("person.id")));
                }
            }
        }
    }

    private void getDirectSuperior(Map<String, Object> params, List<Long> userIds) {
        Set<Long> depSets = this.getIds(params, DEPEMPPARM, DEPEMPQUERYPARM);
        Set<Long> personSets = this.getIds(params, PERSONQUERYPARM, "person");
        this.getDirectSuperior(new ArrayList<Long>(depSets), true, userIds);
        this.getDirectSuperior(new ArrayList<Long>(personSets), false, userIds);
    }

    private void getDirectSuperior(Map<String, Object> params, List<Long> userIds, Date date) {
        Set<Long> depSets = this.getIds(params, DEPEMPPARM, DEPEMPQUERYPARM);
        Set<Long> personSets = this.getIds(params, PERSONQUERYPARM, "person");
        this.getDirectSuperior(new ArrayList<Long>(depSets), true, userIds, date);
        this.getDirectSuperior(new ArrayList<Long>(personSets), false, userIds, date);
    }

    private void getIndirectSuperior(Map<String, Object> params, List<Long> userIds) {
        Set<Long> depSets = this.getIds(params, DEPEMPPARM, DEPEMPQUERYPARM);
        Set<Long> personSets = this.getIds(params, PERSONQUERYPARM, "person");
        this.getIndirectSuperior(new ArrayList<Long>(depSets), true, userIds);
        this.getIndirectSuperior(new ArrayList<Long>(personSets), false, userIds);
    }

    private Set<Long> getIds(Map<String, Object> params, String ... keys) {
        HashSet<Long> result = new HashSet<Long>();
        for (String key : keys) {
            result.addAll(this.getParamId(params, key));
        }
        return result;
    }

    private void getIndirectSuperior(List<Long> paramIds, boolean queryByDepemp, List<Long> userIds) {
        String queryKey;
        DynamicObjectCollection roleIds;
        if (paramIds != null && !paramIds.isEmpty() && !(roleIds = HRPIPersonRolerelRepository.getRolesByPersonId(queryKey = queryByDepemp ? "depemp.id" : "person.id", paramIds)).isEmpty()) {
            HashSet<Long> roleSet = new HashSet<Long>(roleIds.size());
            roleIds.forEach(role -> roleSet.add(role.getLong("role.id")));
            List<DynamicObject> roleList = HRPIPersonRolerelRepository.getAllParentRelations(roleSet);
            LOGGER.info(" getIndirectSuperior info {}", roleList);
            if (roleList.size() > 0) {
                HashSet parentRoleId = new HashSet(roleList.size());
                roleList.stream().filter(role -> roleSet.contains(role.getLong("role.id"))).forEach(parRole -> parentRoleId.add(parRole.getLong("parent.id")));
                if (!parentRoleId.isEmpty()) {
                    List<Map<String, Object>> superiorByRole = PersonRoleServiceImpl.getInstance().getSuperiorByRole(new ArrayList<Long>(parentRoleId));
                    for (Map<String, Object> value : superiorByRole) {
                        userIds.add((Long)value.get("person.id"));
                    }
                }
            }
        }
    }

    private void getDirectSuperior(List<Long> paramIds, boolean queryByDepemp, List<Long> userIds) {
        if (paramIds != null && !paramIds.isEmpty()) {
            Map<Long, List<Map<String, Object>>> directSuperior = queryByDepemp ? PersonRoleServiceImpl.getInstance().getDirectSuperiorByDepempId(paramIds) : PersonRoleServiceImpl.getInstance().getDirectSuperior(paramIds);
            for (List<Map<String, Object>> value : directSuperior.values()) {
                value.forEach(superior -> userIds.add((Long)superior.get("person.id")));
            }
        }
    }

    private void getDirectSuperior(List<Long> paramIds, boolean queryByDepemp, List<Long> userIds, Date date) {
        if (paramIds != null && !paramIds.isEmpty()) {
            Map<Long, List<Map<String, Object>>> directSuperior = queryByDepemp ? PersonRoleServiceImpl.getInstance().getDirectSuperiorByDepempId(paramIds, date) : PersonRoleServiceImpl.getInstance().getDirectSuperior(paramIds, date);
            for (List<Map<String, Object>> value : directSuperior.values()) {
                value.forEach(superior -> userIds.add((Long)superior.get("person.id")));
            }
        }
    }

    private List<Long> getParamId(Map<String, Object> params, String paramKey) {
        ArrayList<Long> result = new ArrayList<Long>();
        Object param = params.get(paramKey);
        try {
            if (param instanceof DynamicObject) {
                DynamicObject paramDy = (DynamicObject)params.get(paramKey);
                if (paramDy == null) {
                    return result;
                }
                Long paramId = paramDy.getLong("id");
                result.add(paramId);
            } else if (param instanceof MulBasedataDynamicObjectCollection) {
                DynamicObjectCollection paramDys = (DynamicObjectCollection)params.get(paramKey);
                if (paramDys == null || paramDys.size() == 0) {
                    return result;
                }
                paramDys.forEach(pm -> result.add(pm.getLong("fbasedataid.id")));
            } else if (param instanceof List) {
                List paramDys = (List)params.get(paramKey);
                if (paramDys == null || paramDys.isEmpty()) {
                    return result;
                }
                result.addAll(paramDys);
            }
        }
        catch (Exception ex) {
            LOGGER.error(" params get error ", (Throwable)ex);
        }
        return result;
    }

    private List<Long> transPersonIdToUserId(List<Long> personIds) {
        LOGGER.info(" workflow transPersonIdToUserId {}", personIds);
        ArrayList<Long> userIds = new ArrayList<Long>(personIds.size());
        HashMap<String, List<Long>> queryMap = new HashMap<String, List<Long>>();
        queryMap.put("person", personIds);
        Map<String, Object> userInfoMap = PersonServiceImpl.getInstance().getUserIdByPersonInfo(queryMap);
        if (!userInfoMap.isEmpty() && userInfoMap.get("success") == Boolean.TRUE) {
            Map data = (Map)userInfoMap.get("data");
            data.values().forEach(user -> {
                Map userMap = (Map)user;
                if (userMap != null && !userMap.isEmpty()) {
                    userIds.add((Long)userMap.get("user"));
                }
            });
        }
        return userIds;
    }
}

