/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.LogPrivacyUtil;
import kd.hrmp.hrpi.business.domian.service.generic.IPersonGenericService;
import kd.hrmp.hrpi.business.domian.service.generic.execute.IPersonGenericExecuteService;
import kd.hrmp.hrpi.business.domian.service.impl.generic.factory.PersonGenericFactory;
import kd.hrmp.hrpi.common.IHRPIActionConstants;
import kd.hrmp.hrpi.common.generic.entity.IPersonGenericEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericDeleteEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericDiscardEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.generic.enums.PersonGenericOperateTypeEnums;
import kd.hrmp.hrpi.common.generic.result.PersonGenericResult;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.time.StopWatch;

public class PersonGenericServiceImpl
implements IPersonGenericService {
    private static final Log LOGGER = LogFactory.getLog(PersonGenericServiceImpl.class);
    private static volatile IPersonGenericService PERSONGENERICSERVICE;
    private static HRBaseServiceHelper serviceHelper;
    private static final char SEMICOLON = ';';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IPersonGenericService getInstance() {
        try {
            if (null != PERSONGENERICSERVICE) return PERSONGENERICSERVICE;
            Class<PersonGenericServiceImpl> clazz = PersonGenericServiceImpl.class;
            synchronized (PersonGenericServiceImpl.class) {
                if (null != PERSONGENERICSERVICE) return PERSONGENERICSERVICE;
                try {
                    PERSONGENERICSERVICE = new PersonGenericServiceImpl();
                    LOGGER.info("HRPIServiceFactory-dependency-check,new-PersonGenericServiceImpl()-success");
                }
                catch (Throwable t) {
                    LOGGER.error("HRPIServiceFactory-dependency-check,new-PersonGenericServiceImpl()-fail", t);
                }
                return PERSONGENERICSERVICE;
            }
        }
        catch (Throwable t) {
            LOGGER.error("HRPIServiceFactory-dependency-check,PersonGenericServiceImpl-getInstance()-fail", t);
        }
        return PERSONGENERICSERVICE;
    }

    @Override
    public Map<String, Object> saveBatch(Map<String, Object> paramMap) {
        LOGGER.info("PersonGenericService#saveBatch run execute.");
        return this.run(paramMap, PersonGenericSaveEntity::createPersonGenericEntity, PersonGenericOperateTypeEnums.SAVEBATCH);
    }

    @Override
    public Map<String, Object> validate(Map<String, Object> paramMap) {
        LOGGER.info("PersonGenericService#validate run execute.");
        return this.run(paramMap, PersonGenericSaveEntity::createPersonGenericEntity, PersonGenericOperateTypeEnums.VALIDATE);
    }

    @Override
    public Map<String, Object> deleteBatch(Map<String, Object> paramMap) {
        LOGGER.info("PersonGenericService#deleteBatch run execute.");
        return this.run(paramMap, PersonGenericDeleteEntity::createPersonGenericEntity, PersonGenericOperateTypeEnums.DELETEBATCH);
    }

    @Override
    public Map<String, Object> saveBatchStandard(Map<String, Object> paramMap) {
        LOGGER.info("PersonGenericService#saveBatchStandard run execute.");
        return this.run(paramMap, PersonGenericSaveEntity::createPersonGenericEntity, PersonGenericOperateTypeEnums.SAVEBATCHSTANDARD);
    }

    @Override
    public Map<String, Object> discardBatch(Map<String, Object> paramMap) {
        LOGGER.info("PersonGenericService#discardBatch run execute.");
        return this.run(paramMap, PersonGenericDiscardEntity::createPersonGenericEntity, PersonGenericOperateTypeEnums.DISCARDBATCH);
    }

    @Override
    public Map<String, Object> reviseVersionBatch(Map<String, Object> paramMap) {
        LOGGER.info("PersonGenericService#reviseVersionBatch run execute.");
        return this.run(paramMap, PersonGenericSaveEntity::createPersonGenericEntity, PersonGenericOperateTypeEnums.REVISEVERSIONBATCH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> run(Map<String, Object> paramMap, Function<Map<String, Object>, IPersonGenericEntity> func, PersonGenericOperateTypeEnums operateTypeEnums) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            LOGGER.info("PersonGenericServiceImpl run begin, the operateTypeEnums is {}, the actionId is {}, the paramMap is {}", new Object[]{operateTypeEnums.name(), paramMap.get("chgActionId"), LogPrivacyUtil.filterPrivacyProp(paramMap)});
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e);
        }
        try {
            this.validateData(paramMap);
            IPersonGenericEntity personGenericEntity = func.apply(paramMap);
            List entityNumberList = personGenericEntity.getEntityNumberList();
            this.validateEntity(entityNumberList);
            IPersonGenericExecuteService genericService = PersonGenericFactory.createGenericService(personGenericEntity, operateTypeEnums);
            genericService.execute();
            Map<String, Object> result = genericService.result();
            boolean success = (Boolean)result.get("success");
            if (!success) {
                LOGGER.error("PersonGenericServiceImpl run result:{}", (Object)SerializationUtils.toJsonString(result));
            } else {
                this.sendToHRMP(paramMap, operateTypeEnums);
            }
            Map<String, Object> map = result;
            return map;
        }
        catch (KDBizException e) {
            LOGGER.error("PersonGenericService#run execute error! the KDBizException is", (Throwable)e);
            Map map = PersonGenericResult.exception((String)e.getMessage());
            return map;
        }
        catch (Exception e) {
            LOGGER.error("PersonGenericService#run execute error! the exception is", (Throwable)e);
            Map map = PersonGenericResult.exception((String)ResManager.loadKDString((String)"\u901a\u7528\u670d\u52a1\u63a5\u53e3\u5f02\u5e38\u3002", (String)"HRPIPersonGenericService_3", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
            return map;
        }
        finally {
            stopWatch.stop();
            LOGGER.info("PersonGenericService#run execute time is: {} ms.", (Object)stopWatch.getTime());
        }
    }

    private void sendToHRMP(Map<String, Object> paramMap, PersonGenericOperateTypeEnums operateTypeEnums) {
        Optional<DynamicObject> optional;
        Object actionType;
        Map listMap;
        HashMap<String, Object> messageParams;
        List data;
        block12: {
            data = (List)paramMap.get("data");
            messageParams = new HashMap<String, Object>(16);
            try {
                if (PersonGenericOperateTypeEnums.SAVEBATCH == operateTypeEnums) {
                    listMap = data.stream().flatMap(map -> ((DynamicObjectCollection)map.get("hisDyns")).stream()).collect(Collectors.groupingBy(dy -> dy.getDataEntityType().getExtendName(), Collectors.mapping(dy -> dy.getLong("boid") > 0L ? dy.getLong("boid") : dy.getLong("id"), Collectors.toList())));
                    messageParams.put("actionId", IHRPIActionConstants.ADD_UPDATE);
                    messageParams.put("msgTitle", "send msg to integration when saveBach invoked");
                    messageParams.put("msgPubNo", "MP20230814001099");
                    break block12;
                }
                if (PersonGenericOperateTypeEnums.DELETEBATCH == operateTypeEnums) {
                    listMap = data.stream().collect(Collectors.groupingBy(map -> (String)map.get("entityNumber"), Collectors.mapping(map -> (List)map.get("boIdList"), Collectors.reducing(new ArrayList(), (list1, list2) -> {
                        list1.addAll(list2);
                        return list1;
                    }))));
                    messageParams.put("actionId", IHRPIActionConstants.DELETE);
                    messageParams.put("msgTitle", "send msg to integration when deleteBatch invoked");
                    messageParams.put("msgPubNo", "MP20230816001100");
                    break block12;
                }
                LOGGER.info("either save or delete , don't need to sync ");
                return;
            }
            catch (Exception exception) {
                LOGGER.error("map data occur exception : ", (Throwable)exception);
                throw new KDBizException("occur exception when packaging params of listMap for sending HRMP");
            }
        }
        HashMap param = Maps.newHashMap();
        String variationtype = null;
        if (data != null && PersonGenericOperateTypeEnums.DELETEBATCH != operateTypeEnums && null != (actionType = (optional = data.stream().filter(map -> ((Collection)map.get("hisDyns")).stream().anyMatch(dy -> "hrpi_empposorgrel".equals(((DynamicObject)dy).getDataEntityType().getExtendName()))).map(map -> (DynamicObjectCollection)map.get("hisDyns")).flatMap(Collection::stream).filter(dy -> "1".equals(dy.get("businessstatus"))).findFirst()).map(dynamicObject -> dynamicObject.get("variationtype")).orElse(null))) {
            if (actionType instanceof String && HRStringUtils.isNotEmpty((String)actionType.toString())) {
                LOGGER.info("actionType instanceof String");
                try {
                    variationtype = this.getActionTypeByActionTypeId(Long.parseLong(actionType.toString()));
                }
                catch (Exception ex) {
                    LOGGER.error("actionTypeId switch number error", (Throwable)ex);
                }
            } else if (actionType instanceof Long && (Long)actionType > 0L) {
                LOGGER.info("actionType instanceof Long");
                variationtype = this.getActionTypeByActionTypeId((Long)actionType);
            } else if (actionType instanceof DynamicObject) {
                LOGGER.info("actionType instanceof DynamicObject");
                variationtype = ((DynamicObject)actionType).getString("number");
            }
        }
        param.put("variationtype", variationtype);
        param.put("caller", paramMap.get("caller"));
        param.put("data", listMap);
        messageParams.put("msgNumber", "integration" + System.nanoTime());
        messageParams.put("senderId", RequestContext.get().getCurrUserId());
        messageParams.put("sendTime", new Date());
        messageParams.put("params", SerializationUtils.serializeToBase64((Object)param));
        HRProducerServiceHelper.publishAction(messageParams);
        LOGGER.info(String.format("Listen method saveBatch or deleteBatch , send to HRMP when invoke success , the message : %s", JSONObject.toJSONString(messageParams)));
    }

    private String getActionTypeByActionTypeId(Long actionTypeId) {
        DynamicObject actionTypeDy = serviceHelper.queryOne((Object)actionTypeId);
        if (null != actionTypeDy) {
            return actionTypeDy.getString("number");
        }
        return null;
    }

    private void validateData(Map<String, Object> paramMap) {
        List data = (List)MapUtils.getObject(paramMap, (Object)"data");
        if (data == null || data.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u64cd\u4f5c\u7684\u6570\u636e\u96c6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HRPIPersonGenericFactory_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    private void validateEntity(List<String> entityNumberList) {
        Map<String, List<String>> entityNumberMap = entityNumberList.stream().collect(Collectors.groupingBy(s -> s));
        if (entityNumberMap.size() < entityNumberList.size()) {
            StringBuilder errMsg = new StringBuilder();
            for (List<String> entityNumbers : entityNumberMap.values()) {
                if (entityNumbers.size() <= 1) continue;
                String errEntityNumber = entityNumbers.get(0);
                errMsg.append(errEntityNumber).append(';');
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u201c%s\u201d \u7684\u6570\u636e\u5b58\u5728\u591a\u4e2a\u4e0d\u540c\u7684\u6570\u636e\u96c6\uff0c\u8bf7\u5148\u5c06\u6570\u636e\u8fdb\u884c\u5408\u5e76\u5904\u7406\u3002", (String)"HRPIPersonGenericFactory_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]), errMsg.toString()));
        }
    }

    static {
        serviceHelper = new HRBaseServiceHelper("hbss_actiontype");
    }
}

