/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.coderule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.service.generic.coderule.IPersonGenericCodeRule;
import kd.hrmp.hrpi.business.domian.service.impl.generic.coderule.DefaultPersonGenericCodeRule;
import kd.hrmp.hrpi.business.domian.service.impl.generic.coderule.FixedPersonGenericCodeRule;

public class HrpiEmpentrelGenericCodeRule
implements IPersonGenericCodeRule {
    private static final Log LOGGER = LogFactory.getLog(HrpiEmpentrelGenericCodeRule.class);

    public static HrpiEmpentrelGenericCodeRule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void getNumbersAndSet(String entityNumber, DynamicObjectCollection dyColl, String numberFieldName) {
        LOGGER.info("PersonGenericService ==> HrpiEmpentrelGenericCodeRule#getNumbersAndSet {} ", (Object)entityNumber);
        FixedPersonGenericCodeRule.getInstance().getNumbersAndSet(entityNumber, dyColl, numberFieldName);
    }

    @Override
    public void getNumbersAndUpdate(String entityNumber, DynamicObjectCollection dyColl, String numberFieldName) {
        LOGGER.info("PersonGenericService ==> HrpiDepEmpGenericCodeRule#getNumbersAndUpdate {} ", (Object)entityNumber);
        if (CollectionUtils.isEmpty((Collection)dyColl)) {
            return;
        }
        ArrayList<Long> boIdList = new ArrayList<Long>(dyColl.size());
        for (DynamicObject dynamicObject : dyColl) {
            String number = dynamicObject.getString("number");
            if (HRStringUtils.isNotEmpty((String)number) && !"FIXED_NUMBER".equals(number)) continue;
            long boId = dynamicObject.getLong("boid");
            long pkId = dynamicObject.getLong("id");
            if (boId != 0L) {
                boIdList.add(boId);
                continue;
            }
            boIdList.add(pkId);
        }
        if (boIdList.size() == 0) {
            return;
        }
        Object[] empEntByBoIdDyArr = HRPIEmployeeRepository.getEmpEntByBoId(boIdList);
        if (HRArrayUtils.isEmpty((Object[])empEntByBoIdDyArr)) {
            return;
        }
        List<Object> empEntByBoIdDys = Arrays.asList(empEntByBoIdDyArr);
        List numbers = CodeRuleServiceHelper.getNumbers((String)entityNumber, empEntByBoIdDys);
        HashMap<Long, String> sourceNumberMap = new HashMap<Long, String>();
        if (!CollectionUtils.isEmpty((Collection)numbers)) {
            for (int idx = 0; idx < numbers.size(); ++idx) {
                DynamicObject dy2 = (DynamicObject)empEntByBoIdDys.get(idx);
                String number = (String)numbers.get(idx);
                dy2.set(numberFieldName, (Object)number);
                sourceNumberMap.put(dy2.getLong("sourcevid"), number);
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
            serviceHelper.updateDatas(empEntByBoIdDys.toArray(new DynamicObject[0]));
            List sourceIds = empEntByBoIdDys.stream().map(dy -> dy.getLong("sourcevid")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(sourceIds)) {
                return;
            }
            Object[] empEntByIdDys = serviceHelper.query("number,id", new QFilter[]{new QFilter("id", "in", sourceIds)});
            if (HRArrayUtils.isNotEmpty((Object[])empEntByIdDys)) {
                for (Object dy3 : empEntByIdDys) {
                    long id = dy3.getLong("id");
                    String number = (String)sourceNumberMap.get(id);
                    if (!HRStringUtils.isNotEmpty((String)number)) continue;
                    dy3.set("number", (Object)number);
                }
                serviceHelper.updateDatas((DynamicObject[])empEntByIdDys);
            }
        }
    }

    @Override
    public void getNumbersAndUpdate(String entityNumber, DynamicObjectCollection dyColl, String numberFieldName, Consumer<Map<Long, String>> consumer) {
        LOGGER.info("PersonGenericService ==> HrpiEmpentrelGenericCodeRule#getNumbersAndUpdate {} ", (Object)entityNumber);
        DefaultPersonGenericCodeRule.getInstance().getNumbersAndUpdate(entityNumber, dyColl, numberFieldName, consumer);
    }

    private static class Holder {
        static final HrpiEmpentrelGenericCodeRule INSTANCE = new HrpiEmpentrelGenericCodeRule();

        private Holder() {
        }
    }
}

