/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.dataoperate;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hrmp.hrpi.business.domian.service.generic.dataoperate.IPersonGenericDataOperateService;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericDeleteDataEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericDeleteEntity;

public class PersonGenericDataOperateDeleteServiceImpl
implements IPersonGenericDataOperateService {
    private static final Log LOGGER = LogFactory.getLog(PersonGenericDataOperateDeleteServiceImpl.class);

    public static PersonGenericDataOperateDeleteServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public boolean buildDataAndOperate(IPersonGenericContext<?> personGenericContext) {
        PersonGenericDeleteEntity personGenericEntity = (PersonGenericDeleteEntity)personGenericContext.getPersonGenericEntity();
        List dyCollList = personGenericEntity.getData();
        try (TXHandle txHandle = TX.requiresNew();){
            for (PersonGenericDeleteDataEntity personGenericDeleteDataEntity : dyCollList) {
                String entityNumber = personGenericDeleteDataEntity.getEntityNumber();
                List boIdList = personGenericDeleteDataEntity.getBoIdList();
                if (CollectionUtils.isEmpty((Collection)boIdList)) continue;
                try {
                    HisBaseBo hisBaseBo = new HisBaseBo();
                    hisBaseBo.setEntityNumber(entityNumber);
                    hisBaseBo.setBoIdList(personGenericDeleteDataEntity.getBoIdList());
                    HisModelController.getInstance().deleteBo(hisBaseBo);
                    LOGGER.info("PersonGenericService ==> deleteBo request success, entityNumber is: {}", (Object)entityNumber);
                }
                catch (Exception e) {
                    LOGGER.error("PersonGenericService ==> request error.", (Throwable)e);
                    HashMap<String, String> response = new HashMap<String, String>(16);
                    response.put("code", "500");
                    response.put("errorMessage", String.format("request error. %s", e.getMessage()));
                    personGenericContext.addErrorResponse(response);
                    txHandle.markRollback();
                    boolean bl = false;
                    if (txHandle != null) {
                        if (var5_5 != null) {
                            try {
                                txHandle.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                        } else {
                            txHandle.close();
                        }
                    }
                    return bl;
                }
            }
        }
        return true;
    }

    private static class Holder {
        static final PersonGenericDataOperateDeleteServiceImpl INSTANCE = new PersonGenericDataOperateDeleteServiceImpl();

        private Holder() {
        }
    }
}

