/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.dataoperate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.api.HisBatchDiscardApiBo;
import kd.hr.hbp.business.domain.model.newhismodel.api.HisDiscardApiBo;
import kd.hrmp.hrpi.business.domian.service.generic.dataoperate.IPersonGenericDataOperateService;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericDiscardDataEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericDiscardEntity;

public class PersonGenericDataOperateDiscardServiceImpl
implements IPersonGenericDataOperateService {
    private static final Log LOGGER = LogFactory.getLog(PersonGenericDataOperateDiscardServiceImpl.class);

    public static PersonGenericDataOperateDiscardServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public boolean buildDataAndOperate(IPersonGenericContext<?> personGenericContext) {
        PersonGenericDiscardEntity personGenericEntity = (PersonGenericDiscardEntity)personGenericContext.getPersonGenericEntity();
        List dyCollList = personGenericEntity.getData();
        Long eventId = personGenericEntity.getEventId();
        try (TXHandle txHandle = TX.requiresNew();){
            HisBatchDiscardApiBo hisBatchDiscardApiBo = new HisBatchDiscardApiBo();
            ArrayList<HisDiscardApiBo> hisDiscardApiBoList = new ArrayList<HisDiscardApiBo>(dyCollList.size());
            for (PersonGenericDiscardDataEntity personGenericDiscardDataEntity : dyCollList) {
                String entityNumber = personGenericDiscardDataEntity.getEntityNumber();
                List boIdList = personGenericDiscardDataEntity.getBoIdList();
                if (CollectionUtils.isEmpty((Collection)boIdList)) continue;
                HisDiscardApiBo hisDiscardApiBo = new HisDiscardApiBo();
                hisDiscardApiBo.setEntityNumber(entityNumber);
                hisDiscardApiBo.setBoIdSet(new HashSet(personGenericDiscardDataEntity.getBoIdList()));
                hisDiscardApiBoList.add(hisDiscardApiBo);
            }
            hisBatchDiscardApiBo.setHisDiscardApiBoList(hisDiscardApiBoList);
            hisBatchDiscardApiBo.setEventId(eventId);
            try {
                HisModelController.getInstance().batchDiscardBoData(hisBatchDiscardApiBo);
                LOGGER.info("PersonGenericService ==> discardBo request success, params is: {}", (Object)hisBatchDiscardApiBo);
            }
            catch (Exception e) {
                LOGGER.error("PersonGenericService ==> request error.", (Throwable)e);
                HashMap<String, String> response = new HashMap<String, String>(16);
                response.put("code", "500");
                response.put("errorMessage", String.format("request error. %s", e.getMessage()));
                personGenericContext.addErrorResponse(response);
                txHandle.markRollback();
                boolean bl = false;
                if (txHandle != null) {
                    if (var6_6 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    private static class Holder {
        static final PersonGenericDataOperateDiscardServiceImpl INSTANCE = new PersonGenericDataOperateDiscardServiceImpl();

        private Holder() {
        }
    }
}

