/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.dataoperate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseResultBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseReturnDataBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.api.comparediff.CompareDiffApiBatchInputParam;
import kd.hr.hbp.business.domain.model.newhismodel.api.comparediff.CompareDiffApiInputParam;
import kd.hr.hbp.business.domain.model.newhismodel.api.comparediff.CompareDiffApiOutPutParam;
import kd.hr.hbp.business.domain.service.impl.comparediff.HrCommonCompareDiffService;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.service.generic.dataoperate.IPersonGenericDataOperateService;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveDataEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;
import org.apache.commons.lang.time.StopWatch;

public class PersonGenericDataOperateReviseServiceImpl
implements IPersonGenericDataOperateService {
    private static final Log LOGGER = LogFactory.getLog(PersonGenericDataOperateReviseServiceImpl.class);

    public static PersonGenericDataOperateReviseServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean buildDataAndOperate(IPersonGenericContext<?> personGenericContext) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        if (CollectionUtils.isEmpty((Collection)personGenericEntity.getHisDyns())) {
            return false;
        }
        this.removeRepeatHisData(personGenericEntity);
        List dyCollList = personGenericEntity.getData();
        if (CollectionUtils.isEmpty((Collection)dyCollList)) {
            return true;
        }
        Long eventId = personGenericEntity.getEventId();
        TXHandle txHandle = TX.requiresNew();
        try {
            for (PersonGenericSaveDataEntity personGenericSaveDataEntity : dyCollList) {
                if (personGenericSaveDataEntity.getHisDyns().isEmpty()) continue;
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)personGenericSaveDataEntity.getEntityNumber());
                if (!entityType.getProperties().containsKey((Object)"bsed")) {
                    this.nontimeChange(personGenericContext, personGenericSaveDataEntity, eventId, dyCollList, (DynamicObjectType)entityType, stopWatch);
                    continue;
                }
                this.revise(personGenericContext, personGenericSaveDataEntity, stopWatch);
            }
        }
        catch (Exception exp) {
            LOGGER.error("PersonGenericService ==> request error.", (Throwable)exp);
            HrApiResponse response = new HrApiResponse();
            if (exp instanceof KDBizException) {
                ErrorCode errorCode = ((KDBizException)((Object)exp)).getErrorCode();
                response.setCode(errorCode.getCode());
                response.setErrorMessage(errorCode.getMessage());
            } else {
                response.setCode("500");
                response.setErrorMessage(String.format("request error. %s", exp.getMessage()));
            }
            personGenericContext.addErrorResponse(this.parseResponse((HrApiResponse<HisVersionReviseResultBo>)response));
            txHandle.markRollback();
            boolean bl = false;
            return bl;
        }
        finally {
            txHandle.close();
            stopWatch.stop();
            LOGGER.info("PersonGenericService ==> PersonGenericDataOperateReviseServiceImpl#buildDataAndOperate time is: {} ms.", (Object)stopWatch.getTime());
        }
        return true;
    }

    private void nontimeChange(IPersonGenericContext<?> personGenericContext, PersonGenericSaveDataEntity personGenericSaveDataEntity, Long eventId, List<PersonGenericSaveDataEntity> dyCollList, DynamicObjectType entityType, StopWatch stopWatch) {
        HisVersionParamListBo listBo = new HisVersionParamListBo();
        listBo.setEffImmediately(Boolean.TRUE.booleanValue());
        listBo.setAtomicTrans(Boolean.TRUE.booleanValue());
        if (eventId != null && eventId > 0L) {
            listBo.setEventId(eventId);
        }
        listBo.setMainBoId(Long.valueOf(ORM.create().genLongId(personGenericSaveDataEntity.getEntityNumber())));
        listBo.setMainEntityNumber(personGenericSaveDataEntity.getEntityNumber());
        ArrayList<HisVersionParamBo> paramBoList = new ArrayList<HisVersionParamBo>(dyCollList.size());
        HisVersionParamBo paramBo = new HisVersionParamBo();
        paramBo.setEntityNumber(personGenericSaveDataEntity.getEntityNumber());
        ArrayList<DynamicObject> hisDyns = new ArrayList<DynamicObject>();
        for (DynamicObject hisDyn : personGenericSaveDataEntity.getHisDyns()) {
            DynamicObject dy = (DynamicObject)entityType.createInstance();
            HRDynamicObjectUtils.copy((DynamicObject)hisDyn, (DynamicObject)dy);
            hisDyns.add(dy);
        }
        paramBo.setHisDyns(hisDyns.toArray(new DynamicObject[0]));
        paramBoList.add(paramBo);
        listBo.setListHisVersionParamBo(paramBoList);
        LOGGER.info("PersonGenericService ==> params :{}", (Object)listBo);
        stopWatch.split();
        LOGGER.info("PersonGenericService ==> PersonGenericDataOperateReviseServiceImpl#buildDataAndOperate createParams time is: {} ms.", (Object)stopWatch.getSplitTime());
        HisResponse response = HisModelController.getInstance().batchHisVersionChange(listBo);
        stopWatch.split();
        LOGGER.info("PersonGenericService ==> PersonGenericDataOperateReviseServiceImpl#buildDataAndOperate response, use time is: {} ms.", (Object)stopWatch.getSplitTime());
        if (HRStringUtils.equals((String)response.getCode(), (String)"200")) {
            LOGGER.info("PersonGenericService ==> request success", (Object)((BatchVersionChangeRespData)response.getData()).getEventId());
        } else {
            LOGGER.info("PersonGenericService ==> request fail", (Object)response.getErrorMessage());
        }
        personGenericContext.addResponse(this.parseResponse((HisResponse<BatchVersionChangeRespData>)response));
        stopWatch.split();
        LOGGER.info("PersonGenericService ==> PersonGenericDataOperateReviseServiceImpl#buildDataAndOperate addResponse, use time is: {} ms.", (Object)stopWatch.getSplitTime());
    }

    private void revise(IPersonGenericContext<?> personGenericContext, PersonGenericSaveDataEntity personGenericSaveDataEntity, StopWatch stopWatch) {
        HisVersionReviseParamBo params = new HisVersionReviseParamBo();
        params.setEntityNumber(personGenericSaveDataEntity.getEntityNumber());
        if ("hrpi_personrolerel".equals(personGenericSaveDataEntity.getEntityNumber())) {
            personGenericSaveDataEntity.getHisDyns().stream().forEach(dyn -> {
                if (dyn.get("role") instanceof Long) {
                    dyn.set("role_id", (Object)dyn.getLong("role"));
                }
            });
        }
        if ("hrpi_depemp".equals(personGenericSaveDataEntity.getEntityNumber())) {
            personGenericSaveDataEntity.getHisDyns().stream().forEach(dyn -> {
                if (dyn.get("position") instanceof Long) {
                    dyn.set("position_id", (Object)dyn.getLong("position"));
                }
            });
        }
        params.setReviseDys((DynamicObject[])personGenericSaveDataEntity.getHisDyns().toArray((Object[])new DynamicObject[0]));
        LOGGER.info("PersonGenericService ==> params :{}", (Object)params);
        stopWatch.split();
        LOGGER.info("PersonGenericService ==> PersonGenericDataOperateReviseServiceImpl#buildDataAndOperate createParams time is: {} ms.", (Object)stopWatch.getSplitTime());
        HrApiResponse hisVersionReviseResultBoHrApiResponse = HisModelController.getInstance().reviseVersion(params);
        stopWatch.split();
        LOGGER.info("PersonGenericService ==> PersonGenericDataOperateReviseServiceImpl#buildDataAndOperate response, use time is: {} ms.", (Object)stopWatch.getSplitTime());
        if (!HRStringUtils.equals((String)hisVersionReviseResultBoHrApiResponse.getCode(), (String)"200")) {
            LOGGER.info("PersonGenericService ==> request fail,error is {}", (Object)hisVersionReviseResultBoHrApiResponse.getErrorMessage());
            throw new KDBizException(new ErrorCode(hisVersionReviseResultBoHrApiResponse.getCode(), hisVersionReviseResultBoHrApiResponse.getErrorMessage()), new Object[]{hisVersionReviseResultBoHrApiResponse.getData()});
        }
        LOGGER.info("PersonGenericService ==> request success", hisVersionReviseResultBoHrApiResponse.getData());
        DynamicObject[] returnData = ((HisVersionReviseResultBo)hisVersionReviseResultBoHrApiResponse.getData()).getReturnDataBo().getReturnData();
        HRBaseDaoFactory.getInstance((String)personGenericSaveDataEntity.getEntityNumber()).update(returnData);
        personGenericContext.addResponse(this.parseResponse((HrApiResponse<HisVersionReviseResultBo>)hisVersionReviseResultBoHrApiResponse));
        stopWatch.split();
        LOGGER.info("PersonGenericService ==> PersonGenericDataOperateReviseServiceImpl#buildDataAndOperate addResponse, use time is: {} ms.", (Object)stopWatch.getSplitTime());
    }

    protected Map<String, Object> parseResponse(HrApiResponse<HisVersionReviseResultBo> response) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("code", response.getCode());
        resultMap.put("errorMessage", response.getErrorMessage());
        resultMap.put("data", this.parseData((HisVersionReviseResultBo)response.getData()));
        return resultMap;
    }

    protected Map<String, Object> parseResponse(HisResponse<BatchVersionChangeRespData> response) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("code", response.getCode());
        resultMap.put("errorMessage", response.getErrorMessage());
        resultMap.put("data", this.parseData((BatchVersionChangeRespData)response.getData()));
        return resultMap;
    }

    private Map<String, Object> parseData(HisVersionReviseResultBo data) {
        if (HRObjectUtils.isEmpty((Object)data)) {
            return null;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        HisVersionReviseReturnDataBo hisVersionReviseReturnDataBo = data.getReturnDataBo();
        dataMap.put("entitynumber", hisVersionReviseReturnDataBo.getEntityNumber());
        dataMap.put("hisVersionReviseDyns", hisVersionReviseReturnDataBo.getReturnData());
        return dataMap;
    }

    private Map<String, Object> parseData(BatchVersionChangeRespData data) {
        if (HRObjectUtils.isEmpty((Object)data)) {
            return null;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        dataMap.put("eventid", data.getEventId());
        List<Map<String, Object>> list = this.parseVersionChangeRespDataList(data);
        dataMap.put("versionChangeRespDataList", list);
        return dataMap;
    }

    private List<Map<String, Object>> parseVersionChangeRespDataList(BatchVersionChangeRespData data) {
        List versionChangeRespDataList = data.getVersionChangeRespDataList();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(versionChangeRespDataList.size());
        for (VersionChangeRespData versionChangeRespData : versionChangeRespDataList) {
            HashMap<String, Object> mapResult = new HashMap<String, Object>(16);
            mapResult.put("eventid", versionChangeRespData.getEventId());
            mapResult.put("entitynumber", versionChangeRespData.getEntityNumber());
            mapResult.put("newDynamicObjects", versionChangeRespData.getNewDynamicObjects());
            list.add(mapResult);
        }
        return list;
    }

    private void removeRepeatHisData(PersonGenericSaveEntity personGenericEntity) {
        Map hisDynsMap = personGenericEntity.getHisDynsMap();
        List repeatCollection = null;
        try {
            CompareDiffApiBatchInputParam compareDiffApiBatchInputParam = this.createCompareDiffParam(hisDynsMap);
            if (CollectionUtils.isEmpty((Collection)compareDiffApiBatchInputParam.getCompareDiffApiInputParamList())) {
                return;
            }
            HrApiResponse response = HrCommonCompareDiffService.getInstance().isNewDataBatch(compareDiffApiBatchInputParam);
            if (null == response || !EnumResponseCode.FAIL.getCode().equals(response.getCode())) {
                LOGGER.info("PersonGenericService ==> PersonGenericDataOperateReviseServiceImpl#removeRepeatHisData compareHisData finish, the response is :{}", (Object)response);
                return;
            }
            repeatCollection = (List)response.getData();
        }
        catch (Exception ex) {
            LOGGER.error("PersonGenericService ==> PersonGenericDataOperateReviseServiceImpl#removeRepeatHisData compareHisData exception:", (Throwable)ex);
        }
        if (null != repeatCollection && !repeatCollection.isEmpty()) {
            Map<String, List<CompareDiffApiOutPutParam>> repeatMap = repeatCollection.stream().collect(Collectors.groupingBy(CompareDiffApiOutPutParam::getEntityNumber));
            for (Map.Entry<String, List<CompareDiffApiOutPutParam>> entry : repeatMap.entrySet()) {
                DynamicObjectCollection dyColl = personGenericEntity.getHisDyns(entry.getKey());
                for (CompareDiffApiOutPutParam cp : entry.getValue()) {
                    dyColl.removeIf(dy -> cp.getDyOriginal().getLong("id") == dy.getLong("id"));
                }
            }
        }
    }

    private CompareDiffApiBatchInputParam createCompareDiffParam(Map<String, DynamicObjectCollection> hisDynsMap) {
        CompareDiffApiBatchInputParam compareDiffApiBatchInputParam = new CompareDiffApiBatchInputParam();
        ArrayList<CompareDiffApiInputParam> params = new ArrayList<CompareDiffApiInputParam>(hisDynsMap.size());
        compareDiffApiBatchInputParam.setCompareDiffApiInputParamList(params);
        for (Map.Entry<String, DynamicObjectCollection> entry : hisDynsMap.entrySet()) {
            if (null == entry.getValue() || entry.getValue().size() == 0) continue;
            ArrayList<DynamicObject> collect = new ArrayList<DynamicObject>((Collection)entry.getValue());
            collect.removeIf(item -> 0L == item.getLong("boid"));
            if (CollectionUtils.isEmpty(collect)) continue;
            CompareDiffApiInputParam compareDiffApiInputParam = new CompareDiffApiInputParam();
            compareDiffApiInputParam.setEntityNumber(entry.getKey());
            compareDiffApiInputParam.setDynamicObjects(collect.toArray(new DynamicObject[0]));
            DataEntityPropertyCollection properties = HRPIDynamicObjectUtil.getProperties((DynamicObjectCollection)entry.getValue());
            if (properties.containsKey((Object)"boid")) {
                compareDiffApiInputParam.setKeyField("boid");
            } else {
                compareDiffApiInputParam.setKeyField("id");
            }
            params.add(compareDiffApiInputParam);
        }
        return compareDiffApiBatchInputParam;
    }

    private static class Holder {
        static final PersonGenericDataOperateReviseServiceImpl INSTANCE = new PersonGenericDataOperateReviseServiceImpl();

        private Holder() {
        }
    }
}

