/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.dataoperate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.api.comparediff.CompareDiffApiBatchInputParam;
import kd.hr.hbp.business.domain.model.newhismodel.api.comparediff.CompareDiffApiInputParam;
import kd.hr.hbp.business.domain.model.newhismodel.api.comparediff.CompareDiffApiOutPutParam;
import kd.hr.hbp.business.domain.service.impl.comparediff.HrCommonCompareDiffService;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.service.generic.dataoperate.IPersonGenericDataOperateService;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;
import org.apache.commons.lang.time.StopWatch;

public class PersonGenericDataOperateSaveServiceImpl
implements IPersonGenericDataOperateService {
    private static final Log LOGGER = LogFactory.getLog(PersonGenericDataOperateSaveServiceImpl.class);

    public static PersonGenericDataOperateSaveServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean buildDataAndOperate(IPersonGenericContext<?> personGenericContext) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        if (CollectionUtils.isEmpty((Collection)personGenericEntity.getHisDyns())) {
            return false;
        }
        this.removeRepeatHisData(personGenericEntity);
        List dyCollList = personGenericEntity.getHisDyns();
        if (CollectionUtils.isEmpty((Collection)dyCollList)) {
            return true;
        }
        Long eventId = personGenericEntity.getEventId();
        TXHandle txHandle = TX.requiresNew();
        try {
            HisVersionParamListBo params = this.createParams(dyCollList, eventId);
            try {
                List listHisVersionParamBo = params.getListHisVersionParamBo();
                listHisVersionParamBo.stream().map(HisVersionParamBo::getHisDyns).forEach(this::printBsedAndBsled);
            }
            catch (Exception ex) {
                LOGGER.error("println error");
            }
            LOGGER.info("PersonGenericService ==> params :{}", (Object)params);
            stopWatch.split();
            LOGGER.info("PersonGenericService ==> PersonGenericDataOperateSaveServiceImpl#buildDataAndOperate createParams time is: {} ms.", (Object)stopWatch.getSplitTime());
            HisResponse response = HisModelController.getInstance().batchHisVersionChange(params);
            stopWatch.split();
            LOGGER.info("PersonGenericService ==> PersonGenericDataOperateSaveServiceImpl#buildDataAndOperate response, use time is: {} ms.", (Object)stopWatch.getSplitTime());
            if (HRStringUtils.equals((String)response.getCode(), (String)"200")) {
                LOGGER.info("PersonGenericService ==> request success", (Object)((BatchVersionChangeRespData)response.getData()).getEventId());
            } else {
                LOGGER.info("PersonGenericService ==> request fail", (Object)response.getErrorMessage());
            }
            personGenericContext.addResponse(this.parseResponse((HisResponse<BatchVersionChangeRespData>)response));
            stopWatch.split();
            LOGGER.info("PersonGenericService ==> PersonGenericDataOperateSaveServiceImpl#buildDataAndOperate addResponse, use time is: {} ms.", (Object)stopWatch.getSplitTime());
        }
        catch (Exception exp) {
            LOGGER.error("PersonGenericService ==> request error.", (Throwable)exp);
            HisResponse response = new HisResponse();
            if (exp instanceof KDBizException) {
                ErrorCode errorCode = ((KDBizException)((Object)exp)).getErrorCode();
                response.setCode(errorCode.getCode());
                response.setErrorMessage(errorCode.getMessage());
            } else {
                response.setCode("500");
                response.setErrorMessage(String.format("request error. %s", exp.getMessage()));
            }
            personGenericContext.addErrorResponse(this.parseResponse((HisResponse<BatchVersionChangeRespData>)response));
            txHandle.markRollback();
            boolean bl = false;
            return bl;
        }
        finally {
            txHandle.close();
            stopWatch.stop();
            LOGGER.info("PersonGenericService ==> PersonGenericDataOperateSaveServiceImpl#buildDataAndOperate time is: {} ms.", (Object)stopWatch.getTime());
        }
        return true;
    }

    private void printBsedAndBsled(DynamicObject[] dyArr) {
        if (null == dyArr || dyArr.length < 1) {
            return;
        }
        if (dyArr[0].containsProperty("job")) {
            Arrays.stream(dyArr).forEach(dy -> LOGGER.info("buildDataAndOperate id is {}, boid is {}, job is {}", new Object[]{dy.getLong("id"), dy.getLong("boid"), dy.get("job")}));
        }
        if (dyArr[0].containsProperty("bsed") && dyArr[0].containsProperty("bsled")) {
            Arrays.stream(dyArr).forEach(dy -> {
                LOGGER.info("printBsedAndBseld==> entityNumber :{}, boid : {}, bsed:{}, bsled:{}", new Object[]{dy.getDataEntityType(), dy.getLong("boid"), dy.getDate("bsed"), dy.getDate("bsled")});
                LOGGER.info("printBsedAndBseld==> dynamicObject: {}", dy);
            });
        }
    }

    private void removeRepeatHisData(PersonGenericSaveEntity personGenericEntity) {
        Map hisDynsMap = personGenericEntity.getHisDynsMap();
        List repeatCollection = null;
        try {
            CompareDiffApiBatchInputParam compareDiffApiBatchInputParam = this.createCompareDiffParam(hisDynsMap);
            if (CollectionUtils.isEmpty((Collection)compareDiffApiBatchInputParam.getCompareDiffApiInputParamList())) {
                return;
            }
            HrApiResponse response = HrCommonCompareDiffService.getInstance().isNewDataBatch(compareDiffApiBatchInputParam);
            if (null == response || !EnumResponseCode.FAIL.getCode().equals(response.getCode())) {
                LOGGER.info("PersonGenericService ==> PersonGenericDataOperateSaveServiceImpl#removeRepeatHisData compareHisData finish, the response is :{}", (Object)response);
                return;
            }
            repeatCollection = (List)response.getData();
        }
        catch (Exception ex) {
            LOGGER.error("PersonGenericService ==> PersonGenericDataOperateSaveServiceImpl#removeRepeatHisData compareHisData exception:", (Throwable)ex);
        }
        if (null != repeatCollection && !repeatCollection.isEmpty()) {
            Map<String, List<CompareDiffApiOutPutParam>> repeatMap = repeatCollection.stream().collect(Collectors.groupingBy(CompareDiffApiOutPutParam::getEntityNumber));
            for (Map.Entry<String, List<CompareDiffApiOutPutParam>> entry : repeatMap.entrySet()) {
                DynamicObjectCollection dyColl = personGenericEntity.getHisDyns(entry.getKey());
                for (CompareDiffApiOutPutParam cp : entry.getValue()) {
                    dyColl.removeIf(dy -> cp.getDyOriginal().getLong("id") == dy.getLong("id"));
                }
            }
        }
    }

    private CompareDiffApiBatchInputParam createCompareDiffParam(Map<String, DynamicObjectCollection> hisDynsMap) {
        CompareDiffApiBatchInputParam compareDiffApiBatchInputParam = new CompareDiffApiBatchInputParam();
        ArrayList<CompareDiffApiInputParam> params = new ArrayList<CompareDiffApiInputParam>(hisDynsMap.size());
        compareDiffApiBatchInputParam.setCompareDiffApiInputParamList(params);
        for (Map.Entry<String, DynamicObjectCollection> entry : hisDynsMap.entrySet()) {
            if (null == entry.getValue() || entry.getValue().size() == 0) continue;
            ArrayList<DynamicObject> collect = new ArrayList<DynamicObject>((Collection)entry.getValue());
            collect.removeIf(item -> 0L == item.getLong("boid"));
            if (CollectionUtils.isEmpty(collect)) continue;
            CompareDiffApiInputParam compareDiffApiInputParam = new CompareDiffApiInputParam();
            compareDiffApiInputParam.setEntityNumber(entry.getKey());
            compareDiffApiInputParam.setDynamicObjects(collect.toArray(new DynamicObject[0]));
            DataEntityPropertyCollection properties = HRPIDynamicObjectUtil.getProperties((DynamicObjectCollection)entry.getValue());
            if (properties.containsKey((Object)"boid")) {
                compareDiffApiInputParam.setKeyField("boid");
            } else {
                compareDiffApiInputParam.setKeyField("id");
            }
            compareDiffApiInputParam.setStringNullEqualsEmpty(true);
            params.add(compareDiffApiInputParam);
        }
        return compareDiffApiBatchInputParam;
    }

    private HisVersionParamListBo createParams(List<DynamicObjectCollection> dyCollList, Long eventId) {
        HisVersionParamListBo listBo = new HisVersionParamListBo();
        listBo.setEffImmediately(Boolean.TRUE.booleanValue());
        listBo.setAtomicTrans(Boolean.TRUE.booleanValue());
        if (eventId != null && eventId > 0L) {
            listBo.setEventId(eventId);
        }
        this.setMainBo(listBo, HRPIDynamicObjectUtil.getEntityNumber((DynamicObjectCollection)dyCollList.get(0)));
        this.setListHisVersionParamBo(dyCollList, listBo);
        return listBo;
    }

    private void setMainBo(HisVersionParamListBo listBo, String entityNumber) {
        listBo.setMainBoId(Long.valueOf(ORM.create().genLongId(entityNumber)));
        listBo.setMainEntityNumber(entityNumber);
    }

    private void setListHisVersionParamBo(List<DynamicObjectCollection> dyCollList, HisVersionParamListBo listBo) {
        ArrayList<HisVersionParamBo> paramBoList = new ArrayList<HisVersionParamBo>(dyCollList.size());
        for (DynamicObjectCollection dyCollection : dyCollList) {
            String entityNumber = HRPIDynamicObjectUtil.getEntityNumber((DynamicObjectCollection)dyCollection);
            HisVersionParamBo paramBo = new HisVersionParamBo();
            paramBo.setEntityNumber(entityNumber);
            paramBo.setHisDyns((DynamicObject[])dyCollection.toArray((Object[])new DynamicObject[0]));
            paramBoList.add(paramBo);
        }
        listBo.setListHisVersionParamBo(paramBoList);
    }

    protected Map<String, Object> parseResponse(HisResponse<BatchVersionChangeRespData> response) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("code", response.getCode());
        resultMap.put("errorMessage", response.getErrorMessage());
        resultMap.put("data", this.parseData((BatchVersionChangeRespData)response.getData()));
        return resultMap;
    }

    private Map<String, Object> parseData(BatchVersionChangeRespData data) {
        if (HRObjectUtils.isEmpty((Object)data)) {
            return null;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        dataMap.put("eventid", data.getEventId());
        List<Map<String, Object>> list = this.parseVersionChangeRespDataList(data);
        dataMap.put("versionChangeRespDataList", list);
        return dataMap;
    }

    private List<Map<String, Object>> parseVersionChangeRespDataList(BatchVersionChangeRespData data) {
        List versionChangeRespDataList = data.getVersionChangeRespDataList();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(versionChangeRespDataList.size());
        for (VersionChangeRespData versionChangeRespData : versionChangeRespDataList) {
            HashMap<String, Object> mapResult = new HashMap<String, Object>(16);
            mapResult.put("eventid", versionChangeRespData.getEventId());
            mapResult.put("entitynumber", versionChangeRespData.getEntityNumber());
            mapResult.put("newDynamicObjects", versionChangeRespData.getNewDynamicObjects());
            list.add(mapResult);
        }
        return list;
    }

    private static class Holder {
        static final PersonGenericDataOperateSaveServiceImpl INSTANCE = new PersonGenericDataOperateSaveServiceImpl();

        private Holder() {
        }
    }
}

