/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.dataoperate;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.service.generic.dataoperate.IPersonGenericDataOperateService;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import org.apache.commons.lang.time.StopWatch;

public class PersonGenericDataOperateSaveStandardServiceImpl
implements IPersonGenericDataOperateService {
    private static final Log LOGGER = LogFactory.getLog(PersonGenericDataOperateSaveStandardServiceImpl.class);

    public static PersonGenericDataOperateSaveStandardServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean buildDataAndOperate(IPersonGenericContext<?> personGenericContext) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        if (CollectionUtils.isEmpty((Collection)personGenericEntity.getHisDyns())) {
            return false;
        }
        TXHandle txHandle = TX.requiresNew();
        try {
            Map hisDynsMap = personGenericEntity.getHisDynsMap();
            for (Map.Entry entry : hisDynsMap.entrySet()) {
                String entityNumber = (String)entry.getKey();
                DynamicObjectCollection dyColl = (DynamicObjectCollection)entry.getValue();
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
                if (dyColl.isEmpty() || !HRStringUtils.isNotEmpty((String)dataEntityType.getAlias())) continue;
                stopWatch.split();
                LOGGER.info("PersonGenericService ==> PersonGenericDataOperateSaveStandardServiceImpl#buildDataAndOperate entityNumber:{} save begin, time is: {} ms.", (Object)entityNumber, (Object)stopWatch.getSplitTime());
                HRBaseDaoFactory.getInstance((String)entityNumber).save((DynamicObject[])dyColl.toArray((Object[])new DynamicObject[0]));
                stopWatch.split();
                LOGGER.info("PersonGenericService ==> PersonGenericDataOperateSaveStandardServiceImpl#buildDataAndOperate entityNumber:{} save end, use time is: {} ms.", (Object)stopWatch.getSplitTime());
            }
            personGenericContext.addResponse(this.success());
            stopWatch.split();
            LOGGER.info("PersonGenericService ==> PersonGenericDataOperateSaveStandardServiceImpl#buildDataAndOperate save end, use time is: {} ms.", (Object)stopWatch.getSplitTime());
        }
        catch (Exception exp) {
            LOGGER.error("PersonGenericService ==> save error.", (Throwable)exp);
            HashMap<String, String> resultMap = new HashMap<String, String>(16);
            if (exp instanceof KDBizException) {
                ErrorCode errorCode = ((KDBizException)((Object)exp)).getErrorCode();
                resultMap.put("code", errorCode.getCode());
                resultMap.put("errorMessage", errorCode.getMessage());
            } else {
                resultMap.put("code", "500");
                resultMap.put("errorMessage", String.format("save error. %s", exp.getMessage()));
            }
            personGenericContext.addErrorResponse(resultMap);
            txHandle.markRollback();
            boolean bl = false;
            return bl;
        }
        finally {
            txHandle.close();
            stopWatch.stop();
            LOGGER.info("PersonGenericService ==> PersonGenericDataOperateSaveStandardServiceImpl#buildDataAndOperate time is: {} ms.", (Object)stopWatch.getTime());
        }
        return true;
    }

    private Map<String, Object> success() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("code", "200");
        resultMap.put("errorMessage", "");
        return resultMap;
    }

    private static class Holder {
        static final PersonGenericDataOperateSaveStandardServiceImpl INSTANCE = new PersonGenericDataOperateSaveStandardServiceImpl();

        private Holder() {
        }
    }
}

