/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.execute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.service.generic.dataoperate.IPersonGenericDataOperateService;
import kd.hrmp.hrpi.business.domian.service.generic.execute.IPersonGenericExecuteService;
import kd.hrmp.hrpi.business.domian.service.generic.rule.IPersonGenericRuleService;
import kd.hrmp.hrpi.business.domian.service.generic.strategy.IPersonGenericStrategy;
import kd.hrmp.hrpi.business.domian.service.generic.validate.IPersonGenericValidateService;
import kd.hrmp.hrpi.business.domian.service.impl.SyncPersonToUserServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.execute.AbstractPersonGenericExecuteService;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.AbstractPersonGenericSaveRuleService;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.context.PersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.generic.enums.PersonGenericMergeRelateDataTypeEnums;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.time.StopWatch;

public class PersonGenericExecuteSaveBatchServiceImpl
extends AbstractPersonGenericExecuteService {
    private static final Log LOGGER = LogFactory.getLog(PersonGenericExecuteSaveBatchServiceImpl.class);
    protected static final int CORE_THREAD = Runtime.getRuntime().availableProcessors();
    protected static final int MAX_THREAD = CORE_THREAD * 10;
    protected static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"ThreadSaveExecutor-Thread", (int)CORE_THREAD, (int)MAX_THREAD, (String)"hr");
    protected static final ThreadPool SYNC_THREAD_POOL = ThreadPools.newCachedThreadPool((String)"SyncBosUserExecutor-Thread", (int)CORE_THREAD, (int)MAX_THREAD, (String)"hr");
    private final SaveExecutor executor;
    private PersonGenericContext<PersonGenericSaveEntity> saveContext;
    private boolean onlyValidate;

    public PersonGenericExecuteSaveBatchServiceImpl(boolean useThread) {
        this.personGenericStrategyServiceMap = useThread ? new ConcurrentHashMap(16) : new HashMap(16);
        this.executor = useThread ? new ThreadSaveExecutor() : new SaveExecutor();
        this.useThread = useThread;
    }

    public PersonGenericExecuteSaveBatchServiceImpl(boolean useThread, boolean onlyValidate) {
        this.personGenericStrategyServiceMap = useThread ? new ConcurrentHashMap(16) : new HashMap(16);
        this.executor = useThread ? new ThreadSaveExecutor() : new SaveExecutor();
        this.useThread = useThread;
        this.onlyValidate = onlyValidate;
    }

    @Override
    public void execute() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.init();
            this.doExecute();
            stopWatch.split();
            LOGGER.info("PersonGenericService ==> PersonGenericExecuteSaveBatchServiceImpl#execute doExecute time is: {} ms.", (Object)stopWatch.getSplitTime());
            if (!this.onlyValidate) {
                this.buildDataAndOperate();
                stopWatch.split();
                LOGGER.info("PersonGenericService ==> PersonGenericExecuteSaveBatchServiceImpl#execute buildDataAndOperate time is: {} ms.", (Object)stopWatch.getSplitTime());
            }
        }
        finally {
            this.destory();
            stopWatch.stop();
            LOGGER.info("PersonGenericService ==> PersonGenericExecuteSaveBatchServiceImpl#execute time is: {} ms.", (Object)stopWatch.getTime());
        }
    }

    private void init() {
        this.executor.doInit();
        this.doInitData();
    }

    private void doInitData() {
        List entityNumberList = this.getContext().getPersonGenericEntity().getEntityNumberList();
        for (String entityNumber : entityNumberList) {
            IPersonGenericStrategy personGenericStrategyService = this.getPersonGenericStrategyService(entityNumber);
            IPersonGenericRuleService personGenericRuleService = personGenericStrategyService.getPersonGenericRuleService();
            personGenericRuleService.initData(entityNumber, (IPersonGenericContext<?>)this.saveContext);
        }
    }

    private void doExecute() {
        List entityNumberList = this.getContext().getPersonGenericEntity().getEntityNumberList();
        LOGGER.info("PersonGenericService ==> PersonGenericExecuteSaveBatchServiceImpl#doExecute entityNumberList: {}.", (Object)entityNumberList);
        this.executor.doExecutor(entityNumberList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildDataAndOperate() {
        IPersonGenericDataOperateService personGenericDataOperateService = this.getPersonGenericDataOperateService();
        if (HRObjectUtils.isEmpty((Object)personGenericDataOperateService)) {
            LOGGER.info("PersonGenericService ==> PersonGenericExecuteSaveBatchServiceImpl#buildDataAndOperate, operateType is validateOnly.");
            return;
        }
        boolean mustAllSuccess = ((PersonGenericSaveEntity)this.saveContext.getPersonGenericEntity()).isMustAllSuccess();
        if (!mustAllSuccess || !this.saveContext.hasFailData()) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            try {
                this.mergeOperateDyCollDataList();
                boolean operateResult = personGenericDataOperateService.buildDataAndOperate((IPersonGenericContext<?>)this.saveContext);
                stopWatch.split();
                LOGGER.info("PersonGenericService ==> PersonGenericExecuteSaveBatchServiceImpl#buildDataAndOperate buildDataAndOperate time is: {} ms.", (Object)stopWatch.getSplitTime());
                if (operateResult) {
                    this.afterExecute();
                    stopWatch.split();
                    LOGGER.info("PersonGenericService ==> PersonGenericExecuteSaveBatchServiceImpl#buildDataAndOperate afterExecute time is: {} ms.", (Object)stopWatch.getSplitTime());
                } else {
                    this.afterRollbackExecute();
                    stopWatch.split();
                    LOGGER.info("PersonGenericService ==> PersonGenericExecuteSaveBatchServiceImpl#buildDataAndOperate afterRollbackExecute time is: {} ms.", (Object)stopWatch.getSplitTime());
                }
            }
            finally {
                stopWatch.stop();
                LOGGER.info("PersonGenericService ==> PersonGenericExecuteSaveBatchServiceImpl#buildDataAndOperate time is: {} ms.", (Object)stopWatch.getTime());
            }
        }
    }

    private void afterExecute() {
        List entityNumberList = this.getContext().getPersonGenericEntity().getEntityNumberList();
        LOGGER.info("PersonGenericService ==> PersonGenericExecuteSaveBatchServiceImpl#afterExecute entityNumberList: {}.", (Object)entityNumberList);
        this.executor.afterExecute(entityNumberList);
    }

    private void syncBosUser() {
        LOGGER.info("PersonGenericExecuteSaveBatchServiceImpl#execute syncBosUser begin");
        PersonGenericSaveEntity saveEntity = (PersonGenericSaveEntity)this.saveContext.getPersonGenericEntity();
        if (!saveEntity.isSyncBosUser()) {
            LOGGER.info("PersonGenericExecuteSaveBatchServiceImpl#execute isSyncBosUser is false");
            return;
        }
        Long chgActionId = saveEntity.getChgActionId();
        LOGGER.info("PersonGenericExecuteSaveBatchServiceImpl#execute syncBosUser chgActionId {}", (Object)chgActionId);
        List resultData = this.saveContext.getResultData();
        HashMap<Long, Set> personEmpMap = new HashMap<Long, Set>();
        resultData.forEach(resultMap -> {
            Map dataMap = (Map)resultMap.get("data");
            List dataList = (List)dataMap.get("versionChangeRespDataList");
            if (!CollectionUtils.isEmpty((Collection)dataList)) {
                dataList.stream().filter(data -> HRArrayUtils.isNotEmpty((Object[])((DynamicObject[])data.get("newDynamicObjects")))).forEach(data -> {
                    DynamicObject[] dynamicObjects = (DynamicObject[])data.get("newDynamicObjects");
                    String entityNumber = (String)data.get("entitynumber");
                    Arrays.asList(dynamicObjects).stream().forEach(dynamicObject -> {
                        Long employeeId;
                        Long personId = HRStringUtils.equals((String)"hrpi_person", (String)entityNumber) ? Long.valueOf(dynamicObject.getLong("boid")) : this.getBasicPropByPropName((DynamicObject)dynamicObject, "person");
                        Long l = employeeId = HRStringUtils.equals((String)"hrpi_employee", (String)entityNumber) ? Long.valueOf(dynamicObject.getLong("boid")) : this.getBasicPropByPropName((DynamicObject)dynamicObject, "employee");
                        if (Objects.nonNull(personId) && personId > 0L) {
                            personEmpMap.compute(personId, (key, empSet) -> {
                                if (Objects.isNull(empSet)) {
                                    empSet = new HashSet<Long>();
                                }
                                if (employeeId > 0L) {
                                    empSet.add(employeeId);
                                }
                                return empSet;
                            });
                        }
                    });
                });
            }
        });
        ArrayList paramList = new ArrayList();
        if (MapUtils.isNotEmpty(personEmpMap)) {
            personEmpMap.forEach((personId, empIds) -> {
                HashMap<String, Long> paramMap = new HashMap<String, Long>();
                paramMap.put("personId", (Long)personId);
                if (Objects.nonNull(chgActionId)) {
                    paramMap.put("actionId", chgActionId);
                }
                if (CollectionUtils.isEmpty((Collection)empIds)) {
                    paramList.add(paramMap);
                } else {
                    empIds.stream().forEach(empId -> {
                        HashMap<String, Long> empParamMap = new HashMap<String, Long>();
                        empParamMap.putAll(paramMap);
                        empParamMap.put("employeeId", (Long)empId);
                        paramList.add(empParamMap);
                    });
                }
            });
        }
        if (!CollectionUtils.isEmpty(paramList)) {
            SYNC_THREAD_POOL.execute(() -> {
                LOGGER.info("PersonGenericExecuteSaveBatchServiceImpl#execute syncBosUser, eventId {}, paramList is {}", (Object)saveEntity.getEventId(), (Object)paramList);
                SyncPersonToUserServiceImpl.getInstance().syncHRPersonToSysUser(paramList);
            });
        }
    }

    private Long getBasicPropByPropName(DynamicObject dy, String propName) {
        String propNameId = String.format("propName_%s", "id");
        if (dy.containsProperty(propNameId) && 0L != dy.getLong(propNameId)) {
            return dy.getLong(propNameId);
        }
        if (dy.containsProperty(propName)) {
            Object o = dy.get(propName);
            if (o instanceof DynamicObject) {
                return (Long)((DynamicObject)o).getPkValue();
            }
            if (o instanceof Long) {
                return (Long)o;
            }
        }
        return 0L;
    }

    private void afterRollbackExecute() {
        List entityNumberList = this.getContext().getPersonGenericEntity().getEntityNumberList();
        LOGGER.info("PersonGenericService ==> PersonGenericExecuteSaveBatchServiceImpl#afterRollbackExecute entityNumberList: {}.", (Object)entityNumberList);
        this.executor.afterRollbackExecute(entityNumberList);
    }

    private void mergeOperateDyCollDataList() {
        PersonGenericSaveEntity personGenericSaveEntity = (PersonGenericSaveEntity)this.saveContext.getPersonGenericEntity();
        this.executor.doMergeRelateDyns(personGenericSaveEntity.getMergeRelateHisDynsMap(), PersonGenericMergeRelateDataTypeEnums.CONTEXT);
        this.executor.doMergeRelateDyns(personGenericSaveEntity.getMergeRelateDbDynsMap(), PersonGenericMergeRelateDataTypeEnums.UPDATEDB);
        this.executor.doMergeRelateDyns(personGenericSaveEntity.getMergeRelateHisDynsRemoveMap(), PersonGenericMergeRelateDataTypeEnums.CONTEXTREMOVE);
    }

    private void destory() {
        this.executor.doDestory();
    }

    @Override
    public Map<String, Object> result() {
        return super.result();
    }

    @Override
    public void setContext(IPersonGenericContext<?> context) {
        super.setContext(context);
        this.saveContext = (PersonGenericContext)context;
    }

    class ThreadSaveExecutor
    extends SaveExecutor {
        private Semaphore semaphore;
        private CountDownLatch countDownLatch;

        ThreadSaveExecutor() {
        }

        @Override
        public void doInit() {
            this.initThreadControl();
        }

        private void initThreadControl() {
            int dataSize = ((PersonGenericSaveEntity)PersonGenericExecuteSaveBatchServiceImpl.this.saveContext.getPersonGenericEntity()).getDataSize();
            this.initSemaphore(dataSize);
            this.initCountDownLaunch(dataSize);
        }

        private void initSemaphore(int dataSize) {
            this.semaphore = dataSize > CORE_THREAD ? new Semaphore(CORE_THREAD) : new Semaphore(dataSize);
        }

        private void initCountDownLaunch(int dataSize) {
            this.countDownLatch = new CountDownLatch(dataSize);
        }

        private void unBlockMainThread() {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            try {
                long lastThreadCount = this.countDownLatch.getCount();
                LOGGER.info("PersonGenericService ==> ThreadSaveExecutor#unBlockMainThread lastThreadCount: {}", (Object)lastThreadCount);
                this.countDownLatch.await();
            }
            catch (Exception exp) {
                LOGGER.error("PersonGenericService ==> ThreadSaveExecutor#unBlockMainThread has exception!", (Throwable)exp);
                throw new KDException((Throwable)exp, new ErrorCode(this.getClass().getSimpleName(), exp.getMessage()), new Object[0]);
            }
            finally {
                stopWatch.stop();
                LOGGER.info("PersonGenericService ==> ThreadSaveExecutor#unBlockMainThread finish, use time is: {} ms.", (Object)stopWatch.getTime());
            }
        }

        @Override
        public void doExecutor(List<String> entityNumberList) {
            this.doThreadExecutor(entityNumberList);
        }

        private void doThreadExecutor(List<String> entityNumberList) {
            IPersonGenericStrategy personGenericStrategyService;
            for (String entityNumber : entityNumberList) {
                personGenericStrategyService = PersonGenericExecuteSaveBatchServiceImpl.this.getPersonGenericStrategyService(entityNumber);
                this.doThreadValidateExecute(entityNumber, personGenericStrategyService);
            }
            this.unBlockMainThread();
            this.initCountDownLaunch(((PersonGenericSaveEntity)PersonGenericExecuteSaveBatchServiceImpl.this.saveContext.getPersonGenericEntity()).getDataSize());
            for (String entityNumber : entityNumberList) {
                personGenericStrategyService = PersonGenericExecuteSaveBatchServiceImpl.this.getPersonGenericStrategyService(entityNumber);
                this.doThreadRuleExecute(entityNumber, personGenericStrategyService);
            }
            this.unBlockMainThread();
        }

        private void doThreadValidateExecute(String entityNumber, IPersonGenericStrategy personGenericStrategyService) {
            try {
                this.semaphore.acquire();
                THREAD_POOL.execute(() -> {
                    this.doValidateExecute(entityNumber, personGenericStrategyService);
                    this.countDownLatch.countDown();
                    this.semaphore.release();
                }, RequestContext.get());
            }
            catch (InterruptedException exp) {
                LOGGER.error(String.format("PersonGenericService ==> ThreadSaveExecutor#doThreadValidateExecute, entityNumber\uff1a%s, has exception!", entityNumber), (Throwable)exp);
                throw new KDException((Throwable)exp, new ErrorCode(this.getClass().getSimpleName(), exp.getMessage()), new Object[0]);
            }
        }

        private void doThreadRuleExecute(String entityNumber, IPersonGenericStrategy personGenericStrategyService) {
            try {
                this.semaphore.acquire();
                THREAD_POOL.execute(() -> {
                    this.doRuleExecute(entityNumber, personGenericStrategyService);
                    this.countDownLatch.countDown();
                    this.semaphore.release();
                }, RequestContext.get());
            }
            catch (InterruptedException exp) {
                LOGGER.error(String.format("PersonGenericService ==> ThreadSaveExecutor#doThreadRuleExecute, entityNumber\uff1a%s, has exception!", entityNumber), (Throwable)exp);
                throw new KDException((Throwable)exp, new ErrorCode(this.getClass().getSimpleName(), exp.getMessage()), new Object[0]);
            }
        }

        @Override
        protected <T> void doMergeRelateDyns(Map<String, List<T>> mergeRelateDynsMap, PersonGenericMergeRelateDataTypeEnums dataTypeEnums) {
            this.initCountDownLaunch(mergeRelateDynsMap.size());
            super.doMergeRelateDyns(mergeRelateDynsMap, dataTypeEnums);
            this.unBlockMainThread();
        }

        @Override
        protected <T> void doMergeRelateDyns(AbstractPersonGenericSaveRuleService personGenericRuleService, String entityNumber, List<T> relateDataList, DynamicObjectCollection hisDynsDyColl, PersonGenericMergeRelateDataTypeEnums dataTypeEnums) {
            this.doThreadMergeRelateData(personGenericRuleService, entityNumber, relateDataList, hisDynsDyColl, dataTypeEnums);
        }

        protected <T> void doThreadMergeRelateData(AbstractPersonGenericSaveRuleService personGenericRuleService, String entityNumber, List<T> relateDataList, DynamicObjectCollection hisDynsDyColl, PersonGenericMergeRelateDataTypeEnums dataTypeEnums) {
            try {
                this.semaphore.acquire();
                THREAD_POOL.execute(() -> {
                    personGenericRuleService.mergeRelateData(entityNumber, relateDataList, hisDynsDyColl, dataTypeEnums, (IPersonGenericContext<PersonGenericSaveEntity>)PersonGenericExecuteSaveBatchServiceImpl.this.saveContext);
                    this.countDownLatch.countDown();
                    this.semaphore.release();
                }, RequestContext.get());
            }
            catch (InterruptedException exp) {
                LOGGER.error(String.format("PersonGenericService ==> ThreadSaveExecutor#threadMergeRelateData, entityNumber\uff1a%s, has exception!", entityNumber), (Throwable)exp);
                throw new KDException((Throwable)exp, new ErrorCode(this.getClass().getSimpleName(), exp.getMessage()), new Object[0]);
            }
        }

        @Override
        public void doDestory() {
        }
    }

    class SaveExecutor
    implements IPersonGenericExecuteService.Executor {
        SaveExecutor() {
        }

        @Override
        public void doInit() {
        }

        @Override
        public void doExecutor(List<String> entityNumberList) {
            this.doSimpleExecutor(entityNumberList);
        }

        protected void doSimpleExecutor(List<String> entityNumberList) {
            IPersonGenericStrategy personGenericStrategyService;
            for (String entityNumber : entityNumberList) {
                personGenericStrategyService = PersonGenericExecuteSaveBatchServiceImpl.this.getPersonGenericStrategyService(entityNumber);
                this.doValidateExecute(entityNumber, personGenericStrategyService);
            }
            for (String entityNumber : entityNumberList) {
                personGenericStrategyService = PersonGenericExecuteSaveBatchServiceImpl.this.getPersonGenericStrategyService(entityNumber);
                this.doRuleExecute(entityNumber, personGenericStrategyService);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doValidateExecute(String entityNumber, IPersonGenericStrategy personGenericStrategyService) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            IPersonGenericValidateService personGenericValidateService = personGenericStrategyService.getPersonGenericValidateService();
            IPersonGenericRuleService personGenericRuleService = personGenericStrategyService.getPersonGenericRuleService();
            try {
                personGenericRuleService.initRuleExecute(entityNumber, (IPersonGenericContext<?>)PersonGenericExecuteSaveBatchServiceImpl.this.saveContext);
                stopWatch.split();
                LOGGER.info("PersonGenericService ==> SaveExecutor#doValidateExecute {} initRuleExecute time is: {} ms.", (Object)entityNumber, (Object)stopWatch.getSplitTime());
                personGenericValidateService.validate(entityNumber, (IPersonGenericContext<?>)PersonGenericExecuteSaveBatchServiceImpl.this.saveContext);
                stopWatch.split();
                LOGGER.info("PersonGenericService ==> SaveExecutor#doValidateExecute {} validate time is: {} ms.", (Object)entityNumber, (Object)stopWatch.getSplitTime());
                personGenericRuleService.filterRuleExecute(entityNumber, (IPersonGenericContext<?>)PersonGenericExecuteSaveBatchServiceImpl.this.saveContext);
                stopWatch.split();
                LOGGER.info("PersonGenericService ==> SaveExecutor#doValidateExecute {} filterRuleExecute time is: {} ms.", (Object)entityNumber, (Object)stopWatch.getSplitTime());
            }
            catch (Exception ex) {
                LOGGER.error("PersonGenericService ==> SaveExecutor#doValidateExecute error!", (Throwable)ex);
                PersonGenericExecuteSaveBatchServiceImpl.this.context.addExceptionMessage(entityNumber, ex.getMessage());
            }
            finally {
                stopWatch.stop();
                LOGGER.info("PersonGenericService ==> SaveExecutor#doValidateExecute {} time is: {} ms.", (Object)entityNumber, (Object)stopWatch.getTime());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRuleExecute(String entityNumber, IPersonGenericStrategy personGenericStrategyService) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            IPersonGenericRuleService personGenericRuleService = personGenericStrategyService.getPersonGenericRuleService();
            try {
                personGenericRuleService.specialRuleExecute(entityNumber, (IPersonGenericContext<?>)PersonGenericExecuteSaveBatchServiceImpl.this.saveContext);
            }
            catch (Exception ex) {
                LOGGER.error("PersonGenericService ==> SaveExecutor#doRuleExecute error ,the entityNumber is {}, the exception:{}", (Object)entityNumber, (Object)ex);
                PersonGenericExecuteSaveBatchServiceImpl.this.context.addExceptionMessage(entityNumber, ex.getMessage());
                try {
                    personGenericRuleService.specialExceptionRuleExecute(entityNumber, (IPersonGenericContext<?>)PersonGenericExecuteSaveBatchServiceImpl.this.saveContext);
                }
                catch (Exception ex1) {
                    LOGGER.error("PersonGenericService ==> SaveExecutor#doRuleExecute specialExceptionRuleExecute error ,the entityNumber is {}, the exception:{}", (Object)entityNumber, (Object)ex);
                    PersonGenericExecuteSaveBatchServiceImpl.this.context.addExceptionMessage(entityNumber, ex1.getMessage());
                }
            }
            finally {
                stopWatch.stop();
                LOGGER.info("PersonGenericService ==> SaveExecutor#doRuleExecute {} time is: {} ms.", (Object)entityNumber, (Object)stopWatch.getTime());
            }
        }

        protected <T> void doMergeRelateDyns(Map<String, List<T>> mergeRelateDynsMap, PersonGenericMergeRelateDataTypeEnums dataTypeEnums) {
            PersonGenericSaveEntity personGenericSaveEntity = (PersonGenericSaveEntity)PersonGenericExecuteSaveBatchServiceImpl.this.saveContext.getPersonGenericEntity();
            if (!mergeRelateDynsMap.isEmpty()) {
                for (Map.Entry<String, List<T>> entry : mergeRelateDynsMap.entrySet()) {
                    String entityNumber = entry.getKey();
                    DynamicObjectCollection hisDynsDyColl = personGenericSaveEntity.getHisDyns(entityNumber);
                    if (PersonGenericMergeRelateDataTypeEnums.UPDATEDB == dataTypeEnums && CollectionUtils.isEmpty((Collection)hisDynsDyColl)) {
                        hisDynsDyColl = personGenericSaveEntity.addData(entityNumber);
                    }
                    AbstractPersonGenericSaveRuleService personGenericRuleService = (AbstractPersonGenericSaveRuleService)PersonGenericExecuteSaveBatchServiceImpl.this.getPersonGenericStrategyService(entityNumber).getPersonGenericRuleService();
                    this.doMergeRelateDyns(personGenericRuleService, entityNumber, entry.getValue(), hisDynsDyColl, dataTypeEnums);
                }
            }
        }

        protected <T> void doMergeRelateDyns(AbstractPersonGenericSaveRuleService personGenericRuleService, String entityNumber, List<T> relateDataList, DynamicObjectCollection hisDynsDyColl, PersonGenericMergeRelateDataTypeEnums dataTypeEnums) {
            this.doSimpleMergeRelateDyns(personGenericRuleService, entityNumber, relateDataList, hisDynsDyColl, dataTypeEnums);
        }

        private <T> void doSimpleMergeRelateDyns(AbstractPersonGenericSaveRuleService personGenericRuleService, String entityNumber, List<T> relateDataList, DynamicObjectCollection hisDynsDyColl, PersonGenericMergeRelateDataTypeEnums dataTypeEnums) {
            personGenericRuleService.mergeRelateData(entityNumber, relateDataList, hisDynsDyColl, dataTypeEnums, (IPersonGenericContext<PersonGenericSaveEntity>)PersonGenericExecuteSaveBatchServiceImpl.this.saveContext);
        }

        @Override
        public void afterExecute(List<String> entityNumberList) {
            this.doSimpleAfterExecute(entityNumberList);
        }

        private void doSimpleAfterExecute(List<String> entityNumberList) {
            for (String entityNumber : entityNumberList) {
                IPersonGenericStrategy personGenericStrategyService = PersonGenericExecuteSaveBatchServiceImpl.this.getPersonGenericStrategyService(entityNumber);
                this.doAfterExecute(entityNumber, personGenericStrategyService);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doAfterExecute(String entityNumber, IPersonGenericStrategy personGenericStrategyService) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            IPersonGenericRuleService personGenericRuleService = personGenericStrategyService.getPersonGenericRuleService();
            try {
                personGenericRuleService.afterRuleExecute(entityNumber, (IPersonGenericContext<?>)PersonGenericExecuteSaveBatchServiceImpl.this.saveContext);
            }
            catch (Exception ex) {
                LOGGER.error("PersonGenericService ==> SaveExecutor#doAfterExecute error!", (Throwable)ex);
                PersonGenericExecuteSaveBatchServiceImpl.this.context.addExceptionMessage(entityNumber, ex.getMessage());
            }
            finally {
                stopWatch.stop();
                LOGGER.info("PersonGenericService ==> SaveExecutor#doAfterExecute {} time is: {} ms.", (Object)entityNumber, (Object)stopWatch.getTime());
            }
        }

        @Override
        public void afterRollbackExecute(List<String> entityNumberList) {
            this.doSimpleAfterRollbackExecute(entityNumberList);
        }

        private void doSimpleAfterRollbackExecute(List<String> entityNumberList) {
            for (String entityNumber : entityNumberList) {
                IPersonGenericStrategy personGenericStrategyService = PersonGenericExecuteSaveBatchServiceImpl.this.getPersonGenericStrategyService(entityNumber);
                this.doAfterRollbackExecute(entityNumber, personGenericStrategyService);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doAfterRollbackExecute(String entityNumber, IPersonGenericStrategy personGenericStrategyService) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            IPersonGenericRuleService personGenericRuleService = personGenericStrategyService.getPersonGenericRuleService();
            try {
                personGenericRuleService.afterRollbackRuleExecute(entityNumber, (PersonGenericContext<PersonGenericSaveEntity>)PersonGenericExecuteSaveBatchServiceImpl.this.saveContext);
            }
            catch (Exception ex) {
                LOGGER.error("PersonGenericService ==> SaveExecutor#doAfterRollbackExecute error!", (Throwable)ex);
                PersonGenericExecuteSaveBatchServiceImpl.this.context.addExceptionMessage(entityNumber, ex.getMessage());
            }
            finally {
                stopWatch.stop();
                LOGGER.info("PersonGenericService ==> SaveExecutor#doAfterRollbackExecute {} time is: {} ms.", (Object)entityNumber, (Object)stopWatch.getTime());
            }
        }

        @Override
        public void doDestory() {
        }
    }
}

