/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.factory;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hrpi.business.domian.service.generic.coderule.IPersonGenericCodeRule;
import kd.hrmp.hrpi.business.domian.service.impl.generic.coderule.DefaultPersonGenericCodeRule;
import kd.hrmp.hrpi.business.domian.service.impl.generic.coderule.FixedPersonGenericCodeRule;
import kd.hrmp.hrpi.business.domian.service.impl.generic.coderule.HrpiDepempGenericCodeRule;
import kd.hrmp.hrpi.business.domian.service.impl.generic.coderule.HrpiEmpentrelGenericCodeRule;
import kd.hrmp.hrpi.business.domian.service.impl.generic.coderule.HrpiLaborRelRecordGenericCodeRule;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.generic.enums.PersonGenericOperateTypeEnums;

public class PersonGenericCodeRuleFactory
implements IPersonGenericCodeRule {
    private static final Log LOGGER = LogFactory.getLog(PersonGenericCodeRuleFactory.class);
    protected static final int CORE_THREAD = Runtime.getRuntime().availableProcessors();
    protected static final int MAX_THREAD = CORE_THREAD * 10;
    protected static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"PersonGenericCodeRuleFactory-Thread", (int)CORE_THREAD, (int)MAX_THREAD, (String)"hr");
    private static final Map<String, IPersonGenericCodeRule> ENTITY_CODERULE_MAP = new HashMap<String, IPersonGenericCodeRule>(16);
    private static final Map<String, IPersonGenericCodeRule> CODERULE_MAP = new HashMap<String, IPersonGenericCodeRule>(16);
    private IPersonGenericCodeRule personGenericCodeRule;
    boolean useThread;
    private PersonGenericOperateTypeEnums operateTypeEnums;

    private PersonGenericCodeRuleFactory() {
    }

    public static IPersonGenericCodeRule getInstance(IPersonGenericContext<PersonGenericSaveEntity> personGenericContext, String entityNumber) {
        PersonGenericCodeRuleFactory factory = new PersonGenericCodeRuleFactory();
        factory.operateTypeEnums = personGenericContext.getOperateTypeEnums();
        factory.useThread = personGenericContext.isUseThread();
        if (PersonGenericOperateTypeEnums.VALIDATE == factory.operateTypeEnums) {
            factory.personGenericCodeRule = FixedPersonGenericCodeRule.getInstance();
        } else {
            IPersonGenericCodeRule personGenericCodeRule = ENTITY_CODERULE_MAP.get(entityNumber);
            if (HRObjectUtils.isEmpty((Object)personGenericCodeRule)) {
                LOGGER.error("PersonGenericService ==> PersonGenericCodeRuleFactory#getInstance the entityNumber: {} has not coreRule.", (Object)entityNumber);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u201c%s\u201d\u4e0d\u5b58\u5728\u7f16\u7801\u89c4\u5219\u670d\u52a1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PersonGenericCodeRuleFactory_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]), entityNumber));
            }
            factory.personGenericCodeRule = personGenericCodeRule;
        }
        return factory;
    }

    public static IPersonGenericCodeRule getInstance(IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        String caller = ((PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity()).getCaller();
        PersonGenericCodeRuleFactory factory = new PersonGenericCodeRuleFactory();
        factory.operateTypeEnums = personGenericContext.getOperateTypeEnums();
        factory.useThread = personGenericContext.isUseThread();
        factory.personGenericCodeRule = PersonGenericOperateTypeEnums.VALIDATE == factory.operateTypeEnums ? FixedPersonGenericCodeRule.getInstance() : CODERULE_MAP.getOrDefault(caller, DefaultPersonGenericCodeRule.getInstance());
        return factory;
    }

    public static IPersonGenericCodeRule getInstance(IPersonGenericContext<PersonGenericSaveEntity> personGenericContext, IPersonGenericCodeRule personGenericCodeRule) {
        PersonGenericCodeRuleFactory factory = new PersonGenericCodeRuleFactory();
        factory.operateTypeEnums = personGenericContext.getOperateTypeEnums();
        factory.useThread = personGenericContext.isUseThread();
        factory.personGenericCodeRule = PersonGenericOperateTypeEnums.VALIDATE == factory.operateTypeEnums ? FixedPersonGenericCodeRule.getInstance() : personGenericCodeRule;
        return factory;
    }

    @Override
    public void getNumbersAndSet(String entityNumber, DynamicObjectCollection dyColl, String numberFieldName) {
        this.personGenericCodeRule.getNumbersAndSet(entityNumber, dyColl, numberFieldName);
    }

    @Override
    public void getNumbersAndUpdate(String entityNumber, DynamicObjectCollection dyColl, String numberFieldName) {
        if (PersonGenericOperateTypeEnums.VALIDATE == this.operateTypeEnums) {
            LOGGER.info("PersonGenericService ==> PersonGenericCodeRuleFactory#getNumbersAndUpdate {} is validateOnly.", (Object)entityNumber);
            return;
        }
        if (this.useThread) {
            THREAD_POOL.execute(() -> {
                this.personGenericCodeRule.getNumbersAndUpdate(entityNumber, dyColl, numberFieldName);
                LOGGER.info("PersonGenericService ==> PersonGenericCodeRuleFactory#getNumbersAndUpdate {} thread isDone.", (Object)entityNumber);
            }, RequestContext.get());
        } else {
            this.personGenericCodeRule.getNumbersAndUpdate(entityNumber, dyColl, numberFieldName);
            LOGGER.info("PersonGenericService ==> PersonGenericCodeRuleFactory#getNumbersAndUpdate {} isDone.", (Object)entityNumber);
        }
    }

    @Override
    public void getNumbersAndUpdate(String entityNumber, DynamicObjectCollection dyColl, String numberFieldName, Consumer<Map<Long, String>> consumer) {
        if (PersonGenericOperateTypeEnums.VALIDATE == this.operateTypeEnums) {
            LOGGER.info("PersonGenericService ==> PersonGenericCodeRuleFactory#getNumbersAndUpdate {} is validateOnly.", (Object)entityNumber);
            return;
        }
        if (this.useThread) {
            THREAD_POOL.execute(() -> {
                this.personGenericCodeRule.getNumbersAndUpdate(entityNumber, dyColl, numberFieldName);
                LOGGER.info("PersonGenericService ==> PersonGenericCodeRuleFactory#getNumbersAndUpdate {} thread isDone.", (Object)entityNumber, (Object)consumer);
            }, RequestContext.get());
        } else {
            this.personGenericCodeRule.getNumbersAndUpdate(entityNumber, dyColl, numberFieldName);
            LOGGER.info("PersonGenericService ==> PersonGenericCodeRuleFactory#getNumbersAndUpdate {} isDone.", (Object)entityNumber, consumer);
        }
    }

    static {
        ENTITY_CODERULE_MAP.put("hrpi_depemp", HrpiDepempGenericCodeRule.getInstance());
        ENTITY_CODERULE_MAP.put("hrpi_laborrelrecord", HrpiLaborRelRecordGenericCodeRule.getInstance());
        ENTITY_CODERULE_MAP.put("hrpi_empentrel", HrpiEmpentrelGenericCodeRule.getInstance());
        CODERULE_MAP.put("initialize", FixedPersonGenericCodeRule.getInstance());
        CODERULE_MAP.put("hpfs", DefaultPersonGenericCodeRule.getInstance());
    }
}

