/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.factory;

import java.util.List;
import kd.hrmp.hrpi.business.domian.service.generic.dataoperate.IPersonGenericDataOperateService;
import kd.hrmp.hrpi.business.domian.service.generic.execute.IPersonGenericExecuteService;
import kd.hrmp.hrpi.business.domian.service.generic.strategy.IPersonGenericStrategy;
import kd.hrmp.hrpi.business.domian.service.impl.generic.dataoperate.PersonGenericDataOperateDeleteServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.dataoperate.PersonGenericDataOperateDiscardServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.dataoperate.PersonGenericDataOperateReviseServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.dataoperate.PersonGenericDataOperateSaveServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.dataoperate.PersonGenericDataOperateSaveStandardServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.execute.AbstractPersonGenericExecuteService;
import kd.hrmp.hrpi.business.domian.service.impl.generic.execute.PersonGenericExecuteDeleteBatchServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.execute.PersonGenericExecuteDiscardBatchServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.execute.PersonGenericExecuteSaveBatchServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.factory.PersonGenericStrategyFactory;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.context.PersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.IPersonGenericEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericDeleteEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericDiscardEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.generic.enums.PersonGenericOperateTypeEnums;

public class PersonGenericFactory {
    public static IPersonGenericExecuteService createGenericService(IPersonGenericEntity personGenericEntity, PersonGenericOperateTypeEnums operateTypeEnums) {
        return Builder.create(operateTypeEnums).initGenericService(personGenericEntity).initPersonGenericRequestContext(personGenericEntity).initPersonGenericStrategy().initPersonDataOperateService(operateTypeEnums).build();
    }

    static class Builder {
        private static final Long MAX_TOTALDATASIZE = 1000L;
        private AbstractPersonGenericExecuteService personGenericService;
        private final PersonGenericOperateTypeEnums operateTypeEnums;
        private boolean useThread;

        public Builder(PersonGenericOperateTypeEnums operateTypeEnums) {
            this.operateTypeEnums = operateTypeEnums;
        }

        public static Builder create(PersonGenericOperateTypeEnums operateTypeEnums) {
            return new Builder(operateTypeEnums);
        }

        public Builder initGenericService(IPersonGenericEntity personGenericEntity) {
            long totalDataSize = personGenericEntity.getTotalDataSize();
            if (totalDataSize > MAX_TOTALDATASIZE) {
                this.useThread = true;
            }
            switch (this.operateTypeEnums) {
                case SAVEBATCH: 
                case SAVEBATCHSTANDARD: 
                case REVISEVERSIONBATCH: {
                    this.personGenericService = new PersonGenericExecuteSaveBatchServiceImpl(this.useThread);
                    break;
                }
                case VALIDATE: {
                    this.personGenericService = new PersonGenericExecuteSaveBatchServiceImpl(this.useThread, true);
                    break;
                }
                case DELETEBATCH: {
                    this.personGenericService = new PersonGenericExecuteDeleteBatchServiceImpl(this.useThread);
                    break;
                }
                case DISCARDBATCH: {
                    this.personGenericService = new PersonGenericExecuteDiscardBatchServiceImpl(this.useThread);
                    break;
                }
            }
            return this;
        }

        public Builder initPersonGenericRequestContext(IPersonGenericEntity personGenericEntity) {
            if (personGenericEntity instanceof PersonGenericDeleteEntity) {
                PersonGenericContext context = new PersonGenericContext();
                context.init((IPersonGenericEntity)((PersonGenericDeleteEntity)personGenericEntity), this.useThread, this.operateTypeEnums);
                this.personGenericService.setContext((IPersonGenericContext<?>)context);
            } else if (personGenericEntity instanceof PersonGenericDiscardEntity) {
                PersonGenericContext context = new PersonGenericContext();
                context.init((IPersonGenericEntity)((PersonGenericDiscardEntity)personGenericEntity), this.useThread, this.operateTypeEnums);
                this.personGenericService.setContext((IPersonGenericContext<?>)context);
            } else {
                PersonGenericContext context = new PersonGenericContext();
                context.init((IPersonGenericEntity)((PersonGenericSaveEntity)personGenericEntity), this.useThread, this.operateTypeEnums);
                this.personGenericService.setContext((IPersonGenericContext<?>)context);
            }
            return this;
        }

        public Builder initPersonGenericStrategy() {
            List entityNumberList = this.personGenericService.getContext().getPersonGenericEntity().getEntityNumberList();
            for (String entityNumber : entityNumberList) {
                IPersonGenericStrategy personGenericStrategy = PersonGenericStrategyFactory.getInstance().getPersonGenericStrategy(entityNumber, this.operateTypeEnums);
                this.personGenericService.putPersonGenericStrategyService(entityNumber, personGenericStrategy);
            }
            return this;
        }

        public Builder initPersonDataOperateService(PersonGenericOperateTypeEnums operateTypeEnums) {
            IPersonGenericDataOperateService personGenericDataOperateService = null;
            switch (operateTypeEnums) {
                case SAVEBATCH: {
                    personGenericDataOperateService = PersonGenericDataOperateSaveServiceImpl.getInstance();
                    break;
                }
                case DELETEBATCH: {
                    personGenericDataOperateService = PersonGenericDataOperateDeleteServiceImpl.getInstance();
                    break;
                }
                case SAVEBATCHSTANDARD: {
                    personGenericDataOperateService = PersonGenericDataOperateSaveStandardServiceImpl.getInstance();
                    break;
                }
                case DISCARDBATCH: {
                    personGenericDataOperateService = PersonGenericDataOperateDiscardServiceImpl.getInstance();
                    break;
                }
                case REVISEVERSIONBATCH: {
                    personGenericDataOperateService = PersonGenericDataOperateReviseServiceImpl.getInstance();
                    break;
                }
            }
            this.personGenericService.setPersonGenericDataOperateService(personGenericDataOperateService);
            return this;
        }

        public IPersonGenericExecuteService build() {
            return this.personGenericService;
        }
    }
}

