/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.rule;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.service.generic.rule.IPersonGenericRuleService;
import kd.hrmp.hrpi.business.domian.service.generic.strategy.IPersonGenericStrategy;
import kd.hrmp.hrpi.business.domian.service.impl.generic.factory.PersonGenericStrategyFactory;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.business.tools.CustomRuleUtil;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.context.PersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericRedundancyRelate;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericRelateDataEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.generic.enums.PersonGenericMergeRelateDataTypeEnums;
import kd.hrmp.hrpi.common.generic.enums.PersonGenericOperateTypeEnums;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;
import kd.hrmp.hrpi.common.util.PersonGenericRedundancyUtil;
import kd.hrmp.hrpi.common.util.PersonGenericUtil;
import org.apache.commons.collections.MapUtils;

public abstract class AbstractPersonGenericSaveRuleService
implements IPersonGenericRuleService {
    private static final Log LOGGER = LogFactory.getLog(AbstractPersonGenericSaveRuleService.class);
    protected static final String DEFAULT_BILLNO = "DEFAULT_BILLNO";
    private final Map<String, HRBaseServiceHelper> serviceHelperMap = new ConcurrentHashMap<String, HRBaseServiceHelper>(16);

    @Override
    public void initRuleExecute(String entityNumber, IPersonGenericContext<?> personGenericContext) {
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection dyColl = personGenericEntity.getHisDyns(entityNumber);
        this.initRuleExecute(entityNumber, dyColl, personGenericContext);
    }

    public abstract void initRuleExecute(String var1, DynamicObjectCollection var2, IPersonGenericContext<PersonGenericSaveEntity> var3);

    @Override
    public void filterRuleExecute(String entityNumber, IPersonGenericContext<?> personGenericContext) {
        Set errorIds = personGenericContext.getErrorIds(entityNumber);
        String errorKey = personGenericContext.getErrorKey(entityNumber);
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection dyColl = personGenericEntity.getHisDyns(entityNumber);
        dyColl.removeIf(dy -> errorIds.contains(dy.get(errorKey)));
    }

    @Override
    public void specialRuleExecute(String entityNumber, IPersonGenericContext<?> personGenericContext) {
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection dyColl = personGenericEntity.getHisDyns(entityNumber);
        if (dyColl.size() == 0) {
            LOGGER.info("PersonGenericService ==> AbstractPersonGenericSaveRuleService#specialRuleExecute entityNumber: {} data is null.", (Object)entityNumber);
            return;
        }
        this.customRuleExecute(entityNumber, dyColl, personGenericContext);
        this.commonRuleExecute(entityNumber, dyColl, personGenericContext);
    }

    @Override
    public void specialExceptionRuleExecute(String entityNumber, IPersonGenericContext<?> personGenericContext) {
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection dyColl = personGenericEntity.getHisDyns(entityNumber);
        if (dyColl.size() == 0) {
            LOGGER.info("PersonGenericService ==> AbstractPersonGenericSaveRuleService#specialExceptionRuleExecute entityNumber: {} data is null.", (Object)entityNumber);
            return;
        }
        this.specialExceptionRuleExecute(entityNumber, dyColl, personGenericContext);
    }

    @Override
    public void afterRuleExecute(String entityNumber, IPersonGenericContext<?> personGenericContext) {
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection dyColl = personGenericEntity.getHisDyns(entityNumber);
        if (dyColl.size() == 0) {
            LOGGER.info("PersonGenericService ==> AbstractPersonGenericSaveRuleService#afterRuleExecute entityNumber: {} data is null.", (Object)entityNumber);
            return;
        }
        this.afterRuleExecute(entityNumber, dyColl, personGenericContext);
    }

    @Override
    public void afterRollbackRuleExecute(String entityNumber, PersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection dyColl = personGenericEntity.getHisDyns(entityNumber);
        if (dyColl.size() == 0) {
            LOGGER.info("PersonGenericService ==> AbstractPersonGenericSaveRuleService#afterRollbackRuleExecute entityNumber: {} data is null.", (Object)entityNumber);
            return;
        }
        this.afterRollbackRuleExecute(entityNumber, dyColl, (IPersonGenericContext<PersonGenericSaveEntity>)personGenericContext);
    }

    protected void commonRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        for (DynamicObject dynamicObject : dyColl) {
            DynamicObjectType dynamicObjectType = dynamicObject.getDynamicObjectType();
            LOGGER.info("PersonGenericService ==> AbstractPersonGenericSaveRuleService#commonRuleExecute entityNumber: {}, dynamicObjectType: {}", (Object)entityNumber, (Object)dynamicObjectType);
            DataEntityPropertyCollection properties = null == dynamicObjectType ? HRPIDynamicObjectUtil.getProperties((DynamicObjectCollection)dyColl) : dynamicObjectType.getProperties();
            this.sysenddateRule(dynamicObject, properties);
        }
        List sourceRedundancyRelates = PersonGenericRedundancyUtil.getSourceRedundancyRelateMap((String)entityNumber);
        if (!CollectionUtils.isEmpty((Collection)sourceRedundancyRelates)) {
            this.commonRedundancyRuleExecute(entityNumber, dyColl, sourceRedundancyRelates, personGenericContext);
        }
    }

    protected void commonSetRedundancyRuleExecute(String entityNumber, DynamicObjectCollection dyColl, List<PersonGenericRedundancyRelate> redundancyRelates, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        Map<String, List<PersonGenericRedundancyRelate>> redundancyMap = redundancyRelates.stream().collect(Collectors.groupingBy(PersonGenericRedundancyRelate::getSourceEntityNumber));
        for (Map.Entry<String, List<PersonGenericRedundancyRelate>> entry : redundancyMap.entrySet()) {
            List<PersonGenericRedundancyRelate> relates = entry.getValue();
            PersonGenericRedundancyRelate commonRelate = relates.get(0);
            Map<Long, List<DynamicObject>> relateMap = this.convertRedundancyMap(dyColl, commonRelate.getRedundancyRelateField());
            DynamicObjectCollection contextSource = ((PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity()).getHisDyns(commonRelate.getSourceEntityNumber());
            if (!CollectionUtils.isEmpty((Collection)contextSource)) {
                Set contextExitIds = contextSource.stream().map(dy -> {
                    if ("boid".equals(commonRelate.getSourceRelateField())) {
                        return dy.getLong("boid") == 0L ? dy.getLong("id") : dy.getLong("boid");
                    }
                    return HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)commonRelate.getSourceRelateField());
                }).collect(Collectors.toSet());
                relateMap.keySet().removeIf(contextExitIds::contains);
            }
            this.createAndaddRedundancyRelateDataEntity(relates, relateMap);
        }
    }

    protected void createAndaddRedundancyRelateDataEntity(List<PersonGenericRedundancyRelate> relates, Map<Long, List<DynamicObject>> relateMap) {
        Set<Long> needCheckDbIds = relateMap.keySet();
        if (CollectionUtils.isEmpty(needCheckDbIds)) {
            return;
        }
        PersonGenericRedundancyRelate commonRelate = relates.get(0);
        HRBaseServiceHelper hrBaseServiceHelper = this.getHRBaseServiceHelper(commonRelate.getSourceEntityNumber());
        DynamicObject[] dbDys = hrBaseServiceHelper.loadDynamicObjectArray(this.getQueryDbQFilter(commonRelate.getSourceRelateField(), needCheckDbIds));
        if (null == dbDys || dbDys.length == 0) {
            return;
        }
        for (DynamicObject dy : dbDys) {
            long relateId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)commonRelate.getSourceRelateField());
            List<DynamicObject> updateDyList = relateMap.get(relateId);
            if (CollectionUtils.isEmpty(updateDyList)) continue;
            updateDyList.forEach(updateRelateDy -> this.setRedundancyField(dy, (DynamicObject)updateRelateDy, relates));
        }
    }

    private void setRedundancyField(DynamicObject dy, DynamicObject updateRelateDy, List<PersonGenericRedundancyRelate> relates) {
        for (PersonGenericRedundancyRelate relate : relates) {
            if (!dy.getDynamicObjectType().getProperties().containsKey((Object)relate.getSourceField())) continue;
            String redundancyField = relate.getRedundancyField();
            updateRelateDy.set(redundancyField, dy.get(relate.getSourceField()));
        }
    }

    protected void commonRedundancyRuleExecute(String entityNumber, DynamicObjectCollection dyColl, List<PersonGenericRedundancyRelate> sourceRedundancyRelates, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        for (PersonGenericRedundancyRelate relate : sourceRedundancyRelates) {
            Map<Long, Object> sourceRedundancyMap;
            String caller = ((PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity()).getCaller();
            if (HRStringUtils.equals((String)caller, (String)"initialize") && HRStringUtils.equals((String)relate.getSourceEntityNumber(), (String)"hrpi_empentrel") && HRStringUtils.equals((String)relate.getRedundancyEntityNumber(), (String)"hrpi_person") && HRStringUtils.equals((String)relate.getSourceField(), (String)"empnumber") && HRStringUtils.equals((String)relate.getRedundancyField(), (String)"number") || CollectionUtils.isEmpty(sourceRedundancyMap = this.convertSourceRedundancyMap(dyColl, relate))) continue;
            IPersonGenericStrategy personGenericStrategy = PersonGenericStrategyFactory.getInstance().getPersonGenericStrategy(relate.getRedundancyEntityNumber(), PersonGenericOperateTypeEnums.SAVEBATCH);
            PersonGenericRelateDataEntity personGenericRelateDataEntity = ((AbstractPersonGenericSaveRuleService)personGenericStrategy.getPersonGenericRuleService()).commonBuildRelateDataEntity(relate, sourceRedundancyMap, personGenericContext);
            ((PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity()).addRelateDataEntity(entityNumber, personGenericRelateDataEntity);
        }
    }

    protected PersonGenericRelateDataEntity commonBuildRelateDataEntity(PersonGenericRedundancyRelate relate, Map<Long, Object> redundancyMap, IPersonGenericContext<?> personGenericContext) {
        PersonGenericRelateDataEntity relateDataEntity = new PersonGenericRelateDataEntity(relate.getRedundancyEntityNumber());
        String redundancyField = relate.getRedundancyField();
        personGenericContext.addRedundancyField(relate.getRedundancyEntityNumber(), redundancyField);
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection dyCollData = personGenericEntity.getHisDyns(relate.getRedundancyEntityNumber());
        DynamicObjectCollection dbDyColl = null;
        if (PersonGenericOperateTypeEnums.REVISEVERSIONBATCH == personGenericContext.getOperateTypeEnums()) {
            DynamicObjectCollection sourceEntityHisDyns = personGenericEntity.getHisDyns(relate.getSourceEntityNumber());
            MainEntityType redundancyEntityType = EntityMetadataCache.getDataEntityType((String)relate.getRedundancyEntityNumber());
            if (redundancyEntityType.getProperties().containsKey((Object)"bsed")) {
                DynamicObjectCollection dbDyns = this.getHRBaseServiceHelper(relate.getRedundancyEntityNumber()).queryOriginalCollection(this.getQueryHisFields(relate), this.getQueryDbHisQFilter(relate.getRedundancyRelateField(), redundancyMap.keySet()));
                for (DynamicObject dbDyn : dbDyns) {
                    Date dbDynBsed = dbDyn.getDate("bsed");
                    Date dbDynBsled = dbDyn.getDate("bsled");
                    for (DynamicObject sourceEntityHisDyn : sourceEntityHisDyns) {
                        if (!"id".equals(relate.getRedundancyRelateField()) && HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dbDyn, (String)relate.getRedundancyRelateField()) != HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)sourceEntityHisDyn, (String)relate.getSourceRelateField())) continue;
                        Date sourceBsed = sourceEntityHisDyn.getDate("bsed");
                        Date sourceBsled = sourceEntityHisDyn.getDate("bsled");
                        if (sourceBsed.compareTo(dbDynBsed) != 0 || sourceBsled.compareTo(dbDynBsled) != 0) continue;
                        if (dbDyColl == null) {
                            dbDyColl = new DynamicObjectCollection();
                        }
                        dbDyColl.add((Object)dbDyn);
                    }
                }
            } else {
                dbDyColl = this.getHRBaseServiceHelper(relate.getRedundancyEntityNumber()).queryOriginalCollection(this.getQueryFields(relate), this.getQueryDbQFilter(relate.getRedundancyRelateField(), redundancyMap.keySet()));
            }
        } else {
            dbDyColl = this.getHRBaseServiceHelper(relate.getRedundancyEntityNumber()).queryOriginalCollection(this.getQueryFields(relate), this.getQueryDbQFilter(relate.getRedundancyRelateField(), redundancyMap.keySet()));
        }
        if (!CollectionUtils.isEmpty((Collection)dyCollData)) {
            DynamicObjectCollection updateHisDyColl = this.updateRelateRuleExecute(relate.getRedundancyEntityNumber(), redundancyMap, dyCollData, redundancyField, relate.getRedundancyRelateField());
            relateDataEntity.setRelateHisDyMap(updateHisDyColl);
        }
        if (!CollectionUtils.isEmpty((Collection)dbDyColl)) {
            DynamicObjectCollection updateDyColl = this.updateRelateRuleExecute(relate.getRedundancyEntityNumber(), redundancyMap, dbDyColl, redundancyField, relate.getRedundancyRelateField());
            relateDataEntity.setRelateDbDyMap(updateDyColl);
        }
        return relateDataEntity;
    }

    protected void wrapRemoveRepeatBo(DynamicObjectCollection dbCollection, DynamicObjectCollection contextCollection) {
        if (!CollectionUtils.isEmpty((Collection)contextCollection)) {
            HashSet existBoIds = Sets.newHashSetWithExpectedSize((int)contextCollection.size());
            contextCollection.forEach(item -> {
                Long boid = (Long)item.get("boid");
                if (boid != 0L) {
                    existBoIds.add(boid);
                }
            });
            List existDyn = dbCollection.stream().filter(item -> existBoIds.contains(item.getLong("boid"))).collect(Collectors.toList());
            dbCollection.removeAll(existDyn);
        }
    }

    protected String getQueryFields(PersonGenericRedundancyRelate relate) {
        if ("id".equals(relate.getRedundancyRelateField())) {
            return String.format("%s,%s,boid", relate.getRedundancyRelateField(), relate.getRedundancyField());
        }
        return String.format("%s, %s,%s,boid", "id", relate.getRedundancyRelateField(), relate.getRedundancyField());
    }

    protected QFilter[] getQueryDbQFilter(String relateField, Set<Long> relateIds) {
        QFilter qFilter = new QFilter(relateField, "in", relateIds).and(QFilterUtil.getDataStatusFilter()).and(QFilterUtil.getCurrentQf());
        return qFilter.toArray();
    }

    protected String getQueryHisFields(PersonGenericRedundancyRelate relate) {
        if ("id".equals(relate.getRedundancyRelateField())) {
            return String.format("%s,%s,boid,bsed,bsled", relate.getRedundancyRelateField(), relate.getRedundancyField());
        }
        return String.format("%s, %s,%s,boid,bsed,bsled", "id", relate.getRedundancyRelateField(), relate.getRedundancyField());
    }

    protected QFilter[] getQueryDbHisQFilter(String relateField, Set<Long> relateIds) {
        QFilter qFilter = new QFilter(relateField, "in", relateIds);
        if ("id".equals(relateField)) {
            qFilter.or(new QFilter("boid", "in", relateIds));
        }
        qFilter.and(QFilterUtil.getHisDataStatusQf()).and(QFilterUtil.getHisVersionQf());
        return qFilter.toArray();
    }

    protected Map<Long, Object> convertSourceRedundancyMap(DynamicObjectCollection dyColl, PersonGenericRedundancyRelate relate) {
        String sourceRelateField = relate.getSourceRelateField();
        String sourceRedundancyField = relate.getSourceField();
        DataEntityPropertyCollection properties = HRPIDynamicObjectUtil.getProperties((DynamicObjectCollection)dyColl);
        if (!properties.containsKey((Object)sourceRedundancyField) || !properties.containsKey((Object)sourceRelateField)) {
            return MapUtils.EMPTY_MAP;
        }
        boolean containKeyIslatestrecord = properties.containsKey((Object)"islatestrecord");
        List collect = containKeyIslatestrecord ? dyColl.stream().sorted((dy1, dy2) -> {
            int islatestrecord1 = CustomRuleUtil.convertSwitch2Int(dy1.get("islatestrecord"));
            int islatestrecord2 = CustomRuleUtil.convertSwitch2Int(dy2.get("islatestrecord"));
            return islatestrecord1 - islatestrecord2;
        }).collect(Collectors.toList()) : dyColl.stream().collect(Collectors.toList());
        Stream dynamicObjectStream = properties.containsKey((Object)"businessstatus") ? collect.stream().filter(dy -> "1".equals(dy.getString("businessstatus"))) : collect.stream();
        Map redundancyMap = dynamicObjectStream.collect(HashMap::new, (map, dy) -> {
            String sourceId = "boid".equals(sourceRelateField) && (Long)dy.get(sourceRelateField) == 0L ? "id" : sourceRelateField;
            map.put(HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)sourceId), dy.get(sourceRedundancyField));
        }, HashMap::putAll);
        return redundancyMap;
    }

    private Map<Long, List<DynamicObject>> convertRedundancyMap(DynamicObjectCollection dyColl, String relateField) {
        DataEntityPropertyCollection properties = HRPIDynamicObjectUtil.getProperties((DynamicObjectCollection)dyColl);
        if (!properties.containsKey((Object)relateField)) {
            return MapUtils.EMPTY_MAP;
        }
        Map<Long, List<DynamicObject>> redundancyMap = "id".equals(relateField) && properties.containsKey((Object)"boid") ? dyColl.stream().collect(Collectors.groupingBy(dy -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)(dy.getLong("boid") == 0L ? relateField : "boid")))) : dyColl.stream().collect(Collectors.groupingBy(dy -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)relateField)));
        return redundancyMap;
    }

    protected void sysenddateRule(DynamicObject dynamicObject, DataEntityPropertyCollection properties) {
        if (properties.containsKey((Object)"startdate") && properties.containsKey((Object)"enddate") && properties.containsKey((Object)"sysenddate")) {
            Date enddate = dynamicObject.getDate("enddate");
            if (enddate.compareTo(HRDateTimeUtils.getSysMaxDate()) >= 0) {
                dynamicObject.set("sysenddate", (Object)enddate);
            } else {
                Date sysenddate;
                if (dynamicObject.getDate("sysenddate") == null || PersonGenericUtil.dateDiff((Date)dynamicObject.getDate("enddate"), (Date)dynamicObject.getDate("startdate")) != 0L || PersonGenericUtil.dateDiff((Date)dynamicObject.getDate("sysenddate"), (Date)dynamicObject.getDate("startdate")) != 0L) {
                    dynamicObject.set("sysenddate", (Object)HRDateTimeUtils.addDay((Date)enddate, (long)1L));
                }
                if ((sysenddate = dynamicObject.getDate("sysenddate")).compareTo(HRDateTimeUtils.getSysMaxDate()) == 0) {
                    dynamicObject.set("enddate", (Object)sysenddate);
                }
            }
        }
    }

    protected abstract void customRuleExecute(String var1, DynamicObjectCollection var2, IPersonGenericContext<PersonGenericSaveEntity> var3);

    protected abstract void specialExceptionRuleExecute(String var1, DynamicObjectCollection var2, IPersonGenericContext<PersonGenericSaveEntity> var3);

    protected abstract void afterRuleExecute(String var1, DynamicObjectCollection var2, IPersonGenericContext<PersonGenericSaveEntity> var3);

    protected abstract void afterRollbackRuleExecute(String var1, DynamicObjectCollection var2, IPersonGenericContext<PersonGenericSaveEntity> var3);

    public <T> void mergeRelateData(String entityNumber, List<T> relateDataList, DynamicObjectCollection dyColl, PersonGenericMergeRelateDataTypeEnums relateDataTypeEnums, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        Set redundancyFields = personGenericContext.getRedundancyFields(entityNumber);
        switch (relateDataTypeEnums) {
            case CONTEXT: {
                this.mergeContextRelateData(relateDataList, dyColl, redundancyFields);
                break;
            }
            case UPDATEDB: {
                this.mergeDbRelateData(entityNumber, relateDataList, dyColl, redundancyFields, personGenericContext);
                break;
            }
            case CONTEXTREMOVE: {
                this.mergeContextRelateRemoveData(relateDataList, dyColl);
                break;
            }
        }
    }

    protected DynamicObjectCollection updateRelateRuleExecute(String entityNumber, Map<Long, Object> personRelateMap, DynamicObjectCollection dyCollData, String redundancyField, String relateField) {
        DynamicObjectCollection updateDyColl = new DynamicObjectCollection();
        for (DynamicObject dy : dyCollData) {
            long relateId;
            DataEntityPropertyCollection properties;
            String tmpRelateField = relateField;
            if (dy.getDynamicObjectType().getProperties().containsKey((Object)"businessstatus") && !"1".equals(dy.getString("businessstatus"))) {
                personRelateMap.remove(HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)tmpRelateField));
                continue;
            }
            if ("id".equals(tmpRelateField) && dy.getDynamicObjectType().getProperties().containsKey((Object)"boid") && (properties = dy.getDynamicObjectType().getProperties()).containsKey((Object)"boid")) {
                String string = tmpRelateField = dy.getLong("boid") == 0L ? tmpRelateField : "boid";
            }
            if (!personRelateMap.containsKey(relateId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)tmpRelateField))) continue;
            DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)entityNumber, Arrays.asList("id", redundancyField));
            DynamicObject updateRelateDy = (DynamicObject)subDataEntityType.createInstance();
            HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)updateRelateDy);
            if (!HRObjectUtils.isEmpty((Object)this.getEntityBillNoField(updateRelateDy)) && !redundancyField.equals(this.getEntityBillNoField(updateRelateDy))) {
                updateRelateDy.set(this.getEntityBillNoField(updateRelateDy), (Object)DEFAULT_BILLNO);
            }
            updateRelateDy.set("id", (Object)dy.getLong("id"));
            updateRelateDy.set(redundancyField, personRelateMap.get(relateId));
            updateDyColl.add((Object)updateRelateDy);
        }
        return updateDyColl;
    }

    protected void mergeContextRelateData(List<Map<Long, DynamicObject>> relateDataList, DynamicObjectCollection dyColl, Set<String> redundancyFields) {
        Map<Long, DynamicObject> hisDynsIndexMap = this.getIndexHisDynsMap(dyColl);
        this.mergeRelateData(relateDataList, hisDynsIndexMap, redundancyFields);
    }

    protected void mergeRelateData(List<Map<Long, DynamicObject>> relateDataList, Map<Long, DynamicObject> targetDyMap) {
        for (Map<Long, DynamicObject> relateDataMap : relateDataList) {
            for (Map.Entry<Long, DynamicObject> relateDataEntry : relateDataMap.entrySet()) {
                Long pkId = relateDataEntry.getKey();
                DynamicObject targetDy = targetDyMap.get(pkId);
                if (HRObjectUtils.isEmpty((Object)targetDy)) continue;
                DynamicObject relateDy = relateDataEntry.getValue();
                this.mergeRelateDataField(relateDy, targetDy);
            }
        }
    }

    protected void mergeRelateDataField(DynamicObject relateData, DynamicObject targetData) {
        DataEntityPropertyCollection relateProperties = relateData.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection targetProperties = targetData.getDynamicObjectType().getProperties();
        for (IDataEntityProperty targetProperty : targetProperties) {
            String fieldName = targetProperty.getName();
            if (!relateProperties.containsKey((Object)fieldName)) continue;
            targetData.set(fieldName, relateData.get(fieldName));
        }
    }

    protected void mergeRelateData(List<Map<Long, DynamicObject>> relateDataList, Map<Long, DynamicObject> targetDyMap, Set<String> redundancyFields) {
        for (Map<Long, DynamicObject> relateDataMap : relateDataList) {
            for (Map.Entry<Long, DynamicObject> relateDataEntry : relateDataMap.entrySet()) {
                Long pkId = relateDataEntry.getKey();
                DynamicObject targetDy = targetDyMap.get(pkId);
                if (HRObjectUtils.isEmpty((Object)targetDy)) continue;
                DynamicObject relateDy = relateDataEntry.getValue();
                this.mergeRelateDataField(relateDy, targetDy, redundancyFields);
            }
        }
    }

    protected void mergeRelateDataField(DynamicObject relateData, DynamicObject targetData, Set<String> redundancyFields) {
        if (!CollectionUtils.isEmpty(redundancyFields)) {
            DataEntityPropertyCollection properties = relateData.getDynamicObjectType().getProperties();
            for (String redundancyField : redundancyFields) {
                this.mergeRelateDataValue(relateData, targetData, properties, redundancyField);
            }
        }
    }

    protected void mergeRelateDataValue(DynamicObject relateData, DynamicObject targetData, DataEntityPropertyCollection relateProperties, String fieldName) {
        if (!(!relateProperties.containsKey((Object)fieldName) || fieldName.equals(this.getEntityBillNoField(relateData)) && DEFAULT_BILLNO.equals(this.getEntityBillNoValue(relateData)))) {
            targetData.set(fieldName, relateData.get(fieldName));
        }
    }

    protected String getEntityBillNoField(DynamicObject dy) {
        return this.getEntityBillNoField(dy.getDynamicObjectType());
    }

    protected String getEntityBillNoField(DynamicObjectType dt) {
        if (dt instanceof BillEntityType) {
            return ((BillEntityType)dt).getBillNo();
        }
        return null;
    }

    protected String getEntityBillNoValue(DynamicObject dy) {
        String billNoField = this.getEntityBillNoField(dy);
        if (null != billNoField) {
            return dy.getString(billNoField);
        }
        return null;
    }

    protected void mergeDbRelateData(String entityNumber, List<Map<Long, DynamicObject>> relateDataList, DynamicObjectCollection dyColl, Set<String> redundancyFields, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        DynamicObjectCollection relateDbData = this.createRelateDbData(entityNumber, relateDataList, redundancyFields, personGenericContext);
        this.wrapRemoveRepeatBo(relateDbData, dyColl);
        dyColl.addAll((Collection)relateDbData);
    }

    protected DynamicObjectCollection createRelateDbData(String entityNumber, List<Map<Long, DynamicObject>> relateDbDataList, Set<String> redundancyFields, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        HRBaseServiceHelper serviceHelper = this.getHRBaseServiceHelper(entityNumber);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        Object[] pkIdArr = relateDbDataList.stream().map(Map::keySet).flatMap(Collection::stream).distinct().toArray();
        DynamicObject[] dbDyArr = serviceHelper.loadDynamicObjectArray(pkIdArr);
        Map<Long, DynamicObject> dbDyMap = Arrays.stream(dbDyArr).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        if (CollectionUtils.isEmpty(dbDyMap)) {
            return dynamicObjectCollection;
        }
        if (PersonGenericOperateTypeEnums.SAVEBATCHSTANDARD == personGenericContext.getOperateTypeEnums()) {
            this.mergeRelateData(relateDbDataList, dbDyMap);
            dynamicObjectCollection.addAll(dbDyMap.values());
        } else if (PersonGenericOperateTypeEnums.REVISEVERSIONBATCH == personGenericContext.getOperateTypeEnums()) {
            this.mergeRelateData(relateDbDataList, dbDyMap, redundancyFields);
            dynamicObjectCollection.addAll(dbDyMap.values());
        } else {
            this.mergeRelateData(relateDbDataList, dbDyMap, redundancyFields);
            for (DynamicObject dbDy : dbDyArr) {
                DynamicObject updateDbDy = serviceHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)dbDy, (DynamicObject)updateDbDy);
                dynamicObjectCollection.add((Object)updateDbDy);
            }
        }
        return dynamicObjectCollection;
    }

    protected final HRBaseServiceHelper getHRBaseServiceHelper(String entityNumber) {
        try {
            HRBaseServiceHelper serviceHelper = this.serviceHelperMap.get(entityNumber);
            if (null == serviceHelper) {
                serviceHelper = new HRBaseServiceHelper(entityNumber);
                this.serviceHelperMap.put(entityNumber, serviceHelper);
            }
            return serviceHelper;
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u5173\u8054\u6570\u636e\u89c4\u5219\u8f6c\u6362\u5f02\u5e38\u3002", (String)"AbstractPersonGenericSaveRuleService_2", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
    }

    private void mergeContextRelateRemoveData(List<Set<Long>> relateDataList, DynamicObjectCollection dyColl) {
        Set removeIdSet = relateDataList.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Iterator iterator = dyColl.iterator();
        while (iterator.hasNext()) {
            long id = ((DynamicObject)iterator.next()).getLong("id");
            if (!removeIdSet.contains(id)) continue;
            iterator.remove();
        }
    }

    protected Map<Long, DynamicObject> getIndexHisDynsMap(DynamicObjectCollection hisDyns) {
        return Objects.isNull(hisDyns) ? new HashMap<Long, DynamicObject>() : hisDyns.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
    }
}

