/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.service.impl.generic.factory.PersonGenericCodeRuleFactory;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.HrpiEmpposorgrelGenericSaveRuleServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.PersonGenericSaveRuleTimeService;
import kd.hrmp.hrpi.business.helper.CodeRuleNumberHelper;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.HRPIValueConstants;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericRelateDataEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.generic.enums.PersonGenericOperateTypeEnums;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;

public class HrpiDepempGenericSaveRuleServiceImpl
extends PersonGenericSaveRuleTimeService {
    private static final Log LOGGER = LogFactory.getLog(HrpiDepempGenericSaveRuleServiceImpl.class);
    private static final HRBaseServiceHelper DEPEMP_SERVICE_HELPER = new HRBaseServiceHelper("hrpi_depemp");

    public static HrpiDepempGenericSaveRuleServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void initRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        PersonGenericCodeRuleFactory.getInstance(personGenericContext, entityNumber).getNumbersAndSet(entityNumber, dyColl, "number");
        for (DynamicObject dynamicObject : dyColl) {
            this.initPosition(dynamicObject);
            this.initOtValueRuleExecute(dynamicObject);
        }
    }

    private void initPosition(DynamicObject dynamicObject) {
        long positionId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"position");
        if (positionId == 0L) {
            dynamicObject.set("position", (Object)1L);
        }
    }

    private void initOtValueRuleExecute(DynamicObject dynamicObject) {
        long adminorgId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"adminorg");
        long positionId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"position");
        long orgteamId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"orgteam");
        long dutyworkrolesId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"dutyworkroles");
        if (adminorgId > 0L) {
            dynamicObject.set("orgteam", (Object)adminorgId);
            dynamicObject.set("otclassify", (Object)HRPIValueConstants.OTCLASSIFY_1010);
        }
        if (positionId != 0L) {
            dynamicObject.set("dutyworkroles", (Object)positionId);
        }
    }

    @Override
    protected void customRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        PersonGenericOperateTypeEnums operateTypeEnums = personGenericContext.getOperateTypeEnums();
        if (PersonGenericOperateTypeEnums.VALIDATE == operateTypeEnums || CollectionUtils.isEmpty((Collection)dyColl)) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)dyColl)) {
            LOGGER.info("customRuleExecuteEmptyDys");
            return;
        }
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        if (!"initialize".equals(personGenericEntity.getCaller())) {
            this.makeAssignNoAndSerialNo(entityNumber, dyColl, personGenericContext);
        }
    }

    private void makeAssignNoAndSerialNo(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        Map<Long, String> numberByDepEmp = this.setUpEmployIdAndNumberRel(dyColl, personGenericContext);
        this.generateNumberAndSerialNo(entityNumber, dyColl, numberByDepEmp);
        this.setNumberToEmpPos(dyColl, personGenericContext, entityNumber);
    }

    public void generateNumberAndSerialNo(String entityNumber, DynamicObjectCollection dyColl, Map<Long, String> numberByDepEmp) {
        Map<Long, List<DynamicObject>> serialMap = CodeRuleNumberHelper.getInstance().setAssignNoMapAndSerial(dyColl, numberByDepEmp);
        if (!HRMapUtils.isEmpty(serialMap)) {
            ArrayList<DynamicObject> serialList = new ArrayList<DynamicObject>(10);
            for (Map.Entry<Long, List<DynamicObject>> eveDys : serialMap.entrySet()) {
                List<DynamicObject> tmpDyList = eveDys.getValue();
                serialList.addAll(tmpDyList);
            }
            List numbers = CodeRuleServiceHelper.getNumbers((String)entityNumber, serialList);
            if (!CollectionUtils.isEmpty((Collection)numbers)) {
                Map<Long, DynamicObject> contextMap = dyColl.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
                for (int i = 0; i < numbers.size(); ++i) {
                    DynamicObject dy2 = (DynamicObject)serialList.get(i);
                    String codeRuleValue = (String)numbers.get(i);
                    DynamicObject conDy = contextMap.get(dy2.getLong("id"));
                    if (conDy == null) continue;
                    conDy.set("number", (Object)codeRuleValue);
                    String serial = codeRuleValue.substring(codeRuleValue.lastIndexOf("-") + 1);
                    conDy.set("serialno", (Object)serial);
                }
            }
        }
    }

    private void setNumberToEmpPos(DynamicObjectCollection totalDys, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext, String entityNumber) {
        HrpiEmpposorgrelGenericSaveRuleServiceImpl empposorgrelGenericSaveRuleService = HrpiEmpposorgrelGenericSaveRuleServiceImpl.getInstance();
        PersonGenericRelateDataEntity personGenericRelateDataEntity = empposorgrelGenericSaveRuleService.updateNumber(personGenericContext, totalDys, "number", "1");
        if (!personGenericRelateDataEntity.isEmpty()) {
            ((PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity()).addRelateDataEntity(entityNumber, personGenericRelateDataEntity);
        }
    }

    private Map<Long, String> setUpEmployIdAndNumberRel(DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection hisDyns = personGenericEntity.getHisDyns("hrpi_employee");
        HashMap<Long, String> empMap = new HashMap<Long, String>(16);
        if (!CollectionUtils.isEmpty((Collection)hisDyns)) {
            for (DynamicObject hisDy : hisDyns) {
                long boId = hisDy.getLong("boid");
                if (boId == 0L) {
                    boId = hisDy.getLong("id");
                }
                empMap.put(boId, hisDy.getString("empnumber"));
            }
        }
        CodeRuleNumberHelper.getInstance().getNumberByDepEmp(dyColl, empMap);
        return empMap;
    }

    public Map<Long, Boolean> getQuitInfoMap(DynamicObjectCollection dyColl) {
        Map<Long, List<DynamicObject>> employDyMap = dyColl.stream().collect(Collectors.groupingBy(dy -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"employee")));
        HashMap<Long, Boolean> quitMap = new HashMap<Long, Boolean>(16);
        for (Map.Entry<Long, List<DynamicObject>> eveDys : employDyMap.entrySet()) {
            List<DynamicObject> depDys = eveDys.getValue();
            Long employId = eveDys.getKey();
            List loseStatus = depDys.stream().filter(dy -> "2".equals(dy.getString("businessstatus"))).map(dy -> dy.getString("businessstatus")).collect(Collectors.toList());
            quitMap.put(employId, !CollectionUtils.isEmpty(loseStatus) && loseStatus.size() == depDys.size());
        }
        return quitMap;
    }

    @Override
    protected void afterRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        if (!"initialize".equals(personGenericEntity.getCaller())) {
            PersonGenericCodeRuleFactory.getInstance(personGenericContext, entityNumber).getNumbersAndUpdate(entityNumber, dyColl, "number");
        }
    }

    public PersonGenericRelateDataEntity setLabRelRecordToEmpDep(IPersonGenericContext<PersonGenericSaveEntity> personGenericContext, Map<Long, Object> recordDepIdMap, String relateField, Map<Long, Boolean> quitInfoMap) {
        DynamicObjectCollection updateHisDyColl;
        PersonGenericRelateDataEntity relateDataEntity = new PersonGenericRelateDataEntity("hrpi_depemp");
        Set<Long> depIdSet = recordDepIdMap.keySet();
        HashSet<Long> notHandleSet = new HashSet<Long>();
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection dyCollData = personGenericEntity.getHisDyns("hrpi_depemp");
        if (!CollectionUtils.isEmpty((Collection)dyCollData) && !CollectionUtils.isEmpty((Collection)(updateHisDyColl = this.updateRelateRuleExecute(recordDepIdMap, dyCollData, relateField, notHandleSet, "1", quitInfoMap)))) {
            relateDataEntity.setRelateHisDyMap(updateHisDyColl);
        }
        if (!CollectionUtils.isEmpty(notHandleSet)) {
            DynamicObjectCollection updateDyColl;
            QFilter qFilter = new QFilter("id", "in", depIdSet).and(QFilterUtil.getDataStatusFilter()).and(QFilterUtil.getCurrentQf());
            DynamicObjectCollection depDyColl = DEPEMP_SERVICE_HELPER.queryOriginalCollection(String.format("id,assignno,boid,%s", relateField), qFilter.toArray());
            if (!CollectionUtils.isEmpty((Collection)depDyColl) && !CollectionUtils.isEmpty((Collection)(updateDyColl = this.updateRelateRuleExecute(recordDepIdMap, depDyColl, relateField, notHandleSet, "0", quitInfoMap)))) {
                relateDataEntity.setRelateDbDyMap(updateDyColl);
            }
        }
        return relateDataEntity;
    }

    private DynamicObjectCollection updateRelateRuleExecute(Map<Long, Object> personRelateMap, DynamicObjectCollection dyCollData, String relateField, Set<Long> notHandleSet, String type, Map<Long, Boolean> quitInfoMap) {
        Set<Long> personIdSet = personRelateMap.keySet();
        DynamicObjectCollection updateDyColl = new DynamicObjectCollection();
        for (DynamicObject dy : dyCollData) {
            long empId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"employee");
            if (quitInfoMap.get(empId).booleanValue()) continue;
            long matchId = dy.getLong("boid");
            if ("1".equals(type)) {
                if (matchId == 0L) {
                    matchId = dy.getLong("id");
                }
            } else {
                matchId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"id");
            }
            if (personIdSet.contains(matchId)) {
                DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)DEPEMP_SERVICE_HELPER.getEntityName(), Arrays.asList("id", relateField, "assignno"));
                DynamicObject updateRelateDy = (DynamicObject)subDataEntityType.createInstance();
                updateRelateDy.set("id", (Object)dy.getLong("id"));
                updateRelateDy.set(relateField, personRelateMap.get(matchId));
                updateDyColl.add((Object)updateRelateDy);
                continue;
            }
            notHandleSet.add(matchId);
        }
        return updateDyColl;
    }

    @Override
    public void mergeRelateDataField(DynamicObject relateData, DynamicObject targetData, Set<String> redundancyFields) {
        super.mergeRelateDataField(relateData, targetData, redundancyFields);
        DataEntityPropertyCollection properties = relateData.getDynamicObjectType().getProperties();
        if (properties.containsKey((Object)"laborrelrecord") && HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)targetData, (String)"laborrelrecord") == 0L) {
            this.mergeRelateDataValue(relateData, targetData, properties, "laborrelrecord");
        }
        if (properties.containsKey((Object)"number") && HRStringUtils.isNotEmpty((String)relateData.getString("number"))) {
            this.mergeRelateDataValue(relateData, targetData, properties, "number");
        }
        if (properties.containsKey((Object)"assignno") && HRStringUtils.isNotEmpty((String)relateData.getString("assignno"))) {
            this.mergeRelateDataValue(relateData, targetData, properties, "assignno");
        }
    }

    private static class Holder {
        static final HrpiDepempGenericSaveRuleServiceImpl INSTANCE = new HrpiDepempGenericSaveRuleServiceImpl();

        private Holder() {
        }
    }
}

