/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.rule;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.service.impl.generic.factory.PersonGenericCodeRuleFactory;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.PersonGenericSaveRuleTimeService;
import kd.hrmp.hrpi.business.infrastructure.utils.BusinessDataUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.business.tools.CustomRuleUtil;
import kd.hrmp.hrpi.common.HRPIValueConstants;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericRedundancyRelate;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.generic.enums.PersonGenericOperateTypeEnums;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;
import org.apache.commons.collections.MapUtils;

public class HrpiEmpentrelGenericSaveRuleServiceImpl
extends PersonGenericSaveRuleTimeService {
    private static final Log LOGGER = LogFactory.getLog(HrpiEmpentrelGenericSaveRuleServiceImpl.class);
    private static final HRBaseServiceHelper EMPENTREL_SERVICEHELPER = new HRBaseServiceHelper("hrpi_empentrel");
    private static final HRBaseServiceHelper EMPLOY_SERVICEHELPER = new HRBaseServiceHelper("hrpi_employee");
    final List<PersonGenericRedundancyRelate> leftRedundancyRelates = new ArrayList<PersonGenericRedundancyRelate>();

    public static HrpiEmpentrelGenericSaveRuleServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    private HrpiEmpentrelGenericSaveRuleServiceImpl() {
        this.leftRedundancyRelates.add(new PersonGenericRedundancyRelate("hrpi_empentrel", "employee", "empnumber", "hrpi_empnonentrel", "employee", "empnumber"));
        this.leftRedundancyRelates.add(new PersonGenericRedundancyRelate("hrpi_empentrel", "employee", "enterprise", "hrpi_empnonentrel", "employee", "enterprise"));
        this.leftRedundancyRelates.add(new PersonGenericRedundancyRelate("hrpi_empentrel", "employee", "lastworkdate", "hrpi_empnonentrel", "employee", "lastworkdate"));
        this.leftRedundancyRelates.add(new PersonGenericRedundancyRelate("hrpi_empentrel", "employee", "laborreltype", "hrpi_empnonentrel", "employee", "laborreltype"));
        this.leftRedundancyRelates.add(new PersonGenericRedundancyRelate("hrpi_empentrel", "employee", "laborrelstatus", "hrpi_empnonentrel", "employee", "laborrelstatus"));
    }

    @Override
    public void initRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        PersonGenericCodeRuleFactory.getInstance(personGenericContext, entityNumber).getNumbersAndSet(entityNumber, dyColl, "number");
        Map<Long, Long> laborrelStatusAndPrdMap = this.getLaborrelStatusAndPrdMap();
        for (DynamicObject dy : dyColl) {
            this.initServicelength(dy, laborrelStatusAndPrdMap);
        }
        this.handleServiceLength(personGenericContext, dyColl);
    }

    public void handleServiceLength(IPersonGenericContext<PersonGenericSaveEntity> personGenericContext, DynamicObjectCollection dyColl) {
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        PersonGenericOperateTypeEnums operateTypeEnums = personGenericContext.getOperateTypeEnums();
        if (PersonGenericOperateTypeEnums.VALIDATE == operateTypeEnums) {
            return;
        }
        List<DynamicObject> continuationDys = dyColl.stream().filter(dy -> "2".equals(dy.getString("serviceagescheme"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(continuationDys)) {
            return;
        }
        HashMap<Long, Long> empIdAndMidMap = new HashMap<Long, Long>(16);
        Object[] oldEmpentrelDys = this.findEmpEntInfo(continuationDys, personGenericContext, empIdAndMidMap);
        if (HRArrayUtils.isEmpty((Object[])oldEmpentrelDys)) {
            return;
        }
        Map<Long, BigDecimal> serviceLengthMap = this.doCalcServiceLength(continuationDys, empIdAndMidMap, (DynamicObject[])oldEmpentrelDys);
        if (!"initialize".equals(personGenericEntity.getCaller())) {
            LOGGER.info("handleServiceLengthMapInfo--->{}", serviceLengthMap);
        }
        if (serviceLengthMap.size() == 0) {
            return;
        }
        this.setServiceLengthToRelateData(dyColl, serviceLengthMap);
    }

    private void setServiceLengthToRelateData(DynamicObjectCollection empEntDys, Map<Long, BigDecimal> serviceLengthMap) {
        for (DynamicObject dy : empEntDys) {
            long boId;
            BigDecimal serLen;
            String serviceAgeScheme = dy.getString("serviceagescheme");
            if (!"2".equals(serviceAgeScheme) || (serLen = serviceLengthMap.get(boId = (boId = dy.getLong("boid")) == 0L ? dy.getLong("id") : dy.getLong("boid"))) == null) continue;
            dy.set("servicelength", (Object)serLen);
        }
    }

    private Map<Long, BigDecimal> doCalcServiceLength(List<DynamicObject> continuationDys, Map<Long, Long> empIdAndMidMap, DynamicObject[] oldEmpentrelDys) {
        HashMap<Long, BigDecimal> totalServiceLengthMap = new HashMap<Long, BigDecimal>(16);
        Map<Long, List<DynamicObject>> midEmpentrelMap = Arrays.stream(oldEmpentrelDys).collect(Collectors.groupingBy(conDy -> conDy.getLong("employee.mid")));
        Map<Long, Long> empMidMap = Arrays.stream(oldEmpentrelDys).collect(Collectors.toMap(conDy -> conDy.getLong("employee.id"), conDy -> conDy.getLong("employee.mid")));
        empIdAndMidMap.putAll(empMidMap);
        for (DynamicObject conDy2 : continuationDys) {
            List<DynamicObject> oldEmpentrelTmpDys;
            BigDecimal lastServiceLength = new BigDecimal(0);
            long empId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)conDy2, (String)"employee");
            long boId = conDy2.getLong("boid");
            Date sData = conDy2.getDate("startdate");
            Date eDate = conDy2.getDate("enddate");
            BigDecimal adjLen = conDy2.getBigDecimal("adjustlength");
            try {
                Date maxDateSub = HRDateTimeUtils.addDay((Date)HRDateTimeUtils.parseDate((String)"2999-12-31"), (long)-1L);
                if (eDate.after(maxDateSub)) {
                    eDate = new Date();
                }
            }
            catch (Exception esc) {
                LOGGER.error("dateError", (Throwable)esc);
            }
            lastServiceLength = lastServiceLength.add(HrpiEmpentrelGenericSaveRuleServiceImpl.calcServiceLength(sData, eDate, adjLen));
            Long mid = empIdAndMidMap.get(empId);
            if (mid == null || mid == 0L || (oldEmpentrelTmpDys = midEmpentrelMap.get(mid)) == null || oldEmpentrelTmpDys.size() == 0) continue;
            oldEmpentrelTmpDys.sort(HrpiEmpentrelGenericSaveRuleServiceImpl::compare);
            for (DynamicObject oldEmpentrelDy : oldEmpentrelTmpDys) {
                Date startDate = oldEmpentrelDy.getDate("startdate");
                long lastBoId = oldEmpentrelDy.getLong("boid");
                if (sData.before(startDate) || lastBoId == boId) continue;
                BigDecimal adjustLength = oldEmpentrelDy.getBigDecimal("adjustlength");
                Date endDate = oldEmpentrelDy.getDate("enddate");
                if (startDate == null || endDate == null) continue;
                lastServiceLength = lastServiceLength.add(HrpiEmpentrelGenericSaveRuleServiceImpl.calcServiceLength(startDate, endDate, adjustLength));
                String serviceAgeScheme = oldEmpentrelDy.getString("serviceagescheme");
                if ("2".equals(serviceAgeScheme)) continue;
                break;
            }
            if (boId == 0L) {
                totalServiceLengthMap.put(conDy2.getLong("id"), lastServiceLength);
                continue;
            }
            totalServiceLengthMap.put(boId, lastServiceLength);
        }
        return totalServiceLengthMap;
    }

    private DynamicObject[] findEmpEntInfo(List<DynamicObject> continuationDys, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext, Map<Long, Long> empIdAndMidMap) {
        Map<Long, Long> tmpMap;
        HashSet<Long> empMidSet = new HashSet<Long>(continuationDys.size());
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection employeeDys = personGenericEntity.getHisDyns("hrpi_employee");
        if (!CollectionUtils.isEmpty((Collection)employeeDys) && (tmpMap = employeeDys.stream().collect(Collectors.toMap(conDy -> conDy.getLong("id"), conDy -> conDy.getLong("mid")))).size() > 0) {
            empIdAndMidMap.putAll(tmpMap);
            Collection<Long> midColl = empIdAndMidMap.values();
            empMidSet.addAll(midColl);
        }
        if (empMidSet.size() == 0) {
            return null;
        }
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter midFilter = new QFilter("mid", "in", empMidSet);
        Object[] empMidDys = EMPLOY_SERVICEHELPER.query("id,mid", new QFilter[]{qFilter, midFilter, QFilterUtil.getDataStatusFilter()});
        if (HRArrayUtils.isEmpty((Object[])empMidDys)) {
            return null;
        }
        Set empIds = Arrays.stream(empMidDys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        QFilter midQFilter = new QFilter("employee", "in", empIds);
        Object[] oldEmpentrelDys = EMPENTREL_SERVICEHELPER.query("id,boid,person,entservicelen,employee.mid,servicelength,adjustlength,startdate,enddate,iscurrentversion,serviceagescheme,boid,labrelstatusprd", new QFilter[]{qFilter, midQFilter});
        if (HRArrayUtils.isEmpty((Object[])oldEmpentrelDys)) {
            return null;
        }
        return oldEmpentrelDys;
    }

    private static int compare(DynamicObject dynamicObject, DynamicObject dynamicObject1) {
        return dynamicObject.getDate("startdate").after(dynamicObject1.getDate("startdate")) ? -1 : 1;
    }

    private static BigDecimal calcServiceLength(Date startdate, Date endDate, BigDecimal adjustlength) {
        BigDecimal year = DateUtil.calcYearsDiff(endDate, startdate);
        return year.add(adjustlength);
    }

    private void initServicelength(DynamicObject dynamicObject, Map<Long, Long> laborrelStatusAndPrdMap) {
        if (0L == HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"laborrelstatus") || null == dynamicObject.getDate("startdate")) {
            return;
        }
        long laborrelstatusId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"laborrelstatus");
        Long labrelstatusprdId = laborrelStatusAndPrdMap.get(laborrelstatusId);
        Date enddate = HRPIValueConstants.LABRELSTATUSPRD_END.equals(labrelstatusprdId) ? dynamicObject.getDate("enddate") : new Date();
        Date startdate = dynamicObject.getDate("startdate");
        BigDecimal adjustlength = dynamicObject.getBigDecimal("adjustlength");
        BigDecimal serviceLength = BusinessDataUtil.getServiceLength(enddate, startdate, adjustlength);
        dynamicObject.set("servicelength", (Object)serviceLength);
    }

    protected Map<Long, Long> getLaborrelStatusAndPrdMap() {
        Map laborrelstatusMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_laborrelstatus", (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")});
        if (CollectionUtils.isEmpty((Map)laborrelstatusMap)) {
            return new HashMap<Long, Long>(1);
        }
        return laborrelstatusMap.entrySet().stream().collect(Collectors.toMap(entry -> (Long)entry.getKey(), entry -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)((DynamicObject)entry.getValue()), (String)"labrelstatusprd")));
    }

    @Override
    protected void afterRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        PersonGenericOperateTypeEnums operateTypeEnums = personGenericContext.getOperateTypeEnums();
        if (PersonGenericOperateTypeEnums.VALIDATE == operateTypeEnums || CollectionUtils.isEmpty((Collection)dyColl)) {
            return;
        }
        PersonGenericCodeRuleFactory.getInstance(personGenericContext, entityNumber).getNumbersAndUpdate(entityNumber, dyColl, "number");
    }

    @Override
    protected void commonRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        super.commonRuleExecute(entityNumber, dyColl, personGenericContext);
        this.executeLeftEmpentrel(entityNumber, dyColl, personGenericContext);
    }

    private void executeLeftEmpentrel(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        List leftDys = dyColl.stream().filter(this::isLeftEmpentrel).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(leftDys)) {
            return;
        }
        DynamicObjectCollection dys = new DynamicObjectCollection();
        dys.addAll(leftDys);
        this.commonRedundancyRuleExecute(entityNumber, dys, this.leftRedundancyRelates, personGenericContext);
    }

    private boolean isLeftEmpentrel(DynamicObject empentrel) {
        long laborrelstatusId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)empentrel, (String)"laborrelstatus");
        if (0L == laborrelstatusId) {
            return false;
        }
        DynamicObject laborrelstatusDy = BusinessDataServiceHelper.loadSingleFromCache((Object)laborrelstatusId, (String)"hbss_laborrelstatus");
        if (null == laborrelstatusDy) {
            return false;
        }
        DynamicObject labrelstatuscls = laborrelstatusDy.getDynamicObject("labrelstatuscls");
        return HRPIValueConstants.NUMBER_LABSTATUSCLS_LEFT_ID.equals(labrelstatuscls.getLong("id"));
    }

    @Override
    public void mergeRelateDataField(DynamicObject relateData, DynamicObject targetData, Set<String> redundancyFields) {
        DataEntityPropertyCollection properties = relateData.getDynamicObjectType().getProperties();
        if (properties.containsKey((Object)"servicelength")) {
            this.mergeRelateDataValue(relateData, targetData, properties, "servicelength");
        }
    }

    @Override
    protected void customRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        super.customRuleExecute(entityNumber, dyColl, personGenericContext);
        PersonGenericOperateTypeEnums operateTypeEnums = personGenericContext.getOperateTypeEnums();
        if (PersonGenericOperateTypeEnums.SAVEBATCH == operateTypeEnums && !CollectionUtils.isEmpty((Collection)dyColl)) {
            CustomRuleUtil.processOfLatestRecord(entityNumber, dyColl);
        }
    }

    @Override
    protected Map<Long, Object> convertSourceRedundancyMap(DynamicObjectCollection dyColl, PersonGenericRedundancyRelate relate) {
        String sourceRelateField = relate.getSourceRelateField();
        String sourceRedundancyField = relate.getSourceField();
        DataEntityPropertyCollection properties = HRPIDynamicObjectUtil.getProperties((DynamicObjectCollection)dyColl);
        if (!properties.containsKey((Object)sourceRedundancyField) || !properties.containsKey((Object)sourceRelateField)) {
            return MapUtils.EMPTY_MAP;
        }
        List collect = dyColl.stream().filter(dy -> HRStringUtils.equals((String)"1", (String)dy.getString("islatestrecord")) || HRStringUtils.equals((String)"true", (String)dy.getString("islatestrecord"))).collect(Collectors.toList());
        if (null == collect || collect.size() == 0) {
            return MapUtils.EMPTY_MAP;
        }
        Map<Long, Object> redundancyMap = collect.stream().collect(Collectors.groupingBy(dyn -> {
            String sourceId = "boid".equals(sourceRelateField) && (Long)dyn.get(sourceRelateField) == 0L ? "id" : sourceRelateField;
            return HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dyn, (String)sourceId);
        }, Collectors.collectingAndThen(Collectors.maxBy(Comparator.comparing(dyn -> dyn.getDate("bsed"))), optional -> ((DynamicObject)optional.get()).get(sourceRedundancyField))));
        return redundancyMap;
    }

    private static class Holder {
        static final HrpiEmpentrelGenericSaveRuleServiceImpl INSTANCE = new HrpiEmpentrelGenericSaveRuleServiceImpl();

        private Holder() {
        }
    }
}

