/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.rule;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.PersonGenericSaveRuleTimeService;
import kd.hrmp.hrpi.business.tools.CustomRuleUtil;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.generic.enums.PersonGenericOperateTypeEnums;

public class HrpiEmployeeGenericSaveRuleServiceImpl
extends PersonGenericSaveRuleTimeService {
    private static final HRBaseServiceHelper EMPLOYEE_SERVICEHELPER = new HRBaseServiceHelper("hrpi_employee");

    public static HrpiEmployeeGenericSaveRuleServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void initData(String entityNumber, IPersonGenericContext<?> personGenericContext) {
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection dyColl = personGenericEntity.getHisDyns(entityNumber);
        for (DynamicObject dynamicObject : dyColl) {
            this.midRuleExecute(dynamicObject);
        }
    }

    @Override
    protected void customRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        super.customRuleExecute(entityNumber, dyColl, personGenericContext);
        for (DynamicObject dynamicObject : dyColl) {
            this.midRuleExecute(dynamicObject);
        }
        PersonGenericOperateTypeEnums operateTypeEnums = personGenericContext.getOperateTypeEnums();
        if (PersonGenericOperateTypeEnums.SAVEBATCH == operateTypeEnums && !CollectionUtils.isEmpty((Collection)dyColl)) {
            CustomRuleUtil.processOfLatestRecord(entityNumber, dyColl);
        }
    }

    private void midRuleExecute(DynamicObject dynamicObject) {
        if (dynamicObject.getLong("mid") == 0L) {
            long boid = dynamicObject.getLong("boid");
            dynamicObject.set("mid", boid == 0L ? dynamicObject.getPkValue() : Long.valueOf(boid));
        }
    }

    protected Map<Long, DynamicObject> getEmployeeMap(Set<Long> employeeIdSet, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        QFilter qFilter;
        DynamicObject[] employeeDbDyArr;
        HashMap<Long, DynamicObject> employeeMap = new HashMap<Long, DynamicObject>(16);
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection dyCollData = personGenericEntity.getHisDyns("hrpi_employee");
        if (!CollectionUtils.isEmpty((Collection)dyCollData)) {
            employeeMap.putAll(dyCollData.stream().collect(Collectors.toMap(dy -> {
                long pkId = dy.getLong("id");
                employeeIdSet.remove(pkId);
                return pkId;
            }, dy -> dy)));
        }
        if (!employeeIdSet.isEmpty() && (employeeDbDyArr = EMPLOYEE_SERVICEHELPER.query("id,laborrelstatus,enddate", (qFilter = new QFilter("id", "in", employeeIdSet)).toArray())) != null && employeeDbDyArr.length > 0) {
            for (DynamicObject employeeDbDy : employeeDbDyArr) {
                employeeMap.put(employeeDbDy.getLong("id"), employeeDbDy);
            }
        }
        return employeeMap;
    }

    private static class Holder {
        static final HrpiEmployeeGenericSaveRuleServiceImpl INSTANCE = new HrpiEmployeeGenericSaveRuleServiceImpl();

        private Holder() {
        }
    }
}

