/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.rule;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginCall;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.service.impl.HRPositionServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.HrpiPersonrolerelGenericSaveRuleServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.PersonGenericSaveRuleTimeService;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.util.HrpiEmpposorgrelGenericUtil;
import kd.hrmp.hrpi.business.extpoint.ProxyUtils;
import kd.hrmp.hrpi.business.helper.EmpposorgrelServiceHelper;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericRedundancyRelate;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericRelateDataEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.generic.enums.PersonGenericOperateTypeEnums;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;
import kd.sdk.hr.hrmp.hrpi.extpoint.ICustomUpdEmpposVid;
import kd.sdk.hr.hrmp.hrpi.extpoint.IUpdateEmpPosExtService;
import kd.sdk.hr.hrmp.hrpi.extpoint.dto.UpdateEmpPosExtDTO;
import org.apache.commons.collections.MapUtils;

public class HrpiEmpposorgrelGenericSaveRuleServiceImpl
extends PersonGenericSaveRuleTimeService {
    private static final Log LOGGER = LogFactory.getLog(HrpiEmpposorgrelGenericSaveRuleServiceImpl.class);
    private static final String ERROR_CODE = "error";
    private static final String CACHE_ADDDARKPOSITION = "HrpiEmpposorgrel.addDarkPositionSet";
    private static final String CACHE_DISABLEDARKPOSITION = "HrpiEmpposorgrel.disableDarkPositionSet";
    private final List<PersonGenericRedundancyRelate> primaryRedundancyRelates = new ArrayList<PersonGenericRedundancyRelate>();
    private static final String SCENCE = "kd.sdk.hr.hrmp.hrpi.extpoint.IUpdateEmpPosExtService";
    private static final HRBaseServiceHelper EMPPOS_SERVICE_HELPER = new HRBaseServiceHelper("hrpi_empposorgrel");

    private HrpiEmpposorgrelGenericSaveRuleServiceImpl() {
        this.primaryRedundancyRelates.add(new PersonGenericRedundancyRelate("hrpi_empposorgrel", "cmpemp", "company", "hrpi_cmpemp", "id", "company"));
        this.primaryRedundancyRelates.add(new PersonGenericRedundancyRelate("hrpi_empposorgrel", "employee", "company", "hrpi_empjobrel", "employee", "company"));
    }

    public static HrpiEmpposorgrelGenericSaveRuleServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void initData(String entityNumber, IPersonGenericContext<?> personGenericContext) {
        if (PersonGenericOperateTypeEnums.REVISEVERSIONBATCH == personGenericContext.getOperateTypeEnums()) {
            return;
        }
        this.buildWorkRole(entityNumber, personGenericContext);
    }

    private void buildWorkRole(String entityNumber, IPersonGenericContext<?> personGenericContext) {
        HrpiPersonrolerelGenericSaveRuleServiceImpl service;
        DynamicObjectCollection newWorkRoleCol;
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        Object dyColl = personGenericEntity.getHisDyns(entityNumber);
        DynamicObjectCollection workRoleCol = personGenericEntity.getHisDyns("hrpi_personrolerel");
        dyColl = dyColl.stream().filter(dy -> dy.getLong("boid") == 0L || HRStringUtils.equals((String)dy.getString("businessstatus"), (String)"2")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)workRoleCol)) {
            Map<Long, List<DynamicObject>> workRoleMap = workRoleCol.stream().collect(Collectors.groupingBy(item -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)item, (String)"depemp")));
            dyColl = dyColl.stream().filter(dy -> {
                List workRoleList = (List)workRoleMap.get(HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"depemp"));
                if (CollectionUtils.isEmpty((Collection)workRoleList)) {
                    return true;
                }
                return workRoleList.stream().noneMatch(workRole -> HRDateTimeUtils.dayEquals((Date)workRole.getDate("startdate"), (Date)dy.getDate("startdate")));
            }).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)(newWorkRoleCol = (service = HrpiPersonrolerelGenericSaveRuleServiceImpl.getInstance()).buildWorkRoleCol((List<DynamicObject>)dyColl)))) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)workRoleCol)) {
            workRoleCol = personGenericEntity.addData("hrpi_personrolerel");
        }
        workRoleCol.addAll((Collection)newWorkRoleCol);
    }

    @Override
    public void initRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        Set<Long> adminOrgSet = dyColl.stream().map(dy -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"adminorg")).collect(Collectors.toSet());
        Map<Long, Long> belongCompanyMap = this.getBelongCompany(adminOrgSet);
        for (DynamicObject dynamicObject : dyColl) {
            this.initPosition(dynamicObject);
            Long companyId = belongCompanyMap.get(HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"adminorg"));
            dynamicObject.set("company", (Object)companyId);
            dynamicObject.set("company_id", (Object)companyId);
        }
    }

    private void initPosition(DynamicObject dynamicObject) {
        String apositiontype = dynamicObject.getString("apositiontype");
        long positionId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"position");
        LOGGER.info("initPosition:apositiontype:{},posId:{}", (Object)apositiontype, (Object)positionId);
        if (!HRStringUtils.equals((String)"1", (String)apositiontype) && positionId == 0L) {
            LOGGER.info("initPosition:set 0L");
            dynamicObject.set("position", (Object)1L);
            dynamicObject.set("position_id", (Object)1L);
        }
    }

    @Override
    protected void customRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        ArrayList addDarkPosParam = Lists.newArrayListWithExpectedSize((int)dyColl.size());
        ArrayList addDarkPosByJobParam = Lists.newArrayListWithExpectedSize((int)dyColl.size());
        HashMap addDarkPosMap = Maps.newHashMapWithExpectedSize((int)dyColl.size());
        HashSet disableDarkPositionSet = Sets.newHashSetWithExpectedSize((int)dyColl.size());
        for (DynamicObject dynamicObject : dyColl) {
            this.doIsinsystemRuleExecute(dynamicObject);
            this.doServicelengthRuleExecute(dynamicObject);
            this.doPositionRuleExecute(dynamicObject, addDarkPosMap, addDarkPosParam, addDarkPosByJobParam, disableDarkPositionSet);
        }
        this.executePositionReturnWorkRoleId(entityNumber, addDarkPosMap, addDarkPosParam, addDarkPosByJobParam, disableDarkPositionSet, personGenericContext);
        boolean isDeal = ProxyUtils.setPosVid((PluginCall<ICustomUpdEmpposVid, Boolean>)((PluginCall)iCustomUpdEmpposVid -> iCustomUpdEmpposVid.executeBoidAndVid(dyColl)));
        if (!isDeal) {
            this.executeBoidAndVid(dyColl);
        }
        this.executeRedundancyPrimaryCompany(entityNumber, dyColl, personGenericContext);
    }

    private Map<Long, Long> getBelongCompany(Set<Long> adminOrgSet) {
        if (CollectionUtils.isEmpty(adminOrgSet)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Map companyResult = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"adminOrgInfoQuery", (Object[])new Object[]{Lists.newArrayList(adminOrgSet), new Date()});
        Map msgMap = (Map)companyResult.get(ERROR_CODE);
        if (msgMap != null) {
            LOGGER.error("adminOrgInfoQuery error:" + msgMap);
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u201cIHAOSBatchAdminOrgInfoQueryService.adminOrgInfoQuery\u201d\u5f02\u5e38\u3002", (String)"HrpiEmpposorgrelGenericSaveRuleServiceImpl_0", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)adminOrgSet.size());
        companyResult.forEach((key, value) -> map.put(Long.valueOf(key), (Long)value.get("belongcompany")));
        return map;
    }

    private void doPositionRuleExecute(DynamicObject dynamicObject, Map<String, DynamicObject> addDarkPosMap, List<Map<String, Object>> addDarkPosParam, List<Map<String, Object>> addDarkPosByJobParam, Set<Long> disableDarkPositionSet) {
        String apositiontype = dynamicObject.getString("apositiontype");
        if (HRStringUtils.equals((String)"1", (String)apositiontype)) {
            return;
        }
        HrpiEmpposorgrelGenericUtil.doPositionParam(dynamicObject, addDarkPosMap, addDarkPosParam, addDarkPosByJobParam);
        String businessstatus = dynamicObject.getString("businessstatus");
        long boid = dynamicObject.getLong("boid");
        long positionId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"position");
        if (positionId != 1L && HRStringUtils.equals((String)businessstatus, (String)"2") && boid != 0L) {
            disableDarkPositionSet.add(positionId);
        }
    }

    private void executePositionReturnWorkRoleId(String entityNumber, Map<String, DynamicObject> addDarkPosMap, List<Map<String, Object>> addDarkPosParam, List<Map<String, Object>> addDarkPosByJobParam, Set<Long> disableDarkPositionSet, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        PersonGenericOperateTypeEnums operateTypeEnums = personGenericContext.getOperateTypeEnums();
        if (operateTypeEnums == PersonGenericOperateTypeEnums.VALIDATE) {
            LOGGER.info("PersonGenericService ==> HrpiEmpposorgrelGenericSaveRuleServiceImpl#executePositionReturnWorkRoleId operateType is validate.");
            return;
        }
        HashMap depempAndRoleMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, Map<String, Object>> darkPosMap = HRPositionServiceImpl.getInstance().addDarkPosByStdPos(addDarkPosParam);
        Map<String, Map<String, Object>> darkPosByJobMap = HRPositionServiceImpl.getInstance().addDarkPosByJob(addDarkPosByJobParam);
        HashSet addDarkPositionSet = Sets.newHashSetWithExpectedSize((int)(darkPosMap.size() + darkPosByJobMap.size()));
        for (Map.Entry<String, DynamicObject> addDarkPosEntry : addDarkPosMap.entrySet()) {
            Map<String, Object> darkPosByJobResult;
            Map<String, Object> darkPosResult;
            String key = addDarkPosEntry.getKey();
            DynamicObject dynamicObject = addDarkPosEntry.getValue();
            if (this.setPositionByStdPosOrJobAndRole(addDarkPositionSet, dynamicObject, darkPosResult = darkPosMap.get(key), depempAndRoleMap) || this.setPositionByStdPosOrJobAndRole(addDarkPositionSet, dynamicObject, darkPosByJobResult = darkPosByJobMap.get(key), depempAndRoleMap)) continue;
            LOGGER.info("PersonGenericService ==> HrpiEmpposorgrelGenericSaveRuleServiceImpl#executePosition key: {} not match any data.", (Object)key);
        }
        personGenericContext.putCustomerParam(CACHE_ADDDARKPOSITION, (Object)addDarkPositionSet);
        personGenericContext.putCustomerParam(CACHE_DISABLEDARKPOSITION, disableDarkPositionSet);
        HrpiPersonrolerelGenericSaveRuleServiceImpl hrpiPersonrolerelGenericGenericSaveRuleService = HrpiPersonrolerelGenericSaveRuleServiceImpl.getInstance();
        PersonGenericRelateDataEntity roleRelateDataEntity = hrpiPersonrolerelGenericGenericSaveRuleService.roleRelateRuleExecute(personGenericContext, depempAndRoleMap);
        if (!roleRelateDataEntity.isEmpty()) {
            ((PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity()).addRelateDataEntity(entityNumber, roleRelateDataEntity);
        }
    }

    private boolean setPositionByStdPosOrJobAndRole(Set<Long> addDarkPositionSet, DynamicObject dynamicObject, Map<String, Object> darkPosResult, Map<Long, Object> depempAndRoleMap) {
        if (darkPosResult != null) {
            Long positionId = MapUtils.getLong(darkPosResult, (Object)"position");
            dynamicObject.set("position", (Object)MapUtils.getLong(darkPosResult, (Object)"position"));
            dynamicObject.set("position_id", (Object)MapUtils.getLong(darkPosResult, (Object)"position"));
            addDarkPositionSet.add(positionId);
            long depempId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"depemp");
            depempAndRoleMap.put(depempId, MapUtils.getLong(darkPosResult, (Object)"workrole"));
            return true;
        }
        return false;
    }

    private void executeBoidAndVid(DynamicObjectCollection dyColl) {
        Map<String, List<DynamicObject>> empposorgrelMap = dyColl.stream().collect(Collectors.groupingBy(dy -> dy.getString("businessstatus")));
        empposorgrelMap.forEach((businessstatus, dynamicObjectList) -> EmpposorgrelServiceHelper.setEmpposorgrelHisInfo(dynamicObjectList));
    }

    private void executeRedundancyPrimaryCompany(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        List primaryEmpposorgrels = dyColl.stream().filter(dy -> "1".equals(dy.getString("isprimary"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(primaryEmpposorgrels)) {
            return;
        }
        DynamicObjectCollection dys = new DynamicObjectCollection();
        dys.addAll(primaryEmpposorgrels);
        this.commonRedundancyRuleExecute(entityNumber, dys, this.primaryRedundancyRelates, personGenericContext);
    }

    private void doIsinsystemRuleExecute(DynamicObject dynamicObject) {
        dynamicObject.set("isinsystem", (Object)"1");
    }

    private void doServicelengthRuleExecute(DynamicObject dynamicObject) {
        Date startdate = dynamicObject.getDate("startdate");
        Date enddate = dynamicObject.getDate("enddate");
        String businessstatus = dynamicObject.getString("businessstatus");
        if (HRObjectUtils.isEmpty((Object)startdate)) {
            return;
        }
        long diff = 0L;
        if (HRStringUtils.equals((String)businessstatus, (String)"1")) {
            diff = HRDateTimeUtils.dateDiff((String)"d", (Date)startdate, (Date)new Date());
        } else if (HRStringUtils.equals((String)businessstatus, (String)"2") && !HRObjectUtils.isEmpty((Object)enddate)) {
            diff = HRDateTimeUtils.dateDiff((String)"d", (Date)startdate, (Date)enddate);
        }
        dynamicObject.set("servicelength", (Object)diff);
    }

    public PersonGenericRelateDataEntity updateNumber(IPersonGenericContext<PersonGenericSaveEntity> personGenericContext, DynamicObjectCollection totalDys, String relateField, String type) {
        PersonGenericRelateDataEntity relateDataEntity = new PersonGenericRelateDataEntity("hrpi_empposorgrel");
        if (!CollectionUtils.isEmpty((Collection)totalDys)) {
            PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
            HashMap<Long, String> boIdAndNumberMap = new HashMap<Long, String>(totalDys.size());
            this.buildDepAndNumberRel(totalDys, type, boIdAndNumberMap);
            Set depIds = boIdAndNumberMap.keySet();
            LOGGER.info("reBuildAssignNo ==> updateNumber{}==>", boIdAndNumberMap, depIds);
            DynamicObjectCollection empDys = personGenericEntity.getHisDyns("hrpi_empposorgrel");
            HashSet<Long> boIdSet = new HashSet<Long>(16);
            DynamicObjectCollection updateDyColl = new DynamicObjectCollection();
            if (!CollectionUtils.isEmpty((Collection)empDys)) {
                for (DynamicObject dy : empDys) {
                    long depId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"depemp");
                    DynamicObject dynamicObject = this.createEmptyDy(relateField, EMPPOS_SERVICE_HELPER, dy);
                    String number = (String)boIdAndNumberMap.get(depId);
                    String conNumber = dy.getString("number");
                    if (!HRStringUtils.isNotEmpty((String)number) || number.equals(conNumber)) continue;
                    dynamicObject.set(relateField, (Object)number);
                    updateDyColl.add((Object)dynamicObject);
                    boIdSet.add(depId);
                }
                if (!CollectionUtils.isEmpty((Collection)updateDyColl)) {
                    relateDataEntity.setRelateHisDyMap(updateDyColl);
                }
            }
            if (!CollectionUtils.isEmpty(depIds)) {
                Object[] dynamicObjects = HRPIDepempRepository.listEmpposOrgrels(new ArrayList<Long>(depIds));
                if (HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
                    return relateDataEntity;
                }
                ArrayList<Object> empPoseDys = new ArrayList<Object>(Arrays.asList(dynamicObjects));
                this.doUpdateEmpPosFilter(empPoseDys);
                DynamicObjectCollection updateDbDyColl = new DynamicObjectCollection();
                if (CollectionUtils.isEmpty(empPoseDys)) {
                    return relateDataEntity;
                }
                for (DynamicObject dynamicObject : empPoseDys) {
                    long depId = dynamicObject.getLong("depemp");
                    if (!"1".equals(dynamicObject.getString("datastatus")) || boIdSet.contains(depId)) continue;
                    String number = (String)boIdAndNumberMap.get(depId);
                    String conNumber = dynamicObject.getString("number");
                    if (!HRStringUtils.isNotEmpty((String)number) || number.equals(conNumber)) continue;
                    DynamicObject updateRelateDy = this.createEmptyDy(relateField, EMPPOS_SERVICE_HELPER, dynamicObject);
                    updateRelateDy.set(relateField, (Object)number);
                    updateDbDyColl.add((Object)updateRelateDy);
                }
                if (!CollectionUtils.isEmpty((Collection)updateDbDyColl)) {
                    relateDataEntity.setRelateDbDyMap(updateDbDyColl);
                }
            }
        }
        return relateDataEntity;
    }

    private void doUpdateEmpPosFilter(List<DynamicObject> empPoseDys) {
        HRPluginProxy PLUGIN_PROXY = new HRPluginProxy(null, IUpdateEmpPosExtService.class, SCENCE, null);
        PLUGIN_PROXY.callReplace(plugin -> {
            plugin.updateEmpPosFilter(new UpdateEmpPosExtDTO(empPoseDys));
            return null;
        });
    }

    private void buildDepAndNumberRel(DynamicObjectCollection totalDys, String type, Map<Long, String> boIdAndNumberMap) {
        for (DynamicObject dy : totalDys) {
            String number = dy.getString("number");
            if (dy.getLong("boid") == 0L) {
                boIdAndNumberMap.put(dy.getLong("id"), number);
                continue;
            }
            boIdAndNumberMap.put(dy.getLong("boid"), number);
        }
    }

    private DynamicObject createEmptyDy(String relateField, HRBaseServiceHelper hrBaseServiceHelper, DynamicObject dy) {
        DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)hrBaseServiceHelper.getEntityName(), Arrays.asList("id", relateField));
        DynamicObject updateRelateDy = (DynamicObject)subDataEntityType.createInstance();
        updateRelateDy.set("id", (Object)dy.getLong("id"));
        return updateRelateDy;
    }

    @Override
    public void mergeRelateDataField(DynamicObject relateData, DynamicObject targetData, Set<String> redundancyFields) {
        super.mergeRelateDataField(relateData, targetData, redundancyFields);
        DataEntityPropertyCollection properties = relateData.getDynamicObjectType().getProperties();
        if (HRStringUtils.isNotEmpty((String)relateData.getString("number"))) {
            this.mergeRelateDataValue(relateData, targetData, properties, "number");
        }
    }

    @Override
    protected void afterRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        LOGGER.info("PersonGenericService ==> HrpiEmpposorgrelGenericSaveRuleServiceImpl#afterRuleExecute {}", (Object)entityNumber);
        Set disableDarkPositionSet = (Set)personGenericContext.getCustomerParam(CACHE_DISABLEDARKPOSITION);
        if (!CollectionUtils.isEmpty((Collection)disableDarkPositionSet)) {
            Object[] darkPositionArr = disableDarkPositionSet.toArray();
            try {
                HRPositionServiceImpl.getInstance().disableDarkPosition(darkPositionArr);
            }
            catch (Exception e) {
                LOGGER.info("PersonGenericService ==> HrpiEmpposorgrelGenericSaveRuleServiceImpl#afterRuleExecute disableDarkPosition error.{}, darkPosition:{}, msg:{}", new Object[]{entityNumber, disableDarkPositionSet, e.getMessage()});
            }
        }
    }

    @Override
    protected void afterRollbackRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        LOGGER.info("PersonGenericService ==> HrpiEmpposorgrelGenericSaveRuleServiceImpl#afterRollbackRuleExecute {}", (Object)entityNumber);
        Set darkPositionSet = (Set)personGenericContext.getCustomerParam(CACHE_ADDDARKPOSITION);
        if (!CollectionUtils.isEmpty((Collection)darkPositionSet)) {
            Object[] darkPositionArr = darkPositionSet.toArray();
            try {
                HRPositionServiceImpl.getInstance().disableDarkPosition(darkPositionArr);
            }
            catch (Exception e) {
                LOGGER.info("PersonGenericService ==> HrpiEmpposorgrelGenericSaveRuleServiceImpl#afterRollbackRuleExecute disableDarkPosition error.{}, darkPosition:{}, msg:{}", new Object[]{entityNumber, darkPositionSet, e.getMessage()});
            }
        }
    }

    private static class Holder {
        static final HrpiEmpposorgrelGenericSaveRuleServiceImpl INSTANCE = new HrpiEmpposorgrelGenericSaveRuleServiceImpl();

        private Holder() {
        }
    }
}

