/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIManFileRepository;
import kd.hrmp.hrpi.business.domian.service.impl.generic.coderule.FixedPersonGenericCodeRule;
import kd.hrmp.hrpi.business.domian.service.impl.generic.factory.PersonGenericCodeRuleFactory;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.HrpiDepempGenericSaveRuleServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.PersonGenericSaveRuleTimeService;
import kd.hrmp.hrpi.common.HRPIFieldConstants;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericRelateDataEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.generic.enums.PersonGenericOperateTypeEnums;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;
import org.apache.commons.collections.CollectionUtils;

public class HrpiLaborRelRecordGenericSaveRuleServiceImpl
extends PersonGenericSaveRuleTimeService {
    private static final Log LOGGER = LogFactory.getLog(HrpiLaborRelRecordGenericSaveRuleServiceImpl.class);
    private static final HRBaseServiceHelper LABORRELRECORD_SERVICEHELPER = new HRBaseServiceHelper("hrpi_laborrelrecord");

    public static HrpiLaborRelRecordGenericSaveRuleServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void initRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        FixedPersonGenericCodeRule.getInstance().getNumbersAndSet(entityNumber, dyColl, "number");
    }

    @Override
    protected void customRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        PersonGenericRelateDataEntity personGenericRelateDataEntity;
        PersonGenericOperateTypeEnums operateTypeEnums = personGenericContext.getOperateTypeEnums();
        if (PersonGenericOperateTypeEnums.VALIDATE == operateTypeEnums) {
            return;
        }
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        if (!"hpfs".equals(personGenericEntity.getCaller())) {
            return;
        }
        HrpiDepempGenericSaveRuleServiceImpl depempGenericSaveRuleService = HrpiDepempGenericSaveRuleServiceImpl.getInstance();
        DynamicObjectCollection depHisDys = personGenericEntity.getHisDyns("hrpi_depemp");
        Map<Long, Boolean> quitInfoMap = depempGenericSaveRuleService.getQuitInfoMap(depHisDys);
        ArrayList<DynamicObject> addDys = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> addRemoveDys = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> updateDys = new ArrayList<DynamicObject>(10);
        for (DynamicObject dynamicObject : dyColl) {
            long boId = dynamicObject.getLong("boid");
            if (boId != 0L) {
                updateDys.add(dynamicObject);
                continue;
            }
            addRemoveDys.add(dynamicObject);
            addDys.add(dynamicObject);
        }
        HashMap<Long, Object> recordDepIdMap = new HashMap<Long, Object>(16);
        this.laborRelRecordRuleExecute(addDys, addRemoveDys, updateDys, personGenericContext, recordDepIdMap);
        PersonGenericRelateDataEntity laborrelrecordRelateDataEntity = this.removeDys(dyColl, addRemoveDys, updateDys);
        if (!laborrelrecordRelateDataEntity.isEmpty()) {
            ((PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity()).addRelateDataEntity(entityNumber, laborrelrecordRelateDataEntity);
        }
        if (!(personGenericRelateDataEntity = depempGenericSaveRuleService.setLabRelRecordToEmpDep(personGenericContext, recordDepIdMap, "laborrelrecord", quitInfoMap)).isEmpty()) {
            ((PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity()).addRelateDataEntity(entityNumber, personGenericRelateDataEntity);
        }
    }

    private PersonGenericRelateDataEntity removeDys(DynamicObjectCollection dyColl, List<DynamicObject> addDys, List<DynamicObject> updateDys) {
        PersonGenericRelateDataEntity relateDataEntity = new PersonGenericRelateDataEntity("hrpi_laborrelrecord");
        addDys.addAll(updateDys);
        Set<Object> addSet = new HashSet(16);
        if (CollectionUtils.isNotEmpty(addDys)) {
            addSet = addDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        }
        HashSet<Long> removeSet = new HashSet<Long>(16);
        for (DynamicObject dy2 : dyColl) {
            long id = dy2.getLong("id");
            if (CollectionUtils.isEmpty(addSet)) {
                removeSet.add(id);
                continue;
            }
            if (!CollectionUtils.isNotEmpty(addSet) || addSet.contains(id)) continue;
            removeSet.add(id);
        }
        LOGGER.info("handLaborRelRecord ==> removeSet{}", removeSet);
        if (CollectionUtils.isNotEmpty(removeSet)) {
            relateDataEntity.setRelateHisDyRemoveSet(removeSet);
        }
        return relateDataEntity;
    }

    @Override
    protected void afterRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        PersonGenericCodeRuleFactory.getInstance(personGenericContext, entityNumber).getNumbersAndUpdate(entityNumber, dyColl, "number");
    }

    private void laborRelRecordRuleExecute(List<DynamicObject> addDys, List<DynamicObject> addRemoveDys, List<DynamicObject> updateDys, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext, Map<Long, Object> recordDepIdMap) {
        PersonGenericOperateTypeEnums operateTypeEnums = personGenericContext.getOperateTypeEnums();
        if (PersonGenericOperateTypeEnums.VALIDATE == operateTypeEnums) {
            return;
        }
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection hisDyns = personGenericEntity.getHisDyns("hspm_ermanfile");
        HashMap<String, List<Long>> effectFileMap = new HashMap<String, List<Long>>(16);
        HashMap<String, List<Long>> paramLoseEmpAndBuDepMap = new HashMap<String, List<Long>>(16);
        DynamicObjectCollection hisDys = personGenericEntity.getHisDyns("hrpi_depemp");
        List<DynamicObject> loseDys = hisDys.stream().filter(dy -> "2".equals(dy.getString("businessstatus")) && HRPIFieldConstants.PSOTYPR_VALUE != HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"postype")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)hisDyns)) {
            this.buildParamLoseDys(paramLoseEmpAndBuDepMap, effectFileMap, loseDys, hisDyns);
        }
        this.handleAddDys(addRemoveDys, recordDepIdMap, effectFileMap);
        this.handleUpdateDys(addDys, updateDys, recordDepIdMap, effectFileMap, paramLoseEmpAndBuDepMap);
        LOGGER.info("handLaborRelRecord ==> laborRelRecordRuleExecute{}==>{}", recordDepIdMap, effectFileMap);
    }

    private void handleUpdateDys(List<DynamicObject> addDys, List<DynamicObject> updateDys, Map<Long, Object> recordDepIdMap, Map<String, List<Long>> effectFileMap, Map<String, List<Long>> paramLoseEmpAndBuDepMap) {
        if (CollectionUtils.isEmpty(updateDys)) {
            LOGGER.info("handLaborRelRecord ==> handleUpdateDysEmpty");
            return;
        }
        List<Long> upEmpIds = updateDys.stream().map(dy -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"employee")).collect(Collectors.toList());
        List<Long> upOrgIds = updateDys.stream().map(dy -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"org")).collect(Collectors.toList());
        Set<String> addRecordDys = addDys.stream().map(dy -> this.buildUniqueKey((DynamicObject)dy, "0")).collect(Collectors.toSet());
        HashMap<String, List<Long>> dbFilebuAndDepIdMap = new HashMap(16);
        if (!CollectionUtils.isEmpty(upEmpIds) && !CollectionUtils.isEmpty(upOrgIds)) {
            Object[] fileByEmpIdAndOrg = HRPIManFileRepository.getFileByEmpIdAndOrg(upEmpIds, upOrgIds);
            if (!HRArrayUtils.isEmpty((Object[])fileByEmpIdAndOrg)) {
                dbFilebuAndDepIdMap = this.buildDepDy(Arrays.asList(fileByEmpIdAndOrg), "depemp.id");
            }
            this.handleRemoveRecord(updateDys, recordDepIdMap, effectFileMap, paramLoseEmpAndBuDepMap, addRecordDys, dbFilebuAndDepIdMap);
        } else {
            LOGGER.info("handleUpdateDys ==> infoEmpty{},{}", upEmpIds, upOrgIds);
        }
        LOGGER.info("handleUpdateDys ==> addRecordDys{}==>{}", paramLoseEmpAndBuDepMap, dbFilebuAndDepIdMap);
    }

    private void buildParamLoseDys(Map<String, List<Long>> tmpMap, Map<String, List<Long>> effectFileMap, List<DynamicObject> loseDys, DynamicObjectCollection hisFileDys) {
        Set<Object> depSet = new HashSet(16);
        if (CollectionUtils.isNotEmpty(loseDys)) {
            depSet = loseDys.stream().map(dy -> String.valueOf(dy.getLong("boid"))).collect(Collectors.toSet());
        }
        for (DynamicObject fileDy : hisFileDys) {
            long fileTypeId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)fileDy, (String)"filetype");
            if (1050L == fileTypeId) continue;
            String key = this.buildUniqueKey(fileDy, "0");
            List<Long> depIds = tmpMap.get(key);
            List<Long> effectDepIds = effectFileMap.get(key);
            if (CollectionUtils.isEmpty(depIds)) {
                depIds = new ArrayList<Long>();
            }
            long depId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)fileDy, (String)"depemp");
            if (CollectionUtils.isEmpty(effectDepIds)) {
                effectDepIds = new ArrayList<Long>();
            }
            if ("1".equals(fileDy.getString("businessstatus"))) {
                effectDepIds.add(depId);
                effectFileMap.put(key, effectDepIds);
            }
            if (!depSet.contains(String.valueOf(depId)) || depIds.contains(depId)) continue;
            depIds.add(depId);
            tmpMap.put(key, depIds);
        }
    }

    private void handleRemoveRecord(List<DynamicObject> updateDys, Map<Long, Object> recordDepIdMap, Map<String, List<Long>> effectFileMap, Map<String, List<Long>> paramLoseEmpAndBuDepMap, Set<String> addRecordDys, Map<String, List<Long>> dbFilebuAndDepIdMap) {
        LOGGER.info("handLaborRelRecord ==> add==>{}", addRecordDys);
        Iterator<DynamicObject> updIte = updateDys.iterator();
        while (updIte.hasNext()) {
            boolean removeFlag = false;
            DynamicObject nextDy = updIte.next();
            long id = nextDy.getLong("id");
            String key = this.buildUniqueKey(nextDy, "0");
            List<Long> depDbList = dbFilebuAndDepIdMap.get(key);
            List<Long> paramLoseDepList = paramLoseEmpAndBuDepMap.get(key);
            LOGGER.info("handLaborRelRecord ==> mapInfo{}==>{}", depDbList, paramLoseDepList);
            if (CollectionUtils.isNotEmpty(paramLoseDepList) && CollectionUtils.isNotEmpty(depDbList)) {
                HashSet<Long> depDbSet = new HashSet<Long>(depDbList);
                HashSet<Long> depParamSet = new HashSet<Long>(paramLoseDepList);
                if (depDbSet.containsAll(depParamSet) && depParamSet.containsAll(depDbSet)) {
                    if (addRecordDys.contains(key)) {
                        removeFlag = true;
                    } else if ("1".equals(nextDy.getString("businessstatus"))) {
                        this.buildEmpIdAndLabRecordMap(recordDepIdMap, effectFileMap, nextDy, key, "0", null);
                    }
                    LOGGER.info("handLaborRelRecord ==> addRecordDys{}", (Object)id);
                } else {
                    removeFlag = true;
                    LOGGER.info("handLaborRelRecord ==> removeDiff{}", (Object)key, (Object)"0");
                }
            } else {
                LOGGER.info("handLaborRelRecord ==> Empty{},{}", (Object)CollectionUtils.isNotEmpty(paramLoseDepList), (Object)CollectionUtils.isNotEmpty(depDbList));
            }
            if (!removeFlag) continue;
            updIte.remove();
        }
    }

    private void buildEmpIdAndLabRecordMap(Map<Long, Object> recordDepIdMap, Map<String, List<Long>> effectFileMap, DynamicObject nextDy, String key, String type, Long recordId) {
        List<Long> depIds = effectFileMap.get(key);
        if (CollectionUtils.isNotEmpty(depIds)) {
            for (Long depId : depIds) {
                if ("0".equals(type)) {
                    recordDepIdMap.put(depId, nextDy.getLong("boid"));
                    continue;
                }
                if (recordId != null && recordId != 0L) {
                    recordDepIdMap.put(depId, recordId);
                    continue;
                }
                recordDepIdMap.put(depId, nextDy.getLong("id"));
            }
        }
    }

    private void handleAddDys(List<DynamicObject> addDys, Map<Long, Object> recordDepMap, Map<String, List<Long>> effectFileMap) {
        if (CollectionUtils.isEmpty(addDys)) {
            return;
        }
        List<Long> empIds = addDys.stream().map(dy -> dy.getLong("employee")).collect(Collectors.toList());
        List<Long> orgIds = addDys.stream().map(dy -> HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"org")).collect(Collectors.toList());
        Object[] dbDys = HRPIEmployeeRepository.getLabRelRecordByEmployeeIds(empIds, orgIds, Boolean.TRUE);
        Map<Object, Object> existEmpOrgMap = new HashMap(16);
        if (!HRArrayUtils.isEmpty((Object[])dbDys)) {
            existEmpOrgMap = Arrays.stream(dbDys).collect(Collectors.toMap(dy -> this.buildUniqueKey((DynamicObject)dy, "1"), dy -> dy.getLong("id"), (v1, v2) -> v1));
        }
        Iterator<DynamicObject> addRecordIte = addDys.iterator();
        while (addRecordIte.hasNext()) {
            DynamicObject nextDy = addRecordIte.next();
            String key = this.buildUniqueKey(nextDy, "0");
            Long recordId = (Long)existEmpOrgMap.get(key);
            if (recordId != null && recordId != 0L) {
                addRecordIte.remove();
                LOGGER.info("handLaborRelRecord ==> handleAddDysRemove{}", (Object)key);
            }
            if ("1".equals(nextDy.getString("businessstatus"))) {
                this.buildEmpIdAndLabRecordMap(recordDepMap, effectFileMap, nextDy, key, "1", recordId);
            }
            LOGGER.info("handLaborRelRecord {}==> manFile{}==> recordMap{}", new Object[]{key, effectFileMap, recordDepMap});
        }
    }

    private String buildUniqueKey(DynamicObject nextDy, String originId) {
        if ("0".equals(originId)) {
            return HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)nextDy, (String)"employee") + "-" + HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)nextDy, (String)"org");
        }
        if ("1".equals(originId)) {
            return nextDy.getLong("employee.id") + "-" + nextDy.getLong("org.id");
        }
        return null;
    }

    private Map<String, List<Long>> buildDepDy(List<DynamicObject> loseDys, String valueField) {
        Map<String, List<Long>> loseParamMap = new HashMap<String, List<Long>>(16);
        if (!CollectionUtils.isEmpty(loseDys)) {
            List<Long> depIds = loseDys.stream().map(dy -> dy.getLong(valueField)).collect(Collectors.toList());
            QFilter postTypeFlter = new QFilter("postype", "not in", Collections.singletonList(HRPIFieldConstants.PSOTYPR_VALUE));
            Object[] depEmpByDepEmpIds = HRPIDepempRepository.getDepEmpByDepEmpIds(depIds, postTypeFlter);
            Set<Object> depIdSet = new HashSet(16);
            if (!HRArrayUtils.isEmpty((Object[])depEmpByDepEmpIds)) {
                depIdSet = Arrays.stream(depEmpByDepEmpIds).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            }
            HashSet finalDepIdSet = depIdSet;
            loseParamMap = loseDys.stream().filter(dy -> finalDepIdSet.contains(dy.getLong(valueField))).collect(Collectors.toMap(dy -> this.buildUniqueKey((DynamicObject)dy, "1"), dy -> new ArrayList<Long>(Collections.singletonList(dy.getLong(valueField))), (a1, a2) -> {
                a1.addAll(a2);
                return a1;
            }));
        }
        return loseParamMap;
    }

    private static class Holder {
        static final HrpiLaborRelRecordGenericSaveRuleServiceImpl INSTANCE = new HrpiLaborRelRecordGenericSaveRuleServiceImpl();

        private Holder() {
        }
    }
}

