/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.rule;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.HrpiPersonGenericSaveRuleServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.PersonGenericSaveRuleNonTimeService;
import kd.hrmp.hrpi.business.infrastructure.utils.BusinessDataUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.PersonUserUtils;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.enums.BosGenderEnum;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericRelateDataEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;

public class HrpiPernontspropGenericSaveRuleServiceImpl
extends PersonGenericSaveRuleNonTimeService {
    private static final HRBaseServiceHelper PERNONTSPROP_SERVICEHELPER = new HRBaseServiceHelper("hrpi_pernontsprop");

    public static HrpiPernontspropGenericSaveRuleServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    protected void customRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        HashMap<Long, Object> personHeadsculptureMap = new HashMap<Long, Object>(16);
        for (DynamicObject dynamicObject : dyColl) {
            this.ageRuleExecute(dynamicObject);
            this.headsculptureRuleExecute(dynamicObject, personHeadsculptureMap);
        }
        HrpiPersonGenericSaveRuleServiceImpl hrpiPersonGenericSaveRuleService = HrpiPersonGenericSaveRuleServiceImpl.getInstance();
        PersonGenericRelateDataEntity headsculptureRelateDataEntity = hrpiPersonGenericSaveRuleService.headsculptureRelateRuleExecute(personGenericContext, personHeadsculptureMap);
        if (!headsculptureRelateDataEntity.isEmpty()) {
            ((PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity()).addRelateDataEntity(entityNumber, headsculptureRelateDataEntity);
        }
    }

    private void ageRuleExecute(DynamicObject dynamicObject) {
        Date birthday = dynamicObject.getDate("birthday");
        int age = BusinessDataUtil.getAge(birthday);
        dynamicObject.set("age", (Object)age);
    }

    private void headsculptureRuleExecute(DynamicObject dynamicObject, Map<Long, Object> personHeadsculptureMap) {
        String headsculpture = dynamicObject.getString("headsculpture");
        if (HRStringUtils.isEmpty((String)headsculpture)) {
            String name = dynamicObject.getString("name");
            headsculpture = PersonUserUtils.createAvatar(name, this.convertGender(dynamicObject));
            dynamicObject.set("headsculpture", (Object)headsculpture);
        }
        personHeadsculptureMap.put(HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"person"), headsculpture);
    }

    private int convertGender(DynamicObject dynamicObject) {
        long genderId = 0L;
        IDataEntityType dataEntityType = dynamicObject.getDataEntityType();
        if (Objects.nonNull(dataEntityType) && Objects.nonNull(dataEntityType.getProperties()) && dataEntityType.getProperties().containsKey((Object)"gender")) {
            genderId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"gender");
        }
        return BosGenderEnum.hRGenderConvert2BosGender((long)genderId);
    }

    protected PersonGenericRelateDataEntity servicelengthRelateRuleExecute(IPersonGenericContext<PersonGenericSaveEntity> personGenericContext, Map<Long, Object> personServiceLenMap) {
        return this.executeRelateDataEntity(personGenericContext, personServiceLenMap, "entservicelen");
    }

    public PersonGenericRelateDataEntity socialworkageRelateRuleExecute(IPersonGenericContext<PersonGenericSaveEntity> personGenericContext, Map<Long, Object> personSocialworkageMap) {
        return this.executeRelateDataEntity(personGenericContext, personSocialworkageMap, "servicelen");
    }

    public PersonGenericRelateDataEntity joinworktimeRelateRuleExecute(IPersonGenericContext<PersonGenericSaveEntity> personGenericContext, Map<Long, Object> personJoinworktimeMap) {
        return this.executeRelateDataEntity(personGenericContext, personJoinworktimeMap, "beginservicedate");
    }

    private PersonGenericRelateDataEntity executeRelateDataEntity(IPersonGenericContext<PersonGenericSaveEntity> personGenericContext, Map<Long, Object> personRelateMap, String relateField) {
        PersonGenericRelateDataEntity relateDataEntity = new PersonGenericRelateDataEntity("hrpi_pernontsprop");
        Set<Long> personIdSet = personRelateMap.keySet();
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection dyCollData = personGenericEntity.getHisDyns("hrpi_pernontsprop");
        if (!CollectionUtils.isEmpty((Collection)dyCollData)) {
            DynamicObjectCollection updateHisDyColl = this.updateRelateRuleExecute("hrpi_pernontsprop", personRelateMap, dyCollData, relateField, "person");
            relateDataEntity.setRelateHisDyMap(updateHisDyColl);
        }
        QFilter qFilter = new QFilter("person", "in", personIdSet).and(QFilterUtil.getDataStatusFilter()).and(QFilterUtil.getCurrentQf());
        DynamicObjectCollection updatePernontspropDyColl = PERNONTSPROP_SERVICEHELPER.queryOriginalCollection(String.format("id,person,%s", relateField), qFilter.toArray());
        if (!CollectionUtils.isEmpty((Collection)updatePernontspropDyColl)) {
            DynamicObjectCollection updateDyColl = this.updateRelateRuleExecute("hrpi_pernontsprop", personRelateMap, updatePernontspropDyColl, relateField, "person");
            relateDataEntity.setRelateDbDyMap(updateDyColl);
        }
        personGenericContext.addRedundancyField("hrpi_pernontsprop", relateField);
        return relateDataEntity;
    }

    private static class Holder {
        static final HrpiPernontspropGenericSaveRuleServiceImpl INSTANCE = new HrpiPernontspropGenericSaveRuleServiceImpl();

        private Holder() {
        }
    }
}

