/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.rule;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRPerserlenHelper;
import kd.hr.hbp.common.model.PerserModel;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.HrpiEmpentrelGenericSaveRuleServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.HrpiEmployeeGenericSaveRuleServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.HrpiPernontspropGenericSaveRuleServiceImpl;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.PersonGenericSaveRuleNonTimeService;
import kd.hrmp.hrpi.business.infrastructure.utils.BusinessDataUtil;
import kd.hrmp.hrpi.common.HRPIValueConstants;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericRelateDataEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;

public class HrpiPerserlenGenericSaveRuleServiceImpl
extends PersonGenericSaveRuleNonTimeService {
    public static HrpiPerserlenGenericSaveRuleServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    protected void customRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        PersonGenericRelateDataEntity joinworktimeRelateDataEntity;
        HashMap<Long, Object> personSocialworkageMap = new HashMap<Long, Object>(16);
        HashMap<Long, Object> personJoinworktimeMap = new HashMap<Long, Object>(16);
        HashSet<Long> employeeIdSet = new HashSet<Long>();
        for (DynamicObject dynamicObject : dyColl) {
            this.socialworkageRuleExecute(dynamicObject, personSocialworkageMap);
            this.personJoinworktimeRuleExecute(dynamicObject, personJoinworktimeMap);
            employeeIdSet.add(HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"employee"));
        }
        this.comsercountRuleExecute(dyColl, employeeIdSet, personGenericContext);
        HrpiPernontspropGenericSaveRuleServiceImpl hrpiPernontspropGenericRuleService = HrpiPernontspropGenericSaveRuleServiceImpl.getInstance();
        PersonGenericRelateDataEntity socialworkageRelateDataEntity = hrpiPernontspropGenericRuleService.socialworkageRelateRuleExecute(personGenericContext, personSocialworkageMap);
        if (!socialworkageRelateDataEntity.isEmpty()) {
            ((PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity()).addRelateDataEntity(entityNumber, socialworkageRelateDataEntity);
        }
        if (!(joinworktimeRelateDataEntity = hrpiPernontspropGenericRuleService.joinworktimeRelateRuleExecute(personGenericContext, personJoinworktimeMap)).isEmpty()) {
            ((PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity()).addRelateDataEntity(entityNumber, joinworktimeRelateDataEntity);
        }
    }

    private void socialworkageRuleExecute(DynamicObject dynamicObject, Map<Long, Object> personSocialworkageMap) {
        Date joinworktime = dynamicObject.getDate("joinworktime");
        BigDecimal adjustworktime = dynamicObject.getBigDecimal("adjustworktime");
        if (!HRObjectUtils.isEmpty((Object)joinworktime) && !HRObjectUtils.isEmpty((Object)adjustworktime)) {
            BigDecimal socialworkage = BusinessDataUtil.getWorkYear(joinworktime, adjustworktime);
            dynamicObject.set("socialworkage", (Object)HRPerserlenHelper.getSocialWorkage((DynamicObject)dynamicObject));
            dynamicObject.set("workyear", (Object)socialworkage);
            personSocialworkageMap.put(HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"person"), socialworkage);
        }
    }

    private void personJoinworktimeRuleExecute(DynamicObject dynamicObject, Map<Long, Object> personJoinworktimeMap) {
        Date joinworktime = dynamicObject.getDate("joinworktime");
        if (!HRObjectUtils.isEmpty((Object)joinworktime)) {
            personJoinworktimeMap.put(HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"person"), joinworktime);
        }
    }

    private void comsercountRuleExecute(DynamicObjectCollection dyColl, Set<Long> employeeIdSet, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        HrpiEmployeeGenericSaveRuleServiceImpl hrpiEmployeeGenericSaveRuleService = HrpiEmployeeGenericSaveRuleServiceImpl.getInstance();
        Map<Long, DynamicObject> employeeIdAndLaborrelStatusMap = hrpiEmployeeGenericSaveRuleService.getEmployeeMap(employeeIdSet, personGenericContext);
        HrpiEmpentrelGenericSaveRuleServiceImpl hrpiEmpentrelGenericSaveRuleService = HrpiEmpentrelGenericSaveRuleServiceImpl.getInstance();
        Map<Long, Long> laborrelStatusAndPrdMap = hrpiEmpentrelGenericSaveRuleService.getLaborrelStatusAndPrdMap();
        ArrayList<PerserModel> perserModelList = new ArrayList<PerserModel>();
        for (DynamicObject dynamicObject : dyColl) {
            long employeeId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"employee");
            DynamicObject employeeDy = employeeIdAndLaborrelStatusMap.get(employeeId);
            long personId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"person");
            Date enddate = new Date();
            if (!HRObjectUtils.isEmpty((Object)employeeDy)) {
                Long labrelstatusprdId = laborrelStatusAndPrdMap.get(HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)employeeDy, (String)"laborrelstatus"));
                enddate = HRPIValueConstants.LABRELSTATUSPRD_END.equals(labrelstatusprdId) ? employeeDy.getDate("enddate") : enddate;
            }
            Date firstjoincomdate = dynamicObject.getDate("firstjoincomdate");
            Date joincomdate = dynamicObject.getDate("joincomdate");
            BigDecimal adjustcomtime = dynamicObject.getBigDecimal("adjustcomtime");
            if (HRObjectUtils.isEmpty((Object)enddate) || HRObjectUtils.isEmpty((Object)joincomdate) || HRObjectUtils.isEmpty((Object)adjustcomtime)) continue;
            PerserModel perserModel = new PerserModel();
            DynamicObjectCollection hisDyns = ((PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity()).getHisDyns("hrpi_person");
            if (!CollectionUtils.isEmpty((Collection)hisDyns)) {
                Optional<DynamicObject> firstOp = hisDyns.stream().filter(dy -> dy.getLong("id") == personId).findFirst();
                if (firstOp.isPresent()) {
                    DynamicObject personDy = firstOp.get();
                    long pid = personDy.getLong("personindexid");
                    BigDecimal comsercount = HRPerserlenHelper.calcComsercountByPid((Date)joincomdate, (BigDecimal)adjustcomtime, (Long)pid, (Date)enddate);
                    dynamicObject.set("comsercount", (Object)comsercount);
                    continue;
                }
                perserModel.setPersonId(personId);
                perserModel.setAdjustTime(adjustcomtime);
                perserModel.setJoincomDate(joincomdate);
                perserModel.setUseDate(enddate);
                perserModelList.add(perserModel);
                perserModel.setEmployeeId(employeeId);
                continue;
            }
            perserModel.setPersonId(personId);
            perserModel.setAdjustTime(adjustcomtime);
            perserModel.setJoincomDate(joincomdate);
            perserModel.setUseDate(enddate);
            perserModelList.add(perserModel);
            perserModel.setEmployeeId(employeeId);
        }
        this.dealPerserComserCount(dyColl, perserModelList);
    }

    private void dealPerserComserCount(DynamicObjectCollection dyColl, List<PerserModel> perserModelList) {
        if (!CollectionUtils.isEmpty(perserModelList)) {
            HRPerserlenHelper.getBatchCalcComsercount(perserModelList);
            for (DynamicObject dynamicObject : dyColl) {
                long personId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"person");
                List list = perserModelList.stream().filter(perser -> perser.getPersonId() == personId).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(list)) continue;
                dynamicObject.set("comsercount", (Object)((PerserModel)list.get(0)).getComserCount());
            }
        }
    }

    private static class Holder {
        static final HrpiPerserlenGenericSaveRuleServiceImpl INSTANCE = new HrpiPerserlenGenericSaveRuleServiceImpl();

        private Holder() {
        }
    }
}

