/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.rule;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.PersonGenericSaveRuleTimeService;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericRelateDataEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;

public class HrpiPersonrolerelGenericSaveRuleServiceImpl
extends PersonGenericSaveRuleTimeService {
    private static final String POSITION_WORK_ROLE = "position.workrole.id";
    private static final String POSITION_ADMIN_ORG = "position.adminorg.id";
    private static final Log LOGGER = LogFactory.getLog(HrpiPersonrolerelGenericSaveRuleServiceImpl.class);
    public static final long DEFAULT_POSITION_ID = 1L;
    private static final HRBaseServiceHelper PERSONROLEREL_SERVICEHELPER = new HRBaseServiceHelper("hrpi_personrolerel");

    public static HrpiPersonrolerelGenericSaveRuleServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void initRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        LOGGER.info("PersonGenericService ==> HrpiPersonrolerelGenericSaveRuleServiceImpl#initRuleExecute {}", (Object)entityNumber);
        for (DynamicObject dynamicObject : dyColl) {
            this.initRole(dynamicObject);
        }
    }

    private void initRole(DynamicObject dynamicObject) {
        long roleId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"role");
        if (roleId == 0L) {
            dynamicObject.set("role", (Object)1L);
        }
    }

    public PersonGenericRelateDataEntity roleRelateRuleExecute(IPersonGenericContext<PersonGenericSaveEntity> personGenericContext, Map<Long, Object> depempAndRoleMap) {
        QFilter qFilter;
        DynamicObjectCollection updatePernontspropDyColl;
        PersonGenericRelateDataEntity relateDataEntity = new PersonGenericRelateDataEntity("hrpi_personrolerel");
        Set<Long> depempIdSet = depempAndRoleMap.keySet();
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection dyCollData = personGenericEntity.getHisDyns("hrpi_personrolerel");
        if (!CollectionUtils.isEmpty((Collection)dyCollData)) {
            DynamicObjectCollection updateHisDyColl = this.updateRelateRuleExecute("hrpi_personrolerel", depempAndRoleMap, dyCollData, "role", "depemp");
            relateDataEntity.setRelateHisDyMap(updateHisDyColl);
        }
        if (!CollectionUtils.isEmpty((Collection)(updatePernontspropDyColl = PERSONROLEREL_SERVICEHELPER.queryOriginalCollection("id,depemp,role", (qFilter = new QFilter("depemp", "in", depempIdSet).and(QFilterUtil.getDataStatusFilter()).and(QFilterUtil.getCurrentQf())).toArray())))) {
            DynamicObjectCollection updateDyColl = this.updateRelateRuleExecute("hrpi_personrolerel", depempAndRoleMap, updatePernontspropDyColl, "role", "depemp");
            relateDataEntity.setRelateDbDyMap(updateDyColl);
        }
        personGenericContext.addRedundancyField("hrpi_personrolerel", "role");
        return relateDataEntity;
    }

    public DynamicObjectCollection buildWorkRoleCol(List<DynamicObject> dyCol) {
        if (CollectionUtils.isEmpty(dyCol)) {
            return null;
        }
        MainEntityType workRoleType = EntityMetadataCache.getDataEntityType((String)"hrpi_personrolerel");
        DynamicObjectCollection workRoleCollection = new DynamicObjectCollection((DynamicObjectType)workRoleType, null);
        long[] workRoleIds = ORM.create().genLongIds((IDataEntityType)workRoleType, dyCol.size());
        HashSet depEmpIdSet = Sets.newHashSetWithExpectedSize((int)dyCol.size());
        HashSet positionIdSet = Sets.newHashSetWithExpectedSize((int)dyCol.size());
        Object positionObj = dyCol.get(0).get("position");
        boolean adminOrgFlag = false;
        boolean workRoleFlag = false;
        if (positionObj instanceof DynamicObject) {
            DynamicObjectType positionType = ((DynamicObject)positionObj).getDynamicObjectType();
            adminOrgFlag = positionType.getProperty("adminorg") != null;
            workRoleFlag = positionType.getProperty("workrole") != null;
        }
        for (DynamicObject dy : dyCol) {
            long positionId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"position");
            if (dy.getLong("boid") != 0L) {
                depEmpIdSet.add(HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)"depemp"));
            }
            if (positionId == 0L) continue;
            if (!adminOrgFlag || !workRoleFlag) {
                positionIdSet.add(positionId);
                continue;
            }
            if (dy.getLong(POSITION_ADMIN_ORG) != 0L && dy.getLong(POSITION_WORK_ROLE) != 0L) continue;
            positionIdSet.add(positionId);
        }
        Map<Long, Long> deEmpBoIdMap = this.getEmpBoIdMap(depEmpIdSet);
        Map<Long, Map<String, Object>> posMap = this.getPositionInfo(Lists.newArrayList((Iterable)positionIdSet));
        for (int index = 0; index < dyCol.size(); ++index) {
            DynamicObject empExp = dyCol.get(index);
            LOGGER.info("dy==> create role, boid : {}, businessstatus:{}", (Object)empExp.getLong("boid"), (Object)empExp.getString("businessstatus"));
            DynamicObject workRole = this.buildWorkRole((DynamicObjectType)workRoleType, workRoleIds[index], empExp, posMap);
            workRole.set("boid", (Object)deEmpBoIdMap.get(HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)workRole, (String)"depemp")));
            workRoleCollection.add((Object)workRole);
        }
        return workRoleCollection;
    }

    private Map<Long, Map<String, Object>> getPositionInfo(List<Long> positionIdList) {
        if (CollectionUtils.isEmpty(positionIdList)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap posMap = Maps.newHashMapWithExpectedSize((int)positionIdList.size());
        Map jobInfo = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IPositionService", (String)"queryPosition", (Object[])new Object[]{positionIdList});
        if (!Integer.valueOf("200").equals(jobInfo.get("code"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u201cIPositionService.queryPosition\u201d\u5f02\u5e38\u3002", (String)"HRPICommonDepInitService_8", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        List jobs = (List)jobInfo.get("data");
        jobs.forEach(item -> posMap.put((Long)item.get("id"), item));
        return posMap;
    }

    private Map<Long, Long> getEmpBoIdMap(Set<Long> depEmpIdSet) {
        if (CollectionUtils.isEmpty(depEmpIdSet)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap deEmpBoIdMap = Maps.newHashMapWithExpectedSize((int)depEmpIdSet.size());
        QFilter[] qFilters = new QFilter[]{new QFilter("depemp", "in", depEmpIdSet), QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getInitStatusFinish()};
        DynamicObjectCollection dbWorkRoleCol = PERSONROLEREL_SERVICEHELPER.queryOriginalCollection("boid,depemp", qFilters);
        dbWorkRoleCol.forEach(workRoleDy -> deEmpBoIdMap.put(workRoleDy.getLong("depemp"), workRoleDy.getLong("boid")));
        return deEmpBoIdMap;
    }

    private DynamicObject buildWorkRole(DynamicObjectType type, Long id, DynamicObject empExp, Map<Long, Map<String, Object>> posMap) {
        Object adminOrgId;
        Object workRoleId;
        DynamicObject dy = (DynamicObject)type.createInstance();
        DynamicTransformUtil.wrapSameFieldFromSource(dy, empExp, Sets.newHashSet((Object[])new String[]{"id", "multilanguagetext", "description", "boid", "iscurrentversion", "datastatus", "sourcevid", "ismodify", "hisversion", "changedescription"}));
        dy.set("id", (Object)id);
        long positionId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)empExp, (String)"position");
        if (positionId == 0L) {
            return dy;
        }
        Map<String, Object> map = posMap.get(positionId);
        if (map != null) {
            workRoleId = map.get("workrole");
            adminOrgId = map.get("adminorg");
        } else {
            workRoleId = empExp.getLong(POSITION_WORK_ROLE);
            adminOrgId = empExp.getLong(POSITION_ADMIN_ORG);
        }
        dy.set("role", workRoleId);
        dy.set("role_id", workRoleId);
        dy.set("adminorg", adminOrgId);
        dy.set("adminorg_id", adminOrgId);
        return dy;
    }

    private static class Holder {
        static final HrpiPersonrolerelGenericSaveRuleServiceImpl INSTANCE = new HrpiPersonrolerelGenericSaveRuleServiceImpl();

        private Holder() {
        }
    }
}

