/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.rule;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.AbstractPersonGenericSaveRuleService;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.util.EmpnumberLinkedBuilder;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericRelateDataEntity;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.generic.entity.reentry.EmpnumberAndStartDateEntity;

public class HrpiReentryrelateGenericSaveRuleService
extends AbstractPersonGenericSaveRuleService {
    private static final Log LOGGER = LogFactory.getLog(AbstractPersonGenericSaveRuleService.class);

    public static HrpiReentryrelateGenericSaveRuleService getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void initData(String entityNumber, IPersonGenericContext<?> personGenericContext) {
        LOGGER.debug("PersonGenericService ==> HrpiReentryrelateGenericSaveRuleService#initData {}", (Object)entityNumber);
    }

    @Override
    public void initRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        LOGGER.debug("PersonGenericService ==> HrpiReentryrelateGenericSaveRuleService#initRuleExecute {}", (Object)entityNumber);
    }

    @Override
    public void filterRuleExecute(String entityNumber, IPersonGenericContext<?> personGenericContext) {
        LOGGER.info("PersonGenericService ==> HrpiReentryrelateGenericSaveRuleService#filterRuleExecute {}", (Object)entityNumber);
        Set errorIds = personGenericContext.getErrorIds(entityNumber);
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection dyColl = personGenericEntity.getHisDyns(entityNumber);
        dyColl.removeIf(dy -> errorIds.contains(EmpnumberAndStartDateEntity.getKey((DynamicObject)dy)));
    }

    @Override
    protected void customRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        LOGGER.debug("PersonGenericService ==> HrpiReentryrelateGenericSaveRuleService#customRuleExecute {}", (Object)entityNumber);
        EmpnumberLinkedBuilder empnumberLinkedBuilder = (EmpnumberLinkedBuilder)personGenericContext.getCustomerParam("empnumberLinkedBuilder");
        Set<EmpnumberAndStartDateEntity> earlyEmpnumberList = empnumberLinkedBuilder.getEarlyEmpnumberSet();
        HashMap<String, Long> empnumberPidMap = new HashMap<String, Long>(16);
        HashMap<String, Long> empnumberMidMap = new HashMap<String, Long>(16);
        this.queryEmpnumberPidAndMidMap(earlyEmpnumberList, empnumberLinkedBuilder, empnumberPidMap, empnumberMidMap);
        Set<EmpnumberAndStartDateEntity> empnumberSet = empnumberLinkedBuilder.getAllEmpnumberSet();
        Map<EmpnumberAndStartDateEntity, Long> empnumberEmployeeidMap = this.queryEmpnumberEmployeeidMap(empnumberSet);
        Map<EmpnumberAndStartDateEntity, EmpnumberAndStartDateEntity> empnumberRelateMap = empnumberLinkedBuilder.getEmpnumberRelateMap();
        Map<EmpnumberAndStartDateEntity, DynamicObject> empnumberDyMap = dyColl.stream().collect(Collectors.toMap(EmpnumberAndStartDateEntity::buildEmp, dy -> dy));
        PersonGenericRelateDataEntity personRelateDataEntity = this.fillUpdatePersonRelateDataEntity(empnumberSet, empnumberPidMap);
        PersonGenericRelateDataEntity employeeRelateDataEntity = this.fillUpdateEmployeeRelateDataEntity(empnumberSet, empnumberMidMap, empnumberRelateMap);
        PersonGenericRelateDataEntity empentrelRelateDataEntity = this.fillUpdateEmpentrelRelateDataEntity(empnumberSet, empnumberDyMap, empnumberRelateMap, empnumberEmployeeidMap);
        PersonGenericRelateDataEntity empnonentrelRelateDataEntity = this.fillUpdateEmpnonentrelRelateDataEntity(empnumberSet, empnumberDyMap, empnumberRelateMap, empnumberEmployeeidMap);
        ((PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity()).addRelateDataEntity(entityNumber, personRelateDataEntity);
        ((PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity()).addRelateDataEntity(entityNumber, employeeRelateDataEntity);
        ((PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity()).addRelateDataEntity(entityNumber, empentrelRelateDataEntity);
        ((PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity()).addRelateDataEntity(entityNumber, empnonentrelRelateDataEntity);
    }

    private PersonGenericRelateDataEntity fillUpdatePersonRelateDataEntity(Set<EmpnumberAndStartDateEntity> empnumberSet, Map<String, Long> empnumberPidMap) {
        QFilter empQfilter = EmpnumberAndStartDateEntity.getEmpQfilter(empnumberSet);
        DynamicObject[] employeeDyArr = this.getHRBaseServiceHelper("hrpi_employee").query("id,empnumber,person", new QFilter[]{empQfilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getStatusFilters()});
        Set personIdSet = Arrays.stream(employeeDyArr).map(employeeDy -> employeeDy.getLong("person.id")).collect(Collectors.toSet());
        DynamicObject[] personDyArr = this.getHRBaseServiceHelper("hrpi_person").query("id,number,personindexid", new QFilter[]{new QFilter("boid", "in", personIdSet), QFilterUtil.getDataStatusFilter()});
        Map<String, List<DynamicObject>> updatePersonDyListMap = Arrays.stream(personDyArr).collect(Collectors.groupingBy(personDy -> personDy.getString("number")));
        for (Map.Entry<String, List<DynamicObject>> entry : updatePersonDyListMap.entrySet()) {
            String empnumber = entry.getKey();
            List<DynamicObject> dbDyList = entry.getValue();
            Long pid = empnumberPidMap.get(empnumber);
            for (DynamicObject dbDy : dbDyList) {
                dbDy.set("personindexid", (Object)pid);
            }
        }
        DynamicObjectCollection updateDyColl = new DynamicObjectCollection();
        updateDyColl.addAll((Collection)updatePersonDyListMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        PersonGenericRelateDataEntity relateDataEntity = new PersonGenericRelateDataEntity("hrpi_person");
        relateDataEntity.setRelateDbDyMap(updateDyColl);
        return relateDataEntity;
    }

    private PersonGenericRelateDataEntity fillUpdateEmployeeRelateDataEntity(Set<EmpnumberAndStartDateEntity> empnumberSet, Map<String, Long> empnumberMidMap, Map<EmpnumberAndStartDateEntity, EmpnumberAndStartDateEntity> empnumberRelateMap) {
        QFilter empQfilter = EmpnumberAndStartDateEntity.getEmpQfilter(empnumberSet);
        DynamicObject[] employeeDyArr = this.getHRBaseServiceHelper("hrpi_employee").query("id,person.id,empnumber,mid,startdate,islatestrecord", new QFilter[]{empQfilter, QFilterUtil.getDataStatusFilter()});
        Map<String, List<DynamicObject>> updateEmployeeDyListMap = Arrays.stream(employeeDyArr).collect(Collectors.groupingBy(employeeDy -> employeeDy.getString("empnumber")));
        Map<EmpnumberAndStartDateEntity, List<DynamicObject>> updEmpLastrecordDyListMap = Arrays.stream(employeeDyArr).collect(Collectors.groupingBy(EmpnumberAndStartDateEntity::buildEmp));
        for (Map.Entry<String, List<DynamicObject>> entry : updateEmployeeDyListMap.entrySet()) {
            String empnumber = entry.getKey();
            List<DynamicObject> dbDyList = entry.getValue();
            Long mid = empnumberMidMap.get(empnumber);
            for (DynamicObject dbDy : dbDyList) {
                dbDy.set("mid", (Object)mid);
            }
        }
        for (Map.Entry<String, List<DynamicObject>> entry : updEmpLastrecordDyListMap.entrySet()) {
            EmpnumberAndStartDateEntity oldnumEntity;
            EmpnumberAndStartDateEntity empnumberEntity = (EmpnumberAndStartDateEntity)entry.getKey();
            List<DynamicObject> newNumEntity = entry.getValue();
            if (CollectionUtils.isEmpty(newNumEntity)) continue;
            DynamicObject empDy = newNumEntity.get(0);
            long personId = 0L;
            if (empDy != null) {
                personId = empDy.getLong("person.id");
            }
            if ((oldnumEntity = empnumberRelateMap.get(empnumberEntity)) == null) continue;
            List<DynamicObject> oldEntitys = updEmpLastrecordDyListMap.get(oldnumEntity);
            for (DynamicObject dbDy : oldEntitys) {
                if (personId == 0L || personId != dbDy.getLong("person.id")) continue;
                dbDy.set("islatestrecord", (Object)"0");
            }
        }
        DynamicObjectCollection updateDyColl = new DynamicObjectCollection();
        updateDyColl.addAll((Collection)updateEmployeeDyListMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        PersonGenericRelateDataEntity personGenericRelateDataEntity = new PersonGenericRelateDataEntity("hrpi_employee");
        personGenericRelateDataEntity.setRelateDbDyMap(updateDyColl);
        return personGenericRelateDataEntity;
    }

    private PersonGenericRelateDataEntity fillUpdateEmpentrelRelateDataEntity(Set<EmpnumberAndStartDateEntity> empnumberSet, Map<EmpnumberAndStartDateEntity, DynamicObject> empnumberDyMap, Map<EmpnumberAndStartDateEntity, EmpnumberAndStartDateEntity> empnumberRelateMap, Map<EmpnumberAndStartDateEntity, Long> empnumberEmployeeidMap) {
        EmpnumberAndStartDateEntity empnumberEntity;
        QFilter empQfilter = EmpnumberAndStartDateEntity.getEmpQfilter(empnumberSet);
        DynamicObject[] empentrelDyArr = this.getHRBaseServiceHelper("hrpi_empentrel").query("id,person.id,empnumber,startdate,oldempnumber,serviceagescheme,inheritnumber,preemployee,islatestrecord", new QFilter[]{empQfilter, QFilterUtil.getDataStatusFilter()});
        Map<EmpnumberAndStartDateEntity, List<DynamicObject>> updateEmpentrelDyListMap = Arrays.stream(empentrelDyArr).collect(Collectors.groupingBy(EmpnumberAndStartDateEntity::buildEmp));
        for (Map.Entry<EmpnumberAndStartDateEntity, List<DynamicObject>> entry : updateEmpentrelDyListMap.entrySet()) {
            empnumberEntity = entry.getKey();
            List<DynamicObject> dbDyList = entry.getValue();
            DynamicObject dy = empnumberDyMap.get(empnumberEntity);
            for (DynamicObject dbDy : dbDyList) {
                EmpnumberAndStartDateEntity oldempnumberEntity;
                if (dy != null) {
                    dbDy.set("oldempnumber", (Object)dy.getString("oldempnumber"));
                    dbDy.set("serviceagescheme", (Object)dy.getString("serviceagescheme"));
                    dbDy.set("inheritnumber", (Object)dy.getString("inheritnumber"));
                    oldempnumberEntity = EmpnumberAndStartDateEntity.buildOldEmp((DynamicObject)dy);
                } else {
                    oldempnumberEntity = empnumberRelateMap.get(empnumberEntity);
                }
                Long preemployeeId = empnumberEmployeeidMap.get(oldempnumberEntity);
                if (preemployeeId == null) {
                    LOGGER.debug("PersonGenericService ==> HrpiReentryrelateGenericSaveRuleService#fillUpdateEmpentrelRelateDataEntity preemployeeId is null. oldempnumber: {}", (Object)oldempnumberEntity);
                    continue;
                }
                dbDy.set("preemployee", (Object)preemployeeId);
            }
        }
        for (Map.Entry<EmpnumberAndStartDateEntity, List<DynamicObject>> entry : updateEmpentrelDyListMap.entrySet()) {
            EmpnumberAndStartDateEntity oldnumEntity;
            empnumberEntity = entry.getKey();
            List<DynamicObject> newNumEntity = entry.getValue();
            if (CollectionUtils.isEmpty(newNumEntity)) continue;
            DynamicObject empDy = newNumEntity.get(0);
            long personId = 0L;
            if (empDy != null) {
                personId = empDy.getLong("person.id");
            }
            if ((oldnumEntity = empnumberRelateMap.get(empnumberEntity)) == null) continue;
            List<DynamicObject> oldEntitys = updateEmpentrelDyListMap.get(oldnumEntity);
            for (DynamicObject dbDy : oldEntitys) {
                if (personId == 0L || personId != dbDy.getLong("person.id")) continue;
                dbDy.set("islatestrecord", (Object)"0");
            }
        }
        DynamicObjectCollection updateDyColl = new DynamicObjectCollection();
        updateDyColl.addAll((Collection)updateEmpentrelDyListMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        PersonGenericRelateDataEntity relateDataEntity = new PersonGenericRelateDataEntity("hrpi_empentrel");
        relateDataEntity.setRelateDbDyMap(updateDyColl);
        return relateDataEntity;
    }

    private PersonGenericRelateDataEntity fillUpdateEmpnonentrelRelateDataEntity(Set<EmpnumberAndStartDateEntity> empnumberSet, Map<EmpnumberAndStartDateEntity, DynamicObject> empnumberDyMap, Map<EmpnumberAndStartDateEntity, EmpnumberAndStartDateEntity> empnumberRelateMap, Map<EmpnumberAndStartDateEntity, Long> empnumberEmployeeidMap) {
        DynamicObject[] empnonentrelDyArr = this.getHRBaseServiceHelper("hrpi_empnonentrel").query("id,employee,empnumber,preemployee", new QFilter[]{new QFilter("empnumber", "in", empnumberSet.stream().map(EmpnumberAndStartDateEntity::getEmpnumber).collect(Collectors.toSet())), QFilterUtil.getDataStatusFilter()});
        Map<Long, List<DynamicObject>> updateEmpnonentrelDyListMap = Arrays.stream(empnonentrelDyArr).collect(Collectors.groupingBy(empnonentrelDy -> empnonentrelDy.getLong("employee.id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : updateEmpnonentrelDyListMap.entrySet()) {
            Long employeeId = entry.getKey();
            List<DynamicObject> dbDyList = entry.getValue();
            EmpnumberAndStartDateEntity empnumberEntity = this.getPersonGenericRelateDataEntityByEmployeeId(empnumberEmployeeidMap, employeeId);
            DynamicObject dy = empnumberDyMap.get(empnumberEntity);
            for (DynamicObject dbDy : dbDyList) {
                EmpnumberAndStartDateEntity oldempnumberEntity = dy != null ? EmpnumberAndStartDateEntity.buildOldEmp((DynamicObject)dy) : empnumberRelateMap.get(empnumberEntity);
                Long preemployeeId = empnumberEmployeeidMap.get(oldempnumberEntity);
                if (preemployeeId == null) {
                    LOGGER.debug("PersonGenericService ==> HrpiReentryrelateGenericSaveRuleService#fillUpdateEmpnonentrelRelateDataEntity preemployeeId is null. oldempnumber: {}", (Object)oldempnumberEntity);
                    continue;
                }
                dbDy.set("preemployee", (Object)preemployeeId);
            }
        }
        DynamicObjectCollection updateDyColl = new DynamicObjectCollection();
        updateDyColl.addAll((Collection)updateEmpnonentrelDyListMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        PersonGenericRelateDataEntity relateDataEntity = new PersonGenericRelateDataEntity("hrpi_empnonentrel");
        relateDataEntity.setRelateDbDyMap(updateDyColl);
        return relateDataEntity;
    }

    private EmpnumberAndStartDateEntity getPersonGenericRelateDataEntityByEmployeeId(Map<EmpnumberAndStartDateEntity, Long> empnumberEmployeeidMap, Long employeeId) {
        for (Map.Entry<EmpnumberAndStartDateEntity, Long> dateEntry : empnumberEmployeeidMap.entrySet()) {
            if (!dateEntry.getValue().equals(employeeId)) continue;
            return dateEntry.getKey();
        }
        return null;
    }

    private void queryEmpnumberPidAndMidMap(Set<EmpnumberAndStartDateEntity> earlyEmpnumberList, EmpnumberLinkedBuilder empnumberLinkedBuilder, Map<String, Long> empnumberPidMap, Map<String, Long> empnumberMidMap) {
        QFilter empQfilter = EmpnumberAndStartDateEntity.getEmpQfilter(earlyEmpnumberList);
        DynamicObject[] employeeDyArr = this.getHRBaseServiceHelper("hrpi_employee").query("empnumber,boid,person", new QFilter[]{empQfilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getStatusFilters()});
        Arrays.stream(employeeDyArr).forEach(employeeDy -> {
            long personid = employeeDy.getLong("person.id");
            long boid = employeeDy.getLong("boid");
            List<EmpnumberAndStartDateEntity> empnumberLinked = empnumberLinkedBuilder.getEmpnumberLinked(employeeDy.getString("empnumber"));
            for (EmpnumberAndStartDateEntity empnumberEntity : empnumberLinked) {
                empnumberPidMap.putIfAbsent(empnumberEntity.getEmpnumber(), personid);
                empnumberMidMap.putIfAbsent(empnumberEntity.getEmpnumber(), boid);
            }
        });
    }

    private Map<EmpnumberAndStartDateEntity, Long> queryEmpnumberEmployeeidMap(Set<EmpnumberAndStartDateEntity> empnumberSet) {
        QFilter empQfilter = EmpnumberAndStartDateEntity.getEmpQfilter(empnumberSet);
        DynamicObject[] employeeDyArr = this.getHRBaseServiceHelper("hrpi_employee").query("empnumber,oldempnumber,startdate,id", new QFilter[]{empQfilter, QFilterUtil.getCurrentQf(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getStatusFilters()});
        return Arrays.stream(employeeDyArr).collect(Collectors.toMap(EmpnumberAndStartDateEntity::buildEmp, employeeDy -> employeeDy.getLong("id"), (k1, k2) -> k1));
    }

    @Override
    protected void commonRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        LOGGER.debug("PersonGenericService ==> HrpiReentryrelateGenericSaveRuleService#commonRuleExecute {}", (Object)entityNumber);
    }

    @Override
    protected void specialExceptionRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        LOGGER.debug("PersonGenericService ==> HrpiReentryrelateGenericSaveRuleService#specialExceptionRuleExecute {}", (Object)entityNumber);
    }

    @Override
    protected void afterRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        LOGGER.debug("PersonGenericService ==> HrpiReentryrelateGenericSaveRuleService#afterRuleExecute {}", (Object)entityNumber);
    }

    @Override
    protected void afterRollbackRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        LOGGER.debug("PersonGenericService ==> HrpiReentryrelateGenericSaveRuleService#afterRollbackRuleExecute {}", (Object)entityNumber);
    }

    private static class Holder {
        static final HrpiReentryrelateGenericSaveRuleService INSTANCE = new HrpiReentryrelateGenericSaveRuleService();

        private Holder() {
        }
    }
}

