/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.rule;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.PersonGenericSaveRuleTimeService;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericRedundancyRelate;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;
import kd.hrmp.hrpi.common.util.PersonGenericRedundancyUtil;

public class HspmErmanfileGenericSaveRuleServiceImpl
extends PersonGenericSaveRuleTimeService {
    private static final HRBaseServiceHelper ERMANFILE_SERVICEHELPER = new HRBaseServiceHelper("hspm_ermanfile");

    public static HspmErmanfileGenericSaveRuleServiceImpl getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    protected void customRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        String caller = ((PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity()).getCaller();
        this.setRelateId(dyColl, personGenericContext);
        HashSet sets = Sets.newHashSet((Object[])new String[]{"number", "name"});
        List<PersonGenericRedundancyRelate> redundancyRelates = PersonGenericRedundancyUtil.getRedundancyRelateMap((String)entityNumber).stream().filter(relate -> sets.contains(relate.getRedundancyField())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(redundancyRelates)) {
            this.commonSetRedundancyRuleExecute(entityNumber, dyColl, redundancyRelates, personGenericContext);
        }
    }

    private void setRelateId(DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        HashMap<Long, DynamicObject> dyCollMap = new HashMap<Long, DynamicObject>(dyColl.size());
        HashMap<Long, List<Long>> personIdListMap = new HashMap<Long, List<Long>>(dyColl.size());
        HashMap<Long, List<Long>> employeeListMap = new HashMap<Long, List<Long>>(dyColl.size());
        HashMap<Long, List<Long>> depempListMap = new HashMap<Long, List<Long>>(dyColl.size());
        for (DynamicObject dynamicObject : dyColl) {
            long id = dynamicObject.getLong("id");
            long personId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"person");
            long employeeId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"employee");
            long depempId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"depemp");
            dyCollMap.put(id, dynamicObject);
            long empentrelId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"empentrel");
            long empposrelId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dynamicObject, (String)"empposrel");
            this.putIdListMap(personId, id, personIdListMap);
            if (empentrelId == 0L) {
                this.putIdListMap(employeeId, id, employeeListMap);
            }
            if (empposrelId != 0L) continue;
            this.putIdListMap(depempId, id, depempListMap);
        }
        if (!personIdListMap.isEmpty()) {
            this.setRelateIdValue(personGenericContext, dyCollMap, personIdListMap, "hrpi_pernontsprop", "id,person", "person", "pernontsprop");
        }
        if (!employeeListMap.isEmpty()) {
            this.setRelateIdValue(personGenericContext, dyCollMap, employeeListMap, "hrpi_empentrel", "id,employee", "employee", "empentrel");
        }
        if (!depempListMap.isEmpty()) {
            this.setRelateIdValue(personGenericContext, dyCollMap, depempListMap, "hrpi_empposorgrel", "id,depemp", "depemp", "empposrel");
        }
    }

    private void setRelateIdValue(IPersonGenericContext<PersonGenericSaveEntity> personGenericContext, Map<Long, DynamicObject> dyCollMap, Map<Long, List<Long>> idListMap, String entityNumber, String selectProperties, String keyName, String relateField) {
        PersonGenericSaveEntity personGenericEntity = (PersonGenericSaveEntity)personGenericContext.getPersonGenericEntity();
        DynamicObjectCollection dyCollData = personGenericEntity.getHisDyns(entityNumber);
        if (!CollectionUtils.isEmpty((Collection)dyCollData)) {
            this.updateRelateIdValue(dyCollMap, idListMap, keyName, relateField, (Collection<DynamicObject>)dyCollData);
            return;
        }
        Map dbDyMap = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter(keyName, "in", idListMap.keySet()), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf()});
        if (!CollectionUtils.isEmpty((Map)dbDyMap)) {
            this.updateRelateIdValue(dyCollMap, idListMap, keyName, relateField, dbDyMap.values());
        }
    }

    private void updateRelateIdValue(Map<Long, DynamicObject> dyCollMap, Map<Long, List<Long>> idListMap, String keyName, String relateField, Collection<DynamicObject> relateDyCollData) {
        for (DynamicObject dy : relateDyCollData) {
            long id = dy.getLong("id");
            long keyId = HRPIDynamicObjectUtil.getBasicDataValue((DynamicObject)dy, (String)keyName);
            List<Long> ermanfileIdList = idListMap.get(keyId);
            if (CollectionUtils.isEmpty(ermanfileIdList)) continue;
            for (Long ermanfileId : ermanfileIdList) {
                DynamicObject ermanfileDy = dyCollMap.get(ermanfileId);
                ermanfileDy.set(relateField, (Object)id);
                ermanfileDy.set(relateField + "_id", (Object)id);
            }
        }
    }

    private void putIdListMap(long keyId, long valueId, Map<Long, List<Long>> idListMap) {
        List<Long> valueIdList = idListMap.get(keyId);
        if (valueIdList == null) {
            valueIdList = new ArrayList<Long>();
            valueIdList.add(valueId);
            idListMap.put(keyId, valueIdList);
        } else {
            valueIdList.add(valueId);
        }
    }

    private static class Holder {
        static final HspmErmanfileGenericSaveRuleServiceImpl INSTANCE = new HspmErmanfileGenericSaveRuleServiceImpl();

        private Holder() {
        }
    }
}

