/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.domian.service.impl.generic.rule;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hrpi.business.domian.service.impl.generic.rule.AbstractPersonGenericSaveRuleService;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.generic.context.IPersonGenericContext;
import kd.hrmp.hrpi.common.generic.entity.PersonGenericSaveEntity;
import kd.hrmp.hrpi.common.util.HRPIDynamicObjectUtil;
import kd.hrmp.hrpi.common.util.PersonGenericUtil;

public class PersonGenericSaveRuleTimeService
extends AbstractPersonGenericSaveRuleService {
    private static final Log LOGGER = LogFactory.getLog(AbstractPersonGenericSaveRuleService.class);

    public static PersonGenericSaveRuleTimeService getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void initData(String entityNumber, IPersonGenericContext<?> personGenericContext) {
        LOGGER.debug("PersonGenericService ==> PersonGenericRuleTimeService#initData {}", (Object)entityNumber);
    }

    @Override
    public void initRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        LOGGER.debug("PersonGenericService ==> PersonGenericSaveRuleTimeService#initRuleExecute {}", (Object)entityNumber);
    }

    @Override
    protected void commonRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        super.commonRuleExecute(entityNumber, dyColl, personGenericContext);
        this.bsledRuleExecute(entityNumber, dyColl);
    }

    private void bsledRuleExecute(String entityNumber, DynamicObjectCollection dyColl) {
        HashMap<Long, DynamicObject> editDyMap = new HashMap<Long, DynamicObject>(16);
        DataEntityPropertyCollection properties = HRPIDynamicObjectUtil.getProperties((DynamicObjectCollection)dyColl);
        for (DynamicObject dynamicObject : dyColl) {
            long boid = dynamicObject.getLong("boid");
            if (boid == 0L) {
                dynamicObject.set("bsled", (Object)HRDateTimeUtils.getSysMaxDate());
                if (!properties.containsKey((Object)"startdate") || null != dynamicObject.get("bsed")) continue;
                dynamicObject.set("bsed", dynamicObject.get("startdate"));
                continue;
            }
            Date bsled = dynamicObject.getDate("bsled");
            if (!HRObjectUtils.isEmpty((Object)bsled)) continue;
            editDyMap.put(boid, dynamicObject);
        }
        if (!editDyMap.isEmpty()) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
            QFilter qFilter = new QFilter("boid", "in", editDyMap.keySet());
            qFilter.and(QFilterUtil.getDataStatusFilter()).and(QFilterUtil.getCurrentQf());
            DynamicObject[] nowDyArr = serviceHelper.query("boid,bsled", qFilter.toArray());
            if (nowDyArr != null && nowDyArr.length > 0) {
                Arrays.stream(nowDyArr).forEach(nowDy -> {
                    DynamicObject dynamicObject = (DynamicObject)editDyMap.get(nowDy.getLong("boid"));
                    dynamicObject.set("bsled", (Object)nowDy.getDate("bsled"));
                });
            }
        }
        dyColl.stream().filter(dy -> null != dy.get("bsed")).forEach(dy -> {
            try {
                Date bsed = PersonGenericUtil.getMidnight((Date)dy.getDate("bsed"));
                if (null != bsed) {
                    dy.set("bsed", (Object)bsed);
                }
            }
            catch (Exception ex) {
                LOGGER.error("PersonGenericSaveRuleTimeService#bsledRuleExecute convert bsed error, exception is", (Throwable)ex);
            }
        });
    }

    @Override
    protected void customRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        LOGGER.debug("PersonGenericService ==> PersonGenericRuleTimeService#customRuleExecute {}", (Object)entityNumber);
    }

    @Override
    protected void specialExceptionRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        LOGGER.debug("PersonGenericService ==> PersonGenericRuleTimeService#specialExceptionRuleExecute {}", (Object)entityNumber);
    }

    @Override
    protected void afterRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        LOGGER.debug("PersonGenericService ==> PersonGenericRuleTimeService#afterRuleExecute {}", (Object)entityNumber);
    }

    @Override
    protected void afterRollbackRuleExecute(String entityNumber, DynamicObjectCollection dyColl, IPersonGenericContext<PersonGenericSaveEntity> personGenericContext) {
        LOGGER.debug("PersonGenericService ==> PersonGenericRuleTimeService#afterRollbackRuleExecute {}", (Object)entityNumber);
    }

    private static class Holder {
        static final PersonGenericSaveRuleTimeService INSTANCE = new PersonGenericSaveRuleTimeService();

        private Holder() {
        }
    }
}

